/*
 * Decompiled with CFR 0.152.
 */
package executables;

import dashboard.ControlPanel;
import dashboard.Output;
import executables.ResolutionVariants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utility.Kit;
import utility.XMLManager;

public class ResolutionCluster {
    private static final String VALUE = "value";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String STEP = "step";
    private static final String MIN1 = "min1";
    private static final String MAX1 = "max1";
    private static final String STEP1 = "step1";
    private static final String MIN2 = "min2";
    private static final String STEP2 = "step2";
    private static final String DIRECTORY = "directory";
    private static final String RESTRICTION = "restriction";
    private static final String PARAMETERS = "parameters";
    private static final String NB_INSTANCES = "nbInstances";
    private static final String PACKAGE = "package";
    private static final String suffixCommand = ",nodes=1:ppn=1 -m n -- ";
    private static final String[] queueCommands = new String[]{"qadd -q short2 -l cput=00:30:00,nodes=1:ppn=1 -m n -- ", "qadd -q normal2 -l cput=05:00:00,nodes=1:ppn=1 -m n -- ", "qadd -q long2 -l cput=48:00:00,nodes=1:ppn=1 -m n -- ", "qadd -q short8 -l cput=00:30:00,nodes=1:ppn=1 -m n -- ", "qadd -q normal8 -l cput=05:00:00,nodes=1:ppn=1 -m n -- ", "qadd -q long8 -l cput=48:00:00,nodes=1:ppn=1 -m n -- ", "qadd -q shortmulti -l cput=00:30:00,nodes=1:ppn=1 -m n -- ", "qadd -q normalmulti -l cput=05:00:00,nodes=1:ppn=1 -m n -- ", "qadd -q longmulti -l cput=48:00:00,nodes=1:ppn=1 -m n -- "};
    private String solverCommandPrefix;
    private String defaultSettingsFileName;
    private String selectedInstancesFileName;
    private String settingsVariantsFileName;
    private String directoryName;
    private int queueMode;
    private String[] listOfResultsDirectory;
    private int nLaunchedJobs;
    private String currVariantFileName;
    private boolean currVariantParallel;
    private boolean timeForCluster = true;

    private String getDirectoryNameOf(String suffix) {
        return this.directoryName + File.separator + suffix;
    }

    private String getDirectoryNameOfContext() {
        return this.getDirectoryNameOf("context");
    }

    private String getDirectoryNameOfConfigurations() {
        return this.getDirectoryNameOf("configurations");
    }

    private String getDirectoryNameOfResults() {
        return this.getDirectoryNameOf("results");
    }

    private void saveContext() {
        String jarName;
        String directoryNameOfContext = this.getDirectoryNameOfContext();
        File file = new File(directoryNameOfContext);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            Kit.control(file.isDirectory());
        }
        Kit.copy(this.defaultSettingsFileName, directoryNameOfContext + File.separator + this.defaultSettingsFileName);
        Kit.copy(this.selectedInstancesFileName, directoryNameOfContext + File.separator + this.selectedInstancesFileName);
        if (this.settingsVariantsFileName != null) {
            Kit.copy(this.settingsVariantsFileName, directoryNameOfContext + File.separator + this.settingsVariantsFileName);
        }
        if ((jarName = System.getProperty("java.class.path")).indexOf(File.pathSeparator) == -1 && jarName.endsWith(".jar")) {
            int index = jarName.lastIndexOf(File.separator);
            index = index == -1 ? 0 : index + 1;
            Kit.copy(jarName, directoryNameOfContext + File.separator + jarName.substring(index));
        }
    }

    public ResolutionCluster(String[] args) {
        this.defaultSettingsFileName = args[0];
        this.selectedInstancesFileName = args[1];
        this.settingsVariantsFileName = args[2];
        this.solverCommandPrefix = args[3];
        if (this.timeForCluster) {
            this.solverCommandPrefix = "time " + this.solverCommandPrefix;
        }
        this.queueMode = Integer.parseInt(args[4]);
        Kit.control(this.queueMode >= 0 && this.queueMode <= 8, () -> "The queue mode must be set to 0 (short), 1 (normal) or 2 (long)");
        this.directoryName = ControlPanel.buildControlPanelFor((String)this.defaultSettingsFileName).xml.dirForCampaign;
        Kit.control(!this.directoryName.trim().equals(""));
        this.saveContext();
        File file = new File(this.getDirectoryNameOfConfigurations());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(this.getDirectoryNameOfResults())).exists()) {
            file.mkdirs();
        }
        this.runVariants();
    }

    private String getInstanceFileNameIn(String command) {
        StringTokenizer st = new StringTokenizer(command);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().contains("configurations")) continue;
            return st.nextToken();
        }
        return null;
    }

    private boolean isPreviouslyRun(String command) {
        String instanceFileName = this.getInstanceFileNameIn(command);
        if (instanceFileName != null) {
            int index;
            String prefix = Output.getOutputFileNamePrefixFrom(instanceFileName, this.currVariantFileName);
            if (this.listOfResultsDirectory == null) {
                this.listOfResultsDirectory = new File(this.getDirectoryNameOfResults()).list();
                Arrays.sort(this.listOfResultsDirectory);
            }
            Kit.control((index = Arrays.binarySearch(this.listOfResultsDirectory, prefix)) < 0);
            index = -index - 1;
            if (index < this.listOfResultsDirectory.length && this.listOfResultsDirectory[index].startsWith(prefix)) {
                return true;
            }
        }
        return false;
    }

    private void addJob(String solverCommand) {
        if (!this.isPreviouslyRun(solverCommand)) {
            ++this.nLaunchedJobs;
            String clusterCommand = queueCommands[this.queueMode] + solverCommand;
            System.out.println("Job number " + this.nLaunchedJobs + " : " + clusterCommand);
            try {
                Process p = Runtime.getRuntime().exec(clusterCommand);
                p.waitFor();
                p.exitValue();
                p.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void operateFile(File srcFile) {
        if (!this.currVariantParallel) {
            this.addJob(this.solverCommandPrefix + " " + this.currVariantFileName + " " + srcFile.toString());
        } else {
            this.addJob(this.solverCommandPrefix + " " + this.getDirectoryNameOfContext() + File.separator + this.defaultSettingsFileName + " " + srcFile.toString() + " " + this.currVariantFileName);
        }
    }

    private void operateDirectory(File dir, String[] selectedInstances) {
        if (dir.list() == null) {
            System.out.println("******************************************** pb with " + dir.getName());
        } else {
            for (String s : Kit.sort(dir.list())) {
                this.operate(new File(dir, s), selectedInstances);
            }
        }
    }

    private void operate(File file, String[] selectedInstances) {
        if (file.isDirectory()) {
            this.operateDirectory(file, selectedInstances);
        } else if ((file.getName().toLowerCase().endsWith("xml") || file.getName().toLowerCase().endsWith("bz2") || file.getName().toLowerCase().endsWith("lzma")) && (selectedInstances == null || Arrays.binarySearch(selectedInstances, file.getName()) >= 0)) {
            this.operateFile(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getSelectedInstances(String fileName) {
        if (fileName == null) return null;
        if (fileName.length() == 0) {
            return null;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            LinkedList<String> list = new LinkedList<String>();
            String line = in.readLine();
            while (line != null) {
                list.add(line.trim());
                line = in.readLine();
            }
            String[] stringArray = Kit.sort(list.toArray(new String[list.size()]));
            return stringArray;
        }
        catch (IOException e) {
            Kit.exit(e);
            return null;
        }
    }

    public void runVariant(String variant, boolean b) {
        this.currVariantFileName = variant;
        this.currVariantParallel = b;
        Document document = XMLManager.load(this.selectedInstancesFileName);
        NodeList directoryList = document.getElementsByTagName(DIRECTORY);
        for (int i = 0; i < directoryList.getLength(); ++i) {
            Element element = (Element)directoryList.item(i);
            this.operate(new File(element.getAttribute(VALUE)), this.getSelectedInstances(element.getAttribute(RESTRICTION)));
        }
        if (!this.currVariantParallel) {
            NodeList parametersList = document.getElementsByTagName(PARAMETERS);
            for (int i = 0; i < parametersList.getLength(); ++i) {
                Element elt = (Element)parametersList.item(i);
                String nInstances = elt.getAttribute(NB_INSTANCES);
                String packageName = elt.getAttribute(PACKAGE);
                String value = elt.getAttribute(VALUE);
                int nb = Kit.countIn('?', value);
                Kit.control(0 <= nb && nb <= 2, () -> "More than two ? in the expression");
                if (nb == 0) {
                    this.addJob(this.solverCommandPrefix + " " + this.currVariantFileName + " " + nInstances + " " + packageName + " " + value);
                    continue;
                }
                if (nb == 1) {
                    boolean integerRange;
                    boolean bl = integerRange = elt.getAttribute(MIN).indexOf(46) == -1;
                    if (integerRange) {
                        int min = Integer.parseInt(elt.getAttribute(MIN));
                        int max = Integer.parseInt(elt.getAttribute(MAX));
                        int step = elt.getAttribute(STEP).length() == 0 ? 1 : Integer.parseInt(elt.getAttribute(STEP));
                        for (int d = min; d <= max; d += step) {
                            this.addJob(this.solverCommandPrefix + " " + this.currVariantFileName + " " + nInstances + " " + packageName + " " + value.replace("?", d + ""));
                        }
                        continue;
                    }
                    double min = Double.parseDouble(elt.getAttribute(MIN));
                    double max = Double.parseDouble(elt.getAttribute(MAX));
                    double step = elt.getAttribute(STEP).length() == 0 ? 1.0 : Double.parseDouble(elt.getAttribute(STEP));
                    for (double d = min; d <= max; d += step) {
                        this.addJob(this.solverCommandPrefix + " " + this.currVariantFileName + " " + nInstances + " " + packageName + " " + value.replace("?", d + ""));
                    }
                    continue;
                }
                if (nb != 2) continue;
                int pos1 = value.indexOf("?");
                int pos2 = value.lastIndexOf("?");
                int min1 = Integer.parseInt(elt.getAttribute(MIN1));
                int min2 = Integer.parseInt(elt.getAttribute(MIN2));
                int max1 = Integer.parseInt(elt.getAttribute(MAX1));
                int step1 = Integer.parseInt(elt.getAttribute(STEP1));
                int step2 = Integer.parseInt(elt.getAttribute(STEP2));
                for (int d1 = min1; d1 <= max1; d1 += step1) {
                    for (int d2 = min2; d2 < d1; d2 += step2) {
                        String v = value.substring(0, pos1) + d1 + " " + value.substring(pos1 + 1, pos2) + d2 + " " + value.substring(pos2 + 1);
                        this.addJob(this.solverCommandPrefix + " " + this.currVariantFileName + " " + nInstances + " " + packageName + " " + v);
                    }
                }
            }
        }
    }

    public void runVariants() {
        String[] parallelVariants;
        String[] sequentialVariants;
        for (String sequentialVariant : sequentialVariants = ResolutionVariants.loadSequentialVariants(this.defaultSettingsFileName, this.settingsVariantsFileName, this.getDirectoryNameOfConfigurations() + File.separator)) {
            this.runVariant(sequentialVariant, false);
        }
        for (String parallelVariant : parallelVariants = ResolutionVariants.loadParallelVariants(this.settingsVariantsFileName, this.getDirectoryNameOfConfigurations() + File.separator)) {
            this.runVariant(parallelVariant, true);
        }
        File file = new File(this.directoryName + File.separator + "synthesis.txt");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            out.println("----------------------");
            out.println("  Current time : " + Kit.getFormattedCurrentDate());
            out.println("  Command : java abscon.ResolutionCluster " + this.defaultSettingsFileName + " " + this.selectedInstancesFileName + " " + this.settingsVariantsFileName + " " + this.solverCommandPrefix + " " + queueCommands[this.queueMode]);
            out.println("  Nb Sequential Variants : " + sequentialVariants.length);
            out.println("  Nb Parallel Variants : " + parallelVariants.length);
            out.println("  Nb Launched Jobs : " + this.nLaunchedJobs);
            out.println();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(" => " + this.nLaunchedJobs + " jobs launched");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("Usage : java abscon.ResolutionCluster <defaultSettingsFileName> <selectedInstancesFileName> <settingsVariantsFileName> <command>  <queueMode>");
            System.out.println("\n  Queue mode:");
            for (int i = 0; i < queueCommands.length; ++i) {
                System.out.println("   - queue = " + i + " => " + queueCommands[i]);
            }
            System.out.println("\n  NB: set no to <settingsVariantsFileName> to not take into account variants");
        } else {
            new ResolutionCluster(args);
        }
    }
}

