/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.ControlPanel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import utility.Kit;

public class ControlPanelVariables {
    public final Object[] selectedVars;
    public final Object[] instantiatedVars;
    public final int[] instantiatedVals;
    public final Object[] priorityVars;
    public final int nStrictPriorityVars;

    private int[] toIntegers(String[] tokens) {
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        Integer[] t = (Integer[])Stream.of(tokens).map(v -> Kit.parseInteger(v)).toArray(Integer[]::new);
        Kit.control(Stream.of(t).noneMatch(v -> v == null), () -> "Only integer values were expected here");
        return Stream.of(t).mapToInt(i -> i).toArray();
    }

    private Object[] readSelectionList(String s) {
        if (s == null || s.trim().length() == 0) {
            return new Object[0];
        }
        String msg = "Badly formed list. For example, you cannot mix ids and numbers of variables in the same list.";
        HashSet<Object> set = new HashSet<Object>();
        for (String token : s.split(",")) {
            if (token.contains("..")) {
                Kit.control(token.matches("-?\\d+\\.\\.\\d+"), () -> msg + " Pb with " + token);
                Kit.control(set.isEmpty() || set.iterator().next() instanceof Integer, () -> msg);
                int[] t = this.toIntegers(token.split("\\.\\."));
                for (int num = Math.abs(t[0]); num <= t[1]; ++num) {
                    if (t[0] >= 0) {
                        set.add(num);
                        continue;
                    }
                    set.remove(num);
                }
                continue;
            }
            Integer num = Kit.parseInteger(token);
            if (num != null) {
                Kit.control(set.isEmpty() || set.iterator().next() instanceof Integer, () -> msg);
                if (num >= 0) {
                    set.add(num);
                    continue;
                }
                set.remove(-num.intValue());
                continue;
            }
            Kit.control(set.isEmpty() || set.iterator().next() instanceof String, () -> msg);
            set.add(token);
        }
        return Kit.sort(set.toArray(new Object[set.size()]));
    }

    private Object[] controlAndFinalizeVariablesLists(Object[] priority1Vars, Object[] priority2Vars) {
        Object[] t = Kit.concat(this.instantiatedVars, priority1Vars, priority2Vars);
        if (t.length > 0) {
            Kit.control(Stream.of(t).distinct().count() == (long)t.length, () -> "Two variables are identical in your lists (-sel -pr1 -pr2)");
            Kit.control(this.selectedVars.length == 0 || Stream.of(t).allMatch(o -> Arrays.binarySearch(this.selectedVars, o) >= 0), () -> "One variable present in one of your list -ins -pr1 or -pr2 is not present in your selection (-sel).");
        }
        return t;
    }

    ControlPanelVariables(ControlPanel.Variables vars) {
        this.selectedVars = this.readSelectionList(vars.selection);
        String[] t = vars.instantiation.trim().length() == 0 ? null : vars.instantiation.trim().split(":");
        Kit.control(t == null || t.length == 2, () -> vars.instantiation);
        this.instantiatedVars = t == null ? new Object[]{} : this.readSelectionList(t[0]);
        this.instantiatedVals = t == null ? new int[]{} : this.toIntegers(t[1].split(","));
        Object[] priority1Vars = this.readSelectionList(vars.priority1Vars);
        Object[] priority2Vars = this.readSelectionList(vars.priority2Vars);
        this.priorityVars = this.controlAndFinalizeVariablesLists(priority1Vars, priority2Vars);
        this.nStrictPriorityVars = this.instantiatedVars.length + priority1Vars.length;
    }
}

