/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.Arguments;
import dashboard.ControlPanel;
import executables.Resolution;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.XMLManager;
import utility.interfaces.TagExperimental;
import utility.interfaces.TagInvisible;

public final class ControlPanelSettings {
    private UserSettings userSettings;
    private List<Setting<?>> settings = new ArrayList();

    protected ControlPanelSettings(String settingsFilename) {
        this.userSettings = new UserSettings(settingsFilename);
    }

    private <T> Setting<T> add(Setting<T> setting) {
        Kit.control(setting.shortcut != null, () -> "A shortcut must be given");
        for (Setting<?> p : this.settings) {
            Kit.control(((Setting)p).shortcut == null || !((Setting)p).shortcut.equals(setting.shortcut), () -> "The parameters " + p.key() + " and " + setting.key() + " with the same shortcut " + setting.shortcut);
            Kit.control(!p.key().equals(setting.key()), () -> "The parameters " + p.key() + " and " + setting.key() + " with the same value");
        }
        this.settings.add(setting);
        Kit.control(setting.priority >= 1 && setting.priority <= 4 && setting.tag != null && setting.attribute != null && setting.defaultValue != null && setting.value != null);
        return setting;
    }

    public int addI(int priority, String tag, String attribute, String shortcut, int defaultValue, String description) {
        return (Integer)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Integer.valueOf((int)defaultValue), (String)description)).value;
    }

    public long addL(int priority, String tag, String attribute, String shortcut, long defaultValue, String description) {
        return (Long)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Long.valueOf((long)defaultValue), (String)description)).value;
    }

    public double addD(int priority, String tag, String attribute, String shortcut, double defaultValue, String description) {
        return (Double)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Double.valueOf((double)defaultValue), (String)description)).value;
    }

    public boolean addB(int priority, String tag, String attribute, String shortcut, boolean defaultValue, String description) {
        return (Boolean)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Boolean.valueOf((boolean)defaultValue), (String)description)).value;
    }

    public String addS(int priority, String tag, String attribute, String shortcut, String defaultValue, String description) {
        return (String)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)defaultValue, (String)description)).value;
    }

    public String addS(int priority, String tag, String attribute, String shortcut, Class<?> defaultValue, Class<?> root, String description) {
        return (String)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, defaultValue, root, (String)description)).value;
    }

    public <T extends Enum<T>> T addE(int priority, String tag, String attribute, String shortcut, T defaultValue, String description) {
        return (T)((Enum)this.add(new SettingEnum<T>((ControlPanelSettings)this, (int)priority, (String)tag, (String)attribute, (String)shortcut, defaultValue, (String)description)).value);
    }

    public void controlKeys() {
        String k = Arguments.argsForCp.keySet().stream().filter(key -> this.settings.stream().noneMatch(s -> s.key().equals(key) || ((Setting)s).shortcut.equals(key))).findFirst().orElse(null);
        Kit.control(k == null, () -> "The parameter " + k + " is unknown");
    }

    public void display() {
        try (Scanner scanner1 = new Scanner(Resolution.class.getResource("/displayPart1.txt").openStream());
             Scanner scanner2 = new Scanner(Resolution.class.getResourceAsStream("/displayPart2.txt"));){
            while (scanner1.hasNext()) {
                System.out.println(scanner1.nextLine());
            }
            String tag = null;
            for (Setting<?> setting : this.settings) {
                String string;
                if (((Setting)setting).priority == 4 || ((Setting)setting).priority == 4) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (!((Setting)setting).tag.equals(tag)) {
                    tag = ((Setting)setting).tag;
                    string = "\n  " + tag + "\n";
                } else {
                    string = "";
                }
                System.out.print(stringBuilder.append(string).append(setting).toString());
            }
            System.out.println();
            while (scanner2.hasNext()) {
                System.out.println(scanner2.nextLine());
            }
        }
        catch (Exception e) {
            Kit.exit("Error while loading display files", e);
        }
    }

    public static void saveControlPanelSettings(ControlPanel cp, String outputFilename, int maximumPriority) {
        Document document = XMLManager.createNewDocument();
        Node root = document.appendChild(document.createElement("configuration"));
        for (Setting<?> setting : cp.settings.settings) {
            if (((Setting)setting).priority > maximumPriority) continue;
            NodeList list = document.getElementsByTagName(((Setting)setting).tag);
            if (list.getLength() == 0) {
                root.appendChild(document.createElement(((Setting)setting).tag));
                list = document.getElementsByTagName(((Setting)setting).tag);
            }
            Kit.control(list.getLength() == 1);
            Object value = setting.defaultValue;
            if (value instanceof Number) {
                Number n = (Number)setting.defaultValue;
                value = n.longValue() == Long.MIN_VALUE || n.intValue() == Integer.MIN_VALUE ? Types.TypeOptimization.MIN.name().toLowerCase() : (n.longValue() == Long.MAX_VALUE || n.intValue() == Integer.MAX_VALUE ? Types.TypeOptimization.MAX.name().toLowerCase() : value);
            }
            ((Element)list.item(0)).setAttribute(((Setting)setting).attribute.trim(), value.toString());
        }
        Utilities.save((Document)document, (String)outputFilename);
        try {
            Runtime.getRuntime().exec("xmlindent -i 2 -w " + outputFilename).waitFor();
        }
        catch (Exception e) {
            Utilities.exit((String)("Pb when Indenting File " + outputFilename + " " + e));
        }
    }

    public static final class SettingEnum<T extends Enum<T>>
    extends Setting<T> {
        final /* synthetic */ ControlPanelSettings this$0;

        private SettingEnum(int priority, String tag, String attribute, String shortcut, T defaultValue, String description) {
            this.this$0 = this$0;
            super(priority, tag, attribute, shortcut, defaultValue, description);
            this.value = Enum.valueOf(defaultValue.getClass(), ((ControlPanelSettings)this$0).userSettings.stringFor(shortcut, tag, attribute, defaultValue).toUpperCase());
        }
    }

    private class Setting<T> {
        private int priority;
        private String tag;
        private String attribute;
        private String shortcut;
        private String description;
        T defaultValue;
        T value;
        private Class<?> root;
        private final String[] experimentalNames = Kit.sort(new String[]{Enums.ESymmetryBreaking.VAL.name(), Enums.ESymmetryBreaking.REC.name(), Enums.EExtension.STRCPRS.name(), Enums.EExtractionMethod.MAX_CSP.name(), Enums.EExtractionMethod.INC.name(), Enums.EExtractionMethod.INC_FIRST.name()});

        private T getValue(String shortcut, String tag, String attribute, T defaultValue) {
            if (defaultValue == null) {
                return null;
            }
            Class<?> clazz = defaultValue.getClass();
            if (defaultValue instanceof Integer) {
                return (T)clazz.cast(ControlPanelSettings.this.userSettings.intFor(shortcut, tag, attribute, (Integer)defaultValue));
            }
            if (defaultValue instanceof Long) {
                return (T)clazz.cast(ControlPanelSettings.this.userSettings.longFor(shortcut, tag, attribute, (Long)defaultValue));
            }
            if (defaultValue instanceof Double) {
                return (T)clazz.cast(ControlPanelSettings.this.userSettings.doubleFor(shortcut, tag, attribute, (Double)defaultValue));
            }
            if (defaultValue instanceof Boolean) {
                return (T)clazz.cast(ControlPanelSettings.this.userSettings.booleanFor(shortcut, tag, attribute, (Boolean)defaultValue));
            }
            if (defaultValue instanceof String) {
                return (T)clazz.cast(ControlPanelSettings.this.userSettings.stringFor(shortcut, tag, attribute, defaultValue));
            }
            if (defaultValue instanceof Enum) {
                // empty if block
            }
            return null;
        }

        private Setting(int priority, String tag, String attribute, String shortcut, T defaultValue, String description) {
            this.priority = priority;
            this.tag = tag;
            this.attribute = attribute;
            this.shortcut = shortcut;
            this.defaultValue = defaultValue;
            this.value = this.getValue(shortcut, tag, attribute, defaultValue);
            this.description = description;
        }

        private Setting(int priority, String tag, String attribute, String shortcut, Class<?> defaultValue, Class<?> root, String description) {
            this(priority, tag, attribute, shortcut, defaultValue == null ? "" : defaultValue.getName().substring(defaultValue.getName().lastIndexOf(".") + 1), description);
            this.root = root;
        }

        String key() {
            return this.tag + "/" + this.attribute;
        }

        public String toString() {
            String s = new String();
            s = s + "    -" + this.key() + (this.shortcut != null ? " -" + this.shortcut : "") + "\n";
            s = s + "\t" + (this.description == null || this.description.length() == 0 ? "Description is missing..." : this.description) + "\n";
            s = s + "\tDefault value is : " + (this.defaultValue instanceof String && ((String)this.defaultValue).length() == 0 ? "\"\" (empty string)" : this.defaultValue) + "\n";
            if (this.root != null) {
                s = s + "\tPossible String values are : ";
                for (AnnotatedElement annotatedElement : Reflector.searchClassesInheritingFrom(this.root)) {
                    if (TagExperimental.class.isAssignableFrom((Class<?>)annotatedElement) || TagInvisible.class.isAssignableFrom((Class<?>)annotatedElement)) continue;
                    s = s + ((Class)annotatedElement).getSimpleName() + " ";
                }
                s = s + "\n";
            }
            if (this.value instanceof Enum) {
                s = s + "\tPossible Enum values are : ";
                for (AnnotatedElement annotatedElement : this.value.getClass().getDeclaredFields()) {
                    if (!((Field)annotatedElement).isEnumConstant() || Arrays.binarySearch(this.experimentalNames, ((Field)annotatedElement).getName()) >= 0) continue;
                    s = s + ((Field)annotatedElement).getName() + " ";
                }
                s = s + "\n";
            }
            return s;
        }
    }

    private static class UserSettings {
        private Document document;
        private XPath xPath;

        private UserSettings(String userSettingsFilename) {
            try {
                if (userSettingsFilename == null) {
                    userSettingsFilename = Arguments.userSettingsFilename;
                }
                if (userSettingsFilename != null && !userSettingsFilename.equals("defaultConfiguration")) {
                    this.document = XMLManager.load(new FileInputStream(new File(userSettingsFilename)));
                    this.xPath = XPathFactory.newInstance().newXPath();
                }
            }
            catch (FileNotFoundException e) {
                Kit.exit(e);
            }
        }

        private String stringFor(String shortcut, String tag, String att, Object defaultValue) {
            String value;
            String string = value = shortcut == null ? null : Arguments.argsForCp.get(shortcut);
            if (value != null) {
                return value.length() == 0 && !(defaultValue instanceof String) ? defaultValue.toString() : value;
            }
            value = Arguments.argsForCp.get((tag != null ? tag + "/" : "") + att);
            if (value != null) {
                return value;
            }
            if (this.document == null) {
                return defaultValue.toString();
            }
            try {
                NodeList nodes = (NodeList)this.xPath.compile("//" + (tag != null ? tag : "*") + "/@" + att).evaluate(this.document, XPathConstants.NODESET);
                Kit.control(nodes.getLength() <= 1, () -> "Problem with several possibilities for " + tag + " " + att);
                if (nodes.getLength() == 0) {
                    return defaultValue.toString();
                }
                value = nodes.item(0).getNodeValue();
                return value.length() == 0 && !(defaultValue instanceof String) ? defaultValue.toString() : value;
            }
            catch (XPathExpressionException e) {
                Kit.exit("problem xpath", e);
                return (String)Kit.exit("Problem with " + tag + " and " + att + " and " + defaultValue);
            }
        }

        private Number numberFor(String shortcut, String tag, String att, Object defaultValue, boolean longValue) {
            String s = this.stringFor(shortcut, tag, att, defaultValue).toLowerCase();
            if (s.equals("min")) {
                return longValue ? (Number)Long.MIN_VALUE : (Number)Integer.MIN_VALUE;
            }
            if (s.equals("max") || s.equals("all")) {
                return longValue ? (Number)Long.MAX_VALUE : (Number)Integer.MAX_VALUE;
            }
            char lastCharacter = s.charAt(s.length() - 1);
            Long baseValue = Kit.parseLong(Character.isDigit(lastCharacter) ? s : s.substring(0, s.length() - 1));
            Kit.control(baseValue != null, () -> "An integer/long value was expected for " + tag + "/" + att);
            double value = Character.isDigit(lastCharacter) ? (double)baseValue.longValue() : (lastCharacter == 'k' || lastCharacter == 's' ? (double)(baseValue * 1000L) : (lastCharacter == 'm' ? (double)(baseValue * 1000000L) : (Double)Kit.exit("Bad character for " + tag + " " + att)));
            Kit.control(longValue && -9.223372036854776E18 <= value && value <= 9.223372036854776E18 || !longValue && -2.147483648E9 <= value && value <= 2.147483647E9);
            return longValue ? (Number)new Long((long)value) : (Number)new Integer((int)value);
        }

        private int intFor(String shortcut, String tag, String att, Integer defaultValue) {
            return (Integer)this.numberFor(shortcut, tag, att, defaultValue, false);
        }

        private Long longFor(String shortcut, String tag, String att, Long defaultValue) {
            return (Long)this.numberFor(shortcut, tag, att, defaultValue, true);
        }

        private double doubleFor(String shortcut, String tag, String att, Double defaultValue) {
            Double d = Utilities.toDouble((String)this.stringFor(shortcut, tag, att, defaultValue));
            Utilities.control((d != null ? 1 : 0) != 0, (String)("A double value was expected for " + tag + "/" + att));
            return d;
        }

        private boolean booleanFor(String shortcut, String tag, String att, Boolean defaultValue) {
            Boolean b = Utilities.toBoolean((String)this.stringFor(shortcut, tag, att, defaultValue));
            Utilities.control((b != null ? 1 : 0) != 0, (String)("A boolean value was expected for " + tag + "/" + att));
            return b;
        }
    }
}

