/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import java.util.Arrays;
import org.xcsp.common.Types;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.domains.Domain;

public class SoftMatrix2D
extends ExtensionStructureSoft {
    public long[][] costsMatrix;

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        throw new MissingImplementationException();
    }

    @Override
    public void storeTuplesAndCosts(int[][] tuples, long[] costs, long defaultCost) {
        super.storeTuplesAndCosts(tuples, costs, defaultCost);
        assert (this.registeredCtrs().size() == 1 && tuples.length == costs.length);
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        Domain dom1 = ctr.scp[1].dom;
        for (long[] t : this.costsMatrix = new long[dom0.initSize()][dom1.initSize()]) {
            Arrays.fill(t, defaultCost);
        }
        if (ctr.indexesMatchValues) {
            for (int i = 0; i < tuples.length; ++i) {
                this.costsMatrix[tuples[i][0]][tuples[i][1]] = costs[i];
            }
        } else {
            for (int i = 0; i < tuples.length; ++i) {
                this.costsMatrix[dom0.toIdx((int)tuples[i][0])][dom1.toIdx((int)tuples[i][1])] = costs[i];
            }
        }
    }

    public SoftMatrix2D(Constraint ctr) {
        super(ctr);
        Kit.control(ctr.scp.length == 2);
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        return this.costsMatrix[tuple[0]][tuple[1]];
    }

    public void setCostOfIndexes(int[] tuple, long cost) {
        this.costsMatrix[tuple[0]][tuple[1]] = cost;
    }

    @Override
    public String getStringListOfTuples() {
        assert (this.registeredCtrs().size() == 1);
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        Domain dom1 = ctr.scp[1].dom;
        StringBuilder sb = new StringBuilder();
        long currentCost = -1L;
        int[] t = new int[2];
        int cnt = 0;
        for (int i = 0; i < this.costsMatrix.length; ++i) {
            t[0] = dom0.toVal(i);
            for (int j = 0; j < this.costsMatrix[i].length; ++j) {
                t[1] = dom1.toVal(j);
                if (this.costsMatrix[i][j] == this.defaultCost) continue;
                ++cnt;
                if (this.costsMatrix[i][j] != currentCost) {
                    currentCost = this.costsMatrix[i][j];
                    sb.append(currentCost).append(":");
                }
                Kit.join(sb, (Object)t, new String[0]).append('|');
            }
        }
        return sb.append("#").append("soft").append(cnt).append(Types.TypeAtt.defaultCost.name()).append(this.defaultCost).toString();
    }

    public String toString() {
        return "matrix2D\n" + Kit.join((Object)this.costsMatrix, new String[0]);
    }
}

