/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import java.util.Arrays;
import org.xcsp.common.Types;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.domains.Domain;

public class SoftMatrix1D
extends ExtensionStructureSoft {
    private long[] costsMatrix;

    public long[] getCosts() {
        return this.costsMatrix;
    }

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        throw new MissingImplementationException();
    }

    @Override
    public void storeTuplesAndCosts(int[][] tuples, long[] costs, long defaultCost) {
        super.storeTuplesAndCosts(tuples, costs, defaultCost);
        assert (this.registeredCtrs().size() == 1 && tuples.length == costs.length);
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom = ctr.scp[0].dom;
        this.costsMatrix = new long[dom.initSize()];
        Arrays.fill(this.costsMatrix, defaultCost);
        if (ctr.indexesMatchValues) {
            for (int i = 0; i < tuples.length; ++i) {
                this.costsMatrix[tuples[i][0]] = costs[i];
            }
        } else {
            for (int i = 0; i < tuples.length; ++i) {
                this.costsMatrix[dom.toIdx((int)tuples[i][0])] = costs[i];
            }
        }
    }

    public SoftMatrix1D(Constraint ctr) {
        super(ctr);
        Kit.control(ctr.scp.length == 1);
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        return this.costsMatrix[tuple[0]];
    }

    @Override
    public String getStringListOfTuples() {
        assert (this.registeredCtrs().size() == 1);
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        StringBuilder sb = new StringBuilder();
        long currentCost = -1L;
        int[] t = new int[1];
        int cnt = 0;
        for (int i = 0; i < this.costsMatrix.length; ++i) {
            t[0] = dom0.toVal(i);
            if (this.costsMatrix[i] == this.defaultCost) continue;
            ++cnt;
            if (this.costsMatrix[i] != currentCost) {
                currentCost = this.costsMatrix[i];
                sb.append(currentCost).append(":");
            }
            Kit.join(sb, (Object)t, new String[0]).append('|');
        }
        return sb.append("#").append("soft").append(cnt).append(Types.TypeAtt.defaultCost.name()).append(this.defaultCost).toString();
    }

    public String toString() {
        return "matrix1D\n " + Kit.join((Object)this.costsMatrix, new String[0]);
    }
}

