/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension;

import constraints.soft.extension.CtrSoftExtensionSTR1;
import constraints.soft.extension.structures.SoftTableDelta;
import java.util.Arrays;
import java.util.stream.Stream;
import problem.Problem;
import propagation.order1.StrongConsistency;
import propagation.soft.sac.SoftAC2;
import utility.Enums;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.interfaces.FilteringGlobal;
import utility.observers.ObserverBacktrackingSystematic;
import utility.operations.Calculator;
import utility.sets.SetSparseMapLong;
import variables.Variable;
import variables.domains.Domain;

public class CtrSoftExtensionSTR2
extends CtrSoftExtensionSTR1
implements FilteringGlobal,
ObserverBacktrackingSystematic {
    protected boolean decremental;
    protected int lastDepth;
    protected int[] lastSizes;
    protected int[][] lastSizesStack;
    protected int nbValVariables;
    protected int[] valVariablePositions;
    protected int nbSupVariables;
    protected int[] supVariablePositions;
    protected long nbAssignmentsAtLastCall;
    private int[] nbValuesWithoutSupports;
    private int index;

    protected void initializeRestorationStructuresBeforeFiltering() {
        if (this.decremental) {
            int depth = this.pb.solver.depth();
            assert (depth >= this.lastDepth && this.lastDepth >= 0) : depth + " " + this.lastDepth;
            for (int i = this.lastDepth + 1; i <= depth; ++i) {
                System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.lastSizesStack[this.lastDepth].length);
            }
            this.lastSizes = this.lastSizesStack[depth];
            this.lastDepth = depth;
        }
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        super.restoreAtDepthBefore(depthBeforeBacktrack);
        if (this.decremental) {
            this.lastDepth = Math.max(0, Math.min(this.lastDepth, depthBeforeBacktrack - 1));
        } else {
            Arrays.fill(this.lastSizes, -2);
        }
    }

    public CtrSoftExtensionSTR2(Problem problem, Variable[] scope, int[][] tuples, long[] costs, long defaultCost) {
        super(problem, scope, tuples, costs, defaultCost);
        this.decremental = problem.rs.cp.extension.decremental;
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        if (this.pb.rs.cp.extension.decremental) {
            this.lastSizesStack = new int[this.pb.variables.length + 1][this.scp.length];
            Arrays.fill(this.lastSizesStack[0], -2);
        } else {
            this.lastSizes = Kit.repeat(-2, this.scp.length);
        }
    }

    protected void buildBasicOptimizationSets() {
        this.valVariablePositions = new int[this.scp.length];
        this.supVariablePositions = new int[this.scp.length];
        this.nbValuesWithoutSupports = new int[this.scp.length];
    }

    @Override
    protected void initializeAdditionalFieldsUsedWithExtensionStructure() {
        super.initializeAdditionalFieldsUsedWithExtensionStructure();
        this.buildBasicOptimizationSets();
    }

    protected void manageLastPastVariable() {
        long nb = this.pb.solver.stats.nAssignments;
        if (this.nbAssignmentsAtLastCall != nb || this.pb.solver.propagation instanceof StrongConsistency) {
            int vap;
            this.nbAssignmentsAtLastCall = nb;
            Variable lastPastVariable = this.pb.solver.futVars.lastPast();
            int n = vap = lastPastVariable == null ? -1 : this.positionOf(lastPastVariable);
            if (vap != -1) {
                this.valVariablePositions[this.nbValVariables++] = vap;
            }
        }
    }

    protected void initializeBeforeFiltering() {
        long ub = this.pb.solver.solManager.bestBound;
        this.initializeRestorationStructuresBeforeFiltering();
        this.nbSupVariables = 0;
        this.nbValVariables = 0;
        this.manageLastPastVariable();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int domainSize;
            int vap = this.futvars.dense[i];
            this.nbValuesWithoutSupports[vap] = domainSize = this.doms[vap].size();
            if (this.lastSizes[vap] != domainSize) {
                this.valVariablePositions[this.nbValVariables++] = vap;
                this.lastSizes[vap] = domainSize;
            }
            this.supVariablePositions[this.nbSupVariables++] = vap;
            Arrays.fill(this.minCosts[vap], ub);
            if (this.defaultCostType == Enums.EDefaultCost.K) continue;
            Arrays.fill(this.nExplicitValidTuples[vap], 0);
        }
    }

    protected boolean isValidTuple(int[] tuple) {
        for (int i = this.nbValVariables - 1; i >= 0; --i) {
            int vap = this.valVariablePositions[i];
            if (this.doms[vap].isPresent(tuple[vap])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected long scanWhenZeroOrIntermediate(long nb) {
        for (int i = this.nbSupVariables - 1; i >= 0; --i) {
            int vap = this.supVariablePositions[i];
            Arrays.fill(this.nExplicitValidTuples[vap], 0);
        }
        long ub = this.pb.solver.solManager.bestBound;
        int depth = this.pb.solver.depth();
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            int[] tuple = this.table.getTuple(dense[i]);
            if (this.isValidTuple(tuple)) {
                long cost = this.table.getCost(dense[i]);
                boolean allowed = this.computeEcost(tuple, cost) < ub;
                for (int j = this.nbSupVariables - 1; j >= 0; --j) {
                    int vap = this.supVariablePositions[j];
                    int idx = tuple[vap];
                    int[] nArray = this.nExplicitValidTuples[vap];
                    int n = idx;
                    nArray[n] = nArray[n] + 1;
                    if (!allowed || cost >= this.minCosts[vap][idx]) continue;
                    this.minCosts[vap][idx] = cost;
                    if (cost != 0L) continue;
                    int n2 = vap;
                    this.nbValuesWithoutSupports[n2] = this.nbValuesWithoutSupports[n2] - 1;
                    if (this.nbValuesWithoutSupports[n2] != 0) continue;
                    this.supVariablePositions[j] = this.supVariablePositions[--this.nbSupVariables];
                }
                continue;
            }
            this.setOfTuples.removeAtPosition(i, depth);
            ++nb;
        }
        return nb;
    }

    @Override
    protected void scanTableWithDefaultCostZero() {
        long nbValidTuples = Variable.nValidTuplesBoundedAtMaxValueFor(this.scp);
        int maxDomSize = Stream.of(this.scp).mapToInt(x -> x.dom.size()).max().orElse(1);
        long nbImplicitValidTuplesLowerbound = nbValidTuples / (long)maxDomSize - (long)this.setOfTuples.size();
        if ((nbImplicitValidTuplesLowerbound = this.scanWhenZeroOrIntermediate(nbImplicitValidTuplesLowerbound)) > 0L) {
            for (int i = this.nbSupVariables - 1; i >= 0; --i) {
                Arrays.fill(this.minCosts[this.supVariablePositions[i]], 0L);
            }
            this.nbSupVariables = 0;
        } else {
            for (int i = this.nbSupVariables - 1; i >= 0; --i) {
                int vap = this.supVariablePositions[i];
                Domain dom = this.scp[vap].dom;
                long nbValidTuplesOfValues = nbValidTuples / (long)dom.size();
                int idx = dom.first();
                while (idx != -1) {
                    if (this.minCosts[vap][idx] != 0L && nbValidTuplesOfValues > (long)this.nExplicitValidTuples[vap][idx]) {
                        this.minCosts[vap][idx] = 0L;
                        int n = vap;
                        this.nbValuesWithoutSupports[n] = this.nbValuesWithoutSupports[n] - 1;
                        if (this.nbValuesWithoutSupports[n] == 0) {
                            this.supVariablePositions[i] = this.supVariablePositions[--this.nbSupVariables];
                        }
                    }
                    idx = dom.next(idx);
                }
            }
        }
    }

    @Override
    protected void scanTableWithDefaultCostIntermediate() {
        this.scanWhenZeroOrIntermediate(Long.MIN_VALUE);
        long nbValidTuples = Variable.nValidTuplesBoundedAtMaxValueFor(this.scp);
        if (this.softAC == null) {
            for (int i = this.nbSupVariables - 1; i >= 0; --i) {
                int vap = this.supVariablePositions[i];
                Domain dom = this.scp[vap].dom;
                long nbValidTuplesOfValues = nbValidTuples / (long)dom.size();
                int idx = dom.first();
                while (idx != -1) {
                    if (nbValidTuplesOfValues > (long)this.nExplicitValidTuples[vap][idx] && this.minCosts[vap][idx] > this.table.getDefaultCost()) {
                        this.minCosts[vap][idx] = this.table.getDefaultCost();
                    }
                    idx = dom.next(idx);
                }
            }
        } else {
            int i;
            long smallestPossibleImplicitCost;
            this.nbValidTuplesOfValues = this.nbValidTuplesOfValues == null ? new long[this.scp.length] : this.nbValidTuplesOfValues;
            long maxSumOfDeltas = 0L;
            for (int i2 = 0; i2 < this.scp.length; ++i2) {
                this.nbValidTuplesOfValues[i2] = nbValidTuples / (long)this.doms[i2].size();
                long maxDelta = -1L;
                Domain dom = this.scp[i2].dom;
                assert (dom.size() > 0);
                int idx = dom.first();
                while (idx != -1) {
                    maxDelta = Math.max(maxDelta, ((SoftTableDelta)this.table).deltas[i2][idx]);
                    idx = dom.next(idx);
                }
                maxSumOfDeltas = Calculator.add(maxSumOfDeltas, maxDelta);
            }
            long l = smallestPossibleImplicitCost = this.table.getDefaultCost() >= this.pb.solver.solManager.bestBound ? this.table.getDefaultCost() : Calculator.add(this.table.getDefaultCost(), -maxSumOfDeltas);
            if (smallestPossibleImplicitCost >= this.pb.solver.solManager.bestBound) {
                return;
            }
            boolean areDomainsSorted = false;
            for (i = this.nbSupVariables - 1; i >= 0; --i) {
                int vap1 = this.supVariablePositions[i];
                Domain dom1 = this.scp[vap1].dom;
                int idx1 = dom1.first();
                while (idx1 != -1) {
                    if (this.minCosts[vap1][idx1] > 0L && this.nbValidTuplesOfValues[vap1] > (long)this.nExplicitValidTuples[vap1][idx1] && this.minCosts[vap1][idx1] > smallestPossibleImplicitCost) {
                        int[] minCostImplicitTuple;
                        if (!areDomainsSorted) {
                            ((SoftTableDelta)this.table).setSortedDomains(this);
                            areDomainsSorted = true;
                        }
                        if ((minCostImplicitTuple = ((SoftTableDelta)this.table).computeMinCostImplicitTuple(this, vap1, idx1, this.minCosts)) != null) {
                            long minCost = this.table.getCostOfIdxs(minCostImplicitTuple);
                            assert (minCost < this.minCosts[vap1][idx1]);
                            this.minCosts[vap1][idx1] = minCost;
                            if (minCost == 0L) {
                                int n = vap1;
                                this.nbValuesWithoutSupports[n] = this.nbValuesWithoutSupports[n] - 1;
                                if (this.nbValuesWithoutSupports[n] == 0) {
                                    this.supVariablePositions[i] = this.supVariablePositions[--this.nbSupVariables];
                                }
                            }
                            for (int j = i - 1; j >= 0; --j) {
                                int vap2 = this.supVariablePositions[j];
                                int idx2 = minCostImplicitTuple[vap2];
                                if (minCost >= this.minCosts[vap2][idx2]) continue;
                                this.minCosts[vap2][idx2] = minCost;
                                if (minCost != 0L) continue;
                                int n = vap2;
                                this.nbValuesWithoutSupports[n] = this.nbValuesWithoutSupports[n] - 1;
                                if (this.nbValuesWithoutSupports[n] != 0) continue;
                            }
                        }
                    }
                    idx1 = dom1.next(idx1);
                }
            }
            for (i = this.nbSupVariables - 1; i >= 0; --i) {
                if (this.nbValuesWithoutSupports[this.supVariablePositions[i]] != 0) continue;
                this.supVariablePositions[i] = this.supVariablePositions[--this.nbSupVariables];
            }
        }
    }

    @Override
    protected void scanTableWithDefaultCostK() {
        long ub = this.pb.solver.solManager.bestBound;
        int depth = this.pb.solver.depth();
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            boolean mustBeRemoved;
            int[] tuple = this.table.getTuple(dense[i]);
            boolean bl = mustBeRemoved = !this.isValidTuple(tuple);
            if (!mustBeRemoved) {
                long cost = this.table.getCost(dense[i]);
                boolean bl2 = mustBeRemoved = this.computeEcost(tuple, cost) >= ub;
                if (!mustBeRemoved) {
                    for (int j = this.nbSupVariables - 1; j >= 0; --j) {
                        int vap = this.supVariablePositions[j];
                        int idx = tuple[vap];
                        if (cost >= this.minCosts[vap][idx]) continue;
                        this.minCosts[vap][idx] = cost;
                        if (cost != 0L) continue;
                        int n = vap;
                        this.nbValuesWithoutSupports[n] = this.nbValuesWithoutSupports[n] - 1;
                        if (this.nbValuesWithoutSupports[n] != 0) continue;
                        this.supVariablePositions[j] = this.supVariablePositions[--this.nbSupVariables];
                    }
                }
            }
            if (!mustBeRemoved) continue;
            this.setOfTuples.removeAtPosition(i, depth);
        }
    }

    private int pickPositionInSup() {
        while (this.index >= 0) {
            int vap = this.futvars.dense[this.index];
            for (int k = this.nbSupVariables - 1; k >= 0; --k) {
                if (vap != this.supVariablePositions[k]) continue;
                this.supVariablePositions[k] = this.supVariablePositions[--this.nbSupVariables];
                return vap;
            }
            --this.index;
        }
        throw new UnreachableCodeException();
    }

    @Override
    public boolean runPropagator(Variable evt) {
        this.initializeBeforeFiltering();
        this.scanTable();
        if (this.softAC != null) {
            while (this.nbSupVariables > 0) {
                int vap = this.pickPositionInSup();
                if (!this.softAC.revise(this, this.scp[vap])) {
                    return false;
                }
                if (!this.softAC.isProjectionPerformedDuringRevision()) continue;
                this.scanTable();
            }
        }
        this.timestamp = this.pb.solver.propagation.incrementTime();
        return true;
    }

    @Override
    public boolean findSupports() {
        this.initializeBeforeFiltering();
        long ub = this.pb.solver.solManager.bestBound;
        SetSparseMapLong variablesRequiringUnaryProjections = ((SoftAC2)this.softAC).getVariablesRequiringUnaryProjections();
        this.scanTable();
        this.index = this.futvars.limit;
        while (this.nbSupVariables > 0) {
            int vap = this.pickPositionInSup();
            Variable var = this.scp[vap];
            long alpha = this.projectFrom(var);
            assert (this.projectionPerformed && alpha >= 0L) : alpha;
            if (Calculator.add(alpha, Calculator.add(this.softAC.c0, variablesRequiringUnaryProjections.sumValues)) >= ub) {
                this.softAC.currFilteringCtr = this;
                return this.softAC.handleWipeout(var);
            }
            variablesRequiringUnaryProjections.add(var.num, alpha);
            if (this.nbSupVariables <= 0) continue;
            this.scanTable();
        }
        return true;
    }
}

