/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension;

import constraints.soft.extension.CtrSoftExtension;
import constraints.soft.extension.Scan;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import constraints.soft.extension.structures.SoftTable;
import constraints.soft.extension.structures.SoftTableDelta;
import dashboard.ControlPanel;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.stream.Stream;
import problem.Problem;
import propagation.soft.sac.SoftAC;
import propagation.soft.sac.SoftAC2;
import utility.Enums;
import utility.Kit;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.operations.Calculator;
import utility.sets.SetDenseReversible;
import utility.sets.SetSparseMapLong;
import variables.Variable;
import variables.domains.Domain;

public class CtrSoftExtensionSTR1
extends CtrSoftExtension
implements FilteringGlobal,
Scan,
TagGuaranteedGAC,
TagCompleteFilteringAtEachCall,
ObserverBacktrackingSystematic {
    protected Enums.EDefaultCost defaultCostType;
    protected SetDenseReversible setOfTuples;
    protected long[][] minCosts;
    protected int[][] nExplicitValidTuples;
    protected SoftTable table;
    public boolean mustConsiderEcost;
    protected long[] nbValidTuplesOfValues;
    protected boolean projectionPerformed;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.setOfTuples.restoreLimitAtLevel(depthBeforeBacktrack);
        assert (this.resetMinCosts());
    }

    @Override
    public final long minCostOfTuplesWith(int vap, int idx) {
        return this.minCosts[vap][idx];
    }

    private boolean resetMinCosts() {
        for (long[] t : this.minCosts) {
            Arrays.fill(t, 0L);
        }
        return true;
    }

    @Override
    protected ExtensionStructureSoft buildSoftExtensionStructure() {
        ControlPanel cfg = this.pb.rs.cp;
        Kit.control(!cfg.propagating.clazz.equals(SoftAC.class.getSimpleName()) || cfg.optimizing.costTranfer == Enums.ECostTranfer.DELTA, () -> "SoftAC with STR requires cost transfert set to delta.");
        this.table = cfg.optimizing.costTranfer == Enums.ECostTranfer.DELTA ? new SoftTableDelta(this) : new SoftTable(this);
        return this.table;
    }

    public CtrSoftExtensionSTR1(Problem problem, Variable[] scope, int[][] tuples, long[] costs, long defaultCost) {
        super(problem, scope, tuples, costs, defaultCost);
        Kit.control(scope.length > 1);
        Kit.control(Long.MAX_VALUE / (long)Variable.maxInitDomSize(scope) > (long)tuples.length);
        this.defaultCostType = defaultCost == 0L ? Enums.EDefaultCost.ZERO : (defaultCost >= problem.rs.cp.optimizing.upperBound ? Enums.EDefaultCost.K : Enums.EDefaultCost.INTERMEDIATE);
        this.mustConsiderEcost = problem.rs.cp.optimizing.ecostForSoftSTR;
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        int nbTuples = ((SoftTable)this.softExtensionStructure).getTuples().length;
        this.setOfTuples = new SetDenseReversible(nbTuples, this.pb.variables.length + 1);
    }

    @Override
    protected void initializeAdditionalFieldsUsedWithExtensionStructure() {
        this.minCosts = Variable.litterals(this.scp).longArray();
        this.nExplicitValidTuples = this.defaultCostType == Enums.EDefaultCost.K ? (int[][])null : Variable.litterals(this.scp).intArray();
    }

    protected void initializeBeforeScan() {
        long ub = this.pb.solver.solManager.bestBound;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int vap = this.futvars.dense[i];
            Arrays.fill(this.minCosts[vap], ub);
            if (this.defaultCostType == Enums.EDefaultCost.K) continue;
            Arrays.fill(this.nExplicitValidTuples[vap], 0);
        }
    }

    protected long computeEcost(int[] tuple, long cost) {
        if (!this.mustConsiderEcost || this.softAC == null) {
            return -1L;
        }
        long fullCost = Calculator.add(cost, this.softAC.c0);
        for (int i = this.futvars.limit; i >= 0; --i) {
            int vap = this.futvars.dense[i];
            fullCost = Calculator.add(fullCost, this.scopeC1s[vap][tuple[vap]]);
        }
        return fullCost;
    }

    protected long scanWhenZeroOrIntermediate(long cnt) {
        this.initializeBeforeScan();
        long ub = this.pb.solver.solManager.bestBound;
        int depth = this.pb.solver.depth();
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            int[] tuple = this.table.getTuple(dense[i]);
            if (this.isValid(tuple)) {
                long cost = this.table.getCost(dense[i]);
                boolean allowed = this.computeEcost(tuple, cost) < ub;
                for (int j = this.futvars.limit; j >= 0; --j) {
                    int vap = this.futvars.dense[j];
                    int idx = tuple[vap];
                    int[] nArray = this.nExplicitValidTuples[vap];
                    int n = idx;
                    nArray[n] = nArray[n] + 1;
                    if (!allowed || cost >= this.minCosts[vap][idx]) continue;
                    this.minCosts[vap][idx] = cost;
                }
                continue;
            }
            this.setOfTuples.removeAtPosition(i, depth);
            if (++cnt > 0L) break;
        }
        return cnt;
    }

    protected void scanTableWithDefaultCostZero() {
        int maxDomSize;
        long nbValidTuples = Variable.nValidTuplesBoundedAtMaxValueFor(this.scp);
        long nImplicitValidTuplesLowerbound = nbValidTuples / (long)(maxDomSize = Stream.of(this.scp).mapToInt(x -> x.dom.size()).max().orElse(1)) - (long)this.setOfTuples.size();
        if (nImplicitValidTuplesLowerbound <= 0L) {
            nImplicitValidTuplesLowerbound = this.scanWhenZeroOrIntermediate(nImplicitValidTuplesLowerbound);
        }
        if (nImplicitValidTuplesLowerbound > 0L) {
            for (int i = this.futvars.limit; i >= 0; --i) {
                Arrays.fill(this.minCosts[this.futvars.dense[i]], 0L);
            }
        } else {
            for (int i = this.futvars.limit; i >= 0; --i) {
                int vap = this.futvars.dense[i];
                Domain dom = this.scp[vap].dom;
                long nValidTuplesOfValues = nbValidTuples / (long)dom.size();
                int idx = dom.first();
                while (idx != -1) {
                    if (nValidTuplesOfValues > (long)this.nExplicitValidTuples[vap][idx]) {
                        this.minCosts[vap][idx] = 0L;
                    }
                    idx = dom.next(idx);
                }
            }
        }
    }

    protected void scanTableWithDefaultCostK() {
        long ub = this.pb.solver.solManager.bestBound;
        int depth = this.pb.solver.depth();
        this.initializeBeforeScan();
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            boolean mustBeRemoved;
            int[] tuple = this.table.getTuple(dense[i]);
            boolean bl = mustBeRemoved = !this.isValid(tuple);
            if (!mustBeRemoved) {
                long cost = this.table.getCost(dense[i]);
                boolean bl2 = mustBeRemoved = this.computeEcost(tuple, cost) >= ub;
                if (!mustBeRemoved) {
                    for (int j = this.futvars.limit; j >= 0; --j) {
                        int vap = this.futvars.dense[j];
                        int idx = tuple[vap];
                        if (cost >= this.minCosts[vap][idx]) continue;
                        this.minCosts[vap][idx] = cost;
                    }
                }
            }
            if (!mustBeRemoved) continue;
            this.setOfTuples.removeAtPosition(i, depth);
        }
    }

    protected void scanTableWithDefaultCostIntermediate() {
        this.scanWhenZeroOrIntermediate(Long.MIN_VALUE);
        long nbValidTuples = Variable.nValidTuplesBoundedAtMaxValueFor(this.scp);
        if (this.softAC == null) {
            for (int i = this.futvars.limit; i >= 0; --i) {
                int vap = this.futvars.dense[i];
                Domain dom = this.scp[vap].dom;
                long nbValidTuplesOfValues = nbValidTuples / (long)dom.size();
                int idx = dom.first();
                while (idx != -1) {
                    if (nbValidTuplesOfValues > (long)this.nExplicitValidTuples[vap][idx] && this.minCosts[vap][idx] > this.table.getDefaultCost()) {
                        this.minCosts[vap][idx] = this.table.getDefaultCost();
                    }
                    idx = dom.next(idx);
                }
            }
        } else {
            long smallestPossibleImplicitCost;
            this.nbValidTuplesOfValues = this.nbValidTuplesOfValues == null ? new long[this.scp.length] : this.nbValidTuplesOfValues;
            long maxSumOfDeltas = 0L;
            for (int i = 0; i < this.scp.length; ++i) {
                Domain dom = this.scp[i].dom;
                this.nbValidTuplesOfValues[i] = nbValidTuples / (long)dom.size();
                long maxDelta = -1L;
                assert (dom.size() > 0);
                int idx = dom.first();
                while (idx != -1) {
                    maxDelta = Math.max(maxDelta, ((SoftTableDelta)this.table).deltas[i][idx]);
                    idx = dom.next(idx);
                }
                maxSumOfDeltas = Calculator.add(maxSumOfDeltas, maxDelta);
            }
            long l = smallestPossibleImplicitCost = this.table.getDefaultCost() >= this.pb.solver.solManager.bestBound ? this.table.getDefaultCost() : Calculator.add(this.table.getDefaultCost(), -maxSumOfDeltas);
            if (smallestPossibleImplicitCost >= this.pb.solver.solManager.bestBound) {
                return;
            }
            boolean areDomainsSorted = false;
            for (int i = this.futvars.limit; i >= 0; --i) {
                int vap1 = this.futvars.dense[i];
                Domain dom1 = this.scp[vap1].dom;
                int idx1 = dom1.first();
                while (idx1 != -1) {
                    if (this.minCosts[vap1][idx1] > 0L && this.nbValidTuplesOfValues[vap1] > (long)this.nExplicitValidTuples[vap1][idx1] && this.minCosts[vap1][idx1] > smallestPossibleImplicitCost) {
                        int[] minCostImplicitTuple;
                        if (!areDomainsSorted) {
                            ((SoftTableDelta)this.table).setSortedDomains(this);
                            areDomainsSorted = true;
                        }
                        if ((minCostImplicitTuple = ((SoftTableDelta)this.table).computeMinCostImplicitTuple(this, vap1, idx1, this.minCosts)) != null) {
                            long minCost;
                            this.minCosts[vap1][idx1] = minCost = this.table.getCostOfIdxs(minCostImplicitTuple);
                            for (int j = i - 1; j >= 0; --j) {
                                int vap2 = this.futvars.dense[j];
                                int idx2 = minCostImplicitTuple[vap2];
                                assert (this.nbValidTuplesOfValues[vap2] > (long)this.nExplicitValidTuples[vap2][idx2]);
                                this.minCosts[vap2][idx2] = Math.min(this.minCosts[vap2][idx2], minCost);
                            }
                        }
                    }
                    idx1 = dom1.next(idx1);
                }
            }
        }
    }

    public void scanTable() {
        if (this.defaultCostType == Enums.EDefaultCost.ZERO) {
            this.scanTableWithDefaultCostZero();
        } else if (this.defaultCostType == Enums.EDefaultCost.K) {
            this.scanTableWithDefaultCostK();
        } else {
            this.scanTableWithDefaultCostIntermediate();
        }
    }

    @Override
    public boolean runPropagator(Variable evt) {
        this.scanTable();
        if (this.softAC != null) {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (!this.softAC.revise(this, this.scp[this.futvars.dense[i]])) {
                    return false;
                }
                if (!this.softAC.isProjectionPerformedDuringRevision()) continue;
                this.scanTable();
            }
        }
        this.timestamp = this.pb.solver.propagation.incrementTime();
        return true;
    }

    protected final long projectFrom(Variable var) {
        assert (this.scp.length > 1);
        this.projectionPerformed = false;
        int vap = this.positionOf(var);
        long[] c1 = this.scopeC1s[vap];
        Domain dom = var.dom;
        long minUnaryCost = Long.MAX_VALUE;
        int idx = dom.first();
        while (idx != -1) {
            long minCost = this.minCosts[vap][idx];
            assert (minCost >= 0L && c1[idx] >= 0L);
            if (minCost > 0L) {
                this.projectionPerformed = true;
                assert (this.seekMinCostFor(vap, idx) == minCost) : this + " " + vap + " " + idx + " mc=" + minCost + " " + this.seekMinCostFor(vap, idx);
                this.extStructure().projectAndStack(vap, idx, minCost);
                assert (this.seekMinCostFor(vap, idx) == 0L || this.seekMinCostFor(vap, idx) == this.pb.solver.solManager.bestBound) : this + " " + this.seekMinCostFor(vap, idx);
            }
            minUnaryCost = Math.min(minUnaryCost, c1[idx]);
            idx = dom.next(idx);
        }
        return minUnaryCost;
    }

    public boolean findSupports() {
        long ub = this.pb.solver.solManager.bestBound;
        SetSparseMapLong variablesRequiringUnaryProjections = ((SoftAC2)this.softAC).getVariablesRequiringUnaryProjections();
        this.scanTable();
        for (int i = this.futvars.limit; i >= 0; --i) {
            Variable var = this.scp[this.futvars.dense[i]];
            long alpha = this.projectFrom(var);
            assert (alpha >= 0L) : alpha;
            if (Calculator.add(this.softAC.c0, alpha) >= ub) {
                return false;
            }
            if (alpha > 0L || this.projectionPerformed) {
                variablesRequiringUnaryProjections.add(var.num, alpha);
            }
            if (!this.projectionPerformed) continue;
            this.scanTable();
        }
        return true;
    }

    @Override
    protected long seekMinCostFrom(int[] tuple) {
        long cost;
        long ub;
        assert (this.isValid(tuple));
        long minCost = ub = this.pb.solver.solManager.bestBound;
        if (this.table instanceof SoftTableDelta) {
            ((SoftTableDelta)this.table).assertInCostOfIndexes = false;
        }
        while (((cost = this.costOfIdxs(tuple)) >= minCost || (minCost = cost) != 0L) && this.tupleManager.nextValidTuple() != -1) {
        }
        if (this.table instanceof SoftTableDelta) {
            ((SoftTableDelta)this.table).assertInCostOfIndexes = true;
        }
        return minCost;
    }

    public void display() {
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            int[] checkedTuple = this.table.getTuple(dense[i]);
            long cost = this.table.getCost(dense[i]);
            Kit.log.finer(Kit.join((Object)checkedTuple, new String[0]) + " c=" + cost + " " + this.isValid(checkedTuple));
        }
    }

    public int getNbSoftTuples() {
        int nbSoftTuples = 0;
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            if (this.table.getCost(dense[i]) <= 0L || this.table.getCost(dense[i]) >= this.pb.solver.solManager.bestBound) continue;
            ++nbSoftTuples;
        }
        return nbSoftTuples;
    }

    public int getNbHardTuples() {
        int nbHardTuples = 0;
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            if (this.table.getCost(dense[i]) != 0L && this.table.getCost(dense[i]) < this.pb.solver.solManager.bestBound) continue;
            ++nbHardTuples;
        }
        return nbHardTuples;
    }

    public int getNbAlmostHardTuples(int marge, long c0) {
        int nbAlmostHardTuples = 0;
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            if (!(this.table.getCost(dense[i]) > 0L && this.table.getCost(dense[i]) < this.pb.solver.solManager.bestBound && (long)marge >= this.pb.solver.solManager.bestBound || this.table.getCost(dense[i]) > 0L && this.table.getCost(dense[i]) < this.pb.solver.solManager.bestBound && this.table.getCost(dense[i]) <= (long)marge) && (this.table.getCost(dense[i]) <= 0L || this.table.getCost(dense[i]) >= this.pb.solver.solManager.bestBound || this.table.getCost(dense[i]) < this.pb.solver.solManager.bestBound - (long)marge)) continue;
            ++nbAlmostHardTuples;
        }
        return nbAlmostHardTuples;
    }

    public TreeMap<Long, Integer> getRepartition() {
        int nbOccPrec = 0;
        TreeMap<Long, Integer> nbTuplesByCost = new TreeMap<Long, Integer>();
        int[] dense = this.setOfTuples.dense;
        for (int i = this.setOfTuples.limit; i >= 0; --i) {
            if (nbTuplesByCost.containsKey(this.table.getCost(dense[i]))) {
                nbOccPrec = nbTuplesByCost.get(this.table.getCost(dense[i]));
                nbTuplesByCost.put(this.table.getCost(dense[i]), ++nbOccPrec);
                continue;
            }
            nbTuplesByCost.put(this.table.getCost(dense[i]), 1);
        }
        return nbTuplesByCost;
    }
}

