/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.primitive;

import constraints.hard.primitive.CtrPrimitiveBinaryCst;
import problem.Problem;
import utility.interfaces.TagSymmetric;
import variables.Variable;
import variables.domains.Domain;

public class DistNE
extends CtrPrimitiveBinaryCst
implements TagSymmetric {
    @Override
    public final boolean checkValues(int[] t) {
        return Math.abs(t[0] - t[1]) != this.k;
    }

    public DistNE(Problem pb, Variable x, Variable y, int k) {
        super(pb, x, y, k);
    }

    private boolean revise(Domain dom1, Domain dom2) {
        if (dom1.size() == 1) {
            return dom2.removeValue(dom1.uniqueValue() - this.k, false) && dom2.removeValue(dom1.uniqueValue() + this.k, false);
        }
        if (dom1.size() == 2 && dom1.lastValue() - dom1.firstValue() == 2 * this.k) {
            return dom2.removeValue(dom1.lastValue() - this.k, false);
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        if (!this.revise(this.dx, this.dy)) {
            return false;
        }
        return this.revise(this.dy, this.dx);
    }
}

