/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.SumAbstract;
import java.util.Arrays;
import java.util.stream.Stream;
import objectives.OptimizationCompatible;
import org.xcsp.common.Types;
import org.xcsp.modeler.definitions.DefXCSP;
import problem.Problem;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagSymmetric;
import variables.Variable;
import variables.domains.Domain;

public abstract class SumSimple
extends SumAbstract
implements TagSymmetric {
    @Override
    public final boolean checkValues(int[] t) {
        long sum = Kit.sum(t);
        switch (this.op) {
            case LE: {
                return sum <= this.limit;
            }
            case GE: {
                return sum >= this.limit;
            }
            case EQ: {
                return sum == this.limit;
            }
            case NE: {
                return sum != this.limit;
            }
        }
        throw new UnreachableCodeException();
    }

    public long minComputableObjectiveValue() {
        return Stream.of(this.scp).mapToLong(x -> x.dom.toVal(0)).sum();
    }

    public long maxComputableObjectiveValue() {
        return Stream.of(this.scp).mapToLong(x -> x.dom.toVal(x.dom.initSize() - 1)).sum();
    }

    public SumSimple(Problem pb, Variable[] scp, Types.TypeConditionOperatorRel op, long limit) {
        super(pb, scp, op, limit);
        this.defineKey(op, limit);
    }

    protected void recomputeBounds() {
        this.max = 0L;
        this.min = 0L;
        for (Variable x : this.scp) {
            this.min += (long)x.dom.firstValue();
            this.max += (long)x.dom.lastValue();
        }
    }

    protected final long currSum() {
        long sum = 0L;
        for (Variable x : this.scp) {
            sum += (long)x.dom.uniqueValue();
        }
        return sum;
    }

    public DefXCSP defXCSP() {
        return new DefXCSP(SUM).addSon(LIST, (Object)this.compactOrdered(this.scp)).addSon(CONDITION, (Object)("(" + this.getClass().getSimpleName().substring(9).toLowerCase() + "," + this.limit + ")"));
    }

    public static final class SumSimpleEQBoolean
    extends SumSimple
    implements TagGuaranteedGAC {
        public SumSimpleEQBoolean(Problem pb, Variable[] scp, long limit) {
            super(pb, scp, Types.TypeConditionOperatorRel.EQ, limit);
            Kit.control(Variable.areInitiallyBoolean(scp));
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            int cnt0 = 0;
            int cnt1 = 0;
            for (Variable y : this.scp) {
                if (y.dom.size() != 1) continue;
                if (y.dom.unique() == 0) {
                    ++cnt0;
                    continue;
                }
                ++cnt1;
            }
            int diff = this.scp.length - cnt0 - cnt1;
            if ((long)cnt1 > this.limit || (long)(cnt1 + diff) < this.limit) {
                return x.dom.fail();
            }
            if ((long)cnt1 < this.limit && (long)(cnt1 + diff) > this.limit) {
                return true;
            }
            if ((long)cnt1 == this.limit) {
                for (i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    dom.removeSafely(1);
                }
            } else {
                assert ((long)(cnt1 + diff) == this.limit);
                for (i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    dom.removeSafely(0);
                }
            }
            return true;
        }
    }

    public static final class SumSimpleNE
    extends SumSimple
    implements TagGuaranteedGAC {
        private Variable sentinel1;
        private Variable sentinel2;

        public SumSimpleNE(Problem pb, Variable[] scp, long limit) {
            super(pb, scp, Types.TypeConditionOperatorRel.NE, limit);
            Kit.control(scp.length >= 2 && !Arrays.stream(scp).anyMatch(x -> x.dom.size() == 1));
            this.sentinel1 = scp[0];
            this.sentinel2 = scp[scp.length - 1];
        }

        private Variable findAnotherSentinel() {
            for (Variable x : this.scp) {
                if (x == this.sentinel1 || x == this.sentinel2 || x.dom.size() <= 1) continue;
                return x;
            }
            return null;
        }

        private boolean filterDomainOf(Variable sentinel) {
            assert (sentinel.dom.size() > 1 && Stream.of(this.scp).filter(x -> x != sentinel).allMatch(x -> x.dom.size() == 1));
            long sum = 0L;
            for (Variable x2 : this.scp) {
                if (x2 == sentinel) continue;
                sum += (long)x2.dom.uniqueValue();
            }
            long v = this.limit - sum;
            if (sum + v == this.limit && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                sentinel.dom.removeValue((int)v, false);
            }
            return true;
        }

        @Override
        public boolean runPropagator(Variable x) {
            Variable y;
            if (this.sentinel1.dom.size() == 1) {
                y = this.findAnotherSentinel();
                if (y == null) {
                    return this.sentinel2.dom.size() == 1 ? this.currSum() != this.limit || x.dom.fail() : this.filterDomainOf(this.sentinel2);
                }
                this.sentinel1 = y;
            }
            if (this.sentinel2.dom.size() == 1) {
                y = this.findAnotherSentinel();
                if (y == null) {
                    return this.filterDomainOf(this.sentinel1);
                }
                this.sentinel2 = y;
            }
            return true;
        }
    }

    public static final class SumSimpleEQ
    extends SumSimple {
        private boolean guaranteedGAC;

        public SumSimpleEQ(Problem pb, Variable[] scp, long limit) {
            super(pb, scp, Types.TypeConditionOperatorRel.EQ, limit);
            this.guaranteedGAC = Stream.of(scp).allMatch(x -> x.dom.initSize() <= 2);
        }

        @Override
        public boolean isGuaranteedGAC() {
            return this.guaranteedGAC;
        }

        @Override
        public boolean runPropagator(Variable evt) {
            this.recomputeBounds();
            if (this.limit < this.min || this.max < this.limit) {
                return evt.dom.fail();
            }
            if (this.futvars.size() > 0) {
                int lastModified = this.futvars.limit;
                int i = this.futvars.limit;
                do {
                    Domain dom;
                    int sizeBefore;
                    if ((sizeBefore = (dom = this.scp[this.futvars.dense[i]].dom).size()) <= 1) continue;
                    this.min -= (long)dom.firstValue();
                    this.max -= (long)dom.lastValue();
                    if (!dom.removeValues(Types.TypeOperatorRel.LT, this.limit - this.max) || !dom.removeValues(Types.TypeOperatorRel.GT, this.limit - this.min)) {
                        return false;
                    }
                    if (sizeBefore != dom.size()) {
                        lastModified = i;
                    }
                    this.min += (long)dom.firstValue();
                    this.max += (long)dom.lastValue();
                } while (lastModified != (i = i > 0 ? i - 1 : this.futvars.limit));
            }
            assert (this.controlFCLevel());
            return true;
        }
    }

    public static class SumSimpleGE
    extends SumSimple
    implements TagGuaranteedGAC,
    OptimizationCompatible {
        @Override
        public long objectiveValue() {
            return this.currSum();
        }

        public SumSimpleGE(Problem pb, Variable[] scp, long limit) {
            super(pb, scp, Types.TypeConditionOperatorRel.GE, limit);
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (this.min >= this.limit) {
                return true;
            }
            if (this.max < this.limit) {
                return x.dom.fail();
            }
            for (int i = this.futvars.limit; i >= 0; --i) {
                Domain dom = this.scp[this.futvars.dense[i]].dom;
                if (dom.size() == 1) continue;
                this.min -= (long)dom.firstValue();
                dom.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)dom.lastValue()));
                assert (dom.size() > 0);
                this.min += (long)dom.firstValue();
                if (this.min < this.limit) continue;
                return true;
            }
            return true;
        }
    }

    public static class SumSimpleLE
    extends SumSimple
    implements TagGuaranteedGAC,
    OptimizationCompatible {
        @Override
        public long objectiveValue() {
            return this.currSum();
        }

        public SumSimpleLE(Problem pb, Variable[] scp, long limit) {
            super(pb, scp, Types.TypeConditionOperatorRel.LE, limit);
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (this.max <= this.limit) {
                return true;
            }
            if (this.min > this.limit) {
                return x.dom.fail();
            }
            for (int i = this.futvars.limit; i >= 0; --i) {
                Domain dom = this.scp[this.futvars.dense[i]].dom;
                if (dom.size() == 1) continue;
                this.max -= (long)dom.lastValue();
                dom.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)dom.firstValue()));
                assert (dom.size() > 0);
                this.max += (long)dom.lastValue();
                if (this.max > this.limit) continue;
                return true;
            }
            return true;
        }
    }
}

