/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import objectives.OptimizationCompatible;
import org.xcsp.common.Types;
import org.xcsp.modeler.definitions.DefXCSP;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.interfaces.TagUnguaranteedGAC;
import variables.Variable;

public final class NValuesLE
extends CtrGlobal
implements OptimizationCompatible,
TagUnguaranteedGAC,
TagPartialFilteringAtEachCall {
    private int limit;
    private Set<Integer> set;

    @Override
    public boolean checkValues(int[] t) {
        return Arrays.stream(t).distinct().count() <= (long)this.limit;
    }

    @Override
    public long minComputableObjectiveValue() {
        return 1L;
    }

    @Override
    public long maxComputableObjectiveValue() {
        return this.scp.length;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long newLimit) {
        Kit.control(Integer.MIN_VALUE <= newLimit && newLimit <= Integer.MAX_VALUE);
        this.limit = (int)newLimit;
    }

    @Override
    public long objectiveValue() {
        return Arrays.stream(this.scp).mapToInt(x -> x.dom.uniqueValue()).distinct().count();
    }

    public NValuesLE(Problem pb, Variable[] scp, int k) {
        super(pb, scp);
        this.limit = k;
        this.set = new HashSet<Integer>(Variable.setOfvaluesIn(scp).size());
        this.defineKey(k);
        Kit.control(1 <= k && k <= scp.length);
    }

    @Override
    public boolean runPropagator(Variable x) {
        if (x.dom.size() == 1) {
            this.set.clear();
            for (Variable y : this.scp) {
                if (y.dom.size() != 1) continue;
                this.set.add(y.dom.firstValue());
            }
            if (this.set.size() > this.limit) {
                return x.dom.fail();
            }
            boolean b = true;
            if (b && this.set.size() == this.limit) {
                for (int i = this.futvars.limit; i >= 0; --i) {
                    if (this.scp[this.futvars.dense[i]].dom.removeValues(Types.TypeConditionOperatorSet.IN, this.set)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public DefXCSP defXCSP() {
        return new DefXCSP(NVALUES).addSon(LIST, (Object)this.compact(this.scp)).addSon(CONDITION, (Object)("(le," + this.limit + ")"));
    }
}

