/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.NValuesAbstract;
import java.util.Arrays;
import objectives.OptimizationCompatible;
import org.xcsp.common.Types;
import org.xcsp.modeler.definitions.DefXCSP;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public abstract class NValues
extends NValuesAbstract
implements OptimizationCompatible {
    protected int limit;

    @Override
    public long minComputableObjectiveValue() {
        return 1L;
    }

    @Override
    public long maxComputableObjectiveValue() {
        return this.list.length;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(long newLimit) {
        Kit.control(Integer.MIN_VALUE <= newLimit && newLimit <= Integer.MAX_VALUE);
        this.limit = (int)newLimit;
    }

    @Override
    public long objectiveValue() {
        return Arrays.stream(this.scp).mapToInt(x -> x.dom.uniqueValue()).distinct().count();
    }

    public NValues(Problem pb, Variable[] list, int k) {
        super(pb, list, list);
        this.limit = k;
        this.defineKey(k);
        Kit.control(1 <= k && k <= list.length);
    }

    public DefXCSP defXCSP() {
        String operator = this instanceof NValuesLE ? "le" : "ge";
        return new DefXCSP(NVALUES).addSon(LIST, (Object)this.compact(this.list)).addSon(CONDITION, (Object)("(" + operator + "," + this.limit + ")"));
    }

    public static final class NValuesGE
    extends NValues {
        @Override
        public boolean checkValues(int[] t) {
            return Arrays.stream(t).distinct().count() >= (long)this.limit;
        }

        public NValuesGE(Problem pb, Variable[] list, int k) {
            super(pb, list, k);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (x.dom.size() == 1) {
                this.initializeSets();
                if (this.fixedVals.size() + this.unfixedVars.size() < this.limit) {
                    return x.dom.fail();
                }
                if (this.fixedVals.size() + this.unfixedVars.size() == this.limit) {
                    for (int i = this.unfixedVars.limit; i >= 0; --i) {
                        Domain dom = this.list[this.unfixedVars.dense[i]].dom;
                        if (dom.removeValues(Types.TypeConditionOperatorSet.IN, this.fixedVals)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static final class NValuesLE
    extends NValues {
        @Override
        public boolean checkValues(int[] t) {
            return Arrays.stream(t).distinct().count() <= (long)this.limit;
        }

        public NValuesLE(Problem pb, Variable[] list, int k) {
            super(pb, list, k);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (x.dom.size() == 1) {
                int i;
                this.fixedVals.clear();
                this.unfixedVars.clear();
                for (i = 0; i < this.list.length; ++i) {
                    if (this.list[i].dom.size() == 1) {
                        this.fixedVals.add(this.list[i].dom.firstValue());
                        continue;
                    }
                    this.unfixedVars.add(i);
                }
                if (this.fixedVals.size() > this.limit) {
                    return x.dom.fail();
                }
                if (this.fixedVals.size() == this.limit) {
                    for (i = this.unfixedVars.limit; i >= 0; --i) {
                        Domain dom = this.list[this.unfixedVars.dense[i]].dom;
                        if (dom.removeValues(Types.TypeConditionOperatorSet.NOTIN, this.fixedVals)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

