/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.Map;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.interfaces.TagUnsymmetric;
import variables.Variable;

public final class DistinctVectors2
extends CtrGlobal
implements TagUnsymmetric,
TagPartialFilteringAtEachCall,
ICtr.ICtrAllDifferent {
    private Variable[] list1;
    private Variable[] list2;
    private int sentinel1 = -1;
    private int sentinel2 = -1;
    private ManagerMultiOccurrences mm;

    @Override
    public boolean checkValues(int[] t) {
        if (this.mm != null) {
            for (int i = 0; i < this.list1.length; ++i) {
                if (t[this.mm.post1[i]] == t[this.mm.post2[i]]) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.list1.length; ++i) {
            if (t[i] == t[i + this.list1.length]) continue;
            return true;
        }
        return false;
    }

    public DistinctVectors2(Problem pb, Variable[] list1, Variable[] list2) {
        super(pb, (Variable[])pb.distinct(pb.vars(new Object[]{list1, list2})));
        Kit.control(list1.length == list2.length);
        this.list1 = list1;
        this.list2 = list2;
        this.sentinel1 = this.findAnotherSentinel();
        this.sentinel2 = this.findAnotherSentinel();
        Kit.control(this.sentinel1 != -1 && this.sentinel2 != -1, () -> "these particular cases not implemented yet");
        this.mm = this.scp.length != list1.length + list2.length ? new ManagerMultiOccurrences() : null;
    }

    @Override
    public boolean isGuaranteedGAC() {
        return this.mm == null;
    }

    private boolean isSentinel(int i) {
        return this.list1[i].dom.size() > 1 || this.list2[i].dom.size() > 1 || this.list1[i].dom.uniqueValue() != this.list2[i].dom.uniqueValue();
    }

    private boolean isPossibleInferenceFor(int sentinel) {
        return this.list1[sentinel].dom.size() == 1 && this.list2[sentinel].dom.size() > 1 || this.list1[sentinel].dom.size() > 1 && this.list2[sentinel].dom.size() == 1;
    }

    private void handlePossibleInferenceFor(int sentinel) {
        assert (this.isPossibleInferenceFor(sentinel));
        if (this.list1[sentinel].dom.size() == 1) {
            this.list2[sentinel].dom.removeValue(this.list1[sentinel].dom.uniqueValue(), false);
        } else {
            this.list1[sentinel].dom.removeValue(this.list2[sentinel].dom.uniqueValue(), false);
        }
    }

    private int findAnotherSentinel() {
        for (int i = 0; i < this.list1.length; ++i) {
            if (i == this.sentinel1 || i == this.sentinel2 || !this.isSentinel(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean runPropagator(Variable x) {
        if (x == this.list1[this.sentinel1] || x == this.list2[this.sentinel1]) {
            if (!this.isSentinel(this.sentinel1)) {
                int sentinel = this.findAnotherSentinel();
                if (sentinel != -1) {
                    this.sentinel1 = sentinel;
                } else {
                    if (this.list1[this.sentinel2].dom.size() > 1 && this.list2[this.sentinel2].dom.size() > 1) {
                        return true;
                    }
                    if (this.list1[this.sentinel2].dom.size() == 1 && this.list2[this.sentinel2].dom.size() == 1) {
                        return this.list1[this.sentinel2].dom.uniqueValue() != this.list2[this.sentinel2].dom.uniqueValue();
                    }
                    this.handlePossibleInferenceFor(this.sentinel2);
                }
            } else if (!this.isSentinel(this.sentinel2) && this.isPossibleInferenceFor(this.sentinel1)) {
                this.handlePossibleInferenceFor(this.sentinel1);
            }
            return true;
        }
        if (x == this.list1[this.sentinel2] || x == this.list2[this.sentinel2]) {
            if (!this.isSentinel(this.sentinel2)) {
                int sentinel = this.findAnotherSentinel();
                if (sentinel != -1) {
                    this.sentinel2 = sentinel;
                } else {
                    if (this.list1[this.sentinel1].dom.size() > 1 && this.list2[this.sentinel1].dom.size() > 1) {
                        return true;
                    }
                    if (this.list1[this.sentinel1].dom.size() == 1 && this.list2[this.sentinel1].dom.size() == 1) {
                        return this.list1[this.sentinel1].dom.uniqueValue() != this.list2[this.sentinel1].dom.uniqueValue();
                    }
                    this.handlePossibleInferenceFor(this.sentinel1);
                }
            } else if (!this.isSentinel(this.sentinel1) && this.isPossibleInferenceFor(this.sentinel2)) {
                this.handlePossibleInferenceFor(this.sentinel2);
            }
            return true;
        }
        return true;
    }

    public Map<String, Object> mapXCSP() {
        return IRootForCtrAndObj.map((String)"scope", (Object)this.scp, (String)"lists", (Object)new String[]{this.compactOrdered(this.list1), this.compactOrdered(this.list2)});
    }

    private class ManagerMultiOccurrences {
        int[] post1;
        int[] post2;

        ManagerMultiOccurrences() {
            this.post1 = IntStream.range(0, DistinctVectors2.this.list1.length).map(i -> Utilities.indexOf((Object)DistinctVectors2.this.list1[i], (Object[])DistinctVectors2.this.scp)).toArray();
            this.post2 = IntStream.range(0, DistinctVectors2.this.list2.length).map(i -> Utilities.indexOf((Object)DistinctVectors2.this.list2[i], (Object[])DistinctVectors2.this.scp)).toArray();
        }
    }
}

