/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.Table;
import dashboard.ControlPanel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import problem.ProblemStuff;
import utility.Kit;
import utility.operations.CombinatorOfTwoInts;
import utility.operations.mining.Miner;
import utility.operations.mining.MinerApriori;
import utility.operations.mining.MinerFPTree;
import variables.Variable;

public class TableSliced
extends Table {
    private static final DecimalFormat df = new DecimalFormat("####.##");
    public static long totalInitialSpace;
    public static long totalReducedSpace;
    public static Kit.Stopwatch stopwatch;
    public static long wck;
    private final int minimalSubtableSize = 10;
    private CombinatorOfTwoInts combinator;
    public Slice[] slices;

    private boolean isMatching(int[] item, int[] tuple) {
        for (int v : item) {
            if (tuple[this.combinator.leftValueIn(v)] == this.combinator.rightValueIn(v)) continue;
            return false;
        }
        return true;
    }

    private Slice buildRemainingSlice(int id, int[][] tuples, int currLimit) {
        if (currLimit == -1) {
            return null;
        }
        ArrayList<int[]> matchingTuples = new ArrayList<int[]>();
        for (int i = 0; i <= currLimit; ++i) {
            matchingTuples.add(tuples[i]);
        }
        return new Slice(id, new int[0], matchingTuples);
    }

    private Slice[] buildSlicesFrom(int[][] selectedItems) {
        int[][] tuples = Kit.cloneDeeply(this.tuples);
        int currLimit = tuples.length - 1;
        ArrayList<Slice> listOfSlices = new ArrayList<Slice>();
        int[] tuplesToBeRestored = new int[9];
        for (int i = selectedItems.length - 1; i >= 0; --i) {
            ArrayList<int[]> matchingTuples = new ArrayList<int[]>();
            int j = 0;
            while (j <= currLimit) {
                if (this.isMatching(selectedItems[i], tuples[j])) {
                    matchingTuples.add(tuples[j]);
                    if (matchingTuples.size() < tuplesToBeRestored.length) {
                        tuplesToBeRestored[matchingTuples.size() - 1] = j;
                    }
                    tuples[j] = tuples[currLimit--];
                    continue;
                }
                ++j;
            }
            if (matchingTuples.size() >= 10) {
                Kit.sort(selectedItems[i]);
                listOfSlices.add(new Slice(listOfSlices.size(), selectedItems[i], matchingTuples));
                continue;
            }
            for (j = matchingTuples.size() - 1; j >= 0; --j) {
                tuples[tuplesToBeRestored[j]] = (int[])matchingTuples.get(j);
                ++currLimit;
            }
        }
        Slice remainingSlice = this.buildRemainingSlice(listOfSlices.size(), tuples, currLimit);
        if (remainingSlice != null) {
            listOfSlices.add(remainingSlice);
        }
        return listOfSlices.toArray(new Slice[listOfSlices.size()]);
    }

    private void displayStatistics() {
        ProblemStuff.Repartitioner<Integer> subtableSizes = new ProblemStuff.Repartitioner<Integer>();
        ProblemStuff.Repartitioner<Integer> itemSizes = new ProblemStuff.Repartitioner<Integer>();
        long initialSpace = this.tuples.length * this.tuples[0].length;
        long reducedSpace = 0L;
        for (Slice piece : this.slices) {
            reducedSpace += (long)(piece.itemVariablePositions.length + piece.subtable.length * piece.subtableVariablePositions.length);
            subtableSizes.add(piece.subtable.length);
            itemSizes.add(piece.itemVariablePositions.length);
        }
        Kit.log.info("nbTuples=" + this.tuples.length + " initialSpace=" + initialSpace + " reducedSpace=" + reducedSpace + " compressionFactor=" + df.format((double)initialSpace / (double)reducedSpace));
        Kit.log.info("nbPieces=" + this.slices.length + " items=" + itemSizes + " subtables=" + subtableSizes + "\n");
        totalInitialSpace += initialSpace;
        totalReducedSpace += reducedSpace;
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        super.storeTuples(tuples, positive);
        ControlPanel cfg = this.firstRegisteredCtr().pb.rs.cp;
        if (stopwatch == null) {
            stopwatch = new Kit.Stopwatch();
        }
        stopwatch.start();
        int[] domainSizes = Variable.domSizeArrayOf(this.firstRegisteredCtr().scp, true);
        Miner miner = cfg.extension.miningApriori ? new MinerApriori(domainSizes, tuples, cfg.extension.miningThreshold) : new MinerFPTree(domainSizes, tuples, cfg.extension.miningThreshold);
        this.combinator = miner.combinator;
        this.slices = this.buildSlicesFrom(miner.getSelectedItems());
        wck += stopwatch.getWckTime();
        this.displayStatistics();
    }

    public TableSliced(Constraint ctr) {
        super(ctr);
    }

    public class Slice {
        public int id;
        public int[] itemVariablePositions;
        public int[] itemIndexes;
        public int[] subtableVariablePositions;
        public byte[][] subtable;

        private void setItemAndSubtable(int[] item, List<int[]> matchingTuples) {
            this.itemVariablePositions = new int[item.length];
            this.itemIndexes = new int[item.length];
            for (int i = 0; i < item.length; ++i) {
                this.itemVariablePositions[i] = TableSliced.this.combinator.leftValueIn(item[i]);
                this.itemIndexes[i] = TableSliced.this.combinator.rightValueIn(item[i]);
            }
            assert (Kit.isIncreasing(this.itemVariablePositions));
            int tableArity = matchingTuples.get(0).length - item.length;
            this.subtableVariablePositions = new int[tableArity];
            int i = 0;
            int j = 0;
            int pos = 0;
            while (i < this.subtableVariablePositions.length) {
                while (j < this.itemVariablePositions.length && pos == this.itemVariablePositions[j]) {
                    ++pos;
                    ++j;
                }
                this.subtableVariablePositions[i++] = pos++;
            }
            this.subtable = new byte[matchingTuples.size()][this.subtableVariablePositions.length];
            i = 0;
            for (int[] matchingTuple : matchingTuples) {
                for (int j2 = 0; j2 < this.subtableVariablePositions.length; ++j2) {
                    this.subtable[i][j2] = (byte)matchingTuple[this.subtableVariablePositions[j2]];
                }
                ++i;
            }
        }

        private Slice(int id, int[] item, List<int[]> matchingTuples) {
            this.id = id;
            this.setItemAndSubtable(item, matchingTuples);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(" Item : " + Kit.join((Object)this.itemVariablePositions, new String[0]) + " = " + Kit.join((Object)this.itemIndexes, new String[0]));
            sb.append("\nsubtable :\n " + Kit.join((Object)this.subtableVariablePositions, new String[0]) + "\n" + this.subtable.length + "\n");
            return sb.toString();
        }
    }
}

