/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.hard.extension.CtrExtensionSmart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import utility.Kit;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;
import variables.domains.DomainInteger;

public final class SmartTuple {
    private Variable[] scp;
    public int[] prefixWithValues;
    public int[] prefix;
    private RestrictionSimple[] restrictions;
    private SetSparse[] supportlesss;
    private int[] tmp;
    private RestrictionSimple[] whichRestrictions;
    private long valTime;
    private long supTime;
    public final List<XNodeParent<? extends IVar>> collectedTreeRestrictions;

    public SmartTuple(int[] tuple, List<XNodeParent<? extends IVar>> restrictions) {
        this.prefixWithValues = tuple;
        this.collectedTreeRestrictions = restrictions;
    }

    public SmartTuple(int[] tuple, Stream<XNodeParent<? extends IVar>> restrictions) {
        this(tuple, restrictions.collect(Collectors.toList()));
    }

    public SmartTuple(int[] tuple) {
        this(tuple, new ArrayList<XNodeParent<? extends IVar>>());
    }

    public SmartTuple(int[] tuple, XNodeParent<? extends IVar> r) {
        this(tuple, Arrays.asList(r));
    }

    public SmartTuple(int[] tuple, XNodeParent<? extends IVar> r1, XNodeParent<? extends IVar> r2) {
        this(tuple, Arrays.asList(r1, r2));
    }

    public SmartTuple(int[] tuple, XNodeParent<? extends IVar> r1, XNodeParent<? extends IVar> r2, XNodeParent<? extends IVar> r3) {
        this(tuple, Arrays.asList(r1, r2, r3));
    }

    public SmartTuple(int[] tuple, XNodeParent<? extends IVar> r1, XNodeParent<? extends IVar> r2, XNodeParent<? extends IVar> r3, XNodeParent<? extends IVar> r4) {
        this(tuple, Arrays.asList(r1, r2, r3, r4));
    }

    public SmartTuple(List<XNodeParent<? extends IVar>> restrictions) {
        this(null, restrictions);
    }

    public SmartTuple(Stream<XNodeParent<? extends IVar>> restrictions) {
        this(null, restrictions.collect(Collectors.toList()));
    }

    public SmartTuple(XNodeParent<? extends IVar> r) {
        this((int[])null, Arrays.asList(r));
    }

    public SmartTuple(XNodeParent<? extends IVar> r1, XNodeParent<? extends IVar> r2) {
        this((int[])null, Arrays.asList(r1, r2));
    }

    public SmartTuple(XNodeParent<? extends IVar> r1, XNodeParent<? extends IVar> r2, XNodeParent<? extends IVar> r3) {
        this((int[])null, Arrays.asList(r1, r2, r3));
    }

    public SmartTuple(XNodeParent<? extends IVar> r1, XNodeParent<? extends IVar> r2, XNodeParent<? extends IVar> r3, XNodeParent<? extends IVar> r4) {
        this((int[])null, Arrays.asList(r1, r2, r3, r4));
    }

    public RestrictionSimple buildRestrictionUnary(int x, Types.TypeConditionOperatorRel op, int v) {
        return op == Types.TypeConditionOperatorRel.LT ? new Rstr1LE(x, v, true) : (op == Types.TypeConditionOperatorRel.LE ? new Rstr1LE(x, v, false) : (op == Types.TypeConditionOperatorRel.GT ? new Rstr1GE(x, v, true) : (op == Types.TypeConditionOperatorRel.GE ? new Rstr1GE(x, v, false) : (op == Types.TypeConditionOperatorRel.NE ? new Rstr1NE(x, v) : new Rstr1EQ(x, v)))));
    }

    private SmartTuple addRestrictionUnary(Collection<RestrictionSimple> list, int x, Types.TypeConditionOperatorRel op, int v) {
        boolean storeEqualities = true;
        if (storeEqualities && op == Types.TypeConditionOperatorRel.EQ) {
            Kit.control(this.prefix[x] == 0x7FFFFFFE && this.scp[x].dom.isPresentValue(v), () -> " " + this.scp[x] + " " + this.prefix[x] + " " + 0x7FFFFFFE + " " + v + " " + this.scp[x].dom);
            this.prefix[x] = this.scp[x].dom.toIdx(v);
            return this;
        }
        list.add(op == Types.TypeConditionOperatorRel.LT ? new Rstr1LE(x, v, true) : (op == Types.TypeConditionOperatorRel.LE ? new Rstr1LE(x, v, false) : (op == Types.TypeConditionOperatorRel.GT ? new Rstr1GE(x, v, true) : (op == Types.TypeConditionOperatorRel.GE ? new Rstr1GE(x, v, false) : (op == Types.TypeConditionOperatorRel.NE ? new Rstr1NE(x, v) : null)))));
        return this;
    }

    private SmartTuple addRestrictionBinary(Collection<RestrictionSimple> list, int x, Types.TypeConditionOperatorRel op, int y) {
        list.add(op == Types.TypeConditionOperatorRel.LT ? new Rstr2L(x, y, true) : (op == Types.TypeConditionOperatorRel.LE ? new Rstr2L(x, y, false) : (op == Types.TypeConditionOperatorRel.GE ? new Rstr2G(x, y, false) : (op == Types.TypeConditionOperatorRel.GT ? new Rstr2G(x, y, true) : (op == Types.TypeConditionOperatorRel.NE ? new Rstr2NE(x, y) : (this.scp[0].dom.typeIdentifier() == this.scp[1].dom.typeIdentifier() ? new Rstr2EQ(x, y) : new Rstr2EQVal(x, y)))))));
        return this;
    }

    private SmartTuple addRestrictionBinary(Collection<RestrictionSimple> list, int x, Types.TypeConditionOperatorRel op, int y, int cst) {
        Rstr2pG restriction = null;
        if (op == Types.TypeConditionOperatorRel.GE) {
            restriction = new Rstr2pG(x, y, false, cst);
        } else if (op == Types.TypeConditionOperatorRel.GT) {
            restriction = new Rstr2pG(x, y, true, cst);
        } else {
            Kit.exit("Currently, unimplemented operator " + op);
        }
        list.add(restriction);
        return this;
    }

    public void attach(CtrExtensionSmart ctr) {
        this.scp = ctr.scp;
        this.prefixWithValues = this.prefixWithValues != null ? this.prefixWithValues : Kit.repeat(0x7FFFFFFE, this.scp.length);
        this.prefix = IntStream.range(0, this.scp.length).map(i -> this.prefixWithValues[i] == 0x7FFFFFFE ? 0x7FFFFFFE : this.scp[i].dom.toIdx(this.prefixWithValues[i])).toArray();
        this.supportlesss = ctr.unsupported;
        this.tmp = new int[Variable.maxInitDomSize(this.scp)];
        assert (Variable.areSortedDomainsIn(this.scp));
        ArrayList<RestrictionSimple> list = new ArrayList<RestrictionSimple>();
        for (XNodeParent<? extends IVar> tr : this.collectedTreeRestrictions) {
            Types.TypeConditionOperatorRel op;
            if (tr.sons.length != 2) continue;
            XNode son0 = tr.sons[0];
            XNode son1 = tr.sons[1];
            Utilities.control((son0.type == Types.TypeExpr.VAR ? 1 : 0) != 0, (String)"Left side operand must be a variable");
            Utilities.control((son1.type != Types.TypeExpr.SYMBOL ? 1 : 0) != 0, (String)"Symbolic values not possible for the moment");
            Variable x = (Variable)((XNodeLeaf)son0).value;
            if (son0.type == Types.TypeExpr.VAR && son1.type == Types.TypeExpr.LONG) {
                int val = Utilities.safeLong2Int((long)((Long)((XNodeLeaf)son1).value), (boolean)true);
                op = (Types.TypeConditionOperatorRel)Types.valueOf(Types.TypeConditionOperatorRel.class, (String)tr.type.lcname);
                this.addRestrictionUnary(list, ctr.positionOf(x), op, val);
                continue;
            }
            if (son0.type == Types.TypeExpr.VAR && son1.type == Types.TypeExpr.VAR) {
                Variable y = (Variable)((XNodeLeaf)son1).value;
                op = (Types.TypeConditionOperatorRel)Types.valueOf(Types.TypeConditionOperatorRel.class, (String)tr.type.lcname);
                this.addRestrictionBinary(list, ctr.positionOf(x), op, ctr.positionOf(y));
                continue;
            }
            if (son0.type == Types.TypeExpr.VAR && son1.type == Types.TypeExpr.ADD) {
                XNode[] grandSons = ((XNodeParent)son1).sons;
                if (grandSons.length == 2 && grandSons[0].type == Types.TypeExpr.VAR && grandSons[1].type == Types.TypeExpr.LONG) {
                    Variable y = (Variable)((XNodeLeaf)grandSons[0]).value;
                    int val = Utilities.safeLong2Int((long)((Long)((XNodeLeaf)grandSons[1]).value), (boolean)true);
                    Types.TypeConditionOperatorRel op2 = (Types.TypeConditionOperatorRel)Types.valueOf(Types.TypeConditionOperatorRel.class, (String)tr.type.lcname);
                    this.addRestrictionBinary(list, ctr.positionOf(x), op2, ctr.positionOf(y), val);
                    continue;
                }
                Kit.exit("Currently, unimplemented case");
                continue;
            }
            Kit.exit("Currently, unimplemented case");
        }
        int[] cnt1 = new int[this.scp.length];
        int[] cnt2 = new int[this.scp.length];
        list.stream().forEach(r -> {
            int n = r.x;
            cnt1[n] = cnt1[n] + 1;
        });
        list.stream().filter(r -> r instanceof Rstr2).forEach(r -> {
            int n = ((Rstr2)r).y;
            cnt2[n] = cnt2[n] + 1;
        });
        Map<Integer, List<RestrictionSimple>> byVap = list.stream().collect(Collectors.groupingBy(r -> r.x));
        this.restrictions = (RestrictionSimple[])byVap.entrySet().stream().map(e -> ((List)e.getValue()).size() == 1 ? (RestrictionSimple)((List)e.getValue()).get(0) : new RestrictionMultiple((Integer)e.getKey(), (List)e.getValue())).toArray(RestrictionSimple[]::new);
        this.whichRestrictions = new RestrictionSimple[this.scp.length];
        RestrictionSimple[] restrictionSimpleArray = this.restrictions;
        int n = restrictionSimpleArray.length;
        for (int j = 0; j < n; ++j) {
            RestrictionSimple r2;
            this.whichRestrictions[r2.x] = r2 = restrictionSimpleArray[j];
            if (r2 instanceof Rstr2) {
                this.whichRestrictions[((Rstr2)r2).y] = r2;
                continue;
            }
            if (!(r2 instanceof RestrictionMultiple)) continue;
            for (RestrictionSimple rr : ((RestrictionMultiple)r2).involvedRestrictions) {
                if (!(rr instanceof Rstr2)) continue;
                this.whichRestrictions[((Rstr2)rr).y] = r2;
            }
        }
    }

    public boolean contains(int[] t) {
        for (int i = 0; i < t.length; ++i) {
            if (this.prefix[i] == 0x7FFFFFFE || this.prefix[i] == t[i]) continue;
            return false;
        }
        for (RestrictionSimple restriction : this.restrictions) {
            if (restriction.checkIndexes(t)) continue;
            return false;
        }
        return true;
    }

    public final boolean isValid(int[] sVal, int sValSize) {
        ++this.valTime;
        for (int i = sValSize - 1; i >= 0; --i) {
            int a;
            int x = sVal[i];
            RestrictionSimple restriction = this.whichRestrictions[x];
            if (!(restriction == null ? (a = this.prefix[x]) != 0x7FFFFFFE && !this.scp[x].dom.isPresent(a) : restriction.valTimeLocal != this.valTime && !restriction.isValid())) continue;
            return false;
        }
        return true;
    }

    public final int collect(int[] sSup, int sSupSize) {
        ++this.supTime;
        for (int i = sSupSize - 1; i >= 0; --i) {
            int x = sSup[i];
            if (this.supportlesss[x].isEmpty()) {
                sSup[i] = sSup[--sSupSize];
                continue;
            }
            RestrictionSimple restriction = this.whichRestrictions[x];
            if (restriction == null) {
                int a = this.prefix[x];
                if (a == 0x7FFFFFFE) {
                    this.supportlesss[x].clear();
                } else {
                    this.supportlesss[x].remove(a);
                }
            } else if (restriction.supTimeLocal != this.supTime) {
                restriction.collect();
            }
            if (!this.supportlesss[x].isEmpty()) continue;
            sSup[i] = sSup[--sSupSize];
        }
        return sSupSize;
    }

    public String toString() {
        String s = "Smart tuple : ";
        s = s + (this.prefix == null ? "" : Kit.join((Object)this.prefix, i -> i == 0x7FFFFFFE ? "*" : i.toString(), new String[0]));
        boolean b = true;
        if (b) {
            return s + " : " + Stream.of(this.restrictions).map(r -> r.toString()).collect(Collectors.joining(", "));
        }
        s = s + "\n  " + this.restrictions.length + " restrictons : ";
        for (RestrictionSimple r2 : this.restrictions) {
            s = s + "\n    Restriction " + r2.toString() + " ";
        }
        for (int i2 = 0; i2 < this.whichRestrictions.length; ++i2) {
            if (this.whichRestrictions[i2] == null) continue;
            s = s + "\n    " + this.scp[i2] + " in restriction with vap " + this.whichRestrictions[i2].x + " ";
        }
        return s;
    }

    abstract class RestrictionStarStarConstant
    extends Rstr2 {
        protected int cst;

        protected RestrictionStarStarConstant(int x, int y, int cst) {
            super(x, y);
            this.cst = cst;
        }
    }

    final class RestrictionMultiple
    extends RestrictionSimple {
        protected RestrictionSimple[] involvedRestrictions;
        protected int cnt;

        protected RestrictionMultiple(int x, List<RestrictionSimple> restrictions) {
            super(x);
            this.involvedRestrictions = restrictions.toArray(new RestrictionSimple[restrictions.size()]);
            assert (Stream.of(this.involvedRestrictions).allMatch(r -> r.x == x));
        }

        @Override
        public boolean isValidFor(int a) {
            for (RestrictionSimple restriction : this.involvedRestrictions) {
                if (restriction.isValidFor(a)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            this.cnt = 0;
            int a = this.domx.first();
            while (a != -1) {
                if (this.isValidFor(a)) {
                    ((SmartTuple)SmartTuple.this).tmp[this.cnt++] = a;
                }
                a = this.domx.next(a);
            }
            return this.cnt > 0;
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            if (this.valTimeLocal != SmartTuple.this.valTime) {
                boolean valid = this.isValid();
                assert (valid);
            }
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                for (int i = 0; i < this.cnt; ++i) {
                    this.supportlessx.remove(SmartTuple.this.tmp[i]);
                }
            }
            for (RestrictionSimple restriction : this.involvedRestrictions) {
                if (!(restriction instanceof Rstr2)) continue;
                ((Rstr2)restriction).collectForVap2(this.cnt);
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            for (RestrictionSimple restriction : this.involvedRestrictions) {
                if (restriction.checkIndexes(t)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Stream.of(this.involvedRestrictions).map(r -> r.toString()).collect(Collectors.joining(", "));
        }
    }

    final class Rstr2pG
    extends Rstr2 {
        private boolean strict;
        private int cst;

        protected Rstr2pG(int x, int y, boolean strict, int cst) {
            super(x, y);
            this.strict = strict;
            this.cst = cst;
            Kit.control(((SmartTuple)SmartTuple.this).scp[x].dom instanceof DomainInteger.DomainRange && ((SmartTuple)SmartTuple.this).scp[y].dom instanceof DomainInteger.DomainRange);
        }

        @Override
        public boolean isValidFor(int a) {
            return this.strict ? a > this.domy.first() + this.cst : a >= this.domy.first() + this.cst;
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            return this.strict ? this.domx.last() > this.domy.first() + this.cst : this.domx.last() >= this.domy.first() + this.cst;
        }

        private void collectThroughInvalidValues() {
            int a;
            int cnt;
            int last1 = this.domx.last();
            int first2 = this.domy.first();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                cnt = 0;
                a = this.domx.first();
                while (a != -1 && (this.strict ? a <= first2 + this.cst : a < first2 + this.cst)) {
                    if (this.supportlessx.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domx.next(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                cnt = 0;
                a = this.domy.last();
                while (a != -1 && (this.strict ? a + this.cst >= last1 : a + this.cst > last1)) {
                    if (this.supportlessy.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domy.prev(a);
                }
                this.supportlessy.resetTo(SmartTuple.this.tmp, cnt);
            }
        }

        private void collectThroughSupportlessSets() {
            int a;
            int i;
            int last1 = this.domx.last();
            int first2 = this.domy.first();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                for (i = this.supportlessx.limit; i >= 0; --i) {
                    a = this.supportlessx.dense[i];
                    if (!(this.strict ? a > first2 + this.cst : a >= first2 + this.cst)) continue;
                    this.supportlessx.remove(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (i = this.supportlessy.limit; i >= 0; --i) {
                    a = this.supportlessy.dense[i];
                    if (!(this.strict ? last1 > a + this.cst : last1 >= a + this.cst)) continue;
                    this.supportlessy.remove(a);
                }
            }
        }

        private void collectThroughValidValues() {
            int a;
            int last1 = this.domx.last();
            int first2 = this.domy.first();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                a = this.domx.last();
                while (a != -1 && (this.strict ? a > first2 + this.cst : a >= first2 + this.cst)) {
                    this.supportlessx.remove(a);
                    a = this.domx.prev(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                a = this.domy.first();
                while (a != -1 && (this.strict ? last1 > a + this.cst : last1 >= a + this.cst)) {
                    this.supportlessy.remove(a);
                    a = this.domy.next(a);
                }
            }
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            int roughNbInvalidValues = Math.max(this.domy.first() + this.cst - this.domx.first(), 0) + Math.max(this.domy.last() + this.cst - this.domx.last(), 0);
            int nbSupportlessValues = this.supportlessx.size() + this.supportlessy.size();
            int roughNbValidValues = Math.min(this.domx.last(), this.domy.last()) + this.cst - this.domy.first() + this.domx.last() - Math.max(this.domx.first(), this.domy.first() + this.cst);
            if (roughNbInvalidValues < nbSupportlessValues && roughNbInvalidValues < roughNbValidValues) {
                this.collectThroughInvalidValues();
            } else if (nbSupportlessValues < roughNbValidValues) {
                this.collectThroughSupportlessSets();
            } else {
                this.collectThroughValidValues();
            }
        }

        @Override
        public void collectForVap2(int nb) {
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                int last1 = SmartTuple.this.tmp[nb - 1];
                int a = this.domy.first();
                while (a != -1 && (this.strict ? last1 > a + this.cst : last1 >= a + this.cst)) {
                    this.supportlessy.remove(a);
                    a = this.domy.next(a);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return this.strict ? t[this.x] > t[this.y] + this.cst : t[this.x] >= t[this.y] + this.cst;
        }

        @Override
        public String toString() {
            return SmartTuple.this.scp[this.x] + " " + this.getClass().getSimpleName().charAt(this.getClass().getSimpleName().length() - 1) + (this.strict ? "T" : "E") + " " + SmartTuple.this.scp[this.y] + " + " + this.cst;
        }
    }

    final class Rstr2EQVal
    extends Rstr2 {
        private int valResidue;
        boolean newResidue;

        protected Rstr2EQVal(int x, int y) {
            super(x, y);
        }

        @Override
        public boolean isValidFor(int a) {
            return this.domy.toPresentIdx(this.domx.toVal(a)) != -1;
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            this.newResidue = false;
            if (this.domx.toPresentIdx(this.valResidue) != -1 && this.domy.toPresentIdx(this.valResidue) != -1) {
                return true;
            }
            this.newResidue = true;
            Domain domSmall = this.domx.size() < this.domy.size() ? this.domx : this.domy;
            Domain domBig = domSmall == this.domx ? this.domy : this.domx;
            int a = domSmall.first();
            while (a != -1) {
                int v = domSmall.toVal(a);
                if (domBig.toPresentIdx(v) != -1) {
                    this.valResidue = v;
                    return true;
                }
                a = domSmall.next(a);
            }
            return false;
        }

        private void collectThroughRemovedValues() {
            int b;
            int v;
            int a;
            int cnt;
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                cnt = 0;
                a = this.domy.lastRemoved();
                while (a != -1) {
                    v = this.domy.toVal(a);
                    b = this.domx.toPresentIdx(v);
                    if (b != -1 && this.supportlessx.isPresent(b)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = b;
                    }
                    a = this.domy.prevRemoved(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                cnt = 0;
                a = this.domx.lastRemoved();
                while (a != -1) {
                    v = this.domx.toVal(a);
                    b = this.domy.toPresentIdx(v);
                    if (b != -1 && this.supportlessy.isPresent(b)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = b;
                    }
                    a = this.domx.prevRemoved(a);
                }
                this.supportlessy.resetTo(SmartTuple.this.tmp, cnt);
            }
        }

        private void collectThroughSmallestDomain() {
            block7: {
                Domain domBig;
                Domain domSmall;
                block8: {
                    block6: {
                        domSmall = this.domx.size() < this.domy.size() ? this.domx : this.domy;
                        Domain domain = domBig = domSmall == this.domx ? this.domy : this.domx;
                        if (SmartTuple.this.scp[this.x].isAssigned() || SmartTuple.this.scp[this.y].isAssigned()) break block6;
                        int a = domSmall.first();
                        while (a != -1) {
                            int v = domSmall.toVal(a);
                            int b = domBig.toPresentIdx(v);
                            if (b != -1) {
                                this.supportlessx.remove(domSmall == this.domx ? a : b);
                                this.supportlessy.remove(domSmall == this.domx ? b : a);
                            }
                            a = domSmall.next(a);
                        }
                        break block7;
                    }
                    if (SmartTuple.this.scp[this.x].isAssigned()) break block8;
                    int a = domSmall.first();
                    while (a != -1) {
                        int v = domSmall.toVal(a);
                        int b = domBig.toPresentIdx(v);
                        if (b != -1) {
                            this.supportlessx.remove(domSmall == this.domx ? a : b);
                        }
                        a = domSmall.next(a);
                    }
                    break block7;
                }
                if (SmartTuple.this.scp[this.y].isAssigned()) break block7;
                int a = domSmall.first();
                while (a != -1) {
                    int v = domSmall.toVal(a);
                    int b = domBig.toPresentIdx(v);
                    if (b != -1) {
                        this.supportlessy.remove(domSmall == this.domx ? b : a);
                    }
                    a = domSmall.next(a);
                }
            }
        }

        private void collectThroughSupportlessSets() {
            int b;
            int v;
            int a;
            int i;
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                for (i = this.supportlessx.limit; i >= 0; --i) {
                    a = this.supportlessx.dense[i];
                    v = this.domx.toVal(a);
                    b = this.domy.toPresentIdx(v);
                    if (b == -1) continue;
                    this.supportlessx.remove(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (i = this.supportlessy.limit; i >= 0; --i) {
                    a = this.supportlessy.dense[i];
                    v = this.domy.toVal(a);
                    b = this.domx.toPresentIdx(v);
                    if (b == -1) continue;
                    this.supportlessy.remove(a);
                }
            }
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            int nbRemovedValues = this.domx.nRemoved() + this.domy.nRemoved();
            int nbSupportlessValues = this.supportlessx.size() + this.supportlessy.size();
            int minDomainSize = Math.min(this.domx.size(), this.domy.size());
            if (nbRemovedValues < nbSupportlessValues && nbRemovedValues < minDomainSize) {
                this.collectThroughRemovedValues();
            } else if (nbSupportlessValues < minDomainSize) {
                this.collectThroughSupportlessSets();
            } else {
                this.collectThroughSmallestDomain();
            }
        }

        @Override
        public void collectForVap2(int nb) {
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (int i = 0; i < nb; ++i) {
                    int a = SmartTuple.this.tmp[i];
                    int v = this.domx.toVal(a);
                    int b = this.domy.toPresentIdx(v);
                    if (b == -1) continue;
                    this.supportlessy.remove(b);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return this.domx.toVal(t[this.x]) == this.domy.toVal(t[this.y]);
        }
    }

    final class Rstr2EQ
    extends Rstr2 {
        private int residue;
        private boolean newResidue;

        protected Rstr2EQ(int x, int y) {
            super(x, y);
        }

        @Override
        public boolean isValidFor(int a) {
            return this.domy.isPresent(a);
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            this.newResidue = false;
            if (this.domx.isPresent(this.residue) && this.domy.isPresent(this.residue)) {
                return true;
            }
            this.newResidue = true;
            Domain domSmall = this.domx.size() < this.domy.size() ? this.domx : this.domy;
            Domain domBig = domSmall == this.domx ? this.domy : this.domx;
            int a = domSmall.first();
            while (a != -1) {
                if (domBig.isPresent(a)) {
                    this.residue = a;
                    return true;
                }
                a = domSmall.next(a);
            }
            return false;
        }

        private void collectThroughRemovedValues() {
            int a;
            int cnt;
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                cnt = 0;
                a = this.domy.lastRemoved();
                while (a != -1) {
                    if (this.supportlessx.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domy.prevRemoved(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                cnt = 0;
                a = this.domx.lastRemoved();
                while (a != -1) {
                    if (this.supportlessy.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domx.prevRemoved(a);
                }
                this.supportlessy.resetTo(SmartTuple.this.tmp, cnt);
            }
        }

        private void collectThroughSmallestDomain() {
            block7: {
                int a;
                Domain domBig;
                Domain domSmall;
                block8: {
                    int a2;
                    block6: {
                        int a3;
                        domSmall = this.domx.size() < this.domy.size() ? this.domx : this.domy;
                        Domain domain = domBig = domSmall == this.domx ? this.domy : this.domx;
                        if (SmartTuple.this.scp[this.x].isAssigned() || SmartTuple.this.scp[this.y].isAssigned()) break block6;
                        int n = a3 = this.valTimeLocal == SmartTuple.this.valTime && this.newResidue ? this.residue : domSmall.first();
                        while (a3 != -1) {
                            if (domBig.isPresent(a3)) {
                                this.supportlessx.remove(a3);
                                this.supportlessy.remove(a3);
                            }
                            a3 = domSmall.next(a3);
                        }
                        break block7;
                    }
                    if (SmartTuple.this.scp[this.x].isAssigned()) break block8;
                    int n = a2 = this.valTimeLocal == SmartTuple.this.valTime && this.newResidue ? this.residue : domSmall.first();
                    while (a2 != -1) {
                        if (domBig.isPresent(a2)) {
                            this.supportlessx.remove(a2);
                        }
                        a2 = domSmall.next(a2);
                    }
                    break block7;
                }
                if (SmartTuple.this.scp[this.y].isAssigned()) break block7;
                int n = a = this.valTimeLocal == SmartTuple.this.valTime && this.newResidue ? this.residue : domSmall.first();
                while (a != -1) {
                    if (domBig.isPresent(a)) {
                        this.supportlessy.remove(a);
                    }
                    a = domSmall.next(a);
                }
            }
        }

        private void collectThroughSupportlessSets() {
            int a;
            int i;
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                for (i = this.supportlessx.limit; i >= 0; --i) {
                    a = this.supportlessx.dense[i];
                    if (!this.domy.isPresent(a)) continue;
                    this.supportlessx.remove(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (i = this.supportlessy.limit; i >= 0; --i) {
                    a = this.supportlessy.dense[i];
                    if (!this.domx.isPresent(a)) continue;
                    this.supportlessy.remove(a);
                }
            }
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            int nbRemovedValues = this.domx.nRemoved() + this.domy.nRemoved();
            int nbSupportlessValues = this.supportlessx.size() + this.supportlessy.size();
            int minDomainSize = Math.min(this.domx.size(), this.domy.size());
            if (nbRemovedValues < nbSupportlessValues && nbRemovedValues < minDomainSize) {
                this.collectThroughRemovedValues();
            } else if (nbSupportlessValues < minDomainSize) {
                this.collectThroughSupportlessSets();
            } else {
                this.collectThroughSmallestDomain();
            }
        }

        @Override
        public void collectForVap2(int nb) {
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (int i = 0; i < nb; ++i) {
                    this.supportlessy.remove(SmartTuple.this.tmp[i]);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return t[this.x] == t[this.y];
        }
    }

    final class Rstr2NE
    extends Rstr2 {
        protected Rstr2NE(int x, int y) {
            super(x, y);
        }

        @Override
        public boolean isValidFor(int a) {
            return this.domy.size() > 1 || a != this.domy.unique();
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            return this.domx.size() > 1 || this.domy.size() > 1 || this.domx.unique() != this.domy.unique();
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                if (this.domy.size() == 1 && this.supportlessx.isPresent(this.domy.unique())) {
                    this.supportlessx.resetTo(this.domy.unique());
                } else {
                    this.supportlessx.clear();
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                if (this.domx.size() == 1 && this.supportlessy.isPresent(this.domx.unique())) {
                    this.supportlessy.resetTo(this.domx.unique());
                } else {
                    this.supportlessy.clear();
                }
            }
        }

        @Override
        public void collectForVap2(int nb) {
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                if (nb == 1 && this.supportlessy.isPresent(SmartTuple.this.tmp[0])) {
                    this.supportlessy.resetTo(SmartTuple.this.tmp[0]);
                } else {
                    this.supportlessy.clear();
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return t[this.x] != t[this.y];
        }
    }

    final class Rstr2G
    extends Rstr2 {
        private boolean strict;

        protected Rstr2G(int x, int y, boolean strict) {
            super(x, y);
            this.strict = strict;
        }

        @Override
        public boolean isValidFor(int a) {
            return this.strict ? a > this.domy.first() : a >= this.domy.first();
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            return this.strict ? this.domx.last() > this.domy.first() : this.domx.last() >= this.domy.first();
        }

        private void collectThroughInvalidValues() {
            int a;
            int cnt;
            int last1 = this.domx.last();
            int first2 = this.domy.first();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                cnt = 0;
                a = this.domx.first();
                while (a != -1 && (this.strict ? a <= first2 : a < first2)) {
                    if (this.supportlessx.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domx.next(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                cnt = 0;
                a = this.domy.last();
                while (a != -1 && (this.strict ? a >= last1 : a > last1)) {
                    if (this.supportlessy.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domy.prev(a);
                }
                this.supportlessy.resetTo(SmartTuple.this.tmp, cnt);
            }
        }

        private void collectThroughSupportlessSets() {
            int a;
            int i;
            int last1 = this.domx.last();
            int first2 = this.domy.first();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                for (i = this.supportlessx.limit; i >= 0; --i) {
                    a = this.supportlessx.dense[i];
                    if (!(this.strict ? a > first2 : a >= first2)) continue;
                    this.supportlessx.remove(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (i = this.supportlessy.limit; i >= 0; --i) {
                    a = this.supportlessy.dense[i];
                    if (!(this.strict ? last1 > a : last1 >= a)) continue;
                    this.supportlessy.remove(a);
                }
            }
        }

        private void collectThroughValidValues() {
            int a;
            int last1 = this.domx.last();
            int first2 = this.domy.first();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                a = this.domx.last();
                while (a != -1 && (this.strict ? a > first2 : a >= first2)) {
                    this.supportlessx.remove(a);
                    a = this.domx.prev(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                a = this.domy.first();
                while (a != -1 && (this.strict ? last1 > a : last1 >= a)) {
                    this.supportlessy.remove(a);
                    a = this.domy.next(a);
                }
            }
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            int roughNbInvalidValues = Math.max(this.domy.first() - this.domx.first(), 0) + Math.max(this.domy.last() - this.domx.last(), 0);
            int nbSupportlessValues = this.supportlessx.size() + this.supportlessy.size();
            int roughNbValidValues = Math.min(this.domx.last(), this.domy.last()) - this.domy.first() + this.domx.last() - Math.max(this.domx.first(), this.domy.first());
            if (roughNbInvalidValues < nbSupportlessValues && roughNbInvalidValues < roughNbValidValues) {
                this.collectThroughInvalidValues();
            } else if (nbSupportlessValues < roughNbValidValues) {
                this.collectThroughSupportlessSets();
            } else {
                this.collectThroughValidValues();
            }
        }

        @Override
        public void collectForVap2(int nb) {
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                int last1 = SmartTuple.this.tmp[nb - 1];
                int a = this.domy.first();
                while (a != -1 && (this.strict ? last1 > a : last1 >= a)) {
                    this.supportlessy.remove(a);
                    a = this.domy.next(a);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return this.strict ? t[this.x] > t[this.y] : t[this.x] >= t[this.y];
        }

        @Override
        public String toString() {
            return SmartTuple.this.scp[this.x] + " " + this.getClass().getSimpleName().charAt(this.getClass().getSimpleName().length() - 1) + (this.strict ? "T" : "E") + " " + SmartTuple.this.scp[this.y];
        }
    }

    final class Rstr2L
    extends Rstr2 {
        private boolean strict;

        protected Rstr2L(int x, int y, boolean strict) {
            super(x, y);
            this.strict = strict;
        }

        @Override
        public boolean isValidFor(int a) {
            return this.strict ? a < this.domy.last() : a <= this.domy.last();
        }

        @Override
        public boolean isValid() {
            this.valTimeLocal = SmartTuple.this.valTime;
            return this.strict ? this.domx.first() < this.domy.last() : this.domx.first() <= this.domy.last();
        }

        private void collectThroughInvalidValues() {
            int a;
            int cnt;
            int first1 = this.domx.first();
            int last2 = this.domy.last();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                cnt = 0;
                a = this.domx.last();
                while (a != -1 && (this.strict ? a >= last2 : a > last2)) {
                    if (this.supportlessx.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domx.prev(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                cnt = 0;
                a = this.domy.first();
                while (a != -1 && (this.strict ? first1 >= a : first1 > a)) {
                    if (this.supportlessy.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domy.next(a);
                }
                this.supportlessy.resetTo(SmartTuple.this.tmp, cnt);
            }
        }

        private void collectThroughSupportlessSets() {
            int a;
            int i;
            int first1 = this.domx.first();
            int last2 = this.domy.last();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                for (i = this.supportlessx.limit; i >= 0; --i) {
                    a = this.supportlessx.dense[i];
                    if (!(this.strict ? a < last2 : a <= last2)) continue;
                    this.supportlessx.remove(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                for (i = this.supportlessy.limit; i >= 0; --i) {
                    a = this.supportlessy.dense[i];
                    if (!(this.strict ? first1 < a : first1 <= a)) continue;
                    this.supportlessy.remove(a);
                }
            }
        }

        private void collectThroughValidValues() {
            int a;
            int first1 = this.domx.first();
            int last2 = this.domy.last();
            if (!SmartTuple.this.scp[this.x].isAssigned()) {
                a = this.domx.first();
                while (a != -1 && (this.strict ? a < last2 : a <= last2)) {
                    this.supportlessx.remove(a);
                    a = this.domx.next(a);
                }
            }
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                a = this.domy.last();
                while (a != -1 && (this.strict ? first1 < a : first1 <= a)) {
                    this.supportlessy.remove(a);
                    a = this.domy.prev(a);
                }
            }
        }

        @Override
        public void collect() {
            this.supTimeLocal = SmartTuple.this.supTime;
            int roughNbInvalidValues = Math.max(this.domx.first() - this.domy.first(), 0) + Math.max(this.domx.last() - this.domy.last(), 0);
            int nSupportlessValues = this.supportlessx.size() + this.supportlessy.size();
            int roughNbValidValues = Math.min(this.domx.last(), this.domy.last()) - this.domx.first() + this.domy.last() - Math.max(this.domx.first(), this.domy.first());
            if (roughNbInvalidValues < nSupportlessValues && roughNbInvalidValues < roughNbValidValues) {
                this.collectThroughInvalidValues();
            } else if (nSupportlessValues < roughNbValidValues) {
                this.collectThroughSupportlessSets();
            } else {
                this.collectThroughValidValues();
            }
        }

        @Override
        public void collectForVap2(int nb) {
            if (!SmartTuple.this.scp[this.y].isAssigned()) {
                int first1 = SmartTuple.this.tmp[0];
                int a = this.domy.last();
                while (a != -1 && (this.strict ? first1 < a : first1 <= a)) {
                    this.supportlessy.remove(a);
                    a = this.domy.prev(a);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return this.strict ? t[this.x] < t[this.y] : t[this.x] <= t[this.y];
        }

        @Override
        public String toString() {
            return SmartTuple.this.scp[this.x] + " " + this.getClass().getSimpleName().charAt(this.getClass().getSimpleName().length() - 1) + (this.strict ? "T" : "E") + " " + SmartTuple.this.scp[this.y];
        }
    }

    abstract class Rstr2
    extends RestrictionSimple {
        protected int y;
        protected Domain domy;
        protected SetSparse supportlessy;

        protected Rstr2(int x, int y) {
            super(x);
            this.y = y;
            this.domy = ((SmartTuple)SmartTuple.this).scp[y].dom;
            this.supportlessy = SmartTuple.this.supportlesss[y];
            Kit.control(this.domx.typeIdentifier() == this.domy.typeIdentifier() || this instanceof Rstr2EQVal);
        }

        public abstract void collectForVap2(int var1);

        public String toString() {
            return SmartTuple.this.scp[this.x] + " " + this.getClass().getSimpleName().substring(this.getClass().getSimpleName().length() - 2) + " " + SmartTuple.this.scp[this.y];
        }
    }

    final class Rstr1EQ
    extends Rstr1 {
        protected Rstr1EQ(int x, int a) {
            super(x);
            this.pivot = this.domx.toIdx(a);
            Kit.control(this.pivot != -1, () -> "inconsistent restriction if the value does not belong to the domain");
        }

        protected Rstr1EQ(int x, String v) {
            super(x);
            this.pivot = ((DomainInteger.DomainSymbols)this.domx).toIdx(v);
            Kit.control(this.pivot != -1, () -> "inconsistent restriction if the value does not belong to the domain");
        }

        @Override
        public boolean isValidFor(int a) {
            return a == this.pivot;
        }

        @Override
        public boolean isValid() {
            return this.domx.isPresent(this.pivot);
        }

        @Override
        public void collect() {
            this.supportlessx.remove(this.pivot);
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return t[this.x] == this.pivot;
        }
    }

    final class Rstr1NE
    extends Rstr1 {
        protected Rstr1NE(int x, int v) {
            super(x);
            this.pivot = this.domx.toIdx(v);
            Kit.control(this.pivot != -1, () -> "useless restriction if the value does not belong to the domain");
        }

        protected Rstr1NE(int x, String v) {
            super(x);
            this.pivot = ((DomainInteger.DomainSymbols)this.domx).toIdx(v);
            Kit.control(this.pivot != -1, () -> "useless restriction if the value does not belong to the domain");
        }

        @Override
        public boolean isValidFor(int a) {
            return a != this.pivot;
        }

        @Override
        public boolean isValid() {
            return this.domx.size() > 1 || this.domx.unique() != this.pivot;
        }

        @Override
        public void collect() {
            boolean present = this.supportlessx.isPresent(this.pivot);
            this.supportlessx.clear();
            if (present) {
                this.supportlessx.add(this.pivot);
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return t[this.x] != this.pivot;
        }
    }

    final class Rstr1GE
    extends Rstr1 {
        protected Rstr1GE(int x, int v, boolean strict) {
            super(x);
            this.pivot = IntStream.range(0, this.domx.initSize()).filter(a -> this.domx.toVal(a) >= v + (strict ? 1 : 0)).findFirst().orElse(this.domx.initSize());
        }

        @Override
        public boolean isValidFor(int a) {
            return a >= this.pivot;
        }

        @Override
        public boolean isValid() {
            return this.domx.last() >= this.pivot;
        }

        @Override
        public void collect() {
            int roughNbValidValues = this.domx.last() - this.pivot;
            int roughNbInvalidValues = this.pivot - this.domx.first();
            if (roughNbInvalidValues < roughNbValidValues && roughNbInvalidValues < this.supportlessx.size()) {
                int cnt = 0;
                int a = this.domx.first();
                while (a != -1 && a < this.pivot) {
                    if (this.supportlessx.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domx.next(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            } else if (roughNbValidValues < this.supportlessx.size()) {
                int a = this.domx.last();
                while (a != -1 && a >= this.pivot) {
                    this.supportlessx.remove(a);
                    a = this.domx.prev(a);
                }
            } else {
                for (int i = this.supportlessx.limit; i >= 0; --i) {
                    int a = this.supportlessx.dense[i];
                    if (a < this.pivot) continue;
                    this.supportlessx.remove(a);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return t[this.x] >= this.pivot;
        }
    }

    final class Rstr1LE
    extends Rstr1 {
        protected Rstr1LE(int x, int v, boolean strict) {
            super(x);
            this.pivot = IntStream.range(0, this.domx.initSize()).map(a -> this.domx.initSize() - 1 - a).filter(a -> this.domx.toVal(a) <= v + (strict ? -1 : 0)).findFirst().orElse(-1);
        }

        @Override
        public boolean isValidFor(int a) {
            return a <= this.pivot;
        }

        @Override
        public boolean isValid() {
            return this.domx.first() <= this.pivot;
        }

        @Override
        public void collect() {
            int roughNbValidValues = this.pivot - this.domx.first();
            int roughNbInvalidValues = this.domx.last() - this.pivot;
            if (roughNbInvalidValues < roughNbValidValues && roughNbInvalidValues < this.supportlessx.size()) {
                int cnt = 0;
                int a = this.domx.last();
                while (a != -1 && a > this.pivot) {
                    if (this.supportlessx.isPresent(a)) {
                        ((SmartTuple)SmartTuple.this).tmp[cnt++] = a;
                    }
                    a = this.domx.prev(a);
                }
                this.supportlessx.resetTo(SmartTuple.this.tmp, cnt);
            } else if (roughNbValidValues < this.supportlessx.size()) {
                int a = this.domx.first();
                while (a != -1 && a <= this.pivot) {
                    this.supportlessx.remove(a);
                    a = this.domx.next(a);
                }
            } else {
                for (int i = this.supportlessx.limit; i >= 0; --i) {
                    int a = this.supportlessx.dense[i];
                    if (a > this.pivot) continue;
                    this.supportlessx.remove(a);
                }
            }
        }

        @Override
        public boolean checkIndexes(int[] t) {
            return t[this.x] <= this.pivot;
        }
    }

    abstract class Rstr1
    extends RestrictionSimple {
        protected int pivot;

        protected Rstr1(int x) {
            super(x);
        }

        public String toString() {
            return SmartTuple.this.scp[this.x] + " " + this.getClass().getSimpleName().substring(this.getClass().getSimpleName().length() - 2) + " " + ((SmartTuple)SmartTuple.this).scp[this.x].dom.toVal(this.pivot);
        }
    }

    public abstract class RestrictionSimple
    extends RestrictionAbstract {
        protected int x;
        protected Domain domx;
        protected SetSparse supportlessx;

        protected RestrictionSimple(int x) {
            this.x = x;
            this.domx = ((SmartTuple)SmartTuple.this).scp[x].dom;
            this.supportlessx = SmartTuple.this.supportlesss[x];
            Kit.control(SmartTuple.this.prefix[x] == 0x7FFFFFFE);
        }

        public abstract boolean isValidFor(int var1);
    }

    public abstract class RestrictionAbstract {
        protected long valTimeLocal;
        protected long supTimeLocal;

        public abstract boolean isValid();

        public abstract void collect();

        public abstract boolean checkIndexes(int[] var1);
    }
}

