/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.Table;
import java.util.Arrays;
import utility.Kit;
import variables.Variable;

public class NextEqNextDiff
extends Table {
    public int[][] firstEq;
    public int[][] nextEq;
    public int[][] nextDiff;
    public int[][] sizes;

    private void buildFirstNextEq() {
        int j;
        Constraint c = this.firstRegisteredCtr();
        this.firstEq = Variable.litterals(c.scp).intArray();
        for (int i = 0; i < this.firstEq.length; ++i) {
            block1: for (j = 0; j < this.firstEq[i].length; ++j) {
                this.firstEq[i][j] = -1;
                for (int k = 0; k < this.tuples.length; ++k) {
                    if (this.tuples[k][i] != j) continue;
                    this.firstEq[i][j] = k;
                    continue block1;
                }
            }
        }
        this.nextEq = new int[this.tuples.length][c.scp.length];
        int[] tmp = new int[Variable.maxInitDomSize(c.scp)];
        for (j = 0; j < c.scp.length; ++j) {
            Arrays.fill(tmp, -1);
            for (int i = this.tuples.length - 1; i >= 0; --i) {
                this.nextEq[i][j] = tmp[this.tuples[i][j]];
                tmp[this.tuples[i][j]] = i;
            }
        }
    }

    private void buildNextDiff() {
        Constraint c = this.firstRegisteredCtr();
        this.nextDiff = new int[this.tuples.length][c.scp.length];
        for (int j = 0; j < c.scp.length; ++j) {
            int nextTupleId = -1;
            int currIdx = -1;
            for (int i = this.tuples.length - 1; i >= 0; --i) {
                int k;
                if (this.tuples[i][j] == currIdx) {
                    this.nextDiff[i][j] = nextTupleId;
                    continue;
                }
                this.nextDiff[i][j] = k = i + 1 == this.tuples.length ? -1 : i + 1;
                nextTupleId = k;
                currIdx = this.tuples[i][j];
            }
        }
    }

    private void computeSizes() {
        Constraint c = this.firstRegisteredCtr();
        this.sizes = Variable.litterals(c.scp).intArray();
        for (int i = 0; i < this.firstEq.length; ++i) {
            for (int j = 0; j < this.firstEq[i].length; ++j) {
                int cnt = 0;
                int k = this.firstEq[i][j];
                while (k != -1) {
                    ++cnt;
                    k = this.nextEq[k][i];
                }
                this.sizes[i][j] = cnt;
            }
        }
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        super.storeTuples(tuples, positive);
        this.buildFirstNextEq();
        this.buildNextDiff();
        this.computeSizes();
    }

    public NextEqNextDiff(Constraint c) {
        super(c);
    }

    @Override
    public String toString() {
        return super.toString() + "\nfirstEq:\n" + Kit.join((Object)this.firstEq, new String[0]) + "\nnextEq\n" + Kit.join((Object)this.nextEq, new String[0]) + "\nnextDiff\n" + Kit.join((Object)this.nextDiff, new String[0]) + "\nsizes\n" + Kit.join((Object)this.sizes, new String[0]);
    }
}

