/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionMDDShort;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.MDDNodeShort;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import utility.Kit;
import variables.Variable;

public final class MDDShort
extends ExtensionStructureHard {
    public MDDNodeShort root;
    private Integer nNodes;
    private boolean reductionWhileProcessingTuples = false;
    private int nCreatedNodes = 2;

    public Integer nNodes() {
        return this.nNodes != null ? this.nNodes : (this.nNodes = Integer.valueOf(2 + this.root.nInternalNodes(new HashSet<Integer>())));
    }

    public int nextNodeId() {
        return this.nCreatedNodes++;
    }

    public MDDShort(CtrExtensionMDDShort c) {
        super(c);
    }

    public MDDShort(CtrExtensionMDDShort c, MDDNodeShort root) {
        this(c);
        this.root = root;
    }

    private MDDNodeShort recursiveReduction(MDDNodeShort node, Map<Kit.IntArrayHashKey, MDDNodeShort> reductionMap) {
        if (node.isLeaf()) {
            return node;
        }
        for (int i = 0; i < node.sons.length; ++i) {
            node.sons[i] = this.recursiveReduction(node.sons[i], reductionMap);
        }
        Kit.IntArrayHashKey hk = new Kit.IntArrayHashKey(Stream.of(node.sons).mapToInt(c -> c.id).toArray());
        return reductionMap.computeIfAbsent(hk, k -> node);
    }

    private void reduce(int[] prevTuple, int[] currTuple, Map<Kit.IntArrayHashKey, MDDNodeShort> reductionMap) {
        int v;
        int i = 0;
        MDDNodeShort node = this.root;
        while (prevTuple[i] == currTuple[i]) {
            v = prevTuple[i] == 0x7FFFFFFE ? node.sons.length - 1 : prevTuple[i];
            node = node.sons[v];
            ++i;
        }
        v = prevTuple[i] == 0x7FFFFFFE ? node.sons.length - 1 : prevTuple[i];
        node.sons[v] = this.recursiveReduction(node.sons[v], reductionMap);
    }

    private void finalizeStoreTuples() {
        this.root.buildSonsClasses();
        this.nNodes = this.root.renameNodes(1, new HashMap<Integer, MDDNodeShort>()) + 1;
        Kit.log.info("MDDShort : nNodes=" + this.nNodes + " nBuiltNodes=" + this.nCreatedNodes);
        assert (this.root.controlUniqueNodes(new HashMap<Integer, MDDNodeShort>()));
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        Kit.control(positive && tuples.length > 0);
        Constraint ctr = this.firstRegisteredCtr();
        int[] domainSizes = Variable.domSizeArrayOf(ctr.scp, true);
        HashMap<Kit.IntArrayHashKey, MDDNodeShort> reductionMap = new HashMap<Kit.IntArrayHashKey, MDDNodeShort>(2000);
        this.root = new MDDNodeShort(this, 0, domainSizes[0], positive);
        if (ctr.indexesMatchValues) {
            for (int i = 0; i < tuples.length; ++i) {
                this.root.addTuple(tuples[i], positive, domainSizes);
                if (!this.reductionWhileProcessingTuples || i <= 0) continue;
                this.reduce(tuples[i - 1], tuples[i], reductionMap);
            }
        } else {
            int[] previousTuple = null;
            int[] currentTuple = new int[tuples[0].length];
            for (int[] tuple : tuples) {
                for (int i = 0; i < currentTuple.length; ++i) {
                    currentTuple[i] = tuple[i] == 0x7FFFFFFE ? 0x7FFFFFFE : ctr.scp[i].dom.toIdx(tuple[i]);
                }
                this.root.addTuple(currentTuple, positive, domainSizes);
                if (!this.reductionWhileProcessingTuples) continue;
                if (previousTuple == null) {
                    previousTuple = (int[])currentTuple.clone();
                    continue;
                }
                this.reduce(previousTuple, currentTuple, reductionMap);
                int[] tmp = previousTuple;
                previousTuple = currentTuple;
                currentTuple = tmp;
            }
        }
        if (!this.reductionWhileProcessingTuples) {
            this.recursiveReduction(this.root, reductionMap);
        }
        this.finalizeStoreTuples();
    }

    private boolean checkIdxs(int[] t, int level, MDDNodeShort node) {
        if (node == MDDNodeShort.nodeT) {
            return true;
        }
        if (node == MDDNodeShort.nodeF) {
            return false;
        }
        return this.checkIdxs(t, level + 1, node.sons[t[level]]) || this.checkIdxs(t, level + 1, node.sons[node.sons.length - 1]);
    }

    @Override
    public boolean checkIdxs(int[] t) {
        return this.checkIdxs(t, 0, this.root);
    }

    public void displayTuples() {
        int cnt = this.root.displayTuples(Variable.buildDomainsArrayFor(this.firstRegisteredCtr().scp), new int[this.firstRegisteredCtr().scp.length], 0, 0);
        Kit.log.info(" => " + cnt + " tuples");
    }
}

