/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.hard.extension.structures.MDDNodeCDbef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xcsp.common.structures.Transitions;
import utility.Kit;

public final class MDDCDbef {
    public MDDNodeCDbef root;
    private Map<Integer, List<MDDNodeCDbef>> hashManager = new HashMap<Integer, List<MDDNodeCDbef>>(2000);

    public Integer nNodes() {
        return 2 + this.root.nInternalNodes(new HashSet<Integer>());
    }

    private MDDNodeCDbef recursiveReduction(MDDNodeCDbef node) {
        if (node.isLeaf()) {
            return node;
        }
        for (int key : node.sons.keySet()) {
            node.sons.put(key, this.recursiveReduction(node.sons.get(key)));
        }
        int[] t = node.signature();
        int hash = Arrays.hashCode(t);
        List<MDDNodeCDbef> list = this.hashManager.get(hash);
        if (list == null) {
            list = new ArrayList<MDDNodeCDbef>();
            list.add(node);
            this.hashManager.put(hash, list);
            return node;
        }
        for (MDDNodeCDbef n : list) {
            if (!Arrays.equals(t, n.signature())) continue;
            return n;
        }
        list.add(node);
        return node;
    }

    private void recursiveRenaming() {
        int nNodes = this.root.renameNodes(1, new HashMap<Integer, MDDNodeCDbef>()) + 1;
        Kit.log.info("MDD : nNodes=" + nNodes + " nBuiltNodes=" + MDDNodeCDbef.nBuiltNodes);
    }

    public MDDCDbef(int[] ... tuples) {
        this.root = new MDDNodeCDbef();
        for (int i = 0; i < tuples.length; ++i) {
            this.root.addTuple(tuples[i]);
        }
        this.recursiveReduction(this.root);
        this.recursiveRenaming();
    }

    public MDDCDbef(int uniqueValue) {
        this(new int[][]{{uniqueValue}});
    }

    public MDDCDbef(MDDCDbef f) {
        this.root = new MDDNodeCDbef(f.root, new HashMap<Integer, MDDNodeCDbef>());
        this.recursiveRenaming();
    }

    public MDDCDbef(MDDCDbef f1, MDDCDbef f2) {
        this.root = MDDNodeCDbef.or(0, f1.root, f2.root);
        System.out.println("nNodes1=" + this.nNodes());
        this.recursiveReduction(this.root);
        System.out.println("nNodes2=" + this.nNodes());
        this.recursiveRenaming();
    }

    public static MDDCDbef concat(MDDCDbef ... sequence) {
        int i;
        int offset = sequence[0].nNodes() - 2;
        for (i = 1; i < sequence.length; ++i) {
            sequence[i].root.renameNodeIds(offset, new HashMap<Integer, MDDNodeCDbef>());
            offset += sequence[i].nNodes() - 2;
        }
        for (i = 0; i < sequence.length - 1; ++i) {
            sequence[i].root.replaceTrueNode(sequence[i + 1].root);
        }
        return sequence[0];
    }

    public Transitions transitions() {
        Transitions trs = new Transitions();
        this.root.transitions(trs, new HashMap<Integer, MDDNodeCDbef>());
        return trs;
    }

    public void displayTuples() {
        int cnt = this.root.displayTuples(0, new ArrayList<Integer>());
        System.out.println("Cnt=" + cnt);
    }

    public static void main(String[] args) {
        int[][] tuples26 = new int[][]{{26}};
        int[][] tuples1 = new int[][]{{0}, {1}, {2}};
        int[][] tuples2 = new int[][]{{0, 0}, {1, 1}, {1, 2}, {2, 0}, {2, 2}};
        int[][] tuples3 = new int[][]{{0, 0, 1}, {0, 2, 1}, {1, 1, 0}, {1, 1, 2}, {2, 0, 1}, {2, 1, 1}};
        int[][] tuples4 = new int[][]{{0, 1, 1, 1}, {0, 1, 2, 1}, {1, 0, 1, 1}, {1, 0, 1, 2}, {1, 1, 0, 1}, {1, 1, 1, 0}};
        MDDCDbef f3 = new MDDCDbef(tuples3);
        MDDCDbef f26 = new MDDCDbef(tuples26);
        MDDCDbef f4 = new MDDCDbef(tuples4);
        MDDCDbef f = MDDCDbef.concat(new MDDCDbef(f3), new MDDCDbef(f26), new MDDCDbef(f4));
        f.displayTuples();
        MDDCDbef g = MDDCDbef.concat(new MDDCDbef(f4), new MDDCDbef(f26), new MDDCDbef(f3));
        g.displayTuples();
        MDDCDbef h = new MDDCDbef(f, g);
        h.displayTuples();
        h.root.display(0, new HashMap<Integer, MDDNodeCDbef>());
        int[][] tuplesor1 = new int[][]{{0, 0, 0, 0}, {0, 0, 1, 1}};
        int[][] tuplesor2 = new int[][]{{0, 1, 0, 0}, {0, 1, 1, 1}};
    }
}

