/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.hard.extension.structures.MDDNodeCD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xcsp.common.structures.Transitions;
import utility.Kit;

public final class MDDCD {
    public MDDNodeCD root;
    private Map<Integer, List<MDDNodeCD>> hashManager = new HashMap<Integer, List<MDDNodeCD>>(2000);
    private Integer nNodes;

    public static MDDCD copy(MDDCD mdd) {
        MDDCD m = new MDDCD(new int[0][]);
        m.root = MDDNodeCD.copy(mdd.root);
        return m;
    }

    public Integer nNodes() {
        return 2 + this.root.nInternalNodes(new HashSet<Integer>());
    }

    private MDDNodeCD recursiveReduction(MDDNodeCD node) {
        if (node.isLeaf()) {
            return node;
        }
        for (int i = 0; i < node.size; ++i) {
            int v = node.dense[i];
            node.insert(v, this.recursiveReduction(node.sons[v]));
        }
        int hash = node.signature();
        List list = this.hashManager.computeIfAbsent(hash, h -> new ArrayList());
        for (MDDNodeCD n : list) {
            if (!node.similarTo(n)) continue;
            return n;
        }
        list.add(node);
        return node;
    }

    public void recursiveRenaming() {
        int nNodes = this.root.renameNodes(1, new HashMap<Integer, MDDNodeCD>()) + 1;
        Kit.log.info("MDD : nNodes=" + nNodes + " nBuiltNodes=" + MDDNodeCD.nBuiltNodes);
    }

    public MDDCD(int[] ... tuples) {
        this.root = new MDDNodeCD();
        for (int[] tuple : tuples) {
            this.root.addTuple(tuple);
        }
        this.recursiveReduction(this.root);
        this.recursiveRenaming();
    }

    public MDDCD(int uniqueValue) {
        this(new int[][]{{uniqueValue}});
    }

    public MDDCD(MDDCD mdd) {
        this.root = new MDDNodeCD(mdd.root, new HashMap<Integer, MDDNodeCD>());
        this.recursiveRenaming();
    }

    public MDDCD(MDDCD mdd1, MDDCD mdd2) {
        this.root = MDDNodeCD.or(0, mdd1.root, mdd2.root);
        this.recursiveReduction(this.root);
        this.recursiveRenaming();
    }

    public static MDDCD concat(MDDCD ... sequence) {
        int i;
        int offset = sequence[0].nNodes() - 2;
        for (i = 1; i < sequence.length; ++i) {
            sequence[i].root.renameNodeIds(offset, new HashMap<Integer, MDDNodeCD>());
            offset += sequence[i].nNodes() - 2;
        }
        for (i = 0; i < sequence.length - 1; ++i) {
            sequence[i].root.replaceTrueNode(sequence[i + 1].root);
        }
        return sequence[0];
    }

    public Transitions transitions() {
        Transitions trs = new Transitions();
        this.root.transitions(trs, new HashMap<Integer, MDDNodeCD>());
        return trs;
    }

    public void displayTuples() {
        int cnt = this.root.displayTuples(0, new ArrayList<Integer>());
        System.out.println("Cnt=" + cnt);
    }
}

