/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.SegmentedTuple;
import constraints.hard.extension.structures.TableSplit;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import propagation.order1.StrongConsistency;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.TagGuaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetDenseReversible;
import utility.sets.SetSparse;
import variables.Variable;

public final class CtrExtensionSegmented
extends CtrExtension
implements FilteringGlobal,
TagGuaranteedGAC,
ObserverBacktrackingSystematic {
    private static final int UNINITIALIZED_VALUE = Integer.MAX_VALUE;
    protected int lastDepth;
    protected int[] lastSizes;
    protected int[][] lastSizesStack;
    public final SegmentedTuple[] segmentedTuples;
    protected SetDenseReversible set;
    public SetSparse[] unsupported;
    protected int sValSize;
    protected int[] sVal;
    protected int sSupSize;
    protected int[] sSup;
    protected long lastCallNode;

    protected void initRestorationStructuresBeforeFiltering() {
        int depth = this.pb.solver.depth();
        assert (depth >= this.lastDepth && this.lastDepth >= 0) : depth + " " + this.lastDepth;
        for (int i = this.lastDepth + 1; i <= depth; ++i) {
            System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.lastSizesStack[this.lastDepth].length);
        }
        this.lastSizes = this.lastSizesStack[depth];
        this.lastDepth = depth;
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.set.restoreLimitAtLevel(depthBeforeBacktrack);
        this.lastDepth = Math.max(0, Math.min(this.lastDepth, depthBeforeBacktrack - 1));
        for (int i = this.set.limit; i >= 0; --i) {
            SegmentedTuple splitTuple = this.segmentedTuples[this.set.dense[i]];
            for (SegmentedTuple.RestrictionTable restriction : splitTuple.restrictions) {
                restriction.restoreAtDepthBefore(depthBeforeBacktrack);
            }
        }
    }

    public CtrExtensionSegmented(Problem pb, Variable[] scp, SegmentedTuple ... splitTuples) {
        super(pb, scp);
        this.segmentedTuples = splitTuples;
        this.extStructure = this.buildExtensionStructure();
        this.unsupported = (SetSparse[])IntStream.range(0, scp.length).mapToObj(i -> new SetSparse(scp[i].dom.initSize(), true)).toArray(SetSparse[]::new);
        Stream.of(splitTuples).forEach(st -> st.attach(this));
        this.sVal = new int[scp.length];
        this.sSup = new int[scp.length];
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.set = new SetDenseReversible(this.segmentedTuples.length, this.pb.variables.length + 1);
        this.lastSizesStack = new int[this.pb.variables.length + 1][this.scp.length];
        Arrays.fill(this.lastSizesStack[0], Integer.MAX_VALUE);
        for (SegmentedTuple st : this.segmentedTuples) {
            for (SegmentedTuple.RestrictionTable rt : st.restrictions) {
                rt.onConstructionProblemFinished(this.pb);
            }
        }
    }

    @Override
    public ExtensionStructureHard buildExtensionStructure() {
        return new TableSplit(this, this.segmentedTuples);
    }

    protected void manageLastPastVariable() {
        if (this.lastCallNode != this.pb.solver.stats.nAssignments || this.pb.solver.propagation instanceof StrongConsistency) {
            int x;
            this.lastCallNode = this.pb.solver.stats.nAssignments;
            Variable lastPast = this.pb.solver.futVars.lastPast();
            int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
            if (x != -1) {
                this.sVal[this.sValSize++] = x;
            }
        }
    }

    protected void beforeFiltering() {
        this.initRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVariable();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            if (this.scp[x].dom.size() == this.lastSizes[x]) {
                this.unsupported[x].limit = this.lastSizes[x] - 1;
            } else {
                this.unsupported[x].clear();
                int a = this.scp[x].dom.first();
                while (a != -1) {
                    this.unsupported[x].add(a);
                    a = this.scp[x].dom.next(a);
                }
            }
            this.sSup[this.sSupSize++] = x;
            if (this.lastSizes[x] == this.scp[x].dom.size()) continue;
            this.sVal[this.sValSize++] = x;
            this.lastSizes[x] = this.scp[x].dom.size();
        }
    }

    protected boolean updateDomains() {
        for (int i = 0; i < this.sSupSize; ++i) {
            int x = this.sSup[i];
            assert (!this.unsupported[x].isEmpty());
            if (!this.scp[x].dom.remove(this.unsupported[x])) {
                return false;
            }
            this.unsupported[x].moveElementsAt(this.lastSizes[x] - 1);
            this.lastSizes[x] = this.scp[x].dom.size();
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            SegmentedTuple st = this.segmentedTuples[this.set.dense[i]];
            if (st.isValid(this.sVal, this.sValSize)) {
                this.sSupSize = st.collect(this.sSup, this.sSupSize);
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        if (this.set.size() == 0) {
            return false;
        }
        return this.updateDomains();
    }
}

