/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.Table;
import java.util.Arrays;
import problem.Problem;
import utility.Kit;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.TagGuaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetDenseReversible;
import variables.Variable;

public class CtrExtensionSTR1
extends CtrExtension
implements FilteringGlobal,
TagGuaranteedGAC,
ObserverBacktrackingSystematic {
    protected int[][] tuples;
    public SetDenseReversible set;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        if (this.set != null) {
            this.set.restoreLimitAtLevel(depthBeforeBacktrack);
        }
    }

    public CtrExtensionSTR1(Problem pb, Variable[] scp) {
        super(pb, scp);
        Kit.control(scp.length > 1, () -> "Arity must be at least 2");
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.tuples = ((Table)this.extStructure).tuples;
        this.set = new SetDenseReversible(this.tuples.length, this.pb.variables.length + 1);
        Kit.control(this.tuples.length > 0);
    }

    @Override
    protected ExtensionStructureHard buildExtensionStructure() {
        return new Table(this);
    }

    protected final void buildBasicCollectingStructures() {
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
    }

    @Override
    protected void initSpecificStructures() {
        this.buildBasicCollectingStructures();
    }

    protected void beforeFiltering() {
        this.cnt = 0;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            this.cnts[x] = this.doms[x].size();
            this.cnt += this.cnts[x];
            Arrays.fill(this.ac[x], false);
        }
    }

    protected boolean updateDomains() {
        for (int i = this.futvars.limit; i >= 0 && this.cnt > 0; --i) {
            int x = this.futvars.dense[i];
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.cnt -= nRemovals;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int j = this.futvars.limit; j >= 0; --j) {
                    int x = this.futvars.dense[j];
                    int a = tuple[x];
                    if (this.ac[x][a]) continue;
                    --this.cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return this.updateDomains();
    }
}

