/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import problem.Problem;
import utility.Kit;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagPositive;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetDenseReversible;
import variables.Variable;
import variables.domains.Domain;

public class CtrExtensionGAC4
extends CtrExtension
implements FilteringGlobal,
TagPositive,
TagGuaranteedGAC,
ObserverBacktrackingSystematic {
    protected int[][] ptrs;
    protected SetDenseReversible[][] sups;
    private int[] lastRemoved;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        for (int i = 0; i < this.sups.length; ++i) {
            for (int j = 0; j < this.sups[i].length; ++j) {
                if (this.sups[i][j] == null) continue;
                this.sups[i][j].restoreLimitAtLevel(depthBeforeBacktrack);
            }
        }
        Arrays.fill(this.lastRemoved, -1);
    }

    @Override
    protected ExtensionStructureHard buildExtensionStructure() {
        return new Table(this);
    }

    public CtrExtensionGAC4(Problem pb, Variable[] scp) {
        super(pb, scp);
        Kit.control(pb.rs.cp.solving.enablePrepro);
    }

    @Override
    public void onConstructionProblemFinished() {
        int j;
        int i2;
        super.onConstructionProblemFinished();
        this.lastRemoved = Kit.repeat(-1, this.scp.length);
        int[][] tuples = ((Table)this.extStructure).tuples;
        assert (tuples.length > 0);
        List[][] tmp = (List[][])IntStream.range(0, this.scp.length).mapToObj(i -> (List[])IntStream.range(0, this.scp[i].dom.initSize()).mapToObj(j -> new ArrayList()).toArray(List[]::new)).toArray(x$0 -> new List[x$0][]);
        this.ptrs = new int[tuples.length][this.scp.length];
        for (i2 = 0; i2 < tuples.length; ++i2) {
            for (j = 0; j < tuples[i2].length; ++j) {
                int a2 = tuples[i2][j];
                tmp[j][a2].add(i2);
                this.ptrs[i2][j] = tmp[j][a2].size() - 1;
            }
        }
        this.sups = new SetDenseReversible[this.scp.length][];
        for (i2 = 0; i2 < this.sups.length; ++i2) {
            this.sups[i2] = new SetDenseReversible[this.scp[i2].dom.initSize()];
            for (j = 0; j < this.sups[i2].length; ++j) {
                this.sups[i2][j] = new SetDenseReversible(Kit.intArray(tmp[i2][j]), true, this.pb.variables.length + 1);
            }
        }
        assert (this.controlStructures());
        for (i2 = 0; i2 < this.scp.length; ++i2) {
            Domain dom = this.scp[i2].dom;
            SetDenseReversible[] set = this.sups[i2];
            dom.execute(a -> {
                if (set[a].size() == 0) {
                    dom.removeValueAtConstructionTime(dom.toVal((int)a));
                }
            });
        }
    }

    private boolean handleVariableAt(int vap) {
        Domain dom = this.scp[vap].dom;
        int level = this.pb.solver.depth();
        int[][] tuples = ((Table)this.extStructure).tuples;
        int a = dom.lastRemoved();
        while (a != this.lastRemoved[vap]) {
            SetDenseReversible droppedSet = this.sups[vap][a];
            for (int j = droppedSet.limit; j >= 0; --j) {
                int droppedTuplePosition = droppedSet.dense[j];
                int[] tuple = tuples[droppedTuplePosition];
                assert (!this.isValid(tuple));
                for (int k = 0; k < this.scp.length; ++k) {
                    Domain domK = this.scp[k].dom;
                    if (!domK.isPresent(tuple[k])) continue;
                    SetDenseReversible set = this.sups[k][tuple[k]];
                    int ptr = this.ptrs[droppedTuplePosition][k];
                    if (ptr > set.limit) continue;
                    if (ptr < set.limit) {
                        int last = set.last();
                        assert (this.ptrs[last][k] == set.limit && set.dense[ptr] == droppedTuplePosition);
                        set.removeAtPosition(ptr, level);
                        this.ptrs[droppedTuplePosition][k] = set.limit + 1;
                        this.ptrs[last][k] = ptr;
                        assert (set.dense[set.limit + 1] == droppedTuplePosition && set.dense[ptr] == last);
                    } else {
                        set.moveLimitAtLevel(1, level);
                    }
                    if (set.size() != 0 || domK.remove(tuple[k])) continue;
                    return false;
                }
            }
            droppedSet.storeLimitAtLevel(level);
            droppedSet.clear();
            a = dom.prevRemoved(a);
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        Variable lastPast = this.pb.solver.futVars.lastPast();
        if (x == lastPast && !this.handleVariableAt(this.positionOf(x))) {
            return false;
        }
        for (i = this.futvars.limit; i >= 0; --i) {
            if (this.handleVariableAt(this.futvars.dense[i])) continue;
            return false;
        }
        for (i = this.futvars.limit; i >= 0; --i) {
            this.lastRemoved[this.futvars.dense[i]] = this.scp[this.futvars.dense[i]].dom.lastRemoved();
        }
        assert (this.controlStructures());
        return true;
    }

    private boolean controlStructures() {
        Table table = (Table)this.extStructure;
        int[][] tuples = table.tuples;
        for (int i = 0; i < this.ptrs.length; ++i) {
            int[] tuple = tuples[i];
            for (int vap = 0; vap < tuple.length; ++vap) {
                int ptr = this.ptrs[i][vap];
                if (this.sups[vap][tuple[vap]].dense[ptr] == i) continue;
                return false;
            }
        }
        return true;
    }
}

