# MYTABLE
A simple package for processing data in the form of a table.

Pay attention, *all indexes starts from 0 instead of 1*.

To install:
```shell
pip install mytable-lucien
```
To import:
```python
import mytable
```
## MYCSV
This is a simple reader and writer for CSV files by Lucien Shaw.
It consumes less resource and processes more quickly than the current csv module, though a lot less functional.

It reads CSV files as plain texts and stores the table in a list, whose elements are lists of cells of the current row. The list is the value to the key 'full' of a dict, which is the returned value of the function.

Here is the guidance.
### To import
```python
from mytable import mycsv
```
### Function: read()
Read a CSV file and store the table in a list.
- usage
```python
from mytable import mycsv
res = mycsv.read(filname, has_header, delimiter=',')
```
- arguments
  - filename
  
    A string value. The filename of the CSV file.
  - has_header
  
    A bool value. Whether the table has a header.
  - delimiter
  
    A char value. Comma by default. The character which is used to delimit the columns.
- returned value
  - dict
    - 'full'
    
        List of rows. Each row is a list of columns, aka. cells, which contains strings. 
    - 'data'
    
        Full table without header. Same as 'full' if there is no header.
    - 'has_header'
    
        A bool value. Whether the table has a header. Copied from the same argument.
    - 'columns'
    
        Total columns of the table.
    - 'rows'
    
        Total rows of the full table.
    - 'rows_data'
    
        Total rows of the table (without header row). Same as 'rows' if there is no header.
### Function: write()
Create a CSV file.
- usage
```python
from mytable import mycsv
mycsv.write(filename, table, delimiter=',')
```
- arguments
  - filename
    
    A string value. The filename of the CSV file be written.
  - table
  
    A list, the structure of which is the same as the value to the key 'full' of the returned dict of function read().
    
    All values shall be **strings**.
  - delimiter
  
    A char value. Comma by default. The character which is used to delimit the columns.
- returned value

  There is no returned value.
## MYTOOLS
Useful tools. Simple, but powerful.
### To import
```python
from mytable import mytools
```
### Function: excel_ctn()
All functions of this package use numbers as indexes, but Excel uses alphabets as indications of the columns, such as 'A' for column 0 (*We count from 0, remember?*), 'Z' for column 25, and 'AA' for column 26.

This converts the alphabetical column Characters To pure Numbers.
- usage
```python
res = excel_ctn(col)
```
- arguments
  - col

    Alphabetical column characters, such as 'A' or 'AA', etc.
- returned value
  
  A number, as mentioned above.
## MYVIEW
Provide a better view of the tables.
### Function: view_range()
In some circumstances, there are so many columns that they cannot be fully displayed in excel, and columns that exceed the limit cannot be visualized.

This allows you to specify the columns and rows to be seen and extract them to a new temporary CSV file so that they can be seen with your favorite table viewer, like Excel.
- usage
```python
view_range(table, columns=[], rows=[], filename='TempMytableFile.csv')
```
- arguments
  - table

    An original table in the form of a list.
  - columns
  
    A list of column numbers that indicate the columns you would like to see. The default value is an empty list, which selects all columns.
  - rows

    A list of row numbers that indicate the rows you would like to see. The default value is an empty list, which selects all rows.
  - filename

    The name of the temporary file. The default value is 'TempMytableFile.csv'.
### Function: select_range()
It is the same as function: view_range() but returns the selected table and does not generate the temporary file.
- usage
```python
res = select_range(table, columns=[], rows=[])
```
- arguments
Same as function: view_range() but no argument: filename.