#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query paraphraseSentence($sentence: String!, $count: Int! = 3) {
  callParaphraseSentence(input: $sentence, number_of_paraphrases: $count) {
    paraphrases
  }
}


"""
]


class paraphraseSentence:
    @dataclass(frozen=True)
    class paraphraseSentenceData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Paraphrase(DataClassJsonMixin):
            paraphrases: Optional[List[str]]

        callParaphraseSentence: Optional[Paraphrase]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, sentence: str, count: int) -> Optional[paraphraseSentenceData.Paraphrase]:
        variables: Dict[str, Any] = {"sentence": sentence, "count": count}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.paraphraseSentenceData.from_dict(response_text)
        return res.callParaphraseSentence

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, sentence: str, count: int) -> Optional[paraphraseSentenceData.Paraphrase]:
        variables: Dict[str, Any] = {"sentence": sentence, "count": count}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.paraphraseSentenceData.from_dict(response_text)
        return res.callParaphraseSentence
