#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query matchIntent(
  $input: String!
  $intent: [String!]!
  $threshold: Float! = 0.7
) {
  callMatchIntent(
    input: $input
    possible_intents: $intent
    similarity_threshold: $threshold
  ) {
    matches {
      intent: matched_intent
      confidence: similarity
      slots: word_matches {
        slot
        value: extracted_word
        match_type
        confidence: similarity
      }
    }
  }
}

"""
]


class matchIntent:
    @dataclass(frozen=True)
    class matchIntentData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class MatchIntentOutput(DataClassJsonMixin):
            @dataclass(frozen=True)
            class PhraseMatch(DataClassJsonMixin):
                @dataclass(frozen=True)
                class WordMatch(DataClassJsonMixin):
                    slot: Optional[str]
                    value: Optional[str]
                    match_type: Optional[str]
                    confidence: Optional[Number]

                intent: Optional[str]
                confidence: Optional[Number]
                slots: Optional[List[WordMatch]]

            matches: Optional[List[PhraseMatch]]

        callMatchIntent: Optional[MatchIntentOutput]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: str, intent: List[str] = [], threshold: Number) -> Optional[matchIntentData.MatchIntentOutput]:
        variables: Dict[str, Any] = {"input": input, "intent": intent, "threshold": threshold}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.matchIntentData.from_dict(response_text)
        return res.callMatchIntent

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: str, intent: List[str] = [], threshold: Number) -> Optional[matchIntentData.MatchIntentOutput]:
        variables: Dict[str, Any] = {"input": input, "intent": intent, "threshold": threshold}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.matchIntentData.from_dict(response_text)
        return res.callMatchIntent
