# Python MMPOS API Library and CLI tool
The MMPOS crypto mining platform has a REST API that allows us to make changes without using the GUI.
This python module brings the power of that API to a native python library and command line tool.

## Installation
If you don't use `pipx`, you're missing out.
Here are [installation instructions](https://pypa.github.io/pipx).

Simply run:

`pipx install . (For installing locally in isolated environment with pipx)`

Or

`pip3 install mmpos`


## Requirements
* Python 3.8+

It may work with older python versions, especially 3.x versions, but I am only testing 3.8+.  
## Features
* List rig data
* List gpu data
* List farm data
* List mining profiles
* Show data in either table or json formats
* Control a rig (disable, enable, reset, poweroff, ...)
* Control rig one at a time, everything all at once.  (Disable everything!)
* Simulate the control action if you are feeling worried. 
* Set mining profile 
* Use short ids to identify components of MMPOS
* Output json, plain and table format, pipe into other commands

## CLI Usage
To use it:

    $ mmpos --help


Each command allows you to list the data in json or table format.  The json output usually provides more output while the table is human readable and provides a subset of the total information.

All commands have `--json` and `--table`.  Use the `--help` to verify these switches work for that command.  

Examples:

```shell
$ mmpos --help
Usage: mmpos [OPTIONS] COMMAND [ARGS]...

Options:
  --help  Show this message and exit.

Commands:
  farms
  rigs

$ mmpos farms --help       
Usage: mmpos farms [OPTIONS] COMMAND [ARGS]...

Options:
  --help  Show this message and exit.

Commands:
  list

$ mmpos rigs --help
Usage: mmpos rigs [OPTIONS] COMMAND [ARGS]...

Options:
  --help  Show this message and exit.

Commands:
  control
  gpus
  list

$ mmpos rigs control --help
Usage: mmpos rigs control [OPTIONS]

Options:
  --rig_id TEXT                   The rig id, not required when using --all or
                                  --everywhere flags
  --farm_id TEXT                  The farm id, defaults to first farm found,
                                  use '--all' flag for all farms  [default:
                                  first]
  --all                           Run action on all rigs across the entire
                                  farm
  --everywhere                    Danger: Run action on all rigs across all
                                  farms
  --action [disable|poweroff|reset|enable|restart|reboot]
                                  [required]
  --simulate                      Simulate the action only
  --help                          Show this message and exit.
```

## Output Format
You can adjust the output format from the default table format to json output.  Table output will normally be shorter and the json will provide much greater detail.
## API Usage
I have built this with the intention of using the api in other areas of automation like ansible playbooks and such.  Usage should be pretty 
simple.  The API will change in the future as I build out the remaining MMPOS API calls. 

```
pip install mmpos
import mmpos.api.farms as farms
import mmpos.api.rigs as rigs

farms.get()
rigs.get()

```

## Notes
This is alpha quality, expect things to change, feature requests welcome as is any code contributions. 

* Most data is cached for 5 minutes to speed up future calls.  You will notice this when repeating calls. This can be controlled as the underlying mechanism is requests_cache library. 


### Using short ids
The MMPOS API uses long uuids as their identifiers.  This makes it annoying to work with on the CLI due to 36 character length.

As a result I have created a translation layer that will encode the uuid into 8 characters.  You can use this id for all commands.  Or you can also use the original uuid as well should you want to supply the 36 character id. Please note that the shorty id is only usable on this tool.  Although the formula for calculating can be implemented anywhere. 

This shortens the command considerably. 

example: `mmpos rigs set-profiles -r a3ea61dd -f cd371105 -p a44551e4`

vs 

 `./env/bin/mmpos rigs set-profiles --farm_id=ef86da23-0044-4530-b00d-124093cece80 --rig_id=85fbbe8d-6388-4b9e-8e2f-e897a7e7a6c5 --profile_ids=b49b6a13-e4ba-4991-a823-557f23754e80`

## Global switches
Some switches are only available at the global level.  You will need to put the switch after `mmpos` to use them.

ie.  `mmpos --json rigs list -f dksl39932`


```
Usage: mmpos [OPTIONS] COMMAND [ARGS]...

Options:
  --version                     Show the version and exit.
  --table                       Show table output
  --json                        Show json output
  --plain                       Show plain output
  --short-ids / --no-short-ids  Use short id instead of uuid from mmpos
                                [default: short-ids]
  --help                        Show this message and exit.

Commands:
  farms
  profiles
  rigs
```  
## Examples

```
# mmpos rigs list 
+--------------------------------------+--------------+---------------+-----------------------------------+---------------+
|                  id                  |     name     |    address    |              profiles             | agent_version |
+--------------------------------------+--------------+---------------+-----------------------------------+---------------+
| 365155f7-0425-4742-9465-7d8208464d51 | machine12345 |  192.168.0.1  |       ['etc_eth_ethermine']       |    v3.0.18    |
| 0fde950d-f321-4459-badd-9a7529dbe32b | machine22345 |  192.168.0.2  |       ['etchash_amd_normal']      |    v3.0.20    |
| 3fa0a53b-1bd9-4c09-91af-e134126c4219 | machine32345 |  192.168.0.3  |       ['etc_eth_ethermine']       |    v3.0.18    |
| 98d40b07-7090-42a8-8282-3e70e404d98c | machine42345 |  192.168.0.4  |       ['etc_eth_ethermine']       |    v3.0.19    |
| 5b00e155-ea64-414e-86af-2acc4e1ee716 | machine52345 |  192.168.0.5  |       ['etchash_amd_normal']      |    v3.0.19    |
+--------------------------------------+--------------+---------------+-----------------------------------+---------------+

# mmpos rigs gpus
+--------------+--------------------------+---------------+--------------------------------------+------------+
|   rig_name   |           name           |    address    |                gpu_id                |   pci_id   |
+--------------+--------------------------+---------------+--------------------------------------+------------+
| 0291ba94bb74 |    Radeon RX 5700 XT     |  192.168.0.1  | ef86da23-0044-4530-b00d-124093cece80 | 0000:0d:00 |
| 0291ba94bb74 | AMD Ryzen 7 3700X 8-Core |  192.168.0.1  | b49b6a13-e4ba-4991-a823-557f23754e80 | cpu0:08:10 |
|   super12    |    Radeon RX 6700 XT     |  192.168.0.2  | afa7b6b5-78da-436c-a3d9-c60d9dcdba73 | 0000:04:00 |
|   super12    |    Radeon RX 6700 XT     |  192.168.0.2  | 85fbbe8d-6388-4b9e-8e2f-e897a7e7a6c5 | 0000:07:00 |
+--------------+--------------------------+---------------+--------------------------------------+------------+



# mmpos rigs control --all --farm_id=first --action disable
+--------------+---------+
|   rig_name   |  action |
+--------------+---------+
|    machine1  | disable |
|    machine2  | disable |
|    machine3  | disable |
|    machine4  | disable |
+--------------+---------+

# mmpos rigs set-profiles -r xxxxxx -f xxxxxx -p xxxxxx -p xxxxxxxy (multiple -p will set multiple profiles)
```

