"""Coriolis matrix for Kinova Gen3 robot

Functions
---------
coriolis(joint_position, joint_velocity)

"""

import math
import numpy as np


def coriolis(joint_position, joint_velocity):
    """The Coriolis term of the Kinova Gen3 robot

    Arguments
    ---------
    joint_position (array_like): The joint angles of the robot [rad]
    joint_velocity (array_like): The joint velocities of the robot [rad/s]

    Returns
    -------
    ndarray:  The Coriolis term of the robot

    """

    x_0 = math.sin(joint_position[1])
    x_1 = joint_velocity[0] ** 2
    x_2 = x_0 * x_1
    x_3 = math.cos(joint_position[1])
    x_4 = 0.09958 * x_0
    x_5 = 4.4e-5 * x_3
    x_6 = -x_5
    x_7 = 0.00628344 * x_1
    x_8 = math.cos(joint_position[2])
    x_9 = x_8**2
    x_10 = 0.2104 * x_9
    x_11 = x_0 * x_10
    x_12 = math.sin(joint_position[2])
    x_13 = 0.0064 * x_3
    x_14 = x_0 * x_12
    x_15 = 0.2104 * x_14
    x_16 = -x_13 + x_15
    x_17 = x_12 * x_16
    x_18 = joint_velocity[0] * x_3
    x_19 = joint_velocity[1] * x_18
    x_20 = x_0**2 * x_1
    x_21 = -0.0064 * x_18
    x_22 = 0.2104 * joint_velocity[1] + x_21
    x_23 = 0.5 * joint_velocity[1]
    x_24 = 0.0032 * x_19 + 0.1052 * x_20 + x_22 * x_23
    x_25 = 0.0118 * x_0
    x_26 = 0.678 * joint_velocity[1]
    x_27 = 0.0043392 * x_19 + 0.1426512 * x_20 + x_22 * x_26
    x_28 = 0.0236 * x_0
    x_29 = joint_velocity[1] * x_22
    x_30 = 0.005952 * x_19 + 0.195672 * x_20 + 0.93 * x_29
    x_31 = 0.00744704 * x_19 + 0.24482144 * x_20 + 1.1636 * x_29
    x_32 = x_2 * x_3
    x_33 = 0.5861744 * x_32
    x_34 = 0.006641 * x_3
    x_35 = 0.117892 * x_0
    x_36 = x_12 * x_35 + x_34
    x_37 = x_12 * x_36
    x_38 = x_35 * x_8 + x_6
    x_39 = x_38 * x_8
    x_40 = x_18 * x_22
    x_41 = -0.1052 * x_19 + 0.0032 * x_20 - 0.5 * x_40
    x_42 = 0.2104 * x_0
    x_43 = -0.1426512 * x_19 + 0.0043392 * x_20 - 0.678 * x_40
    x_44 = -0.195672 * x_19 + 0.005952 * x_20 - 0.93 * x_40
    x_45 = 1.1636 * x_18
    x_46 = -0.24482144 * x_19 + 0.00744704 * x_20 - x_22 * x_45
    x_47 = x_0 * x_8
    x_48 = 0.0064 * x_47
    x_49 = 0.0128 * x_47
    x_50 = joint_velocity[0] * x_0
    x_51 = joint_velocity[1] * x_50
    x_52 = 4.4e-5 * joint_velocity[1]
    x_53 = 0.013278 * x_50 - x_52
    x_54 = 1.1636 * joint_velocity[1]
    x_55 = joint_velocity[0] * x_5
    x_56 = -joint_velocity[0] * x_4 + x_55
    x_57 = 0.09958 * joint_velocity[1] - 0.013278 * x_18
    x_58 = 1.1636 * x_50
    x_59 = 0.24482144 * x_32
    x_60 = 4.4e-5 * x_12
    x_61 = 0.006641 * x_8
    x_62 = -x_0 * x_60 - x_0 * x_61
    x_63 = 5.0e-6 * x_18
    x_64 = 0.011088 * x_50 + x_63
    x_65 = 0.011255 * joint_velocity[1] - 0.000691 * x_18
    x_66 = 5.0e-6 * x_50
    x_67 = -0.000691 * joint_velocity[1] + 0.001072 * x_18 + x_66
    x_68 = 5.11984e-5 * joint_velocity[1]
    x_69 = x_50 * x_68
    x_70 = 0.115871288 * joint_velocity[1]
    x_71 = -x_11 - x_17
    x_72 = 2 * x_43
    x_73 = math.sin(joint_position[3])
    x_74 = x_3 * x_73
    x_75 = 0.2084 * x_74
    x_76 = 0.2084 * x_8
    x_77 = math.cos(joint_position[3])
    x_78 = x_0 * x_77
    x_79 = x_76 * x_78
    x_80 = -x_75 - x_79
    x_81 = x_8 * x_80
    x_82 = x_13 * x_73
    x_83 = x_47 * x_77
    x_84 = 0.0064 * x_83
    x_85 = x_82 + x_84
    x_86 = x_73 * x_85
    x_87 = x_12 * x_86
    x_88 = 0.2084 * x_14
    x_89 = x_13 * x_77
    x_90 = x_47 * x_73
    x_91 = 0.0064 * x_90
    x_92 = x_88 - x_89 + x_91
    x_93 = x_77 * x_92
    x_94 = x_12 * x_93
    x_95 = 0.0100224 * x_1
    x_96 = x_73 * x_92 + x_77 * x_85
    x_97 = 2 * x_96
    x_98 = 0.3905024 * x_32
    x_99 = 1.8e-5 * x_14
    x_100 = 0.015006 * x_74
    x_101 = 0.015006 * x_83
    x_102 = x_100 + x_101 - x_99
    x_103 = 0.075478 * x_14
    x_104 = x_3 * x_77
    x_105 = 0.015006 * x_104
    x_106 = 0.015006 * x_90
    x_107 = x_103 - x_105 + x_106
    x_108 = x_102 * x_77 + x_107 * x_73
    x_109 = joint_velocity[1] * x_12
    x_110 = joint_velocity[2] * x_109
    x_111 = x_109 * x_18
    x_112 = x_50 * x_8
    x_113 = joint_velocity[2] * x_112
    x_114 = joint_velocity[2] + x_18
    x_115 = -0.2104 * x_109 + 0.2104 * x_112
    x_116 = x_114 * x_115
    x_117 = joint_velocity[1] * x_8
    x_118 = x_12 * x_50
    x_119 = -x_117 - x_118
    x_120 = 0.0064 * x_109
    x_121 = 0.0064 * x_112 - x_120
    x_122 = x_119 * x_121
    x_123 = (
        -0.1052 * x_110
        + 0.1052 * x_111
        + 0.1052 * x_113
        - 0.5 * x_116
        + 0.5 * x_122
        + 0.0032 * x_51
    )
    x_124 = 0.0054 * x_3
    x_125 = x_124 * x_8
    x_126 = (
        -0.1426512 * x_110
        + 0.1426512 * x_111
        + 0.1426512 * x_113
        - 0.678 * x_116
        + 0.678 * x_122
        + 0.0043392 * x_51
    )
    x_127 = x_126 * x_8
    x_128 = 0.0108 * x_3
    x_129 = (
        -0.195672 * x_110
        + 0.195672 * x_111
        + 0.195672 * x_113
        - 0.93 * x_116
        + 0.93 * x_122
        + 0.005952 * x_51
    )
    x_130 = joint_velocity[2] * x_117
    x_131 = x_117 * x_18
    x_132 = joint_velocity[2] * x_118
    x_133 = -x_109 + x_112
    x_134 = 0.5 * x_133
    x_135 = -0.0064 * joint_velocity[2] + 0.2104 * x_117 + 0.2104 * x_118 + x_21
    x_136 = 0.5 * x_135
    x_137 = (
        x_114 * x_136 - x_121 * x_134 - 0.1052 * x_130 + 0.1052 * x_131 - 0.1052 * x_132
    )
    x_138 = 0.2104 * x_47
    x_139 = x_12 * x_124
    x_140 = x_121 * x_133
    x_141 = x_114 * x_135
    x_142 = (
        -0.1426512 * x_130
        + 0.1426512 * x_131
        - 0.1426512 * x_132
        - 0.678 * x_140
        + 0.678 * x_141
    )
    x_143 = 0.4208 * x_47
    x_144 = x_12 * x_128
    x_145 = (
        -0.195672 * x_130
        + 0.195672 * x_131
        - 0.195672 * x_132
        - 0.93 * x_140
        + 0.93 * x_141
    )
    x_146 = math.cos(joint_position[4])
    x_147 = x_146 * x_8
    x_148 = math.sin(joint_position[4])
    x_149 = x_12 * x_148
    x_150 = x_149 * x_77
    x_151 = x_147 - x_150
    x_152 = x_146 * x_74
    x_153 = 0.1059 * x_152
    x_154 = x_147 * x_77
    x_155 = -x_149 + x_154
    x_156 = x_0 * x_155
    x_157 = 0.1059 * x_156
    x_158 = x_153 + x_157
    x_159 = x_148 * x_8
    x_160 = x_12 * x_146
    x_161 = x_160 * x_77
    x_162 = x_159 + x_161
    x_163 = x_148 * x_74
    x_164 = 0.1059 * x_163
    x_165 = x_159 * x_77
    x_166 = -x_160 - x_165
    x_167 = x_0 * x_166
    x_168 = x_164 - 0.1059 * x_167
    x_169 = 0.0063612 * x_1
    x_170 = (
        x_115 * x_134 - x_119 * x_136 - 0.0032 * x_130 + 0.0032 * x_131 - 0.0032 * x_132
    )
    x_171 = x_115 * x_133
    x_172 = x_119 * x_135
    x_173 = (
        -0.0043392 * x_130
        + 0.0043392 * x_131
        - 0.0043392 * x_132
        + 0.678 * x_171
        - 0.678 * x_172
    )
    x_174 = (
        -0.005952 * x_130
        + 0.005952 * x_131
        - 0.005952 * x_132
        + 0.93 * x_171
        - 0.93 * x_172
    )
    x_175 = 2 * x_126
    x_176 = x_107 * x_77
    x_177 = x_12 * x_176
    x_178 = x_102 * x_73
    x_179 = x_12 * x_178
    x_180 = 0.075478 * x_74
    x_181 = 1.8e-5 * x_104
    x_182 = 1.8e-5 * x_8
    x_183 = x_182 * x_73
    x_184 = x_0 * x_183
    x_185 = 0.075478 * x_8
    x_186 = x_185 * x_78
    x_187 = -x_180 + x_181 - x_184 - x_186
    x_188 = x_187 * x_8
    x_189 = 0.005022 * x_1
    x_190 = -x_13 * x_8 + x_15
    x_191 = x_12 * x_13
    x_192 = x_138 + x_191
    x_193 = 2 * x_142
    x_194 = x_75 + x_79
    x_195 = 0.195672 * x_32
    x_196 = x_148 * x_158
    x_197 = x_146 * x_168
    x_198 = -x_196 * x_73 + x_197 * x_73
    x_199 = 0.2478512 * x_32
    x_200 = x_81 + x_87 - x_94
    x_201 = 0.1371791312 * joint_velocity[2]
    x_202 = 0.1371791312 * x_18
    x_203 = (
        joint_velocity[0] * x_34
        + 0.006641 * joint_velocity[2]
        + 0.117892 * x_117
        + 0.117892 * x_118
    )
    x_204 = 1.1636 * x_114
    x_205 = 0.006641 * x_109 - x_50 * x_60 - x_50 * x_61 - x_52 * x_8
    x_206 = 1.1636 * x_205
    x_207 = (
        -x_117 * x_201
        + x_117 * x_202
        - x_118 * x_201
        - x_133 * x_206
        + x_203 * x_204
        + x_69
    )
    x_208 = x_12 * x_207
    x_209 = -4.4e-5 * joint_velocity[2] - 0.117892 * x_109 + 0.117892 * x_112 - x_55
    x_210 = (
        -x_109 * x_201
        + x_109 * x_202
        + x_112 * x_201
        + x_119 * x_206
        - x_204 * x_209
        - 0.0077274676 * x_51
    )
    x_211 = x_210 * x_8
    x_212 = joint_velocity[2] * x_133
    x_213 = 7.0e-6 * joint_velocity[2]
    x_214 = 7.0e-6 * x_18
    x_215 = -0.010932 * x_109 + 0.010932 * x_112 - x_213 - x_214
    x_216 = (
        0.001043 * joint_velocity[2]
        + 7.0e-6 * x_109
        - 7.0e-6 * x_112
        - 0.000606 * x_117
        - 0.000606 * x_118
        + 0.001043 * x_18
    )
    x_217 = (
        -0.011127 * x_111
        + x_114 * x_215
        - x_133 * x_216
        - 0.011127 * x_212
        - 0.000606 * x_51
    )
    x_218 = joint_velocity[2] * x_119
    x_219 = 0.000606 * joint_velocity[2]
    x_220 = 0.000606 * x_18
    x_221 = -0.011127 * x_117 - 0.011127 * x_118 + x_219 + x_220
    x_222 = (
        -x_114 * x_221
        + x_119 * x_216
        + 0.010932 * x_131
        + 0.010932 * x_218
        + 7.0e-6 * x_51
    )
    x_223 = -x_147 + x_150
    x_224 = -x_159 - x_161
    x_225 = x_158 * x_223 + x_168 * x_224
    x_226 = (
        5.11984e-5 * x_110
        - 5.11984e-5 * x_111
        - 5.11984e-5 * x_113
        - 1.1636 * x_119 * x_203
        + 0.0077274676 * x_130
        - 0.0077274676 * x_131
        + 0.0077274676 * x_132
        + 1.1636 * x_133 * x_209
    )
    x_227 = math.cos(joint_position[5])
    x_228 = x_159 * x_227
    x_229 = math.sin(joint_position[5])
    x_230 = x_229 * x_73
    x_231 = x_227 * x_77
    x_232 = x_146 * x_231
    x_233 = -x_230 + x_232
    x_234 = x_12 * x_233
    x_235 = x_228 + x_234
    x_236 = x_160 + x_165
    x_237 = x_0 * x_236
    x_238 = x_164 + 0.1059 * x_237
    x_239 = x_229 * x_77
    x_240 = x_227 * x_73
    x_241 = x_146 * x_240
    x_242 = x_239 + x_241
    x_243 = x_242 * x_3
    x_244 = 0.1059 * x_243
    x_245 = x_149 * x_227
    x_246 = x_233 * x_8
    x_247 = -x_245 + x_246
    x_248 = x_0 * x_247
    x_249 = 0.1059 * x_248
    x_250 = -x_244 - x_249
    x_251 = 0.0027 * x_1
    x_252 = -x_86 + x_93
    x_253 = x_148 * x_250
    x_254 = x_238 * x_242 + x_253 * x_73
    x_255 = 0.1052 * x_32
    x_256 = -x_119 * x_213 - x_119 * x_215 - x_133 * x_219 + x_133 * x_221
    x_257 = x_146 * x_158
    x_258 = x_148 * x_168
    x_259 = x_257 + x_258
    x_260 = -x_196 * x_77 + x_197 * x_77
    x_261 = -x_228 - x_234
    x_262 = x_227 * x_238
    x_263 = x_148 * x_262
    x_264 = x_146 * x_250
    x_265 = 1.0e-6 * x_104
    x_266 = 0.063883 * x_152
    x_267 = 0.063883 * x_156 + x_265 + x_266 - 1.0e-6 * x_90
    x_268 = x_146 * x_267
    x_269 = 0.009432 * x_104
    x_270 = 0.063883 * x_163
    x_271 = -0.063883 * x_167 + x_269 + x_270 - 0.009432 * x_90
    x_272 = x_148 * x_271
    x_273 = 1.0e-6 * x_148
    x_274 = x_273 * x_74
    x_275 = 0.009432 * x_146
    x_276 = -0.009432 * x_156 - 1.0e-6 * x_167 + x_274 - x_275 * x_74
    x_277 = x_276 * x_73
    x_278 = x_12 * x_277
    x_279 = 0.0036612 * x_1
    x_280 = x_148 * x_267
    x_281 = x_146 * x_271
    x_282 = x_276 * x_77 - x_280 * x_73 + x_281 * x_73
    x_283 = 0.1426512 * x_32
    x_284 = 0.0054 * x_8
    x_285 = x_284 * x_74 + 0.0054 * x_78
    x_286 = joint_velocity[2] * x_77
    x_287 = joint_velocity[3] * x_286
    x_288 = x_117 * x_286
    x_289 = x_109 * x_73
    x_290 = joint_velocity[3] * x_289
    x_291 = 0.0064 * x_0
    x_292 = x_291 * x_73
    x_293 = 0.0064 * x_286
    x_294 = (
        -joint_velocity[1] * x_292
        + joint_velocity[3] * x_89
        - joint_velocity[3] * x_91
        + x_117 * x_89
        - x_14 * x_293
    )
    x_295 = 0.5 * joint_velocity[0]
    x_296 = joint_velocity[2] * x_73
    x_297 = x_109 * x_77
    x_298 = x_74 + x_83
    x_299 = joint_velocity[0] * x_298
    x_300 = x_296 - x_297 + x_299
    x_301 = -0.2084 * x_296 + 0.2084 * x_297 - 0.2084 * x_299
    x_302 = joint_velocity[3] + x_117 + x_118
    x_303 = 0.2084 * joint_velocity[3]
    x_304 = 0.2084 * x_117
    x_305 = x_104 - x_90
    x_306 = joint_velocity[0] * x_305
    x_307 = 0.2084 * x_118 - x_120 * x_73 - x_293 + x_303 + x_304 - 0.0064 * x_306
    x_308 = (
        0.0032 * x_287
        - 0.0032 * x_288
        + 0.0032 * x_290
        + x_294 * x_295
        - 0.5 * x_300 * x_301
        + 0.5 * x_302 * x_307
    )
    x_309 = 0.678 * joint_velocity[0]
    x_310 = 0.678 * x_301
    x_311 = 0.678 * x_302
    x_312 = (
        0.0043392 * x_287
        - 0.0043392 * x_288
        + 0.0043392 * x_290
        + x_294 * x_309
        - x_300 * x_310
        + x_307 * x_311
    )
    x_313 = 2 * x_312
    x_314 = 0.2084 * x_73
    x_315 = joint_velocity[1] * x_0
    x_316 = -x_104 * x_303 - x_104 * x_304 + x_286 * x_88 + x_303 * x_90 + x_314 * x_315
    x_317 = 0.0064 * x_296
    x_318 = -x_120 * x_77 + 0.0064 * x_299 + x_317
    x_319 = 0.5 * x_318
    x_320 = x_286 + x_289 + x_306
    x_321 = 0.5 * x_320
    x_322 = (
        -0.1042 * x_287
        + 0.1042 * x_288
        - 0.1042 * x_290
        + x_295 * x_316
        + x_300 * x_319
        - x_307 * x_321
    )
    x_323 = (
        -0.1412952 * x_287
        + 0.1412952 * x_288
        - 0.1412952 * x_290
        + 0.678 * x_300 * x_318
        - 0.678 * x_307 * x_320
        + x_309 * x_316
    )
    x_324 = 0.0054 * x_0
    x_325 = x_324 * x_73
    x_326 = -x_104 * x_284 + x_325
    x_327 = joint_velocity[3] * x_296
    x_328 = x_117 * x_296
    x_329 = joint_velocity[3] * x_297
    x_330 = 0.0064 * x_78
    x_331 = (
        joint_velocity[1] * x_330
        + joint_velocity[3] * x_82
        + joint_velocity[3] * x_84
        + x_117 * x_82
        - x_14 * x_317
    )
    x_332 = (
        -0.1042 * x_110
        + 0.1042 * x_111
        + 0.1042 * x_113
        + x_295 * x_331
        + x_301 * x_321
        - x_302 * x_319
        + 0.0032 * x_327
        - 0.0032 * x_328
        - 0.0032 * x_329
    )
    x_333 = (
        -0.1412952 * x_110
        + 0.1412952 * x_111
        + 0.1412952 * x_113
        + x_309 * x_331
        + x_310 * x_320
        - x_311 * x_318
        + 0.0043392 * x_327
        - 0.0043392 * x_328
        - 0.0043392 * x_329
    )
    x_334 = 2 * x_333
    x_335 = -x_15 * x_73 + x_330 + x_8 * x_82
    x_336 = -x_16 * x_73 + x_84
    x_337 = -x_138 - x_191
    x_338 = x_229 * x_238
    x_339 = x_16 * x_77
    x_340 = x_339 + x_91
    x_341 = 2 * x_323
    x_342 = x_15 * x_77 + x_292 - x_8 * x_89
    x_343 = 0.015006 * joint_velocity[1]
    x_344 = 0.015006 * x_296
    x_345 = (
        joint_velocity[3] * x_100
        + joint_velocity[3] * x_101
        + x_100 * x_117
        - x_14 * x_344
        + x_343 * x_78
    )
    x_346 = 0.93 * joint_velocity[0]
    x_347 = 1.8e-5 * joint_velocity[3]
    x_348 = 1.8e-5 * x_117
    x_349 = (
        -1.8e-5 * x_118 - 0.015006 * x_297 + 0.015006 * x_299 + x_344 - x_347 - x_348
    )
    x_350 = 0.93 * x_302
    x_351 = 1.8e-5 * x_73
    x_352 = 0.075478 * x_77
    x_353 = (
        x_109 * x_351
        + x_109 * x_352
        + 1.8e-5 * x_286
        - 0.075478 * x_296
        - 0.075478 * x_299
        + 1.8e-5 * x_306
    )
    x_354 = 0.93 * x_353
    x_355 = (
        -0.07019454 * x_110
        + 0.07019454 * x_111
        + 0.07019454 * x_113
        + x_320 * x_354
        + 0.01395558 * x_327
        - 0.01395558 * x_328
        - 0.01395558 * x_329
        + x_345 * x_346
        - x_349 * x_350
    )
    x_356 = 0.015006 * x_286
    x_357 = (
        joint_velocity[3] * x_105
        - joint_velocity[3] * x_106
        - x_0 * x_343 * x_73
        + x_105 * x_117
        - x_14 * x_356
    )
    x_358 = 0.075478 * joint_velocity[3]
    x_359 = 0.075478 * x_117
    x_360 = (
        0.075478 * x_118 - 0.015006 * x_289 - 0.015006 * x_306 - x_356 + x_358 + x_359
    )
    x_361 = (
        1.674e-5 * x_110
        - 1.674e-5 * x_111
        - 1.674e-5 * x_113
        + 0.01395558 * x_287
        - 0.01395558 * x_288
        + 0.01395558 * x_290
        - x_300 * x_354
        + x_346 * x_357
        + x_350 * x_360
    )
    x_362 = joint_velocity[3] * x_148
    x_363 = x_146 * x_296
    x_364 = joint_velocity[1] * x_224
    x_365 = x_152 + x_156
    x_366 = joint_velocity[0] * x_365
    x_367 = -x_362 + x_363 + x_364 + x_366
    x_368 = 0.1059 * x_362
    x_369 = 0.1059 * x_363 + 0.1059 * x_364 + 0.1059 * x_366 - x_368
    x_370 = x_367 * x_369
    x_371 = joint_velocity[3] * x_146
    x_372 = x_148 * x_296
    x_373 = joint_velocity[1] * x_223
    x_374 = -x_163 + x_167
    x_375 = joint_velocity[0] * x_374
    x_376 = -x_371 - x_372 + x_373 + x_375
    x_377 = 0.1059 * x_371
    x_378 = 0.1059 * x_372 + x_377
    x_379 = -0.1059 * x_373 - 0.1059 * x_375 + x_378
    x_380 = 0.5 * x_379
    x_381 = 0.5 * x_370 - x_376 * x_380
    x_382 = 0.678 * x_376
    x_383 = 0.678 * x_370 - x_379 * x_382
    x_384 = -x_196 + x_197
    x_385 = -x_257 - x_258
    x_386 = -x_124 * x_155 + x_146 * x_325
    x_387 = joint_velocity[4] * x_149
    x_388 = joint_velocity[2] * x_147
    x_389 = x_149 * x_286
    x_390 = joint_velocity[3] * x_73
    x_391 = x_159 * x_390
    x_392 = joint_velocity[4] * x_154
    x_393 = x_0 * (x_387 - x_388 + x_389 + x_391 - x_392)
    x_394 = joint_velocity[1] * x_3
    x_395 = x_166 * x_394
    x_396 = x_148 * x_73
    x_397 = 0.1059 * x_0
    x_398 = joint_velocity[1] * x_397
    x_399 = joint_velocity[4] * x_153 + x_104 * x_368 - x_396 * x_398
    x_400 = -0.1059 * x_393 - 0.1059 * x_395 + x_399
    x_401 = joint_velocity[4] + x_320
    x_402 = x_369 * x_401
    x_403 = joint_velocity[2] * x_160
    x_404 = 0.1059 * x_159
    x_405 = 0.1059 * x_390
    x_406 = 0.1059 * x_161
    x_407 = (
        -joint_velocity[4] * x_404
        - joint_velocity[4] * x_406
        + x_149 * x_405
        - x_286 * x_404
        - 0.1059 * x_403
    )
    x_408 = joint_velocity[4] * x_362
    x_409 = x_286 * x_362
    x_410 = joint_velocity[4] * x_363
    x_411 = x_23 * x_407 - 0.05295 * x_408 + 0.05295 * x_409 + 0.05295 * x_410
    x_412 = x_295 * x_400 - 0.5 * x_402 + x_411
    x_413 = (
        x_26 * x_407
        + x_309 * x_400
        - 0.678 * x_402
        - 0.0718002 * x_408
        + 0.0718002 * x_409
        + 0.0718002 * x_410
    )
    x_414 = joint_velocity[4] * x_371
    x_415 = x_286 * x_371
    x_416 = joint_velocity[4] * x_372
    x_417 = joint_velocity[2] * x_149
    x_418 = 0.1059 * x_147
    x_419 = 0.1059 * x_150
    x_420 = (
        -joint_velocity[4] * x_418
        + joint_velocity[4] * x_419
        + x_160 * x_405
        - x_286 * x_418
        + 0.1059 * x_417
    )
    x_421 = x_146 * x_73
    x_422 = 0.1059 * x_394
    x_423 = (
        -joint_velocity[2] * x_159
        - joint_velocity[4] * x_160
        - joint_velocity[4] * x_165
        - x_147 * x_390
        - x_160 * x_286
    )
    x_424 = (
        -joint_velocity[4] * x_164
        + x_104 * x_377
        + x_155 * x_422
        + x_397 * x_423
        - x_398 * x_421
    )
    x_425 = (
        x_23 * x_420
        + x_295 * x_424
        + x_380 * x_401
        - 0.05295 * x_414
        + 0.05295 * x_415
        - 0.05295 * x_416
    )
    x_426 = 0.678 * x_401
    x_427 = (
        x_26 * x_420
        + x_309 * x_424
        + x_379 * x_426
        - 0.0718002 * x_414
        + 0.0718002 * x_415
        - 0.0718002 * x_416
    )
    x_428 = x_148 * x_325
    x_429 = -x_124 * x_166 - x_428
    x_430 = 0.0005 * joint_velocity[3]
    x_431 = 0.0005 * x_117
    x_432 = 1.0e-6 * x_296
    x_433 = 1.0e-6 * x_77
    x_434 = (
        x_109 * x_433
        - 0.0005 * x_118
        + 0.000631 * x_286
        + 0.000631 * x_289
        - 1.0e-6 * x_299
        + 0.000631 * x_306
        - x_430
        - x_431
        - x_432
    )
    x_435 = 1.0e-6 * x_286
    x_436 = 1.0e-6 * x_289
    x_437 = 1.0e-6 * x_306
    x_438 = (
        0.008147 * x_296 - 0.008147 * x_297 + 0.008147 * x_299 - x_435 - x_436 - x_437
    )
    x_439 = x_119 * x_296
    x_440 = x_51 * x_77
    x_441 = (
        x_18 * x_431 * x_73
        + 0.008316 * x_212
        + x_300 * x_430
        + x_300 * x_434
        - x_320 * x_438
        + 0.0005 * x_439
        + 0.0005 * x_440
    )
    x_442 = 0.008316 * x_111 + x_441
    x_443 = x_146 * x_339 + x_147 * x_292 + x_159 * x_42
    x_444 = 0.075478 * x_73
    x_445 = 1.8e-5 * x_77
    x_446 = (
        -0.07019454 * x_287
        + 0.07019454 * x_288
        - 0.07019454 * x_290
        + 0.93 * x_300 * x_349
        - 0.93 * x_320 * x_360
        - 1.674e-5 * x_327
        + 1.674e-5 * x_328
        + 1.674e-5 * x_329
        + x_346
        * (x_103 * x_286 - x_104 * x_358 - x_104 * x_359 + x_315 * x_444 + x_358 * x_90)
        + x_346
        * (x_296 * x_99 - x_315 * x_445 - x_347 * x_74 - x_347 * x_83 - x_348 * x_74)
    )
    x_447 = x_147 * x_42
    x_448 = x_159 * x_292
    x_449 = x_148 * x_339
    x_450 = x_447 - x_448 - x_449
    x_451 = x_148 * x_80
    x_452 = x_146 * x_92
    x_453 = -x_451 + x_452
    x_454 = -x_13 * x_155 + x_146 * x_292 - x_224 * x_42
    x_455 = x_146 * x_80
    x_456 = x_148 * x_92
    x_457 = -x_455 - x_456
    x_458 = x_148 * x_292
    x_459 = -x_13 * x_166 - x_223 * x_42 - x_458
    x_460 = x_51 * x_73
    x_461 = x_131 * x_73
    x_462 = x_119 * x_286
    x_463 = joint_velocity[3] * x_320
    x_464 = joint_velocity[3] * x_300
    x_465 = (
        0.008316 * joint_velocity[3]
        + 0.008316 * x_117
        + 0.008316 * x_118
        - 0.0005 * x_286
        - 0.0005 * x_289
        - 0.0005 * x_306
    )
    x_466 = (
        x_119 * x_432
        + 0.008147 * x_131 * x_77
        - x_302 * x_434
        + x_320 * x_465
        + x_433 * x_51
        - 0.008147 * x_460
        + 1.0e-6 * x_461
        + 0.008147 * x_462
        + 0.008147 * x_463
        + 1.0e-6 * x_464
    )
    x_467 = x_146 * x_230
    x_468 = x_231 - x_467
    x_469 = 1.0e-6 * x_237 + 0.00965 * x_243 + 0.00965 * x_248 + x_274
    x_470 = x_3 * x_468
    x_471 = x_149 * x_229
    x_472 = x_146 * x_239
    x_473 = -x_240 - x_472
    x_474 = x_473 * x_8
    x_475 = x_471 + x_474
    x_476 = x_0 * x_475
    x_477 = 0.045483 * x_163 + 0.045483 * x_237 - 0.00965 * x_470 - 0.00965 * x_476
    x_478 = 0.045483 * x_243
    x_479 = 1.0e-6 * x_470
    x_480 = 0.045483 * x_248
    x_481 = 1.0e-6 * x_476
    x_482 = -x_478 - x_479 - x_480 - x_481
    x_483 = x_148 * x_482
    x_484 = x_242 * x_477 + x_468 * x_469 + x_483 * x_73
    x_485 = (
        -0.0005 * x_111
        - x_119 * x_435
        - x_131 * x_433
        - 0.0005 * x_212
        - x_300 * x_465
        + x_302 * x_438
        - 0.000631 * x_439
        - 0.000631 * x_440
        + 1.0e-6 * x_460
        - 0.000631 * x_461
        - 1.0e-6 * x_463
        - 0.000631 * x_464
    )
    x_486 = x_159 * x_229
    x_487 = x_12 * x_473
    x_488 = -x_486 + x_487
    x_489 = x_229 * x_469
    x_490 = x_148 * x_489
    x_491 = x_227 * x_477
    x_492 = x_148 * x_491
    x_493 = x_146 * x_482
    x_494 = x_227 * x_469 + x_229 * x_477
    x_495 = x_486 - x_487
    x_496 = joint_velocity[1] * x_151
    x_497 = x_163 + x_237
    x_498 = joint_velocity[0] * x_497
    x_499 = joint_velocity[5] + x_371 + x_372 + x_496 + x_498
    x_500 = 0.1059 * joint_velocity[5]
    x_501 = x_378 + 0.1059 * x_496 + 0.1059 * x_498 + x_500
    x_502 = joint_velocity[4] * x_229
    x_503 = x_227 * x_362
    x_504 = joint_velocity[2] * x_242
    x_505 = joint_velocity[1] * x_261
    x_506 = x_243 + x_248
    x_507 = joint_velocity[0] * x_506
    x_508 = x_502 - x_503 + x_504 + x_505 + x_507
    x_509 = (
        -0.1059 * x_502
        + 0.1059 * x_503
        - 0.1059 * x_504
        - 0.1059 * x_505
        - 0.1059 * x_507
    )
    x_510 = 0.5 * x_499 * x_501 - 0.5 * x_508 * x_509
    x_511 = x_168 * x_229
    x_512 = x_0 * x_468
    x_513 = -x_124 * x_475 + 0.0054 * x_512
    x_514 = x_16 * x_473 - x_42 * x_486 + x_468 * x_48
    x_515 = x_227 * x_85 + x_229 * x_451 - x_229 * x_452
    x_516 = -x_387 + x_388 - x_389 - x_391 + x_392
    x_517 = x_236 * x_422 + x_397 * x_516 + x_399
    x_518 = joint_velocity[4] * x_227
    x_519 = x_229 * x_362
    x_520 = joint_velocity[2] * x_468
    x_521 = joint_velocity[1] * x_495
    x_522 = x_470 + x_476
    x_523 = joint_velocity[0] * x_522
    x_524 = x_518 + x_519 + x_520 + x_521 + x_523
    x_525 = 0.5 * x_524
    x_526 = x_295 * x_517 + x_411 + x_509 * x_525
    x_527 = x_168 * x_227
    x_528 = -x_13 * x_475 - x_42 * x_495 + 0.0064 * x_512
    x_529 = -x_124 * x_247 + x_242 * x_324
    x_530 = x_16 * x_233 + x_228 * x_42 + x_242 * x_48
    x_531 = x_229 * x_85
    x_532 = -x_227 * x_451 + x_227 * x_452 + x_531
    x_533 = -x_13 * x_247 + x_242 * x_291 - x_261 * x_42
    x_534 = x_320 * x_371
    x_535 = 0.000256 * joint_velocity[4]
    x_536 = 0.000256 * x_286
    x_537 = (
        0.000256 * x_289
        + 0.000256 * x_306
        - 0.001607 * x_371
        - 0.001607 * x_372
        + 0.001607 * x_373
        + 0.001607 * x_375
        + x_535
        + x_536
    )
    x_538 = (
        0.000399 * joint_velocity[4]
        + 0.000399 * x_286
        + 0.000399 * x_289
        + 0.000399 * x_306
        - 0.000256 * x_371
        - 0.000256 * x_372
        + 0.000256 * x_373
        + 0.000256 * x_375
    )
    x_539 = (
        0.001596 * joint_velocity[4] * x_376
        + 0.001596 * x_146 * x_462
        - 0.001596 * x_148 * x_212
        + 0.001596 * x_155 * x_19
        + x_376 * x_538
        - x_401 * x_537
        - 0.001596 * x_421 * x_51
        + 0.001596 * x_534
    )
    x_540 = x_396 * x_51
    x_541 = x_146 * x_212
    x_542 = x_148 * x_462
    x_543 = x_166 * x_19
    x_544 = x_320 * x_362
    x_545 = joint_velocity[4] * x_367
    x_546 = -0.001596 * x_362 + 0.001596 * x_363 + 0.001596 * x_364 + 0.001596 * x_366
    x_547 = (
        -x_367 * x_538
        + x_401 * x_546
        - 0.000256 * x_439
        - 0.000256 * x_440
        - 0.000256 * x_461
        - 0.000256 * x_464
        + 0.001607 * x_540
        - 0.001607 * x_541
        - 0.001607 * x_542
        + 0.001607 * x_543
        - 0.001607 * x_544
        - 0.001607 * x_545
    )
    x_548 = math.cos(joint_position[6])
    x_549 = x_239 * x_548
    x_550 = math.sin(joint_position[6])
    x_551 = x_148 * x_550
    x_552 = x_146 * x_548
    x_553 = x_227 * x_552
    x_554 = -x_551 + x_553
    x_555 = x_554 * x_73
    x_556 = x_549 + x_555
    x_557 = x_3 * x_556
    x_558 = x_239 * x_550
    x_559 = x_148 * x_548
    x_560 = x_146 * x_550
    x_561 = x_227 * x_560
    x_562 = -x_559 - x_561
    x_563 = x_562 * x_73
    x_564 = -x_558 + x_563
    x_565 = x_3 * x_564
    x_566 = x_227 * x_559
    x_567 = x_560 + x_566
    x_568 = x_12 * x_567
    x_569 = x_230 * x_548
    x_570 = x_554 * x_77
    x_571 = -x_569 + x_570
    x_572 = x_571 * x_8
    x_573 = -x_568 + x_572
    x_574 = x_0 * x_573
    x_575 = x_227 * x_551
    x_576 = x_552 - x_575
    x_577 = x_12 * x_576
    x_578 = x_230 * x_550
    x_579 = x_562 * x_77
    x_580 = x_578 + x_579
    x_581 = x_580 * x_8
    x_582 = -x_577 + x_581
    x_583 = x_0 * x_582
    x_584 = -0.011402 * x_557 + 0.000281 * x_565 - 0.011402 * x_574 + 0.000281 * x_583
    x_585 = (
        -x_119 * x_148 * x_536
        - x_367 * x_535
        + x_367 * x_537
        - x_376 * x_546
        - 0.000399 * x_439
        - 0.000399 * x_440
        - 0.000399 * x_461
        - 0.000399 * x_464
        + 0.000256 * x_540
        - 0.000256 * x_541
        + 0.000256 * x_543
        - 0.000256 * x_544
    )
    x_586 = -0.000281 * x_470 - 0.000281 * x_476 + 0.029798 * x_557 + 0.029798 * x_574
    x_587 = x_548 * x_586
    x_588 = 0.011402 * x_470 + 0.011402 * x_476 - 0.029798 * x_565 - 0.029798 * x_583
    x_589 = x_550 * x_588
    x_590 = x_468 * x_584 + x_556 * x_588 + x_564 * x_586
    x_591 = x_229 * x_584
    x_592 = x_148 * x_591
    x_593 = -x_124 * x_236 + x_428
    x_594 = joint_velocity[5] * x_518
    x_595 = x_371 * x_518
    x_596 = joint_velocity[5] * x_519
    x_597 = joint_velocity[3] * x_230
    x_598 = joint_velocity[4] * x_148
    x_599 = x_240 * x_598
    x_600 = 0.5 * joint_velocity[2]
    x_601 = 0.1059 * x_245
    x_602 = joint_velocity[2] * x_8
    x_603 = x_602 * (x_230 - x_232)
    x_604 = joint_velocity[3] * x_239
    x_605 = joint_velocity[5] * x_240
    x_606 = x_240 * x_371
    x_607 = x_231 * x_598
    x_608 = joint_velocity[5] * x_472
    x_609 = x_12 * (x_604 + x_605 + x_606 + x_607 + x_608)
    x_610 = 0.1059 * x_247
    x_611 = joint_velocity[5] * x_231
    x_612 = joint_velocity[5] * x_467
    x_613 = x_3 * (x_231 * x_371 - x_597 - x_599 + x_611 - x_612)
    x_614 = x_0 * (
        -joint_velocity[2] * x_228
        - joint_velocity[2] * x_234
        + joint_velocity[5] * x_471
        - x_160 * x_518
        + x_8 * (-x_604 - x_605 - x_606 - x_607 - x_608)
    )
    x_615 = (
        x_23
        * (
            -joint_velocity[2] * x_601
            + x_418 * x_518
            - x_486 * x_500
            - 0.1059 * x_603
            - 0.1059 * x_609
        )
        + x_295 * (x_242 * x_398 - x_394 * x_610 - 0.1059 * x_613 - 0.1059 * x_614)
        - x_501 * x_525
        - 0.05295 * x_594
        + 0.05295 * x_595
        - 0.05295 * x_596
        + x_600
        * (
            -x_231 * x_377
            - x_231 * x_500
            + x_467 * x_500
            + 0.1059 * x_597
            + 0.1059 * x_599
        )
    )
    x_616 = -x_153 - x_157
    x_617 = x_576 * x_8
    x_618 = x_12 * x_580
    x_619 = x_617 + x_618
    x_620 = x_567 * x_8
    x_621 = x_12 * x_571
    x_622 = x_620 + x_621
    x_623 = -x_447 + x_448 + x_449
    x_624 = 0.009432 * x_77
    x_625 = joint_velocity[3] * x_74
    x_626 = x_117 * x_74
    x_627 = joint_velocity[3] * x_47
    x_628 = (
        0.009432 * x_14 * x_296
        - x_315 * x_624
        - x_624 * x_627
        - 0.009432 * x_625
        - 0.009432 * x_626
    )
    x_629 = 0.063883 * x_159
    x_630 = 0.063883 * x_73
    x_631 = joint_velocity[3] * x_630
    x_632 = 0.063883 * x_161
    x_633 = (
        -joint_velocity[4] * x_629
        - joint_velocity[4] * x_632
        + x_149 * x_631
        - x_286 * x_629
        - 0.063883 * x_403
    )
    x_634 = x_148 * x_630
    x_635 = 0.063883 * x_362
    x_636 = (
        joint_velocity[4] * x_266
        + x_104 * x_635
        - x_315 * x_634
        - 0.063883 * x_393
        - 0.063883 * x_395
    )
    x_637 = 1.0e-6 * joint_velocity[4]
    x_638 = (
        0.063883 * x_363
        + 0.063883 * x_364
        + 0.063883 * x_366
        + x_435
        + x_436
        + x_437
        - x_635
        + x_637
    )
    x_639 = 0.678 * x_638
    x_640 = 1.0e-6 * x_371
    x_641 = x_273 * x_296 + x_640
    x_642 = (
        -x_275 * x_296
        + 0.009432 * x_362
        - 0.009432 * x_364
        - 0.009432 * x_366
        - 1.0e-6 * x_373
        - 1.0e-6 * x_375
        + x_641
    )
    x_643 = (
        x_26 * x_633
        + x_309 * x_628
        + x_309 * x_636
        - 0.006394896 * x_327
        + 0.006394896 * x_328
        + 0.006394896 * x_329
        + x_382 * x_642
        - x_401 * x_639
        - 0.043312674 * x_408
        + 0.043312674 * x_409
        + 0.043312674 * x_410
    )
    x_644 = (
        x_14 * x_432 - x_315 * x_433 - x_433 * x_627 - 1.0e-6 * x_625 - 1.0e-6 * x_626
    )
    x_645 = 0.063883 * x_147
    x_646 = 0.063883 * x_150
    x_647 = (
        -joint_velocity[4] * x_645
        + joint_velocity[4] * x_646
        + x_160 * x_631
        - x_286 * x_645
        + 0.063883 * x_417
    )
    x_648 = x_146 * x_630
    x_649 = 0.063883 * x_371
    x_650 = x_155 * x_394
    x_651 = x_0 * x_423
    x_652 = (
        -joint_velocity[4] * x_270
        + x_104 * x_649
        - x_315 * x_648
        + 0.063883 * x_650
        + 0.063883 * x_651
    )
    x_653 = 0.009432 * joint_velocity[4]
    x_654 = 0.009432 * x_286
    x_655 = (
        0.009432 * x_289
        + 0.009432 * x_306
        + 0.063883 * x_372
        - 0.063883 * x_373
        - 0.063883 * x_375
        + x_649
        + x_653
        + x_654
    )
    x_656 = x_367 * x_642
    x_657 = (
        x_26 * x_647
        + x_309 * x_644
        + x_309 * x_652
        - 6.78e-7 * x_327
        + 6.78e-7 * x_328
        + 6.78e-7 * x_329
        - 0.043312674 * x_414
        + 0.043312674 * x_415
        - 0.043312674 * x_416
        + x_426 * x_655
        - 0.678 * x_656
    )
    x_658 = x_455 + x_456
    x_659 = -x_13 * x_236 - x_151 * x_42 + x_458
    x_660 = -x_617 - x_618
    x_661 = -x_620 - x_621
    x_662 = x_550 * x_586
    x_663 = x_548 * x_588
    x_664 = x_227 * x_584 - x_229 * x_662 + x_229 * x_663
    x_665 = x_275 * x_73
    x_666 = x_273 * x_73
    x_667 = x_152 * x_637 + x_265 * x_362 - x_315 * x_666
    x_668 = 0.009432 * x_149
    x_669 = 1.0e-6 * x_160
    x_670 = x_149 * x_390
    x_671 = (
        -joint_velocity[2] * x_669
        - x_159 * x_435
        - x_159 * x_637
        - x_161 * x_637
        + 1.0e-6 * x_670
    )
    x_672 = x_26 * x_671 - 6.78e-7 * x_408 + 6.78e-7 * x_409 + 6.78e-7 * x_410
    x_673 = (
        x_26
        * (
            -joint_velocity[2] * x_668
            + x_147 * x_653
            + x_147 * x_654
            - x_150 * x_653
            - 0.009432 * x_160 * x_390
        )
        + x_309 * (-1.0e-6 * x_393 - 1.0e-6 * x_395 + x_667)
        + x_309
        * (
            x_163 * x_653
            - x_269 * x_371
            + x_315 * x_665
            - 0.009432 * x_650
            - 0.009432 * x_651
        )
        + x_367 * x_639
        - x_382 * x_655
        + 0.006394896 * x_414
        - 0.006394896 * x_415
        + 0.006394896 * x_416
        + x_672
    )
    x_674 = -x_552 + x_575
    x_675 = -x_560 - x_566
    x_676 = 0.001641 * x_51
    x_677 = x_148 * x_227
    x_678 = 0.001641 * x_371
    x_679 = x_376 * x_518
    x_680 = 0.001641 * joint_velocity[5]
    x_681 = 0.000278 * joint_velocity[5]
    x_682 = 0.000278 * x_371
    x_683 = (
        -0.000278 * x_372
        - 0.000278 * x_496
        - 0.000278 * x_498
        + 0.00041 * x_518
        + 0.00041 * x_519
        + 0.00041 * x_520
        + 0.00041 * x_521
        + 0.00041 * x_523
        - x_681
        - x_682
    )
    x_684 = (
        0.001641 * x_372
        + 0.001641 * x_496
        + 0.001641 * x_498
        - 0.000278 * x_518
        - 0.000278 * x_519
        - 0.000278 * x_520
        - 0.000278 * x_521
        - 0.000278 * x_523
        + x_678
        + x_680
    )
    x_685 = (
        0.001641 * x_19 * x_247
        - 0.001641 * x_212 * x_677
        + 0.001641 * x_218 * x_233
        + x_227 * x_320 * x_678
        - 0.001641 * x_229 * x_464
        - x_242 * x_676
        - x_499 * x_683
        + x_524 * x_680
        + x_524 * x_684
        + 0.001641 * x_679
    )
    x_686 = x_19 * x_236
    x_687 = x_148 * x_229
    x_688 = x_212 * x_687
    x_689 = x_468 * x_51
    x_690 = x_218 * x_473
    x_691 = x_227 * x_464
    x_692 = x_19 * x_475
    x_693 = x_229 * x_534
    x_694 = x_376 * x_502
    x_695 = joint_velocity[5] * x_508
    x_696 = (
        0.001641 * x_502
        - 0.001641 * x_503
        + 0.001641 * x_504
        + 0.001641 * x_505
        + 0.001641 * x_507
    )
    x_697 = (
        x_499 * x_696
        - x_508 * x_684
        + 0.000278 * x_540
        - 0.000278 * x_541
        - 0.000278 * x_542
        - 0.000278 * x_544
        - 0.000278 * x_545
        - 0.000278 * x_686
        + 0.00041 * x_688
        - 0.00041 * x_689
        + 0.00041 * x_690
        - 0.00041 * x_691
        + 0.00041 * x_692
        - 0.00041 * x_693
        - 0.00041 * x_694
        - 0.00041 * x_695
    )
    x_698 = (
        x_229 * x_320 * x_682
        - x_396 * x_676
        + x_508 * x_681
        + x_508 * x_683
        - x_524 * x_696
        + 0.001641 * x_541
        + 0.001641 * x_542
        + 0.001641 * x_544
        + 0.001641 * x_545
        + 0.001641 * x_686
        - 0.000278 * x_688
        + 0.000278 * x_689
        - 0.000278 * x_690
        + 0.000278 * x_691
        - 0.000278 * x_692
        + 0.000278 * x_694
    )
    x_699 = joint_velocity[5] * x_502
    x_700 = x_371 * x_502
    x_701 = joint_velocity[5] * x_503
    x_702 = 0.045483 * x_159
    x_703 = (
        -0.045483 * joint_velocity[4] * x_161
        - joint_velocity[4] * x_702
        - x_286 * x_702
        - 0.045483 * x_403
        + 0.045483 * x_670
    )
    x_704 = joint_velocity[3] * x_240
    x_705 = joint_velocity[5] * x_239
    x_706 = 0.00965 * x_239
    x_707 = 0.00965 * x_148
    x_708 = joint_velocity[4] * x_707
    x_709 = joint_velocity[5] * x_241
    x_710 = (
        -x_230 * x_708
        + x_371 * x_706
        + 0.00965 * x_704
        + 0.00965 * x_705
        + 0.00965 * x_709
    )
    x_711 = 0.678 * joint_velocity[2]
    x_712 = 0.045483 * x_396
    x_713 = 0.045483 * x_146
    x_714 = x_236 * x_394
    x_715 = x_0 * x_516
    x_716 = (
        joint_velocity[4] * x_713 * x_74
        + 0.045483 * x_104 * x_362
        - x_315 * x_712
        + 0.045483 * x_714
        + 0.045483 * x_715
    )
    x_717 = joint_velocity[2] * x_471
    x_718 = 0.00965 * x_502
    x_719 = 0.00965 * x_228
    x_720 = x_602 * (x_240 + x_472)
    x_721 = joint_velocity[3] * x_231
    x_722 = joint_velocity[5] * x_230
    x_723 = joint_velocity[5] * x_232
    x_724 = x_230 * x_371
    x_725 = x_239 * x_598
    x_726 = x_12 * (x_721 - x_722 + x_723 - x_724 - x_725)
    x_727 = (
        -joint_velocity[5] * x_719
        - x_147 * x_718
        + 0.00965 * x_717
        - 0.00965 * x_720
        - 0.00965 * x_726
    )
    x_728 = joint_velocity[1] * x_512
    x_729 = joint_velocity[1] * x_475
    x_730 = x_3 * x_729
    x_731 = x_230 * x_598
    x_732 = x_239 * x_371
    x_733 = x_3 * (-x_704 - x_705 - x_709 + x_731 - x_732)
    x_734 = x_0 * (
        joint_velocity[2] * x_486
        - joint_velocity[2] * x_487
        + joint_velocity[5] * x_245
        + x_160 * x_502
        + x_8 * (-x_721 + x_722 - x_723 + x_724 + x_725)
    )
    x_735 = 0.00965 * x_728 - 0.00965 * x_730 - 0.00965 * x_733 - 0.00965 * x_734
    x_736 = 1.0e-6 * joint_velocity[5]
    x_737 = (
        1.0e-6 * x_496
        + 1.0e-6 * x_498
        - 0.00965 * x_503
        + 0.00965 * x_504
        + 0.00965 * x_505
        + 0.00965 * x_507
        + x_641
        + x_718
        + x_736
    )
    x_738 = x_499 * x_737
    x_739 = 1.0e-6 * x_229
    x_740 = 0.045483 * x_227
    x_741 = (
        -x_362 * x_739
        + x_362 * x_740
        - 0.045483 * x_502
        - 0.045483 * x_504
        - 0.045483 * x_505
        - 0.045483 * x_507
        - 1.0e-6 * x_518
        - 1.0e-6 * x_520
        - 1.0e-6 * x_521
        - 1.0e-6 * x_523
    )
    x_742 = x_524 * x_741
    x_743 = (
        x_26 * x_703
        + x_26 * x_727
        + x_309 * x_716
        + x_309 * x_735
        - 0.030837474 * x_408
        + 0.030837474 * x_409
        + 0.030837474 * x_410
        + 0.0065427 * x_699
        - 0.0065427 * x_700
        - 0.0065427 * x_701
        + x_710 * x_711
        - 0.678 * x_738
        + 0.678 * x_742
    )
    x_744 = x_242 * x_315
    x_745 = x_247 * x_394
    x_746 = 0.00965 * x_613 + 0.00965 * x_614 - 0.00965 * x_744 + 0.00965 * x_745
    x_747 = x_667 + 1.0e-6 * x_714 + 1.0e-6 * x_715
    x_748 = 0.00965 * x_518
    x_749 = 0.00965 * x_486
    x_750 = (
        0.00965 * joint_velocity[2] * x_245
        + joint_velocity[5] * x_749
        - x_147 * x_748
        + 0.00965 * x_603
        + 0.00965 * x_609
    )
    x_751 = 0.00965 * x_231
    x_752 = (
        -x_240 * x_708
        + x_371 * x_751
        - 0.00965 * x_597
        + 0.00965 * x_611
        - 0.00965 * x_612
    )
    x_753 = 0.045483 * joint_velocity[5]
    x_754 = 0.045483 * x_371
    x_755 = (
        0.045483 * x_372
        + 0.045483 * x_496
        + 0.045483 * x_498
        - 0.00965 * x_519
        - 0.00965 * x_520
        - 0.00965 * x_521
        - 0.00965 * x_523
        - x_748
        + x_753
        + x_754
    )
    x_756 = 0.678 * x_755
    x_757 = 0.678 * x_508
    x_758 = (
        x_26 * x_750
        + x_309 * x_746
        + x_309 * x_747
        + x_499 * x_756
        + 0.0065427 * x_594
        - 0.0065427 * x_595
        + 0.0065427 * x_596
        + x_672
        + x_711 * x_752
        - x_741 * x_757
    )
    x_759 = 0.045483 * x_147
    x_760 = 1.0e-6 * x_147
    x_761 = (
        x_26
        * (
            -x_228 * x_736
            + x_417 * x_739
            - x_502 * x_760
            - 1.0e-6 * x_720
            - 1.0e-6 * x_726
        )
        + x_26
        * (
            -x_417 * x_740
            - x_486 * x_753
            + x_518 * x_759
            - 0.045483 * x_603
            - 0.045483 * x_609
        )
        + x_309
        * (-0.045483 * x_613 - 0.045483 * x_614 + 0.045483 * x_744 - 0.045483 * x_745)
        + x_309 * (1.0e-6 * x_728 - 1.0e-6 * x_730 - 1.0e-6 * x_733 - 1.0e-6 * x_734)
        - x_524 * x_756
        - 0.030837474 * x_594
        + 0.030837474 * x_595
        - 0.030837474 * x_596
        + 6.78e-7 * x_699
        - 6.78e-7 * x_700
        - 6.78e-7 * x_701
        + x_711
        * (
            -x_231 * x_753
            - x_231 * x_754
            + x_467 * x_753
            + 0.045483 * x_597
            + 0.045483 * x_599
        )
        + x_711
        * (
            -x_148 * x_230 * x_637
            + x_239 * x_640
            + x_239 * x_736
            + x_241 * x_736
            + 1.0e-6 * x_704
        )
        + x_737 * x_757
    )
    x_762 = joint_velocity[5] * x_550
    x_763 = 0.014899 * joint_velocity[6]
    x_764 = 0.014899 * x_518
    x_765 = x_502 * x_548
    x_766 = (
        -0.011402 * x_704
        - 0.011402 * x_705
        - 0.011402 * x_709
        + 0.011402 * x_731
        - 0.011402 * x_732
    )
    x_767 = joint_velocity[4] * x_559
    x_768 = joint_velocity[6] * x_560
    x_769 = 0.029798 * x_560
    x_770 = 0.029798 * x_229
    x_771 = joint_velocity[5] * x_770
    x_772 = joint_velocity[6] * x_566
    x_773 = (
        -x_518 * x_769
        + x_551 * x_771
        - 0.029798 * x_767
        - 0.029798 * x_768
        - 0.029798 * x_772
    )
    x_774 = 0.5 * joint_velocity[3]
    x_775 = x_147 * x_502
    x_776 = 0.011402 * x_227
    x_777 = joint_velocity[5] * x_159
    x_778 = (
        -0.011402 * x_717
        + 0.011402 * x_720
        + 0.011402 * x_726
        + 0.011402 * x_775
        + x_776 * x_777
    )
    x_779 = joint_velocity[3] * x_578
    x_780 = 0.029798 * x_762
    x_781 = joint_velocity[6] * x_549
    x_782 = joint_velocity[3] * x_579
    x_783 = joint_velocity[5] * x_229
    x_784 = (
        -joint_velocity[4] * x_552
        + joint_velocity[6] * x_551
        - joint_velocity[6] * x_553
        + x_518 * x_551
        + x_560 * x_783
    )
    x_785 = x_73 * x_784
    x_786 = (
        x_231 * x_780
        - 0.029798 * x_779
        + 0.029798 * x_781
        - 0.029798 * x_782
        - 0.029798 * x_785
    )
    x_787 = 0.011402 * x_3
    x_788 = -0.011402 * x_728 + x_729 * x_787 + 0.011402 * x_733 + 0.011402 * x_734
    x_789 = 0.029798 * x_12
    x_790 = joint_velocity[2] * x_789
    x_791 = -x_578 - x_579
    x_792 = 0.029798 * x_602
    x_793 = x_551 * x_783
    x_794 = x_518 * x_560 + x_767 + x_768 + x_772 - x_793
    x_795 = 0.029798 * x_8
    x_796 = joint_velocity[3] * x_558
    x_797 = x_240 * x_762
    x_798 = joint_velocity[6] * x_569
    x_799 = joint_velocity[3] * x_563
    x_800 = x_77 * x_784
    x_801 = -x_796 - x_797 - x_798 + x_799 - x_800
    x_802 = x_674 * x_790 - x_789 * x_801 - x_791 * x_792 - x_794 * x_795
    x_803 = 0.029798 * x_0
    x_804 = joint_velocity[1] * x_803
    x_805 = 0.029798 * x_3
    x_806 = joint_velocity[1] * x_805
    x_807 = -x_231 * x_762 + x_779 - x_781 + x_782 + x_785
    x_808 = (
        -joint_velocity[2] * x_618
        + x_12 * x_794
        + x_602 * x_674
        + x_8 * (x_796 + x_797 + x_798 - x_799 + x_800)
    )
    x_809 = x_564 * x_804 - x_582 * x_806 - x_803 * x_808 - x_805 * x_807
    x_810 = 0.000281 * joint_velocity[6]
    x_811 = 0.000281 * x_518
    x_812 = joint_velocity[3] * x_675
    x_813 = joint_velocity[2] * x_556
    x_814 = joint_velocity[1] * x_661
    x_815 = x_557 + x_574
    x_816 = joint_velocity[0] * x_815
    x_817 = (
        -0.000281 * x_519
        - 0.000281 * x_520
        - 0.000281 * x_521
        - 0.000281 * x_523
        + 0.029798 * x_765
        - x_780
        - x_810
        - x_811
        + 0.029798 * x_812
        + 0.029798 * x_813
        + 0.029798 * x_814
        + 0.029798 * x_816
    )
    x_818 = joint_velocity[6] + x_524
    x_819 = 0.5 * x_818
    x_820 = joint_velocity[5] * x_548
    x_821 = x_502 * x_550
    x_822 = joint_velocity[3] * x_674
    x_823 = joint_velocity[2] * x_564
    x_824 = joint_velocity[1] * x_660
    x_825 = x_565 + x_583
    x_826 = joint_velocity[0] * x_825
    x_827 = -x_820 - x_821 + x_822 + x_823 + x_824 + x_826
    x_828 = 0.000281 * x_550
    x_829 = 0.011402 * x_548
    x_830 = (
        -x_502 * x_828
        - x_502 * x_829
        + 0.011402 * x_762
        - 0.011402 * x_812
        - 0.011402 * x_813
        - 0.011402 * x_814
        - 0.011402 * x_816
        - 0.000281 * x_820
        + 0.000281 * x_822
        + 0.000281 * x_823
        + 0.000281 * x_824
        + 0.000281 * x_826
    )
    x_831 = 0.5 * x_830
    x_832 = (
        x_23 * x_778
        + x_23 * x_802
        + x_295 * x_788
        + x_295 * x_809
        + x_600 * x_766
        + x_600 * x_786
        - 0.005701 * x_699
        + 0.005701 * x_700
        + 0.005701 * x_701
        - x_762 * x_763
        + x_762 * x_764
        + x_763 * x_765
        + x_773 * x_774
        - x_817 * x_819
        + x_827 * x_831
    )
    x_833 = (
        0.000281 * x_704
        + 0.000281 * x_705
        + 0.000281 * x_709
        - 0.000281 * x_731
        + 0.000281 * x_732
    )
    x_834 = joint_velocity[4] * x_551
    x_835 = joint_velocity[6] * x_552
    x_836 = 0.029798 * x_552
    x_837 = joint_velocity[6] * x_575
    x_838 = (
        -x_518 * x_836
        + x_559 * x_771
        + 0.029798 * x_834
        - 0.029798 * x_835
        + 0.029798 * x_837
    )
    x_839 = 0.000281 * x_227
    x_840 = (
        0.000281 * x_717
        - 0.000281 * x_720
        - 0.000281 * x_726
        - 0.000281 * x_775
        - x_777 * x_839
    )
    x_841 = joint_velocity[3] * x_569
    x_842 = 0.029798 * x_820
    x_843 = joint_velocity[6] * x_558
    x_844 = joint_velocity[3] * x_570
    x_845 = (
        -joint_velocity[4] * x_560
        - joint_velocity[6] * x_559
        - joint_velocity[6] * x_561
        - x_518 * x_559
        - x_552 * x_783
    )
    x_846 = x_73 * x_845
    x_847 = (
        x_231 * x_842
        - 0.029798 * x_841
        - 0.029798 * x_843
        + 0.029798 * x_844
        + 0.029798 * x_846
    )
    x_848 = 0.000281 * x_3
    x_849 = 0.000281 * x_728 - x_729 * x_848 - 0.000281 * x_733 - 0.000281 * x_734
    x_850 = x_569 - x_570
    x_851 = x_559 * x_783
    x_852 = -x_518 * x_552 + x_834 - x_835 + x_837 + x_851
    x_853 = joint_velocity[3] * x_549
    x_854 = x_240 * x_820
    x_855 = joint_velocity[6] * x_578
    x_856 = joint_velocity[3] * x_555
    x_857 = x_77 * x_845
    x_858 = x_853 + x_854 - x_855 + x_856 - x_857
    x_859 = -x_675 * x_790 + x_789 * x_858 + x_792 * x_850 + x_795 * x_852
    x_860 = x_231 * x_820 - x_841 - x_843 + x_844 + x_846
    x_861 = (
        -joint_velocity[2] * x_621
        + x_12 * x_852
        + x_602 * x_675
        + x_8 * (-x_853 - x_854 + x_855 - x_856 + x_857)
    )
    x_862 = -x_556 * x_804 + x_573 * x_806 + x_803 * x_861 + x_805 * x_860
    x_863 = 0.011402 * joint_velocity[6]
    x_864 = 0.011402 * x_518
    x_865 = (
        0.011402 * x_519
        + 0.011402 * x_520
        + 0.011402 * x_521
        + 0.011402 * x_523
        + 0.029798 * x_821
        - 0.029798 * x_822
        - 0.029798 * x_823
        - 0.029798 * x_824
        - 0.029798 * x_826
        + x_842
        + x_863
        + x_864
    )
    x_866 = -x_762 + x_765 + x_812 + x_813 + x_814 + x_816
    x_867 = (
        x_23 * x_840
        + x_23 * x_859
        + x_295 * x_849
        + x_295 * x_862
        + x_600 * x_833
        + x_600 * x_847
        + 0.0001405 * x_699
        - 0.0001405 * x_700
        - 0.0001405 * x_701
        - x_763 * x_820
        - x_763 * x_821
        + x_764 * x_820
        + x_774 * x_838
        + x_819 * x_865
        - x_831 * x_866
    )
    x_868 = joint_velocity[6] * x_762
    x_869 = joint_velocity[6] * x_820
    x_870 = x_518 * x_762
    x_871 = x_518 * x_820
    x_872 = joint_velocity[6] * x_821
    x_873 = joint_velocity[6] * x_765
    x_874 = 0.000281 * x_231
    x_875 = 0.011402 * x_231
    x_876 = 0.011402 * x_12
    x_877 = 0.000281 * x_12
    x_878 = 0.000281 * x_0
    x_879 = 0.011402 * x_0
    x_880 = (
        x_23
        * (
            -joint_velocity[2] * x_674 * x_877
            + 0.000281 * x_602 * x_791
            + 0.000281 * x_794 * x_8
            + x_801 * x_877
        )
        + x_23
        * (
            joint_velocity[2] * x_675 * x_876
            - 0.011402 * x_602 * x_850
            - 0.011402 * x_8 * x_852
            - x_858 * x_876
        )
        + x_295
        * (
            joint_velocity[1] * x_556 * x_879
            - joint_velocity[1] * x_573 * x_787
            - x_787 * x_860
            - x_861 * x_879
        )
        + x_295
        * (
            -joint_velocity[1] * x_564 * x_878
            + joint_velocity[1] * x_582 * x_848
            + x_807 * x_848
            + x_808 * x_878
        )
        + x_600
        * (
            -x_549 * x_810
            + x_597 * x_828
            - x_762 * x_874
            + 0.000281 * x_782
            + 0.000281 * x_785
        )
        + x_600
        * (
            x_558 * x_863
            + x_597 * x_829
            - x_820 * x_875
            - 0.011402 * x_844
            - 0.011402 * x_846
        )
        + x_774
        * (
            x_552 * x_863
            + x_552 * x_864
            - x_575 * x_863
            - 0.011402 * x_834
            - 0.011402 * x_851
        )
        + x_774
        * (
            x_560 * x_810
            + x_560 * x_811
            + x_566 * x_810
            + 0.000281 * x_767
            - 0.000281 * x_793
        )
        + 0.5 * x_817 * x_866
        - 0.5 * x_827 * x_865
        + 0.0001405 * x_868
        + 0.005701 * x_869
        - 0.0001405 * x_870
        - 0.005701 * x_871
        + 0.005701 * x_872
        - 0.0001405 * x_873
    )
    x_881 = 3.0e-6 * joint_velocity[6]
    x_882 = 3.0e-6 * x_518
    x_883 = 3.0e-6 * x_820
    x_884 = (
        3.0e-6 * x_519
        + 3.0e-6 * x_520
        + 3.0e-6 * x_521
        + 3.0e-6 * x_523
        - 0.000587 * x_762
        + 0.000587 * x_765
        + 0.000587 * x_812
        + 0.000587 * x_813
        + 0.000587 * x_814
        + 0.000587 * x_816
        - 3.0e-6 * x_821
        + 3.0e-6 * x_822
        + 3.0e-6 * x_823
        + 3.0e-6 * x_824
        + 3.0e-6 * x_826
        + x_881
        + x_882
        - x_883
    )
    x_885 = 3.0e-6 * x_762
    x_886 = (
        3.0e-6 * x_765
        + 3.0e-6 * x_812
        + 3.0e-6 * x_813
        + 3.0e-6 * x_814
        + 3.0e-6 * x_816
        - x_885
    )
    x_887 = (
        0.000609 * joint_velocity[6]
        + 0.000609 * x_518
        + 0.000609 * x_519
        + 0.000609 * x_520
        + 0.000609 * x_521
        + 0.000609 * x_523
        - 0.000118 * x_820
        - 0.000118 * x_821
        + 0.000118 * x_822
        + 0.000118 * x_823
        + 0.000118 * x_824
        + 0.000118 * x_826
        + x_886
    )
    x_888 = x_218 * x_580
    x_889 = x_463 * x_562
    x_890 = x_212 * x_576
    x_891 = x_545 * x_548
    x_892 = x_524 * x_762
    x_893 = x_19 * x_582
    x_894 = x_229 * x_550
    x_895 = x_464 * x_894
    x_896 = x_51 * x_564
    x_897 = 3.0e-6 * x_218
    x_898 = 3.0e-6 * x_463
    x_899 = 3.0e-6 * x_212
    x_900 = 3.0e-6 * x_545
    x_901 = 3.0e-6 * x_19
    x_902 = x_376 * x_882
    x_903 = 3.0e-6 * x_51
    x_904 = x_229 * x_548
    x_905 = x_464 * x_904
    x_906 = (
        x_524 * x_883
        + x_548 * x_902
        - x_550 * x_900
        + x_554 * x_898
        - x_556 * x_903
        - x_567 * x_899
        + x_571 * x_897
        + x_573 * x_901
        + x_827 * x_881
        - 3.0e-6 * x_905
    )
    x_907 = (
        -0.000369 * joint_velocity[6] * x_866
        - 0.000369 * x_550 * x_679
        + 0.000118 * x_688
        - 0.000118 * x_689
        + 0.000118 * x_690
        - 0.000118 * x_691
        + 0.000118 * x_692
        - 0.000118 * x_693
        - 0.000118 * x_694
        - 0.000118 * x_695
        + x_818 * x_884
        - x_866 * x_887
        + 0.000369 * x_888
        + 0.000369 * x_889
        - 0.000369 * x_890
        - 0.000369 * x_891
        - 0.000369 * x_892
        + 0.000369 * x_893
        + 0.000369 * x_895
        - 0.000369 * x_896
        + x_906
    )
    x_908 = 0.000118 * joint_velocity[6]
    x_909 = 0.000118 * x_518
    x_910 = (
        0.000118 * x_519
        + 0.000118 * x_520
        + 0.000118 * x_521
        + 0.000118 * x_523
        - 0.000369 * x_820
        - 0.000369 * x_821
        + 0.000369 * x_822
        + 0.000369 * x_823
        + 0.000369 * x_824
        + 0.000369 * x_826
        + x_886
        + x_908
        + x_909
    )
    x_911 = (
        0.000587 * joint_velocity[6] * x_827
        + 0.000587 * x_19 * x_573
        - 0.000587 * x_212 * x_567
        + 0.000587 * x_218 * x_571
        + 0.000587 * x_463 * x_554
        - x_468 * x_903
        + x_473 * x_897
        + x_475 * x_901
        - 0.000587 * x_51 * x_556
        + 0.000587 * x_524 * x_820
        - x_524 * x_885
        - 0.000587 * x_545 * x_550
        + 0.000587 * x_548 * x_679
        - x_548 * x_900
        - x_550 * x_902
        + x_562 * x_898
        - x_564 * x_903
        - x_576 * x_899
        + x_580 * x_897
        + x_582 * x_901
        + x_687 * x_899
        - 3.0e-6 * x_691
        - 3.0e-6 * x_693
        - 3.0e-6 * x_694
        - 3.0e-6 * x_695
        - x_818 * x_910
        + x_827 * x_887
        - x_866 * x_881
        + 3.0e-6 * x_895
        - 0.000587 * x_905
    )
    x_912 = (
        -x_376 * x_550 * x_909
        + 0.000609 * x_688
        - 0.000609 * x_689
        + 0.000609 * x_690
        - 0.000609 * x_691
        + 0.000609 * x_692
        - 0.000609 * x_693
        - 0.000609 * x_694
        - 0.000609 * x_695
        - x_827 * x_884
        - x_866 * x_908
        + x_866 * x_910
        + 0.000118 * x_888
        + 0.000118 * x_889
        - 0.000118 * x_890
        - 0.000118 * x_891
        - 0.000118 * x_892
        + 0.000118 * x_893
        + 0.000118 * x_895
        - 0.000118 * x_896
        + x_906
    )
    x_913 = x_12**2
    x_914 = 0.0064 * x_12
    x_915 = 0.0128 * x_12
    x_916 = 0.006641 * x_12
    x_917 = 4.4e-5 * x_8
    x_918 = x_916 - x_917
    x_919 = x_12 * x_77
    x_920 = x_76 * x_919
    x_921 = 0.0064 * x_77
    x_922 = x_73 * x_913 * x_921
    x_923 = x_12 * x_73
    x_924 = 0.0064 * x_923
    x_925 = -x_924
    x_926 = x_76 + x_925
    x_927 = x_77 * x_926
    x_928 = x_12 * x_927
    x_929 = 0.2084 * x_77
    x_930 = x_77 * x_924
    x_931 = x_77**2
    x_932 = 0.0064 * x_931
    x_933 = x_12 * x_932
    x_934 = -x_933
    x_935 = x_73 * x_926 + x_934
    x_936 = 2 * x_935
    x_937 = x_185 - 0.015006 * x_923
    x_938 = x_77 * x_937
    x_939 = x_12 * x_938
    x_940 = x_12 * x_351
    x_941 = x_12 * x_352
    x_942 = x_940 + x_941
    x_943 = x_8 * x_942
    x_944 = -x_182 - 0.015006 * x_919
    x_945 = x_73 * x_944
    x_946 = x_12 * x_945
    x_947 = x_73 * x_937 + x_77 * x_944
    x_948 = x_418 - x_419
    x_949 = -x_404 - x_406
    x_950 = x_920 - x_922 - x_928
    x_951 = x_146 * x_948
    x_952 = x_148 * x_949
    x_953 = x_73 * x_951 - x_73 * x_952
    x_954 = 0.4208 * x_8
    x_955 = 0.4208 * x_12
    x_956 = 0.8416 * x_12
    x_957 = 0.2084 * x_919
    x_958 = 0.4168 * x_919
    x_959 = 0.1059 * x_228
    x_960 = 0.1059 * x_234
    x_961 = x_959 + x_960
    x_962 = x_148 * x_961
    x_963 = x_242 * x_948 + x_73 * x_962
    x_964 = x_223 * x_949 + x_224 * x_948
    x_965 = -x_940 - x_941
    x_966 = x_927 + x_930
    x_967 = x_645 - x_646 + 0.009432 * x_923
    x_968 = 0.009432 * x_159
    x_969 = x_160 * x_624
    x_970 = x_149 * x_433
    x_971 = x_760 - x_970
    x_972 = x_968 + x_969 + x_971
    x_973 = x_73 * x_972
    x_974 = x_12 * x_973
    x_975 = -x_629 - x_632 + 1.0e-6 * x_923
    x_976 = x_146 * x_967
    x_977 = x_148 * x_975
    x_978 = x_73 * x_976 - x_73 * x_977 + x_77 * x_972
    x_979 = x_148 * x_948
    x_980 = x_146 * x_949
    x_981 = x_979 + x_980
    x_982 = x_77 * x_951 - x_77 * x_952
    x_983 = x_146 * x_975
    x_984 = x_148 * x_967
    x_985 = x_227 * x_979
    x_986 = x_146 * x_961
    x_987 = 0.0064 * x_919
    x_988 = 0.2104 * x_8
    x_989 = x_73 * x_988
    x_990 = x_312 * x_73
    x_991 = x_77 * x_988
    x_992 = x_333 * x_77
    x_993 = -x_987 - x_989
    x_994 = -0.00965 * x_234 - x_719 + x_971
    x_995 = -0.045483 * x_150 + 0.00965 * x_487 - x_749 + x_759
    x_996 = x_159 * x_739
    x_997 = x_159 * x_740
    x_998 = 0.045483 * x_234
    x_999 = 1.0e-6 * x_487
    x_1000 = -x_996 + x_997 + x_998 + x_999
    x_1001 = x_1000 * x_148
    x_1002 = x_1001 * x_73 + x_242 * x_995 + x_468 * x_994
    x_1003 = x_229 * x_948
    x_1004 = x_925 + x_991
    x_1005 = x_951 - x_952
    x_1006 = x_229 * x_994
    x_1007 = x_1006 * x_148
    x_1008 = x_227 * x_995
    x_1009 = x_1008 * x_148
    x_1010 = x_1000 * x_146
    x_1011 = -x_979 - x_980
    x_1012 = -0.2104 * x_149 + 0.2104 * x_154
    x_1013 = x_412 * x_948
    x_1014 = 0.2104 * x_160
    x_1015 = 0.2104 * x_165
    x_1016 = -x_1014 - x_1015
    x_1017 = x_146 * x_926
    x_1018 = x_1017 - 0.2084 * x_150
    x_1019 = 0.0064 * x_73
    x_1020 = x_1012 - x_1019 * x_160
    x_1021 = x_227 * x_994 + x_229 * x_995
    x_1022 = x_1019 * x_149
    x_1023 = x_1016 + x_1022
    x_1024 = 0.2084 * x_161
    x_1025 = x_148 * x_926
    x_1026 = -x_1024 - x_1025
    x_1027 = -x_959 - x_960
    x_1028 = x_996 - x_997 - x_998 - x_999
    x_1029 = 0.011402 * x_486 - 0.011402 * x_487 + 0.029798 * x_617 + 0.029798 * x_618
    x_1030 = -0.000281 * x_486 + 0.000281 * x_487 - 0.029798 * x_620 - 0.029798 * x_621
    x_1031 = 0.011402 * x_620
    x_1032 = 0.000281 * x_617
    x_1033 = 0.011402 * x_621
    x_1034 = 0.000281 * x_618
    x_1035 = x_1031 - x_1032 + x_1033 - x_1034
    x_1036 = x_1029 * x_556 + x_1030 * x_564 + x_1035 * x_468
    x_1037 = 0.2104 * x_471 + 0.2104 * x_474
    x_1038 = x_1035 * x_229
    x_1039 = x_1038 * x_148
    x_1040 = 0.2084 * x_149
    x_1041 = -x_1017 * x_229 + x_1040 * x_239 - x_231 * x_914
    x_1042 = x_1037 - x_468 * x_914
    x_1043 = x_526 * x_948
    x_1044 = -0.2104 * x_245 + 0.2104 * x_246
    x_1045 = x_1017 * x_227 - x_1040 * x_231 - x_239 * x_914
    x_1046 = x_1030 * x_548
    x_1047 = x_1029 * x_550
    x_1048 = x_1044 - x_242 * x_914
    x_1049 = x_1030 * x_550
    x_1050 = x_1029 * x_548
    x_1051 = x_1035 * x_227 - x_1049 * x_229 + x_1050 * x_229
    x_1052 = x_1014 + x_1015
    x_1053 = x_404 + x_406
    x_1054 = x_1024 + x_1025
    x_1055 = -x_1022 + x_1052
    x_1056 = x_227 * x_743
    x_1057 = x_548 * x_948
    x_1058 = x_550 * x_948
    x_1059 = -0.2104 * x_568 + 0.2104 * x_572
    x_1060 = -0.2104 * x_577 + 0.2104 * x_581
    x_1061 = x_624 + x_634
    x_1062 = x_433 + x_648
    x_1063 = -x_444 + x_445
    x_1064 = x_444 - x_445
    x_1065 = x_73**2
    x_1066 = 0.0064 * x_1065
    x_1067 = -x_1066 - x_932
    x_1068 = 0.015006 * x_1065
    x_1069 = 0.015006 * x_931
    x_1070 = x_1061 * x_146
    x_1071 = x_1062 * x_148
    x_1072 = x_1061 * x_148
    x_1073 = x_1062 * x_146
    x_1074 = 0.1059 * x_239
    x_1075 = 0.1059 * x_241
    x_1076 = -x_1074 - x_1075
    x_1077 = 0.1059 * x_396
    x_1078 = x_148**2
    x_1079 = 0.1059 * x_1078
    x_1080 = x_1079 * x_240
    x_1081 = x_1076 * x_146
    x_1082 = x_1076 * x_148
    x_1083 = 0.00965 * x_241 + x_666 + x_706
    x_1084 = 0.00965 * x_467 + x_712 - x_751
    x_1085 = x_1083 * x_227 + x_1084 * x_229
    x_1086 = x_1084 * x_227
    x_1087 = x_1083 * x_229
    x_1088 = 0.000281 * x_467 + 0.029798 * x_549 + 0.029798 * x_555 - x_874
    x_1089 = x_1088 * x_550
    x_1090 = -0.011402 * x_467 + 0.029798 * x_558 - 0.029798 * x_563 + x_875
    x_1091 = x_1090 * x_548
    x_1092 = x_1088 * x_548
    x_1093 = x_1090 * x_550
    x_1094 = 0.1059 * x_551
    x_1095 = 0.1059 * x_559
    x_1096 = x_239 * x_828
    x_1097 = x_239 * x_829
    x_1098 = 0.011402 * x_555
    x_1099 = 0.000281 * x_563
    x_1100 = -x_1096 - x_1097 - x_1098 + x_1099
    x_1101 = -x_1089 * x_229 + x_1091 * x_229 + x_1100 * x_227
    x_1102 = 0.0064 * x_240 + 0.0064 * x_472
    x_1103 = 0.2084 * x_148
    x_1104 = x_1102 - x_1103 * x_230
    x_1105 = x_1079 * x_73
    x_1106 = x_146**2
    x_1107 = 0.1059 * x_1106
    x_1108 = x_1107 * x_73
    x_1109 = x_1105 + x_1108
    x_1110 = x_1074 + x_1075
    x_1111 = -x_665 + x_666
    x_1112 = x_146 * x_314
    x_1113 = x_148 * x_921
    x_1114 = x_1112 + x_1113
    x_1115 = 0.0064 * x_230 - 0.0064 * x_232
    x_1116 = x_146 * x_921
    x_1117 = -x_1116 + 0.2084 * x_396
    x_1118 = -x_1105 - x_1108
    x_1119 = -0.0064 * x_578 - 0.0064 * x_579
    x_1120 = 0.0064 * x_569 - 0.0064 * x_570
    x_1121 = -x_1112 - x_1113
    x_1122 = x_1077 * x_242 + x_1082 * x_73
    x_1123 = 0.1059 * x_421
    x_1124 = x_1077 * x_224 + x_1123 * x_223
    x_1125 = 0.1059 * x_552
    x_1126 = 0.1059 * x_560
    x_1127 = x_1111 * x_73
    x_1128 = x_1127 * x_12
    x_1129 = x_1068 * x_12
    x_1130 = x_1069 * x_12
    x_1131 = x_1063 * x_8
    x_1132 = x_1088 * x_564 + x_1090 * x_556 + x_1100 * x_468
    x_1133 = 0.045483 * x_239
    x_1134 = 1.0e-6 * x_231
    x_1135 = 1.0e-6 * x_146
    x_1136 = x_1135 * x_230
    x_1137 = x_240 * x_713
    x_1138 = -x_1133 - x_1134 + x_1136 - x_1137
    x_1139 = x_1138 * x_148
    x_1140 = x_1083 * x_468 + x_1084 * x_242 + x_1139 * x_73
    x_1141 = x_1100 * x_229
    x_1142 = x_1141 * x_148
    x_1143 = x_1070 * x_73 - x_1071 * x_73 + x_1111 * x_77
    x_1144 = x_1087 * x_148
    x_1145 = x_1086 * x_148
    x_1146 = x_1138 * x_146
    x_1147 = x_73 * x_76
    x_1148 = x_1066 * x_12
    x_1149 = -x_1147 + x_1148 + x_933
    x_1150 = x_1103 * x_240 + x_1115
    x_1151 = x_1133 + x_1134 - x_1136 + x_1137
    x_1152 = 0.0128 * x_73
    x_1153 = 0.4168 * x_73
    x_1154 = 0.1059 * x_412
    x_1155 = 0.1059 * x_230
    x_1156 = x_1155 * x_148
    x_1157 = x_148 * x_240
    x_1158 = 0.1059 * x_1157
    x_1159 = x_1 * x_47
    x_1160 = x_1079 + x_1107
    x_1161 = 0.063883 * x_1078
    x_1162 = 0.063883 * x_1106
    x_1163 = 0.009432 * x_148
    x_1164 = x_1135 + x_1163
    x_1165 = x_1135 - x_227 * x_707
    x_1166 = -x_229 * x_707 + x_713
    x_1167 = x_1165 * x_227 + x_1166 * x_229
    x_1168 = x_1166 * x_227
    x_1169 = x_1165 * x_229
    x_1170 = -0.029798 * x_575 + 0.011402 * x_687 + x_836
    x_1171 = x_1170 * x_548
    x_1172 = -0.029798 * x_566 - 0.000281 * x_687 - x_769
    x_1173 = x_1172 * x_550
    x_1174 = x_1172 * x_548
    x_1175 = x_1170 * x_550
    x_1176 = 0.011402 * x_560
    x_1177 = 0.000281 * x_552
    x_1178 = x_551 * x_839
    x_1179 = x_559 * x_776
    x_1180 = x_1176 - x_1177 + x_1178 + x_1179
    x_1181 = x_1171 * x_229 - x_1173 * x_229 + x_1180 * x_227
    x_1182 = x_1079 * x_77 + x_1107 * x_77
    x_1183 = 0.1059 * x_146
    x_1184 = x_1080 + x_1183 * x_242
    x_1185 = x_148 * x_151
    x_1186 = 0.1059 * x_1185
    x_1187 = x_148 * x_223
    x_1188 = 0.1059 * x_1187
    x_1189 = x_1183 * x_224 - x_1188
    x_1190 = x_229 * x_273
    x_1191 = x_148 * x_740
    x_1192 = x_1190 - x_1191
    x_1193 = -x_1190 + x_1191
    x_1194 = x_1161 * x_73 + x_1162 * x_73 + x_1164 * x_77
    x_1195 = x_1193 * x_148
    x_1196 = x_1165 * x_468 + x_1166 * x_242 + x_1195 * x_73
    x_1197 = x_1170 * x_556 + x_1172 * x_564 + x_1180 * x_468
    x_1198 = x_1180 * x_229
    x_1199 = x_1198 * x_148
    x_1200 = x_1193 * x_146
    x_1201 = x_1169 * x_148
    x_1202 = x_1168 * x_148
    x_1203 = x_1164 * x_73
    x_1204 = x_12 * x_1203
    x_1205 = 0.063883 * x_146
    x_1206 = 0.3143 * x_146
    x_1207 = 0.3143 * x_148
    x_1208 = x_1183 * x_229
    x_1209 = x_1183 * x_227
    x_1210 = 0.1059 * x_677
    x_1211 = x_1206 * x_229
    x_1212 = x_148 * x_166
    x_1213 = 0.045483 * x_229
    x_1214 = 1.0e-6 * x_227
    x_1215 = x_1213 + x_1214
    x_1216 = x_550 * x_770 + x_776
    x_1217 = x_548 * x_770 - x_839
    x_1218 = -x_1213 - x_1214
    x_1219 = 0.00965 * x_229**2
    x_1220 = 0.00965 * x_227**2
    x_1221 = x_1216 * x_548
    x_1222 = x_1217 * x_550
    x_1223 = x_1216 * x_550
    x_1224 = x_1217 * x_548
    x_1225 = x_229 * x_828
    x_1226 = x_229 * x_829
    x_1227 = -x_1225 - x_1226
    x_1228 = x_1221 * x_229 - x_1222 * x_229 + x_1227 * x_227
    x_1229 = x_665 - x_666
    x_1230 = x_1216 * x_556 + x_1217 * x_564 + x_1227 * x_468
    x_1231 = x_1227 * x_229
    x_1232 = x_1231 * x_148
    x_1233 = 0.00965 * x_227
    x_1234 = 0.00965 * x_229
    x_1235 = x_1219 * x_148
    x_1236 = x_1220 * x_148
    x_1237 = x_1218 * x_146
    x_1238 = x_1218 * x_148
    x_1239 = -x_1233 * x_242 + x_1234 * x_468 + x_1238 * x_73
    x_1240 = 0.1059 * x_229
    x_1241 = 6.78e-7 * joint_velocity[0]
    x_1242 = 6.78e-7 * joint_velocity[1]
    x_1243 = 0.006394896 * joint_velocity[0]
    x_1244 = x_1 * x_229
    x_1245 = 0.011402 * x_550
    x_1246 = 0.000281 * x_548
    x_1247 = x_1245 - x_1246
    x_1248 = 0.029798 * x_550**2
    x_1249 = 0.029798 * x_548**2
    x_1250 = x_1247 * x_227 + x_1248 * x_229 + x_1249 * x_229
    x_1251 = 0.029798 * x_548
    x_1252 = 0.029798 * x_550
    x_1253 = x_1247 * x_468 + x_1251 * x_556 - x_1252 * x_564
    x_1254 = x_1247 * x_229
    x_1255 = x_1254 * x_148
    x_1256 = 0.030837474 * joint_velocity[0]
    x_1257 = 0.030837474 * joint_velocity[1]
    x_1258 = x_1225 + x_1226
    x_1259 = x_1096 + x_1097 + x_1098 - x_1099
    x_1260 = 0.005701 * joint_velocity[0]
    x_1261 = 0.005701 * joint_velocity[1]
    x_1262 = 0.005701 * joint_velocity[2]
    x_1263 = 0.0001405 * joint_velocity[0]
    x_1264 = 0.0001405 * joint_velocity[1]
    x_1265 = 0.0001405 * joint_velocity[2]
    return np.array(
        [
            [
                -0.4208 * x_0 * x_43
                + 0.018678 * x_0 * (0.0154502808 * x_19 + x_54 * x_57 - x_56 * x_58)
                + x_0
                * (
                    -joint_velocity[1] * x_66
                    - joint_velocity[1] * x_67
                    + x_18 * x_65
                    + 0.011088 * x_19
                )
                - 0.0150444 * x_1 * (x_11 + x_17)
                + x_102 * x_361
                + x_107 * x_355
                + x_108 * x_174
                + x_108 * x_30
                - x_123 * x_125
                + x_123 * x_16
                + x_123 * x_190
                + x_123 * x_252
                + x_123 * x_260
                + x_123 * (x_233 * x_238 + x_253 * x_77)
                + x_123 * (x_473 * x_584 + x_571 * x_588 + x_580 * x_586)
                + x_124 * x_208
                - x_124 * x_211
                - x_125 * x_129
                + x_126 * x_260
                + x_126 * (-x_277 - x_280 * x_77 + x_281 * x_77)
                + x_126 * (x_233 * x_477 + x_469 * x_473 + x_483 * x_77)
                - x_127 * x_128
                + x_129 * x_16
                + x_129 * x_190
                + x_129 * (x_176 - x_178)
                + x_137 * x_138
                + x_137 * x_139
                + x_137 * x_192
                + x_137 * x_194
                + x_137 * x_259
                + x_137 * (x_263 - x_264)
                + x_137 * (x_567 * x_588 + x_576 * x_586 - x_592)
                + x_138 * x_145
                - x_138 * x_322
                - x_138 * x_446
                + x_139 * x_145
                - x_139 * x_322
                - x_139 * x_446
                - x_14 * x_217
                + x_14 * x_442
                + x_142 * x_143
                + x_142 * x_144
                + x_142 * x_259
                + x_142 * (x_268 + x_272)
                + x_142 * (-x_490 + x_492 - x_493)
                - x_143 * x_323
                - x_144 * x_323
                + x_145 * x_192
                + x_145 * (x_180 - x_181 + x_184 + x_186)
                + x_158 * x_425
                + x_158 * x_427
                + x_16 * x_175
                + x_168 * x_412
                + x_168 * x_413
                - x_169 * (x_151 * x_158 + x_162 * x_168)
                + x_170 * x_198
                + x_170 * x_25
                + x_170 * x_254
                + x_170 * x_48
                + x_170 * x_590
                + x_170 * x_96
                + x_173 * x_198
                + x_173 * x_28
                + x_173 * x_282
                + x_173 * x_484
                + x_173 * x_49
                + x_173 * x_97
                + x_174 * x_25
                + x_174 * x_48
                + x_175 * x_190
                + x_175 * x_252
                + x_187 * x_446
                - x_189 * (x_177 - x_179 - x_188)
                + x_190 * x_210
                + x_192 * x_193
                + x_192 * x_207
                + x_193 * x_194
                - x_195 * (x_12 * x_187 + x_176 * x_8 - x_178 * x_8)
                + x_198 * x_24
                + x_198 * x_27
                - x_199 * (x_155 * x_168 + x_158 * x_166)
                + 0.009805750912 * x_2 * x_3**2
                - 0.004487377536 * x_2
                + x_200 * x_41
                + x_200 * x_72
                + x_207 * x_38
                + x_210 * x_36
                + x_222 * x_47
                + x_225 * x_41
                + x_225 * x_43
                + x_226 * x_25
                + x_226 * x_62
                + x_238 * x_526
                + x_24 * x_25
                + x_24 * x_254
                + x_24 * x_48
                + x_24 * x_590
                + x_24 * x_96
                + x_25 * x_30
                + x_25 * x_31
                + x_250 * x_615
                - x_251 * (x_223 * x_250 + x_235 * x_238)
                - x_251 * (x_488 * x_584 + x_586 * x_619 + x_588 * x_622)
                - x_255 * (x_236 * x_250 + x_238 * x_247)
                - x_255 * (x_475 * x_584 + x_573 * x_588 + x_582 * x_586)
                + x_262 * x_412
                + x_267 * x_657
                + x_27 * x_28
                + x_27 * x_282
                + x_27 * x_484
                + x_27 * x_49
                + x_27 * x_97
                + x_271 * x_643
                + x_276 * x_312
                + x_276 * x_673
                - x_279 * (x_151 * x_267 + x_162 * x_271 - x_278)
                - x_279 * (x_223 * x_482 + x_235 * x_477 + x_469 * x_488)
                - x_283 * (x_155 * x_271 + x_166 * x_267 - x_277 * x_8)
                - x_283 * (x_236 * x_482 + x_247 * x_477 + x_469 * x_475)
                + x_285 * x_308
                + x_285 * x_313
                + x_285 * x_361
                + x_285 * x_381
                + x_285 * x_383
                + x_285 * x_673
                + x_298 * x_466
                - 0.018678 * x_3 * (x_45 * x_56 + 0.0154502808 * x_51 - x_53 * x_54)
                + x_3
                * (
                    joint_velocity[1] * x_63
                    + joint_velocity[1] * x_64
                    - x_50 * x_65
                    - 0.001072 * x_51
                )
                + x_3 * (-x_109 * x_220 - x_117 * x_214 + x_256 - 0.001043 * x_51)
                + x_30 * x_48
                + x_305 * x_485
                + x_305 * x_585
                + x_308 * x_335
                + x_308 * x_336
                + x_308 * x_338
                + x_308 * x_664
                + x_308 * x_85
                + x_31 * x_62
                + x_312 * x_494
                + x_313 * x_335
                + x_313 * x_336
                + x_313 * x_85
                + x_322 * x_337
                + x_322 * x_385
                + x_322 * x_80
                + x_322 * (-x_263 + x_264)
                + x_322 * (x_586 * x_674 + x_588 * x_675 + x_592)
                + x_323 * x_385
                + x_323 * (-x_268 - x_272)
                + x_323 * (x_490 - x_492 + x_493)
                + x_326 * x_332
                + x_326 * x_334
                + x_326 * x_355
                - x_33 * (-x_15 * x_8 + x_16 * x_8)
                + x_332 * x_340
                + x_332 * x_342
                + x_332 * x_384
                + x_332 * x_92
                + x_332 * (x_146 * x_262 + x_253)
                + x_332 * (-x_146 * x_591 + x_554 * x_588 + x_562 * x_586)
                + x_333 * x_384
                + x_333 * (-x_280 + x_281)
                + x_333 * (-x_146 * x_489 + x_146 * x_491 + x_483)
                + x_334 * x_340
                + x_334 * x_342
                + x_334 * x_92
                + x_335 * x_361
                + x_335 * x_381
                + x_335 * x_383
                + x_335 * x_673
                + x_336 * x_361
                + x_336 * x_381
                + x_336 * x_383
                + x_336 * x_673
                + x_337 * x_341
                + x_337 * x_446
                + x_338 * x_381
                + x_340 * x_355
                + x_341 * x_80
                + x_342 * x_355
                + x_365 * x_539
                + x_374 * x_547
                + x_381 * x_664
                + x_381 * x_85
                + x_383 * x_494
                + x_383 * x_85
                + x_386 * x_412
                + x_386 * x_413
                + x_386 * x_643
                - x_41 * x_42
                + x_41 * x_71
                + x_41 * (x_151 * x_250 + x_238 * x_261)
                + x_41 * (x_495 * x_584 + x_586 * x_660 + x_588 * x_661)
                + x_412 * x_443
                + x_412 * x_453
                + x_412 * x_454
                + x_412 * (-x_227 * x_662 + x_227 * x_663 - x_591)
                + x_413 * x_443
                + x_413 * x_453
                + x_413 * x_454
                + x_413 * (-x_489 + x_491)
                - x_42 * x_44
                - x_42 * x_46
                + x_425 * x_429
                + x_425 * x_450
                + x_425 * x_457
                + x_425 * x_459
                + x_425 * (x_244 + x_249)
                + x_425 * (x_587 + x_589)
                + x_427 * x_429
                + x_427 * x_450
                + x_427 * x_457
                + x_427 * x_459
                + x_427 * (x_478 + x_479 + x_480 + x_481)
                + x_429 * x_657
                + x_43 * (x_151 * x_482 + x_261 * x_477 + x_469 * x_495)
                + x_43 * (x_223 * x_267 + x_224 * x_271 + x_278)
                + x_44 * x_71
                + x_44 * (-x_177 + x_179 + x_188)
                + x_443 * x_643
                + x_450 * x_657
                + x_453 * x_643
                + x_454 * x_643
                + x_457 * x_657
                + x_459 * x_657
                + x_46 * (-x_37 - x_39)
                + x_469 * x_758
                + x_477 * x_743
                + x_482 * x_761
                + x_497 * x_698
                + x_506 * x_685
                - x_510 * x_511
                + x_510 * x_513
                + x_510 * x_514
                + x_510 * x_515
                + x_510 * x_528
                + x_510 * x_584
                - x_511 * x_758
                - x_511 * x_880
                + x_513 * x_758
                + x_513 * x_880
                + x_514 * x_758
                + x_514 * x_880
                + x_515 * x_758
                + x_515 * x_880
                + x_522 * x_697
                + x_522 * x_912
                + x_526 * x_527
                + x_526 * x_529
                + x_526 * x_530
                + x_526 * x_532
                + x_526 * x_533
                + x_526 * (-x_662 + x_663)
                + x_527 * x_743
                + x_528 * x_758
                + x_528 * x_880
                + x_529 * x_743
                + x_530 * x_743
                + x_532 * x_743
                + x_533 * x_743
                + x_584 * x_880
                + x_586 * x_867
                + x_588 * x_832
                - x_59 * (-x_12 * x_38 + x_36 * x_8)
                + x_593 * x_615
                + x_593 * x_761
                + x_615 * x_616
                + x_615 * x_623
                + x_615 * x_658
                + x_615 * x_659
                + x_615 * (-x_587 - x_589)
                + x_616 * x_761
                + x_623 * x_761
                + x_658 * x_761
                + x_659 * x_761
                + x_673 * x_85
                - x_7 * (x_37 + x_39)
                - x_7 * (x_4 + x_6)
                + x_71 * x_72
                + x_815 * x_911
                + x_825 * x_907
                + x_832 * (-x_124 * x_573 + x_324 * x_556)
                + x_832 * (x_158 * x_550 + x_527 * x_548)
                + x_832 * (x_238 * x_548 - x_250 * x_550)
                + x_832 * (-x_13 * x_573 + x_291 * x_556 - x_42 * x_661)
                + x_832 * (x_16 * x_571 + x_42 * x_620 + x_48 * x_556)
                + x_832 * (x_531 * x_548 + x_554 * x_92 + x_675 * x_80)
                + x_867 * (-x_124 * x_582 + x_324 * x_564)
                + x_867 * (x_158 * x_548 - x_527 * x_550)
                + x_867 * (-x_238 * x_550 - x_250 * x_548)
                + x_867 * (-x_13 * x_582 + x_291 * x_564 - x_42 * x_660)
                + x_867 * (x_16 * x_580 + x_42 * x_617 + x_48 * x_564)
                + x_867 * (-x_531 * x_550 + x_562 * x_92 + x_674 * x_80)
                - x_95 * (-x_81 - x_87 + x_94)
                - x_98 * (x_12 * x_80 - x_8 * x_86 + x_8 * x_93)
                + (-x_4 + x_5) * (-x_18 * x_70 - x_45 * x_57 + x_53 * x_58 - x_69)
            ],
            [
                x_1000 * x_761
                + x_1002 * x_173
                + x_1002 * x_27
                + x_1003 * x_308
                + x_1003 * x_381
                - x_1003 * x_510
                - x_1003 * x_758
                - x_1003 * x_880
                + x_1004 * x_332
                + x_1004 * x_334
                + x_1004 * x_355
                + x_1005 * x_332
                + x_1005 * x_333
                + x_1011 * x_322
                + x_1011 * x_323
                + x_1012 * x_412
                + x_1012 * x_413
                + x_1012 * x_643
                + x_1013 * x_227
                + x_1013
                + x_1016 * x_425
                + x_1016 * x_427
                + x_1016 * x_657
                + x_1018 * x_412
                + x_1018 * x_413
                + x_1018 * x_643
                + x_1020 * x_412
                + x_1020 * x_413
                + x_1020 * x_643
                + x_1021 * x_312
                + x_1021 * x_383
                + x_1023 * x_425
                + x_1023 * x_427
                + x_1023 * x_657
                + x_1026 * x_425
                + x_1026 * x_427
                + x_1026 * x_657
                + x_1027 * x_425
                + x_1028 * x_427
                + x_1029 * x_832
                + x_1030 * x_867
                + x_1035 * x_510
                + x_1035 * x_880
                + x_1036 * x_170
                + x_1036 * x_24
                + x_1037 * x_510
                + x_1037 * x_758
                + x_1037 * x_880
                + x_1041 * x_510
                + x_1041 * x_758
                + x_1041 * x_880
                + x_1042 * x_510
                + x_1042 * x_758
                + x_1042 * x_880
                + x_1043 * x_227
                + x_1043
                + x_1044 * x_526
                + x_1044 * x_743
                + x_1045 * x_526
                + x_1045 * x_743
                + x_1048 * x_526
                + x_1048 * x_743
                + x_1051 * x_308
                + x_1051 * x_381
                + x_1052 * x_615
                + x_1052 * x_761
                + x_1053 * x_615
                + x_1053 * x_761
                + x_1054 * x_615
                + x_1054 * x_761
                + x_1055 * x_615
                + x_1055 * x_761
                + x_1056 * x_948
                + x_1059 * x_832
                + x_1060 * x_867
                - x_12 * x_222
                + x_123 * x_954
                + x_123 * x_966
                + x_123 * x_982
                + x_123 * (x_233 * x_948 + x_77 * x_962)
                + x_123 * (x_1029 * x_571 + x_1030 * x_580 + x_1035 * x_473)
                + x_126 * x_982
                + x_126 * (x_1001 * x_77 + x_233 * x_995 + x_473 * x_994)
                + x_126 * (x_77 * x_976 - x_77 * x_977 - x_973)
                + 0.8416 * x_127
                + x_129 * x_954
                + x_129 * (x_938 - x_945)
                - x_137 * x_955
                - x_137 * x_957
                + x_137 * x_981
                + x_137 * (x_985 - x_986)
                + x_137 * (x_1029 * x_567 + x_1030 * x_576 - x_1039)
                - x_142 * x_956
                - x_142 * x_958
                + x_142 * x_981
                + x_142 * (x_983 + x_984)
                + x_142 * (-x_1007 + x_1009 - x_1010)
                - x_145 * x_955
                + x_145 * x_965
                + x_151 * x_698
                - x_169 * (x_151 * x_949 + x_162 * x_948)
                - x_170 * x_914
                + x_170 * x_935
                + x_170 * x_953
                + x_170 * x_963
                - x_173 * x_915
                + x_173 * x_936
                + x_173 * x_953
                + x_173 * x_978
                - x_174 * x_914
                + x_174 * x_947
                + x_175 * x_966
                + 0.115871288 * x_18 * x_56
                - x_18 * x_64
                - x_189 * (x_939 - x_943 - x_946)
                - 6.798123552e-7 * x_19
                - x_195 * (x_12 * x_942 + x_8 * x_938 - x_8 * x_945)
                - x_199 * (x_155 * x_948 + x_166 * x_949)
                - 0.328292 * x_208
                + 0.328292 * x_211
                - x_217 * x_8
                + x_223 * x_547
                + x_224 * x_539
                + x_226 * x_918
                - x_24 * x_914
                + x_24 * x_935
                + x_24 * x_953
                + x_24 * x_963
                - x_251 * (x_223 * x_961 + x_235 * x_948)
                - x_251 * (x_1029 * x_622 + x_1030 * x_619 + x_1035 * x_488)
                - x_255 * (x_236 * x_961 + x_247 * x_948)
                - x_255 * (x_1029 * x_573 + x_1030 * x_582 + x_1035 * x_475)
                + x_261 * x_685
                - x_27 * x_915
                + x_27 * x_936
                + x_27 * x_953
                + x_27 * x_978
                - x_279 * (x_1000 * x_223 + x_235 * x_995 + x_488 * x_994)
                - x_279 * (x_151 * x_975 + x_162 * x_967 - x_974)
                - x_283 * (x_1000 * x_236 + x_247 * x_995 + x_475 * x_994)
                - x_283 * (x_155 * x_967 + x_166 * x_975 - x_8 * x_973)
                - x_30 * x_914
                + x_30 * x_947
                - x_308 * x_987
                - x_308 * x_989
                + x_308 * x_993
                + x_31 * x_918
                - 0.0128 * x_312 * x_919
                + x_312 * x_972
                + x_313 * x_993
                - 0.174841524736 * x_32
                + x_322 * x_955
                + x_322 * x_957
                + x_322 * (-x_985 + x_986)
                + x_322 * (x_1029 * x_675 + x_1030 * x_674 + x_1039)
                + x_323 * x_956
                + x_323 * x_958
                + x_323 * (-x_983 - x_984)
                + x_323 * (x_1007 - x_1009 + x_1010)
                - x_33 * (x_10 + 0.2104 * x_913)
                + x_332 * x_926
                + x_332 * x_991
                + x_332 * (x_227 * x_951 + x_962)
                + x_332 * (x_1029 * x_554 + x_1030 * x_562 - x_1038 * x_146)
                + x_333 * (x_976 - x_977)
                + x_333 * (x_1001 - x_1006 * x_146 + x_1008 * x_146)
                + x_334 * x_926
                + x_355 * x_937
                + x_355 * x_991
                + x_361 * x_944
                - x_361 * x_989
                + x_361 * x_993
                - x_381 * x_987
                - x_381 * x_989
                + x_381 * x_993
                - x_383 * x_987
                - x_383 * x_989
                + x_383 * x_993
                + x_41 * x_950
                + x_41 * x_964
                + x_41 * (x_151 * x_961 + x_261 * x_948)
                + x_41 * (x_1029 * x_661 + x_1030 * x_660 + x_1035 * x_495)
                + x_412 * (-x_1038 - x_1049 * x_227 + x_1050 * x_227)
                + x_413 * x_948
                + x_413 * (-x_1006 + x_1008)
                + x_425 * x_949
                + x_425 * (x_1046 + x_1047)
                + x_427 * x_949
                + x_43 * x_964
                + x_43 * (x_1000 * x_151 + x_261 * x_995 + x_495 * x_994)
                + x_43 * (x_223 * x_975 + x_224 * x_967 + x_974)
                + x_44 * (-x_939 + x_943 + x_946)
                + x_442 * x_8
                + x_446 * x_942
                + x_446 * x_955
                - x_466 * x_919
                + x_485 * x_923
                + x_495 * x_697
                + x_495 * x_912
                + 5.11984e-5 * x_50 * x_56
                + x_50 * x_67
                + 0.002229538962064 * x_51
                + x_526 * (-x_1049 + x_1050)
                - x_53 * x_70
                - x_57 * x_68
                + x_585 * x_923
                - x_59 * (0.117892 * x_9 + 0.117892 * x_913)
                + x_615 * x_961
                + x_615 * (-x_1046 - x_1047)
                + x_643 * x_967
                + x_657 * x_975
                + x_660 * x_907
                + x_661 * x_911
                + x_673 * x_972
                - x_673 * x_987
                - x_673 * x_989
                + x_673 * x_993
                + x_72 * x_950
                + x_743 * x_995
                + x_758 * x_994
                + x_832 * (x_1057 - x_550 * x_961)
                + x_832 * (x_1059 - x_556 * x_914)
                + x_832 * (x_1057 * x_227 + x_550 * x_949)
                + x_832 * (-x_549 * x_914 + x_554 * x_926 + x_675 * x_957)
                + x_867 * (-x_1058 - x_548 * x_961)
                + x_867 * (x_1060 - x_564 * x_914)
                + x_867 * (-x_1058 * x_227 + x_548 * x_949)
                + x_867 * (x_558 * x_914 + x_562 * x_926 + x_674 * x_957)
                - x_95 * (-x_920 + x_922 + x_928)
                - x_954 * x_990
                + x_954 * x_992
                - x_98 * (x_8 * x_927 + x_8 * x_930 + x_913 * x_929)
            ],
            [
                9.628416e-5 * x_1 * x_12
                + x_1061 * x_643
                + x_1062 * x_657
                + x_1063 * x_446
                + x_1064 * x_145
                + x_1067 * x_123
                + x_1067 * x_175
                + x_1076 * x_615
                + x_1077 * x_413
                + x_1077 * x_526
                + x_1083 * x_758
                + x_1084 * x_743
                + x_1085 * x_312
                + x_1085 * x_383
                + x_1088 * x_867
                + x_1090 * x_832
                + 0.0028405095497008 * x_110
                + x_1100 * x_510
                + x_1100 * x_880
                + x_1101 * x_308
                + x_1101 * x_381
                + x_1102 * x_510
                + x_1102 * x_758
                + x_1102 * x_880
                + x_1104 * x_510
                + x_1104 * x_758
                + x_1104 * x_880
                + x_1109 * x_137
                + x_1109 * x_142
                - 0.0034465095497008 * x_111
                + x_1110 * x_425
                + x_1111 * x_312
                + x_1111 * x_673
                + x_1113 * x_425
                + x_1113 * x_427
                - x_1113 * x_615
                + x_1113 * x_657
                - x_1113 * x_761
                + x_1114 * x_425
                + x_1114 * x_427
                + x_1114 * x_657
                + x_1115 * x_526
                + x_1115 * x_743
                - x_1116 * x_412
                - x_1116 * x_413
                - x_1116 * x_643
                + x_1117 * x_412
                + x_1117 * x_413
                + x_1117 * x_643
                + x_1118 * x_322
                + x_1118 * x_323
                + x_1119 * x_867
                + x_1120 * x_832
                + x_1121 * x_615
                + x_1121 * x_761
                + x_1122 * x_170
                + x_1122 * x_24
                + x_1123 * x_425
                + x_1123 * x_427
                - x_1123 * x_615
                - x_1123 * x_761
                + x_1124 * x_41
                + x_1124 * x_43
                - 0.0028405095497008 * x_113
                + x_1132 * x_170
                + x_1132 * x_24
                + x_1138 * x_761
                - 5.11984e-5 * x_114 * x_203
                - 0.0077274676 * x_114 * x_209
                + x_1140 * x_173
                + x_1140 * x_27
                + x_1143 * x_173
                + x_1143 * x_27
                + x_1149 * x_41
                + x_1149 * x_72
                + x_1150 * x_526
                + x_1150 * x_743
                + x_1151 * x_427
                + x_1152 * x_308
                + x_1152 * x_381
                + x_1152 * x_383
                + x_1152 * x_673
                + x_1153 * x_142
                - x_1153 * x_323
                + x_1154 * x_1157
                + x_1154 * x_396
                + x_1156 * x_308
                + x_1156 * x_381
                - x_1156 * x_510
                - x_1156 * x_758
                - x_1156 * x_880
                + x_1158 * x_526
                + x_1158 * x_743
                + 0.00375151616 * x_1159 * x_3
                + 0.0178304 * x_116
                + 0.0077274676 * x_119 * x_205
                - 0.0178304 * x_122
                + x_123 * (x_1077 * x_233 + x_1082 * x_77)
                + x_123 * (x_1088 * x_580 + x_1090 * x_571 + x_1100 * x_473)
                + x_126 * (x_1070 * x_77 - x_1071 * x_77 - x_1127)
                + x_126 * (x_1083 * x_473 + x_1084 * x_233 + x_1139 * x_77)
                + x_129 * (-x_1068 - x_1069)
                + 6.0358817728e-6 * x_130
                - 1.30358817728e-5 * x_131
                + 6.0358817728e-6 * x_132
                + 5.11984e-5 * x_133 * x_205
                + x_137 * x_314
                + x_137 * (x_1080 - x_1081)
                + x_137 * (x_1088 * x_576 + x_1090 * x_567 - x_1142)
                + x_142 * (x_1072 + x_1073)
                + x_142 * (-x_1144 + x_1145 - x_1146)
                - x_169 * (x_1077 * x_162 + x_1123 * x_151)
                - x_189 * (-x_1129 - x_1130 - x_1131)
                - x_195 * (x_1063 * x_12 - x_1068 * x_8 - x_1069 * x_8)
                - x_199 * (x_1077 * x_155 + x_1123 * x_166)
                + x_242 * x_685
                - x_251 * (x_1076 * x_223 + x_1077 * x_235)
                - x_251 * (x_1088 * x_619 + x_1090 * x_622 + x_1100 * x_488)
                - x_255 * (x_1076 * x_236 + x_396 * x_610)
                - x_255 * (x_1088 * x_582 + x_1090 * x_573 + x_1100 * x_475)
                + x_256
                - x_279 * (x_1061 * x_162 + x_1062 * x_151 - x_1128)
                - x_279 * (x_1083 * x_488 + x_1084 * x_235 + x_1138 * x_223)
                - x_283 * (x_1061 * x_155 + x_1062 * x_166 - x_1127 * x_8)
                - x_283 * (x_1083 * x_475 + x_1084 * x_247 + x_1138 * x_236)
                - x_314 * x_322
                + x_322 * (-x_1080 + x_1081)
                + x_322 * (x_1088 * x_674 + x_1090 * x_675 + x_1142)
                + x_323 * (-x_1072 - x_1073)
                + x_323 * (x_1144 - x_1145 + x_1146)
                - 0.0128 * x_332 * x_77
                + x_332 * (x_1075 * x_148 + x_1082)
                + x_332 * (x_1088 * x_562 + x_1090 * x_554 - x_1141 * x_146)
                + x_333 * (x_1070 - x_1071)
                + x_333 * (x_1086 * x_146 - x_1087 * x_146 + x_1139)
                - 0.021406 * x_355 * x_77
                + 0.021406 * x_361 * x_73
                - x_396 * x_547
                + x_396 * x_698
                + x_41 * x_914
                + x_41 * (x_1076 * x_151 + x_1077 * x_261)
                + x_41 * (x_1088 * x_660 + x_1090 * x_661 + x_1100 * x_495)
                + x_412 * (-x_1089 * x_227 + x_1091 * x_227 - x_1141)
                + x_413 * (x_1086 - x_1087)
                + x_421 * x_539
                + x_425 * (x_1092 + x_1093)
                + x_43 * x_915
                + x_43 * (x_1061 * x_224 + x_1062 * x_223 + x_1128)
                + x_43 * (x_1083 * x_495 + x_1084 * x_261 + x_1138 * x_151)
                + x_44 * x_914
                + x_44 * (x_1129 + x_1130 + x_1131)
                + x_46 * (-x_916 + x_917)
                + x_466 * x_73
                + x_468 * x_697
                + x_468 * x_912
                + x_485 * x_77
                - 0.0012084349250612 * x_51
                + x_526 * (-x_1089 + x_1091)
                + x_556 * x_911
                + x_564 * x_907
                + x_585 * x_77
                - x_59 * (x_60 + x_61)
                + x_615 * (-x_1092 - x_1093)
                - x_7 * x_918
                + x_832 * (x_1120 - x_314 * x_675)
                + x_832 * (-x_1076 * x_550 + x_1095 * x_73)
                + x_832 * (x_1095 * x_240 + x_1126 * x_73)
                + x_867 * (x_1119 - x_314 * x_674)
                + x_867 * (-x_1076 * x_548 - x_1094 * x_73)
                + x_867 * (-x_1094 * x_240 + x_1125 * x_73)
                - x_95 * (x_1147 - x_1148 + x_934)
                - x_98 * (-x_1066 * x_8 - x_8 * x_932 - 0.2084 * x_923)
                + 0.0256 * x_990
                - 0.0256 * x_992
            ],
            [
                0.3867904 * joint_velocity[0] * x_331
                + 0.07019454 * joint_velocity[0] * x_345
                - 1.674e-5 * joint_velocity[0] * x_357
                - 0.00208866816 * x_1 * x_919
                - 0.08138070016 * x_104 * x_1159
                + x_1056 * x_1206
                + x_1064 * x_174
                + x_1064 * x_30
                - 0.08590526315144 * x_110
                + x_1109 * x_170
                + x_1109 * x_173
                + x_1109 * x_24
                + x_1109 * x_27
                + 0.09422126315144 * x_111
                + 0.08590526315144 * x_113
                + x_1153 * x_173
                + x_1153 * x_27
                + x_1160 * x_332
                + x_1160 * x_333
                + x_1164 * x_312
                + x_1164 * x_673
                + x_1165 * x_758
                + x_1166 * x_743
                + x_1167 * x_312
                + x_1167 * x_383
                + x_1170 * x_832
                + x_1172 * x_867
                + x_1180 * x_510
                + x_1180 * x_880
                + x_1181 * x_308
                + x_1181 * x_381
                + x_1182 * x_123
                + x_1182 * x_126
                + x_1183 * x_526
                + x_1184 * x_170
                + x_1184 * x_24
                + x_1189 * x_41
                + x_1189 * x_43
                + x_1192 * x_427
                + x_1193 * x_761
                + x_1194 * x_173
                + x_1194 * x_27
                + x_1196 * x_173
                + x_1196 * x_27
                + x_1197 * x_170
                + x_1197 * x_24
                + x_1206 * x_227 * x_526
                + x_1206 * x_412
                + x_1206 * x_413
                - x_1207 * x_425
                - x_1207 * x_427
                + x_1207 * x_615
                + x_1207 * x_761
                + x_1208 * x_308
                + x_1208 * x_381
                + x_1209 * x_412
                - x_1210 * x_425
                + x_1210 * x_615
                - x_1211 * x_510
                - x_1211 * x_758
                - x_1211 * x_880
                + x_123 * x_929
                + x_123 * (x_1079 * x_231 + x_1183 * x_233)
                + x_123 * (x_1170 * x_571 + x_1172 * x_580 + x_1180 * x_473)
                + 0.4168 * x_126 * x_77
                + x_126 * (x_1161 * x_77 + x_1162 * x_77 - x_1203)
                + x_126 * (x_1165 * x_473 + x_1166 * x_233 + x_1195 * x_77)
                + x_129 * (x_351 + x_352)
                + x_137 * (x_1170 * x_567 + x_1172 * x_576 - x_1199)
                + x_142 * (-x_1200 - x_1201 + x_1202)
                - x_146 * x_547
                + 0.272283 * x_146 * x_643
                + x_146 * x_698
                - x_148 * x_539
                - 0.272283 * x_148 * x_657
                - x_169 * (x_1183 * x_162 - x_1186)
                + x_170 * x_314
                - x_189 * x_942
                - x_195 * (x_183 + x_185 * x_77)
                - x_199 * (x_1183 * x_155 - 0.1059 * x_1212)
                + x_24 * x_314
                - x_251 * (x_1183 * x_235 + x_1188 * x_227)
                - x_251 * (x_1170 * x_622 + x_1172 * x_619 + x_1180 * x_488)
                - x_255 * (x_1183 * x_247 + x_1210 * x_236)
                - x_255 * (x_1170 * x_573 + x_1172 * x_582 + x_1180 * x_475)
                - x_279 * (-0.063883 * x_1185 - x_1204 + x_1205 * x_162)
                - x_279 * (x_1165 * x_488 + x_1166 * x_235 + x_1193 * x_223)
                - x_283 * (x_1165 * x_475 + x_1166 * x_247 + x_1193 * x_236)
                - x_283 * (-x_1203 * x_8 + x_1205 * x_155 - 0.063883 * x_1212)
                - 2.5120044e-7 * x_287
                + 2.5120044e-7 * x_288
                - 2.5120044e-7 * x_290
                + 1.674e-5 * x_300 * x_353
                + 0.3867904 * x_301 * x_320
                - 0.3867904 * x_302 * x_318
                - 0.07019454 * x_302 * x_349
                - 1.674e-5 * x_302 * x_360
                + 0.07019454 * x_320 * x_353
                + x_322 * (x_1170 * x_675 + x_1172 * x_674 + x_1199)
                + x_323 * (x_1200 + x_1201 - x_1202)
                + 0.00352879782724 * x_327
                - 0.00352879782724 * x_328
                - 0.00352879782724 * x_329
                + x_332 * (x_1079 * x_227 + x_1107 * x_227)
                + x_332 * (x_1170 * x_554 + x_1172 * x_562 - x_1198 * x_146)
                + x_333 * (x_1161 + x_1162)
                + x_333 * (x_1168 * x_146 - x_1169 * x_146 + x_1195)
                - x_41 * x_957
                + x_41 * (x_1183 * x_261 + x_1186 * x_227)
                + x_41 * (x_1170 * x_661 + x_1172 * x_660 + x_1180 * x_495)
                + x_412 * (x_1171 * x_227 - x_1173 * x_227 - x_1198)
                + x_413 * (x_1168 - x_1169)
                + x_425 * (x_1174 + x_1175)
                - x_43 * x_958
                + x_43 * (-0.063883 * x_1187 + x_1204 + x_1205 * x_224)
                + x_43 * (x_1165 * x_495 + x_1166 * x_261 + x_1193 * x_151)
                + x_44 * x_965
                + x_441
                + x_526 * (x_1171 - x_1173)
                + x_615 * (-x_1174 - x_1175)
                + x_674 * x_907
                + x_675 * x_911
                - x_677 * x_685
                + x_687 * x_697
                + x_687 * x_912
                + x_832 * (-x_1094 + 0.1059 * x_553)
                + x_832 * (x_1125 - 0.1059 * x_575)
                + x_832 * (-0.2084 * x_551 + 0.2084 * x_553)
                + x_867 * (-x_1095 - 0.1059 * x_561)
                + x_867 * (-x_1126 - 0.1059 * x_566)
                + x_867 * (-0.2084 * x_559 - 0.2084 * x_561)
            ],
            [
                0.006394896 * joint_velocity[1] * x_633
                - 0.00965 * x_1056
                - x_1074 * x_123 * x_148
                - x_1156 * x_170
                - x_1156 * x_24
                + x_1164 * x_142
                + x_1208 * x_137
                - x_1208 * x_322
                + x_1215 * x_427
                + x_1216 * x_832
                + x_1217 * x_867
                + x_1218 * x_761
                + x_1227 * x_510
                + x_1227 * x_880
                + x_1228 * x_308
                + x_1228 * x_381
                + x_1229 * x_173
                + x_1229 * x_27
                + x_123 * (x_1216 * x_571 + x_1217 * x_580 + x_1227 * x_473)
                + x_1230 * x_170
                + x_1230 * x_24
                + x_1234 * x_758
                + x_1239 * x_173
                + x_1239 * x_27
                - x_1240 * x_151 * x_41
                + x_1240 * x_425
                + x_1240 * x_548 * x_867
                + x_1240 * x_550 * x_832
                - x_1240 * x_615
                + x_1241 * x_644
                + x_1241 * x_652
                + x_1242 * x_647
                + x_1243 * x_628
                + x_1243 * x_636
                + 0.00028593 * x_1244 * x_223
                + 0.01114068 * x_1244 * x_237 * x_3
                + x_126 * (x_146 * x_624 - x_148 * x_433)
                + x_126 * (-x_1233 * x_233 + x_1234 * x_473 + x_1238 * x_77)
                + x_137 * (x_1216 * x_567 + x_1217 * x_576 - x_1232)
                + x_142 * (-x_1235 - x_1236 - x_1237)
                + x_227 * x_697
                + x_227 * x_912
                + x_229 * x_685
                - x_251 * (x_1216 * x_622 + x_1217 * x_619 + x_1227 * x_488)
                - x_255 * (x_1216 * x_573 + x_1217 * x_582 + x_1227 * x_475)
                - x_279 * x_972
                - x_279 * (x_1218 * x_223 - x_1233 * x_235 + x_1234 * x_488)
                - x_283 * (x_1218 * x_236 - x_1233 * x_247 + x_1234 * x_475)
                - x_283 * (x_147 * x_624 - x_159 * x_433 - x_668 - x_669)
                + x_322 * (x_1216 * x_675 + x_1217 * x_674 + x_1232)
                + x_323 * (-x_1135 - x_1163)
                + x_323 * (x_1235 + x_1236 + x_1237)
                - 6.031665975e-5 * x_327
                + 6.031665975e-5 * x_328
                + 6.031665975e-5 * x_329
                - 0.1059 * x_332 * x_687
                + x_332 * (x_1216 * x_554 + x_1217 * x_562 - x_1231 * x_146)
                + x_333 * (-x_273 + x_275)
                + x_333 * (-x_1219 * x_146 - x_1220 * x_146 + x_1238)
                + 0.006394896 * x_376 * x_642
                - 0.006394896 * x_401 * x_638
                + 6.78e-7 * x_401 * x_655
                - 0.000408525141168 * x_408
                + 0.000408525141168 * x_409
                + x_41 * (x_1216 * x_661 + x_1217 * x_660 + x_1227 * x_495)
                + 0.000408525141168 * x_410
                + x_412 * (x_1221 * x_227 - x_1222 * x_227 - x_1231)
                + x_413 * (-x_1219 - x_1220)
                - 4.3312674e-8 * x_414
                + 4.3312674e-8 * x_415
                - 4.3312674e-8 * x_416
                + x_425 * (x_1223 + x_1224)
                + x_43 * (x_1218 * x_151 - x_1233 * x_261 + x_1234 * x_495)
                + x_43 * (-x_760 - x_968 - x_969 + x_970)
                + x_526 * (x_1221 - x_1222)
                + x_585
                + x_615 * (-x_1223 - x_1224)
                - 6.78e-7 * x_656
                - x_894 * x_907
                + x_904 * x_911
            ],
            [
                0.05295 * joint_velocity[0] * x_517
                + 0.05295 * joint_velocity[1] * x_407
                + 0.030837474 * joint_velocity[2] * x_710
                + 6.78e-7 * joint_velocity[2] * x_752
                - x_1000 * x_279
                + x_1027 * x_41
                + x_1028 * x_43
                + x_1110 * x_170
                + x_1110 * x_24
                + x_1151 * x_173
                + x_1151 * x_27
                + x_1154 * x_227
                + x_1192 * x_323
                + x_1193 * x_142
                + x_1209 * x_332
                + x_1210 * x_137
                - x_1210 * x_322
                + x_1215 * x_312
                + x_1215 * x_383
                + x_123 * (-x_1155 + 0.1059 * x_232)
                + x_123 * (x_1247 * x_473 + x_1251 * x_571 - x_1252 * x_580)
                + x_1240 * x_308
                + x_1240 * x_381
                + x_1241 * x_746
                + x_1241 * x_747
                + x_1242 * x_671
                + x_1242 * x_750
                + x_1247 * x_510
                + x_1247 * x_880
                + x_1250 * x_308
                + x_1250 * x_381
                + x_1253 * x_170
                + x_1253 * x_24
                + x_1256 * x_716
                + x_1256 * x_735
                + x_1257 * x_703
                + x_1257 * x_727
                + x_126
                * (-x_1135 * x_239 - 0.045483 * x_230 + x_231 * x_713 - 1.0e-6 * x_240)
                + x_137 * (x_1251 * x_567 - x_1252 * x_576 - x_1255)
                - x_251 * x_961
                - x_251 * (x_1247 * x_488 + x_1251 * x_622 - x_1252 * x_619)
                - x_255 * (0.1059 * x_246 - x_601)
                - x_255 * (x_1247 * x_475 + x_1251 * x_573 - x_1252 * x_582)
                - x_283
                * (x_149 * x_739 - x_149 * x_740 + 0.045483 * x_246 + 1.0e-6 * x_474)
                + x_322 * (x_1251 * x_675 - x_1252 * x_674 + x_1255)
                + x_332 * (x_1251 * x_554 - x_1252 * x_562 - x_1254 * x_146)
                + x_333 * (-x_1135 * x_229 + x_227 * x_713)
                - 0.00700998583062 * x_408
                + 0.00700998583062 * x_409
                + x_41 * (x_1247 * x_495 + x_1251 * x_661 - x_1252 * x_660)
                + 0.00700998583062 * x_410
                + x_412 * (x_1248 * x_227 + x_1249 * x_227 - x_1254)
                + x_413 * (-x_739 + x_740)
                + 6.78e-7 * x_499 * x_755
                - 6.78e-7 * x_508 * x_741
                + 0.05295 * x_509 * x_524
                + x_526 * (x_1248 + x_1249)
                + 0.135698 * x_548 * x_832
                - x_548 * x_907
                - 0.135698 * x_550 * x_867
                - x_550 * x_911
                + 6.5427e-9 * x_594
                - 6.5427e-9 * x_595
                + 6.5427e-9 * x_596
                + x_698
                + 0.0002975816241 * x_699
                - 0.0002975816241 * x_700
                - 0.0002975816241 * x_701
                - 0.030837474 * x_738
                + 0.030837474 * x_742
            ],
            [
                0.005701 * joint_velocity[3] * x_773
                - 0.0001405 * joint_velocity[3] * x_838
                - x_1035 * x_251
                + x_1180 * x_137
                + x_123
                * (-x_230 * x_828 - x_230 * x_829 + 0.011402 * x_570 - 0.000281 * x_579)
                + x_1247 * x_425
                + x_1258 * x_308
                + x_1258 * x_381
                + x_1259 * x_170
                + x_1259 * x_24
                + x_1260 * x_788
                + x_1260 * x_809
                + x_1261 * x_778
                + x_1261 * x_802
                + x_1262 * x_766
                + x_1262 * x_786
                - x_1263 * x_849
                - x_1263 * x_862
                - x_1264 * x_840
                - x_1264 * x_859
                - x_1265 * x_833
                - x_1265 * x_847
                - x_255
                * (
                    -0.011402 * x_568
                    + 0.011402 * x_572
                    + 0.000281 * x_577
                    - 0.000281 * x_581
                )
                + x_322 * (-x_1176 + x_1177 - x_1178 - x_1179)
                + x_332
                * (-0.011402 * x_551 + x_552 * x_776 + 0.000281 * x_559 + x_560 * x_839)
                + x_41 * (-x_1031 + x_1032 - x_1033 + x_1034)
                + x_412 * (x_548 * x_776 + x_550 * x_839)
                + x_526 * (x_828 + x_829)
                + x_615 * (-x_1245 + x_1246)
                - 6.50422825e-5 * x_699
                + 6.50422825e-5 * x_700
                + 6.50422825e-5 * x_701
                - 0.005701 * x_817 * x_818
                - 0.0001405 * x_818 * x_865
                + 0.005701 * x_827 * x_830
                + 0.0001405 * x_830 * x_866
                - 0.000169878398 * x_868
                + 4.186619e-6 * x_869
                + 0.000169878398 * x_870
                - 4.186619e-6 * x_871
                + 4.186619e-6 * x_872
                + 0.000169878398 * x_873
                + x_912
            ],
        ]
    )
