"""
    Nuaudit

    Nanaged Audit Trails for Cloud Applications.  # noqa: E501

    The version of the OpenAPI document: 0.14.0
    Contact: support@nuaudit.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nuaudit_python_autogen.api_client import ApiClient, Endpoint as _Endpoint
from nuaudit_python_autogen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nuaudit_python_autogen.model.api_key import APIKey
from nuaudit_python_autogen.model.api_key_mutation import APIKeyMutation
from nuaudit_python_autogen.model.error_message import ErrorMessage
from nuaudit_python_autogen.model.http_validation_error import HTTPValidationError


class APIKeysApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_api_key_endpoint = _Endpoint(
            settings={
                'response_type': (APIKey,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/api_clients/{api_client_id}/api_keys',
                'operation_id': 'create_api_key',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'api_client_id',
                    'api_key_mutation',
                ],
                'required': [
                    'organization_id',
                    'api_client_id',
                    'api_key_mutation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'api_client_id':
                        (str,),
                    'api_key_mutation':
                        (APIKeyMutation,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'api_client_id': 'api_client_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'api_client_id': 'path',
                    'api_key_mutation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_api_key_endpoint = _Endpoint(
            settings={
                'response_type': (APIKey,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/api_clients/{api_client_id}/api_keys/{api_key_id}',
                'operation_id': 'delete_api_key',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'api_client_id',
                    'api_key_id',
                ],
                'required': [
                    'organization_id',
                    'api_client_id',
                    'api_key_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'api_client_id':
                        (str,),
                    'api_key_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'api_client_id': 'api_client_id',
                    'api_key_id': 'api_key_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'api_client_id': 'path',
                    'api_key_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_api_keys_for_api_client_endpoint = _Endpoint(
            settings={
                'response_type': ([APIKey],),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/api_clients/{api_client_id}/api_keys',
                'operation_id': 'list_api_keys_for_api_client',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'api_client_id',
                ],
                'required': [
                    'organization_id',
                    'api_client_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'api_client_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'api_client_id': 'api_client_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'api_client_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_api_key_endpoint = _Endpoint(
            settings={
                'response_type': (APIKey,),
                'auth': [
                    'APIKeyHeader'
                ],
                'endpoint_path': '/{organization_id}/api_clients/{api_client_id}/api_keys/{api_key_id}',
                'operation_id': 'update_api_key',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'api_client_id',
                    'api_key_id',
                    'api_key_mutation',
                ],
                'required': [
                    'organization_id',
                    'api_client_id',
                    'api_key_id',
                    'api_key_mutation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'api_client_id':
                        (str,),
                    'api_key_id':
                        (str,),
                    'api_key_mutation':
                        (APIKeyMutation,),
                },
                'attribute_map': {
                    'organization_id': 'organization_id',
                    'api_client_id': 'api_client_id',
                    'api_key_id': 'api_key_id',
                },
                'location_map': {
                    'organization_id': 'path',
                    'api_client_id': 'path',
                    'api_key_id': 'path',
                    'api_key_mutation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_api_key(
        self,
        organization_id,
        api_client_id,
        api_key_mutation,
        **kwargs
    ):
        """Create Api Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_api_key(organization_id, api_client_id, api_key_mutation, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            api_client_id (str):
            api_key_mutation (APIKeyMutation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['api_client_id'] = \
            api_client_id
        kwargs['api_key_mutation'] = \
            api_key_mutation
        return self.create_api_key_endpoint.call_with_http_info(**kwargs)

    def delete_api_key(
        self,
        organization_id,
        api_client_id,
        api_key_id,
        **kwargs
    ):
        """Delete Api Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_api_key(organization_id, api_client_id, api_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            api_client_id (str):
            api_key_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['api_client_id'] = \
            api_client_id
        kwargs['api_key_id'] = \
            api_key_id
        return self.delete_api_key_endpoint.call_with_http_info(**kwargs)

    def list_api_keys_for_api_client(
        self,
        organization_id,
        api_client_id,
        **kwargs
    ):
        """List Api Keys For Api Client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_api_keys_for_api_client(organization_id, api_client_id, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            api_client_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [APIKey]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['api_client_id'] = \
            api_client_id
        return self.list_api_keys_for_api_client_endpoint.call_with_http_info(**kwargs)

    def update_api_key(
        self,
        organization_id,
        api_client_id,
        api_key_id,
        api_key_mutation,
        **kwargs
    ):
        """Update Api Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_api_key(organization_id, api_client_id, api_key_id, api_key_mutation, async_req=True)
        >>> result = thread.get()

        Args:
            organization_id (str):
            api_client_id (str):
            api_key_id (str):
            api_key_mutation (APIKeyMutation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['organization_id'] = \
            organization_id
        kwargs['api_client_id'] = \
            api_client_id
        kwargs['api_key_id'] = \
            api_key_id
        kwargs['api_key_mutation'] = \
            api_key_mutation
        return self.update_api_key_endpoint.call_with_http_info(**kwargs)

