from setuptools import setup, find_packages

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name='streak_cal',
    version='0.3',
    author="Kacha Mukabe",
    description="A cli calendar for keeping track of streaks",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/kachaMukabe/streak",
    packages=find_packages(),
    include_package_data=True,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
    install_requires=[
        'Click',
        'tinydb',
        'termcolor',
        'colorama'
    ],
    entry_points='''
        [console_scripts]
        streak-cal=streak.streak:cli
    ''',
)