#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : MICTRZOO.
# @File         : profile2vec
# @Time         : 2021/3/8 2:44 下午
# @Author       : yuanjie
# @WeChat       : 313303303
# @Software     : PyCharm
# @Description  : 垂类包向量化


from meutils.pipe import *
from meutils.aizoo import tf_io
from meutils.np_utils import normalize
from meutils.date_utils import date_difference
from meutils.http_utils.results import get_simbert_vectors
from meutils.log_utils import logger4feishu

from ctrzoo.utils.db import mysql_mitvpush_conn

magic_cmd("kinit -k -t ./data/s_feeds.keytab s_feeds@XIAOMI.HADOOP")

operator_pre_push_data = {
    'userCategory':
        [
            '科技', '科技', '科技', '科技', '科技', '科技', '科技', '科技', '科技', '科技',
            '美女', '美女', '美女', '美女', '美女', '美女', ' 美女', '美女', '美女', '美女',
            '影视', '影视', '影视', '影视', '影视', '影视', '影视', '影视', '影视', '影视',
            '搞笑', '搞笑', '搞笑', '搞笑', '搞笑', '搞笑', '搞笑', '搞笑', '搞笑', '搞笑',
            '小品', '小品', '小品', '小品', '小品', '小品', '小品', '小品', '小品', '小品',
            '游戏', '游戏', '游戏', '游戏', '游戏', '游戏', '游戏', '游戏', '游戏', '游戏', '游戏',
            '少儿', '少儿', '少儿', '少儿', '少儿', '少儿', '少儿', '少儿', '少儿', '少儿',
            '美食', '美食', '美食', '美食', '美食', '美食', '美食', '美食', '美食', '美食',
            '动漫', '动漫', '动漫', '动漫', '动漫', '动漫', '动漫', '动漫', '动漫', '动漫',
            '电视剧', '电视剧', '电视剧', '电视剧', '电视剧', '电视剧', '电视剧', '电视剧', '电视剧', '电视剧'
        ],
    'title':
        [
            '中国首款“自平衡轮式机器人”问世，智能能躲避障碍，永远摔不倒',
            '这是距地球3亿公里，小行星龙宫的真实画面，由隼鸟2号探测器拍摄',
            'Discoverey：宇宙大爆炸，爱因斯坦的宇宙观',
            '首款“个人飞行器”问世，飞行高度3000米最高时速150公里',
            '研科技：五分钟教你装系统',
            '新科技：了不起的中国科技研发世界最大整平船',
            '《科技相对论|谷歌大宇宙（上）：改变世界的黑科技帝国》',
            '长征八号火箭攻克关键新技术，开辟火箭研制创新之路小时',
            '飞机与火箭有何区别？火箭能够进入太空，为何飞机却不能？',
            '国产无人机又放“大招”，新型无人机航程无限，飞行高度2万米！',

            '街拍美女：夏日的三里屯，别有一番风景',
            '时尚街拍美女，这么酷飒的美女，你喜欢吗？',
            '时尚潮流的bachata，身材好颜值高的美女跳舞太有气质了',
            '她被誉为微胖女神，气质堪称最佳，依然有心动的感觉',
            '日本最美天气女播报员大石惠 这颜值太能打了！',
            '太有范了！全网超火swagger舞蹈，美女舞姿优美洒脱！',
            '维密超模百科：超级名模吉赛尔 · 邦臣',
            '李知恩的美颜合集，颜值真是太高了，最美瞬间！',
            '舞蹈女神日常秀《格斗宝贝》，颜值在可爱面前，真的是一文不值',
            '射箭美女，不仅颜值超高，还这么可爱，反正我是爱了',

            '美女和小伙正在对台词，合伙骗老妈，妈妈从身后出现',
            '盗墓笔记：吴邪遭盗墓贼追杀，小哥及时出现，吓退盗墓贼',
            '拆弹专家：看到炸弹的吨位，拆弹专家都慌神了',
            '鼠胆英雄：胆小如鼠的青龙帮小弟，阴差阳错当上警察',
            '速度与激情混剪：天堂向左，一路走好 #速度与激情',
            '长城：长城内部机关重重，饕餮想爬上长城，怎料长城竟开了条缝！',
            '我的前半生: 唐晶与贺涵闹矛盾,罗平挑拨离间,想抢走贺涵的客户',
            '盘点正能量的励志台词：人生就像射箭，梦想就像箭靶子！',
            ' 西游伏妖篇: 如来从天而降,真人被他打回原形,原来是个九头金雕',
            '人民的名义: 程度监视李达康,祁同伟当场发飙: 谁给你的权利?',

            '陈翔六点半：为一顿饭，妹爷坑陈翔，陈翔坑老大爷，不带这么玩的',
            '搞笑动画！你小时候也被长辈逼着做过什么事吗？',
            '小伙套路美女2000元，没想美女套路更深，反骗小伙8000元',
            '搞笑剧小伙家门口干活，女骗子找上门来，对话从开头笑到结尾',
            '短剧：大卫张装阔假装开车展，没想被紫薇和老六识破，结局太逗了',
            '搞笑段子：兄弟两人去吃饭，谁付账成了大问题，看完笑到我了',
            '憋笑大挑战：岳云鹏版的蒙拉丽莎，成功把我逗笑了！',
            '爆笑小品：小沈阳，宋晓峰套路小沈阳，小沈阳的反应超搞笑',
            '学神，学霸，学渣，学弱“追姑娘”区别，看完学渣别笑喷！哈哈',
            '家庭幽默录像：动物通灵性？太可爱了！',

            '大个儿豁牙子为二丫打了起来，宋小宝不劝架，却在一旁看热闹',
            '谢广坤表演魔术，谁知却被白清明当场拆穿了，太尴尬了',
            '小品《真假老板》，小偷修睿去偷东西，没想到被当成了新来的老板',
            '德云社搞笑片段，岳云鹏再爆金句，直言孙越的肚子像超市！',
            '实现梦想要努力，创新服务真便民，巩汉林被逼着给狗办户口',
            '大潘跟潘长江同龄？潘长江：看一眼少一眼嘛 潘长江这嘴也挺毒啊',
            '郭达蔡明爆笑小品，蔡明卖房被郭达投诉，蔡明应对手法太搞笑了',
            '郭冬临小品《过年》，郭冬临接媳妇回家，被郭达误会笑点十足',
            '沈春阳大变造型惊呆小沈阳，小沈阳沈春阳小品，笑料不断',
            '张小斐贾玲进古墓 贾玲竟被当成了熊 贾玲你现在是有点熊人啊',

            '五排第一个选阿轲，对面挑选鲁班？秒他十次！',
            '全网细致传授，露娜中路gank与连招传授。',
            '干将怎样预判团战走向，你是否也碰见过这种题目，干将意识！',
            '迷你世界生存：小伙伴一直在家里面偷懒，又不肯帮忙去寻找金矿石',
            '迷你世界糖糖解说：不要碰到草快，你们可以在这个世界生存几天',
            '第五人格：老牌监管蜘蛛上分气球刀也能空，看牧童运营四杀',
            '斗地主：一张牌的腥风血雨！9炸贪功杀气腾腾，王炸天裁义愤填膺',
            'LOL徐老师来巡山：稻草人乌鸦坐飞机，隔空取物夺大龙',
            'LOL：难度“最低”的ADC？女枪：但我比第一伤害高',
            '和平精英：和平精英里吃鸡和刺激战场有什么不同？看了就知道',
            '绝地求生高玩实录22 绝地求生中真正的大杀器',

            ' 少儿乐园：侏罗纪小恐龙玩具蛋展示',
            '凌乱的积木谁说我拿它们没办法？炫彩射击枪玩具宝宝喜笑颜开',
            '喜欢吃火锅吗？火锅大乐斗儿童益智玩具双人PK用餐具夹丸子',
            '少儿乐园：卡通列车头机器人玩具变形',
            '大象看到牛牛推来一车苹果，原来自己种的，分给每一个好朋友',
            '如何用18片乐高搭建马车？开箱乐高圣诞倒数日历第4天',
            '小狐狸开潜水艇好朋友手工彩泥培乐多diy',
            '儿童剧：下雨了没办法去郊游，佩奇乔治为什么还是很开心？',
            '积木猪魔法变成假鲁鲁偷吃大白兔奶糖真鲁鲁被冤枉委屈地哭',
            '电动积木三角龙跑跑跑！一起来跳野狼DISCO！',

            '终于找到鸡肠最正确的吃法，配方个窍门都在这，上桌就抢吃光',
            '瘦肉咬不动？80岁老奶奶的秘制做法，不用一滴油，没牙齿也能吃',
            '五花肉放到大米里面，教你从没吃过的做法，出锅未来看馋了，真香',
            '没想到辣条和泡面的搭配居然这么好吃！香辣过瘾#深夜放毒',
            '校门口最让你难忘的小吃是什么？我最喜欢的炸香肠，闻到香味的快',
            ' 肉松蛋糕卷的家常做法，香甜细腻口感丰富（一',
            '茄子焖面怎么做好吃？教你家常的做法',
            '杏鲍菇炒鸡丁怎么做才鲜嫩多汁？大厨分享上浆的技巧，教你在家做',
            '四川师傅这样炒河虾，肉质细腻鲜嫩美味，一次做3斤不够吃',
            '杨子姗同款燕麦南瓜饼，营养低脂，有手就行',

            '卡卡西和自来也的差距, 面对佩恩两人已经很吃力',
            '迪士尼反派角色中，你知道哪些被误解了，而哪些则纯粹邪恶？',
            '海贼王：海贼王争夺战，路飞能否成为海贼王呢',
            '火影忍者：悲惨身世揭晓！鸣人找到长门的藏身之地，嘴遁模式上线',
            '一人之下3：宝儿姐在线教王也埋人，道长也学坏了，听话模样太萌',
            '悟空实现财富自由，前往界王神殿修行，贝吉塔的假期终于来啦！',
            '传说中的海贼现身，路飞遇大危机，究竟和路飞有什么深仇大恨？',
            '光头超人对战美女英雄，开启嘴遁模式，竟想跟对手讲道理？',
            '哆啦A梦变成胖虎一样妹控和霸道，为了点心和胖虎起争执',
            '数码宝贝三大最弱究极体！胜率完全为0，被喊滚出究极体行列！',

            '觉醒年代：北大学子瞧不起青年毛泽东，下一秒惨遭打脸，教授开骂',
            '乡村爱情13：美女书记点拨晓峰，爱情故事会，应多讲讲初恋美好',
            '战场：日本军舰夹击英方商船，断定中国不敢动，岂料下秒就被炸翻',
            '女孩意外怀孕，穷男友决定不再隐藏身份，直接带她回豪宅',
            '小幸福：儿媳坐着月子还练瑜伽，婆婆一看姿势吓坏，姥姥：多好看',
            '甄嬛传：甄嬛终于肯让皇上留宿了，可她的眼里已经没有爱了',
            '琅琊榜：曾经的林殊有多耀眼？13年后，梅长苏的撕心裂肺说明一切',
            '欢乐颂：关关和邱莹莹被小包总订的酒店惊讶到，曲筱绡：两土鳖',
            '山海情：蘑菇贩子放狠话，凌教授忍不了直接动手，结果笑喷了',
            '婚姻背后：美女来借拖把，小伙开门看见这一幕，下秒举动太逗了'

        ],

    'subTitle':
        [
            '中国首款“自平衡轮式机器人”问世，智能能躲避障碍，永远摔不倒',
            '这是距地球3亿公里，小行星龙宫的真实画面，由隼鸟2号探测器拍摄',
            'Discoverey：宇宙大爆炸，爱因斯坦的宇宙观',
            '首款“个人飞行器”问世，飞行高度3000米最高时速150公里',
            '研科技：五分钟教你装系统',
            '新科技：了不起的中国科技研发世界最大整平船',
            '《科技相对论|谷歌大宇宙（上）：改变世界的黑科技帝国》',
            '长征八号火箭攻克关键新技术，开辟火箭研制创新之路小时',
            '飞机与火箭有何区别？火箭能够进入太空，为何飞机却不能？',
            '国产无人机又放“大招”，新型无人机航程无限，飞行高度2万米！',

            '街拍美女：夏日的三里屯，别有一番风景',
            '时尚街拍美女，这么酷飒的美女，你喜欢吗？',
            '时尚潮流的bachata，身材好颜值高的美女跳舞太有气质了',
            '她被誉为微胖女神，气质堪称最佳，依然有心动的感觉',
            '日本最美天气女播报员大石惠 这颜值太能打了！',
            '太有范了！全网超火swagger舞蹈，美女舞姿优美洒脱！',
            '维密超模百科：超级名模吉赛尔 · 邦臣',
            '李知恩的美颜合集，颜值真是太高了，最美瞬间！',
            '舞蹈女神日常秀《格斗宝贝》，颜值在可爱面前，真的是一文不值',
            '射箭美女，不仅颜值超高，还这么可爱，反正我是爱了',

            '美女和小伙正在对台词，合伙骗老妈，妈妈从身后出现',
            '盗墓笔记：吴邪遭盗墓贼追杀，小哥及时出现，吓退盗墓贼',
            '拆弹专家：看到炸弹的吨位，拆弹专家都慌神了',
            '鼠胆英雄：胆小如鼠的青龙帮小弟，阴差阳错当上警察',
            '速度与激情混剪：天堂向左，一路走好 #速度与激情',
            '长城：长城内部机关重重，饕餮想爬上长城，怎料长城竟开了条缝！',
            '我的前半生: 唐晶与贺涵闹矛盾,罗平挑拨离间,想抢走贺涵的客户',
            '盘点正能量的励志台词：人生就像射箭，梦想就像箭靶子！',
            ' 西游伏妖篇: 如来从天而降,真人被他打回原形,原来是个九头金雕',
            '人民的名义: 程度监视李达康,祁同伟当场发飙: 谁给你的权利?',

            '陈翔六点半：为一顿饭，妹爷坑陈翔，陈翔坑老大爷，不带这么玩的',
            '搞笑动画！你小时候也被长辈逼着做过什么事吗？',
            '小伙套路美女2000元，没想美女套路更深，反骗小伙8000元',
            '搞笑剧小伙家门口干活，女骗子找上门来，对话从开头笑到结尾',
            '短剧：大卫张装阔假装开车展，没想被紫薇和老六识破，结局太逗了',
            '搞笑段子：兄弟两人去吃饭，谁付账成了大问题，看完笑到我了',
            '憋笑大挑战：岳云鹏版的蒙拉丽莎，成功把我逗笑了！',
            '爆笑小品：小沈阳，宋晓峰套路小沈阳，小沈阳的反应超搞笑',
            '学神，学霸，学渣，学弱“追姑娘”区别，看完学渣别笑喷！哈哈',
            '家庭幽默录像：动物通灵性？太可爱了！',

            '大个儿豁牙子为二丫打了起来，宋小宝不劝架，却在一旁看热闹',
            '谢广坤表演魔术，谁知却被白清明当场拆穿了，太尴尬了',
            '小品《真假老板》，小偷修睿去偷东西，没想到被当成了新来的老板',
            '德云社搞笑片段，岳云鹏再爆金句，直言孙越的肚子像超市！',
            '实现梦想要努力，创新服务真便民，巩汉林被逼着给狗办户口',
            '大潘跟潘长江同龄？潘长江：看一眼少一眼嘛 潘长江这嘴也挺毒啊',
            '郭达蔡明爆笑小品，蔡明卖房被郭达投诉，蔡明应对手法太搞笑了',
            '郭冬临小品《过年》，郭冬临接媳妇回家，被郭达误会笑点十足',
            '沈春阳大变造型惊呆小沈阳，小沈阳沈春阳小品，笑料不断',
            '张小斐贾玲进古墓 贾玲竟被当成了熊 贾玲你现在是有点熊人啊',

            '五排第一个选阿轲，对面挑选鲁班？秒他十次！',
            '全网细致传授，露娜中路gank与连招传授。',
            '干将怎样预判团战走向，你是否也碰见过这种题目，干将意识！',
            '迷你世界生存：小伙伴一直在家里面偷懒，又不肯帮忙去寻找金矿石',
            '迷你世界糖糖解说：不要碰到草快，你们可以在这个世界生存几天',
            '第五人格：老牌监管蜘蛛上分气球刀也能空，看牧童运营四杀',
            '斗地主：一张牌的腥风血雨！9炸贪功杀气腾腾，王炸天裁义愤填膺',
            'LOL徐老师来巡山：稻草人乌鸦坐飞机，隔空取物夺大龙',
            'LOL：难度“最低”的ADC？女枪：但我比第一伤害高',
            '和平精英：和平精英里吃鸡和刺激战场有什么不同？看了就知道',
            '绝地求生高玩实录22 绝地求生中真正的大杀器',

            ' 少儿乐园：侏罗纪小恐龙玩具蛋展示',
            '凌乱的积木谁说我拿它们没办法？炫彩射击枪玩具宝宝喜笑颜开',
            '喜欢吃火锅吗？火锅大乐斗儿童益智玩具双人PK用餐具夹丸子',
            '少儿乐园：卡通列车头机器人玩具变形',
            '大象看到牛牛推来一车苹果，原来自己种的，分给每一个好朋友',
            '如何用18片乐高搭建马车？开箱乐高圣诞倒数日历第4天',
            '小狐狸开潜水艇好朋友手工彩泥培乐多diy',
            '儿童剧：下雨了没办法去郊游，佩奇乔治为什么还是很开心？',
            '积木猪魔法变成假鲁鲁偷吃大白兔奶糖真鲁鲁被冤枉委屈地哭',
            '电动积木三角龙跑跑跑！一起来跳野狼DISCO！',

            '终于找到鸡肠最正确的吃法，配方个窍门都在这，上桌就抢吃光',
            '瘦肉咬不动？80岁老奶奶的秘制做法，不用一滴油，没牙齿也能吃',
            '五花肉放到大米里面，教你从没吃过的做法，出锅未来看馋了，真香',
            '没想到辣条和泡面的搭配居然这么好吃！香辣过瘾#深夜放毒',
            '校门口最让你难忘的小吃是什么？我最喜欢的炸香肠，闻到香味的快',
            ' 肉松蛋糕卷的家常做法，香甜细腻口感丰富（一',
            '茄子焖面怎么做好吃？教你家常的做法',
            '杏鲍菇炒鸡丁怎么做才鲜嫩多汁？大厨分享上浆的技巧，教你在家做',
            '四川师傅这样炒河虾，肉质细腻鲜嫩美味，一次做3斤不够吃',
            '杨子姗同款燕麦南瓜饼，营养低脂，有手就行',

            '卡卡西和自来也的差距, 面对佩恩两人已经很吃力',
            '迪士尼反派角色中，你知道哪些被误解了，而哪些则纯粹邪恶？',
            '海贼王：海贼王争夺战，路飞能否成为海贼王呢',
            '火影忍者：悲惨身世揭晓！鸣人找到长门的藏身之地，嘴遁模式上线',
            '一人之下3：宝儿姐在线教王也埋人，道长也学坏了，听话模样太萌',
            '悟空实现财富自由，前往界王神殿修行，贝吉塔的假期终于来啦！',
            '传说中的海贼现身，路飞遇大危机，究竟和路飞有什么深仇大恨？',
            '光头超人对战美女英雄，开启嘴遁模式，竟想跟对手讲道理？',
            '哆啦A梦变成胖虎一样妹控和霸道，为了点心和胖虎起争执',
            '数码宝贝三大最弱究极体！胜率完全为0，被喊滚出究极体行列！',

            '觉醒年代：北大学子瞧不起青年毛泽东，下一秒惨遭打脸，教授开骂',
            '乡村爱情13：美女书记点拨晓峰，爱情故事会，应多讲讲初恋美好',
            '战场：日本军舰夹击英方商船，断定中国不敢动，岂料下秒就被炸翻',
            '女孩意外怀孕，穷男友决定不再隐藏身份，直接带她回豪宅',
            '小幸福：儿媳坐着月子还练瑜伽，婆婆一看姿势吓坏，姥姥：多好看',
            '甄嬛传：甄嬛终于肯让皇上留宿了，可她的眼里已经没有爱了',
            '琅琊榜：曾经的林殊有多耀眼？13年后，梅长苏的撕心裂肺说明一切',
            '欢乐颂：关关和邱莹莹被小包总订的酒店惊讶到，曲筱绡：两土鳖',
            '山海情：蘑菇贩子放狠话，凌教授忍不了直接动手，结果笑喷了',
            '婚姻背后：美女来借拖把，小伙开门看见这一幕，下秒举动太逗了'

        ]

}

def parser(d):
    try:
        r = {}
        r['taskId'] = d['taskId']
        r['appName'] = d['appName']
        r['pushType'] = d['pushType']
        r['realPush'] = d['realPush']

        pushItemModel = d['pushItemModels'][0]
        r['itemId'] = pushItemModel['itemId']
        r['pushId'] = pushItemModel['pushId']
        r['title'] = pushItemModel['title']
        r['subTitle'] = pushItemModel.get('subTitle', '')
        r['userCategory'] = pushItemModel['userCategory']
        return r

    except:
        return {}


def profile_push_his(days=15):
    """

    @return: 垂类下发历史
    """
    sql = f"""
    select distinct news_info  from news_push_info
    where updateTimeStamp >= '{date_difference(days=days)}'
    and length(news_info) > 66
    limit 10000
    """
    df = pd.read_sql(sql, mysql_mitvpush_conn)
    df['news_info'] = df['news_info'].map(json.loads).map(parser)
    df = df[df['news_info'] != {}]

    df = pd.DataFrame(df['news_info'].values.tolist())
    df['userCategory'] = df['userCategory'].map(lambda x: x[0] if x else None)
    df = (
        df[~df['userCategory'].isnull()][lambda df: df['realPush']]
            .sort_values(['taskId', 'userCategory'], 0, [0, 0], ignore_index=True)
    )

    return df

# 选择需要表征的人群包
# TODO: 按时间倒排取topN文章
df = profile_push_his(15)  # 选取历史15天下发文章

# concat with o2o articles, to gen unknown profile_category embedding
o2o_TopN_high_quality_items_dw_df = tf_io.read_hdfs(
                "/user/h_data_platform/platform/feeds/biz/biz=TopN_high_quality_items_dw",
                reader=lambda p: pd.read_csv(p, '\t', names=['userCategory', 'bizdocid', 'title', 'subTitle'], usecols=range(4)),
                max_workers=1
            )
o2o_TopN_high_quality_items_dw_df = o2o_TopN_high_quality_items_dw_df[o2o_TopN_high_quality_items_dw_df['title']!=None]

df = pd.concat([o2o_TopN_high_quality_items_dw_df, df])

df['title']=df['title'].astype(str)
df['subTitle']=df['subTitle'].astype(str)

# df = df[df.userCategory.isin(['资讯'])]

# 向量化
date = date_difference("%Y%m%d", days=1)
df['title_vector'] = get_simbert_vectors(df['title'].tolist(), 20).tolist()
df['subtitle_vector'] = get_simbert_vectors(df['subTitle'].tolist(), 20).tolist()
df_title = df.groupby('userCategory')['title_vector'].agg(list).reset_index()
df_title['title_vector_mean'] = df_title['title_vector'].map(lambda x: normalize(np.array(x).mean(0)))  # 要归一化
df_subtitle = df.groupby('userCategory')['subtitle_vector'].agg(list).reset_index()
df_subtitle['subtitle_vector_mean'] = df_subtitle['subtitle_vector'].map(
    lambda x: normalize(np.array(x).mean(0)))  # 要归一化
df_title.merge(df_subtitle).to_parquet('VECTOR')

# 运营提供的文章 向量化
operator_pre_push_df = pd.DataFrame(operator_pre_push_data)
operator_pre_push_df['title_vector'] = get_simbert_vectors(operator_pre_push_df['title'].tolist(), 20).tolist()
operator_pre_push_df['subtitle_vector'] = get_simbert_vectors(operator_pre_push_df['subTitle'].tolist(), 20).tolist()
operator_pre_push_df_title = operator_pre_push_df.groupby('userCategory')['title_vector'].agg(list).reset_index()
operator_pre_push_df_title['title_vector_mean'] = operator_pre_push_df_title['title_vector'].map(lambda x: normalize(np.array(x).mean(0)))  # 要归一化
operator_pre_push_df_subtitle = operator_pre_push_df.groupby('userCategory')['subtitle_vector'].agg(list).reset_index()
operator_pre_push_df_subtitle['subtitle_vector_mean'] = operator_pre_push_df_subtitle['subtitle_vector'].map(
    lambda x: normalize(np.array(x).mean(0)))  # 要归一化
operator_pre_push_df_title.merge(operator_pre_push_df_subtitle).to_parquet('OPERATOR_VECTOR')


if __name__ == '__main__':

    class Profie2Vec(Main):

        @args
        def main(self, **kwargs):
            tf_io.cp('VECTOR', "/user/h_data_platform/platform/feeds/biz/biz=profile2vec")
            tf_io.cp('OPERATOR_VECTOR', "/user/h_data_platform/platform/feeds/biz/biz=profile2vec_operator")

    Profie2Vec.cli()
