var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
import * as vue from "vue";
import { defineComponent, watchEffect, computed, resolveDirective, withDirectives, openBlock, createElementBlock, normalizeStyle, createVNode, unref, createElementVNode, vShow, onMounted, onBeforeUnmount, createBlock, withCtx, renderSlot, createCommentVNode, resolveDynamicComponent, Fragment, renderList, toDisplayString, watch, ref, nextTick, mergeProps, markRaw, onUnmounted, withModifiers, withKeys, normalizeClass, createStaticVNode, Transition, shallowRef, createTextVNode, isRef, toRaw, Teleport, toRefs as toRefs$1, useId as useId$1, readonly, onUpdated, reactive, provide, inject, getCurrentInstance, onErrorCaptured, useTemplateRef, mergeModels, useModel, customRef, getCurrentScope, onScopeDispose, effectScope, hasInjectionContext, toValue as toValue$2, toRef as toRef$1, onBeforeMount, isReactive, shallowReactive, h, TransitionGroup, isReadonly, onBeforeUpdate, toHandlerKey, camelize as camelize$1, Comment, cloneVNode, normalizeProps, guardReactiveProps, watchPostEffect, shallowReadonly, mergeDefaults, watchSyncEffect, withMemo, triggerRef, useSlots, toHandlers, createSlots } from "vue";
import { u as useWorkspaceStore, a as useSettingStore, b as app, s as showNativeSystemMenu, _ as _export_sfc, c as useWorkflowStore, d as useSidebarTabStore, e as useBottomPanelStore, f as useDialogService, g as useCanvasStore, h as useCanvasPositionConversion, i as useElementBounding$1, j as isComponentWidget, k as isDOMWidget, l as useEventListener$1, m as useDomWidgetStore, w as whenever$1, n as useChainCallback, o as useThrottleFn$1, p as api, r as renderMinimapToCanvas, q as useColorPaletteStore, t as calculateNodeBounds, v as enforceMinimumBounds, x as calculateMinimapScale, y as useRafFn$1, z as useCommandStore, A as useCanvasInteractions, L as LiteGraph, B as useNodeDefStore, C as isOverNodeInput, D as st, E as normalizeI18nKey, F as isOverNodeOutput, G as LGraphCanvas, H as adjustColor, I as isColorable, J as getItemsColorOption, K as useNodeHelpStore, M as useNodeLibrarySidebarTab, N as storeToRefs, O as isLGraphNode, P as isImageNode, S as SubgraphNode, Q as isLoad3dNode, R as LGraphEventMode, T as t, U as isLGraphGroup, V as useSelectedLiteGraphItems, W as layoutStore, X as LGraphNode, Y as useTitleEditorStore, Z as LGraphGroup, $ as RenderShape, a0 as alignNodes, a1 as distributeNodes, a2 as useToastStore, a3 as useNodeOutputStore, a4 as useNodeBookmarkStore, a5 as useExtensionService, a6 as EditableText, a7 as defineStore, a8 as useMouse$1, a9 as useNodeFrequencyStore, aa as highlightQuery, ab as formatNumberWithSuffix, ac as NodeSourceType, ad as NodePreview, ae as NodeSearchFilter, af as SearchFilterChip, ag as useLitegraphService, ah as LinkReleaseTriggerAction, ai as axios, aj as COMFY_API_BASE_URL, ak as isAbortError, al as useSystemStatsStore, am as compareVersions, an as isElectron, ao as until$1, ap as stringToLocale, aq as useConflictAcknowledgment, ar as useManagerState, as as ManagerTab, at as electronAPI, au as formatVersionAnchor, av as marked, aw as useConflictDetection, ax as useUserStore, ay as useKeybindingStore, az as usePragmaticDraggable, aA as usePragmaticDroppable, aB as useWorkflowThumbnail, aC as useWorkflowService, aD as debounce$2, aE as useMutationObserver$1, aF as useResizeObserver$1, aG as useWorkflowBookmarkStore, aH as useScroll$1, aI as useLayoutMutations, aJ as QuadTree, aK as LayoutSource, aL as log, aM as getSlotPosition, aN as LinkDirection, aO as LLink, aP as Reroute, aQ as LitegraphLinkAdapter, aR as getSlotKey, aS as calculateInputSlotPos, aT as calculateOutputSlotPos, aU as computedWithControl$1, aV as useExtensionStore, aW as NodeBadgeMode, aX as BadgePosition, aY as LGraphBadge, aZ as toolkit, a_ as useModelToNodeStore, a$ as useSharedCanvasPositionConversion, b0 as ComfyNodeDefImpl, b1 as ComfyModelDef, b2 as ComfyWorkflow, b3 as te, b4 as LGraph, b5 as DragAndScale, b6 as ContextMenu$1, b7 as isVideoNode, b8 as isAudioNode, b9 as CanvasPointer, ba as LinkMarkerShape, bb as getStorageValue, bc as setStorageValue, bd as tryOnScopeDispose$1, be as useDebounceFn$1, bf as isPointEqual, bg as isSizeEqual, bh as useErrorHandling, bi as cn, bj as isSlotObject, bk as flatten$1, bl as difference, bm as differenceWith, bn as uniq$1, bo as uniqBy, bp as uniqWith, bq as intersection, br as intersectionBy, bs as differenceBy, bt as intersectionWith, bu as debounce$3, bv as ary, bw as isPlainObject$1, bx as isUnsafeProperty, by as isObjectLike, bz as isArray, bA as camelCase, bB as cloneDeep, bC as isPlainObject$2, bD as snakeCase, bE as words, bF as capitalize, bG as noop$1, bH as isColorFormat, bI as toHexFromFormat, bJ as reactiveOmit$1, bK as renderMarkdownToHtml, bL as useExecutionStore, bM as getNodeByLocatorId, bN as IS_CONTROL_WIDGET, bO as updateControlWidgetLabel, bP as useColorPaletteService, bQ as ChangeTracker, bR as UnauthorizedError, bS as __vitePreload, bT as i18n, bU as migrateLegacyRerouteNodes, bV as useQueueSettingsStore, bW as useQueuePendingTaskCountStore, bX as useLocalStorage$1, bY as useDraggable$1, bZ as watchDebounced$1, b_ as useEventBus$1, b$ as clamp$3, c0 as appendJsonExt, c1 as useSubgraphNavigationStore, c2 as useSubgraphStore, c3 as forEachSubgraphNode, c4 as useMenuItemStore, c5 as useDialogStore, c6 as _imports_0, c7 as SettingDialogHeader, c8 as SettingDialogContent, c9 as useCurrentUser, ca as useFirebaseAuthActions, cb as _sfc_main$1L, cc as isNativeWindow, cd as useTitle$1, ce as _sfc_main$1M, cf as getBaseButtonClasses, cg as getButtonSizeClasses, ch as getBorderButtonTypeClasses, ci as getButtonTypeClasses, cj as useBreakpoints$1, ck as _sfc_main$1N, cl as getAllNonIoNodesInSubgraph, cm as useQueueStore, cn as getExecutionIdsForSelectedNodes, co as DEFAULT_DARK_COLOR_PALETTE, cp as DEFAULT_LIGHT_COLOR_PALETTE, cq as ManagerUIState, cr as useFavicon$1, cs as config, ct as semver, cu as useStorage$1, cv as useModelStore } from "./index-Cso8sTOw.js";
import { useToast as useToast$1 } from "primevue/usetoast";
import { useI18n } from "vue-i18n";
import Button from "primevue/button";
import Splitter from "primevue/splitter";
import SplitterPanel from "primevue/splitterpanel";
import Tab from "primevue/tab";
import TabList from "primevue/tablist";
import Tabs from "primevue/tabs";
import ButtonGroup from "primevue/buttongroup";
import { Button as Button$1, InputNumber, useToast } from "primevue";
import Panel from "primevue/panel";
import SelectButton from "primevue/selectbutton";
import { c as computeUnionBounds } from "./mathUtil-CTARWQ-l.js";
import Popover from "primevue/popover";
import Badge from "primevue/badge";
import Dialog from "primevue/dialog";
import AutoComplete from "primevue/autocomplete";
import Chip from "primevue/chip";
import Tag from "primevue/tag";
import OverlayBadge from "primevue/overlaybadge";
import ContextMenu from "primevue/contextmenu";
import ScrollPanel from "primevue/scrollpanel";
import Menu from "primevue/menu";
import Checkbox from "primevue/checkbox";
import Skeleton from "primevue/skeleton";
import InputText from "primevue/inputtext";
import Chart from "primevue/chart";
import ColorPicker from "primevue/colorpicker";
import Select from "primevue/select";
import Galleria from "primevue/galleria";
import ImageCompare from "primevue/imagecompare";
import InputNumber$1 from "primevue/inputnumber";
import Textarea from "primevue/textarea";
import MultiSelect from "primevue/multiselect";
import ToggleSwitch from "primevue/toggleswitch";
import TreeSelect from "primevue/treeselect";
import Toast from "primevue/toast";
import SplitButton from "primevue/splitbutton";
import TieredMenu from "primevue/tieredmenu";
import Breadcrumb from "primevue/breadcrumb";
import { _ as _sfc_main$1K } from "./UserAvatar-C9bSkTC5.js";
import Divider from "primevue/divider";
import { u as useKeybindingService } from "./keybindingService-Bz6mlu2M.js";
import { u as useServerConfigStore } from "./serverConfigStore-siZ6giIy.js";
import "@primevue/themes";
import "@primevue/themes/aura";
import "primevue/config";
import "primevue/confirmationservice";
import "primevue/toastservice";
import "primevue/tooltip";
import "primevue/blockui";
import "primevue/progressspinner";
import "primevue/message";
import "primevue/card";
import "primevue/listbox";
import "primevue/progressbar";
import "primevue/floatlabel";
import "@primevue/forms";
import "@primevue/forms/resolvers/zod";
import "primevue/password";
import "primevue/tabpanel";
import "primevue/tabpanels";
import "primevue/dropdown";
import "primevue/tabmenu";
import "primevue/dataview";
import "primevue/column";
import "primevue/datatable";
import "primevue/iconfield";
import "primevue/inputicon";
import "primevue/radiobutton";
import "primevue/knob";
import "primevue/slider";
import "primevue/tree";
import "primevue/toolbar";
import "primevue/confirmpopup";
import "primevue/useconfirm";
import "primevue/confirmdialog";
import "primevue/avatar";
const _hoisted_1$1N = { class: "window-actions-spacer" };
const _sfc_main$1J = /* @__PURE__ */ defineComponent({
  __name: "MenuHamburger",
  setup(__props) {
    const workspaceState = useWorkspaceStore();
    const settingStore = useSettingStore();
    const exitFocusMode = /* @__PURE__ */ __name(() => {
      workspaceState.focusMode = false;
    }, "exitFocusMode");
    watchEffect(() => {
      if (settingStore.get("Comfy.UseNewMenu") !== "Disabled") {
        return;
      }
      if (workspaceState.focusMode) {
        app.ui.menuContainer.style.display = "none";
      } else {
        app.ui.menuContainer.style.display = "block";
      }
    });
    const menuSetting = computed(() => settingStore.get("Comfy.UseNewMenu"));
    const positionCSS = computed(
      () => (
        // 'Bottom' menuSetting shows the hamburger button in the bottom right corner
        // 'Disabled', 'Top' menuSetting shows the hamburger button in the top right corner
        menuSetting.value === "Bottom" ? { bottom: "0px", right: "0px" } : { top: "0px", right: "0px" }
      )
    );
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createElementBlock("div", {
        class: "comfy-menu-hamburger no-drag",
        style: normalizeStyle(positionCSS.value)
      }, [
        withDirectives(createVNode(unref(Button), {
          icon: "pi pi-bars",
          severity: "secondary",
          text: "",
          size: "large",
          "aria-label": _ctx.$t("menu.showMenu"),
          "aria-live": "assertive",
          onClick: exitFocusMode,
          onContextmenu: unref(showNativeSystemMenu)
        }, null, 8, ["aria-label", "onContextmenu"]), [
          [_directive_tooltip, { value: _ctx.$t("menu.showMenu"), showDelay: 300 }]
        ]),
        withDirectives(createElementVNode("div", _hoisted_1$1N, null, 512), [
          [vShow, menuSetting.value !== "Bottom"]
        ])
      ], 4)), [
        [vShow, unref(workspaceState).focusMode]
      ]);
    };
  }
});
const MenuHamburger = /* @__PURE__ */ _export_sfc(_sfc_main$1J, [["__scopeId", "data-v-0fc2841f"]]);
const _sfc_main$1I = /* @__PURE__ */ defineComponent({
  __name: "UnloadWindowConfirmDialog",
  setup(__props) {
    const settingStore = useSettingStore();
    const workflowStore = useWorkflowStore();
    const handleBeforeUnload = /* @__PURE__ */ __name((event) => {
      if (settingStore.get("Comfy.Window.UnloadConfirmation") && workflowStore.modifiedWorkflows.length > 0) {
        event.preventDefault();
        return true;
      }
      return void 0;
    }, "handleBeforeUnload");
    onMounted(() => {
      window.addEventListener("beforeunload", handleBeforeUnload);
    });
    onBeforeUnmount(() => {
      window.removeEventListener("beforeunload", handleBeforeUnload);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div");
    };
  }
});
const _sfc_main$1H = /* @__PURE__ */ defineComponent({
  __name: "LiteGraphCanvasSplitterOverlay",
  setup(__props) {
    const settingStore = useSettingStore();
    const sidebarLocation = computed(
      () => settingStore.get("Comfy.Sidebar.Location")
    );
    const unifiedWidth = computed(
      () => settingStore.get("Comfy.Sidebar.UnifiedWidth")
    );
    const sidebarPanelVisible = computed(
      () => useSidebarTabStore().activeSidebarTab !== null
    );
    const bottomPanelVisible = computed(
      () => useBottomPanelStore().bottomPanelVisible
    );
    const activeSidebarTabId = computed(
      () => useSidebarTabStore().activeSidebarTabId
    );
    const sidebarStateKey = computed(() => {
      return unifiedWidth.value ? "unified-sidebar" : activeSidebarTabId.value ?? "";
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Splitter), {
        key: sidebarStateKey.value,
        class: "splitter-overlay-root splitter-overlay",
        "pt:gutter": sidebarPanelVisible.value ? "" : "hidden",
        "state-key": sidebarStateKey.value,
        "state-storage": "local"
      }, {
        default: withCtx(() => [
          sidebarLocation.value === "left" ? withDirectives((openBlock(), createBlock(unref(SplitterPanel), {
            key: 0,
            class: "side-bar-panel",
            "min-size": 10,
            size: 20
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "side-bar-panel", {}, void 0, true)
            ]),
            _: 3
          }, 512)), [
            [vShow, sidebarPanelVisible.value]
          ]) : createCommentVNode("", true),
          createVNode(unref(SplitterPanel), { size: 100 }, {
            default: withCtx(() => [
              createVNode(unref(Splitter), {
                class: "splitter-overlay max-w-full",
                layout: "vertical",
                "pt:gutter": bottomPanelVisible.value ? "" : "hidden",
                "state-key": "bottom-panel-splitter",
                "state-storage": "local"
              }, {
                default: withCtx(() => [
                  createVNode(unref(SplitterPanel), { class: "graph-canvas-panel relative" }, {
                    default: withCtx(() => [
                      renderSlot(_ctx.$slots, "graph-canvas-panel", {}, void 0, true)
                    ]),
                    _: 3
                  }),
                  withDirectives(createVNode(unref(SplitterPanel), { class: "bottom-panel" }, {
                    default: withCtx(() => [
                      renderSlot(_ctx.$slots, "bottom-panel", {}, void 0, true)
                    ]),
                    _: 3
                  }, 512), [
                    [vShow, bottomPanelVisible.value]
                  ])
                ]),
                _: 3
              }, 8, ["pt:gutter"])
            ]),
            _: 3
          }),
          sidebarLocation.value === "right" ? withDirectives((openBlock(), createBlock(unref(SplitterPanel), {
            key: 1,
            class: "side-bar-panel",
            "min-size": 10,
            size: 20
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "side-bar-panel", {}, void 0, true)
            ]),
            _: 3
          }, 512)), [
            [vShow, sidebarPanelVisible.value]
          ]) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["pt:gutter", "state-key"]);
    };
  }
});
const LiteGraphCanvasSplitterOverlay = /* @__PURE__ */ _export_sfc(_sfc_main$1H, [["__scopeId", "data-v-a4c975a1"]]);
const _sfc_main$1G = /* @__PURE__ */ defineComponent({
  __name: "ExtensionSlot",
  props: {
    extension: {}
  },
  setup(__props) {
    const props2 = __props;
    const mountCustomExtension = /* @__PURE__ */ __name((extension, el) => {
      extension.render(el);
    }, "mountCustomExtension");
    onBeforeUnmount(() => {
      if (props2.extension.type === "custom" && props2.extension.destroy) {
        props2.extension.destroy();
      }
    });
    return (_ctx, _cache) => {
      return _ctx.extension.type === "vue" ? (openBlock(), createBlock(resolveDynamicComponent(_ctx.extension.component), { key: 0 })) : (openBlock(), createElementBlock("div", {
        key: 1,
        ref: /* @__PURE__ */ __name((el) => {
          if (el)
            mountCustomExtension(
              props2.extension,
              el
            );
        }, "ref")
      }, null, 512));
    };
  }
});
const _hoisted_1$1M = { class: "flex flex-col h-full" };
const _hoisted_2$M = { class: "w-full flex justify-between" };
const _hoisted_3$u = { class: "tabs-container" };
const _hoisted_4$l = { class: "font-bold" };
const _hoisted_5$d = { class: "flex items-center gap-2" };
const _hoisted_6$a = { class: "grow h-0" };
const _sfc_main$1F = /* @__PURE__ */ defineComponent({
  __name: "BottomPanel",
  setup(__props) {
    const bottomPanelStore = useBottomPanelStore();
    const dialogService = useDialogService();
    const { t: t2 } = useI18n();
    const isShortcutsTabActive = computed(() => {
      const activeTabId = bottomPanelStore.activeBottomPanelTabId;
      return activeTabId === "shortcuts-essentials" || activeTabId === "shortcuts-view-controls";
    });
    const shouldCapitalizeTab = /* @__PURE__ */ __name((tabId) => {
      return tabId !== "shortcuts-essentials" && tabId !== "shortcuts-view-controls";
    }, "shouldCapitalizeTab");
    const getTabDisplayTitle = /* @__PURE__ */ __name((tab) => {
      const title = tab.titleKey ? t2(tab.titleKey) : tab.title || "";
      return shouldCapitalizeTab(tab.id) ? title.toUpperCase() : title;
    }, "getTabDisplayTitle");
    const openKeybindingSettings = /* @__PURE__ */ __name(async () => {
      dialogService.showSettingsDialog("keybinding");
    }, "openKeybindingSettings");
    const closeBottomPanel = /* @__PURE__ */ __name(() => {
      bottomPanelStore.activePanel = null;
    }, "closeBottomPanel");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1M, [
        (openBlock(), createBlock(unref(Tabs), {
          key: _ctx.$i18n.locale,
          value: unref(bottomPanelStore).activeBottomPanelTabId,
          "onUpdate:value": _cache[0] || (_cache[0] = ($event) => unref(bottomPanelStore).activeBottomPanelTabId = $event)
        }, {
          default: withCtx(() => [
            createVNode(unref(TabList), { "pt:tab-list": "border-none" }, {
              default: withCtx(() => [
                createElementVNode("div", _hoisted_2$M, [
                  createElementVNode("div", _hoisted_3$u, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(unref(bottomPanelStore).bottomPanelTabs, (tab) => {
                      return openBlock(), createBlock(unref(Tab), {
                        key: tab.id,
                        value: tab.id,
                        class: "p-3 border-none"
                      }, {
                        default: withCtx(() => [
                          createElementVNode("span", _hoisted_4$l, toDisplayString(getTabDisplayTitle(tab)), 1)
                        ]),
                        _: 2
                      }, 1032, ["value"]);
                    }), 128))
                  ]),
                  createElementVNode("div", _hoisted_5$d, [
                    isShortcutsTabActive.value ? (openBlock(), createBlock(unref(Button), {
                      key: 0,
                      label: _ctx.$t("shortcuts.manageShortcuts"),
                      icon: "pi pi-cog",
                      severity: "secondary",
                      size: "small",
                      text: "",
                      onClick: openKeybindingSettings
                    }, null, 8, ["label"])) : createCommentVNode("", true),
                    createVNode(unref(Button), {
                      class: "justify-self-end",
                      icon: "pi pi-times",
                      severity: "secondary",
                      size: "small",
                      text: "",
                      onClick: closeBottomPanel
                    })
                  ])
                ])
              ]),
              _: 1
            })
          ]),
          _: 1
        }, 8, ["value"])),
        createElementVNode("div", _hoisted_6$a, [
          unref(bottomPanelStore).bottomPanelVisible && unref(bottomPanelStore).activeBottomPanelTab ? (openBlock(), createBlock(_sfc_main$1G, {
            key: 0,
            extension: unref(bottomPanelStore).activeBottomPanelTab
          }, null, 8, ["extension"])) : createCommentVNode("", true)
        ])
      ]);
    };
  }
});
function useAbsolutePosition(options = {}) {
  const { useTransform = false } = options;
  const canvasStore = useCanvasStore();
  const lgCanvas = canvasStore.getCanvas();
  const { canvasPosToClientPos, update: updateCanvasPosition } = useCanvasPositionConversion(lgCanvas.canvas, lgCanvas);
  const settingStore = useSettingStore();
  watch(
    [
      () => settingStore.get("Comfy.Sidebar.Location"),
      () => settingStore.get("Comfy.Sidebar.Size"),
      () => settingStore.get("Comfy.UseNewMenu")
    ],
    () => updateCanvasPosition(),
    { flush: "post" }
  );
  const style = ref({});
  const computeStyle = /* @__PURE__ */ __name((position) => {
    const { pos, size: size2, scale = lgCanvas.ds.scale } = position;
    const [left, top] = canvasPosToClientPos(pos);
    const [width, height] = size2;
    return useTransform ? {
      position: "fixed",
      transformOrigin: "0 0",
      transform: `scale(${scale})`,
      left: `${left}px`,
      top: `${top}px`,
      width: `${width}px`,
      height: `${height}px`
    } : {
      position: "fixed",
      left: `${left}px`,
      top: `${top}px`,
      width: `${width * scale}px`,
      height: `${height * scale}px`
    };
  }, "computeStyle");
  const updatePosition = /* @__PURE__ */ __name((config2) => {
    style.value = computeStyle(config2);
  }, "updatePosition");
  return {
    style,
    updatePosition
  };
}
__name(useAbsolutePosition, "useAbsolutePosition");
function intersect(a, b) {
  const x1 = Math.max(a.x, b.x);
  const y1 = Math.max(a.y, b.y);
  const x2 = Math.min(a.x + a.width, b.x + b.width);
  const y2 = Math.min(a.y + a.height, b.y + b.height);
  if (x1 >= x2 || y1 >= y2) {
    return null;
  }
  return [x1, y1, x2 - x1, y2 - y1];
}
__name(intersect, "intersect");
const useDomClipping = /* @__PURE__ */ __name((options = {}) => {
  const style = ref({});
  const { margin = 4 } = options;
  const calculateClipPath = /* @__PURE__ */ __name((elementRect, canvasRect, isSelected, selectedArea) => {
    if (!isSelected && selectedArea) {
      const { scale, offset: offset2 } = selectedArea;
      const intersection2 = intersect(
        {
          x: elementRect.left - canvasRect.left,
          y: elementRect.top - canvasRect.top,
          width: elementRect.width,
          height: elementRect.height
        },
        {
          x: (selectedArea.x + offset2[0] - margin) * scale,
          y: (selectedArea.y + offset2[1] - margin) * scale,
          width: (selectedArea.width + 2 * margin) * scale,
          height: (selectedArea.height + 2 * margin) * scale
        }
      );
      if (!intersection2) {
        return "";
      }
      const clipX = (intersection2[0] - elementRect.left + canvasRect.left) / scale + "px";
      const clipY = (intersection2[1] - elementRect.top + canvasRect.top) / scale + "px";
      const clipWidth = intersection2[2] / scale + "px";
      const clipHeight = intersection2[3] / scale + "px";
      return `polygon(0% 0%, 0% 100%, ${clipX} 100%, ${clipX} ${clipY}, calc(${clipX} + ${clipWidth}) ${clipY}, calc(${clipX} + ${clipWidth}) calc(${clipY} + ${clipHeight}), ${clipX} calc(${clipY} + ${clipHeight}), ${clipX} 100%, 100% 100%, 100% 0%)`;
    }
    return "";
  }, "calculateClipPath");
  const updateClipPath = /* @__PURE__ */ __name((element, canvasElement, isSelected, selectedArea) => {
    const elementRect = element.getBoundingClientRect();
    const canvasRect = canvasElement.getBoundingClientRect();
    const clipPath = calculateClipPath(
      elementRect,
      canvasRect,
      isSelected,
      selectedArea
    );
    style.value = {
      clipPath: clipPath || "none",
      willChange: "clip-path"
    };
  }, "updateClipPath");
  return {
    style,
    updateClipPath
  };
}, "useDomClipping");
const _hoisted_1$1L = ["title"];
const _sfc_main$1E = /* @__PURE__ */ defineComponent({
  __name: "DomWidget",
  props: {
    widgetState: {}
  },
  emits: ["update:widgetValue"],
  setup(__props, { emit: __emit }) {
    const widget = __props.widgetState.widget;
    const emit = __emit;
    const widgetElement = ref();
    const style = ref({});
    const { style: positionStyle, updatePosition } = useAbsolutePosition({
      useTransform: true
    });
    const { style: clippingStyle, updateClipPath } = useDomClipping();
    const canvasStore = useCanvasStore();
    const settingStore = useSettingStore();
    const enableDomClipping = computed(
      () => settingStore.get("Comfy.DOMClippingEnabled")
    );
    const updateDomClipping = /* @__PURE__ */ __name(() => {
      const lgCanvas = canvasStore.canvas;
      if (!lgCanvas || !widgetElement.value) return;
      const selectedNode = Object.values(lgCanvas.selected_nodes ?? {})[0];
      if (!selectedNode) {
        updateClipPath(widgetElement.value, lgCanvas.canvas, false, void 0);
        return;
      }
      const isSelected = selectedNode === widget.node;
      const renderArea = selectedNode?.renderArea;
      const offset2 = lgCanvas.ds.offset;
      const scale = lgCanvas.ds.scale;
      const selectedAreaConfig = renderArea ? {
        x: renderArea[0],
        y: renderArea[1],
        width: renderArea[2],
        height: renderArea[3],
        scale,
        offset: [offset2[0], offset2[1]]
      } : void 0;
      updateClipPath(
        widgetElement.value,
        lgCanvas.canvas,
        isSelected,
        selectedAreaConfig
      );
    }, "updateDomClipping");
    const { left, top } = useElementBounding$1(canvasStore.getCanvas().canvas);
    watch(
      [() => __props.widgetState, left, top],
      ([widgetState, _, __]) => {
        updatePosition(widgetState);
        if (enableDomClipping.value) {
          updateDomClipping();
        }
        style.value = {
          ...positionStyle.value,
          ...enableDomClipping.value ? clippingStyle.value : {},
          zIndex: widgetState.zIndex,
          pointerEvents: widgetState.readonly || widget.computedDisabled ? "none" : "auto",
          opacity: widget.computedDisabled ? 0.5 : 1
        };
      },
      { deep: true }
    );
    watch(
      () => __props.widgetState.visible,
      (newVisible, oldVisible) => {
        if (!newVisible && oldVisible) {
          widget.options.onHide?.(widget);
        }
      }
    );
    const setupDOMEventListeners = /* @__PURE__ */ __name(() => {
      if (!isDOMWidget(widget) || !__props.widgetState.visible) return;
      if (widget.element.blur) {
        useEventListener$1(document, "mousedown", (event) => {
          if (!widget.element.contains(event.target)) {
            widget.element.blur();
          }
        });
      }
      for (const evt of widget.options.selectOn ?? ["focus", "click"]) {
        useEventListener$1(widget.element, evt, () => {
          const lgCanvas = canvasStore.canvas;
          lgCanvas?.selectNode(widget.node);
          lgCanvas?.bringToFront(widget.node);
        });
      }
    }, "setupDOMEventListeners");
    watch(
      () => __props.widgetState.visible,
      (visible) => {
        if (visible) {
          setupDOMEventListeners();
        }
      },
      { immediate: true }
    );
    const inputSpec = widget.node.constructor.nodeData;
    const tooltip = inputSpec?.inputs?.[widget.name]?.tooltip;
    const mountElementIfVisible = /* @__PURE__ */ __name(() => {
      if (__props.widgetState.visible && isDOMWidget(widget) && widgetElement.value) {
        if (!widgetElement.value.contains(widget.element)) {
          widgetElement.value.appendChild(widget.element);
        }
      }
    }, "mountElementIfVisible");
    onMounted(() => {
      nextTick(() => {
        mountElementIfVisible();
      }).catch((error) => {
        console.error("Error mounting DOM widget element:", error);
      });
    });
    watch(
      () => __props.widgetState.visible,
      () => {
        mountElementIfVisible();
      }
    );
    return (_ctx, _cache) => {
      return withDirectives((openBlock(), createElementBlock("div", {
        ref_key: "widgetElement",
        ref: widgetElement,
        class: "dom-widget",
        title: unref(tooltip),
        style: normalizeStyle(style.value)
      }, [
        unref(isComponentWidget)(unref(widget)) ? (openBlock(), createBlock(resolveDynamicComponent(unref(widget).component), mergeProps({
          key: 0,
          "model-value": unref(widget).value,
          widget: unref(widget)
        }, unref(widget).props, {
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => emit("update:widgetValue", $event))
        }), null, 16, ["model-value", "widget"])) : createCommentVNode("", true)
      ], 12, _hoisted_1$1L)), [
        [vShow, _ctx.widgetState.visible]
      ]);
    };
  }
});
const DomWidget = /* @__PURE__ */ _export_sfc(_sfc_main$1E, [["__scopeId", "data-v-b52a007f"]]);
const _hoisted_1$1K = { class: "isolate" };
const _sfc_main$1D = /* @__PURE__ */ defineComponent({
  __name: "DomWidgets",
  setup(__props) {
    const domWidgetStore = useDomWidgetStore();
    const widgetStates = computed(() => [...domWidgetStore.widgetStates.values()]);
    const updateWidgets = /* @__PURE__ */ __name(() => {
      const lgCanvas = canvasStore.canvas;
      if (!lgCanvas) return;
      const lowQuality = lgCanvas.low_quality;
      const currentGraph = lgCanvas.graph;
      for (const widgetState of widgetStates.value) {
        const widget = widgetState.widget;
        if (!widget.isVisible() || !widgetState.active) {
          widgetState.visible = false;
          continue;
        }
        const node = widget.node;
        const isInCorrectGraph = currentGraph?.nodes.includes(node);
        widgetState.visible = !!isInCorrectGraph && lgCanvas.isNodeVisible(node) && !(widget.options.hideOnZoom && lowQuality);
        if (widgetState.visible && node) {
          const margin = widget.margin;
          widgetState.pos = [node.pos[0] + margin, node.pos[1] + margin + widget.y];
          widgetState.size = [
            (widget.width ?? node.width) - margin * 2,
            (widget.computedHeight ?? 50) - margin * 2
          ];
          widgetState.zIndex = lgCanvas.graph?.nodes.indexOf(node) ?? -1;
          widgetState.readonly = lgCanvas.read_only;
        }
      }
    }, "updateWidgets");
    const canvasStore = useCanvasStore();
    whenever$1(
      () => canvasStore.canvas,
      (canvas) => canvas.onDrawForeground = useChainCallback(
        canvas.onDrawForeground,
        updateWidgets
      ),
      { immediate: true }
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1K, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(widgetStates.value, (widgetState) => {
          return openBlock(), createBlock(DomWidget, {
            key: widgetState.widget.id,
            "widget-state": widgetState,
            "onUpdate:widgetValue": /* @__PURE__ */ __name(($event) => widgetState.widget.value = $event, "onUpdate:widgetValue")
          }, null, 8, ["widget-state", "onUpdate:widgetValue"]);
        }), 128))
      ]);
    };
  }
});
const _hoisted_1$1J = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$F(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1J, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("circle", {
        cx: "6",
        cy: "19",
        r: "3"
      }),
      createElementVNode("path", { d: "M9 19h8.5c.4 0 .9-.1 1.3-.2M5.2 5.2A3.5 3.53 0 0 0 6.5 12H12M2 2l20 20m-1-6.7a3.5 3.5 0 0 0-3.3-3.3M15 5h-4.3" }),
      createElementVNode("circle", {
        cx: "18",
        cy: "5",
        r: "3"
      })
    ], -1)
  ]));
}
__name(render$F, "render$F");
const __unplugin_components_5$1 = markRaw({ name: "lucide-route-off", render: render$F });
const _hoisted_1$1I = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$E(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1I, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M15 14c.2-1 .7-1.7 1.5-2.5c1-.9 1.5-2.2 1.5-3.5A6 6 0 0 0 6 8c0 1 .2 2.2 1.5 3.5c.7.7 1.3 1.5 1.5 2.5m0 4h6m-5 4h4"
    }, null, -1)
  ]));
}
__name(render$E, "render$E");
const __unplugin_components_4$2 = markRaw({ name: "lucide-lightbulb", render: render$E });
const _hoisted_1$1H = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$D(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1H, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "m6 9l6 6l6-6"
    }, null, -1)
  ]));
}
__name(render$D, "render$D");
const __unplugin_components_0$h = markRaw({ name: "lucide-chevron-down", render: render$D });
const _hoisted_1$1G = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$C(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1G, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("circle", {
        cx: "12",
        cy: "12",
        r: "3"
      }),
      createElementVNode("path", { d: "M3 7V5a2 2 0 0 1 2-2h2m10 0h2a2 2 0 0 1 2 2v2m0 10v2a2 2 0 0 1-2 2h-2M7 21H5a2 2 0 0 1-2-2v-2" })
    ], -1)
  ]));
}
__name(render$C, "render$C");
const __unplugin_components_2$4 = markRaw({ name: "lucide-focus", render: render$C });
const _hoisted_1$1F = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$B(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1F, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M18 11V6a2 2 0 0 0-2-2a2 2 0 0 0-2 2m0 4V4a2 2 0 0 0-2-2a2 2 0 0 0-2 2v2m0 4.5V6a2 2 0 0 0-2-2a2 2 0 0 0-2 2v8" }),
      createElementVNode("path", { d: "M18 8a2 2 0 1 1 4 0v6a8 8 0 0 1-8 8h-2c-2.8 0-4.5-.86-5.99-2.34l-3.6-3.6a2 2 0 0 1 2.83-2.82L7 15" })
    ], -1)
  ]));
}
__name(render$B, "render$B");
const __unplugin_components_1$7 = markRaw({ name: "lucide-hand", render: render$B });
const _hoisted_1$1E = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$A(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1E, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M4.037 4.688a.495.495 0 0 1 .651-.651l16 6.5a.5.5 0 0 1-.063.947l-6.124 1.58a2 2 0 0 0-1.438 1.435l-1.579 6.126a.5.5 0 0 1-.947.063z"
    }, null, -1)
  ]));
}
__name(render$A, "render$A");
const __unplugin_components_0$g = markRaw({ name: "lucide-mouse-pointer2", render: render$A });
function useZoomControls() {
  const isModalVisible = ref(false);
  const showModal = /* @__PURE__ */ __name(() => {
    isModalVisible.value = true;
  }, "showModal");
  const hideModal = /* @__PURE__ */ __name(() => {
    isModalVisible.value = false;
  }, "hideModal");
  const toggleModal = /* @__PURE__ */ __name(() => {
    isModalVisible.value = !isModalVisible.value;
  }, "toggleModal");
  const hasActivePopup = computed(() => isModalVisible.value);
  return {
    isModalVisible,
    showModal,
    hideModal,
    toggleModal,
    hasActivePopup
  };
}
__name(useZoomControls, "useZoomControls");
function useMinimapGraph(graph, onGraphChanged) {
  const nodeStatesCache = /* @__PURE__ */ new Map();
  const linksCache = ref("");
  const lastNodeCount = ref(0);
  const updateFlags = ref({
    bounds: false,
    nodes: false,
    connections: false,
    viewport: false
  });
  const originalCallbacksMap = /* @__PURE__ */ new Map();
  const handleGraphChangedThrottled = useThrottleFn$1(() => {
    onGraphChanged();
  }, 500);
  const setupEventListeners = /* @__PURE__ */ __name(() => {
    const g = graph.value;
    if (!g) return;
    if (originalCallbacksMap.has(g.id)) {
      return;
    }
    const originalCallbacks = {
      onNodeAdded: g.onNodeAdded,
      onNodeRemoved: g.onNodeRemoved,
      onConnectionChange: g.onConnectionChange
    };
    originalCallbacksMap.set(g.id, originalCallbacks);
    g.onNodeAdded = function(node) {
      originalCallbacks.onNodeAdded?.call(this, node);
      void handleGraphChangedThrottled();
    };
    g.onNodeRemoved = function(node) {
      originalCallbacks.onNodeRemoved?.call(this, node);
      nodeStatesCache.delete(node.id);
      void handleGraphChangedThrottled();
    };
    g.onConnectionChange = function(node) {
      originalCallbacks.onConnectionChange?.call(this, node);
      void handleGraphChangedThrottled();
    };
  }, "setupEventListeners");
  const cleanupEventListeners = /* @__PURE__ */ __name((oldGraph) => {
    const g = oldGraph || graph.value;
    if (!g) return;
    const originalCallbacks = originalCallbacksMap.get(g.id);
    if (!originalCallbacks) {
      console.error(
        "Attempted to cleanup event listeners for graph that was never set up"
      );
      return;
    }
    g.onNodeAdded = originalCallbacks.onNodeAdded;
    g.onNodeRemoved = originalCallbacks.onNodeRemoved;
    g.onConnectionChange = originalCallbacks.onConnectionChange;
    originalCallbacksMap.delete(g.id);
  }, "cleanupEventListeners");
  const checkForChangesInternal = /* @__PURE__ */ __name(() => {
    const g = graph.value;
    if (!g) return false;
    let structureChanged = false;
    let positionChanged = false;
    let connectionChanged = false;
    if (g._nodes.length !== lastNodeCount.value) {
      structureChanged = true;
      lastNodeCount.value = g._nodes.length;
    }
    for (const node of g._nodes) {
      const key = node.id;
      const currentState = `${node.pos[0]},${node.pos[1]},${node.size[0]},${node.size[1]}`;
      if (nodeStatesCache.get(key) !== currentState) {
        positionChanged = true;
        nodeStatesCache.set(key, currentState);
      }
    }
    const currentLinks = JSON.stringify(g.links || {});
    if (currentLinks !== linksCache.value) {
      connectionChanged = true;
      linksCache.value = currentLinks;
    }
    const currentNodeIds = new Set(g._nodes.map((n) => n.id));
    for (const [nodeId] of nodeStatesCache) {
      if (!currentNodeIds.has(nodeId)) {
        nodeStatesCache.delete(nodeId);
        structureChanged = true;
      }
    }
    if (structureChanged || positionChanged) {
      updateFlags.value.bounds = true;
      updateFlags.value.nodes = true;
    }
    if (connectionChanged) {
      updateFlags.value.connections = true;
    }
    return structureChanged || positionChanged || connectionChanged;
  }, "checkForChangesInternal");
  const init = /* @__PURE__ */ __name(() => {
    setupEventListeners();
    api.addEventListener("graphChanged", handleGraphChangedThrottled);
  }, "init");
  const destroy = /* @__PURE__ */ __name(() => {
    cleanupEventListeners();
    api.removeEventListener("graphChanged", handleGraphChangedThrottled);
    nodeStatesCache.clear();
  }, "destroy");
  const clearCache = /* @__PURE__ */ __name(() => {
    nodeStatesCache.clear();
    linksCache.value = "";
    lastNodeCount.value = 0;
  }, "clearCache");
  return {
    updateFlags,
    setupEventListeners,
    cleanupEventListeners,
    checkForChanges: checkForChangesInternal,
    init,
    destroy,
    clearCache
  };
}
__name(useMinimapGraph, "useMinimapGraph");
function useMinimapInteraction(containerRef, bounds, scale, width, height, centerViewOn, canvas) {
  const isDragging = ref(false);
  const containerRect = ref({
    left: 0,
    top: 0,
    width,
    height
  });
  const updateContainerRect = /* @__PURE__ */ __name(() => {
    if (!containerRef.value) return;
    const rect = containerRef.value.getBoundingClientRect();
    containerRect.value = {
      left: rect.left,
      top: rect.top,
      width: rect.width,
      height: rect.height
    };
  }, "updateContainerRect");
  const handlePointerDown2 = /* @__PURE__ */ __name((e) => {
    isDragging.value = true;
    updateContainerRect();
    handlePointerMove2(e);
  }, "handlePointerDown");
  const handlePointerMove2 = /* @__PURE__ */ __name((e) => {
    if (!isDragging.value || !canvas.value) return;
    const x = e.clientX - containerRect.value.left;
    const y = e.clientY - containerRect.value.top;
    const offsetX = (width - bounds.value.width * scale.value) / 2;
    const offsetY = (height - bounds.value.height * scale.value) / 2;
    const worldX = (x - offsetX) / scale.value + bounds.value.minX;
    const worldY = (y - offsetY) / scale.value + bounds.value.minY;
    centerViewOn(worldX, worldY);
  }, "handlePointerMove");
  const handlePointerUp2 = /* @__PURE__ */ __name(() => {
    isDragging.value = false;
  }, "handlePointerUp");
  const handleWheel = /* @__PURE__ */ __name((e) => {
    e.preventDefault();
    const c2 = canvas.value;
    if (!c2) return;
    if (containerRect.value.left === 0 && containerRect.value.top === 0 && containerRef.value) {
      updateContainerRect();
    }
    const ds = c2.ds;
    const delta = e.deltaY > 0 ? 0.9 : 1.1;
    const newScale = ds.scale * delta;
    const MIN_SCALE = 0.1;
    const MAX_SCALE = 10;
    if (newScale < MIN_SCALE || newScale > MAX_SCALE) return;
    const x = e.clientX - containerRect.value.left;
    const y = e.clientY - containerRect.value.top;
    const offsetX = (width - bounds.value.width * scale.value) / 2;
    const offsetY = (height - bounds.value.height * scale.value) / 2;
    const worldX = (x - offsetX) / scale.value + bounds.value.minX;
    const worldY = (y - offsetY) / scale.value + bounds.value.minY;
    ds.scale = newScale;
    centerViewOn(worldX, worldY);
  }, "handleWheel");
  return {
    isDragging,
    containerRect,
    updateContainerRect,
    handlePointerDown: handlePointerDown2,
    handlePointerMove: handlePointerMove2,
    handlePointerUp: handlePointerUp2,
    handleWheel
  };
}
__name(useMinimapInteraction, "useMinimapInteraction");
function useMinimapRenderer(canvasRef, graph, bounds, scale, updateFlags, settings, width, height) {
  const needsFullRedraw = ref(true);
  const needsBoundsUpdate = ref(true);
  const renderMinimap = /* @__PURE__ */ __name(() => {
    const g = graph.value;
    if (!canvasRef.value || !g) return;
    const ctx = canvasRef.value.getContext("2d");
    if (!ctx) return;
    if (!g._nodes || g._nodes.length === 0) {
      ctx.clearRect(0, 0, width, height);
      return;
    }
    const needsRedraw = needsFullRedraw.value || updateFlags.value.nodes || updateFlags.value.connections;
    if (needsRedraw) {
      renderMinimapToCanvas(canvasRef.value, g, {
        bounds: bounds.value,
        scale: scale.value,
        settings: {
          nodeColors: settings.nodeColors.value,
          showLinks: settings.showLinks.value,
          showGroups: settings.showGroups.value,
          renderBypass: settings.renderBypass.value,
          renderError: settings.renderError.value
        },
        width,
        height
      });
      needsFullRedraw.value = false;
      updateFlags.value.nodes = false;
      updateFlags.value.connections = false;
    }
  }, "renderMinimap");
  const updateMinimap = /* @__PURE__ */ __name((updateBounds, updateViewport) => {
    if (needsBoundsUpdate.value || updateFlags.value.bounds) {
      updateBounds();
      needsBoundsUpdate.value = false;
      updateFlags.value.bounds = false;
      needsFullRedraw.value = true;
      updateFlags.value.viewport = true;
    }
    if (needsFullRedraw.value || updateFlags.value.nodes || updateFlags.value.connections) {
      renderMinimap();
    }
    if (updateFlags.value.viewport) {
      updateViewport();
      updateFlags.value.viewport = false;
    }
  }, "updateMinimap");
  const forceFullRedraw = /* @__PURE__ */ __name(() => {
    needsFullRedraw.value = true;
    updateFlags.value.bounds = true;
    updateFlags.value.nodes = true;
    updateFlags.value.connections = true;
    updateFlags.value.viewport = true;
  }, "forceFullRedraw");
  return {
    needsFullRedraw,
    needsBoundsUpdate,
    renderMinimap,
    updateMinimap,
    forceFullRedraw
  };
}
__name(useMinimapRenderer, "useMinimapRenderer");
function useMinimapSettings() {
  const settingStore = useSettingStore();
  const colorPaletteStore = useColorPaletteStore();
  const nodeColors = computed(
    () => settingStore.get("Comfy.Minimap.NodeColors")
  );
  const showLinks = computed(() => settingStore.get("Comfy.Minimap.ShowLinks"));
  const showGroups = computed(
    () => settingStore.get("Comfy.Minimap.ShowGroups")
  );
  const renderBypass = computed(
    () => settingStore.get("Comfy.Minimap.RenderBypassState")
  );
  const renderError = computed(
    () => settingStore.get("Comfy.Minimap.RenderErrorState")
  );
  const width = 250;
  const height = 200;
  const isLightTheme = computed(
    () => colorPaletteStore.completedActivePalette.light_theme
  );
  const containerStyles = computed(() => ({
    width: `${width}px`,
    height: `${height}px`,
    backgroundColor: isLightTheme.value ? "#FAF9F5" : "#15161C",
    border: `1px solid ${isLightTheme.value ? "#ccc" : "#333"}`,
    borderRadius: "8px"
  }));
  const panelStyles = computed(() => ({
    width: `210px`,
    height: `${height}px`,
    backgroundColor: isLightTheme.value ? "#FAF9F5" : "#15161C",
    border: `1px solid ${isLightTheme.value ? "#ccc" : "#333"}`,
    borderRadius: "8px"
  }));
  return {
    nodeColors,
    showLinks,
    showGroups,
    renderBypass,
    renderError,
    containerStyles,
    panelStyles,
    isLightTheme
  };
}
__name(useMinimapSettings, "useMinimapSettings");
function useCanvasTransformSync$1(syncFn, options = {}) {
  const { onStart, onStop, autoStart = true } = options;
  const { getCanvas } = useCanvasStore();
  const isActive = ref(false);
  let rafId2 = null;
  let lastTransform = {
    scale: 0,
    offsetX: 0,
    offsetY: 0
  };
  const hasTransformChanged = /* @__PURE__ */ __name((canvas) => {
    const ds = canvas.ds;
    return ds.scale !== lastTransform.scale || ds.offset[0] !== lastTransform.offsetX || ds.offset[1] !== lastTransform.offsetY;
  }, "hasTransformChanged");
  const sync = /* @__PURE__ */ __name(() => {
    if (!isActive.value) return;
    const canvas = getCanvas();
    if (!canvas) return;
    try {
      if (hasTransformChanged(canvas)) {
        lastTransform = {
          scale: canvas.ds.scale,
          offsetX: canvas.ds.offset[0],
          offsetY: canvas.ds.offset[1]
        };
        syncFn(canvas);
      }
    } catch (error) {
      console.error("Canvas transform sync error:", error);
    }
    rafId2 = requestAnimationFrame(sync);
  }, "sync");
  const startSync = /* @__PURE__ */ __name(() => {
    if (isActive.value) return;
    isActive.value = true;
    onStart?.();
    lastTransform = { scale: 0, offsetX: 0, offsetY: 0 };
    sync();
  }, "startSync");
  const stopSync = /* @__PURE__ */ __name(() => {
    isActive.value = false;
    if (rafId2 !== null) {
      cancelAnimationFrame(rafId2);
      rafId2 = null;
    }
    onStop?.();
  }, "stopSync");
  onUnmounted(stopSync);
  if (autoStart) {
    startSync();
  }
  return {
    isActive,
    startSync,
    stopSync
  };
}
__name(useCanvasTransformSync$1, "useCanvasTransformSync$1");
function useMinimapViewport(canvas, graph, width, height) {
  const bounds = ref({
    minX: 0,
    minY: 0,
    maxX: 0,
    maxY: 0,
    width: 0,
    height: 0
  });
  const scale = ref(1);
  const viewportTransform = ref({
    x: 0,
    y: 0,
    width: 0,
    height: 0
  });
  const canvasDimensions = ref({
    width: 0,
    height: 0
  });
  const updateCanvasDimensions = /* @__PURE__ */ __name(() => {
    const c2 = canvas.value;
    if (!c2) return;
    const canvasEl = c2.canvas;
    const dpr = window.devicePixelRatio || 1;
    canvasDimensions.value = {
      width: canvasEl.clientWidth || canvasEl.width / dpr,
      height: canvasEl.clientHeight || canvasEl.height / dpr
    };
  }, "updateCanvasDimensions");
  const calculateGraphBounds = /* @__PURE__ */ __name(() => {
    const g = graph.value;
    if (!g || !g._nodes || g._nodes.length === 0) {
      return { minX: 0, minY: 0, maxX: 100, maxY: 100, width: 100, height: 100 };
    }
    const bounds2 = calculateNodeBounds(g._nodes);
    if (!bounds2) {
      return { minX: 0, minY: 0, maxX: 100, maxY: 100, width: 100, height: 100 };
    }
    return enforceMinimumBounds(bounds2);
  }, "calculateGraphBounds");
  const calculateScale = /* @__PURE__ */ __name(() => {
    return calculateMinimapScale(bounds.value, width, height);
  }, "calculateScale");
  const updateViewport = /* @__PURE__ */ __name(() => {
    const c2 = canvas.value;
    if (!c2) return;
    if (canvasDimensions.value.width === 0 || canvasDimensions.value.height === 0) {
      updateCanvasDimensions();
    }
    const ds = c2.ds;
    const viewportWidth = canvasDimensions.value.width / ds.scale;
    const viewportHeight = canvasDimensions.value.height / ds.scale;
    const worldX = -ds.offset[0];
    const worldY = -ds.offset[1];
    const centerOffsetX = (width - bounds.value.width * scale.value) / 2;
    const centerOffsetY = (height - bounds.value.height * scale.value) / 2;
    viewportTransform.value = {
      x: (worldX - bounds.value.minX) * scale.value + centerOffsetX,
      y: (worldY - bounds.value.minY) * scale.value + centerOffsetY,
      width: viewportWidth * scale.value,
      height: viewportHeight * scale.value
    };
  }, "updateViewport");
  const updateBounds = /* @__PURE__ */ __name(() => {
    bounds.value = calculateGraphBounds();
    scale.value = calculateScale();
  }, "updateBounds");
  const centerViewOn = /* @__PURE__ */ __name((worldX, worldY) => {
    const c2 = canvas.value;
    if (!c2) return;
    if (canvasDimensions.value.width === 0 || canvasDimensions.value.height === 0) {
      updateCanvasDimensions();
    }
    const ds = c2.ds;
    const viewportWidth = canvasDimensions.value.width / ds.scale;
    const viewportHeight = canvasDimensions.value.height / ds.scale;
    ds.offset[0] = -(worldX - viewportWidth / 2);
    ds.offset[1] = -(worldY - viewportHeight / 2);
    c2.setDirty(true, true);
  }, "centerViewOn");
  const { startSync: startViewportSync, stopSync: stopViewportSync } = useCanvasTransformSync$1(updateViewport, { autoStart: false });
  return {
    bounds: computed(() => bounds.value),
    scale: computed(() => scale.value),
    viewportTransform: computed(() => viewportTransform.value),
    canvasDimensions: computed(() => canvasDimensions.value),
    updateCanvasDimensions,
    updateViewport,
    updateBounds,
    centerViewOn,
    startViewportSync,
    stopViewportSync
  };
}
__name(useMinimapViewport, "useMinimapViewport");
function useMinimap() {
  const canvasStore = useCanvasStore();
  const workflowStore = useWorkflowStore();
  const settingStore = useSettingStore();
  const containerRef = ref();
  const canvasRef = ref();
  const minimapRef = ref(null);
  const visible = ref(true);
  const initialized = ref(false);
  const width = 250;
  const height = 200;
  const canvas = computed(() => canvasStore.canvas);
  const graph = computed(() => {
    const activeSubgraph = workflowStore.activeSubgraph;
    return activeSubgraph || canvas.value?.graph;
  });
  const settings = useMinimapSettings();
  const {
    nodeColors,
    showLinks,
    showGroups,
    renderBypass,
    renderError,
    containerStyles,
    panelStyles
  } = settings;
  const updateOption = /* @__PURE__ */ __name(async (key, value) => {
    await settingStore.set(key, value);
    renderer.forceFullRedraw();
    renderer.updateMinimap(viewport.updateBounds, viewport.updateViewport);
  }, "updateOption");
  const viewport = useMinimapViewport(canvas, graph, width, height);
  const interaction = useMinimapInteraction(
    containerRef,
    viewport.bounds,
    viewport.scale,
    width,
    height,
    viewport.centerViewOn,
    canvas
  );
  const graphManager = useMinimapGraph(graph, () => {
    renderer.forceFullRedraw();
    renderer.updateMinimap(viewport.updateBounds, viewport.updateViewport);
  });
  const renderer = useMinimapRenderer(
    canvasRef,
    graph,
    viewport.bounds,
    viewport.scale,
    graphManager.updateFlags,
    settings,
    width,
    height
  );
  const { pause: pauseChangeDetection, resume: resumeChangeDetection } = useRafFn$1(
    async () => {
      if (visible.value) {
        const hasChanges = await graphManager.checkForChanges();
        if (hasChanges) {
          renderer.updateMinimap(
            viewport.updateBounds,
            viewport.updateViewport
          );
        }
      }
    },
    { immediate: false }
  );
  const init = /* @__PURE__ */ __name(async () => {
    if (initialized.value) return;
    visible.value = settingStore.get("Comfy.Minimap.Visible");
    if (canvas.value && graph.value) {
      graphManager.init();
      if (containerRef.value) {
        interaction.updateContainerRect();
      }
      viewport.updateCanvasDimensions();
      window.addEventListener("resize", interaction.updateContainerRect);
      window.addEventListener("scroll", interaction.updateContainerRect);
      window.addEventListener("resize", viewport.updateCanvasDimensions);
      renderer.forceFullRedraw();
      renderer.updateMinimap(viewport.updateBounds, viewport.updateViewport);
      viewport.updateViewport();
      if (visible.value) {
        resumeChangeDetection();
        viewport.startViewportSync();
      }
      initialized.value = true;
    }
  }, "init");
  const destroy = /* @__PURE__ */ __name(() => {
    pauseChangeDetection();
    viewport.stopViewportSync();
    graphManager.destroy();
    window.removeEventListener("resize", interaction.updateContainerRect);
    window.removeEventListener("scroll", interaction.updateContainerRect);
    window.removeEventListener("resize", viewport.updateCanvasDimensions);
    initialized.value = false;
  }, "destroy");
  watch(
    canvas,
    async (newCanvas, oldCanvas) => {
      if (oldCanvas) {
        graphManager.cleanupEventListeners();
        pauseChangeDetection();
        viewport.stopViewportSync();
        graphManager.destroy();
        window.removeEventListener("resize", interaction.updateContainerRect);
        window.removeEventListener("scroll", interaction.updateContainerRect);
        window.removeEventListener("resize", viewport.updateCanvasDimensions);
      }
      if (newCanvas && !initialized.value) {
        await init();
      }
    },
    { immediate: true, flush: "post" }
  );
  watch(graph, (newGraph, oldGraph) => {
    if (newGraph && newGraph !== oldGraph) {
      graphManager.cleanupEventListeners(oldGraph || void 0);
      graphManager.setupEventListeners();
      renderer.forceFullRedraw();
      renderer.updateMinimap(viewport.updateBounds, viewport.updateViewport);
    }
  });
  watch(visible, async (isVisible) => {
    if (isVisible) {
      if (containerRef.value) {
        interaction.updateContainerRect();
      }
      viewport.updateCanvasDimensions();
      renderer.forceFullRedraw();
      await nextTick();
      await nextTick();
      renderer.updateMinimap(viewport.updateBounds, viewport.updateViewport);
      viewport.updateViewport();
      resumeChangeDetection();
      viewport.startViewportSync();
    } else {
      pauseChangeDetection();
      viewport.stopViewportSync();
    }
  });
  const toggle = /* @__PURE__ */ __name(async () => {
    visible.value = !visible.value;
    await settingStore.set("Comfy.Minimap.Visible", visible.value);
  }, "toggle");
  const setMinimapRef = /* @__PURE__ */ __name((ref2) => {
    minimapRef.value = ref2;
  }, "setMinimapRef");
  const viewportStyles = computed(() => {
    const transform2 = viewport.viewportTransform.value;
    return {
      transform: `translate(${transform2.x}px, ${transform2.y}px)`,
      width: `${transform2.width}px`,
      height: `${transform2.height}px`,
      border: `2px solid ${settings.isLightTheme.value ? "#E0E0E0" : "#FFF"}`,
      backgroundColor: `rgba(255, 255, 255, 0.2)`,
      willChange: "transform",
      backfaceVisibility: "hidden",
      perspective: "1000px",
      pointerEvents: "none"
    };
  });
  return {
    visible: computed(() => visible.value),
    initialized: computed(() => initialized.value),
    containerRef,
    canvasRef,
    containerStyles,
    viewportStyles,
    panelStyles,
    width,
    height,
    nodeColors,
    showLinks,
    showGroups,
    renderBypass,
    renderError,
    init,
    destroy,
    toggle,
    renderMinimap: renderer.renderMinimap,
    handlePointerDown: interaction.handlePointerDown,
    handlePointerMove: interaction.handlePointerMove,
    handlePointerUp: interaction.handlePointerUp,
    handleWheel: interaction.handleWheel,
    setMinimapRef,
    updateOption
  };
}
__name(useMinimap, "useMinimap");
const _hoisted_1$1D = {
  key: 0,
  class: "w-[250px] absolute flex justify-center right-2 md:right-11 z-1300 bottom-[66px] bg-inherit! border-0!"
};
const _hoisted_2$L = { class: "text-sm font-medium block" };
const _hoisted_3$t = { class: "text-sm text-gray-500 block" };
const _hoisted_4$k = { class: "text-sm font-medium block" };
const _hoisted_5$c = { class: "text-sm text-gray-500 block" };
const _hoisted_6$9 = { class: "text-sm font-medium block" };
const _hoisted_7$7 = { class: "text-sm text-gray-500 block" };
const _hoisted_8$6 = { class: "text-sm font-medium block" };
const _hoisted_9$5 = { class: "text-sm text-gray-500 block" };
const _sfc_main$1C = /* @__PURE__ */ defineComponent({
  __name: "ZoomControlsModal",
  props: {
    visible: { type: Boolean }
  },
  setup(__props) {
    const { t: t2 } = useI18n();
    const minimap = useMinimap();
    const settingStore = useSettingStore();
    const commandStore = useCommandStore();
    const canvasStore = useCanvasStore();
    const { formatKeySequence } = useCommandStore();
    const props2 = __props;
    const interval = ref(null);
    const minimapToggleText = computed(
      () => settingStore.get("Comfy.Minimap.Visible") ? t2("zoomControls.hideMinimap") : t2("zoomControls.showMinimap")
    );
    const applyZoom = /* @__PURE__ */ __name((val) => {
      const inputValue = val.value;
      if (isNaN(inputValue) || inputValue < 1 || inputValue > 1e3) {
        return;
      }
      canvasStore.setAppZoomFromPercentage(inputValue);
    }, "applyZoom");
    const executeCommand = /* @__PURE__ */ __name((command) => {
      void commandStore.execute(command);
    }, "executeCommand");
    const startRepeat = /* @__PURE__ */ __name((command) => {
      if (interval.value) return;
      const cmd = /* @__PURE__ */ __name(() => commandStore.execute(command), "cmd");
      void cmd();
      interval.value = window.setInterval(cmd, 100);
    }, "startRepeat");
    const stopRepeat = /* @__PURE__ */ __name(() => {
      if (interval.value) {
        clearInterval(interval.value);
        interval.value = null;
      }
    }, "stopRepeat");
    const filteredMinimapStyles = computed(() => {
      return {
        ...minimap.containerStyles.value,
        height: void 0,
        width: void 0
      };
    });
    const zoomInCommandText = computed(
      () => formatKeySequence(commandStore.getCommand("Comfy.Canvas.ZoomIn"))
    );
    const zoomOutCommandText = computed(
      () => formatKeySequence(commandStore.getCommand("Comfy.Canvas.ZoomOut"))
    );
    const zoomToFitCommandText = computed(
      () => formatKeySequence(commandStore.getCommand("Comfy.Canvas.FitView"))
    );
    const showMinimapCommandText = computed(
      () => formatKeySequence(commandStore.getCommand("Comfy.Canvas.ToggleMinimap"))
    );
    const zoomInput = ref(null);
    const zoomInputContainer = ref(null);
    watch(
      () => props2.visible,
      async (newVal) => {
        if (newVal) {
          await nextTick();
          const input = zoomInputContainer.value?.querySelector(
            "input"
          );
          input?.focus();
        }
      }
    );
    return (_ctx, _cache) => {
      return _ctx.visible ? (openBlock(), createElementBlock("div", _hoisted_1$1D, [
        createElementVNode("div", {
          class: "bg-white dark-theme:bg-[#2b2b2b] border border-gray-200 dark-theme:border-gray-700 rounded-lg shadow-lg p-4 w-4/5",
          style: normalizeStyle(filteredMinimapStyles.value),
          onClick: _cache[4] || (_cache[4] = withModifiers(() => {
          }, ["stop"]))
        }, [
          createElementVNode("div", null, [
            createVNode(unref(Button$1), {
              severity: "secondary",
              text: "",
              pt: {
                root: {
                  class: "flex items-center justify-between cursor-pointer p-2 rounded w-full text-left hover:bg-transparent! focus:bg-transparent! active:bg-transparent!"
                },
                label: {
                  class: "flex flex-col items-start w-full"
                }
              },
              onMousedown: _cache[0] || (_cache[0] = ($event) => startRepeat("Comfy.Canvas.ZoomIn")),
              onMouseup: stopRepeat,
              onMouseleave: stopRepeat
            }, {
              default: withCtx(() => [
                createElementVNode("span", _hoisted_2$L, toDisplayString(_ctx.$t("graphCanvasMenu.zoomIn")), 1),
                createElementVNode("span", _hoisted_3$t, toDisplayString(zoomInCommandText.value), 1)
              ]),
              _: 1
            }),
            createVNode(unref(Button$1), {
              severity: "secondary",
              text: "",
              pt: {
                root: {
                  class: "flex items-center justify-between cursor-pointer p-2 rounded w-full text-left hover:bg-transparent! focus:bg-transparent! active:bg-transparent!"
                },
                label: {
                  class: "flex flex-col items-start w-full"
                }
              },
              onMousedown: _cache[1] || (_cache[1] = ($event) => startRepeat("Comfy.Canvas.ZoomOut")),
              onMouseup: stopRepeat,
              onMouseleave: stopRepeat
            }, {
              default: withCtx(() => [
                createElementVNode("span", _hoisted_4$k, toDisplayString(_ctx.$t("graphCanvasMenu.zoomOut")), 1),
                createElementVNode("span", _hoisted_5$c, toDisplayString(zoomOutCommandText.value), 1)
              ]),
              _: 1
            }),
            createVNode(unref(Button$1), {
              severity: "secondary",
              text: "",
              pt: {
                root: {
                  class: "flex items-center justify-between cursor-pointer p-2 rounded w-full text-left hover:bg-transparent! focus:bg-transparent! active:bg-transparent!"
                },
                label: {
                  class: "flex flex-col items-start w-full"
                }
              },
              onClick: _cache[2] || (_cache[2] = ($event) => executeCommand("Comfy.Canvas.FitView"))
            }, {
              default: withCtx(() => [
                createElementVNode("span", _hoisted_6$9, toDisplayString(_ctx.$t("zoomControls.zoomToFit")), 1),
                createElementVNode("span", _hoisted_7$7, toDisplayString(zoomToFitCommandText.value), 1)
              ]),
              _: 1
            }),
            _cache[6] || (_cache[6] = createElementVNode("hr", { class: "border-[#E1DED5] mb-1 dark-theme:border-[#2E3037]" }, null, -1)),
            createVNode(unref(Button$1), {
              severity: "secondary",
              text: "",
              "data-testid": "toggle-minimap-button",
              pt: {
                root: {
                  class: "flex items-center justify-between cursor-pointer p-2 rounded w-full text-left hover:bg-transparent! focus:bg-transparent! active:bg-transparent!"
                },
                label: {
                  class: "flex flex-col items-start w-full"
                }
              },
              onClick: _cache[3] || (_cache[3] = ($event) => executeCommand("Comfy.Canvas.ToggleMinimap"))
            }, {
              default: withCtx(() => [
                createElementVNode("span", _hoisted_8$6, toDisplayString(minimapToggleText.value), 1),
                createElementVNode("span", _hoisted_9$5, toDisplayString(showMinimapCommandText.value), 1)
              ]),
              _: 1
            }),
            _cache[7] || (_cache[7] = createElementVNode("hr", { class: "border-[#E1DED5] mt-1 dark-theme:border-[#2E3037]" }, null, -1)),
            createElementVNode("div", {
              ref_key: "zoomInputContainer",
              ref: zoomInputContainer,
              class: "flex items-center px-2 bg-[#E7E6E6] focus-within:bg-[#F3F3F3] dark-theme:bg-[#8282821A] rounded p-2 zoomInputContainer"
            }, [
              createVNode(unref(InputNumber), {
                ref_key: "zoomInput",
                ref: zoomInput,
                "default-value": unref(canvasStore).appScalePercentage,
                min: 1,
                max: 1e3,
                "show-buttons": false,
                "use-grouping": false,
                unstyled: true,
                "input-class": "flex-1 bg-transparent border-none outline-hidden text-sm shadow-none my-0 ",
                fluid: "",
                onInput: applyZoom,
                onKeyup: withKeys(applyZoom, ["enter"])
              }, null, 8, ["default-value"]),
              _cache[5] || (_cache[5] = createElementVNode("span", { class: "text-sm text-gray-500 -ml-4" }, "%", -1))
            ], 512)
          ])
        ], 4)
      ])) : createCommentVNode("", true);
    };
  }
});
const _hoisted_1$1C = { class: "inline-flex text-xs" };
const _sfc_main$1B = /* @__PURE__ */ defineComponent({
  __name: "GraphCanvasMenu",
  setup(__props) {
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const { formatKeySequence } = useCommandStore();
    const canvasStore = useCanvasStore();
    const settingStore = useSettingStore();
    const canvasInteractions = useCanvasInteractions();
    const workspaceStore = useWorkspaceStore();
    const minimap = useMinimap();
    const { isModalVisible, toggleModal, hideModal, hasActivePopup } = useZoomControls();
    const stringifiedMinimapStyles = computed(() => {
      const buttonGroupKeys = ["backgroundColor", "borderRadius", ""];
      const buttonKeys = ["backgroundColor", "borderRadius"];
      const additionalButtonStyles = {
        border: "none",
        width: "35px",
        height: "35px",
        "margin-right": "2px",
        "margin-left": "2px"
      };
      const containerStyles = minimap.containerStyles.value;
      const buttonStyles = {
        ...Object.fromEntries(
          Object.entries(containerStyles).filter(
            ([key]) => buttonKeys.includes(key)
          )
        ),
        ...additionalButtonStyles
      };
      const buttonGroupStyles = Object.entries(containerStyles).filter(([key]) => buttonGroupKeys.includes(key)).reduce((acc, [key, value]) => ({ ...acc, [key]: value }), {});
      return { buttonStyles, buttonGroupStyles };
    });
    const isCanvasReadOnly = computed(() => canvasStore.canvas?.read_only ?? false);
    const isCanvasUnlocked = computed(() => !isCanvasReadOnly.value);
    const linkHidden = computed(
      () => settingStore.get("Comfy.LinkRenderMode") === LiteGraph.HIDDEN_LINK
    );
    const unlockCommandText = computed(
      () => formatKeySequence(
        commandStore.getCommand("Comfy.Canvas.Unlock")
      ).toUpperCase()
    );
    const lockCommandText = computed(
      () => formatKeySequence(commandStore.getCommand("Comfy.Canvas.Lock")).toUpperCase()
    );
    const fitViewCommandText = computed(
      () => formatKeySequence(
        commandStore.getCommand("Comfy.Canvas.FitView")
      ).toUpperCase()
    );
    const focusCommandText = computed(
      () => formatKeySequence(
        commandStore.getCommand("Workspace.ToggleFocusMode")
      ).toUpperCase()
    );
    const selectButtonClass = computed(
      () => isCanvasUnlocked.value ? "not-active:dark-theme:bg-[#262729]! not-active:bg-[#E7E6E6]!" : ""
    );
    const handButtonClass = computed(
      () => isCanvasReadOnly.value ? "not-active:dark-theme:bg-[#262729]! not-active:bg-[#E7E6E6]!" : ""
    );
    const zoomButtonClass = computed(() => [
      "w-16!",
      isModalVisible.value ? "not-active:dark-theme:bg-[#262729]! not-active:bg-[#E7E6E6]!" : "",
      "dark-theme:hover:bg-[#262729]! hover:bg-[#E7E6E6]!"
    ]);
    const focusButtonClass = computed(() => ({
      "dark-theme:hover:bg-[#262729]! hover:bg-[#E7E6E6]!": true,
      "not-active:dark-theme:bg-[#262729]! not-active:bg-[#E7E6E6]!": workspaceStore.focusMode
    }));
    const selectTooltip = computed(
      () => `${t2("graphCanvasMenu.select")} (${unlockCommandText.value})`
    );
    const handTooltip = computed(
      () => `${t2("graphCanvasMenu.hand")} (${lockCommandText.value})`
    );
    const fitViewTooltip = computed(
      () => `${t2("graphCanvasMenu.fitView")} (${fitViewCommandText.value})`
    );
    const focusModeTooltip = computed(
      () => `${t2("graphCanvasMenu.focusMode")} (${focusCommandText.value})`
    );
    const linkVisibilityTooltip = computed(
      () => linkHidden.value ? t2("graphCanvasMenu.showLinks") : t2("graphCanvasMenu.hideLinks")
    );
    const linkVisibilityAriaLabel = computed(
      () => linkHidden.value ? t2("graphCanvasMenu.showLinks") : t2("graphCanvasMenu.hideLinks")
    );
    const linkVisibleClass = computed(() => [
      linkHidden.value ? "not-active:dark-theme:bg-[#262729]! not-active:bg-[#E7E6E6]!" : "",
      "dark-theme:hover:bg-[#262729]! hover:bg-[#E7E6E6]!"
    ]);
    onMounted(() => {
      canvasStore.initScaleSync();
    });
    onBeforeUnmount(() => {
      canvasStore.cleanupScaleSync();
    });
    return (_ctx, _cache) => {
      const _component_i_lucide58mouse_pointer_2 = __unplugin_components_0$g;
      const _component_i_lucide58hand = __unplugin_components_1$7;
      const _component_i_lucide58focus = __unplugin_components_2$4;
      const _component_i_lucide58chevron_down = __unplugin_components_0$h;
      const _component_i_lucide58lightbulb = __unplugin_components_4$2;
      const _component_i_lucide58route_off = __unplugin_components_5$1;
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", null, [
        createVNode(_sfc_main$1C, { visible: unref(isModalVisible) }, null, 8, ["visible"]),
        unref(hasActivePopup) ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: "fixed inset-0 z-1200",
          onClick: _cache[0] || (_cache[0] = //@ts-ignore
          (...args) => unref(hideModal) && unref(hideModal)(...args))
        })) : createCommentVNode("", true),
        createVNode(unref(ButtonGroup), {
          class: "p-buttongroup-vertical p-1 absolute bottom-4 right-2 md:right-4",
          style: normalizeStyle(stringifiedMinimapStyles.value.buttonGroupStyles),
          onWheel: unref(canvasInteractions).handleWheel
        }, {
          default: withCtx(() => [
            withDirectives((openBlock(), createBlock(unref(Button), {
              style: normalizeStyle(stringifiedMinimapStyles.value.buttonStyles),
              severity: "secondary",
              "aria-label": selectTooltip.value,
              pressed: isCanvasReadOnly.value,
              icon: "i-material-symbols:pan-tool-outline",
              class: normalizeClass(selectButtonClass.value),
              onClick: _cache[1] || (_cache[1] = () => unref(commandStore).execute("Comfy.Canvas.Unlock"))
            }, {
              icon: withCtx(() => [
                createVNode(_component_i_lucide58mouse_pointer_2)
              ]),
              _: 1
            }, 8, ["style", "aria-label", "pressed", "class"])), [
              [
                _directive_tooltip,
                selectTooltip.value,
                void 0,
                { top: true }
              ]
            ]),
            withDirectives((openBlock(), createBlock(unref(Button), {
              severity: "secondary",
              "aria-label": handTooltip.value,
              pressed: isCanvasUnlocked.value,
              class: normalizeClass(handButtonClass.value),
              style: normalizeStyle(stringifiedMinimapStyles.value.buttonStyles),
              onClick: _cache[2] || (_cache[2] = () => unref(commandStore).execute("Comfy.Canvas.Lock"))
            }, {
              icon: withCtx(() => [
                createVNode(_component_i_lucide58hand)
              ]),
              _: 1
            }, 8, ["aria-label", "pressed", "class", "style"])), [
              [
                _directive_tooltip,
                handTooltip.value,
                void 0,
                { top: true }
              ]
            ]),
            _cache[6] || (_cache[6] = createElementVNode("div", { class: "w-px my-1 bg-[#E1DED5] dark-theme:bg-[#2E3037] mx-2" }, null, -1)),
            withDirectives((openBlock(), createBlock(unref(Button), {
              severity: "secondary",
              icon: "pi pi-expand",
              "aria-label": fitViewTooltip.value,
              style: normalizeStyle(stringifiedMinimapStyles.value.buttonStyles),
              class: "dark-theme:hover:bg-[#444444]! hover:bg-[#E7E6E6]!",
              onClick: _cache[3] || (_cache[3] = () => unref(commandStore).execute("Comfy.Canvas.FitView"))
            }, {
              icon: withCtx(() => [
                createVNode(_component_i_lucide58focus)
              ]),
              _: 1
            }, 8, ["aria-label", "style"])), [
              [
                _directive_tooltip,
                fitViewTooltip.value,
                void 0,
                { top: true }
              ]
            ]),
            withDirectives((openBlock(), createBlock(unref(Button), {
              ref: "zoomButton",
              severity: "secondary",
              label: unref(t2)("zoomControls.label"),
              class: normalizeClass(zoomButtonClass.value),
              "aria-label": unref(t2)("zoomControls.label"),
              "data-testid": "zoom-controls-button",
              style: normalizeStyle(stringifiedMinimapStyles.value.buttonStyles),
              onClick: unref(toggleModal)
            }, {
              default: withCtx(() => [
                createElementVNode("span", _hoisted_1$1C, [
                  createElementVNode("span", null, toDisplayString(unref(canvasStore).appScalePercentage) + "%", 1),
                  createVNode(_component_i_lucide58chevron_down)
                ])
              ]),
              _: 1
            }, 8, ["label", "class", "aria-label", "style", "onClick"])), [
              [
                _directive_tooltip,
                unref(t2)("zoomControls.label"),
                void 0,
                { top: true }
              ]
            ]),
            _cache[7] || (_cache[7] = createElementVNode("div", { class: "w-px my-1 bg-[#E1DED5] dark-theme:bg-[#2E3037] mx-2" }, null, -1)),
            withDirectives((openBlock(), createBlock(unref(Button), {
              ref: "focusButton",
              severity: "secondary",
              "aria-label": focusModeTooltip.value,
              "data-testid": "focus-mode-button",
              style: normalizeStyle(stringifiedMinimapStyles.value.buttonStyles),
              class: normalizeClass(focusButtonClass.value),
              onClick: _cache[4] || (_cache[4] = () => unref(commandStore).execute("Workspace.ToggleFocusMode"))
            }, {
              icon: withCtx(() => [
                createVNode(_component_i_lucide58lightbulb)
              ]),
              _: 1
            }, 8, ["aria-label", "style", "class"])), [
              [
                _directive_tooltip,
                focusModeTooltip.value,
                void 0,
                { top: true }
              ]
            ]),
            withDirectives((openBlock(), createBlock(unref(Button), {
              severity: "secondary",
              class: normalizeClass(linkVisibleClass.value),
              "aria-label": linkVisibilityAriaLabel.value,
              "data-testid": "toggle-link-visibility-button",
              style: normalizeStyle(stringifiedMinimapStyles.value.buttonStyles),
              onClick: _cache[5] || (_cache[5] = () => unref(commandStore).execute("Comfy.Canvas.ToggleLinkVisibility"))
            }, {
              icon: withCtx(() => [
                createVNode(_component_i_lucide58route_off)
              ]),
              _: 1
            }, 8, ["class", "aria-label", "style"])), [
              [
                _directive_tooltip,
                {
                  value: linkVisibilityTooltip.value,
                  pt: {
                    root: {
                      style: "z-index: 2; transform: translateY(-20px);"
                    }
                  }
                },
                void 0,
                { top: true }
              ]
            ])
          ]),
          _: 1
        }, 8, ["style", "onWheel"])
      ]);
    };
  }
});
const GraphCanvasMenu = /* @__PURE__ */ _export_sfc(_sfc_main$1B, [["__scopeId", "data-v-ff65687c"]]);
const _sfc_main$1A = /* @__PURE__ */ defineComponent({
  __name: "NodeTooltip",
  setup(__props) {
    let idleTimeout;
    const nodeDefStore = useNodeDefStore();
    const settingStore = useSettingStore();
    const tooltipRef = ref();
    const tooltipText = ref("");
    const left = ref();
    const top = ref();
    const hideTooltip = /* @__PURE__ */ __name(() => tooltipText.value = "", "hideTooltip");
    const showTooltip = /* @__PURE__ */ __name(async (tooltip) => {
      if (!tooltip) return;
      left.value = app.canvas.mouse[0] + "px";
      top.value = app.canvas.mouse[1] + "px";
      tooltipText.value = tooltip;
      await nextTick();
      const rect = tooltipRef.value?.getBoundingClientRect();
      if (!rect) return;
      if (rect.right > window.innerWidth) {
        left.value = app.canvas.mouse[0] - rect.width + "px";
      }
      if (rect.top < 0) {
        top.value = app.canvas.mouse[1] + rect.height + "px";
      }
    }, "showTooltip");
    const onIdle = /* @__PURE__ */ __name(() => {
      const { canvas } = app;
      const node = canvas.node_over;
      if (!node) return;
      const ctor = node.constructor;
      const nodeDef = nodeDefStore.nodeDefsByName[node.type ?? ""];
      if (ctor.title_mode !== LiteGraph.NO_TITLE && canvas.graph_mouse[1] < node.pos[1]) {
        return showTooltip(nodeDef.description);
      }
      if (node.flags?.collapsed) return;
      const inputSlot = isOverNodeInput(
        node,
        canvas.graph_mouse[0],
        canvas.graph_mouse[1],
        [0, 0]
      );
      if (inputSlot !== -1) {
        const inputName = node.inputs[inputSlot].name;
        const translatedTooltip = st(
          `nodeDefs.${normalizeI18nKey(node.type ?? "")}.inputs.${normalizeI18nKey(inputName)}.tooltip`,
          nodeDef.inputs[inputName]?.tooltip ?? ""
        );
        return showTooltip(translatedTooltip);
      }
      const outputSlot = isOverNodeOutput(
        node,
        canvas.graph_mouse[0],
        canvas.graph_mouse[1],
        [0, 0]
      );
      if (outputSlot !== -1) {
        const translatedTooltip = st(
          `nodeDefs.${normalizeI18nKey(node.type ?? "")}.outputs.${outputSlot}.tooltip`,
          nodeDef.outputs[outputSlot]?.tooltip ?? ""
        );
        return showTooltip(translatedTooltip);
      }
      const widget = app.canvas.getWidgetAtCursor();
      if (widget && !isDOMWidget(widget)) {
        const translatedTooltip = st(
          `nodeDefs.${normalizeI18nKey(node.type ?? "")}.inputs.${normalizeI18nKey(widget.name)}.tooltip`,
          nodeDef.inputs[widget.name]?.tooltip ?? ""
        );
        return showTooltip(widget.tooltip ?? translatedTooltip);
      }
    }, "onIdle");
    const onMouseMove = /* @__PURE__ */ __name((e) => {
      hideTooltip();
      clearTimeout(idleTimeout);
      if (e.target.nodeName !== "CANVAS") return;
      idleTimeout = window.setTimeout(
        onIdle,
        settingStore.get("LiteGraph.Node.TooltipDelay")
      );
    }, "onMouseMove");
    useEventListener$1(window, "mousemove", onMouseMove);
    useEventListener$1(window, "click", hideTooltip);
    return (_ctx, _cache) => {
      return tooltipText.value ? (openBlock(), createElementBlock("div", {
        key: 0,
        ref_key: "tooltipRef",
        ref: tooltipRef,
        class: "node-tooltip",
        style: normalizeStyle({ left: left.value, top: top.value })
      }, toDisplayString(tooltipText.value), 5)) : createCommentVNode("", true);
    };
  }
});
const NodeTooltip = /* @__PURE__ */ _export_sfc(_sfc_main$1A, [["__scopeId", "data-v-9621f52a"]]);
const _hoisted_1$1B = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$z(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1B, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M4.929 4.929L19.07 19.071" }),
      createElementVNode("circle", {
        cx: "12",
        cy: "12",
        r: "10"
      })
    ], -1)
  ]));
}
__name(render$z, "render$z");
const __unplugin_components_0$f = markRaw({ name: "lucide-ban", render: render$z });
const _sfc_main$1z = /* @__PURE__ */ defineComponent({
  __name: "BypassButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const toggleBypass = /* @__PURE__ */ __name(async () => {
      await commandStore.execute("Comfy.Canvas.ToggleSelectedNodes.Bypass");
    }, "toggleBypass");
    return (_ctx, _cache) => {
      const _component_i_lucide58ban = __unplugin_components_0$f;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        "data-testid": "bypass-button",
        class: "hover:dark-theme:bg-charcoal-600 hover:bg-[#E7E6E6]",
        onClick: toggleBypass
      }, {
        icon: withCtx(() => [
          createVNode(_component_i_lucide58ban, { class: "w-4 h-4" })
        ]),
        _: 1
      })), [
        [
          _directive_tooltip,
          {
            value: unref(t2)("commands.Comfy_Canvas_ToggleSelectedNodes_Bypass.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1A = { class: "relative" };
const _hoisted_2$K = { class: "flex items-center gap-1 px-0" };
const _hoisted_3$s = {
  key: 0,
  class: "color-picker-container absolute -top-10 left-1/2"
};
const _hoisted_4$j = ["data-testid"];
const _sfc_main$1y = /* @__PURE__ */ defineComponent({
  __name: "ColorPickerButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const canvasStore = useCanvasStore();
    const colorPaletteStore = useColorPaletteStore();
    const workflowStore = useWorkflowStore();
    const isLightTheme = computed(
      () => colorPaletteStore.completedActivePalette.light_theme
    );
    const toLightThemeColor = /* @__PURE__ */ __name((color) => adjustColor(color, { lightness: 0.5 }), "toLightThemeColor");
    const showColorPicker = ref(false);
    const NO_COLOR_OPTION = {
      name: "noColor",
      localizedName: t2("color.noColor"),
      value: {
        dark: LiteGraph.NODE_DEFAULT_BGCOLOR,
        light: toLightThemeColor(LiteGraph.NODE_DEFAULT_BGCOLOR)
      }
    };
    const colorOptions = [
      NO_COLOR_OPTION,
      ...Object.entries(LGraphCanvas.node_colors).map(([name, color]) => ({
        name,
        localizedName: t2(`color.${name}`),
        value: {
          dark: color.bgcolor,
          light: toLightThemeColor(color.bgcolor)
        }
      }))
    ];
    const selectedColorOption = ref(null);
    const applyColor = /* @__PURE__ */ __name((colorOption) => {
      const colorName = colorOption?.name ?? NO_COLOR_OPTION.name;
      const canvasColorOption = colorName === NO_COLOR_OPTION.name ? null : LGraphCanvas.node_colors[colorName];
      for (const item of canvasStore.selectedItems) {
        if (isColorable(item)) {
          item.setColorOption(canvasColorOption);
        }
      }
      canvasStore.canvas?.setDirty(true, true);
      currentColorOption.value = canvasColorOption;
      showColorPicker.value = false;
      workflowStore.activeWorkflow?.changeTracker.checkState();
    }, "applyColor");
    const currentColorOption = ref(null);
    const currentColor = computed(
      () => currentColorOption.value ? isLightTheme.value ? toLightThemeColor(currentColorOption.value?.bgcolor) : currentColorOption.value?.bgcolor : null
    );
    const localizedCurrentColorName = computed(() => {
      if (!currentColorOption.value?.bgcolor) return null;
      const colorOption = colorOptions.find(
        (option) => option.value.dark === currentColorOption.value?.bgcolor || option.value.light === currentColorOption.value?.bgcolor
      );
      return colorOption?.localizedName ?? NO_COLOR_OPTION.localizedName;
    });
    const updateColorSelectionFromNode = /* @__PURE__ */ __name((newSelectedItems) => {
      showColorPicker.value = false;
      selectedColorOption.value = null;
      currentColorOption.value = getItemsColorOption(newSelectedItems);
    }, "updateColorSelectionFromNode");
    watch(
      () => canvasStore.selectedItems,
      (newSelectedItems) => {
        updateColorSelectionFromNode(newSelectedItems);
      },
      { immediate: true }
    );
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", _hoisted_1$1A, [
        withDirectives((openBlock(), createBlock(unref(Button), {
          "data-testid": "color-picker-button",
          severity: "secondary",
          text: "",
          onClick: _cache[0] || (_cache[0] = () => showColorPicker.value = !showColorPicker.value)
        }, {
          default: withCtx(() => [
            createElementVNode("div", _hoisted_2$K, [
              createElementVNode("i", {
                class: "w-4 h-4 pi pi-circle-fill",
                style: normalizeStyle({ color: currentColor.value ?? "" })
              }, null, 4),
              _cache[1] || (_cache[1] = createElementVNode("i", {
                class: "w-4 h-4 pi pi-chevron-down py-1",
                style: { fontSize: "0.5rem" }
              }, null, -1))
            ])
          ]),
          _: 1
        })), [
          [
            _directive_tooltip,
            {
              value: localizedCurrentColorName.value ?? unref(t2)("color.noColor"),
              showDelay: 1e3
            },
            void 0,
            { top: true }
          ]
        ]),
        showColorPicker.value ? (openBlock(), createElementBlock("div", _hoisted_3$s, [
          createVNode(unref(SelectButton), {
            "model-value": selectedColorOption.value,
            options: colorOptions,
            "option-label": "name",
            "data-key": "value",
            "onUpdate:modelValue": applyColor
          }, {
            option: withCtx(({ option }) => [
              withDirectives(createElementVNode("i", {
                class: "pi pi-circle-fill",
                style: normalizeStyle({
                  color: isLightTheme.value ? option.value.light : option.value.dark
                }),
                "data-testid": option.name
              }, null, 12, _hoisted_4$j), [
                [
                  _directive_tooltip,
                  option.localizedName,
                  void 0,
                  { top: true }
                ]
              ])
            ]),
            _: 1
          }, 8, ["model-value"])
        ])) : createCommentVNode("", true)
      ]);
    };
  }
});
const ColorPickerButton = /* @__PURE__ */ _export_sfc(_sfc_main$1y, [["__scopeId", "data-v-4c87eac5"]]);
const _hoisted_1$1z = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$y(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1z, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "m15 15l6 6m-6-6v4.8m0-4.8h4.8M9 19.8V15m0 0H4.2M9 15l-6 6M15 4.2V9m0 0h4.8M15 9l6-6M9 4.2V9m0 0H4.2M9 9L3 3"
    }, null, -1)
  ]));
}
__name(render$y, "render$y");
const __unplugin_components_1$6 = markRaw({ name: "lucide-shrink", render: render$y });
const _hoisted_1$1y = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$x(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1y, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "m15 15l6 6M15 9l6-6m0 13v5h-5m5-13V3h-5M3 16v5h5m-5 0l6-6M3 8V3h5m1 6L3 3"
    }, null, -1)
  ]));
}
__name(render$x, "render$x");
const __unplugin_components_0$e = markRaw({ name: "lucide-expand", render: render$x });
const isOutputNode = /* @__PURE__ */ __name((node) => node.constructor.nodeData?.output_node, "isOutputNode");
const filterOutputNodes = /* @__PURE__ */ __name((nodes) => nodes.filter(isOutputNode), "filterOutputNodes");
function useSelectionState() {
  const canvasStore = useCanvasStore();
  const nodeDefStore = useNodeDefStore();
  const sidebarTabStore = useSidebarTabStore();
  const nodeHelpStore = useNodeHelpStore();
  const { id: nodeLibraryTabId } = useNodeLibrarySidebarTab();
  const { selectedItems } = storeToRefs(canvasStore);
  const selectedNodes = computed(() => {
    return selectedItems.value.filter(
      (i) => isLGraphNode(i)
    );
  });
  const nodeDef = computed(() => {
    if (selectedNodes.value.length !== 1) return null;
    return nodeDefStore.fromLGraphNode(selectedNodes.value[0]);
  });
  const hasAnySelection = computed(() => selectedItems.value.length > 0);
  const hasSingleSelection = computed(() => selectedItems.value.length === 1);
  const hasMultipleSelection = computed(() => selectedItems.value.length > 1);
  const isSingleNode = computed(
    () => hasSingleSelection.value && isLGraphNode(selectedItems.value[0])
  );
  const isSingleSubgraph = computed(
    () => isSingleNode.value && selectedItems.value[0]?.isSubgraphNode?.()
  );
  const isSingleImageNode = computed(
    () => isSingleNode.value && isImageNode(selectedItems.value[0])
  );
  const hasSubgraphs = computed(
    () => selectedItems.value.some((i) => i instanceof SubgraphNode)
  );
  const hasAny3DNodeSelected = computed(() => {
    const enable3DViewer = useSettingStore().get("Comfy.Load3D.3DViewerEnable");
    return selectedNodes.value.length === 1 && selectedNodes.value.some(isLoad3dNode) && enable3DViewer;
  });
  const hasImageNode = computed(() => isSingleImageNode.value);
  const hasOutputNodesSelected = computed(
    () => filterOutputNodes(selectedNodes.value).length > 0
  );
  const computeSelectionStatesFromNodes = /* @__PURE__ */ __name((nodes) => {
    if (!nodes.length)
      return { collapsed: false, pinned: false, bypassed: false };
    return {
      collapsed: nodes.some((n) => n.flags?.collapsed),
      pinned: nodes.some((n) => n.pinned),
      bypassed: nodes.some((n) => n.mode === LGraphEventMode.BYPASS)
    };
  }, "computeSelectionStatesFromNodes");
  const selectedNodesStates = computed(
    () => computeSelectionStatesFromNodes(selectedNodes.value)
  );
  const computeSelectionFlags = /* @__PURE__ */ __name(() => computeSelectionStatesFromNodes(selectedNodes.value), "computeSelectionFlags");
  const showNodeHelp = /* @__PURE__ */ __name(() => {
    const def = nodeDef.value;
    if (!def) return;
    const isSidebarActive = sidebarTabStore.activeSidebarTabId === nodeLibraryTabId;
    const currentHelpNode = nodeHelpStore.currentHelpNode;
    const isSameNodeHelpOpen = isSidebarActive && nodeHelpStore.isHelpOpen && currentHelpNode && currentHelpNode.nodePath === def.nodePath;
    if (isSameNodeHelpOpen) {
      nodeHelpStore.closeHelp();
      sidebarTabStore.toggleSidebarTab(nodeLibraryTabId);
      return;
    }
    if (!isSidebarActive) sidebarTabStore.toggleSidebarTab(nodeLibraryTabId);
    nodeHelpStore.openHelp(def);
  }, "showNodeHelp");
  return {
    selectedItems,
    selectedNodes,
    nodeDef,
    showNodeHelp,
    hasAny3DNodeSelected,
    hasAnySelection,
    hasSingleSelection,
    hasMultipleSelection,
    isSingleNode,
    isSingleSubgraph,
    isSingleImageNode,
    hasSubgraphs,
    hasImageNode,
    hasOutputNodesSelected,
    selectedNodesStates,
    computeSelectionFlags
  };
}
__name(useSelectionState, "useSelectionState");
const _sfc_main$1x = /* @__PURE__ */ defineComponent({
  __name: "ConvertToSubgraphButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const { isSingleSubgraph, hasAnySelection } = useSelectionState();
    const isUnpackVisible = isSingleSubgraph;
    const isConvertVisible = computed(
      () => hasAnySelection.value && !isSingleSubgraph.value
    );
    return (_ctx, _cache) => {
      const _component_i_lucide58expand = __unplugin_components_0$e;
      const _component_i_lucide58shrink = __unplugin_components_1$6;
      const _directive_tooltip = resolveDirective("tooltip");
      return unref(isUnpackVisible) ? withDirectives((openBlock(), createBlock(unref(Button), {
        key: 0,
        severity: "secondary",
        "data-testid": "convert-to-subgraph-button",
        text: "",
        onClick: _cache[0] || (_cache[0] = () => unref(commandStore).execute("Comfy.Graph.UnpackSubgraph"))
      }, {
        icon: withCtx(() => [
          createVNode(_component_i_lucide58expand, { class: "w-4 h-4" })
        ]),
        _: 1
      })), [
        [
          _directive_tooltip,
          {
            value: unref(t2)("commands.Comfy_Graph_UnpackSubgraph.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]) : isConvertVisible.value ? withDirectives((openBlock(), createBlock(unref(Button), {
        key: 1,
        severity: "secondary",
        "data-testid": "convert-to-subgraph-button",
        text: "",
        onClick: _cache[1] || (_cache[1] = () => unref(commandStore).execute("Comfy.Graph.ConvertToSubgraph"))
      }, {
        icon: withCtx(() => [
          createVNode(_component_i_lucide58shrink)
        ]),
        _: 1
      })), [
        [
          _directive_tooltip,
          {
            value: unref(t2)("commands.Comfy_Graph_ConvertToSubgraph.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]) : createCommentVNode("", true);
    };
  }
});
const _sfc_main$1w = /* @__PURE__ */ defineComponent({
  __name: "DeleteButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const { selectedItems } = useSelectionState();
    const isDeletable = computed(
      () => selectedItems.value.some((x) => x.removable !== false)
    );
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        "icon-class": "w-4 h-4",
        icon: "pi pi-trash",
        "data-testid": "delete-button",
        onClick: _cache[0] || (_cache[0] = () => unref(commandStore).execute("Comfy.Canvas.DeleteSelectedItems"))
      }, null, 512)), [
        [vShow, isDeletable.value],
        [
          _directive_tooltip,
          {
            value: unref(t2)("commands.Comfy_Canvas_DeleteSelectedItems.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1x = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$w(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1x, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M5 5a2 2 0 0 1 3.008-1.728l11.997 6.998a2 2 0 0 1 .003 3.458l-12 7A2 2 0 0 1 5 19z"
    }, null, -1)
  ]));
}
__name(render$w, "render$w");
const __unplugin_components_1$5 = markRaw({ name: "lucide-play", render: render$w });
const _sfc_main$1v = /* @__PURE__ */ defineComponent({
  __name: "ExecuteButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const canvasStore = useCanvasStore();
    const { selectedNodes } = useSelectionState();
    const canvas = canvasStore.getCanvas();
    const buttonHovered = ref(false);
    const selectedOutputNodes = computed(
      () => selectedNodes.value.filter(isLGraphNode).filter(isOutputNode)
    );
    function outputNodeStokeStyle() {
      if (this.selected && this.constructor.nodeData?.output_node && buttonHovered.value) {
        return { color: "orange", lineWidth: 2, padding: 10 };
      }
    }
    __name(outputNodeStokeStyle, "outputNodeStokeStyle");
    const handleMouseEnter = /* @__PURE__ */ __name(() => {
      buttonHovered.value = true;
      for (const node of selectedOutputNodes.value) {
        node.strokeStyles["outputNode"] = outputNodeStokeStyle;
      }
      canvas.setDirty(true);
    }, "handleMouseEnter");
    const handleMouseLeave = /* @__PURE__ */ __name(() => {
      buttonHovered.value = false;
      canvas.setDirty(true);
    }, "handleMouseLeave");
    const handleClick = /* @__PURE__ */ __name(async () => {
      await commandStore.execute("Comfy.QueueSelectedOutputNodes");
    }, "handleClick");
    return (_ctx, _cache) => {
      const _component_i_lucide58play = __unplugin_components_1$5;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        class: "dark-theme:bg-[#0B8CE9] bg-[#31B9F4] size-8 !p-0",
        text: "",
        onMouseenter: _cache[0] || (_cache[0] = () => handleMouseEnter()),
        onMouseleave: _cache[1] || (_cache[1] = () => handleMouseLeave()),
        onClick: handleClick
      }, {
        default: withCtx(() => [
          createVNode(_component_i_lucide58play, { class: "fill-path-white w-4 h-4" })
        ]),
        _: 1
      })), [
        [
          _directive_tooltip,
          {
            value: unref(t2)("selectionToolbox.executeButton.tooltip"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const ExecuteButton = /* @__PURE__ */ _export_sfc(_sfc_main$1v, [["__scopeId", "data-v-d6041921"]]);
const _sfc_main$1u = /* @__PURE__ */ defineComponent({
  __name: "ExtensionCommandButton",
  props: {
    command: {}
  },
  setup(__props) {
    const commandStore = useCommandStore();
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        "icon-class": "w-4 h-4",
        icon: typeof _ctx.command.icon === "function" ? _ctx.command.icon() : _ctx.command.icon,
        onClick: _cache[0] || (_cache[0] = () => unref(commandStore).execute(_ctx.command.id))
      }, null, 8, ["icon"])), [
        [
          _directive_tooltip,
          {
            value: unref(st)(`commands.${unref(normalizeI18nKey)(_ctx.command.id)}.label`, "") || void 0,
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1w = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$v(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1w, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("circle", {
        cx: "12",
        cy: "12",
        r: "10"
      }),
      createElementVNode("path", { d: "M12 16v-4m0-4h.01" })
    ], -1)
  ]));
}
__name(render$v, "render$v");
const __unplugin_components_5 = markRaw({ name: "lucide-info", render: render$v });
const _sfc_main$1t = /* @__PURE__ */ defineComponent({
  __name: "InfoButton",
  setup(__props) {
    const { showNodeHelp: toggleHelp } = useSelectionState();
    return (_ctx, _cache) => {
      const _component_i_lucide58info = __unplugin_components_5;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        "data-testid": "info-button",
        text: "",
        severity: "secondary",
        onClick: unref(toggleHelp)
      }, {
        default: withCtx(() => [
          createVNode(_component_i_lucide58info, { class: "w-4 h-4" })
        ]),
        _: 1
      }, 8, ["onClick"])), [
        [
          _directive_tooltip,
          {
            value: _ctx.$t("g.info"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _sfc_main$1s = /* @__PURE__ */ defineComponent({
  __name: "Load3DViewerButton",
  setup(__props) {
    const commandStore = useCommandStore();
    const open3DViewer = /* @__PURE__ */ __name(() => {
      void commandStore.execute("Comfy.3DViewer.Open3DViewer");
    }, "open3DViewer");
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        icon: "pi pi-pencil",
        "icon-class": "w-4 h-4",
        onClick: open3DViewer
      }, null, 512)), [
        [
          _directive_tooltip,
          {
            value: unref(t)("commands.Comfy_3DViewer_Open3DViewer.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1v = {
  width: "1.2em",
  height: "1.2em",
  xmlns: "http://www.w3.org/2000/svg",
  class: "",
  viewBox: "0 0 16 16",
  fill: "none"
};
const _hoisted_2$J = ["clip-path"];
const _hoisted_3$r = ["id"];
function render$u(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1v, [
    createElementVNode("g", {
      "clip-path": "url(#" + _ctx.idMap["clip0_704_2695"] + ")"
    }, _cache[0] || (_cache[0] = [
      createStaticVNode('<path d="M6.05048 2C5.52055 7.29512 9.23033 10.4722 14 9.94267" stroke="#9C9EAB" stroke-width="1.3"></path><path d="M6.5 5.5L10 2" stroke="#9C9EAB" stroke-width="1.3" stroke-linecap="round"></path><path d="M8 8L12.5 3.5" stroke="#9C9EAB" stroke-width="1.3" stroke-linecap="square"></path><path d="M10.5 9.5L14 6" stroke="#9C9EAB" stroke-width="1.3" stroke-linecap="round"></path><path d="M7.99992 14.6667C11.6818 14.6667 14.6666 11.6819 14.6666 8.00004C14.6666 4.31814 11.6818 1.33337 7.99992 1.33337C4.31802 1.33337 1.33325 4.31814 1.33325 8.00004C1.33325 11.6819 4.31802 14.6667 7.99992 14.6667Z" stroke="#9C9EAB" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"></path>', 5)
    ]), 8, _hoisted_2$J),
    createElementVNode("defs", null, [
      createElementVNode("clipPath", {
        id: _ctx.idMap["clip0_704_2695"]
      }, _cache[1] || (_cache[1] = [
        createElementVNode("rect", {
          width: "16",
          height: "16",
          fill: "white"
        }, null, -1)
      ]), 8, _hoisted_3$r)
    ])
  ]);
}
__name(render$u, "render$u");
const __unplugin_components_0$d = markRaw({ name: "comfy-mask", render: render$u, setup() {
  const __randId = /* @__PURE__ */ __name(() => Math.random().toString(36).substr(2, 10), "__randId");
  const idMap = { "clip0_704_2695": "uicons-" + __randId() };
  ;
  return { idMap };
} });
const _sfc_main$1r = /* @__PURE__ */ defineComponent({
  __name: "MaskEditorButton",
  setup(__props) {
    const commandStore = useCommandStore();
    const { isSingleImageNode } = useSelectionState();
    const openMaskEditor = /* @__PURE__ */ __name(() => {
      void commandStore.execute("Comfy.MaskEditor.OpenMaskEditor");
    }, "openMaskEditor");
    return (_ctx, _cache) => {
      const _component_i_comfy58mask = __unplugin_components_0$d;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        onClick: openMaskEditor
      }, {
        default: withCtx(() => [
          createVNode(_component_i_comfy58mask, { class: "!w-4 !h-4" })
        ]),
        _: 1
      })), [
        [vShow, unref(isSingleImageNode)],
        [
          _directive_tooltip,
          {
            value: unref(t)("commands.Comfy_MaskEditor_OpenMaskEditor.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1u = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$t(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1u, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M3 12a9 9 0 0 1 9-9a9.75 9.75 0 0 1 6.74 2.74L21 8" }),
      createElementVNode("path", { d: "M21 3v5h-5m5 4a9 9 0 0 1-9 9a9.75 9.75 0 0 1-6.74-2.74L3 16" }),
      createElementVNode("path", { d: "M8 16H3v5" })
    ], -1)
  ]));
}
__name(render$t, "render$t");
const __unplugin_components_0$c = markRaw({ name: "lucide-refresh-cw", render: render$t });
const isRefreshableWidget = /* @__PURE__ */ __name((widget) => widget != null && typeof widget === "object" && "refresh" in widget && typeof widget.refresh === "function", "isRefreshableWidget");
const useRefreshableSelection = /* @__PURE__ */ __name(() => {
  const graphStore = useCanvasStore();
  const selectedNodes = ref([]);
  watchEffect(() => {
    selectedNodes.value = graphStore.selectedItems.filter(isLGraphNode);
  });
  const refreshableWidgets = computed(
    () => selectedNodes.value.flatMap((node) => {
      if (!node.widgets) return [];
      const items = [];
      for (const widget of node.widgets) {
        if (isRefreshableWidget(widget)) {
          items.push(widget);
        }
      }
      return items;
    })
  );
  const isRefreshable = computed(() => refreshableWidgets.value.length > 0);
  async function refreshSelected() {
    if (!isRefreshable.value) return;
    await Promise.all(refreshableWidgets.value.map((item) => item.refresh()));
  }
  __name(refreshSelected, "refreshSelected");
  return {
    isRefreshable,
    refreshSelected
  };
}, "useRefreshableSelection");
const _sfc_main$1q = /* @__PURE__ */ defineComponent({
  __name: "RefreshSelectionButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const { isRefreshable, refreshSelected } = useRefreshableSelection();
    return (_ctx, _cache) => {
      const _component_i_lucide58refresh_cw = __unplugin_components_0$c;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        "data-testid": "refresh-button",
        onClick: unref(refreshSelected)
      }, {
        default: withCtx(() => [
          createVNode(_component_i_lucide58refresh_cw, { class: "w-4 h-4" })
        ]),
        _: 1
      }, 8, ["onClick"])), [
        [vShow, unref(isRefreshable)],
        [
          _directive_tooltip,
          unref(t2)("g.refreshNode"),
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1t = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$s(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1t, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M12 7v14m-9-3a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h5a4 4 0 0 1 4 4a4 4 0 0 1 4-4h5a1 1 0 0 1 1 1v13a1 1 0 0 1-1 1h-6a3 3 0 0 0-3 3a3 3 0 0 0-3-3z"
    }, null, -1)
  ]));
}
__name(render$s, "render$s");
const __unplugin_components_0$b = markRaw({ name: "lucide-book-open", render: render$s });
const _sfc_main$1p = /* @__PURE__ */ defineComponent({
  __name: "SaveToSubgraphLibrary",
  setup(__props) {
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const canvasStore = useCanvasStore();
    const isVisible = computed(() => {
      return canvasStore.selectedItems?.length === 1 && canvasStore.selectedItems[0] instanceof SubgraphNode;
    });
    return (_ctx, _cache) => {
      const _component_i_lucide58book_open = __unplugin_components_0$b;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        severity: "secondary",
        text: "",
        onClick: _cache[0] || (_cache[0] = () => unref(commandStore).execute("Comfy.PublishSubgraph"))
      }, {
        icon: withCtx(() => [
          createVNode(_component_i_lucide58book_open)
        ]),
        _: 1
      })), [
        [vShow, isVisible.value],
        [
          _directive_tooltip,
          {
            value: unref(t2)("commands.Comfy_PublishSubgraph.label"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const useVueFeatureFlags = /* @__PURE__ */ __name(() => {
  const settingStore = useSettingStore();
  const isVueNodesEnabled = computed(() => {
    try {
      return settingStore.get("Comfy.VueNodes.Enabled") ?? false;
    } catch {
      return false;
    }
  });
  const shouldRenderVueNodes = computed(() => isVueNodesEnabled.value);
  const syncVueNodesFlag = /* @__PURE__ */ __name(() => {
    LiteGraph.vueNodesMode = isVueNodesEnabled.value;
  }, "syncVueNodesFlag");
  watch(isVueNodesEnabled, syncVueNodesFlag, { immediate: true });
  return {
    isVueNodesEnabled,
    shouldRenderVueNodes,
    syncVueNodesFlag
  };
}, "useVueFeatureFlags");
const moreOptionsOpen = ref(false);
const forceCloseMoreOptionsSignal = ref(0);
const restoreMoreOptionsSignal = ref(0);
const moreOptionsRestorePending = ref(false);
let moreOptionsWasOpenBeforeDrag = false;
let moreOptionsSelectionSignature = null;
function buildSelectionSignature(store) {
  const c2 = store.canvas;
  if (!c2) return null;
  const items = Array.from(c2.selectedItems);
  if (items.length !== 1) return null;
  const item = items[0];
  if (isLGraphNode(item)) return `N:${item.id}`;
  if (isLGraphGroup(item)) return `G:${item.id}`;
  return null;
}
__name(buildSelectionSignature, "buildSelectionSignature");
function currentSelectionMatchesSignature(store) {
  if (!moreOptionsSelectionSignature) return false;
  return buildSelectionSignature(store) === moreOptionsSelectionSignature;
}
__name(currentSelectionMatchesSignature, "currentSelectionMatchesSignature");
function useSelectionToolboxPosition(toolboxRef) {
  const canvasStore = useCanvasStore();
  const lgCanvas = canvasStore.getCanvas();
  const { getSelectableItems } = useSelectedLiteGraphItems();
  const { shouldRenderVueNodes } = useVueFeatureFlags();
  const worldPosition = ref({ x: 0, y: 0 });
  const visible = ref(false);
  const updateSelectionBounds = /* @__PURE__ */ __name(() => {
    const selectableItems = getSelectableItems();
    if (!selectableItems.size) {
      visible.value = false;
      return;
    }
    visible.value = true;
    const allBounds = [];
    for (const item of selectableItems) {
      if (item.id == null) continue;
      if (shouldRenderVueNodes.value && typeof item.id === "string") {
        const layout = layoutStore.getNodeLayoutRef(item.id).value;
        if (layout) {
          allBounds.push([
            layout.bounds.x,
            layout.bounds.y,
            layout.bounds.width,
            layout.bounds.height
          ]);
        }
      } else {
        if (item instanceof LGraphNode) {
          const bounds = item.getBounding();
          allBounds.push([bounds[0], bounds[1], bounds[2], bounds[3]]);
        }
      }
    }
    const unionBounds = computeUnionBounds(allBounds);
    if (!unionBounds) return;
    worldPosition.value = {
      x: unionBounds.x + unionBounds.width / 2,
      // createBounds() applied a default padding of 10px
      // so adjust Y to maintain visual consistency
      y: unionBounds.y - 10
    };
    updateTransform();
  }, "updateSelectionBounds");
  const updateTransform = /* @__PURE__ */ __name(() => {
    if (!visible.value) return;
    const { scale, offset: offset2 } = lgCanvas.ds;
    const canvasRect = lgCanvas.canvas.getBoundingClientRect();
    const screenX = (worldPosition.value.x + offset2[0]) * scale + canvasRect.left;
    const screenY = (worldPosition.value.y + offset2[1]) * scale + canvasRect.top;
    if (toolboxRef.value) {
      toolboxRef.value.style.setProperty("--tb-x", `${screenX}px`);
      toolboxRef.value.style.setProperty("--tb-y", `${screenY}px`);
    }
  }, "updateTransform");
  const { startSync, stopSync } = useCanvasTransformSync$1(updateTransform, {
    autoStart: false
  });
  watch(
    () => canvasStore.getCanvas().state.selectionChanged,
    (changed) => {
      if (changed) {
        if (moreOptionsRestorePending.value || moreOptionsSelectionSignature) {
          moreOptionsRestorePending.value = false;
          moreOptionsWasOpenBeforeDrag = false;
          if (!moreOptionsOpen.value) {
            moreOptionsSelectionSignature = null;
          } else {
            moreOptionsSelectionSignature = buildSelectionSignature(canvasStore);
          }
        }
        updateSelectionBounds();
        canvasStore.getCanvas().state.selectionChanged = false;
        if (visible.value) {
          startSync();
        } else {
          stopSync();
        }
      }
    },
    { immediate: true }
  );
  watch(
    () => moreOptionsOpen.value,
    (v) => {
      if (v) {
        moreOptionsSelectionSignature = buildSelectionSignature(canvasStore);
      } else if (!canvasStore.canvas?.state?.draggingItems) {
        moreOptionsSelectionSignature = null;
        if (moreOptionsRestorePending.value)
          moreOptionsRestorePending.value = false;
      }
    }
  );
  const handleDragStateChange = /* @__PURE__ */ __name((dragging) => {
    if (dragging) {
      handleDragStart();
      return;
    }
    handleDragEnd();
  }, "handleDragStateChange");
  const handleDragStart = /* @__PURE__ */ __name(() => {
    visible.value = false;
    if (!moreOptionsOpen.value) {
      moreOptionsRestorePending.value = false;
      moreOptionsWasOpenBeforeDrag = false;
      return;
    }
    const currentSig = buildSelectionSignature(canvasStore);
    const selectionChanged = currentSig !== moreOptionsSelectionSignature;
    if (selectionChanged) {
      moreOptionsSelectionSignature = null;
    }
    moreOptionsOpen.value = false;
    moreOptionsWasOpenBeforeDrag = true;
    moreOptionsRestorePending.value = !!moreOptionsSelectionSignature;
    if (moreOptionsRestorePending.value) {
      forceCloseMoreOptionsSignal.value++;
      return;
    }
    moreOptionsWasOpenBeforeDrag = false;
  }, "handleDragStart");
  const handleDragEnd = /* @__PURE__ */ __name(() => {
    requestAnimationFrame(() => {
      updateSelectionBounds();
      const selectionMatches = currentSelectionMatchesSignature(canvasStore);
      const shouldRestore = moreOptionsWasOpenBeforeDrag && visible.value && moreOptionsRestorePending.value && selectionMatches;
      moreOptionsRestorePending.value = shouldRestore && moreOptionsRestorePending.value;
      moreOptionsWasOpenBeforeDrag = false;
      if (shouldRestore) {
        restoreMoreOptionsSignal.value++;
      }
    });
  }, "handleDragEnd");
  const isDragging = computed(() => {
    const litegraphDragging = canvasStore.canvas?.state?.draggingItems ?? false;
    const vueNodeDragging = shouldRenderVueNodes.value && layoutStore.isDraggingVueNodes.value;
    return litegraphDragging || vueNodeDragging;
  });
  watch(isDragging, handleDragStateChange);
  onUnmounted(() => {
    resetMoreOptionsState();
  });
  return {
    visible
  };
}
__name(useSelectionToolboxPosition, "useSelectionToolboxPosition");
function resetMoreOptionsState() {
  moreOptionsOpen.value = false;
  moreOptionsRestorePending.value = false;
  moreOptionsWasOpenBeforeDrag = false;
  moreOptionsSelectionSignature = null;
}
__name(resetMoreOptionsState, "resetMoreOptionsState");
const _hoisted_1$1s = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$r(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1s, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M22 6H2m20 12H2M6 2v20M18 2v20"
    }, null, -1)
  ]));
}
__name(render$r, "render$r");
const __unplugin_components_2$3 = markRaw({ name: "lucide-frame", render: render$r });
function useFrameNodes() {
  const settingStore = useSettingStore();
  const titleEditorStore = useTitleEditorStore();
  const { hasMultipleSelection } = useSelectionState();
  const canFrame = computed(() => hasMultipleSelection.value);
  const frameNodes = /* @__PURE__ */ __name(() => {
    const { canvas } = app;
    if (!canvas.selectedItems?.size) return;
    const group = new LGraphGroup();
    const padding = settingStore.get("Comfy.GroupSelectedNodes.Padding");
    group.resizeTo(canvas.selectedItems, padding);
    canvas.graph?.add(group);
    titleEditorStore.titleEditorTarget = group;
  }, "frameNodes");
  return { frameNodes, canFrame };
}
__name(useFrameNodes, "useFrameNodes");
const _sfc_main$1o = /* @__PURE__ */ defineComponent({
  __name: "FrameNodes",
  setup(__props) {
    const { frameNodes } = useFrameNodes();
    return (_ctx, _cache) => {
      const _component_i_lucide58frame = __unplugin_components_2$3;
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        class: "frame-nodes-button",
        text: "",
        severity: "secondary",
        onClick: unref(frameNodes)
      }, {
        default: withCtx(() => [
          createVNode(_component_i_lucide58frame, { class: "w-4 h-4" })
        ]),
        _: 1
      }, 8, ["onClick"])), [
        [
          _directive_tooltip,
          {
            value: _ctx.$t("g.frameNodes"),
            showDelay: 1e3
          },
          void 0,
          { top: true }
        ]
      ]);
    };
  }
});
const _hoisted_1$1r = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$q(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1r, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("circle", {
        cx: "12",
        cy: "12",
        r: "1"
      }),
      createElementVNode("circle", {
        cx: "12",
        cy: "5",
        r: "1"
      }),
      createElementVNode("circle", {
        cx: "12",
        cy: "19",
        r: "1"
      })
    ], -1)
  ]));
}
__name(render$q, "render$q");
const __unplugin_components_0$a = markRaw({ name: "lucide-more-vertical", render: render$q });
function useCanvasRefresh() {
  const canvasStore = useCanvasStore();
  const workflowStore = useWorkflowStore();
  const refreshCanvas = /* @__PURE__ */ __name(() => {
    canvasStore.canvas?.emitBeforeChange();
    canvasStore.canvas?.setDirty(true, true);
    canvasStore.canvas?.graph?.afterChange();
    canvasStore.canvas?.emitAfterChange();
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "refreshCanvas");
  return {
    refreshCanvas
  };
}
__name(useCanvasRefresh, "useCanvasRefresh");
function useNodeCustomization() {
  const { t: t2 } = useI18n();
  const canvasStore = useCanvasStore();
  const colorPaletteStore = useColorPaletteStore();
  const canvasRefresh = useCanvasRefresh();
  const isLightTheme = computed(
    () => colorPaletteStore.completedActivePalette.light_theme
  );
  const toLightThemeColor = /* @__PURE__ */ __name((color) => adjustColor(color, { lightness: 0.5 }), "toLightThemeColor");
  const NO_COLOR_OPTION = {
    name: "noColor",
    localizedName: t2("color.noColor"),
    value: {
      dark: LiteGraph.NODE_DEFAULT_BGCOLOR,
      light: toLightThemeColor(LiteGraph.NODE_DEFAULT_BGCOLOR)
    }
  };
  const colorOptions = [
    NO_COLOR_OPTION,
    ...Object.entries(LGraphCanvas.node_colors).map(([name, color]) => ({
      name,
      localizedName: t2(`color.${name}`),
      value: {
        dark: color.bgcolor,
        light: toLightThemeColor(color.bgcolor)
      }
    }))
  ];
  const shapeOptions = [
    {
      name: "default",
      localizedName: t2("shape.default"),
      value: RenderShape.ROUND
    },
    {
      name: "box",
      localizedName: t2("shape.box"),
      value: RenderShape.BOX
    },
    {
      name: "card",
      localizedName: t2("shape.CARD"),
      value: RenderShape.CARD
    }
  ];
  const applyColor = /* @__PURE__ */ __name((colorOption) => {
    const colorName = colorOption?.name ?? NO_COLOR_OPTION.name;
    const canvasColorOption = colorName === NO_COLOR_OPTION.name ? null : LGraphCanvas.node_colors[colorName];
    for (const item of canvasStore.selectedItems) {
      if (isColorable(item)) {
        item.setColorOption(canvasColorOption);
      }
    }
    canvasRefresh.refreshCanvas();
  }, "applyColor");
  const applyShape = /* @__PURE__ */ __name((shapeOption) => {
    const selectedNodes = Array.from(canvasStore.selectedItems).filter(
      (item) => item instanceof LGraphNode
    );
    if (selectedNodes.length === 0) {
      return;
    }
    selectedNodes.forEach((node) => {
      node.shape = shapeOption.value;
    });
    canvasRefresh.refreshCanvas();
  }, "applyShape");
  const getCurrentColor = /* @__PURE__ */ __name(() => {
    const selectedItems = Array.from(canvasStore.selectedItems);
    if (selectedItems.length === 0) return null;
    const firstColorableItem = selectedItems.find((item) => isColorable(item));
    if (!firstColorableItem || !isColorable(firstColorableItem)) return null;
    const currentColorOption = firstColorableItem.getColorOption();
    const currentBgColor = currentColorOption?.bgcolor ?? null;
    return colorOptions.find(
      (option) => option.value.dark === currentBgColor || option.value.light === currentBgColor
    ) ?? NO_COLOR_OPTION;
  }, "getCurrentColor");
  const getCurrentShape = /* @__PURE__ */ __name(() => {
    const selectedNodes = Array.from(canvasStore.selectedItems).filter(
      (item) => item instanceof LGraphNode
    );
    if (selectedNodes.length === 0) return null;
    const firstNode = selectedNodes[0];
    const currentShape = firstNode.shape ?? RenderShape.ROUND;
    return shapeOptions.find((option) => option.value === currentShape) ?? shapeOptions[0];
  }, "getCurrentShape");
  return {
    colorOptions,
    shapeOptions,
    applyColor,
    applyShape,
    getCurrentColor,
    getCurrentShape,
    isLightTheme
  };
}
__name(useNodeCustomization, "useNodeCustomization");
function useGroupMenuOptions() {
  const { t: t2 } = useI18n();
  const canvasStore = useCanvasStore();
  const workflowStore = useWorkflowStore();
  const settingStore = useSettingStore();
  const canvasRefresh = useCanvasRefresh();
  const { shapeOptions, colorOptions, isLightTheme } = useNodeCustomization();
  const getFitGroupToNodesOption = /* @__PURE__ */ __name((groupContext) => ({
    label: "Fit Group To Nodes",
    icon: "icon-[lucide--move-diagonal-2]",
    action: /* @__PURE__ */ __name(() => {
      try {
        groupContext.recomputeInsideNodes();
      } catch (e) {
        console.warn("Failed to recompute group nodes:", e);
        return;
      }
      const padding = settingStore.get("Comfy.GroupSelectedNodes.Padding");
      groupContext.resizeTo(groupContext.children, padding);
      groupContext.graph?.change();
      canvasStore.canvas?.setDirty(true, true);
      workflowStore.activeWorkflow?.changeTracker?.checkState();
    }, "action")
  }), "getFitGroupToNodesOption");
  const getGroupShapeOptions = /* @__PURE__ */ __name((groupContext, bump) => ({
    label: t2("contextMenu.Shape"),
    icon: "icon-[lucide--box]",
    hasSubmenu: true,
    submenu: shapeOptions.map((shape) => ({
      label: shape.localizedName,
      action: /* @__PURE__ */ __name(() => {
        const nodes = groupContext.nodes || [];
        nodes.forEach((node) => node.shape = shape.value);
        canvasRefresh.refreshCanvas();
        bump();
      }, "action")
    }))
  }), "getGroupShapeOptions");
  const getGroupColorOptions = /* @__PURE__ */ __name((groupContext, bump) => ({
    label: t2("contextMenu.Color"),
    icon: "icon-[lucide--palette]",
    hasSubmenu: true,
    submenu: colorOptions.map((colorOption) => ({
      label: colorOption.localizedName,
      color: isLightTheme.value ? colorOption.value.light : colorOption.value.dark,
      action: /* @__PURE__ */ __name(() => {
        groupContext.color = isLightTheme.value ? colorOption.value.light : colorOption.value.dark;
        canvasRefresh.refreshCanvas();
        bump();
      }, "action")
    }))
  }), "getGroupColorOptions");
  const getGroupModeOptions = /* @__PURE__ */ __name((groupContext, bump) => {
    const options = [];
    try {
      groupContext.recomputeInsideNodes();
    } catch (e) {
      console.warn("Failed to recompute group nodes for mode options:", e);
      return options;
    }
    const groupNodes = groupContext.nodes || [];
    if (!groupNodes.length) return options;
    let allSame = true;
    for (let i = 1; i < groupNodes.length; i++) {
      if (groupNodes[i].mode !== groupNodes[0].mode) {
        allSame = false;
        break;
      }
    }
    const createModeAction = /* @__PURE__ */ __name((label, mode) => ({
      label: t2(`selectionToolbox.${label}`),
      icon: mode === LGraphEventMode.BYPASS ? "icon-[lucide--ban]" : mode === LGraphEventMode.NEVER ? "icon-[lucide--zap-off]" : "icon-[lucide--play]",
      action: /* @__PURE__ */ __name(() => {
        groupNodes.forEach((n) => {
          n.mode = mode;
        });
        canvasStore.canvas?.setDirty(true, true);
        groupContext.graph?.change();
        workflowStore.activeWorkflow?.changeTracker?.checkState();
        bump();
      }, "action")
    }), "createModeAction");
    if (allSame) {
      const current = groupNodes[0].mode;
      switch (current) {
        case LGraphEventMode.ALWAYS:
          options.push(
            createModeAction("Set Group Nodes to Never", LGraphEventMode.NEVER)
          );
          options.push(
            createModeAction("Bypass Group Nodes", LGraphEventMode.BYPASS)
          );
          break;
        case LGraphEventMode.NEVER:
          options.push(
            createModeAction(
              "Set Group Nodes to Always",
              LGraphEventMode.ALWAYS
            )
          );
          options.push(
            createModeAction("Bypass Group Nodes", LGraphEventMode.BYPASS)
          );
          break;
        case LGraphEventMode.BYPASS:
          options.push(
            createModeAction(
              "Set Group Nodes to Always",
              LGraphEventMode.ALWAYS
            )
          );
          options.push(
            createModeAction("Set Group Nodes to Never", LGraphEventMode.NEVER)
          );
          break;
        default:
          options.push(
            createModeAction(
              "Set Group Nodes to Always",
              LGraphEventMode.ALWAYS
            )
          );
          options.push(
            createModeAction("Set Group Nodes to Never", LGraphEventMode.NEVER)
          );
          options.push(
            createModeAction("Bypass Group Nodes", LGraphEventMode.BYPASS)
          );
          break;
      }
    } else {
      options.push(
        createModeAction("Set Group Nodes to Always", LGraphEventMode.ALWAYS)
      );
      options.push(
        createModeAction("Set Group Nodes to Never", LGraphEventMode.NEVER)
      );
      options.push(
        createModeAction("Bypass Group Nodes", LGraphEventMode.BYPASS)
      );
    }
    return options;
  }, "getGroupModeOptions");
  return {
    getFitGroupToNodesOption,
    getGroupShapeOptions,
    getGroupColorOptions,
    getGroupModeOptions
  };
}
__name(useGroupMenuOptions, "useGroupMenuOptions");
const DEFAULT_DOWNLOAD_FILENAME = "download.png";
const downloadFile = /* @__PURE__ */ __name((url, filename) => {
  if (!url || typeof url !== "string" || url.trim().length === 0) {
    throw new Error("Invalid URL provided for download");
  }
  const link = document.createElement("a");
  link.href = url;
  link.download = filename || extractFilenameFromUrl(url) || DEFAULT_DOWNLOAD_FILENAME;
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}, "downloadFile");
const extractFilenameFromUrl = /* @__PURE__ */ __name((url) => {
  try {
    const urlObj = new URL(url, window.location.origin);
    return urlObj.searchParams.get("filename");
  } catch {
    return null;
  }
}, "extractFilenameFromUrl");
function useImageMenuOptions() {
  const { t: t2 } = useI18n();
  const openMaskEditor = /* @__PURE__ */ __name(() => {
    const commandStore = useCommandStore();
    void commandStore.execute("Comfy.MaskEditor.OpenMaskEditor");
  }, "openMaskEditor");
  const openImage = /* @__PURE__ */ __name((node) => {
    if (!node?.imgs?.length) return;
    const img = node.imgs[node.imageIndex ?? 0];
    if (!img) return;
    const url = new URL(img.src);
    url.searchParams.delete("preview");
    window.open(url.toString(), "_blank");
  }, "openImage");
  const copyImage = /* @__PURE__ */ __name(async (node) => {
    if (!node?.imgs?.length) return;
    const img = node.imgs[node.imageIndex ?? 0];
    if (!img) return;
    const canvas = document.createElement("canvas");
    const ctx = canvas.getContext("2d");
    if (!ctx) return;
    canvas.width = img.naturalWidth;
    canvas.height = img.naturalHeight;
    ctx.drawImage(img, 0, 0);
    try {
      const blob = await new Promise((resolve) => {
        canvas.toBlob(resolve, "image/png");
      });
      if (!blob) {
        console.warn("Failed to create image blob");
        return;
      }
      if (!navigator.clipboard?.write) {
        console.warn("Clipboard API not available");
        return;
      }
      await navigator.clipboard.write([
        new ClipboardItem({ "image/png": blob })
      ]);
    } catch (error) {
      console.error("Failed to copy image to clipboard:", error);
    }
  }, "copyImage");
  const saveImage = /* @__PURE__ */ __name((node) => {
    if (!node?.imgs?.length) return;
    const img = node.imgs[node.imageIndex ?? 0];
    if (!img) return;
    try {
      const url = new URL(img.src);
      url.searchParams.delete("preview");
      downloadFile(url.toString());
    } catch (error) {
      console.error("Failed to save image:", error);
    }
  }, "saveImage");
  const getImageMenuOptions = /* @__PURE__ */ __name((node) => {
    if (!node?.imgs?.length) return [];
    return [
      {
        label: t2("contextMenu.Open in Mask Editor"),
        action: /* @__PURE__ */ __name(() => openMaskEditor(), "action")
      },
      {
        label: t2("contextMenu.Open Image"),
        icon: "icon-[lucide--external-link]",
        action: /* @__PURE__ */ __name(() => openImage(node), "action")
      },
      {
        label: t2("contextMenu.Copy Image"),
        icon: "icon-[lucide--copy]",
        action: /* @__PURE__ */ __name(() => copyImage(node), "action")
      },
      {
        label: t2("contextMenu.Save Image"),
        icon: "icon-[lucide--download]",
        action: /* @__PURE__ */ __name(() => saveImage(node), "action")
      }
    ];
  }, "getImageMenuOptions");
  return {
    getImageMenuOptions
  };
}
__name(useImageMenuOptions, "useImageMenuOptions");
function useSelectedNodeActions() {
  const { getSelectedNodes, toggleSelectedNodesMode } = useSelectedLiteGraphItems();
  const commandStore = useCommandStore();
  const workflowStore = useWorkflowStore();
  const adjustNodeSize = /* @__PURE__ */ __name(() => {
    const selectedNodes = getSelectedNodes();
    selectedNodes.forEach((node) => {
      const optimalSize = node.computeSize();
      node.setSize([optimalSize[0], optimalSize[1]]);
    });
    app.canvas.setDirty(true, true);
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "adjustNodeSize");
  const toggleNodeCollapse = /* @__PURE__ */ __name(() => {
    const selectedNodes = getSelectedNodes();
    selectedNodes.forEach((node) => {
      node.collapse();
    });
    app.canvas.setDirty(true, true);
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "toggleNodeCollapse");
  const toggleNodePin = /* @__PURE__ */ __name(() => {
    const selectedNodes = getSelectedNodes();
    selectedNodes.forEach((node) => {
      node.pin(!node.pinned);
    });
    app.canvas.setDirty(true, true);
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "toggleNodePin");
  const toggleNodeBypass = /* @__PURE__ */ __name(() => {
    toggleSelectedNodesMode(LGraphEventMode.BYPASS);
    app.canvas.setDirty(true, true);
  }, "toggleNodeBypass");
  const runBranch = /* @__PURE__ */ __name(async () => {
    const selectedNodes = getSelectedNodes();
    const selectedOutputNodes = filterOutputNodes(selectedNodes);
    if (selectedOutputNodes.length === 0) return;
    await commandStore.execute("Comfy.QueueSelectedOutputNodes");
  }, "runBranch");
  return {
    adjustNodeSize,
    toggleNodeCollapse,
    toggleNodePin,
    toggleNodeBypass,
    runBranch
  };
}
__name(useSelectedNodeActions, "useSelectedNodeActions");
function useNodeMenuOptions() {
  const { t: t2 } = useI18n();
  const { shapeOptions, applyShape, applyColor, colorOptions, isLightTheme } = useNodeCustomization();
  const {
    adjustNodeSize,
    toggleNodeCollapse,
    toggleNodePin,
    toggleNodeBypass,
    runBranch
  } = useSelectedNodeActions();
  const shapeSubmenu = computed(
    () => shapeOptions.map((shape) => ({
      label: shape.localizedName,
      action: /* @__PURE__ */ __name(() => applyShape(shape), "action")
    }))
  );
  const colorSubmenu = computed(() => {
    return colorOptions.map((colorOption) => ({
      label: colorOption.localizedName,
      color: isLightTheme.value ? colorOption.value.light : colorOption.value.dark,
      action: /* @__PURE__ */ __name(() => applyColor(colorOption.name === "noColor" ? null : colorOption), "action")
    }));
  });
  const getAdjustSizeOption = /* @__PURE__ */ __name(() => ({
    label: t2("contextMenu.Adjust Size"),
    icon: "icon-[lucide--move-diagonal-2]",
    action: adjustNodeSize
  }), "getAdjustSizeOption");
  const getNodeVisualOptions = /* @__PURE__ */ __name((states, bump) => [
    {
      label: states.collapsed ? t2("contextMenu.Expand Node") : t2("contextMenu.Minimize Node"),
      icon: states.collapsed ? "icon-[lucide--maximize-2]" : "icon-[lucide--minimize-2]",
      action: /* @__PURE__ */ __name(() => {
        toggleNodeCollapse();
        bump();
      }, "action")
    },
    {
      label: t2("contextMenu.Shape"),
      icon: "icon-[lucide--box]",
      hasSubmenu: true,
      submenu: shapeSubmenu.value,
      action: /* @__PURE__ */ __name(() => {
      }, "action")
    },
    {
      label: t2("contextMenu.Color"),
      icon: "icon-[lucide--palette]",
      hasSubmenu: true,
      submenu: colorSubmenu.value,
      action: /* @__PURE__ */ __name(() => {
      }, "action")
    }
  ], "getNodeVisualOptions");
  const getPinOption = /* @__PURE__ */ __name((states, bump) => ({
    label: states.pinned ? t2("contextMenu.Unpin") : t2("contextMenu.Pin"),
    icon: states.pinned ? "icon-[lucide--pin-off]" : "icon-[lucide--pin]",
    action: /* @__PURE__ */ __name(() => {
      toggleNodePin();
      bump();
    }, "action")
  }), "getPinOption");
  const getBypassOption = /* @__PURE__ */ __name((states, bump) => ({
    label: states.bypassed ? t2("contextMenu.Remove Bypass") : t2("contextMenu.Bypass"),
    icon: states.bypassed ? "icon-[lucide--zap-off]" : "icon-[lucide--ban]",
    shortcut: "Ctrl+B",
    action: /* @__PURE__ */ __name(() => {
      toggleNodeBypass();
      bump();
    }, "action")
  }), "getBypassOption");
  const getRunBranchOption = /* @__PURE__ */ __name(() => ({
    label: t2("contextMenu.Run Branch"),
    icon: "icon-[lucide--play]",
    action: runBranch
  }), "getRunBranchOption");
  const getNodeInfoOption = /* @__PURE__ */ __name((showNodeHelp) => ({
    label: t2("contextMenu.Node Info"),
    icon: "icon-[lucide--info]",
    action: showNodeHelp
  }), "getNodeInfoOption");
  return {
    getNodeInfoOption,
    getAdjustSizeOption,
    getNodeVisualOptions,
    getPinOption,
    getBypassOption,
    getRunBranchOption,
    colorSubmenu
  };
}
__name(useNodeMenuOptions, "useNodeMenuOptions");
function useNodeArrangement() {
  const { t: t2 } = useI18n();
  const canvasStore = useCanvasStore();
  const canvasRefresh = useCanvasRefresh();
  const alignOptions = [
    {
      name: "top",
      localizedName: t2("contextMenu.Top"),
      value: "top",
      icon: "icon-[lucide--align-start-vertical]"
    },
    {
      name: "bottom",
      localizedName: t2("contextMenu.Bottom"),
      value: "bottom",
      icon: "icon-[lucide--align-end-vertical]"
    },
    {
      name: "left",
      localizedName: t2("contextMenu.Left"),
      value: "left",
      icon: "icon-[lucide--align-start-horizontal]"
    },
    {
      name: "right",
      localizedName: t2("contextMenu.Right"),
      value: "right",
      icon: "icon-[lucide--align-end-horizontal]"
    }
  ];
  const distributeOptions = [
    {
      name: "horizontal",
      localizedName: t2("contextMenu.Horizontal"),
      value: true,
      icon: "icon-[lucide--align-center-horizontal]"
    },
    {
      name: "vertical",
      localizedName: t2("contextMenu.Vertical"),
      value: false,
      icon: "icon-[lucide--align-center-vertical]"
    }
  ];
  const applyAlign = /* @__PURE__ */ __name((alignOption) => {
    const selectedNodes = Array.from(canvasStore.selectedItems).filter(
      (item) => isLGraphNode(item)
    );
    if (selectedNodes.length === 0) {
      return;
    }
    alignNodes(selectedNodes, alignOption.value);
    canvasRefresh.refreshCanvas();
  }, "applyAlign");
  const applyDistribute = /* @__PURE__ */ __name((distributeOption) => {
    const selectedNodes = Array.from(canvasStore.selectedItems).filter(
      (item) => isLGraphNode(item)
    );
    if (selectedNodes.length < 2) {
      return;
    }
    distributeNodes(selectedNodes, distributeOption.value);
    canvasRefresh.refreshCanvas();
  }, "applyDistribute");
  return {
    alignOptions,
    distributeOptions,
    applyAlign,
    applyDistribute
  };
}
__name(useNodeArrangement, "useNodeArrangement");
function useSelectionOperations() {
  const canvasStore = useCanvasStore();
  const toastStore = useToastStore();
  const dialogService = useDialogService();
  const titleEditorStore = useTitleEditorStore();
  const workflowStore = useWorkflowStore();
  const copySelection = /* @__PURE__ */ __name(() => {
    const canvas = app.canvas;
    if (!canvas.selectedItems || canvas.selectedItems.size === 0) {
      toastStore.add({
        severity: "warn",
        summary: t("g.nothingToCopy"),
        detail: t("g.selectItemsToCopy"),
        life: 3e3
      });
      return;
    }
    canvas.copyToClipboard();
    toastStore.add({
      severity: "success",
      summary: t("g.copied"),
      detail: t("g.itemsCopiedToClipboard"),
      life: 2e3
    });
  }, "copySelection");
  const pasteSelection = /* @__PURE__ */ __name(() => {
    const canvas = app.canvas;
    canvas.pasteFromClipboard({ connectInputs: false });
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "pasteSelection");
  const duplicateSelection = /* @__PURE__ */ __name(() => {
    const canvas = app.canvas;
    if (!canvas.selectedItems || canvas.selectedItems.size === 0) {
      toastStore.add({
        severity: "warn",
        summary: t("g.nothingToDuplicate"),
        detail: t("g.selectItemsToDuplicate"),
        life: 3e3
      });
      return;
    }
    canvas.copyToClipboard();
    canvas.selectedItems.clear();
    canvasStore.updateSelectedItems();
    canvas.pasteFromClipboard({ connectInputs: false });
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "duplicateSelection");
  const deleteSelection = /* @__PURE__ */ __name(() => {
    const canvas = app.canvas;
    if (!canvas.selectedItems || canvas.selectedItems.size === 0) {
      toastStore.add({
        severity: "warn",
        summary: t("g.nothingToDelete"),
        detail: t("g.selectItemsToDelete"),
        life: 3e3
      });
      return;
    }
    canvas.deleteSelected();
    canvas.setDirty(true, true);
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "deleteSelection");
  const renameSelection = /* @__PURE__ */ __name(async () => {
    const selectedItems = Array.from(canvasStore.selectedItems);
    if (selectedItems.length === 1) {
      const item = selectedItems[0];
      if (item instanceof LGraphNode) {
        titleEditorStore.titleEditorTarget = item;
        return;
      }
      const currentTitle = "title" in item ? item.title : "";
      const newTitle = await dialogService.prompt({
        title: t("g.rename"),
        message: t("g.enterNewName"),
        defaultValue: currentTitle
      });
      if (newTitle && newTitle !== currentTitle) {
        if ("title" in item) {
          const titledItem = item;
          titledItem.title = newTitle;
          app.canvas.setDirty(true, true);
          workflowStore.activeWorkflow?.changeTracker?.checkState();
        }
      }
      return;
    }
    if (selectedItems.length > 1) {
      const baseTitle = await dialogService.prompt({
        title: t("g.batchRename"),
        message: t("g.enterBaseName"),
        defaultValue: "Item"
      });
      if (baseTitle) {
        selectedItems.forEach((item, index) => {
          if ("title" in item) {
            const titledItem = item;
            titledItem.title = `${baseTitle} ${index + 1}`;
          }
        });
        app.canvas.setDirty(true, true);
        workflowStore.activeWorkflow?.changeTracker?.checkState();
      }
      return;
    }
    toastStore.add({
      severity: "warn",
      summary: t("g.nothingToRename"),
      detail: t("g.selectItemsToRename"),
      life: 3e3
    });
  }, "renameSelection");
  return {
    copySelection,
    pasteSelection,
    duplicateSelection,
    deleteSelection,
    renameSelection
  };
}
__name(useSelectionOperations, "useSelectionOperations");
function useSubgraphOperations() {
  const { getSelectedNodes } = useSelectedLiteGraphItems();
  const canvasStore = useCanvasStore();
  const workflowStore = useWorkflowStore();
  const nodeOutputStore = useNodeOutputStore();
  const nodeDefStore = useNodeDefStore();
  const nodeBookmarkStore = useNodeBookmarkStore();
  const convertToSubgraph = /* @__PURE__ */ __name(() => {
    const canvas = canvasStore.getCanvas();
    const graph = canvas.subgraph ?? canvas.graph;
    if (!graph) {
      return null;
    }
    const res = graph.convertToSubgraph(canvas.selectedItems);
    if (!res) {
      return;
    }
    const { node } = res;
    canvas.select(node);
    canvasStore.updateSelectedItems();
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "convertToSubgraph");
  const unpackSubgraph = /* @__PURE__ */ __name(() => {
    const canvas = canvasStore.getCanvas();
    const graph = canvas.subgraph ?? canvas.graph;
    if (!graph) {
      return;
    }
    const selectedItems = Array.from(canvas.selectedItems);
    const subgraphNodes = selectedItems.filter(
      (item) => item instanceof SubgraphNode
    );
    if (subgraphNodes.length === 0) {
      return;
    }
    subgraphNodes.forEach((subgraphNode) => {
      nodeOutputStore.revokeSubgraphPreviews(subgraphNode);
      graph.unpackSubgraph(subgraphNode);
    });
    workflowStore.activeWorkflow?.changeTracker?.checkState();
  }, "unpackSubgraph");
  const addSubgraphToLibrary = /* @__PURE__ */ __name(async () => {
    const selectedItems = Array.from(canvasStore.selectedItems);
    if (selectedItems.length === 1) {
      const item = selectedItems[0];
      if (isLGraphNode(item)) {
        const nodeDef = nodeDefStore.fromLGraphNode(item);
        if (nodeDef) {
          await nodeBookmarkStore.addBookmark(nodeDef.nodePath);
          return;
        }
      }
    }
    const selectedNodes = getSelectedNodes();
    if (selectedNodes.length === 0) {
      return;
    }
    const hasSubgraphs = selectedNodes.some(
      (node) => node instanceof SubgraphNode
    );
    if (!hasSubgraphs) {
      convertToSubgraph();
      return;
    }
    let bookmarkedCount = 0;
    for (const node of selectedNodes) {
      if (node instanceof SubgraphNode) {
        const nodeDef = nodeDefStore.fromLGraphNode(node);
        if (nodeDef) {
          await nodeBookmarkStore.addBookmark(nodeDef.nodePath);
          bookmarkedCount++;
        }
      }
    }
  }, "addSubgraphToLibrary");
  const isSubgraphSelected = /* @__PURE__ */ __name(() => {
    const selectedItems = Array.from(canvasStore.selectedItems);
    return selectedItems.some((item) => item instanceof SubgraphNode);
  }, "isSubgraphSelected");
  const hasSelectableNodes = /* @__PURE__ */ __name(() => {
    return getSelectedNodes().length > 0;
  }, "hasSelectableNodes");
  return {
    convertToSubgraph,
    unpackSubgraph,
    addSubgraphToLibrary,
    isSubgraphSelected,
    hasSelectableNodes
  };
}
__name(useSubgraphOperations, "useSubgraphOperations");
function useSelectionMenuOptions() {
  const { t: t2 } = useI18n();
  const {
    copySelection,
    duplicateSelection,
    deleteSelection,
    renameSelection
  } = useSelectionOperations();
  const { alignOptions, distributeOptions, applyAlign, applyDistribute } = useNodeArrangement();
  const { convertToSubgraph, unpackSubgraph, addSubgraphToLibrary } = useSubgraphOperations();
  const { frameNodes } = useFrameNodes();
  const alignSubmenu = computed(
    () => alignOptions.map((align) => ({
      label: align.localizedName,
      icon: align.icon,
      action: /* @__PURE__ */ __name(() => applyAlign(align), "action")
    }))
  );
  const distributeSubmenu = computed(
    () => distributeOptions.map((distribute) => ({
      label: distribute.localizedName,
      icon: distribute.icon,
      action: /* @__PURE__ */ __name(() => applyDistribute(distribute), "action")
    }))
  );
  const getBasicSelectionOptions = /* @__PURE__ */ __name(() => [
    {
      label: t2("contextMenu.Rename"),
      action: renameSelection
    },
    {
      label: t2("contextMenu.Copy"),
      shortcut: "Ctrl+C",
      action: copySelection
    },
    {
      label: t2("contextMenu.Duplicate"),
      shortcut: "Ctrl+D",
      action: duplicateSelection
    }
  ], "getBasicSelectionOptions");
  const getSubgraphOptions = /* @__PURE__ */ __name((hasSubgraphs) => {
    if (hasSubgraphs) {
      return [
        {
          label: t2("contextMenu.Add Subgraph to Library"),
          icon: "icon-[lucide--folder-plus]",
          action: addSubgraphToLibrary
        },
        {
          label: t2("contextMenu.Unpack Subgraph"),
          icon: "icon-[lucide--expand]",
          action: unpackSubgraph
        }
      ];
    } else {
      return [
        {
          label: t2("contextMenu.Convert to Subgraph"),
          icon: "icon-[lucide--shrink]",
          action: convertToSubgraph,
          badge: BadgeVariant.NEW
        }
      ];
    }
  }, "getSubgraphOptions");
  const getMultipleNodesOptions = /* @__PURE__ */ __name(() => {
    const convertToGroupNodes = /* @__PURE__ */ __name(() => {
      const commandStore = useCommandStore();
      void commandStore.execute(
        "Comfy.GroupNode.ConvertSelectedNodesToGroupNode"
      );
    }, "convertToGroupNodes");
    return [
      {
        label: t2("contextMenu.Convert to Group Node"),
        icon: "icon-[lucide--group]",
        action: convertToGroupNodes,
        badge: BadgeVariant.DEPRECATED
      },
      {
        label: t2("g.frameNodes"),
        icon: "icon-[lucide--frame]",
        action: frameNodes
      }
    ];
  }, "getMultipleNodesOptions");
  const getAlignmentOptions = /* @__PURE__ */ __name(() => [
    {
      label: t2("contextMenu.Align Selected To"),
      icon: "icon-[lucide--align-start-horizontal]",
      hasSubmenu: true,
      submenu: alignSubmenu.value,
      action: /* @__PURE__ */ __name(() => {
      }, "action")
    },
    {
      label: t2("contextMenu.Distribute Nodes"),
      icon: "icon-[lucide--align-center-horizontal]",
      hasSubmenu: true,
      submenu: distributeSubmenu.value,
      action: /* @__PURE__ */ __name(() => {
      }, "action")
    }
  ], "getAlignmentOptions");
  const getDeleteOption = /* @__PURE__ */ __name(() => ({
    label: t2("contextMenu.Delete"),
    icon: "icon-[lucide--trash-2]",
    shortcut: "Delete",
    action: deleteSelection
  }), "getDeleteOption");
  return {
    getBasicSelectionOptions,
    getSubgraphOptions,
    getMultipleNodesOptions,
    getDeleteOption,
    getAlignmentOptions,
    alignSubmenu,
    distributeSubmenu
  };
}
__name(useSelectionMenuOptions, "useSelectionMenuOptions");
var BadgeVariant = /* @__PURE__ */ ((BadgeVariant2) => {
  BadgeVariant2["NEW"] = "new";
  BadgeVariant2["DEPRECATED"] = "deprecated";
  return BadgeVariant2;
})(BadgeVariant || {});
function useMoreOptionsMenu() {
  const {
    selectedItems,
    selectedNodes,
    nodeDef,
    showNodeHelp,
    hasSubgraphs: hasSubgraphsComputed,
    hasImageNode,
    hasOutputNodesSelected,
    hasMultipleSelection,
    computeSelectionFlags
  } = useSelectionState();
  const { getImageMenuOptions } = useImageMenuOptions();
  const {
    getNodeInfoOption,
    getAdjustSizeOption,
    getNodeVisualOptions,
    getPinOption,
    getBypassOption,
    getRunBranchOption
  } = useNodeMenuOptions();
  const {
    getFitGroupToNodesOption,
    getGroupShapeOptions,
    getGroupColorOptions,
    getGroupModeOptions
  } = useGroupMenuOptions();
  const {
    getBasicSelectionOptions,
    getSubgraphOptions,
    getMultipleNodesOptions,
    getDeleteOption,
    getAlignmentOptions
  } = useSelectionMenuOptions();
  const hasSubgraphs = hasSubgraphsComputed;
  const hasMultipleNodes = hasMultipleSelection;
  const optionsVersion = ref(0);
  const bump = /* @__PURE__ */ __name(() => {
    optionsVersion.value++;
  }, "bump");
  const menuOptions = computed(() => {
    optionsVersion.value;
    const states = computeSelectionFlags();
    const selectedGroups = selectedItems.value.filter(
      isLGraphGroup
    );
    const groupContext = selectedGroups.length === 1 && selectedNodes.value.length === 0 ? selectedGroups[0] : null;
    const hasSubgraphsSelected = hasSubgraphs.value;
    const options = [];
    options.push(...getBasicSelectionOptions());
    options.push({ type: "divider" });
    if (nodeDef.value) {
      options.push(getNodeInfoOption(showNodeHelp));
    }
    if (groupContext) {
      options.push(getFitGroupToNodesOption(groupContext));
    } else {
      options.push(getAdjustSizeOption());
    }
    if (groupContext) {
      options.push(getGroupShapeOptions(groupContext, bump));
      options.push(getGroupColorOptions(groupContext, bump));
      options.push({ type: "divider" });
    } else {
      options.push(...getNodeVisualOptions(states, bump));
      options.push({ type: "divider" });
    }
    if (hasImageNode.value && selectedNodes.value.length > 0) {
      options.push(...getImageMenuOptions(selectedNodes.value[0]));
    }
    options.push(...getSubgraphOptions(hasSubgraphsSelected));
    if (hasMultipleNodes.value) {
      options.push(...getMultipleNodesOptions());
    }
    options.push({ type: "divider" });
    if (!groupContext) {
      options.push(getPinOption(states, bump));
    }
    if (hasMultipleNodes.value) {
      options.push(...getAlignmentOptions());
    }
    if (groupContext) {
      options.push(...getGroupModeOptions(groupContext, bump));
    } else {
      options.push(getBypassOption(states, bump));
    }
    if (hasOutputNodesSelected.value) {
      options.push(getRunBranchOption());
    }
    options.push({ type: "divider" });
    options.push(getDeleteOption());
    return options;
  });
  const menuOptionsWithSubmenu = computed(
    () => menuOptions.value.filter((option) => option.hasSubmenu && option.submenu)
  );
  return {
    menuOptions,
    menuOptionsWithSubmenu,
    bump,
    hasSubgraphs
  };
}
__name(useMoreOptionsMenu, "useMoreOptionsMenu");
function useSubmenuPositioning() {
  const toggleSubmenu = /* @__PURE__ */ __name(async (option, event, submenu, currentSubmenu, menuOptionsWithSubmenu, submenuRefs) => {
    if (!option.label || !option.hasSubmenu) return;
    const isCurrentlyOpen = currentSubmenu.value === option.label;
    menuOptionsWithSubmenu.forEach((opt) => {
      const sm = submenuRefs[`submenu-${opt.label}`];
      if (sm) {
        sm.hide();
      }
    });
    currentSubmenu.value = null;
    if (!isCurrentlyOpen) {
      currentSubmenu.value = option.label;
      await nextTick();
      const menuItem = event.currentTarget;
      const menuItemRect = menuItem.getBoundingClientRect();
      const mainPopoverContent = menuItem.closest(
        '[data-pc-section="content"]'
      );
      if (mainPopoverContent) {
        const mainPopoverRect = mainPopoverContent.getBoundingClientRect();
        const tempTarget = createPositionedTarget(
          mainPopoverRect.right + 8,
          menuItemRect.top,
          `submenu-target-${option.label}`
        );
        const tempEvent = createMouseEvent(
          mainPopoverRect.right + 8,
          menuItemRect.top
        );
        submenu.show(tempEvent, tempTarget);
        cleanupTempTarget(tempTarget, 100);
      } else {
        const tempTarget = createPositionedTarget(
          menuItemRect.right + 8,
          menuItemRect.top,
          `submenu-fallback-target-${option.label}`
        );
        const tempEvent = createMouseEvent(
          menuItemRect.right + 8,
          menuItemRect.top
        );
        submenu.show(tempEvent, tempTarget);
        cleanupTempTarget(tempTarget, 100);
      }
    }
  }, "toggleSubmenu");
  const createPositionedTarget = /* @__PURE__ */ __name((left, top, id) => {
    const tempTarget = document.createElement("div");
    tempTarget.style.position = "absolute";
    tempTarget.style.left = `${left}px`;
    tempTarget.style.top = `${top}px`;
    tempTarget.style.width = "1px";
    tempTarget.style.height = "1px";
    tempTarget.style.pointerEvents = "none";
    tempTarget.style.visibility = "hidden";
    tempTarget.id = id;
    document.body.appendChild(tempTarget);
    return tempTarget;
  }, "createPositionedTarget");
  const createMouseEvent = /* @__PURE__ */ __name((clientX, clientY) => {
    return new MouseEvent("click", {
      bubbles: true,
      cancelable: true,
      clientX,
      clientY
    });
  }, "createMouseEvent");
  const cleanupTempTarget = /* @__PURE__ */ __name((target, delay2) => {
    setTimeout(() => {
      if (target.parentNode) {
        target.parentNode.removeChild(target);
      }
    }, delay2);
  }, "cleanupTempTarget");
  const hideAllSubmenus = /* @__PURE__ */ __name((menuOptionsWithSubmenu, submenuRefs, currentSubmenu) => {
    menuOptionsWithSubmenu.forEach((option) => {
      const submenu = submenuRefs[`submenu-${option.label}`];
      if (submenu) {
        submenu.hide();
      }
    });
    currentSubmenu.value = null;
  }, "hideAllSubmenus");
  return {
    toggleSubmenu,
    hideAllSubmenus
  };
}
__name(useSubmenuPositioning, "useSubmenuPositioning");
const _hoisted_1$1q = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$p(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1q, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "m9 18l6-6l-6-6"
    }, null, -1)
  ]));
}
__name(render$p, "render$p");
const __unplugin_components_0$9 = markRaw({ name: "lucide-chevron-right", render: render$p });
const _hoisted_1$1p = {
  key: 0,
  class: "h-px bg-gray-200 dark-theme:bg-zinc-700 my-1"
};
const _hoisted_2$I = { class: "flex-1" };
const _hoisted_3$q = {
  key: 1,
  class: "text-xs opacity-60"
};
const _sfc_main$1n = /* @__PURE__ */ defineComponent({
  __name: "MenuOptionItem",
  props: {
    option: {}
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const { t: t2 } = useI18n();
    const props2 = __props;
    const emit = __emit;
    const handleClick = /* @__PURE__ */ __name((event) => {
      emit("click", props2.option, event);
    }, "handleClick");
    return (_ctx, _cache) => {
      const _component_i_lucide58chevron_right = __unplugin_components_0$9;
      return _ctx.option.type === "divider" ? (openBlock(), createElementBlock("div", _hoisted_1$1p)) : (openBlock(), createElementBlock("div", {
        key: 1,
        role: "button",
        class: "flex items-center gap-2 px-3 py-1.5 text-sm text-left hover:bg-gray-100 dark-theme:hover:bg-zinc-700 rounded cursor-pointer",
        onClick: handleClick
      }, [
        _ctx.option.icon ? (openBlock(), createElementBlock("i", {
          key: 0,
          class: normalizeClass([_ctx.option.icon, "w-4 h-4"])
        }, null, 2)) : createCommentVNode("", true),
        createElementVNode("span", _hoisted_2$I, toDisplayString(_ctx.option.label), 1),
        _ctx.option.shortcut ? (openBlock(), createElementBlock("span", _hoisted_3$q, toDisplayString(_ctx.option.shortcut), 1)) : createCommentVNode("", true),
        _ctx.option.hasSubmenu ? (openBlock(), createBlock(_component_i_lucide58chevron_right, {
          key: 2,
          size: 14,
          class: "opacity-60"
        })) : createCommentVNode("", true),
        _ctx.option.badge ? (openBlock(), createBlock(unref(Badge), {
          key: 3,
          severity: _ctx.option.badge === "new" ? "info" : "secondary",
          value: unref(t2)(_ctx.option.badge),
          class: normalizeClass({
            "bg-[#31B9F4] dark-theme:bg-[#0B8CE9] rounded-4xl": _ctx.option.badge === "new",
            "bg-[#9C9EAB] dark-theme:bg-[#000] rounded-4xl": _ctx.option.badge === "deprecated",
            "text-white uppercase text-[9px] h-4 px-1 gap-2.5": true
          })
        }, null, 8, ["severity", "value", "class"])) : createCommentVNode("", true)
      ]));
    };
  }
});
const _hoisted_1$1o = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$o(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1o, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M20 6L9 17l-5-5"
    }, null, -1)
  ]));
}
__name(render$o, "render$o");
const __unplugin_components_1$4 = markRaw({ name: "lucide-check", render: render$o });
const _hoisted_1$1n = ["title", "onClick"];
const _hoisted_2$H = {
  key: 1,
  class: "w-4 flex-shrink-0"
};
const _sfc_main$1m = /* @__PURE__ */ defineComponent({
  __name: "SubmenuPopover",
  props: {
    option: {},
    containerStyles: {}
  },
  emits: ["submenu-click"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const { getCurrentShape } = useNodeCustomization();
    const popover = ref();
    const show = /* @__PURE__ */ __name((event, target) => {
      popover.value?.show(event, target);
    }, "show");
    const hide2 = /* @__PURE__ */ __name(() => {
      popover.value?.hide();
    }, "hide");
    __expose({
      show,
      hide: hide2
    });
    const handleSubmenuClick = /* @__PURE__ */ __name((subOption) => {
      emit("submenu-click", subOption);
    }, "handleSubmenuClick");
    const isShapeSelected = /* @__PURE__ */ __name((subOption) => {
      if (subOption.color) return false;
      const currentShape = getCurrentShape();
      if (!currentShape) return false;
      return currentShape.localizedName === subOption.label;
    }, "isShapeSelected");
    const isColorSubmenu = computed(() => {
      return props2.option.submenu && props2.option.submenu.length > 0 && props2.option.submenu.every((item) => item.color && !item.icon);
    });
    const submenuPt = computed(() => ({
      root: {
        class: "absolute z-[60]"
      },
      content: {
        class: [
          "text-neutral dark-theme:text-white rounded-lg",
          "shadow-lg border border-zinc-200 dark-theme:border-zinc-700"
        ],
        style: {
          backgroundColor: props2.containerStyles.backgroundColor
        }
      }
    }));
    return (_ctx, _cache) => {
      const _component_i_lucide58check = __unplugin_components_1$4;
      return openBlock(), createBlock(unref(Popover), {
        ref_key: "popover",
        ref: popover,
        "auto-z-index": true,
        "base-z-index": 1100,
        dismissable: true,
        "close-on-escape": true,
        unstyled: "",
        pt: submenuPt.value
      }, {
        default: withCtx(() => [
          createElementVNode("div", {
            class: normalizeClass(
              isColorSubmenu.value ? "flex flex-col gap-1 p-2" : "flex flex-col p-2 min-w-40"
            )
          }, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.option.submenu, (subOption) => {
              return openBlock(), createElementBlock("div", {
                key: subOption.label,
                class: normalizeClass(
                  isColorSubmenu.value ? "w-7 h-7 flex items-center justify-center hover:bg-gray-100 dark-theme:hover:bg-zinc-700 rounded cursor-pointer" : "flex items-center gap-2 px-3 py-1.5 text-sm hover:bg-gray-100 dark-theme:hover:bg-zinc-700 rounded cursor-pointer"
                ),
                title: subOption.label,
                onClick: /* @__PURE__ */ __name(($event) => handleSubmenuClick(subOption), "onClick")
              }, [
                subOption.color ? (openBlock(), createElementBlock("div", {
                  key: 0,
                  class: "w-5 h-5 rounded-full border border-gray-300 dark-theme:border-zinc-600",
                  style: normalizeStyle({ backgroundColor: subOption.color })
                }, null, 4)) : !subOption.color ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  isShapeSelected(subOption) ? (openBlock(), createBlock(_component_i_lucide58check, {
                    key: 0,
                    class: "w-4 h-4 flex-shrink-0"
                  })) : (openBlock(), createElementBlock("div", _hoisted_2$H)),
                  createElementVNode("span", null, toDisplayString(subOption.label), 1)
                ], 64)) : createCommentVNode("", true)
              ], 10, _hoisted_1$1n);
            }), 128))
          ], 2)
        ]),
        _: 1
      }, 8, ["pt"]);
    };
  }
});
const _hoisted_1$1m = { class: "relative inline-flex items-center" };
const _hoisted_2$G = { class: "flex flex-col p-2 min-w-48" };
const LOG_INTERVAL = 120;
const _sfc_main$1l = /* @__PURE__ */ defineComponent({
  __name: "MoreOptions",
  setup(__props) {
    const popover = ref();
    const buttonRef = ref(null);
    const isOpen = ref(false);
    const wasOpenBeforeHide = ref(false);
    const lastProgrammaticHideReason = ref(null);
    const submenuRefs = ref({});
    const currentSubmenu = ref(null);
    const { menuOptions, menuOptionsWithSubmenu, bump } = useMoreOptionsMenu();
    const { toggleSubmenu, hideAllSubmenus } = useSubmenuPositioning();
    const minimap = useMinimap();
    const containerStyles = minimap.containerStyles;
    function getButtonEl() {
      const el = buttonRef.value?.$el || buttonRef.value;
      return el instanceof HTMLElement ? el : null;
    }
    __name(getButtonEl, "getButtonEl");
    let lastLogTs = 0;
    let overlayElCache = null;
    function resolveOverlayEl() {
      if (overlayElCache && overlayElCache.isConnected) return overlayElCache;
      const direct = popover.value?.$el;
      if (direct instanceof HTMLElement) {
        overlayElCache = direct;
        return direct;
      }
      const btn = getButtonEl();
      if (btn) {
        const candidates = Array.from(
          document.querySelectorAll("div.absolute.z-50")
        );
        const rect = btn.getBoundingClientRect();
        let best = null;
        for (const el of candidates) {
          const r2 = el.getBoundingClientRect();
          const dist = Math.abs(r2.top - rect.bottom);
          if (!best || dist < best.dist) best = { el, dist };
        }
        if (best && best.el) {
          overlayElCache = best.el;
          return best.el;
        }
      }
      return null;
    }
    __name(resolveOverlayEl, "resolveOverlayEl");
    const repositionPopover = /* @__PURE__ */ __name(() => {
      if (!isOpen.value) return;
      const btn = getButtonEl();
      const overlayEl = resolveOverlayEl();
      if (!btn || !overlayEl) return;
      const rect = btn.getBoundingClientRect();
      const marginY = 8;
      const left = rect.left + rect.width / 2;
      const top = rect.bottom + marginY;
      try {
        overlayEl.style.position = "fixed";
        overlayEl.style.left = `${left}px`;
        overlayEl.style.top = `${top}px`;
        overlayEl.style.transform = "translate(-50%, 0)";
      } catch (e) {
        console.warn("[MoreOptions] Failed to set overlay style", e);
        return;
      }
      const now2 = performance.now();
      if (now2 - lastLogTs > LOG_INTERVAL) {
        lastLogTs = now2;
      }
    }, "repositionPopover");
    const { startSync, stopSync } = useCanvasTransformSync$1(repositionPopover, {
      autoStart: false
    });
    function openPopover(triggerEvent) {
      const el = getButtonEl();
      if (!el || !el.isConnected) return false;
      bump();
      popover.value?.show(triggerEvent ?? new Event("reopen"), el);
      isOpen.value = true;
      moreOptionsOpen.value = true;
      moreOptionsRestorePending.value = false;
      return true;
    }
    __name(openPopover, "openPopover");
    function closePopover(reason = "manual") {
      lastProgrammaticHideReason.value = reason;
      popover.value?.hide();
      isOpen.value = false;
      moreOptionsOpen.value = false;
      stopSync();
      hideAll();
      if (reason !== "drag") {
        wasOpenBeforeHide.value = false;
        moreOptionsRestorePending.value = false;
      } else {
        if (!moreOptionsRestorePending.value) {
          wasOpenBeforeHide.value = true;
          moreOptionsRestorePending.value = true;
        }
      }
    }
    __name(closePopover, "closePopover");
    let restoreAttempts = 0;
    function attemptRestore() {
      if (isOpen.value) return;
      if (!wasOpenBeforeHide.value && !moreOptionsRestorePending.value) return;
      if (openPopover(new Event("reopen"))) {
        wasOpenBeforeHide.value = false;
        restoreAttempts = 0;
        return;
      }
      if (restoreAttempts >= 5) return;
      restoreAttempts++;
      requestAnimationFrame(() => attemptRestore());
    }
    __name(attemptRestore, "attemptRestore");
    const toggle = /* @__PURE__ */ __name((event) => {
      if (isOpen.value) closePopover("manual");
      else openPopover(event);
    }, "toggle");
    const hide2 = /* @__PURE__ */ __name((reason = "manual") => closePopover(reason), "hide");
    const hideAll = /* @__PURE__ */ __name(() => {
      hideAllSubmenus(
        menuOptionsWithSubmenu.value,
        submenuRefs.value,
        currentSubmenu
      );
    }, "hideAll");
    const handleOptionClick = /* @__PURE__ */ __name((option, event) => {
      if (!option.hasSubmenu && option.action) {
        option.action();
        hide2();
      } else if (option.hasSubmenu) {
        event.stopPropagation();
        const submenuKey = `submenu-${option.label}`;
        const submenu = submenuRefs.value[submenuKey];
        if (submenu) {
          void toggleSubmenu(
            option,
            event,
            submenu,
            currentSubmenu,
            menuOptionsWithSubmenu.value,
            submenuRefs.value
          );
        }
      }
    }, "handleOptionClick");
    const handleSubmenuClick = /* @__PURE__ */ __name((subOption) => {
      subOption.action();
      hide2("manual");
    }, "handleSubmenuClick");
    const setSubmenuRef = /* @__PURE__ */ __name((key, el) => {
      if (el) {
        submenuRefs.value[key] = el;
      } else {
        delete submenuRefs.value[key];
      }
    }, "setSubmenuRef");
    const pt = computed(() => ({
      root: {
        class: "absolute z-50 w-[300px] px-[12]"
      },
      content: {
        class: [
          "mt-2 text-neutral dark-theme:text-white rounded-lg",
          "shadow-lg border border-zinc-200 dark-theme:border-zinc-700"
        ],
        style: {
          backgroundColor: containerStyles.value.backgroundColor
        }
      }
    }));
    const onPopoverShow = /* @__PURE__ */ __name(() => {
      overlayElCache = resolveOverlayEl();
      requestAnimationFrame(() => repositionPopover());
      startSync();
    }, "onPopoverShow");
    const onPopoverHide = /* @__PURE__ */ __name(() => {
      if (lastProgrammaticHideReason.value == null) {
        isOpen.value = false;
        hideAll();
        wasOpenBeforeHide.value = false;
        moreOptionsOpen.value = false;
        moreOptionsRestorePending.value = false;
      }
      overlayElCache = null;
      stopSync();
      lastProgrammaticHideReason.value = null;
    }, "onPopoverHide");
    watch(
      () => forceCloseMoreOptionsSignal.value,
      () => {
        if (isOpen.value) hide2("drag");
        else
          wasOpenBeforeHide.value = wasOpenBeforeHide.value || moreOptionsRestorePending.value;
      }
    );
    watch(
      () => restoreMoreOptionsSignal.value,
      () => attemptRestore()
    );
    onMounted(() => {
      if (moreOptionsRestorePending.value && !isOpen.value) {
        requestAnimationFrame(() => attemptRestore());
      }
    });
    onUnmounted(() => {
      stopSync();
    });
    return (_ctx, _cache) => {
      const _component_i_lucide58more_vertical = __unplugin_components_0$a;
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", _hoisted_1$1m, [
        withDirectives((openBlock(), createBlock(unref(Button), {
          ref_key: "buttonRef",
          ref: buttonRef,
          "data-testid": "more-options-button",
          text: "",
          class: "h-8 w-8 px-0",
          severity: "secondary",
          onClick: toggle
        }, {
          default: withCtx(() => [
            createVNode(_component_i_lucide58more_vertical, { class: "w-4 h-4" })
          ]),
          _: 1
        })), [
          [
            _directive_tooltip,
            {
              value: _ctx.$t("g.moreOptions"),
              showDelay: 1e3
            },
            void 0,
            { top: true }
          ]
        ]),
        createVNode(unref(Popover), {
          ref_key: "popover",
          ref: popover,
          "append-to": "body",
          "auto-z-index": true,
          "base-z-index": 1e3,
          dismissable: true,
          "close-on-escape": true,
          unstyled: "",
          pt: pt.value,
          onShow: onPopoverShow,
          onHide: onPopoverHide
        }, {
          default: withCtx(() => [
            createElementVNode("div", _hoisted_2$G, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(unref(menuOptions), (option, index) => {
                return openBlock(), createBlock(_sfc_main$1n, {
                  key: option.label || `divider-${index}`,
                  option,
                  onClick: handleOptionClick
                }, null, 8, ["option"]);
              }), 128))
            ])
          ]),
          _: 1
        }, 8, ["pt"]),
        (openBlock(true), createElementBlock(Fragment, null, renderList(unref(menuOptionsWithSubmenu), (option) => {
          return openBlock(), createBlock(_sfc_main$1m, {
            key: `submenu-${option.label}`,
            ref_for: true,
            ref: /* @__PURE__ */ __name((el) => setSubmenuRef(`submenu-${option.label}`, el), "ref"),
            option,
            "container-styles": unref(containerStyles),
            onSubmenuClick: handleSubmenuClick
          }, null, 8, ["option", "container-styles"]);
        }), 128))
      ]);
    };
  }
});
const _sfc_main$1k = {};
const _hoisted_1$1l = { class: "h-6 w-px bg-gray-300/10 dark-theme:bg-gray-600/10 self-center" };
function _sfc_render$3(_ctx, _cache) {
  return openBlock(), createElementBlock("div", _hoisted_1$1l);
}
__name(_sfc_render$3, "_sfc_render$3");
const VerticalDivider = /* @__PURE__ */ _export_sfc(_sfc_main$1k, [["render", _sfc_render$3]]);
const _sfc_main$1j = /* @__PURE__ */ defineComponent({
  __name: "SelectionToolbox",
  setup(__props) {
    const commandStore = useCommandStore();
    const canvasStore = useCanvasStore();
    const extensionService = useExtensionService();
    const canvasInteractions = useCanvasInteractions();
    const minimap = useMinimap();
    const containerStyles = minimap.containerStyles;
    const toolboxRef = ref();
    const { visible } = useSelectionToolboxPosition(toolboxRef);
    const extensionToolboxCommands = computed(() => {
      const commandIds = new Set(
        canvasStore.selectedItems.map(
          (item) => extensionService.invokeExtensions("getSelectionToolboxCommands", item).flat()
        ).flat()
      );
      return Array.from(commandIds).map((commandId) => commandStore.getCommand(commandId)).filter((command) => command !== void 0);
    });
    const {
      hasAnySelection,
      hasMultipleSelection,
      isSingleNode,
      isSingleSubgraph,
      isSingleImageNode,
      hasAny3DNodeSelected,
      hasOutputNodesSelected,
      nodeDef
    } = useSelectionState();
    const showInfoButton = computed(() => !!nodeDef.value);
    const showColorPicker = computed(() => hasAnySelection.value);
    const showConvertToSubgraph = computed(() => hasAnySelection.value);
    const showFrameNodes = computed(() => hasMultipleSelection.value);
    const showPublishSubgraph = computed(() => isSingleSubgraph.value);
    const showBypass = computed(
      () => isSingleNode.value || isSingleSubgraph.value || hasMultipleSelection.value
    );
    const showLoad3DViewer = computed(() => hasAny3DNodeSelected.value);
    const showMaskEditor = computed(() => isSingleImageNode.value);
    const showDelete = computed(() => hasAnySelection.value);
    const showRefresh = computed(() => hasAnySelection.value);
    const showExecute = computed(() => hasOutputNodesSelected.value);
    const showAnyPrimaryActions = computed(
      () => showColorPicker.value || showConvertToSubgraph.value || showFrameNodes.value || showPublishSubgraph.value
    );
    const showAnyControlActions = computed(() => showBypass.value);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "toolboxRef",
        ref: toolboxRef,
        style: { "transform": "translate(var(--tb-x), var(--tb-y))" },
        class: "fixed left-0 top-0 z-40 pointer-events-none"
      }, [
        createVNode(Transition, { name: "slide-up" }, {
          default: withCtx(() => [
            unref(visible) ? (openBlock(), createBlock(unref(Panel), {
              key: 0,
              class: "rounded-lg selection-toolbox pointer-events-auto",
              style: normalizeStyle(`backgroundColor: ${unref(containerStyles).backgroundColor};`),
              pt: {
                header: "hidden",
                content: "px-1 py-1 h-10 px-1 flex flex-row gap-1"
              },
              onWheel: unref(canvasInteractions).handleWheel
            }, {
              default: withCtx(() => [
                showDelete.value ? (openBlock(), createBlock(_sfc_main$1w, { key: 0 })) : createCommentVNode("", true),
                showInfoButton.value && showAnyPrimaryActions.value ? (openBlock(), createBlock(VerticalDivider, { key: 1 })) : createCommentVNode("", true),
                showInfoButton.value ? (openBlock(), createBlock(_sfc_main$1t, { key: 2 })) : createCommentVNode("", true),
                showColorPicker.value ? (openBlock(), createBlock(ColorPickerButton, { key: 3 })) : createCommentVNode("", true),
                showFrameNodes.value ? (openBlock(), createBlock(_sfc_main$1o, { key: 4 })) : createCommentVNode("", true),
                showConvertToSubgraph.value ? (openBlock(), createBlock(_sfc_main$1x, { key: 5 })) : createCommentVNode("", true),
                showPublishSubgraph.value ? (openBlock(), createBlock(_sfc_main$1p, { key: 6 })) : createCommentVNode("", true),
                showMaskEditor.value ? (openBlock(), createBlock(_sfc_main$1r, { key: 7 })) : createCommentVNode("", true),
                showAnyPrimaryActions.value && showAnyControlActions.value ? (openBlock(), createBlock(VerticalDivider, { key: 8 })) : createCommentVNode("", true),
                showBypass.value ? (openBlock(), createBlock(_sfc_main$1z, { key: 9 })) : createCommentVNode("", true),
                showRefresh.value ? (openBlock(), createBlock(_sfc_main$1q, { key: 10 })) : createCommentVNode("", true),
                showLoad3DViewer.value ? (openBlock(), createBlock(_sfc_main$1s, { key: 11 })) : createCommentVNode("", true),
                (openBlock(true), createElementBlock(Fragment, null, renderList(extensionToolboxCommands.value, (command) => {
                  return openBlock(), createBlock(_sfc_main$1u, {
                    key: command.id,
                    command
                  }, null, 8, ["command"]);
                }), 128)),
                showExecute.value ? (openBlock(), createBlock(ExecuteButton, { key: 12 })) : createCommentVNode("", true),
                createVNode(_sfc_main$1l)
              ]),
              _: 1
            }, 8, ["style", "onWheel"])) : createCommentVNode("", true)
          ]),
          _: 1
        })
      ], 512);
    };
  }
});
const SelectionToolbox = /* @__PURE__ */ _export_sfc(_sfc_main$1j, [["__scopeId", "data-v-fe78f85f"]]);
const _sfc_main$1i = /* @__PURE__ */ defineComponent({
  __name: "TitleEditor",
  setup(__props) {
    const settingStore = useSettingStore();
    const showInput = ref(false);
    const editedTitle = ref("");
    const { style: inputPositionStyle, updatePosition } = useAbsolutePosition();
    const inputFontStyle = ref({});
    const inputStyle = computed(() => ({
      ...inputPositionStyle.value,
      ...inputFontStyle.value
    }));
    const titleEditorStore = useTitleEditorStore();
    const canvasStore = useCanvasStore();
    const previousCanvasDraggable = ref(true);
    const onEdit = /* @__PURE__ */ __name((newValue) => {
      if (titleEditorStore.titleEditorTarget && newValue.trim() !== "") {
        const trimmedTitle = newValue.trim();
        titleEditorStore.titleEditorTarget.title = trimmedTitle;
        const target = titleEditorStore.titleEditorTarget;
        if (target instanceof LGraphNode && target.isSubgraphNode?.()) {
          target.subgraph.name = trimmedTitle;
        }
        app.graph.setDirtyCanvas(true, true);
      }
      showInput.value = false;
      titleEditorStore.titleEditorTarget = null;
      canvasStore.canvas.allow_dragcanvas = previousCanvasDraggable.value;
    }, "onEdit");
    watch(
      () => titleEditorStore.titleEditorTarget,
      (target) => {
        if (target === null) {
          return;
        }
        editedTitle.value = target.title;
        showInput.value = true;
        const canvas = canvasStore.canvas;
        previousCanvasDraggable.value = canvas.allow_dragcanvas;
        canvas.allow_dragcanvas = false;
        const scale = canvas.ds.scale;
        if (target instanceof LGraphGroup) {
          const group = target;
          updatePosition({
            pos: group.pos,
            size: [group.size[0], group.titleHeight]
          });
          inputFontStyle.value = { fontSize: `${group.font_size * scale}px` };
        } else if (target instanceof LGraphNode) {
          const node = target;
          const [x, y] = node.getBounding();
          updatePosition({
            pos: [x, y],
            size: [node.width, LiteGraph.NODE_TITLE_HEIGHT]
          });
          inputFontStyle.value = { fontSize: `${12 * scale}px` };
        }
      }
    );
    const canvasEventHandler = /* @__PURE__ */ __name((event) => {
      if (event.detail.subType === "group-double-click") {
        if (!settingStore.get("Comfy.Group.DoubleClickTitleToEdit")) {
          return;
        }
        const group = event.detail.group;
        const [_, y] = group.pos;
        const e = event.detail.originalEvent;
        const relativeY = e.canvasY - y;
        if (relativeY <= group.titleHeight) {
          titleEditorStore.titleEditorTarget = group;
        }
      } else if (event.detail.subType === "node-double-click") {
        if (!settingStore.get("Comfy.Node.DoubleClickTitleToEdit")) {
          return;
        }
        const node = event.detail.node;
        const [_, y] = node.pos;
        const e = event.detail.originalEvent;
        const relativeY = e.canvasY - y;
        if (relativeY <= 0) {
          titleEditorStore.titleEditorTarget = node;
        }
      }
    }, "canvasEventHandler");
    useEventListener$1(document, "litegraph:canvas", canvasEventHandler);
    return (_ctx, _cache) => {
      return showInput.value ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: "group-title-editor node-title-editor",
        style: normalizeStyle(inputStyle.value)
      }, [
        createVNode(EditableText, {
          "is-editing": showInput.value,
          "model-value": editedTitle.value,
          onEdit
        }, null, 8, ["is-editing", "model-value"])
      ], 4)) : createCommentVNode("", true);
    };
  }
});
const TitleEditor = /* @__PURE__ */ _export_sfc(_sfc_main$1i, [["__scopeId", "data-v-c4373319"]]);
const useSearchBoxStore = defineStore("searchBox", () => {
  const settingStore = useSettingStore();
  const { x, y } = useMouse$1();
  const newSearchBoxEnabled = computed(
    () => settingStore.get("Comfy.NodeSearchBoxImpl") === "default"
  );
  const popoverRef = shallowRef(null);
  function setPopoverRef(popover) {
    popoverRef.value = popover;
  }
  __name(setPopoverRef, "setPopoverRef");
  const visible = ref(false);
  function toggleVisible() {
    if (newSearchBoxEnabled.value) {
      visible.value = !visible.value;
      return;
    }
    if (!popoverRef.value) return;
    popoverRef.value.showSearchBox(
      new MouseEvent("click", {
        clientX: x.value,
        clientY: y.value,
        // @ts-expect-error layerY is a nonstandard property
        layerY: y.value
      })
    );
  }
  __name(toggleVisible, "toggleVisible");
  return {
    newSearchBoxEnabled,
    setPopoverRef,
    toggleVisible,
    visible
  };
});
const _sfc_main$1h = {
  name: "AutoCompletePlus",
  extends: AutoComplete,
  emits: ["focused-option-changed"],
  data() {
    return {
      // Flag to determine if IME is active
      isComposing: false
    };
  },
  mounted() {
    if (typeof AutoComplete.mounted === "function") {
      AutoComplete.mounted.call(this);
    }
    const inputEl = this.$el.querySelector("input");
    if (inputEl) {
      inputEl.addEventListener("compositionstart", () => {
        this.isComposing = true;
      });
      inputEl.addEventListener("compositionend", () => {
        this.isComposing = false;
      });
    }
    this.$watch(
      () => this.focusedOptionIndex,
      (newVal, oldVal) => {
        this.$emit("focused-option-changed", newVal);
      }
    );
  },
  methods: {
    // Override onKeyDown to block Enter when IME is active
    onKeyDown(event) {
      if (event.key === "Enter" && this.isComposing) {
        event.preventDefault();
        event.stopPropagation();
        return;
      }
      AutoComplete.methods.onKeyDown.call(this, event);
    }
  }
};
const _hoisted_1$1k = { class: "option-container flex justify-between items-center px-2 py-0 cursor-pointer overflow-hidden w-full" };
const _hoisted_2$F = { class: "option-display-name font-semibold flex flex-col" };
const _hoisted_3$p = { key: 0 };
const _hoisted_4$i = ["innerHTML"];
const _hoisted_5$b = ["innerHTML"];
const _hoisted_6$8 = {
  key: 0,
  class: "option-category font-light text-sm text-muted overflow-hidden text-ellipsis whitespace-nowrap"
};
const _hoisted_7$6 = { class: "option-badges" };
const _sfc_main$1g = /* @__PURE__ */ defineComponent({
  __name: "NodeSearchItem",
  props: {
    nodeDef: {},
    currentQuery: {}
  },
  setup(__props) {
    const settingStore = useSettingStore();
    const showCategory = computed(
      () => settingStore.get("Comfy.NodeSearchBoxImpl.ShowCategory")
    );
    const showIdName = computed(
      () => settingStore.get("Comfy.NodeSearchBoxImpl.ShowIdName")
    );
    const showNodeFrequency = computed(
      () => settingStore.get("Comfy.NodeSearchBoxImpl.ShowNodeFrequency")
    );
    const nodeFrequencyStore = useNodeFrequencyStore();
    const nodeFrequency = computed(
      () => nodeFrequencyStore.getNodeFrequency(props2.nodeDef)
    );
    const nodeBookmarkStore = useNodeBookmarkStore();
    const isBookmarked = computed(
      () => nodeBookmarkStore.isBookmarked(props2.nodeDef)
    );
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1k, [
        createElementVNode("div", _hoisted_2$F, [
          createElementVNode("div", null, [
            isBookmarked.value ? (openBlock(), createElementBlock("span", _hoisted_3$p, _cache[0] || (_cache[0] = [
              createElementVNode("i", { class: "pi pi-bookmark-fill text-sm mr-1" }, null, -1)
            ]))) : createCommentVNode("", true),
            createElementVNode("span", {
              innerHTML: unref(highlightQuery)(_ctx.nodeDef.display_name, _ctx.currentQuery)
            }, null, 8, _hoisted_4$i),
            _cache[1] || (_cache[1] = createElementVNode("span", null, " ", -1)),
            showIdName.value ? (openBlock(), createBlock(unref(Tag), {
              key: 1,
              severity: "secondary"
            }, {
              default: withCtx(() => [
                createElementVNode("span", {
                  innerHTML: unref(highlightQuery)(_ctx.nodeDef.name, _ctx.currentQuery)
                }, null, 8, _hoisted_5$b)
              ]),
              _: 1
            })) : createCommentVNode("", true)
          ]),
          showCategory.value ? (openBlock(), createElementBlock("div", _hoisted_6$8, toDisplayString(_ctx.nodeDef.category.replaceAll("/", " > ")), 1)) : createCommentVNode("", true)
        ]),
        createElementVNode("div", _hoisted_7$6, [
          _ctx.nodeDef.experimental ? (openBlock(), createBlock(unref(Tag), {
            key: 0,
            value: _ctx.$t("g.experimental"),
            severity: "primary"
          }, null, 8, ["value"])) : createCommentVNode("", true),
          _ctx.nodeDef.deprecated ? (openBlock(), createBlock(unref(Tag), {
            key: 1,
            value: _ctx.$t("g.deprecated"),
            severity: "danger"
          }, null, 8, ["value"])) : createCommentVNode("", true),
          showNodeFrequency.value && nodeFrequency.value > 0 ? (openBlock(), createBlock(unref(Tag), {
            key: 2,
            value: unref(formatNumberWithSuffix)(nodeFrequency.value, { roundToInt: true }),
            severity: "secondary"
          }, null, 8, ["value"])) : createCommentVNode("", true),
          _ctx.nodeDef.nodeSource.type !== unref(NodeSourceType).Unknown ? (openBlock(), createBlock(unref(Chip), {
            key: 3,
            class: "text-sm font-light"
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString(_ctx.nodeDef.nodeSource.displayText), 1)
            ]),
            _: 1
          })) : createCommentVNode("", true)
        ])
      ]);
    };
  }
});
const NodeSearchItem = /* @__PURE__ */ _export_sfc(_sfc_main$1g, [["__scopeId", "data-v-f64953bf"]]);
const _hoisted_1$1j = { class: "comfy-vue-node-search-container flex justify-center items-center w-full min-w-96" };
const _hoisted_2$E = {
  key: 0,
  class: "comfy-vue-node-preview-container absolute left-[-350px] top-[50px]"
};
const _hoisted_3$o = { class: "_dialog-body" };
const _sfc_main$1f = /* @__PURE__ */ defineComponent({
  __name: "NodeSearchBox",
  props: {
    filters: {},
    searchLimit: { default: 64 }
  },
  emits: ["addFilter", "removeFilter", "addNode"],
  setup(__props, { emit: __emit }) {
    const settingStore = useSettingStore();
    const { t: t2 } = useI18n();
    const enableNodePreview = computed(
      () => settingStore.get("Comfy.NodeSearchBoxImpl.NodePreview")
    );
    const nodeSearchFilterVisible = ref(false);
    const inputId = `comfy-vue-node-search-box-input-${Math.random()}`;
    const suggestions = ref([]);
    const hoveredSuggestion = ref(null);
    const currentQuery = ref("");
    const placeholder = computed(() => {
      return __props.filters.length === 0 ? t2("g.searchNodes") + "..." : "";
    });
    const nodeDefStore = useNodeDefStore();
    const nodeFrequencyStore = useNodeFrequencyStore();
    const search = /* @__PURE__ */ __name((query) => {
      const queryIsEmpty = query === "" && __props.filters.length === 0;
      currentQuery.value = query;
      suggestions.value = queryIsEmpty ? nodeFrequencyStore.topNodeDefs : [
        ...nodeDefStore.nodeSearchService.searchNode(query, __props.filters, {
          limit: __props.searchLimit
        })
      ];
    }, "search");
    const emit = __emit;
    let inputElement = null;
    const reFocusInput = /* @__PURE__ */ __name(async () => {
      inputElement ??= document.getElementById(inputId);
      if (inputElement) {
        inputElement.blur();
        await nextTick(() => inputElement?.focus());
      }
    }, "reFocusInput");
    onMounted(reFocusInput);
    const onAddFilter = /* @__PURE__ */ __name((filterAndValue) => {
      nodeSearchFilterVisible.value = false;
      emit("addFilter", filterAndValue);
    }, "onAddFilter");
    const onRemoveFilter = /* @__PURE__ */ __name(async (event, filterAndValue) => {
      event.stopPropagation();
      event.preventDefault();
      emit("removeFilter", filterAndValue);
      await reFocusInput();
    }, "onRemoveFilter");
    const setHoverSuggestion = /* @__PURE__ */ __name((index) => {
      if (index === -1) {
        hoveredSuggestion.value = null;
        return;
      }
      const value = suggestions.value[index];
      hoveredSuggestion.value = value;
    }, "setHoverSuggestion");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1j, [
        enableNodePreview.value ? (openBlock(), createElementBlock("div", _hoisted_2$E, [
          hoveredSuggestion.value ? (openBlock(), createBlock(NodePreview, {
            key: hoveredSuggestion.value?.name || "",
            "node-def": hoveredSuggestion.value
          }, null, 8, ["node-def"])) : createCommentVNode("", true)
        ])) : createCommentVNode("", true),
        createVNode(unref(Button), {
          icon: "pi pi-filter",
          severity: "secondary",
          class: "filter-button z-10",
          onClick: _cache[0] || (_cache[0] = ($event) => nodeSearchFilterVisible.value = true)
        }),
        createVNode(unref(Dialog), {
          visible: nodeSearchFilterVisible.value,
          "onUpdate:visible": _cache[1] || (_cache[1] = ($event) => nodeSearchFilterVisible.value = $event),
          class: "min-w-96",
          "dismissable-mask": "",
          modal: "",
          onHide: reFocusInput
        }, {
          header: withCtx(() => [
            createElementVNode("h3", null, toDisplayString(_ctx.$t("g.addNodeFilterCondition")), 1)
          ]),
          default: withCtx(() => [
            createElementVNode("div", _hoisted_3$o, [
              createVNode(NodeSearchFilter, { onAddFilter })
            ])
          ]),
          _: 1
        }, 8, ["visible"]),
        createVNode(_sfc_main$1h, {
          "model-value": _ctx.filters,
          class: "comfy-vue-node-search-box z-10 grow",
          "scroll-height": "40vh",
          placeholder: placeholder.value,
          "input-id": inputId,
          "append-to": "self",
          suggestions: suggestions.value,
          "min-length": 0,
          delay: 100,
          loading: !unref(nodeFrequencyStore).isLoaded,
          "complete-on-focus": "",
          "auto-option-focus": "",
          "force-selection": "",
          multiple: "",
          "option-label": "display_name",
          onComplete: _cache[2] || (_cache[2] = ($event) => search($event.query)),
          onOptionSelect: _cache[3] || (_cache[3] = ($event) => emit("addNode", $event.value)),
          onFocusedOptionChanged: _cache[4] || (_cache[4] = ($event) => setHoverSuggestion($event))
        }, {
          option: withCtx(({ option }) => [
            createVNode(NodeSearchItem, {
              "node-def": option,
              "current-query": currentQuery.value
            }, null, 8, ["node-def", "current-query"])
          ]),
          chip: withCtx(({ value }) => [
            value.filterDef && value.value ? (openBlock(), createBlock(SearchFilterChip, {
              key: `${value.filterDef.id}-${value.value}`,
              text: value.value,
              badge: value.filterDef.invokeSequence.toUpperCase(),
              "badge-class": value.filterDef.invokeSequence + "-badge",
              onRemove: /* @__PURE__ */ __name(($event) => onRemoveFilter(
                $event,
                value
              ), "onRemove")
            }, null, 8, ["text", "badge", "badge-class", "onRemove"])) : createCommentVNode("", true)
          ]),
          _: 1
        }, 8, ["model-value", "placeholder", "suggestions", "loading"])
      ]);
    };
  }
});
const _sfc_main$1e = /* @__PURE__ */ defineComponent({
  __name: "NodeSearchBoxPopover",
  setup(__props, { expose: __expose }) {
    let triggerEvent = null;
    let listenerController = null;
    let disconnectOnReset = false;
    const settingStore = useSettingStore();
    const searchBoxStore = useSearchBoxStore();
    const litegraphService = useLitegraphService();
    const { visible, newSearchBoxEnabled } = storeToRefs(searchBoxStore);
    const dismissable = ref(true);
    const getNewNodeLocation = /* @__PURE__ */ __name(() => {
      return triggerEvent ? [triggerEvent.canvasX, triggerEvent.canvasY] : litegraphService.getCanvasCenter();
    }, "getNewNodeLocation");
    const nodeFilters = ref([]);
    const addFilter = /* @__PURE__ */ __name((filter) => {
      nodeFilters.value.push(filter);
    }, "addFilter");
    const removeFilter = /* @__PURE__ */ __name((filter) => {
      nodeFilters.value = nodeFilters.value.filter(
        (f) => toRaw(f) !== toRaw(filter)
      );
    }, "removeFilter");
    const clearFilters = /* @__PURE__ */ __name(() => {
      nodeFilters.value = [];
    }, "clearFilters");
    const closeDialog = /* @__PURE__ */ __name(() => {
      visible.value = false;
    }, "closeDialog");
    const canvasStore = useCanvasStore();
    const addNode = /* @__PURE__ */ __name((nodeDef) => {
      const node = litegraphService.addNodeOnGraph(nodeDef, {
        pos: getNewNodeLocation()
      });
      if (disconnectOnReset && triggerEvent) {
        canvasStore.getCanvas().linkConnector.connectToNode(node, triggerEvent);
      } else if (!triggerEvent) {
        console.warn("The trigger event was undefined when addNode was called.");
      }
      disconnectOnReset = false;
      useWorkflowStore().activeWorkflow?.changeTracker?.checkState();
      window.requestAnimationFrame(closeDialog);
    }, "addNode");
    const showSearchBox = /* @__PURE__ */ __name((e) => {
      if (newSearchBoxEnabled.value) {
        if (e?.pointerType === "touch") {
          setTimeout(() => {
            showNewSearchBox(e);
          }, 128);
        } else {
          showNewSearchBox(e);
        }
      } else {
        canvasStore.getCanvas().showSearchBox(e);
      }
    }, "showSearchBox");
    const getFirstLink = /* @__PURE__ */ __name(() => canvasStore.getCanvas().linkConnector.renderLinks.at(0), "getFirstLink");
    const nodeDefStore = useNodeDefStore();
    const showNewSearchBox = /* @__PURE__ */ __name((e) => {
      const firstLink = getFirstLink();
      if (firstLink) {
        const filter = firstLink.toType === "input" ? nodeDefStore.nodeSearchService.inputTypeFilter : nodeDefStore.nodeSearchService.outputTypeFilter;
        const dataType = firstLink.fromSlot.type?.toString() ?? "";
        addFilter({
          filterDef: filter,
          value: dataType
        });
      }
      visible.value = true;
      triggerEvent = e;
      dismissable.value = false;
      setTimeout(() => {
        dismissable.value = true;
      }, 300);
    }, "showNewSearchBox");
    const showContextMenu = /* @__PURE__ */ __name((e) => {
      const firstLink = getFirstLink();
      if (!firstLink) return;
      const { node, fromSlot, toType } = firstLink;
      const commonOptions = {
        e,
        allow_searchbox: true,
        showSearchBox: /* @__PURE__ */ __name(() => {
          cancelResetOnContextClose();
          showSearchBox(e);
        }, "showSearchBox")
      };
      const afterRerouteId = firstLink.fromReroute?.id;
      const connectionOptions = toType === "input" ? { nodeFrom: node, slotFrom: fromSlot, afterRerouteId } : { nodeTo: node, slotTo: fromSlot, afterRerouteId };
      const canvas = canvasStore.getCanvas();
      const menu = canvas.showConnectionMenu({
        ...connectionOptions,
        ...commonOptions
      });
      if (!menu) {
        console.warn("No menu was returned from showConnectionMenu");
        return;
      }
      triggerEvent = e;
      listenerController = new AbortController();
      const { signal } = listenerController;
      const options = { once: true, signal };
      useEventListener$1(
        canvas.canvas,
        "connect-new-default-node",
        (createEvent) => {
          if (!(createEvent instanceof CustomEvent))
            throw new Error("Invalid event");
          const node2 = createEvent.detail?.node;
          if (!(node2 instanceof LGraphNode)) throw new Error("Invalid node");
          disconnectOnReset = false;
          createEvent.preventDefault();
          canvas.linkConnector.connectToNode(node2, e);
        },
        options
      );
      const cancelResetOnContextClose = useEventListener$1(
        menu.controller.signal,
        "abort",
        reset,
        options
      );
    }, "showContextMenu");
    watchEffect(() => {
      const { canvas } = canvasStore;
      if (!canvas) return;
      LiteGraph.release_link_on_empty_shows_menu = false;
      canvas.allow_searchbox = false;
      useEventListener$1(
        canvas.linkConnector.events,
        "dropped-on-canvas",
        handleDroppedOnCanvas
      );
    });
    const canvasEventHandler = /* @__PURE__ */ __name((e) => {
      if (e.detail.subType === "empty-double-click") {
        showSearchBox(e.detail.originalEvent);
      } else if (e.detail.subType === "group-double-click") {
        const group = e.detail.group;
        const [_, y] = group.pos;
        const relativeY = e.detail.originalEvent.canvasY - y;
        if (relativeY > group.titleHeight) {
          showSearchBox(e.detail.originalEvent);
        }
      }
    }, "canvasEventHandler");
    const linkReleaseAction = computed(
      () => settingStore.get("Comfy.LinkRelease.Action")
    );
    const linkReleaseActionShift = computed(
      () => settingStore.get("Comfy.LinkRelease.ActionShift")
    );
    const preventDefault2 = /* @__PURE__ */ __name((e) => e.preventDefault(), "preventDefault");
    const cancelNextReset = /* @__PURE__ */ __name((e) => {
      e.preventDefault();
      const canvas = canvasStore.getCanvas();
      canvas.linkConnector.state.snapLinksPos = [e.detail.canvasX, e.detail.canvasY];
      useEventListener$1(canvas.linkConnector.events, "reset", preventDefault2, {
        once: true
      });
    }, "cancelNextReset");
    const handleDroppedOnCanvas = /* @__PURE__ */ __name((e) => {
      disconnectOnReset = true;
      const action = e.detail.shiftKey ? linkReleaseActionShift.value : linkReleaseAction.value;
      switch (action) {
        case LinkReleaseTriggerAction.SEARCH_BOX:
          cancelNextReset(e);
          showSearchBox(e.detail);
          break;
        case LinkReleaseTriggerAction.CONTEXT_MENU:
          cancelNextReset(e);
          showContextMenu(e.detail);
          break;
        case LinkReleaseTriggerAction.NO_ACTION:
        default:
          break;
      }
    }, "handleDroppedOnCanvas");
    const reset = /* @__PURE__ */ __name(() => {
      listenerController?.abort();
      listenerController = null;
      triggerEvent = null;
      const canvas = canvasStore.getCanvas();
      canvas.linkConnector.events.removeEventListener("reset", preventDefault2);
      if (disconnectOnReset) canvas.linkConnector.disconnectLinks();
      canvas.linkConnector.reset();
      canvas.setDirty(true, true);
    }, "reset");
    watch(visible, () => {
      if (!visible.value) reset();
    });
    useEventListener$1(document, "litegraph:canvas", canvasEventHandler);
    __expose({ showSearchBox });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", null, [
        createVNode(unref(Dialog), {
          visible: unref(visible),
          "onUpdate:visible": _cache[0] || (_cache[0] = ($event) => isRef(visible) ? visible.value = $event : null),
          modal: "",
          "dismissable-mask": dismissable.value,
          pt: {
            root: {
              class: "invisible-dialog-root",
              role: "search"
            },
            mask: { class: "node-search-box-dialog-mask" },
            transition: {
              enterFromClass: "opacity-0 scale-75",
              // 100ms is the duration of the transition in the dialog component
              enterActiveClass: "transition-all duration-100 ease-out",
              leaveActiveClass: "transition-all duration-100 ease-in",
              leaveToClass: "opacity-0 scale-75"
            }
          },
          onHide: clearFilters
        }, {
          container: withCtx(() => [
            createVNode(_sfc_main$1f, {
              filters: nodeFilters.value,
              onAddFilter: addFilter,
              onRemoveFilter: removeFilter,
              onAddNode: addNode
            }, null, 8, ["filters"])
          ]),
          _: 1
        }, 8, ["visible", "dismissable-mask"])
      ]);
    };
  }
});
const _hoisted_1$1i = {
  viewBox: "0 0 256 256",
  width: "1.2em",
  height: "1.2em"
};
function render$n(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1i, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "currentColor",
      d: "m120 137l-72 64a12 12 0 1 1-16-18l61.91-55L32 73a12 12 0 1 1 16-18l72 64a12 12 0 0 1 0 18m96 43h-96a12 12 0 0 0 0 24h96a12 12 0 0 0 0-24"
    }, null, -1)
  ]));
}
__name(render$n, "render$n");
const __unplugin_components_0$8 = markRaw({ name: "ph-terminal-bold", render: render$n });
const _hoisted_1$1h = { class: "side-bar-button-content" };
const _hoisted_2$D = {
  key: 0,
  class: "side-bar-button-label"
};
const _sfc_main$1d = /* @__PURE__ */ defineComponent({
  __name: "SidebarIcon",
  props: {
    icon: { default: "" },
    selected: { type: Boolean, default: false },
    tooltip: { default: "" },
    tooltipSuffix: { default: "" },
    iconBadge: { type: [String, Function], default: "" },
    label: { default: "" },
    isSmall: { type: Boolean, default: false }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const { t: t2 } = useI18n();
    const emit = __emit;
    const overlayValue = computed(
      () => typeof __props.iconBadge === "function" ? __props.iconBadge() ?? "" : __props.iconBadge
    );
    const shouldShowBadge = computed(() => !!overlayValue.value);
    const computedTooltip = computed(() => t2(__props.tooltip) + __props.tooltipSuffix);
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return withDirectives((openBlock(), createBlock(unref(Button), {
        text: "",
        pt: {
          root: {
            class: `side-bar-button ${_ctx.selected ? "p-button-primary side-bar-button-selected" : "p-button-secondary"}`,
            "aria-label": computedTooltip.value
          }
        },
        onClick: _cache[0] || (_cache[0] = ($event) => emit("click", $event))
      }, {
        icon: withCtx(() => [
          createElementVNode("div", _hoisted_1$1h, [
            renderSlot(_ctx.$slots, "icon", {}, () => [
              shouldShowBadge.value ? (openBlock(), createBlock(unref(OverlayBadge), {
                key: 0,
                value: overlayValue.value
              }, {
                default: withCtx(() => [
                  typeof _ctx.icon === "string" ? (openBlock(), createElementBlock("i", {
                    key: 0,
                    class: normalizeClass(_ctx.icon + " side-bar-button-icon")
                  }, null, 2)) : (openBlock(), createBlock(resolveDynamicComponent(_ctx.icon), {
                    key: 1,
                    class: "side-bar-button-icon"
                  }))
                ]),
                _: 1
              }, 8, ["value"])) : typeof _ctx.icon === "string" ? (openBlock(), createElementBlock("i", {
                key: 1,
                class: normalizeClass(_ctx.icon + " side-bar-button-icon")
              }, null, 2)) : typeof _ctx.icon === "object" ? (openBlock(), createBlock(resolveDynamicComponent(_ctx.icon), {
                key: 2,
                class: "side-bar-button-icon"
              })) : createCommentVNode("", true)
            ], true),
            _ctx.label && !_ctx.isSmall ? (openBlock(), createElementBlock("span", _hoisted_2$D, toDisplayString(unref(t2)(_ctx.label)), 1)) : createCommentVNode("", true)
          ])
        ]),
        _: 3
      }, 8, ["pt"])), [
        [_directive_tooltip, {
          value: computedTooltip.value,
          showDelay: 300,
          hideDelay: 300
        }]
      ]);
    };
  }
});
const SidebarIcon = /* @__PURE__ */ _export_sfc(_sfc_main$1d, [["__scopeId", "data-v-179455cd"]]);
const _sfc_main$1c = /* @__PURE__ */ defineComponent({
  __name: "SidebarBottomPanelToggleButton",
  setup(__props) {
    const bottomPanelStore = useBottomPanelStore();
    return (_ctx, _cache) => {
      const _component_i_ph58terminal_bold = __unplugin_components_0$8;
      return openBlock(), createBlock(SidebarIcon, {
        tooltip: _ctx.$t("menu.toggleBottomPanel"),
        selected: unref(bottomPanelStore).activePanel == "terminal",
        onClick: unref(bottomPanelStore).toggleBottomPanel
      }, {
        icon: withCtx(() => [
          createVNode(_component_i_ph58terminal_bold)
        ]),
        _: 1
      }, 8, ["tooltip", "selected", "onClick"]);
    };
  }
});
const _hoisted_1$1g = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$m(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1g, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M10 8h.01M12 12h.01M14 8h.01M16 12h.01M18 8h.01M6 8h.01M7 16h10m-9-4h.01" }),
      createElementVNode("rect", {
        width: "20",
        height: "16",
        x: "2",
        y: "4",
        rx: "2"
      })
    ], -1)
  ]));
}
__name(render$m, "render$m");
const __unplugin_components_0$7 = markRaw({ name: "lucide-keyboard", render: render$m });
const _sfc_main$1b = /* @__PURE__ */ defineComponent({
  __name: "SidebarShortcutsToggleButton",
  setup(__props) {
    const { t: t2 } = useI18n();
    const bottomPanelStore = useBottomPanelStore();
    const commandStore = useCommandStore();
    const command = commandStore.getCommand("Workspace.ToggleBottomPanel.Shortcuts");
    const { formatKeySequence } = commandStore;
    const isShortcutsPanelVisible = computed(
      () => bottomPanelStore.activePanel === "shortcuts"
    );
    const tooltipText = computed(
      () => `${t2("shortcuts.keyboardShortcuts")} (${formatKeySequence(command)})`
    );
    const toggleShortcutsPanel = /* @__PURE__ */ __name(() => {
      bottomPanelStore.togglePanel("shortcuts");
    }, "toggleShortcutsPanel");
    return (_ctx, _cache) => {
      const _component_i_lucide58keyboard = __unplugin_components_0$7;
      return openBlock(), createBlock(SidebarIcon, {
        tooltip: tooltipText.value,
        selected: isShortcutsPanelVisible.value,
        onClick: toggleShortcutsPanel
      }, {
        icon: withCtx(() => [
          createVNode(_component_i_lucide58keyboard)
        ]),
        _: 1
      }, 8, ["tooltip", "selected"]);
    };
  }
});
const _hoisted_1$1f = ["width", "height"];
const _hoisted_2$C = { "clip-path": "url(#clip0_1099_16244)" };
const _hoisted_3$n = ["stroke"];
const _sfc_main$1a = /* @__PURE__ */ defineComponent({
  __name: "PuzzleIcon",
  props: {
    size: { default: 16 },
    color: { default: "currentColor" },
    class: {}
  },
  setup(__props) {
    const iconClass = computed(() => __props.class || "");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("svg", {
        xmlns: "http://www.w3.org/2000/svg",
        width: _ctx.size,
        height: _ctx.size,
        viewBox: "0 0 16 16",
        fill: "none",
        class: normalizeClass(iconClass.value)
      }, [
        createElementVNode("g", _hoisted_2$C, [
          createElementVNode("path", {
            d: "M4.99992 3.00016C4.99992 2.07969 5.74611 1.3335 6.66658 1.3335C7.58706 1.3335 8.33325 2.07969 8.33325 3.00016V4.00016H8.99992C9.9318 4.00016 10.3977 4.00016 10.7653 4.1524C11.2553 4.35539 11.6447 4.74474 11.8477 5.2348C11.9999 5.60234 11.9999 6.06828 11.9999 7.00016H12.9999C13.9204 7.00016 14.6666 7.74635 14.6666 8.66683C14.6666 9.5873 13.9204 10.3335 12.9999 10.3335H11.9999V11.4668C11.9999 12.5869 11.9999 13.147 11.7819 13.5748C11.5902 13.9511 11.2842 14.2571 10.9079 14.4488C10.4801 14.6668 9.92002 14.6668 8.79992 14.6668H8.33325V13.5002C8.33325 12.6717 7.66168 12.0002 6.83325 12.0002C6.00482 12.0002 5.33325 12.6717 5.33325 13.5002V14.6668H4.53325C3.41315 14.6668 2.85309 14.6668 2.42527 14.4488C2.04895 14.2571 1.74299 13.9511 1.55124 13.5748C1.33325 13.147 1.33325 12.5869 1.33325 11.4668V10.3335H2.33325C3.25373 10.3335 3.99992 9.5873 3.99992 8.66683C3.99992 7.74635 3.25373 7.00016 2.33325 7.00016H1.33325C1.33325 6.06828 1.33325 5.60234 1.48549 5.2348C1.68848 4.74474 2.07783 4.35539 2.56789 4.1524C2.93543 4.00016 3.40137 4.00016 4.33325 4.00016H4.99992V3.00016Z",
            stroke: _ctx.color,
            "stroke-width": "1.2",
            "stroke-linecap": "round",
            "stroke-linejoin": "round"
          }, null, 8, _hoisted_3$n)
        ]),
        _cache[0] || (_cache[0] = createElementVNode("defs", null, [
          createElementVNode("clipPath", { id: "clip0_1099_16244" }, [
            createElementVNode("rect", {
              width: "16",
              height: "16",
              fill: "white"
            })
          ])
        ], -1))
      ], 10, _hoisted_1$1f);
    };
  }
});
const releaseApiClient = axios.create({
  baseURL: COMFY_API_BASE_URL,
  headers: {
    "Content-Type": "application/json"
  }
});
const useReleaseService = /* @__PURE__ */ __name(() => {
  const isLoading = ref(false);
  const error = ref(null);
  const handleApiError = /* @__PURE__ */ __name((err, context2, routeSpecificErrors) => {
    if (!axios.isAxiosError(err))
      return err instanceof Error ? `${context2}: ${err.message}` : `${context2}: Unknown error occurred`;
    const axiosError = err;
    if (axiosError.response) {
      const { status, data } = axiosError.response;
      if (routeSpecificErrors && routeSpecificErrors[status])
        return routeSpecificErrors[status];
      switch (status) {
        case 400:
          return `Bad request: ${data?.message || "Invalid input"}`;
        case 401:
          return "Unauthorized: Authentication required";
        case 403:
          return `Forbidden: ${data?.message || "Access denied"}`;
        case 404:
          return `Not found: ${data?.message || "Resource not found"}`;
        case 500:
          return `Server error: ${data?.message || "Internal server error"}`;
        default:
          return `${context2}: ${data?.message || axiosError.message}`;
      }
    }
    return `${context2}: ${axiosError.message}`;
  }, "handleApiError");
  const executeApiRequest = /* @__PURE__ */ __name(async (apiCall, errorContext, routeSpecificErrors) => {
    isLoading.value = true;
    error.value = null;
    try {
      const response = await apiCall();
      return response.data;
    } catch (err) {
      if (isAbortError(err)) return null;
      error.value = handleApiError(err, errorContext, routeSpecificErrors);
      return null;
    } finally {
      isLoading.value = false;
    }
  }, "executeApiRequest");
  const getReleases = /* @__PURE__ */ __name(async (params, signal) => {
    const endpoint = "/releases";
    const errorContext = "Failed to get releases";
    const routeSpecificErrors = {
      400: "Invalid project or version parameter"
    };
    const apiResponse = await executeApiRequest(
      () => releaseApiClient.get(endpoint, {
        params,
        signal
      }),
      errorContext,
      routeSpecificErrors
    );
    return apiResponse;
  }, "getReleases");
  return {
    isLoading,
    error,
    getReleases
  };
}, "useReleaseService");
const useReleaseStore = defineStore("release", () => {
  const releases = ref([]);
  const isLoading = ref(false);
  const error = ref(null);
  const releaseService = useReleaseService();
  const systemStatsStore = useSystemStatsStore();
  const settingStore = useSettingStore();
  const currentComfyUIVersion = computed(
    () => systemStatsStore?.systemStats?.system?.comfyui_version ?? ""
  );
  const locale = computed(() => settingStore.get("Comfy.Locale"));
  const releaseVersion = computed(
    () => settingStore.get("Comfy.Release.Version")
  );
  const releaseStatus = computed(() => settingStore.get("Comfy.Release.Status"));
  const releaseTimestamp = computed(
    () => settingStore.get("Comfy.Release.Timestamp")
  );
  const showVersionUpdates = computed(
    () => settingStore.get("Comfy.Notification.ShowVersionUpdates")
  );
  const recentRelease = computed(() => {
    return releases.value[0] ?? null;
  });
  const recentReleases = computed(() => {
    return releases.value.slice(0, 3);
  });
  const THREE_DAYS_MS = 3 * 24 * 60 * 60 * 1e3;
  const isNewVersionAvailable = computed(
    () => !!recentRelease.value && compareVersions(
      recentRelease.value.version,
      currentComfyUIVersion.value
    ) > 0
  );
  const isLatestVersion = computed(
    () => !!recentRelease.value && !compareVersions(recentRelease.value.version, currentComfyUIVersion.value)
  );
  const hasMediumOrHighAttention = computed(
    () => recentReleases.value.slice(0, -1).some(
      (release) => release.attention === "medium" || release.attention === "high"
    )
  );
  const shouldShowToast = computed(() => {
    if (!isElectron()) {
      return false;
    }
    if (!showVersionUpdates.value) {
      return false;
    }
    if (!isNewVersionAvailable.value) {
      return false;
    }
    if (!hasMediumOrHighAttention.value) {
      return false;
    }
    if (releaseVersion.value === recentRelease.value?.version && ["skipped", "changelog seen"].includes(releaseStatus.value)) {
      return false;
    }
    return true;
  });
  const shouldShowRedDot = computed(() => {
    if (!isElectron()) {
      return false;
    }
    if (!showVersionUpdates.value) {
      return false;
    }
    if (!isNewVersionAvailable.value) {
      return false;
    }
    const { version } = recentRelease.value;
    if (releaseVersion.value === version && releaseStatus.value === "changelog seen") {
      return false;
    }
    if (hasMediumOrHighAttention.value) {
      return true;
    }
    if (releaseVersion.value === version && releaseStatus.value === "skipped" && releaseTimestamp.value && Date.now() - releaseTimestamp.value >= THREE_DAYS_MS) {
      return false;
    }
    return true;
  });
  const shouldShowPopup = computed(() => {
    if (!isElectron()) {
      return false;
    }
    if (!showVersionUpdates.value) {
      return false;
    }
    if (!isLatestVersion.value) {
      return false;
    }
    if (releaseVersion.value === recentRelease.value.version && releaseStatus.value === "what's new seen") {
      return false;
    }
    return true;
  });
  async function handleSkipRelease(version) {
    if (version !== recentRelease.value?.version || releaseStatus.value === "changelog seen") {
      return;
    }
    await settingStore.set("Comfy.Release.Version", version);
    await settingStore.set("Comfy.Release.Status", "skipped");
    await settingStore.set("Comfy.Release.Timestamp", Date.now());
  }
  __name(handleSkipRelease, "handleSkipRelease");
  async function handleShowChangelog(version) {
    if (version !== recentRelease.value?.version) {
      return;
    }
    await settingStore.set("Comfy.Release.Version", version);
    await settingStore.set("Comfy.Release.Status", "changelog seen");
    await settingStore.set("Comfy.Release.Timestamp", Date.now());
  }
  __name(handleShowChangelog, "handleShowChangelog");
  async function handleWhatsNewSeen(version) {
    if (version !== recentRelease.value?.version) {
      return;
    }
    await settingStore.set("Comfy.Release.Version", version);
    await settingStore.set("Comfy.Release.Status", "what's new seen");
    await settingStore.set("Comfy.Release.Timestamp", Date.now());
  }
  __name(handleWhatsNewSeen, "handleWhatsNewSeen");
  async function fetchReleases() {
    if (isLoading.value) {
      return;
    }
    if (!showVersionUpdates.value) {
      return;
    }
    if (systemStatsStore.systemStats?.system?.argv?.includes(
      "--disable-api-nodes"
    )) {
      return;
    }
    isLoading.value = true;
    error.value = null;
    try {
      if (!systemStatsStore.systemStats) {
        await until$1(systemStatsStore.isInitialized);
      }
      const fetchedReleases = await releaseService.getReleases({
        project: "comfyui",
        current_version: currentComfyUIVersion.value,
        form_factor: systemStatsStore.getFormFactor(),
        locale: stringToLocale(locale.value)
      });
      if (fetchedReleases !== null) {
        releases.value = fetchedReleases;
      } else if (releaseService.error.value) {
        error.value = releaseService.error.value;
      }
    } catch (err) {
      error.value = err instanceof Error ? err.message : "Unknown error occurred";
    } finally {
      isLoading.value = false;
    }
  }
  __name(fetchReleases, "fetchReleases");
  async function initialize() {
    await fetchReleases();
  }
  __name(initialize, "initialize");
  return {
    releases,
    isLoading,
    error,
    recentRelease,
    recentReleases,
    shouldShowToast,
    shouldShowRedDot,
    shouldShowPopup,
    shouldShowUpdateButton: isNewVersionAvailable,
    handleSkipRelease,
    handleShowChangelog,
    handleWhatsNewSeen,
    fetchReleases,
    initialize
  };
});
const releaseStore = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  useReleaseStore
}, Symbol.toStringTag, { value: "Module" }));
const _hoisted_1$1e = {
  class: "help-center-menu",
  role: "menu",
  "aria-label": "Help Center Menu"
};
const _hoisted_2$B = {
  class: "help-menu-section",
  role: "menubar"
};
const _hoisted_3$m = ["onClick", "onMouseenter", "onMouseleave"];
const _hoisted_4$h = { class: "help-menu-icon-container" };
const _hoisted_5$a = { class: "help-menu-icon" };
const _hoisted_6$7 = {
  key: 0,
  class: "menu-red-dot"
};
const _hoisted_7$5 = { class: "menu-label" };
const _hoisted_8$5 = {
  key: 0,
  class: "pi pi-chevron-right"
};
const _hoisted_9$4 = {
  key: 0,
  class: "submenu-divider"
};
const _hoisted_10$4 = ["onClick"];
const _hoisted_11$3 = { class: "menu-label" };
const _hoisted_12$2 = {
  key: 0,
  class: "whats-new-section"
};
const _hoisted_13$2 = { class: "section-description" };
const _hoisted_14$2 = {
  key: 0,
  role: "group",
  "aria-label": "Recent releases"
};
const _hoisted_15$2 = ["onClick", "onKeydown"];
const _hoisted_16$2 = { class: "release-content" };
const _hoisted_17$1 = { class: "release-title" };
const _hoisted_18$1 = ["datetime"];
const _hoisted_19$1 = { class: "normal-state" };
const _hoisted_20$1 = { class: "hover-state" };
const _hoisted_21$1 = {
  key: 1,
  class: "help-menu-item",
  role: "status",
  "aria-live": "polite"
};
const _hoisted_22$1 = {
  key: 2,
  class: "help-menu-item",
  role: "status"
};
const _sfc_main$19 = /* @__PURE__ */ defineComponent({
  __name: "HelpCenterMenuContent",
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const EXTERNAL_LINKS = {
      DOCS: "https://docs.comfy.org/",
      DISCORD: "https://www.comfy.org/discord",
      GITHUB: "https://github.com/comfyanonymous/ComfyUI",
      DESKTOP_GUIDE: "https://comfyorg.notion.site/",
      UPDATE_GUIDE: "https://docs.comfy.org/installation/update_comfyui"
    };
    const TIME_UNITS = {
      MINUTE: 60 * 1e3,
      HOUR: 60 * 60 * 1e3,
      DAY: 24 * 60 * 60 * 1e3,
      WEEK: 7 * 24 * 60 * 60 * 1e3,
      MONTH: 30 * 24 * 60 * 60 * 1e3,
      YEAR: 365 * 24 * 60 * 60 * 1e3
    };
    const SUBMENU_CONFIG = {
      DELAY_MS: 100,
      OFFSET_PX: 8,
      Z_INDEX: 10001
    };
    const { t: t2, locale } = useI18n();
    const releaseStore2 = useReleaseStore();
    const commandStore = useCommandStore();
    const settingStore = useSettingStore();
    const emit = __emit;
    const isSubmenuVisible = ref(false);
    const submenuRef = ref(null);
    const submenuStyle = ref({});
    let hoverTimeout = null;
    const hasReleases = computed(() => releaseStore2.releases.length > 0);
    const showVersionUpdates = computed(
      () => settingStore.get("Comfy.Notification.ShowVersionUpdates")
    );
    const { shouldShowRedDot: shouldShowManagerRedDot } = useConflictAcknowledgment();
    const moreItems = computed(() => {
      const allMoreItems = [
        {
          key: "desktop-guide",
          type: "item",
          label: t2("helpCenter.desktopUserGuide"),
          visible: isElectron(),
          action: /* @__PURE__ */ __name(() => {
            openExternalLink(EXTERNAL_LINKS.DESKTOP_GUIDE);
            emit("close");
          }, "action")
        },
        {
          key: "dev-tools",
          type: "item",
          label: t2("helpCenter.openDevTools"),
          visible: isElectron(),
          action: /* @__PURE__ */ __name(() => {
            openDevTools();
            emit("close");
          }, "action")
        },
        {
          key: "divider-1",
          type: "divider",
          visible: isElectron()
        },
        {
          key: "reinstall",
          type: "item",
          label: t2("helpCenter.reinstall"),
          visible: isElectron(),
          action: /* @__PURE__ */ __name(() => {
            onReinstall();
            emit("close");
          }, "action")
        }
      ];
      return allMoreItems.filter((item) => item.visible !== false);
    });
    const hasVisibleMoreItems = computed(() => {
      return !!moreItems.value.length;
    });
    const moreMenuItem = computed(
      () => menuItems.value.find((item) => item.key === "more")
    );
    const menuItems = computed(() => {
      return [
        {
          key: "docs",
          type: "item",
          icon: "pi pi-book",
          label: t2("helpCenter.docs"),
          action: /* @__PURE__ */ __name(() => {
            openExternalLink(EXTERNAL_LINKS.DOCS);
            emit("close");
          }, "action")
        },
        {
          key: "discord",
          type: "item",
          icon: "pi pi-discord",
          label: "Discord",
          action: /* @__PURE__ */ __name(() => {
            openExternalLink(EXTERNAL_LINKS.DISCORD);
            emit("close");
          }, "action")
        },
        {
          key: "github",
          type: "item",
          icon: "pi pi-github",
          label: t2("helpCenter.github"),
          action: /* @__PURE__ */ __name(() => {
            openExternalLink(EXTERNAL_LINKS.GITHUB);
            emit("close");
          }, "action")
        },
        {
          key: "help",
          type: "item",
          icon: "pi pi-question-circle",
          label: t2("helpCenter.helpFeedback"),
          action: /* @__PURE__ */ __name(() => {
            void commandStore.execute("Comfy.ContactSupport");
            emit("close");
          }, "action")
        },
        {
          key: "manager",
          type: "item",
          icon: _sfc_main$1a,
          label: t2("helpCenter.managerExtension"),
          showRedDot: shouldShowManagerRedDot.value,
          action: /* @__PURE__ */ __name(async () => {
            await useManagerState().openManager({
              initialTab: ManagerTab.All,
              showToastOnLegacyError: false
            });
            emit("close");
          }, "action")
        },
        {
          key: "more",
          type: "item",
          icon: "",
          label: t2("helpCenter.more"),
          visible: hasVisibleMoreItems.value,
          action: /* @__PURE__ */ __name(() => {
          }, "action"),
          // No action for more item
          items: moreItems.value
        }
      ];
    });
    const openExternalLink = /* @__PURE__ */ __name((url) => {
      window.open(url, "_blank", "noopener,noreferrer");
    }, "openExternalLink");
    const clearHoverTimeout = /* @__PURE__ */ __name(() => {
      if (hoverTimeout) {
        clearTimeout(hoverTimeout);
        hoverTimeout = null;
      }
    }, "clearHoverTimeout");
    const calculateSubmenuPosition = /* @__PURE__ */ __name((button) => {
      const rect = button.getBoundingClientRect();
      const submenuWidth = 210;
      const visibleItemCount = moreMenuItem.value?.items?.filter((item) => item.visible !== false).length || 0;
      const estimatedHeight = visibleItemCount * 48 + 16;
      const submenuHeight = submenuRef.value?.offsetHeight || estimatedHeight;
      const viewportWidth = window.innerWidth;
      const viewportHeight = window.innerHeight;
      let top = rect.top;
      let left = rect.right + SUBMENU_CONFIG.OFFSET_PX;
      if (left + submenuWidth > viewportWidth) {
        left = rect.left - submenuWidth - SUBMENU_CONFIG.OFFSET_PX;
      }
      if (top + submenuHeight > viewportHeight) {
        top = Math.max(
          SUBMENU_CONFIG.OFFSET_PX,
          // Minimum distance from top of viewport
          rect.bottom - submenuHeight
        );
      }
      if (top < SUBMENU_CONFIG.OFFSET_PX) {
        top = SUBMENU_CONFIG.OFFSET_PX;
      }
      top -= 8;
      return {
        position: "fixed",
        top: `${top}px`,
        left: `${left}px`,
        zIndex: SUBMENU_CONFIG.Z_INDEX
      };
    }, "calculateSubmenuPosition");
    const formatReleaseDate = /* @__PURE__ */ __name((dateString) => {
      if (!dateString) return "date";
      const date = new Date(dateString);
      const now2 = /* @__PURE__ */ new Date();
      const diffTime = Math.abs(now2.getTime() - date.getTime());
      const timeUnits = [
        { unit: TIME_UNITS.YEAR, suffix: "y" },
        { unit: TIME_UNITS.MONTH, suffix: "mo" },
        { unit: TIME_UNITS.WEEK, suffix: "w" },
        { unit: TIME_UNITS.DAY, suffix: "d" },
        { unit: TIME_UNITS.HOUR, suffix: "h" },
        { unit: TIME_UNITS.MINUTE, suffix: "min" }
      ];
      for (const { unit, suffix } of timeUnits) {
        const value = Math.floor(diffTime / unit);
        if (value > 0) {
          return `${value}${suffix} ago`;
        }
      }
      return "now";
    }, "formatReleaseDate");
    const shouldShowUpdateButton = /* @__PURE__ */ __name((release) => {
      return releaseStore2.shouldShowUpdateButton && release === releaseStore2.recentReleases[0];
    }, "shouldShowUpdateButton");
    const onMenuItemHover = /* @__PURE__ */ __name(async (key, event) => {
      if (key !== "more" || !moreMenuItem.value?.items) return;
      const hasVisibleItems = moreMenuItem.value.items.some(
        (item) => item.visible !== false
      );
      if (!hasVisibleItems) return;
      clearHoverTimeout();
      const moreButton = event.currentTarget;
      submenuStyle.value = calculateSubmenuPosition(moreButton);
      isSubmenuVisible.value = true;
      await nextTick();
      if (submenuRef.value) {
        submenuStyle.value = calculateSubmenuPosition(moreButton);
      }
    }, "onMenuItemHover");
    const onMenuItemLeave = /* @__PURE__ */ __name((key) => {
      if (key !== "more") return;
      hoverTimeout = window.setTimeout(() => {
        isSubmenuVisible.value = false;
      }, SUBMENU_CONFIG.DELAY_MS);
    }, "onMenuItemLeave");
    const onSubmenuHover = /* @__PURE__ */ __name(() => {
      clearHoverTimeout();
    }, "onSubmenuHover");
    const onSubmenuLeave = /* @__PURE__ */ __name(() => {
      isSubmenuVisible.value = false;
    }, "onSubmenuLeave");
    const openDevTools = /* @__PURE__ */ __name(() => {
      if (isElectron()) {
        electronAPI().openDevTools();
      }
    }, "openDevTools");
    const onReinstall = /* @__PURE__ */ __name(() => {
      if (isElectron()) {
        void electronAPI().reinstall();
      }
    }, "onReinstall");
    const onReleaseClick = /* @__PURE__ */ __name((release) => {
      void releaseStore2.handleShowChangelog(release.version);
      const versionAnchor = formatVersionAnchor(release.version);
      const changelogUrl = `${getChangelogUrl()}#${versionAnchor}`;
      openExternalLink(changelogUrl);
      emit("close");
    }, "onReleaseClick");
    const onUpdate = /* @__PURE__ */ __name((_) => {
      openExternalLink(EXTERNAL_LINKS.UPDATE_GUIDE);
      emit("close");
    }, "onUpdate");
    const getChangelogUrl = /* @__PURE__ */ __name(() => {
      const isChineseLocale = locale.value === "zh";
      return isChineseLocale ? "https://docs.comfy.org/zh-CN/changelog" : "https://docs.comfy.org/changelog";
    }, "getChangelogUrl");
    onMounted(async () => {
      if (!hasReleases.value) {
        await releaseStore2.fetchReleases();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1e, [
        createElementVNode("nav", _hoisted_2$B, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(menuItems.value, (menuItem) => {
            return withDirectives((openBlock(), createElementBlock("button", {
              key: menuItem.key,
              type: "button",
              class: normalizeClass(["help-menu-item", { "more-item": menuItem.key === "more" }]),
              role: "menuitem",
              onClick: menuItem.action,
              onMouseenter: /* @__PURE__ */ __name(($event) => onMenuItemHover(menuItem.key, $event), "onMouseenter"),
              onMouseleave: /* @__PURE__ */ __name(($event) => onMenuItemLeave(menuItem.key), "onMouseleave")
            }, [
              createElementVNode("div", _hoisted_4$h, [
                createElementVNode("div", _hoisted_5$a, [
                  typeof menuItem.icon === "object" ? (openBlock(), createBlock(resolveDynamicComponent(menuItem.icon), {
                    key: 0,
                    size: 16
                  })) : (openBlock(), createElementBlock("i", {
                    key: 1,
                    class: normalizeClass(menuItem.icon)
                  }, null, 2))
                ]),
                menuItem.showRedDot ? (openBlock(), createElementBlock("div", _hoisted_6$7)) : createCommentVNode("", true)
              ]),
              createElementVNode("span", _hoisted_7$5, toDisplayString(menuItem.label), 1),
              menuItem.key === "more" ? (openBlock(), createElementBlock("i", _hoisted_8$5)) : createCommentVNode("", true)
            ], 42, _hoisted_3$m)), [
              [vShow, menuItem.visible !== false]
            ]);
          }), 128))
        ]),
        (openBlock(), createBlock(Teleport, { to: "body" }, [
          isSubmenuVisible.value ? (openBlock(), createElementBlock("div", {
            key: 0,
            ref_key: "submenuRef",
            ref: submenuRef,
            class: "more-submenu",
            style: normalizeStyle(submenuStyle.value),
            onMouseenter: onSubmenuHover,
            onMouseleave: onSubmenuLeave
          }, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(moreMenuItem.value?.items, (submenuItem) => {
              return openBlock(), createElementBlock(Fragment, {
                key: submenuItem.key
              }, [
                submenuItem.type === "divider" ? withDirectives((openBlock(), createElementBlock("div", _hoisted_9$4, null, 512)), [
                  [vShow, submenuItem.visible !== false]
                ]) : withDirectives((openBlock(), createElementBlock("button", {
                  key: 1,
                  type: "button",
                  class: "help-menu-item submenu-item",
                  role: "menuitem",
                  onClick: submenuItem.action
                }, [
                  createElementVNode("span", _hoisted_11$3, toDisplayString(submenuItem.label), 1)
                ], 8, _hoisted_10$4)), [
                  [vShow, submenuItem.visible !== false]
                ])
              ], 64);
            }), 128))
          ], 36)) : createCommentVNode("", true)
        ])),
        showVersionUpdates.value ? (openBlock(), createElementBlock("section", _hoisted_12$2, [
          createElementVNode("h3", _hoisted_13$2, toDisplayString(_ctx.$t("helpCenter.whatsNew")), 1),
          hasReleases.value ? (openBlock(), createElementBlock("div", _hoisted_14$2, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(releaseStore2).recentReleases, (release) => {
              return openBlock(), createElementBlock("article", {
                key: release.id || release.version,
                class: "help-menu-item release-menu-item",
                role: "button",
                tabindex: "0",
                onClick: /* @__PURE__ */ __name(($event) => onReleaseClick(release), "onClick"),
                onKeydown: [
                  withKeys(($event) => onReleaseClick(release), ["enter"]),
                  withKeys(withModifiers(($event) => onReleaseClick(release), ["prevent"]), ["space"])
                ]
              }, [
                _cache[0] || (_cache[0] = createElementVNode("i", {
                  class: "pi pi-refresh help-menu-icon",
                  "aria-hidden": "true"
                }, null, -1)),
                createElementVNode("div", _hoisted_16$2, [
                  createElementVNode("span", _hoisted_17$1, toDisplayString(_ctx.$t("g.releaseTitle", {
                    package: "Comfy",
                    version: release.version
                  })), 1),
                  createElementVNode("time", {
                    class: "release-date",
                    datetime: release.published_at
                  }, [
                    createElementVNode("span", _hoisted_19$1, toDisplayString(formatReleaseDate(release.published_at)), 1),
                    createElementVNode("span", _hoisted_20$1, toDisplayString(_ctx.$t("helpCenter.clickToLearnMore")), 1)
                  ], 8, _hoisted_18$1)
                ]),
                shouldShowUpdateButton(release) ? (openBlock(), createBlock(unref(Button), {
                  key: 0,
                  label: _ctx.$t("helpCenter.updateAvailable"),
                  size: "small",
                  class: "update-button",
                  onClick: withModifiers(($event) => onUpdate(release), ["stop"])
                }, null, 8, ["label", "onClick"])) : createCommentVNode("", true)
              ], 40, _hoisted_15$2);
            }), 128))
          ])) : unref(releaseStore2).isLoading ? (openBlock(), createElementBlock("div", _hoisted_21$1, [
            _cache[1] || (_cache[1] = createElementVNode("i", {
              class: "pi pi-spin pi-spinner help-menu-icon",
              "aria-hidden": "true"
            }, null, -1)),
            createElementVNode("span", null, toDisplayString(_ctx.$t("helpCenter.loadingReleases")), 1)
          ])) : (openBlock(), createElementBlock("div", _hoisted_22$1, [
            _cache[2] || (_cache[2] = createElementVNode("i", {
              class: "pi pi-info-circle help-menu-icon",
              "aria-hidden": "true"
            }, null, -1)),
            createElementVNode("span", null, toDisplayString(_ctx.$t("helpCenter.noRecentReleases")), 1)
          ]))
        ])) : createCommentVNode("", true)
      ]);
    };
  }
});
const HelpCenterMenuContent = /* @__PURE__ */ _export_sfc(_sfc_main$19, [["__scopeId", "data-v-46dab195"]]);
const _hoisted_1$1d = {
  key: 0,
  class: "release-toast-popup"
};
const _hoisted_2$A = { class: "release-notification-toast" };
const _hoisted_3$l = { class: "toast-header" };
const _hoisted_4$g = { class: "toast-text" };
const _hoisted_5$9 = { class: "toast-title" };
const _hoisted_6$6 = { class: "toast-version-badge" };
const _hoisted_7$4 = { class: "toast-actions-section" };
const _hoisted_8$4 = { class: "actions-row" };
const _hoisted_9$3 = { class: "left-actions" };
const _hoisted_10$3 = ["href"];
const _hoisted_11$2 = { class: "right-actions" };
const _sfc_main$18 = /* @__PURE__ */ defineComponent({
  __name: "ReleaseNotificationToast",
  setup(__props) {
    const { locale } = useI18n();
    const releaseStore2 = useReleaseStore();
    const isDismissed = ref(false);
    const latestRelease = computed(
      () => releaseStore2.recentRelease
    );
    const shouldShow = computed(
      () => releaseStore2.shouldShowToast && !isDismissed.value
    );
    const changelogUrl = computed(() => {
      const isChineseLocale = locale.value === "zh";
      const baseUrl = isChineseLocale ? "https://docs.comfy.org/zh-CN/changelog" : "https://docs.comfy.org/changelog";
      if (latestRelease.value?.version) {
        const versionAnchor = formatVersionAnchor(latestRelease.value.version);
        return `${baseUrl}#${versionAnchor}`;
      }
      return baseUrl;
    });
    let hideTimer = null;
    const startAutoHide = /* @__PURE__ */ __name(() => {
      if (hideTimer) clearTimeout(hideTimer);
      hideTimer = setTimeout(() => {
        dismissToast();
      }, 8e3);
    }, "startAutoHide");
    const clearAutoHide = /* @__PURE__ */ __name(() => {
      if (hideTimer) {
        clearTimeout(hideTimer);
        hideTimer = null;
      }
    }, "clearAutoHide");
    const dismissToast = /* @__PURE__ */ __name(() => {
      isDismissed.value = true;
      clearAutoHide();
    }, "dismissToast");
    const handleSkip = /* @__PURE__ */ __name(() => {
      if (latestRelease.value) {
        void releaseStore2.handleSkipRelease(latestRelease.value.version);
      }
      dismissToast();
    }, "handleSkip");
    const handleLearnMore = /* @__PURE__ */ __name(() => {
      if (latestRelease.value) {
        void releaseStore2.handleShowChangelog(latestRelease.value.version);
      }
      dismissToast();
    }, "handleLearnMore");
    const handleUpdate = /* @__PURE__ */ __name(() => {
      window.open("https://docs.comfy.org/installation/update_comfyui", "_blank");
      dismissToast();
    }, "handleUpdate");
    watch(shouldShow, (isVisible) => {
      if (isVisible) {
        startAutoHide();
      } else {
        clearAutoHide();
      }
    });
    onMounted(async () => {
      if (!releaseStore2.releases.length) {
        await releaseStore2.fetchReleases();
      }
    });
    return (_ctx, _cache) => {
      return shouldShow.value ? (openBlock(), createElementBlock("div", _hoisted_1$1d, [
        createElementVNode("div", _hoisted_2$A, [
          createElementVNode("div", _hoisted_3$l, [
            _cache[0] || (_cache[0] = createElementVNode("div", { class: "toast-icon" }, [
              createElementVNode("i", { class: "pi pi-download" })
            ], -1)),
            createElementVNode("div", _hoisted_4$g, [
              createElementVNode("div", _hoisted_5$9, toDisplayString(_ctx.$t("releaseToast.newVersionAvailable")), 1),
              createElementVNode("div", _hoisted_6$6, toDisplayString(latestRelease.value?.version), 1)
            ])
          ]),
          createElementVNode("div", _hoisted_7$4, [
            createElementVNode("div", _hoisted_8$4, [
              createElementVNode("div", _hoisted_9$3, [
                createElementVNode("a", {
                  class: "learn-more-link",
                  href: changelogUrl.value,
                  target: "_blank",
                  rel: "noopener,noreferrer",
                  onClick: handleLearnMore
                }, toDisplayString(_ctx.$t("releaseToast.whatsNew")), 9, _hoisted_10$3)
              ]),
              createElementVNode("div", _hoisted_11$2, [
                createElementVNode("button", {
                  class: "skip-button",
                  onClick: handleSkip
                }, toDisplayString(_ctx.$t("releaseToast.skip")), 1),
                createElementVNode("button", {
                  class: "cta-button",
                  onClick: handleUpdate
                }, toDisplayString(_ctx.$t("releaseToast.update")), 1)
              ])
            ])
          ])
        ])
      ])) : createCommentVNode("", true);
    };
  }
});
const ReleaseNotificationToast = /* @__PURE__ */ _export_sfc(_sfc_main$18, [["__scopeId", "data-v-a3d4724f"]]);
const _hoisted_1$1c = {
  key: 0,
  class: "whats-new-popup-container"
};
const _hoisted_2$z = ["aria-label"];
const _hoisted_3$k = { class: "popup-content" };
const _hoisted_4$f = ["innerHTML"];
const _hoisted_5$8 = { class: "popup-actions" };
const _hoisted_6$5 = ["href"];
const _sfc_main$17 = /* @__PURE__ */ defineComponent({
  __name: "WhatsNewPopup",
  emits: ["whats-new-dismissed"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const { locale, t: t2 } = useI18n();
    const releaseStore2 = useReleaseStore();
    const emit = __emit;
    const isDismissed = ref(false);
    const latestRelease = computed(
      () => releaseStore2.recentRelease
    );
    const shouldShow = computed(
      () => releaseStore2.shouldShowPopup && !isDismissed.value
    );
    const changelogUrl = computed(() => {
      const isChineseLocale = locale.value === "zh";
      const baseUrl = isChineseLocale ? "https://docs.comfy.org/zh-CN/changelog" : "https://docs.comfy.org/changelog";
      if (latestRelease.value?.version) {
        const versionAnchor = formatVersionAnchor(latestRelease.value.version);
        return `${baseUrl}#${versionAnchor}`;
      }
      return baseUrl;
    });
    const formattedContent = computed(() => {
      if (!latestRelease.value?.content) {
        return `<p>${t2("whatsNewPopup.noReleaseNotes")}</p>`;
      }
      try {
        return marked(latestRelease.value.content, {
          gfm: true
          // Enable GitHub Flavored Markdown
        });
      } catch (error) {
        console.error("Error parsing markdown:", error);
        return latestRelease.value.content.replace(/\n/g, "<br>");
      }
    });
    const show = /* @__PURE__ */ __name(() => {
      isDismissed.value = false;
    }, "show");
    const hide2 = /* @__PURE__ */ __name(() => {
      isDismissed.value = true;
      emit("whats-new-dismissed");
    }, "hide");
    const closePopup = /* @__PURE__ */ __name(async () => {
      if (latestRelease.value) {
        await releaseStore2.handleWhatsNewSeen(latestRelease.value.version);
      }
      hide2();
    }, "closePopup");
    onMounted(async () => {
      if (!releaseStore2.releases.length) {
        await releaseStore2.fetchReleases();
      }
    });
    __expose({
      show,
      hide: hide2
    });
    return (_ctx, _cache) => {
      return shouldShow.value ? (openBlock(), createElementBlock("div", _hoisted_1$1c, [
        _cache[2] || (_cache[2] = createStaticVNode('<div class="help-center-arrow" data-v-90a7c5ff><svg xmlns="http://www.w3.org/2000/svg" width="16" height="19" viewBox="0 0 16 19" fill="none" data-v-90a7c5ff><path d="M15.25 1.27246L15.25 17.7275L0.999023 9.5L15.25 1.27246Z" fill="#353535" data-v-90a7c5ff></path><path d="M15.25 1.27246L0.999023 9.5" stroke="#4e4e4e" stroke-width="1" fill="none" data-v-90a7c5ff></path><path d="M0.999023 9.5L15.25 17.7275" stroke="#4e4e4e" stroke-width="1" fill="none" data-v-90a7c5ff></path></svg></div>', 1)),
        createElementVNode("div", {
          class: "whats-new-popup",
          onClick: _cache[0] || (_cache[0] = withModifiers(() => {
          }, ["stop"]))
        }, [
          createElementVNode("button", {
            class: "close-button",
            "aria-label": _ctx.$t("g.close"),
            onClick: closePopup
          }, _cache[1] || (_cache[1] = [
            createElementVNode("div", { class: "close-icon" }, null, -1)
          ]), 8, _hoisted_2$z),
          createElementVNode("div", _hoisted_3$k, [
            createElementVNode("div", {
              class: "content-text",
              innerHTML: formattedContent.value
            }, null, 8, _hoisted_4$f),
            createElementVNode("div", _hoisted_5$8, [
              createElementVNode("a", {
                class: "learn-more-link",
                href: changelogUrl.value,
                target: "_blank",
                rel: "noopener,noreferrer",
                onClick: closePopup
              }, toDisplayString(_ctx.$t("whatsNewPopup.learnMore")), 9, _hoisted_6$5)
            ])
          ])
        ])
      ])) : createCommentVNode("", true);
    };
  }
});
const WhatsNewPopup = /* @__PURE__ */ _export_sfc(_sfc_main$17, [["__scopeId", "data-v-90a7c5ff"]]);
const useHelpCenterStore = defineStore("helpCenter", () => {
  const isVisible = ref(false);
  const toggle = /* @__PURE__ */ __name(() => {
    isVisible.value = !isVisible.value;
  }, "toggle");
  const show = /* @__PURE__ */ __name(() => {
    isVisible.value = true;
  }, "show");
  const hide2 = /* @__PURE__ */ __name(() => {
    isVisible.value = false;
  }, "hide");
  return {
    isVisible,
    toggle,
    show,
    hide: hide2
  };
});
const _sfc_main$16 = /* @__PURE__ */ defineComponent({
  __name: "SidebarHelpCenterIcon",
  setup(__props) {
    const settingStore = useSettingStore();
    const releaseStore2 = useReleaseStore();
    const helpCenterStore = useHelpCenterStore();
    const { isVisible: isHelpCenterVisible } = storeToRefs(helpCenterStore);
    const { shouldShowRedDot: showReleaseRedDot } = storeToRefs(releaseStore2);
    const conflictDetection = useConflictDetection();
    const { showNodeConflictDialog } = useDialogService();
    const { shouldShowRedDot: shouldShowConflictRedDot, markConflictsAsSeen } = useConflictAcknowledgment();
    const shouldShowRedDot = computed(() => {
      const releaseRedDot = showReleaseRedDot.value;
      return releaseRedDot || shouldShowConflictRedDot.value;
    });
    const sidebarLocation = computed(
      () => settingStore.get("Comfy.Sidebar.Location")
    );
    const sidebarSize = computed(() => settingStore.get("Comfy.Sidebar.Size"));
    const toggleHelpCenter = /* @__PURE__ */ __name(() => {
      helpCenterStore.toggle();
    }, "toggleHelpCenter");
    const closeHelpCenter = /* @__PURE__ */ __name(() => {
      helpCenterStore.hide();
    }, "closeHelpCenter");
    const handleWhatsNewDismissed = /* @__PURE__ */ __name(async () => {
      try {
        const shouldShow = await conflictDetection.shouldShowConflictModalAfterUpdate();
        if (shouldShow) {
          showConflictModal();
        }
      } catch (error) {
        console.error("[HelpCenter] Error checking conflict modal:", error);
      }
    }, "handleWhatsNewDismissed");
    const showConflictModal = /* @__PURE__ */ __name(() => {
      showNodeConflictDialog({
        showAfterWhatsNew: true,
        dialogComponentProps: {
          onClose: /* @__PURE__ */ __name(() => {
            markConflictsAsSeen();
          }, "onClose")
        }
      });
    }, "showConflictModal");
    onMounted(async () => {
      await releaseStore2.initialize();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", null, [
        createVNode(SidebarIcon, {
          icon: "pi pi-question-circle",
          class: "comfy-help-center-btn",
          tooltip: _ctx.$t("sideToolbar.helpCenter"),
          "icon-badge": shouldShowRedDot.value ? "•" : "",
          onClick: toggleHelpCenter
        }, null, 8, ["tooltip", "icon-badge"]),
        (openBlock(), createBlock(Teleport, { to: "#graph-canvas-container" }, [
          unref(isHelpCenterVisible) ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass(["help-center-popup", {
              "sidebar-left": sidebarLocation.value === "left",
              "sidebar-right": sidebarLocation.value === "right",
              "small-sidebar": sidebarSize.value === "small"
            }])
          }, [
            createVNode(HelpCenterMenuContent, { onClose: closeHelpCenter })
          ], 2)) : createCommentVNode("", true)
        ])),
        (openBlock(), createBlock(Teleport, { to: "#graph-canvas-container" }, [
          createVNode(ReleaseNotificationToast, {
            class: normalizeClass({
              "sidebar-left": sidebarLocation.value === "left",
              "sidebar-right": sidebarLocation.value === "right",
              "small-sidebar": sidebarSize.value === "small"
            })
          }, null, 8, ["class"])
        ])),
        (openBlock(), createBlock(Teleport, { to: "#graph-canvas-container" }, [
          createVNode(WhatsNewPopup, {
            class: normalizeClass({
              "sidebar-left": sidebarLocation.value === "left",
              "sidebar-right": sidebarLocation.value === "right",
              "small-sidebar": sidebarSize.value === "small"
            }),
            onWhatsNewDismissed: handleWhatsNewDismissed
          }, null, 8, ["class"])
        ])),
        (openBlock(), createBlock(Teleport, { to: "body" }, [
          unref(isHelpCenterVisible) ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: "help-center-backdrop",
            onClick: closeHelpCenter
          })) : createCommentVNode("", true)
        ]))
      ]);
    };
  }
});
const SidebarHelpCenterIcon = /* @__PURE__ */ _export_sfc(_sfc_main$16, [["__scopeId", "data-v-49750eb6"]]);
const _sfc_main$15 = /* @__PURE__ */ defineComponent({
  __name: "SidebarLogoutIcon",
  setup(__props) {
    const { t: t2 } = useI18n();
    const userStore = useUserStore();
    const tooltip = computed(
      () => `${t2("sideToolbar.logout")} (${userStore.currentUser?.username})`
    );
    const logout = /* @__PURE__ */ __name(async () => {
      await userStore.logout();
      window.location.reload();
    }, "logout");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(SidebarIcon, {
        icon: "pi pi-sign-out",
        tooltip: tooltip.value,
        onClick: logout
      }, null, 8, ["tooltip"]);
    };
  }
});
const _sfc_main$14 = /* @__PURE__ */ defineComponent({
  __name: "SidebarTemplatesButton",
  setup(__props) {
    const settingStore = useSettingStore();
    const commandStore = useCommandStore();
    const isSmall = computed(
      () => settingStore.get("Comfy.Sidebar.Size") === "small"
    );
    const openTemplates = /* @__PURE__ */ __name(() => {
      void commandStore.execute("Comfy.BrowseTemplates");
    }, "openTemplates");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(SidebarIcon, {
        icon: "icon-[comfy--template]",
        tooltip: _ctx.$t("sideToolbar.templates"),
        label: _ctx.$t("sideToolbar.labels.templates"),
        "is-small": isSmall.value,
        class: "templates-tab-button",
        onClick: openTemplates
      }, null, 8, ["tooltip", "label", "is-small"]);
    };
  }
});
const _hoisted_1$1b = { class: "side-tool-bar-end" };
const _hoisted_2$y = {
  key: 0,
  class: "sidebar-content-container h-full overflow-y-auto overflow-x-hidden"
};
const _sfc_main$13 = /* @__PURE__ */ defineComponent({
  __name: "SideToolbar",
  setup(__props) {
    const workspaceStore = useWorkspaceStore();
    const settingStore = useSettingStore();
    const userStore = useUserStore();
    const teleportTarget = computed(
      () => settingStore.get("Comfy.Sidebar.Location") === "left" ? ".comfyui-body-left" : ".comfyui-body-right"
    );
    const isSmall = computed(
      () => settingStore.get("Comfy.Sidebar.Size") === "small"
    );
    const tabs = computed(() => workspaceStore.getSidebarTabs());
    const selectedTab = computed(() => workspaceStore.sidebarTab.activeSidebarTab);
    const onTabClick = /* @__PURE__ */ __name((item) => {
      workspaceStore.sidebarTab.toggleSidebarTab(item.id);
    }, "onTabClick");
    const keybindingStore = useKeybindingStore();
    const getTabTooltipSuffix = /* @__PURE__ */ __name((tab) => {
      const keybinding = keybindingStore.getKeybindingByCommandId(
        `Workspace.ToggleSidebarTab.${tab.id}`
      );
      return keybinding ? ` (${keybinding.combo.toString()})` : "";
    }, "getTabTooltipSuffix");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        (openBlock(), createBlock(Teleport, { to: teleportTarget.value }, [
          createElementVNode("nav", {
            class: normalizeClass(["side-tool-bar-container", { "small-sidebar": isSmall.value }])
          }, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(tabs.value, (tab) => {
              return openBlock(), createBlock(SidebarIcon, {
                key: tab.id,
                icon: tab.icon,
                "icon-badge": tab.iconBadge,
                tooltip: tab.tooltip,
                "tooltip-suffix": getTabTooltipSuffix(tab),
                label: tab.label || tab.title,
                "is-small": isSmall.value,
                selected: tab.id === selectedTab.value?.id,
                class: normalizeClass(tab.id + "-tab-button"),
                onClick: /* @__PURE__ */ __name(($event) => onTabClick(tab), "onClick")
              }, null, 8, ["icon", "icon-badge", "tooltip", "tooltip-suffix", "label", "is-small", "selected", "class", "onClick"]);
            }), 128)),
            createVNode(_sfc_main$14),
            createElementVNode("div", _hoisted_1$1b, [
              unref(userStore).isMultiUserServer ? (openBlock(), createBlock(_sfc_main$15, { key: 0 })) : createCommentVNode("", true),
              createVNode(SidebarHelpCenterIcon),
              createVNode(_sfc_main$1c),
              createVNode(_sfc_main$1b)
            ])
          ], 2)
        ], 8, ["to"])),
        selectedTab.value ? (openBlock(), createElementBlock("div", _hoisted_2$y, [
          createVNode(_sfc_main$1G, { extension: selectedTab.value }, null, 8, ["extension"])
        ])) : createCommentVNode("", true)
      ], 64);
    };
  }
});
const SideToolbar = /* @__PURE__ */ _export_sfc(_sfc_main$13, [["__scopeId", "data-v-e7d450fe"]]);
const _hoisted_1$1a = { class: "workflow-preview-content" };
const _hoisted_2$x = {
  key: 0,
  class: "workflow-preview-thumbnail relative"
};
const _hoisted_3$j = ["src"];
const _hoisted_4$e = { class: "workflow-preview-footer" };
const _hoisted_5$7 = { class: "workflow-preview-name" };
const POPOVER_WIDTH = 250;
const _sfc_main$12 = /* @__PURE__ */ defineComponent({
  __name: "WorkflowTabPopover",
  props: {
    workflowFilename: {},
    thumbnailUrl: {},
    isActiveTab: { type: Boolean }
  },
  setup(__props, { expose: __expose }) {
    const props2 = __props;
    const { thumbnailUrl, isActiveTab } = toRefs$1(props2);
    const settingStore = useSettingStore();
    const positions = computed(() => {
      if (settingStore.get("Comfy.Workflow.WorkflowTabsPosition") === "Topbar" && settingStore.get("Comfy.UseNewMenu") === "Bottom") {
        return {
          positioner: "top-0",
          root: "p-popover-flipped",
          active: isActiveTab.value ? "translateY(-100%)" : void 0
        };
      }
      return {
        positioner: "bottom-0"
      };
    });
    const popoverRef = ref(null);
    const positionRef = ref(null);
    let hideTimeout = null;
    let showTimeout = null;
    const id = useId$1();
    const showPopover = /* @__PURE__ */ __name((event) => {
      if (hideTimeout) {
        clearTimeout(hideTimeout);
        hideTimeout = null;
      }
      if (showTimeout) {
        clearTimeout(showTimeout);
        showTimeout = null;
      }
      showTimeout = setTimeout(async () => {
        if (popoverRef.value && positionRef.value) {
          popoverRef.value.show(event, positionRef.value);
          await nextTick();
          const el = document.querySelector(
            `.workflow-popover-fade[data-popover-id="${id}"]`
          );
          if (el) {
            const middle = positionRef.value.getBoundingClientRect().left;
            const popoverWidth = el.getBoundingClientRect().width;
            const halfWidth = popoverWidth / 2;
            let pos = middle - halfWidth;
            let shift2 = 0;
            if (pos < 0) {
              shift2 = pos - 8;
              pos = 8;
            } else if (pos + popoverWidth > window.innerWidth) {
              const newPos = window.innerWidth - popoverWidth - 16;
              shift2 = pos - newPos;
              pos = newPos;
            }
            if (shift2 + halfWidth < 0) {
              shift2 = -halfWidth + 24;
            }
            el.style.left = `${pos}px`;
            el.style.setProperty("--shift", `${shift2}px`);
          }
        }
      }, 200);
    }, "showPopover");
    const cancelHidePopover = /* @__PURE__ */ __name(() => {
    }, "cancelHidePopover");
    const hidePopover = /* @__PURE__ */ __name(() => {
      if (showTimeout) {
        clearTimeout(showTimeout);
        showTimeout = null;
      }
      hideTimeout = setTimeout(() => {
        if (popoverRef.value) {
          popoverRef.value.hide();
        }
      }, 100);
    }, "hidePopover");
    const togglePopover = /* @__PURE__ */ __name((event) => {
      if (popoverRef.value) {
        popoverRef.value.toggle(event);
      }
    }, "togglePopover");
    __expose({
      showPopover,
      hidePopover,
      togglePopover
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        createElementVNode("div", {
          ref_key: "positionRef",
          ref: positionRef,
          class: normalizeClass(["absolute left-1/2 -translate-x-1/2", positions.value.positioner])
        }, null, 2),
        createVNode(unref(Popover), {
          ref_key: "popoverRef",
          ref: popoverRef,
          "append-to": "body",
          pt: {
            root: {
              class: "workflow-popover-fade fit-content " + positions.value.root,
              "data-popover-id": unref(id),
              style: {
                transform: positions.value.active
              }
            }
          },
          onMouseenter: cancelHidePopover,
          onMouseleave: hidePopover
        }, {
          default: withCtx(() => [
            createElementVNode("div", _hoisted_1$1a, [
              unref(thumbnailUrl) && !unref(isActiveTab) ? (openBlock(), createElementBlock("div", _hoisted_2$x, [
                createElementVNode("img", {
                  src: unref(thumbnailUrl),
                  class: "block h-[200px] object-cover rounded-lg p-2",
                  style: normalizeStyle({ width: `${POPOVER_WIDTH}px` })
                }, null, 12, _hoisted_3$j)
              ])) : createCommentVNode("", true),
              createElementVNode("div", _hoisted_4$e, [
                createElementVNode("span", _hoisted_5$7, toDisplayString(_ctx.workflowFilename), 1)
              ])
            ])
          ]),
          _: 1
        }, 8, ["pt"])
      ], 64);
    };
  }
});
const WorkflowTabPopover = /* @__PURE__ */ _export_sfc(_sfc_main$12, [["__scopeId", "data-v-93115c74"]]);
const _hoisted_1$19 = { class: "workflow-label text-sm max-w-[150px] truncate inline-block" };
const _hoisted_2$w = { class: "relative" };
const _hoisted_3$i = {
  key: 0,
  class: "status-indicator"
};
const _sfc_main$11 = /* @__PURE__ */ defineComponent({
  __name: "WorkflowTab",
  props: {
    class: {},
    workflowOption: {}
  },
  setup(__props) {
    const props2 = __props;
    const { t: t2 } = useI18n();
    const workspaceStore = useWorkspaceStore();
    const workflowStore = useWorkflowStore();
    const settingStore = useSettingStore();
    const workflowTabRef = ref(null);
    const popoverRef = ref(null);
    const workflowThumbnail = useWorkflowThumbnail();
    const autoSaveSetting = computed(
      () => settingStore.get("Comfy.Workflow.AutoSave")
    );
    const autoSaveDelay = computed(
      () => settingStore.get("Comfy.Workflow.AutoSaveDelay")
    );
    const shouldShowStatusIndicator = computed(() => {
      if (workspaceStore.shiftDown) {
        return false;
      }
      if (!props2.workflowOption.workflow.isPersisted) {
        return true;
      }
      if (props2.workflowOption.workflow.isModified) {
        if (autoSaveSetting.value === "off") {
          return true;
        }
        if (autoSaveSetting.value === "after delay" && autoSaveDelay.value > 3e3) {
          return true;
        }
        return false;
      }
      return false;
    });
    const isActiveTab = computed(() => {
      return workflowStore.activeWorkflow?.key === props2.workflowOption.workflow.key;
    });
    const thumbnailUrl = computed(() => {
      return workflowThumbnail.getThumbnail(props2.workflowOption.workflow.key);
    });
    const handleMouseEnter = /* @__PURE__ */ __name((event) => {
      popoverRef.value?.showPopover(event);
    }, "handleMouseEnter");
    const handleMouseLeave = /* @__PURE__ */ __name(() => {
      popoverRef.value?.hidePopover();
    }, "handleMouseLeave");
    const handleClick = /* @__PURE__ */ __name((event) => {
      popoverRef.value?.togglePopover(event);
    }, "handleClick");
    const closeWorkflows = /* @__PURE__ */ __name(async (options) => {
      for (const opt of options) {
        if (!await useWorkflowService().closeWorkflow(opt.workflow, {
          warnIfUnsaved: !workspaceStore.shiftDown,
          hint: t2("sideToolbar.workflowTab.dirtyCloseHint")
        })) {
          break;
        }
      }
    }, "closeWorkflows");
    const onCloseWorkflow = /* @__PURE__ */ __name(async (option) => {
      await closeWorkflows([option]);
    }, "onCloseWorkflow");
    const tabGetter = /* @__PURE__ */ __name(() => workflowTabRef.value, "tabGetter");
    usePragmaticDraggable(tabGetter, {
      getInitialData: /* @__PURE__ */ __name(() => {
        return {
          workflowKey: props2.workflowOption.workflow.key
        };
      }, "getInitialData")
    });
    usePragmaticDroppable(tabGetter, {
      getData: /* @__PURE__ */ __name(() => {
        return {
          workflowKey: props2.workflowOption.workflow.key
        };
      }, "getData"),
      onDrop: /* @__PURE__ */ __name((e) => {
        const fromIndex = workflowStore.openWorkflows.findIndex(
          (wf) => wf.key === e.source.data.workflowKey
        );
        const toIndex = workflowStore.openWorkflows.findIndex(
          (wf) => wf.key === e.location.current.dropTargets[0]?.data.workflowKey
        );
        if (fromIndex !== toIndex) {
          workflowStore.reorderWorkflows(fromIndex, toIndex);
        }
      }, "onDrop")
    });
    onUnmounted(() => {
      popoverRef.value?.hidePopover();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        createElementVNode("div", mergeProps({
          ref_key: "workflowTabRef",
          ref: workflowTabRef,
          class: "flex p-2 gap-2 workflow-tab"
        }, _ctx.$attrs, {
          onMouseenter: handleMouseEnter,
          onMouseleave: handleMouseLeave,
          onClick: handleClick
        }), [
          createElementVNode("span", _hoisted_1$19, toDisplayString(_ctx.workflowOption.workflow.filename), 1),
          createElementVNode("div", _hoisted_2$w, [
            shouldShowStatusIndicator.value ? (openBlock(), createElementBlock("span", _hoisted_3$i, "•")) : createCommentVNode("", true),
            createVNode(unref(Button), {
              class: "close-button p-0 w-auto",
              icon: "pi pi-times",
              text: "",
              severity: "secondary",
              size: "small",
              onClick: _cache[0] || (_cache[0] = withModifiers(($event) => onCloseWorkflow(_ctx.workflowOption), ["stop"]))
            })
          ])
        ], 16),
        createVNode(WorkflowTabPopover, {
          ref_key: "popoverRef",
          ref: popoverRef,
          "workflow-filename": _ctx.workflowOption.workflow.filename,
          "thumbnail-url": thumbnailUrl.value,
          "is-active-tab": isActiveTab.value
        }, null, 8, ["workflow-filename", "thumbnail-url", "is-active-tab"])
      ], 64);
    };
  }
});
const WorkflowTab = /* @__PURE__ */ _export_sfc(_sfc_main$11, [["__scopeId", "data-v-cab0d244"]]);
const useOverflowObserver = /* @__PURE__ */ __name((element, options) => {
  options = {
    debounceTime: 25,
    useMutationObserver: true,
    useResizeObserver: true,
    ...options
  };
  const isOverflowing = ref(false);
  const disposeFns = [];
  const disposed = ref(false);
  const checkOverflowFn = /* @__PURE__ */ __name(() => {
    isOverflowing.value = element.scrollWidth > element.clientWidth;
    options.onCheck?.(isOverflowing.value);
  }, "checkOverflowFn");
  const checkOverflow = options.debounceTime ? debounce$2(checkOverflowFn, options.debounceTime) : checkOverflowFn;
  if (options.useMutationObserver) {
    disposeFns.push(
      useMutationObserver$1(element, checkOverflow, {
        subtree: true,
        childList: true
      }).stop
    );
  }
  if (options.useResizeObserver) {
    disposeFns.push(useResizeObserver$1(element, checkOverflow).stop);
  }
  return {
    isOverflowing: readonly(isOverflowing),
    disposed: readonly(disposed),
    checkOverflow,
    dispose: /* @__PURE__ */ __name(() => {
      disposed.value = true;
      disposeFns.forEach((fn) => fn());
    }, "dispose")
  };
}, "useOverflowObserver");
const whileMouseDown = /* @__PURE__ */ __name((elementOrEvent, callback, interval = 30) => {
  const element = elementOrEvent instanceof HTMLElement ? elementOrEvent : elementOrEvent.target;
  let iteration = 0;
  const intervalId = setInterval(() => {
    callback(iteration++);
  }, interval);
  const dispose = /* @__PURE__ */ __name(() => {
    clearInterval(intervalId);
    disposeGlobal();
    disposeLocal();
  }, "dispose");
  const disposeGlobal = useEventListener$1(document, "mouseup", dispose);
  const disposeLocal = useEventListener$1(element, "mouseup", dispose);
  return {
    dispose
  };
}, "whileMouseDown");
const _sfc_main$10 = /* @__PURE__ */ defineComponent({
  __name: "WorkflowOverflowMenu",
  props: {
    workflows: {},
    activeWorkflow: {}
  },
  setup(__props) {
    const props2 = __props;
    const menu = ref(null);
    const workflowService = useWorkflowService();
    const menuItems = computed(
      () => props2.workflows.map((workflow) => ({
        label: workflow.filename,
        icon: props2.activeWorkflow?.key === workflow.key ? "pi pi-check" : void 0,
        command: /* @__PURE__ */ __name(() => {
          void workflowService.openWorkflow(workflow);
        }, "command")
      }))
    );
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", null, [
        withDirectives(createVNode(unref(Button), {
          class: "rounded-none",
          icon: "pi pi-ellipsis-h",
          text: "",
          severity: "secondary",
          "aria-label": _ctx.$t("g.moreWorkflows"),
          onClick: _cache[0] || (_cache[0] = ($event) => menu.value?.toggle($event))
        }, null, 8, ["aria-label"]), [
          [_directive_tooltip, { value: _ctx.$t("g.moreWorkflows"), showDelay: 300 }]
        ]),
        createVNode(unref(Menu), {
          ref_key: "menu",
          ref: menu,
          model: menuItems.value,
          popup: true,
          class: "max-h-[40vh] overflow-auto"
        }, null, 8, ["model"])
      ]);
    };
  }
});
const _hoisted_1$18 = {
  key: 3,
  class: "window-actions-spacer shrink-0 app-drag"
};
const _sfc_main$$ = /* @__PURE__ */ defineComponent({
  __name: "WorkflowTabs",
  props: {
    class: {}
  },
  setup(__props) {
    const props2 = __props;
    const { t: t2 } = useI18n();
    const workspaceStore = useWorkspaceStore();
    const workflowStore = useWorkflowStore();
    const workflowBookmarkStore = useWorkflowBookmarkStore();
    const settingStore = useSettingStore();
    const workflowService = useWorkflowService();
    const rightClickedTab = ref();
    const menu = ref();
    const scrollPanelRef = ref();
    const showOverflowArrows = ref(false);
    const leftArrowEnabled = ref(false);
    const rightArrowEnabled = ref(false);
    const isDesktop = isElectron();
    const menuSetting = computed(() => settingStore.get("Comfy.UseNewMenu"));
    const workflowToOption = /* @__PURE__ */ __name((workflow) => ({
      value: workflow.path,
      workflow
    }), "workflowToOption");
    const options = computed(
      () => workflowStore.openWorkflows.map(workflowToOption)
    );
    const selectedWorkflow = computed(
      () => workflowStore.activeWorkflow ? workflowToOption(workflowStore.activeWorkflow) : null
    );
    const onWorkflowChange = /* @__PURE__ */ __name(async (option) => {
      if (!option) {
        return;
      }
      if (selectedWorkflow.value?.value === option.value) {
        return;
      }
      await workflowService.openWorkflow(option.workflow);
    }, "onWorkflowChange");
    const closeWorkflows = /* @__PURE__ */ __name(async (options2) => {
      for (const opt of options2) {
        if (!await workflowService.closeWorkflow(opt.workflow, {
          warnIfUnsaved: !workspaceStore.shiftDown
        })) {
          break;
        }
      }
    }, "closeWorkflows");
    const onCloseWorkflow = /* @__PURE__ */ __name(async (option) => {
      await closeWorkflows([option]);
    }, "onCloseWorkflow");
    const showContextMenu = /* @__PURE__ */ __name((event, option) => {
      rightClickedTab.value = option;
      menu.value.show(event);
    }, "showContextMenu");
    const contextMenuItems = computed(() => {
      const tab = rightClickedTab.value;
      if (!tab) return [];
      const index = options.value.findIndex((v) => v.workflow === tab.workflow);
      return [
        {
          label: t2("tabMenu.duplicateTab"),
          command: /* @__PURE__ */ __name(async () => {
            await workflowService.duplicateWorkflow(tab.workflow);
          }, "command")
        },
        {
          separator: true
        },
        {
          label: t2("tabMenu.closeTab"),
          command: /* @__PURE__ */ __name(() => onCloseWorkflow(tab), "command")
        },
        {
          label: t2("tabMenu.closeTabsToLeft"),
          command: /* @__PURE__ */ __name(() => closeWorkflows(options.value.slice(0, index)), "command"),
          disabled: index <= 0
        },
        {
          label: t2("tabMenu.closeTabsToRight"),
          command: /* @__PURE__ */ __name(() => closeWorkflows(options.value.slice(index + 1)), "command"),
          disabled: index === options.value.length - 1
        },
        {
          label: t2("tabMenu.closeOtherTabs"),
          command: /* @__PURE__ */ __name(() => closeWorkflows([
            ...options.value.slice(index + 1),
            ...options.value.slice(0, index)
          ]), "command"),
          disabled: options.value.length <= 1
        },
        {
          label: workflowBookmarkStore.isBookmarked(tab.workflow.path) ? t2("tabMenu.removeFromBookmarks") : t2("tabMenu.addToBookmarks"),
          command: /* @__PURE__ */ __name(() => workflowBookmarkStore.toggleBookmarked(tab.workflow.path), "command"),
          disabled: tab.workflow.isTemporary
        }
      ];
    });
    const commandStore = useCommandStore();
    const handleWheel = /* @__PURE__ */ __name((event) => {
      const scrollElement = event.currentTarget;
      const scrollAmount = event.deltaX || event.deltaY;
      scrollElement.scroll({
        left: scrollElement.scrollLeft + scrollAmount
      });
    }, "handleWheel");
    const scroll = /* @__PURE__ */ __name((direction) => {
      const scrollElement = scrollPanelRef.value.$el.querySelector(
        ".p-scrollpanel-content"
      );
      scrollElement.scrollBy({ left: direction * 20 });
    }, "scroll");
    watch(
      () => workflowStore.activeWorkflow,
      async () => {
        if (!selectedWorkflow.value) return;
        await nextTick();
        const activeTabElement = document.querySelector(".p-togglebutton-checked");
        if (!activeTabElement || !scrollPanelRef.value) return;
        const container = scrollPanelRef.value.$el.querySelector(
          ".p-scrollpanel-content"
        );
        if (!container) return;
        const tabRect = activeTabElement.getBoundingClientRect();
        const containerRect = container.getBoundingClientRect();
        const offsetLeft = tabRect.left - containerRect.left;
        const offsetRight = tabRect.right - containerRect.right;
        if (offsetRight > 0) {
          container.scrollBy({ left: offsetRight });
        } else if (offsetLeft < 0) {
          container.scrollBy({ left: offsetLeft });
        }
      },
      { immediate: true }
    );
    const scrollContent = computed(
      () => scrollPanelRef.value?.$el.querySelector(
        ".p-scrollpanel-content"
      )
    );
    let overflowObserver = null;
    let overflowWatch = null;
    watch(scrollContent, (value) => {
      const scrollState = useScroll$1(value);
      watch(scrollState.arrivedState, () => {
        leftArrowEnabled.value = !scrollState.arrivedState.left;
        rightArrowEnabled.value = !scrollState.arrivedState.right;
      });
      overflowObserver?.dispose();
      overflowWatch?.stop();
      overflowObserver = useOverflowObserver(value);
      overflowWatch = watch(
        overflowObserver.isOverflowing,
        (value2) => {
          showOverflowArrows.value = value2;
          void nextTick(() => {
            scrollState.measure();
          });
        },
        { immediate: true }
      );
    });
    onUpdated(() => {
      if (!overflowObserver?.disposed.value) {
        overflowObserver?.checkOverflow();
      }
    });
    return (_ctx, _cache) => {
      const _directive_tooltip = resolveDirective("tooltip");
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["workflow-tabs-container flex flex-row max-w-full h-full flex-auto overflow-hidden", { "workflow-tabs-container-desktop": unref(isDesktop) }])
      }, [
        showOverflowArrows.value ? (openBlock(), createBlock(unref(Button), {
          key: 0,
          icon: "pi pi-chevron-left",
          text: "",
          severity: "secondary",
          class: "overflow-arrow overflow-arrow-left",
          disabled: !leftArrowEnabled.value,
          onMousedown: _cache[0] || (_cache[0] = ($event) => unref(whileMouseDown)($event, () => scroll(-1)))
        }, null, 8, ["disabled"])) : createCommentVNode("", true),
        createVNode(unref(ScrollPanel), {
          ref_key: "scrollPanelRef",
          ref: scrollPanelRef,
          class: "overflow-hidden no-drag",
          "pt:content": {
            class: "p-0 w-full flex",
            onwheel: handleWheel
          },
          "pt:bar-x": "h-1"
        }, {
          default: withCtx(() => [
            createVNode(unref(SelectButton), {
              class: normalizeClass(["workflow-tabs bg-transparent", props2.class]),
              "model-value": selectedWorkflow.value,
              options: options.value,
              "option-label": "label",
              "data-key": "value",
              "onUpdate:modelValue": onWorkflowChange
            }, {
              option: withCtx(({ option }) => [
                createVNode(WorkflowTab, {
                  "workflow-option": option,
                  onContextmenu: /* @__PURE__ */ __name(($event) => showContextMenu($event, option), "onContextmenu"),
                  onMouseup: withModifiers(($event) => onCloseWorkflow(option), ["middle"])
                }, null, 8, ["workflow-option", "onContextmenu", "onMouseup"])
              ]),
              _: 1
            }, 8, ["class", "model-value", "options"])
          ]),
          _: 1
        }, 8, ["pt:content"]),
        showOverflowArrows.value ? (openBlock(), createBlock(unref(Button), {
          key: 1,
          icon: "pi pi-chevron-right",
          text: "",
          severity: "secondary",
          class: "overflow-arrow overflow-arrow-right",
          disabled: !rightArrowEnabled.value,
          onMousedown: _cache[1] || (_cache[1] = ($event) => unref(whileMouseDown)($event, () => scroll(1)))
        }, null, 8, ["disabled"])) : createCommentVNode("", true),
        showOverflowArrows.value ? (openBlock(), createBlock(_sfc_main$10, {
          key: 2,
          workflows: unref(workflowStore).openWorkflows,
          "active-workflow": unref(workflowStore).activeWorkflow
        }, null, 8, ["workflows", "active-workflow"])) : createCommentVNode("", true),
        withDirectives(createVNode(unref(Button), {
          class: "new-blank-workflow-button shrink-0 no-drag rounded-none",
          icon: "pi pi-plus",
          text: "",
          severity: "secondary",
          "aria-label": _ctx.$t("sideToolbar.newBlankWorkflow"),
          onClick: _cache[2] || (_cache[2] = () => unref(commandStore).execute("Comfy.NewBlankWorkflow"))
        }, null, 8, ["aria-label"]), [
          [_directive_tooltip, { value: _ctx.$t("sideToolbar.newBlankWorkflow"), showDelay: 300 }]
        ]),
        createVNode(unref(ContextMenu), {
          ref_key: "menu",
          ref: menu,
          model: contextMenuItems.value
        }, null, 8, ["model"]),
        menuSetting.value !== "Bottom" && unref(isDesktop) ? (openBlock(), createElementBlock("div", _hoisted_1$18)) : createCommentVNode("", true)
      ], 2);
    };
  }
});
const WorkflowTabs = /* @__PURE__ */ _export_sfc(_sfc_main$$, [["__scopeId", "data-v-8a3e9bb6"]]);
const _hoisted_1$17 = { class: "w-auto max-w-full" };
const _sfc_main$_ = /* @__PURE__ */ defineComponent({
  __name: "SecondRowWorkflowTabs",
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$17, [
        createVNode(WorkflowTabs)
      ]);
    };
  }
});
const SecondRowWorkflowTabs = /* @__PURE__ */ _export_sfc(_sfc_main$_, [["__scopeId", "data-v-2dbac56c"]]);
function useViewportCulling(isVueNodesEnabled, vueNodeData, nodeDataTrigger, nodeManager) {
  const canvasStore = useCanvasStore();
  const allNodes = computed(() => {
    if (!isVueNodesEnabled.value) return [];
    void nodeDataTrigger.value;
    return Array.from(vueNodeData.value.values());
  });
  const updateVisibility = /* @__PURE__ */ __name(() => {
    if (!nodeManager.value || !canvasStore.canvas || !app.canvas) return;
    const canvas = canvasStore.canvas;
    const manager = nodeManager.value;
    const ds = canvas.ds;
    const viewport_width = canvas.canvas.width;
    const viewport_height = canvas.canvas.height;
    const margin = 500 * ds.scale;
    const nodeElements = document.querySelectorAll("[data-node-id]");
    for (const element of nodeElements) {
      const nodeId = element.getAttribute("data-node-id");
      if (!nodeId) continue;
      const node = manager.getNode(nodeId);
      if (!node) continue;
      const screen_x = (node.pos[0] + ds.offset[0]) * ds.scale;
      const screen_y = (node.pos[1] + ds.offset[1]) * ds.scale;
      const screen_width = node.size[0] * ds.scale;
      const screen_height = node.size[1] * ds.scale;
      const isNodeOutsideViewport = screen_x + screen_width < -margin || screen_x > viewport_width + margin || screen_y + screen_height < -margin || screen_y > viewport_height + margin;
      if (element instanceof HTMLElement) {
        element.style.display = isNodeOutsideViewport ? "none" : "";
      }
    }
  }, "updateVisibility");
  let rafId2 = null;
  const handleTransformUpdate = /* @__PURE__ */ __name(() => {
    if (!isVueNodesEnabled.value) return;
    if (rafId2 !== null) {
      cancelAnimationFrame(rafId2);
    }
    rafId2 = requestAnimationFrame(() => {
      updateVisibility();
      rafId2 = null;
    });
  }, "handleTransformUpdate");
  return {
    allNodes,
    handleTransformUpdate,
    updateVisibility
  };
}
__name(useViewportCulling, "useViewportCulling");
const useGraphNodeManager = /* @__PURE__ */ __name((graph) => {
  const { moveNode, resizeNode, createNode, deleteNode, setSource } = useLayoutMutations();
  const vueNodeData = reactive(/* @__PURE__ */ new Map());
  const nodeState = reactive(/* @__PURE__ */ new Map());
  const nodePositions = reactive(/* @__PURE__ */ new Map());
  const nodeSizes = reactive(
    /* @__PURE__ */ new Map()
  );
  const nodeRefs = /* @__PURE__ */ new Map();
  const nodeMetadata = /* @__PURE__ */ new WeakMap();
  const performanceMetrics = reactive({
    fps: 0,
    frameTime: 0,
    updateTime: 0,
    nodeCount: 0,
    culledCount: 0,
    callbackUpdateCount: 0,
    rafUpdateCount: 0,
    adaptiveQuality: false
  });
  const spatialIndex = new QuadTree(
    { x: -1e4, y: -1e4, width: 2e4, height: 2e4 },
    { maxDepth: 6, maxItemsPerNode: 4 }
  );
  let lastSpatialQueryTime = 0;
  const spatialMetrics = reactive({
    queryTime: 0,
    nodesInIndex: 0
  });
  const pendingUpdates = /* @__PURE__ */ new Set();
  const criticalUpdates = /* @__PURE__ */ new Set();
  const lowPriorityUpdates = /* @__PURE__ */ new Set();
  let updateScheduled = false;
  let batchTimeoutId = null;
  const lastNodesSnapshot = /* @__PURE__ */ new Map();
  const attachMetadata = /* @__PURE__ */ __name((node) => {
    nodeMetadata.set(node, {
      lastRenderTime: performance.now(),
      cachedBounds: null,
      lodLevel: "high",
      spatialIndex: void 0
    });
  }, "attachMetadata");
  const extractVueNodeData = /* @__PURE__ */ __name((node) => {
    const subgraphId = node.graph && "id" in node.graph && node.graph !== node.graph.rootGraph ? String(node.graph.id) : null;
    const safeWidgets = node.widgets?.map((widget) => {
      try {
        let value = widget.value;
        if (value === void 0 && widget.type === "combo" && widget.options?.values && Array.isArray(widget.options.values) && widget.options.values.length > 0) {
          value = widget.options.values[0];
        }
        return {
          name: widget.name,
          type: widget.type,
          value,
          options: widget.options ? { ...widget.options } : void 0,
          callback: widget.callback
        };
      } catch (error) {
        return {
          name: widget.name || "unknown",
          type: widget.type || "text",
          value: void 0,
          // Already a valid WidgetValue
          options: void 0,
          callback: void 0
        };
      }
    });
    const nodeType = node.type || node.constructor?.comfyClass || node.constructor?.title || node.constructor?.name || "Unknown";
    return {
      id: String(node.id),
      title: typeof node.title === "string" ? node.title : "",
      type: nodeType,
      mode: node.mode || 0,
      selected: node.selected || false,
      executing: false,
      // Will be updated separately based on execution state
      subgraphId,
      hasErrors: !!node.has_errors,
      widgets: safeWidgets,
      inputs: node.inputs ? [...node.inputs] : void 0,
      outputs: node.outputs ? [...node.outputs] : void 0,
      flags: node.flags ? { ...node.flags } : void 0
    };
  }, "extractVueNodeData");
  const getNode = /* @__PURE__ */ __name((id) => {
    return nodeRefs.get(id);
  }, "getNode");
  const validateWidgetValue = /* @__PURE__ */ __name((value) => {
    if (value === null || value === void 0 || value === void 0) {
      return void 0;
    }
    if (typeof value === "string" || typeof value === "number" || typeof value === "boolean") {
      return value;
    }
    if (typeof value === "object") {
      if (Array.isArray(value) && value.length > 0 && value.every((item) => item instanceof File)) {
        return value;
      }
      return value;
    }
    console.warn(`Invalid widget value type: ${typeof value}`, value);
    return void 0;
  }, "validateWidgetValue");
  const updateVueWidgetState = /* @__PURE__ */ __name((nodeId, widgetName, value) => {
    try {
      const currentData = vueNodeData.get(nodeId);
      if (!currentData?.widgets) return;
      const updatedWidgets = currentData.widgets.map(
        (w) => w.name === widgetName ? { ...w, value: validateWidgetValue(value) } : w
      );
      vueNodeData.set(nodeId, {
        ...currentData,
        widgets: updatedWidgets
      });
      performanceMetrics.callbackUpdateCount++;
    } catch (error) {
    }
  }, "updateVueWidgetState");
  const createWrappedWidgetCallback = /* @__PURE__ */ __name((widget, originalCallback, nodeId) => {
    let updateInProgress = false;
    return (value) => {
      if (updateInProgress) return;
      updateInProgress = true;
      try {
        if (value !== null && value !== void 0 && typeof value !== "string" && typeof value !== "number" && typeof value !== "boolean" && typeof value !== "object") {
          console.warn(`Invalid widget value type: ${typeof value}`);
          updateInProgress = false;
          return;
        }
        widget.value = value;
        if (originalCallback) {
          originalCallback.call(widget, value);
        }
        updateVueWidgetState(nodeId, widget.name, value);
      } finally {
        updateInProgress = false;
      }
    };
  }, "createWrappedWidgetCallback");
  const setupNodeWidgetCallbacks = /* @__PURE__ */ __name((node) => {
    if (!node.widgets) return;
    const nodeId = String(node.id);
    node.widgets.forEach((widget) => {
      const originalCallback = widget.callback;
      widget.callback = createWrappedWidgetCallback(
        widget,
        originalCallback,
        nodeId
      );
    });
  }, "setupNodeWidgetCallbacks");
  const scheduleUpdate = /* @__PURE__ */ __name((nodeId, priority = "normal") => {
    if (nodeId) {
      const state = nodeState.get(nodeId);
      if (state) state.dirty = true;
      if (priority === "critical") {
        criticalUpdates.add(nodeId);
        flush();
        return;
      } else if (priority === "low") {
        lowPriorityUpdates.add(nodeId);
      } else {
        pendingUpdates.add(nodeId);
      }
    }
    if (!updateScheduled) {
      updateScheduled = true;
      if (pendingUpdates.size > 10) {
        void nextTick(() => flush());
      } else {
        batchTimeoutId = window.setTimeout(() => flush(), 4);
      }
    }
  }, "scheduleUpdate");
  const flush = /* @__PURE__ */ __name(() => {
    const startTime = performance.now();
    if (batchTimeoutId !== null) {
      clearTimeout(batchTimeoutId);
      batchTimeoutId = null;
    }
    criticalUpdates.clear();
    pendingUpdates.clear();
    lowPriorityUpdates.clear();
    updateScheduled = false;
    syncWithGraph();
    const endTime = performance.now();
    performanceMetrics.updateTime = endTime - startTime;
  }, "flush");
  const syncWithGraph = /* @__PURE__ */ __name(() => {
    if (!graph?._nodes) return;
    const currentNodes = new Set(graph._nodes.map((n) => String(n.id)));
    for (const id of Array.from(vueNodeData.keys())) {
      if (!currentNodes.has(id)) {
        nodeRefs.delete(id);
        vueNodeData.delete(id);
        nodeState.delete(id);
        nodePositions.delete(id);
        nodeSizes.delete(id);
        lastNodesSnapshot.delete(id);
        spatialIndex.remove(id);
      }
    }
    graph._nodes.forEach((node) => {
      const id = String(node.id);
      nodeRefs.set(id, node);
      setupNodeWidgetCallbacks(node);
      vueNodeData.set(id, extractVueNodeData(node));
      if (!nodeState.has(id)) {
        nodeState.set(id, {
          visible: true,
          dirty: false,
          lastUpdate: performance.now(),
          culled: false
        });
        nodePositions.set(id, { x: node.pos[0], y: node.pos[1] });
        nodeSizes.set(id, { width: node.size[0], height: node.size[1] });
        attachMetadata(node);
        const bounds = {
          x: node.pos[0],
          y: node.pos[1],
          width: node.size[0],
          height: node.size[1]
        };
        spatialIndex.insert(id, bounds, id);
      }
    });
    performanceMetrics.nodeCount = vueNodeData.size;
    performanceMetrics.culledCount = Array.from(nodeState.values()).filter(
      (s) => s.culled
    ).length;
  }, "syncWithGraph");
  const getVisibleNodeIds = /* @__PURE__ */ __name((viewportBounds) => {
    const startTime = performance.now();
    const results = spatialIndex.query(viewportBounds);
    const visibleIds = new Set(results);
    lastSpatialQueryTime = performance.now() - startTime;
    spatialMetrics.queryTime = lastSpatialQueryTime;
    return visibleIds;
  }, "getVisibleNodeIds");
  const detectPositionChanges = /* @__PURE__ */ __name((node, id) => {
    const currentPos = nodePositions.get(id);
    if (!currentPos || currentPos.x !== node.pos[0] || currentPos.y !== node.pos[1]) {
      nodePositions.set(id, { x: node.pos[0], y: node.pos[1] });
      void moveNode(id, { x: node.pos[0], y: node.pos[1] });
      return true;
    }
    return false;
  }, "detectPositionChanges");
  const detectSizeChanges = /* @__PURE__ */ __name((node, id) => {
    const currentSize = nodeSizes.get(id);
    if (!currentSize || currentSize.width !== node.size[0] || currentSize.height !== node.size[1]) {
      nodeSizes.set(id, { width: node.size[0], height: node.size[1] });
      void resizeNode(id, {
        width: node.size[0],
        height: node.size[1]
      });
      return true;
    }
    return false;
  }, "detectSizeChanges");
  const updateSpatialIndex = /* @__PURE__ */ __name((node, id) => {
    const bounds = {
      x: node.pos[0],
      y: node.pos[1],
      width: node.size[0],
      height: node.size[1]
    };
    spatialIndex.update(id, bounds);
  }, "updateSpatialIndex");
  const updatePerformanceMetrics = /* @__PURE__ */ __name((startTime, positionUpdates, sizeUpdates) => {
    const endTime = performance.now();
    performanceMetrics.updateTime = endTime - startTime;
    performanceMetrics.nodeCount = vueNodeData.size;
    performanceMetrics.culledCount = Array.from(nodeState.values()).filter(
      (state) => state.culled
    ).length;
    spatialMetrics.nodesInIndex = spatialIndex.size;
    if (positionUpdates > 0 || sizeUpdates > 0) {
      performanceMetrics.rafUpdateCount++;
    }
  }, "updatePerformanceMetrics");
  const detectChangesInRAF = /* @__PURE__ */ __name(() => {
    const startTime = performance.now();
    if (!graph?._nodes) return;
    let positionUpdates = 0;
    let sizeUpdates = 0;
    setSource(LayoutSource.Canvas);
    for (const node of graph._nodes) {
      const id = String(node.id);
      const posChanged = detectPositionChanges(node, id);
      const sizeChanged = detectSizeChanges(node, id);
      if (posChanged) positionUpdates++;
      if (sizeChanged) sizeUpdates++;
      if (posChanged || sizeChanged) {
        updateSpatialIndex(node, id);
      }
    }
    updatePerformanceMetrics(startTime, positionUpdates, sizeUpdates);
  }, "detectChangesInRAF");
  const handleNodeAdded = /* @__PURE__ */ __name((node, originalCallback) => {
    const id = String(node.id);
    nodeRefs.set(id, node);
    setupNodeWidgetCallbacks(node);
    vueNodeData.set(id, extractVueNodeData(node));
    nodeState.set(id, {
      visible: true,
      dirty: false,
      lastUpdate: performance.now(),
      culled: false
    });
    const initializeVueNodeLayout = /* @__PURE__ */ __name(() => {
      const nodePosition = { x: node.pos[0], y: node.pos[1] };
      const nodeSize = { width: node.size[0], height: node.size[1] };
      nodePositions.set(id, nodePosition);
      nodeSizes.set(id, nodeSize);
      attachMetadata(node);
      const nodeBounds = {
        x: nodePosition.x,
        y: nodePosition.y,
        width: nodeSize.width,
        height: nodeSize.height
      };
      spatialIndex.insert(id, nodeBounds, id);
      setSource(LayoutSource.Canvas);
      void createNode(id, {
        position: nodePosition,
        size: nodeSize,
        zIndex: node.order || 0,
        visible: true
      });
    }, "initializeVueNodeLayout");
    if (window.app?.configuringGraph) {
      node.onAfterGraphConfigured = useChainCallback(
        node.onAfterGraphConfigured,
        () => {
          vueNodeData.set(id, extractVueNodeData(node));
          initializeVueNodeLayout();
        }
      );
    } else {
      initializeVueNodeLayout();
    }
    if (originalCallback) {
      void originalCallback(node);
    }
  }, "handleNodeAdded");
  const handleNodeRemoved = /* @__PURE__ */ __name((node, originalCallback) => {
    const id = String(node.id);
    spatialIndex.remove(id);
    setSource(LayoutSource.Canvas);
    void deleteNode(id);
    nodeRefs.delete(id);
    vueNodeData.delete(id);
    nodeState.delete(id);
    nodePositions.delete(id);
    nodeSizes.delete(id);
    lastNodesSnapshot.delete(id);
    if (originalCallback) {
      originalCallback(node);
    }
  }, "handleNodeRemoved");
  const createCleanupFunction = /* @__PURE__ */ __name((originalOnNodeAdded, originalOnNodeRemoved, originalOnTrigger) => {
    return () => {
      graph.onNodeAdded = originalOnNodeAdded || void 0;
      graph.onNodeRemoved = originalOnNodeRemoved || void 0;
      graph.onTrigger = originalOnTrigger || void 0;
      if (batchTimeoutId !== null) {
        clearTimeout(batchTimeoutId);
        batchTimeoutId = null;
      }
      nodeRefs.clear();
      vueNodeData.clear();
      nodeState.clear();
      nodePositions.clear();
      nodeSizes.clear();
      lastNodesSnapshot.clear();
      pendingUpdates.clear();
      criticalUpdates.clear();
      lowPriorityUpdates.clear();
      spatialIndex.clear();
    };
  }, "createCleanupFunction");
  const setupEventListeners = /* @__PURE__ */ __name(() => {
    const originalOnNodeAdded = graph.onNodeAdded;
    const originalOnNodeRemoved = graph.onNodeRemoved;
    const originalOnTrigger = graph.onTrigger;
    graph.onNodeAdded = (node) => {
      handleNodeAdded(node, originalOnNodeAdded);
    };
    graph.onNodeRemoved = (node) => {
      handleNodeRemoved(node, originalOnNodeRemoved);
    };
    graph.onTrigger = (action, param) => {
      if (action === "node:property:changed" && param && typeof param === "object") {
        const event = param;
        const nodeId = String(event.nodeId);
        const currentData = vueNodeData.get(nodeId);
        if (currentData) {
          switch (event.property) {
            case "title":
              vueNodeData.set(nodeId, {
                ...currentData,
                title: String(event.newValue)
              });
              break;
            case "flags.collapsed":
              vueNodeData.set(nodeId, {
                ...currentData,
                flags: {
                  ...currentData.flags,
                  collapsed: Boolean(event.newValue)
                }
              });
              break;
            case "mode":
              vueNodeData.set(nodeId, {
                ...currentData,
                mode: typeof event.newValue === "number" ? event.newValue : 0
              });
          }
        }
      }
      if (originalOnTrigger) {
        originalOnTrigger(action, param);
      }
    };
    syncWithGraph();
    return createCleanupFunction(
      originalOnNodeAdded || void 0,
      originalOnNodeRemoved || void 0,
      originalOnTrigger || void 0
    );
  }, "setupEventListeners");
  const cleanup = setupEventListeners();
  if (graph._nodes && graph._nodes.length > 0) {
    graph._nodes.forEach((node) => {
      if (graph.onNodeAdded) {
        graph.onNodeAdded(node);
      }
    });
  }
  return {
    vueNodeData,
    nodeState,
    nodePositions,
    nodeSizes,
    getNode,
    setupEventListeners,
    cleanup,
    scheduleUpdate,
    forceSync: syncWithGraph,
    detectChangesInRAF,
    getVisibleNodeIds,
    performanceMetrics,
    spatialMetrics,
    getSpatialIndexDebugInfo: /* @__PURE__ */ __name(() => spatialIndex.getDebugInfo(), "getSpatialIndexDebugInfo")
  };
}, "useGraphNodeManager");
function useLayoutSync() {
  let unsubscribe = null;
  function startSync(canvas) {
    if (!canvas?.graph) return;
    unsubscribe = layoutStore.onChange((change) => {
      for (const nodeId of change.nodeIds) {
        const layout = layoutStore.getNodeLayoutRef(nodeId).value;
        if (!layout) continue;
        const liteNode = canvas.graph.getNodeById(parseInt(nodeId));
        if (!liteNode) continue;
        if (liteNode.pos[0] !== layout.position.x || liteNode.pos[1] !== layout.position.y) {
          liteNode.pos[0] = layout.position.x;
          liteNode.pos[1] = layout.position.y;
        }
        if (liteNode.size[0] !== layout.size.width || liteNode.size[1] !== layout.size.height) {
          liteNode.size[0] = layout.size.width;
          liteNode.size[1] = layout.size.height;
        }
      }
      canvas.setDirty(true, true);
    });
  }
  __name(startSync, "startSync");
  function stopSync() {
    if (unsubscribe) {
      unsubscribe();
      unsubscribe = null;
    }
  }
  __name(stopSync, "stopSync");
  onUnmounted(() => {
    stopSync();
  });
  return {
    startSync,
    stopSync
  };
}
__name(useLayoutSync, "useLayoutSync");
const logger = log.getLogger("useLinkLayoutSync");
function useLinkLayoutSync() {
  let canvas = null;
  let graph = null;
  let offscreenCtx = null;
  let adapter = null;
  let unsubscribeLayoutChange = null;
  let restoreHandlers = null;
  function buildLinkRenderContext() {
    if (!canvas) {
      throw new Error("Canvas not initialized");
    }
    return {
      // Canvas settings
      renderMode: canvas.links_render_mode,
      connectionWidth: canvas.connections_width,
      renderBorder: canvas.render_connections_border,
      lowQuality: canvas.low_quality,
      highQualityRender: canvas.highquality_render,
      scale: canvas.ds.scale,
      linkMarkerShape: canvas.linkMarkerShape,
      renderConnectionArrows: canvas.render_connection_arrows,
      // State
      highlightedLinks: new Set(Object.keys(canvas.highlighted_links)),
      // Colors
      defaultLinkColor: canvas.default_link_color,
      linkTypeColors: canvas.constructor.link_type_colors || {},
      // Pattern for disabled links
      disabledPattern: canvas._pattern
    };
  }
  __name(buildLinkRenderContext, "buildLinkRenderContext");
  function recomputeLinkById(linkId) {
    if (!graph || !adapter || !offscreenCtx || !canvas) return;
    const link = graph.links.get(linkId);
    if (!link || link.id === -1) return;
    const sourceNode = graph.getNodeById(link.origin_id);
    const targetNode = graph.getNodeById(link.target_id);
    if (!sourceNode || !targetNode) return;
    const sourceSlot = sourceNode.outputs?.[link.origin_slot];
    const targetSlot = targetNode.inputs?.[link.target_slot];
    if (!sourceSlot || !targetSlot) return;
    const startPos = getSlotPosition(sourceNode, link.origin_slot, false);
    const endPos = getSlotPosition(targetNode, link.target_slot, true);
    const startDir = sourceSlot.dir || LinkDirection.RIGHT;
    const endDir = targetSlot.dir || LinkDirection.LEFT;
    const reroutes = LLink.getReroutes(graph, link);
    const context2 = buildLinkRenderContext();
    if (reroutes.length > 0) {
      let segmentStartPos = startPos;
      let segmentStartDir = startDir;
      for (let i = 0; i < reroutes.length; i++) {
        const reroute = reroutes[i];
        reroute.calculateAngle(Date.now(), graph, [
          segmentStartPos[0],
          segmentStartPos[1]
        ]);
        const distance = Math.sqrt(
          (reroute.pos[0] - segmentStartPos[0]) ** 2 + (reroute.pos[1] - segmentStartPos[1]) ** 2
        );
        const dist = Math.min(Reroute.maxSplineOffset, distance * 0.25);
        const isFloatingInputChain = !sourceNode && targetNode;
        const startControl = isFloatingInputChain ? [0, 0] : [dist * reroute.cos, dist * reroute.sin];
        adapter.renderLinkDirect(
          offscreenCtx,
          segmentStartPos,
          reroute.pos,
          link,
          true,
          // skip_border
          0,
          // flow
          null,
          // color
          segmentStartDir,
          LinkDirection.CENTER,
          context2,
          {
            startControl,
            endControl: reroute.controlPoint,
            reroute,
            disabled: false
          }
        );
        segmentStartPos = reroute.pos;
        segmentStartDir = LinkDirection.CENTER;
      }
      const lastReroute = reroutes[reroutes.length - 1];
      const finalDistance = Math.sqrt(
        (endPos[0] - lastReroute.pos[0]) ** 2 + (endPos[1] - lastReroute.pos[1]) ** 2
      );
      const finalDist = Math.min(Reroute.maxSplineOffset, finalDistance * 0.25);
      const finalStartControl = [
        finalDist * lastReroute.cos,
        finalDist * lastReroute.sin
      ];
      adapter.renderLinkDirect(
        offscreenCtx,
        lastReroute.pos,
        endPos,
        link,
        true,
        // skip_border
        0,
        // flow
        null,
        // color
        LinkDirection.CENTER,
        endDir,
        context2,
        {
          startControl: finalStartControl,
          disabled: false
        }
      );
    } else {
      adapter.renderLinkDirect(
        offscreenCtx,
        startPos,
        endPos,
        link,
        true,
        // skip_border
        0,
        // flow
        null,
        // color
        startDir,
        endDir,
        context2,
        {
          disabled: false
        }
      );
    }
  }
  __name(recomputeLinkById, "recomputeLinkById");
  function recomputeLinksForNode(nodeId) {
    if (!graph) return;
    const node = graph.getNodeById(nodeId);
    if (!node) return;
    const linkIds = /* @__PURE__ */ new Set();
    if (node.outputs) {
      for (const output of node.outputs) {
        if (output.links) {
          for (const linkId of output.links) {
            linkIds.add(linkId);
          }
        }
      }
    }
    if (node.inputs) {
      for (const input of node.inputs) {
        if (input.link !== null && input.link !== void 0) {
          linkIds.add(input.link);
        }
      }
    }
    for (const linkId of linkIds) {
      recomputeLinkById(linkId);
    }
  }
  __name(recomputeLinksForNode, "recomputeLinksForNode");
  function recomputeLinksForReroute(rerouteId) {
    if (!graph) return;
    const reroute = graph.reroutes.get(rerouteId);
    if (!reroute) return;
    for (const linkId of reroute.linkIds) {
      recomputeLinkById(linkId);
    }
  }
  __name(recomputeLinksForReroute, "recomputeLinksForReroute");
  function start(canvasInstance) {
    canvas = canvasInstance;
    graph = canvas.graph;
    if (!graph) return;
    const offscreenCanvas = document.createElement("canvas");
    offscreenCtx = offscreenCanvas.getContext("2d");
    if (!offscreenCtx) {
      logger.error("Failed to create offscreen canvas context");
      return;
    }
    adapter = new LitegraphLinkAdapter(graph);
    adapter.enableLayoutStoreWrites = true;
    for (const link of graph._links.values()) {
      if (link.id !== -1) {
        recomputeLinkById(link.id);
      }
    }
    unsubscribeLayoutChange = layoutStore.onChange((change) => {
      switch (change.operation.type) {
        case "moveNode":
        case "resizeNode":
          recomputeLinksForNode(parseInt(change.operation.nodeId));
          break;
        case "createLink":
          recomputeLinkById(change.operation.linkId);
          break;
        case "deleteLink":
          break;
        case "createReroute":
        case "deleteReroute":
          if ("linkIds" in change.operation) {
            for (const linkId of change.operation.linkIds) {
              recomputeLinkById(linkId);
            }
          }
          break;
        case "moveReroute":
          recomputeLinksForReroute(change.operation.rerouteId);
          break;
      }
    });
    const origTrigger = graph.onTrigger;
    graph.onTrigger = (action, param) => {
      if (action === "node:property:changed" && param?.property === "flags.collapsed") {
        const nodeId = parseInt(String(param.nodeId));
        if (!isNaN(nodeId)) {
          recomputeLinksForNode(nodeId);
        }
      }
      if (origTrigger) {
        origTrigger.call(graph, action, param);
      }
    };
    restoreHandlers = /* @__PURE__ */ __name(() => {
      if (graph) {
        graph.onTrigger = origTrigger || void 0;
      }
    }, "restoreHandlers");
  }
  __name(start, "start");
  function stop() {
    if (unsubscribeLayoutChange) {
      unsubscribeLayoutChange();
      unsubscribeLayoutChange = null;
    }
    if (restoreHandlers) {
      restoreHandlers();
      restoreHandlers = null;
    }
    canvas = null;
    graph = null;
    offscreenCtx = null;
    adapter = null;
  }
  __name(stop, "stop");
  onUnmounted(() => {
    stop();
  });
  return {
    start,
    stop
  };
}
__name(useLinkLayoutSync, "useLinkLayoutSync");
function registerSlotLayout(nodeId, slotIndex, isInput, position) {
  const slotKey = getSlotKey(nodeId, slotIndex, isInput);
  const slotSize = LiteGraph.NODE_SLOT_HEIGHT;
  const halfSize = slotSize / 2;
  const slotLayout = {
    nodeId,
    index: slotIndex,
    type: isInput ? "input" : "output",
    position: { x: position[0], y: position[1] },
    bounds: {
      x: position[0] - halfSize,
      y: position[1] - halfSize,
      width: slotSize,
      height: slotSize
    }
  };
  layoutStore.updateSlotLayout(slotKey, slotLayout);
}
__name(registerSlotLayout, "registerSlotLayout");
function registerNodeSlots(nodeId, context2) {
  context2.inputs.forEach((_, index) => {
    const position = calculateInputSlotPos(context2, index);
    registerSlotLayout(nodeId, index, true, position);
  });
  context2.outputs.forEach((_, index) => {
    const position = calculateOutputSlotPos(context2, index);
    registerSlotLayout(nodeId, index, false, position);
  });
}
__name(registerNodeSlots, "registerNodeSlots");
function computeAndRegisterSlots(node) {
  const nodeId = String(node.id);
  const nodeLayout = layoutStore.getNodeLayoutRef(nodeId).value;
  const nodeX = nodeLayout?.position.x ?? node.pos[0];
  const nodeY = nodeLayout?.position.y ?? node.pos[1];
  const nodeWidth = nodeLayout?.size.width ?? node.size[0];
  const nodeHeight = nodeLayout?.size.height ?? node.size[1];
  node._setConcreteSlots();
  const collapsed = node.flags.collapsed ?? false;
  if (!collapsed) {
    node.arrange();
  }
  const context2 = {
    nodeX,
    nodeY,
    nodeWidth,
    nodeHeight,
    collapsed,
    collapsedWidth: node._collapsed_width,
    slotStartY: node.constructor.slot_start_y,
    inputs: node.inputs,
    outputs: node.outputs,
    widgets: node.widgets
  };
  registerNodeSlots(nodeId, context2);
}
__name(computeAndRegisterSlots, "computeAndRegisterSlots");
function useSlotLayoutSync() {
  let unsubscribeLayoutChange = null;
  let restoreHandlers = null;
  function attemptStart(canvas) {
    if (LiteGraph.vueNodesMode) {
      return false;
    }
    const graph = canvas?.graph;
    if (!graph) return false;
    for (const node of graph.nodes) {
      computeAndRegisterSlots(node);
    }
    unsubscribeLayoutChange = layoutStore.onChange((change) => {
      for (const nodeId of change.nodeIds) {
        const node = graph.getNodeById(parseInt(nodeId));
        if (node) {
          computeAndRegisterSlots(node);
        }
      }
    });
    const origNodeAdded = graph.onNodeAdded;
    const origNodeRemoved = graph.onNodeRemoved;
    const origTrigger = graph.onTrigger;
    const origAfterChange = graph.onAfterChange;
    graph.onNodeAdded = (node) => {
      computeAndRegisterSlots(node);
      if (origNodeAdded) {
        origNodeAdded.call(graph, node);
      }
    };
    graph.onNodeRemoved = (node) => {
      layoutStore.deleteNodeSlotLayouts(String(node.id));
      if (origNodeRemoved) {
        origNodeRemoved.call(graph, node);
      }
    };
    graph.onTrigger = (action, param) => {
      if (action === "node:property:changed" && param?.property === "flags.collapsed") {
        const node = graph.getNodeById(parseInt(String(param.nodeId)));
        if (node) {
          computeAndRegisterSlots(node);
        }
      }
      if (origTrigger) {
        origTrigger.call(graph, action, param);
      }
    };
    graph.onAfterChange = (graph2, node) => {
      if (node && node.id) {
        computeAndRegisterSlots(node);
      }
      if (origAfterChange) {
        origAfterChange.call(graph2, graph2, node);
      }
    };
    restoreHandlers = /* @__PURE__ */ __name(() => {
      graph.onNodeAdded = origNodeAdded || void 0;
      graph.onNodeRemoved = origNodeRemoved || void 0;
      graph.onTrigger = origTrigger || void 0;
      graph.onAfterChange = origAfterChange || void 0;
    }, "restoreHandlers");
    return true;
  }
  __name(attemptStart, "attemptStart");
  function stop() {
    if (unsubscribeLayoutChange) {
      unsubscribeLayoutChange();
      unsubscribeLayoutChange = null;
    }
    if (restoreHandlers) {
      restoreHandlers();
      restoreHandlers = null;
    }
  }
  __name(stop, "stop");
  onUnmounted(() => {
    stop();
  });
  return {
    attemptStart,
    stop
  };
}
__name(useSlotLayoutSync, "useSlotLayoutSync");
function useVueNodeLifecycle(isVueNodesEnabled) {
  const canvasStore = useCanvasStore();
  const layoutMutations = useLayoutMutations();
  const nodeManager = shallowRef(
    null
  );
  const cleanupNodeManager = shallowRef(null);
  const slotSync = shallowRef(null);
  const slotSyncStarted = ref(false);
  const linkSync = shallowRef(null);
  const vueNodeData = ref(/* @__PURE__ */ new Map());
  const nodeState = ref(/* @__PURE__ */ new Map());
  const nodePositions = ref(
    /* @__PURE__ */ new Map()
  );
  const nodeSizes = ref(
    /* @__PURE__ */ new Map()
  );
  const detectChangesInRAF = ref(() => {
  });
  const nodeDataTrigger = ref(0);
  const isNodeManagerReady = computed(() => nodeManager.value !== null);
  const initializeNodeManager = /* @__PURE__ */ __name(() => {
    if (!app.graph || nodeManager.value) return;
    const manager = useGraphNodeManager(app.graph);
    nodeManager.value = manager;
    cleanupNodeManager.value = manager.cleanup;
    vueNodeData.value = manager.vueNodeData;
    nodeState.value = manager.nodeState;
    nodePositions.value = manager.nodePositions;
    nodeSizes.value = manager.nodeSizes;
    detectChangesInRAF.value = manager.detectChangesInRAF;
    const nodes = app.graph._nodes.map((node) => ({
      id: node.id.toString(),
      pos: [node.pos[0], node.pos[1]],
      size: [node.size[0], node.size[1]]
    }));
    layoutStore.initializeFromLiteGraph(nodes);
    for (const reroute of app.graph.reroutes.values()) {
      const [x, y] = reroute.pos;
      const parent = reroute.parentId ?? void 0;
      const linkIds = Array.from(reroute.linkIds);
      layoutMutations.createReroute(reroute.id, { x, y }, parent, linkIds);
    }
    for (const link of app.graph._links.values()) {
      layoutMutations.createLink(
        link.id,
        link.origin_id,
        link.origin_slot,
        link.target_id,
        link.target_slot
      );
    }
    const { startSync } = useLayoutSync();
    startSync(canvasStore.canvas);
    const linkSyncManager = useLinkLayoutSync();
    linkSync.value = linkSyncManager;
    if (app.canvas) {
      linkSyncManager.start(app.canvas);
    }
    nodeDataTrigger.value++;
  }, "initializeNodeManager");
  const disposeNodeManagerAndSyncs = /* @__PURE__ */ __name(() => {
    if (!nodeManager.value) return;
    try {
      cleanupNodeManager.value?.();
    } catch {
    }
    nodeManager.value = null;
    cleanupNodeManager.value = null;
    if (linkSync.value) {
      linkSync.value.stop();
      linkSync.value = null;
    }
    vueNodeData.value = /* @__PURE__ */ new Map();
    nodeState.value = /* @__PURE__ */ new Map();
    nodePositions.value = /* @__PURE__ */ new Map();
    nodeSizes.value = /* @__PURE__ */ new Map();
    detectChangesInRAF.value = () => {
    };
  }, "disposeNodeManagerAndSyncs");
  watch(
    () => isVueNodesEnabled.value && Boolean(app.graph),
    (enabled) => {
      if (enabled) {
        initializeNodeManager();
      } else {
        disposeNodeManagerAndSyncs();
      }
    },
    { immediate: true }
  );
  watch(
    [() => canvasStore.canvas, () => isVueNodesEnabled.value],
    ([canvas, vueMode], [, oldVueMode]) => {
      const modeChanged = vueMode !== oldVueMode;
      if (modeChanged) {
        layoutStore.clearAllSlotLayouts();
      }
      if (vueMode && slotSyncStarted.value) {
        slotSync.value?.stop();
        slotSyncStarted.value = false;
      }
      const shouldRun = Boolean(canvas?.graph) && !vueMode;
      if (shouldRun && !slotSyncStarted.value && canvas) {
        if (!slotSync.value) {
          slotSync.value = useSlotLayoutSync();
        }
        const started = slotSync.value.attemptStart(canvas);
        slotSyncStarted.value = started;
      }
    },
    { immediate: true }
  );
  const setupEmptyGraphListener = /* @__PURE__ */ __name(() => {
    if (isVueNodesEnabled.value && app.graph && !nodeManager.value && app.graph._nodes.length === 0) {
      const originalOnNodeAdded = app.graph.onNodeAdded;
      app.graph.onNodeAdded = function(node) {
        app.graph.onNodeAdded = originalOnNodeAdded;
        if (isVueNodesEnabled.value && !nodeManager.value) {
          initializeNodeManager();
        }
        if (originalOnNodeAdded) {
          originalOnNodeAdded.call(this, node);
        }
      };
    }
  }, "setupEmptyGraphListener");
  const cleanup = /* @__PURE__ */ __name(() => {
    if (nodeManager.value) {
      nodeManager.value.cleanup();
      nodeManager.value = null;
    }
    if (slotSyncStarted.value) {
      slotSync.value?.stop();
      slotSyncStarted.value = false;
    }
    slotSync.value = null;
    if (linkSync.value) {
      linkSync.value.stop();
      linkSync.value = null;
    }
  }, "cleanup");
  return {
    vueNodeData,
    nodeState,
    nodePositions,
    nodeSizes,
    nodeDataTrigger: readonly(nodeDataTrigger),
    nodeManager: readonly(nodeManager),
    detectChangesInRAF: readonly(detectChangesInRAF),
    isNodeManagerReady,
    // Lifecycle methods
    initializeNodeManager,
    disposeNodeManagerAndSyncs,
    setupEmptyGraphListener,
    cleanup
  };
}
__name(useVueNodeLifecycle, "useVueNodeLifecycle");
function safePricingExecution(fn, node, fallback = "") {
  try {
    return fn(node);
  } catch (error) {
    if (false) {
      console.warn(
        "Pricing calculation failed for node:",
        node.constructor?.nodeData?.name,
        error
      );
    }
    return fallback;
  }
}
__name(safePricingExecution, "safePricingExecution");
const calculateRunwayDurationPrice = /* @__PURE__ */ __name((node) => {
  const durationWidget = node.widgets?.find(
    (w) => w.name === "duration"
  );
  if (!durationWidget) return "$0.05/second";
  const duration = Number(durationWidget.value);
  const validDuration = isNaN(duration) ? 5 : duration;
  const cost = (0.05 * validDuration).toFixed(2);
  return `$${cost}/Run`;
}, "calculateRunwayDurationPrice");
const pixversePricingCalculator = /* @__PURE__ */ __name((node) => {
  const durationWidget = node.widgets?.find(
    (w) => w.name === "duration_seconds"
  );
  const qualityWidget = node.widgets?.find(
    (w) => w.name === "quality"
  );
  const motionModeWidget = node.widgets?.find(
    (w) => w.name === "motion_mode"
  );
  if (!durationWidget || !qualityWidget) {
    return "$0.45-1.2/Run (varies with duration, quality & motion mode)";
  }
  const duration = String(durationWidget.value);
  const quality = String(qualityWidget.value);
  const motionMode = String(motionModeWidget?.value);
  if (duration.includes("5")) {
    if (quality.includes("1080p")) return "$1.2/Run";
    if (quality.includes("720p") && motionMode?.includes("fast"))
      return "$1.2/Run";
    if (quality.includes("720p") && motionMode?.includes("normal"))
      return "$0.6/Run";
    if (quality.includes("540p") && motionMode?.includes("fast"))
      return "$0.9/Run";
    if (quality.includes("540p") && motionMode?.includes("normal"))
      return "$0.45/Run";
    if (quality.includes("360p") && motionMode?.includes("fast"))
      return "$0.9/Run";
    if (quality.includes("360p") && motionMode?.includes("normal"))
      return "$0.45/Run";
    if (quality.includes("720p") && motionMode?.includes("fast"))
      return "$1.2/Run";
  } else if (duration.includes("8")) {
    if (quality.includes("720p") && motionMode?.includes("normal"))
      return "$1.2/Run";
    if (quality.includes("540p") && motionMode?.includes("normal"))
      return "$0.9/Run";
    if (quality.includes("540p") && motionMode?.includes("fast"))
      return "$1.2/Run";
    if (quality.includes("360p") && motionMode?.includes("normal"))
      return "$0.9/Run";
    if (quality.includes("360p") && motionMode?.includes("fast"))
      return "$1.2/Run";
    if (quality.includes("1080p") && motionMode?.includes("normal"))
      return "$1.2/Run";
    if (quality.includes("1080p") && motionMode?.includes("fast"))
      return "$1.2/Run";
    if (quality.includes("720p") && motionMode?.includes("normal"))
      return "$1.2/Run";
    if (quality.includes("720p") && motionMode?.includes("fast"))
      return "$1.2/Run";
  }
  return "$0.9/Run";
}, "pixversePricingCalculator");
const byteDanceVideoPricingCalculator = /* @__PURE__ */ __name((node) => {
  const modelWidget = node.widgets?.find(
    (w) => w.name === "model"
  );
  const durationWidget = node.widgets?.find(
    (w) => w.name === "duration"
  );
  const resolutionWidget = node.widgets?.find(
    (w) => w.name === "resolution"
  );
  if (!modelWidget || !durationWidget || !resolutionWidget) return "Token-based";
  const model = String(modelWidget.value).toLowerCase();
  const resolution = String(resolutionWidget.value).toLowerCase();
  const seconds = parseFloat(String(durationWidget.value));
  const priceByModel = {
    "seedance-1-0-pro": {
      "480p": [0.23, 0.24],
      "720p": [0.51, 0.56],
      "1080p": [1.18, 1.22]
    },
    "seedance-1-0-lite": {
      "480p": [0.17, 0.18],
      "720p": [0.37, 0.41],
      "1080p": [0.85, 0.88]
    }
  };
  const modelKey = model.includes("seedance-1-0-pro") ? "seedance-1-0-pro" : model.includes("seedance-1-0-lite") ? "seedance-1-0-lite" : "";
  const resKey = resolution.includes("1080") ? "1080p" : resolution.includes("720") ? "720p" : resolution.includes("480") ? "480p" : "";
  const baseRange = modelKey && resKey ? priceByModel[modelKey]?.[resKey] : void 0;
  if (!baseRange) return "Token-based";
  const [min10s, max10s] = baseRange;
  const scale = seconds / 10;
  const minCost = min10s * scale;
  const maxCost = max10s * scale;
  const minStr = `$${minCost.toFixed(2)}/Run`;
  const maxStr = `$${maxCost.toFixed(2)}/Run`;
  return minStr === maxStr ? minStr : `$${minCost.toFixed(2)}-$${maxCost.toFixed(2)}/Run`;
}, "byteDanceVideoPricingCalculator");
const apiNodeCosts = {
  FluxProCannyNode: {
    displayPrice: "$0.05/Run"
  },
  FluxProDepthNode: {
    displayPrice: "$0.05/Run"
  },
  FluxProExpandNode: {
    displayPrice: "$0.05/Run"
  },
  FluxProFillNode: {
    displayPrice: "$0.05/Run"
  },
  FluxProUltraImageNode: {
    displayPrice: "$0.06/Run"
  },
  FluxProKontextProNode: {
    displayPrice: "$0.04/Run"
  },
  FluxProKontextMaxNode: {
    displayPrice: "$0.08/Run"
  },
  IdeogramV1: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const numImagesWidget = node.widgets?.find(
        (w) => w.name === "num_images"
      );
      const turboWidget = node.widgets?.find(
        (w) => w.name === "turbo"
      );
      if (!numImagesWidget) return "$0.02-0.06 x num_images/Run";
      const numImages = Number(numImagesWidget.value) || 1;
      const turbo = String(turboWidget?.value).toLowerCase() === "true";
      const basePrice = turbo ? 0.02 : 0.06;
      const cost = (basePrice * numImages).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  IdeogramV2: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const numImagesWidget = node.widgets?.find(
        (w) => w.name === "num_images"
      );
      const turboWidget = node.widgets?.find(
        (w) => w.name === "turbo"
      );
      if (!numImagesWidget) return "$0.05-0.08 x num_images/Run";
      const numImages = Number(numImagesWidget.value) || 1;
      const turbo = String(turboWidget?.value).toLowerCase() === "true";
      const basePrice = turbo ? 0.05 : 0.08;
      const cost = (basePrice * numImages).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  IdeogramV3: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const renderingSpeedWidget = node.widgets?.find(
        (w) => w.name === "rendering_speed"
      );
      const numImagesWidget = node.widgets?.find(
        (w) => w.name === "num_images"
      );
      const characterInput = node.inputs?.find(
        (i) => i.name === "character_image"
      );
      const hasCharacter = typeof characterInput?.link !== "undefined" && characterInput.link != null;
      if (!renderingSpeedWidget)
        return "$0.03-0.08 x num_images/Run (varies with rendering speed & num_images)";
      const numImages = Number(numImagesWidget?.value) || 1;
      let basePrice = 0.06;
      const renderingSpeed = String(renderingSpeedWidget.value);
      if (renderingSpeed.toLowerCase().includes("quality")) {
        if (hasCharacter) {
          basePrice = 0.2;
        } else {
          basePrice = 0.09;
        }
      } else if (renderingSpeed.toLowerCase().includes("default")) {
        if (hasCharacter) {
          basePrice = 0.15;
        } else {
          basePrice = 0.06;
        }
      } else if (renderingSpeed.toLowerCase().includes("turbo")) {
        if (hasCharacter) {
          basePrice = 0.1;
        } else {
          basePrice = 0.03;
        }
      }
      const totalCost = (basePrice * numImages).toFixed(2);
      return `$${totalCost}/Run`;
    }, "displayPrice")
  },
  KlingCameraControlI2VNode: {
    displayPrice: "$0.49/Run"
  },
  KlingCameraControlT2VNode: {
    displayPrice: "$0.14/Run"
  },
  KlingDualCharacterVideoEffectNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modeWidget = node.widgets?.find(
        (w) => w.name === "mode"
      );
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model_name"
      );
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      if (!modeWidget || !modelWidget || !durationWidget)
        return "$0.14-2.80/Run (varies with model, mode & duration)";
      const modeValue = String(modeWidget.value);
      const durationValue = String(durationWidget.value);
      const modelValue = String(modelWidget.value);
      console.log("modelValue", modelValue);
      console.log("modeValue", modeValue);
      console.log("durationValue", durationValue);
      if (modelValue.includes("v1-6") || modelValue.includes("v1-5")) {
        if (modeValue.includes("pro")) {
          return durationValue.includes("10") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return durationValue.includes("10") ? "$0.56/Run" : "$0.28/Run";
        }
      } else if (modelValue.includes("v1")) {
        if (modeValue.includes("pro")) {
          return durationValue.includes("10") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return durationValue.includes("10") ? "$0.28/Run" : "$0.14/Run";
        }
      }
      return "$0.14/Run";
    }, "displayPrice")
  },
  KlingImage2VideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modeWidget = node.widgets?.find(
        (w) => w.name === "mode"
      );
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model_name"
      );
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      if (!modeWidget) {
        if (!modelWidget)
          return "$0.14-2.80/Run (varies with model, mode & duration)";
        const modelValue2 = String(modelWidget.value);
        if (modelValue2.includes("v2-1-master") || modelValue2.includes("v2-master")) {
          return "$1.40/Run";
        } else if (modelValue2.includes("v1-6") || modelValue2.includes("v1-5")) {
          return "$0.28/Run";
        }
        return "$0.14/Run";
      }
      const modeValue = String(modeWidget.value);
      const durationValue = String(durationWidget.value);
      const modelValue = String(modelWidget.value);
      console.log("modelValue", modelValue);
      console.log("modeValue", modeValue);
      console.log("durationValue", durationValue);
      if (modelValue.includes("v2-1-master") || modelValue.includes("v2-master")) {
        if (durationValue.includes("10")) {
          return "$2.80/Run";
        }
        return "$1.40/Run";
      } else if (modelValue.includes("v2-1") || modelValue.includes("v1-6") || modelValue.includes("v1-5")) {
        if (modeValue.includes("pro")) {
          return durationValue.includes("10") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return durationValue.includes("10") ? "$0.56/Run" : "$0.28/Run";
        }
      } else if (modelValue.includes("v1")) {
        if (modeValue.includes("pro")) {
          return durationValue.includes("10") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return durationValue.includes("10") ? "$0.28/Run" : "$0.14/Run";
        }
      }
      return "$0.14/Run";
    }, "displayPrice")
  },
  KlingImageGenerationNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const imageInputWidget = node.inputs?.find((i) => i.name === "image");
      const modality = imageInputWidget?.link ? "image to image" : "text to image";
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model_name"
      );
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!modelWidget)
        return "$0.0035-0.028 x n/Run (varies with modality & model)";
      const model = String(modelWidget.value);
      const n = Number(nWidget?.value) || 1;
      let basePrice = 0.014;
      if (modality.includes("text to image")) {
        if (model.includes("kling-v1-5") || model.includes("kling-v2")) {
          basePrice = 0.014;
        } else if (model.includes("kling-v1")) {
          basePrice = 35e-4;
        }
      } else if (modality.includes("image to image")) {
        if (model.includes("kling-v1-5")) {
          basePrice = 0.028;
        } else if (model.includes("kling-v1")) {
          basePrice = 35e-4;
        }
      }
      const totalCost = (basePrice * n).toFixed(4);
      return `$${totalCost}/Run`;
    }, "displayPrice")
  },
  KlingLipSyncAudioToVideoNode: {
    displayPrice: "~$0.10/Run"
  },
  KlingLipSyncTextToVideoNode: {
    displayPrice: "~$0.10/Run"
  },
  KlingSingleImageVideoEffectNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const effectSceneWidget = node.widgets?.find(
        (w) => w.name === "effect_scene"
      );
      if (!effectSceneWidget)
        return "$0.28-0.49/Run (varies with effect scene)";
      const effectScene = String(effectSceneWidget.value);
      if (effectScene.includes("fuzzyfuzzy") || effectScene.includes("squish")) {
        return "$0.28/Run";
      } else if (effectScene.includes("dizzydizzy")) {
        return "$0.49/Run";
      } else if (effectScene.includes("bloombloom")) {
        return "$0.49/Run";
      } else if (effectScene.includes("expansion")) {
        return "$0.28/Run";
      }
      return "$0.28/Run";
    }, "displayPrice")
  },
  KlingStartEndFrameNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modeWidget = node.widgets?.find(
        (w) => w.name === "mode"
      );
      if (!modeWidget)
        return "$0.14-2.80/Run (varies with model, mode & duration)";
      const modeValue = String(modeWidget.value);
      if (modeValue.includes("v2-1")) {
        if (modeValue.includes("10s")) {
          return "$0.98/Run";
        }
        return "$0.49/Run";
      } else if (modeValue.includes("v2-master")) {
        if (modeValue.includes("10s")) {
          return "$2.80/Run";
        }
        return "$1.40/Run";
      } else if (modeValue.includes("v1-6")) {
        if (modeValue.includes("pro")) {
          return modeValue.includes("10s") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return modeValue.includes("10s") ? "$0.56/Run" : "$0.28/Run";
        }
      } else if (modeValue.includes("v1")) {
        if (modeValue.includes("pro")) {
          return modeValue.includes("10s") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return modeValue.includes("10s") ? "$0.28/Run" : "$0.14/Run";
        }
      }
      return "$0.14/Run";
    }, "displayPrice")
  },
  KlingTextToVideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modeWidget = node.widgets?.find(
        (w) => w.name === "mode"
      );
      if (!modeWidget)
        return "$0.14-2.80/Run (varies with model, mode & duration)";
      const modeValue = String(modeWidget.value);
      if (modeValue.includes("v2-1-master")) {
        if (modeValue.includes("10s")) {
          return "$2.80/Run";
        }
        return "$1.40/Run";
      } else if (modeValue.includes("v2-master")) {
        if (modeValue.includes("10s")) {
          return "$2.80/Run";
        }
        return "$1.40/Run";
      } else if (modeValue.includes("v1-6")) {
        if (modeValue.includes("pro")) {
          return modeValue.includes("10s") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return modeValue.includes("10s") ? "$0.56/Run" : "$0.28/Run";
        }
      } else if (modeValue.includes("v1")) {
        if (modeValue.includes("pro")) {
          return modeValue.includes("10s") ? "$0.98/Run" : "$0.49/Run";
        } else {
          return modeValue.includes("10s") ? "$0.28/Run" : "$0.14/Run";
        }
      }
      return "$0.14/Run";
    }, "displayPrice")
  },
  KlingVideoExtendNode: {
    displayPrice: "$0.28/Run"
  },
  KlingVirtualTryOnNode: {
    displayPrice: "$0.07/Run"
  },
  LumaImageToVideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      if (!modelWidget || !resolutionWidget || !durationWidget) {
        return "$0.14-11.47/Run (varies with model, resolution & duration)";
      }
      const model = String(modelWidget.value);
      const resolution = String(resolutionWidget.value).toLowerCase();
      const duration = String(durationWidget.value);
      console.log("model", model);
      console.log("resolution", resolution);
      console.log("duration", duration);
      if (model.includes("ray-flash-2")) {
        if (duration.includes("5s")) {
          if (resolution.includes("4k")) return "$2.19/Run";
          if (resolution.includes("1080p")) return "$0.55/Run";
          if (resolution.includes("720p")) return "$0.24/Run";
          if (resolution.includes("540p")) return "$0.14/Run";
        } else if (duration.includes("9s")) {
          if (resolution.includes("4k")) return "$3.95/Run";
          if (resolution.includes("1080p")) return "$0.99/Run";
          if (resolution.includes("720p")) return "$0.43/Run";
          if (resolution.includes("540p")) return "$0.252/Run";
        }
      } else if (model.includes("ray-2")) {
        if (duration.includes("5s")) {
          if (resolution.includes("4k")) return "$6.37/Run";
          if (resolution.includes("1080p")) return "$1.59/Run";
          if (resolution.includes("720p")) return "$0.71/Run";
          if (resolution.includes("540p")) return "$0.40/Run";
        } else if (duration.includes("9s")) {
          if (resolution.includes("4k")) return "$11.47/Run";
          if (resolution.includes("1080p")) return "$2.87/Run";
          if (resolution.includes("720p")) return "$1.28/Run";
          if (resolution.includes("540p")) return "$0.72/Run";
        }
      } else if (model.includes("ray-1.6")) {
        return "$0.35/Run";
      }
      return "$0.55/Run";
    }, "displayPrice")
  },
  LumaVideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      if (!modelWidget || !resolutionWidget || !durationWidget) {
        return "$0.14-11.47/Run (varies with model, resolution & duration)";
      }
      const model = String(modelWidget.value);
      const resolution = String(resolutionWidget.value).toLowerCase();
      const duration = String(durationWidget.value);
      if (model.includes("ray-flash-2")) {
        if (duration.includes("5s")) {
          if (resolution.includes("4k")) return "$2.19/Run";
          if (resolution.includes("1080p")) return "$0.55/Run";
          if (resolution.includes("720p")) return "$0.24/Run";
          if (resolution.includes("540p")) return "$0.14/Run";
        } else if (duration.includes("9s")) {
          if (resolution.includes("4k")) return "$3.95/Run";
          if (resolution.includes("1080p")) return "$0.99/Run";
          if (resolution.includes("720p")) return "$0.43/Run";
          if (resolution.includes("540p")) return "$0.252/Run";
        }
      } else if (model.includes("ray-2")) {
        if (duration.includes("5s")) {
          if (resolution.includes("4k")) return "$6.37/Run";
          if (resolution.includes("1080p")) return "$1.59/Run";
          if (resolution.includes("720p")) return "$0.71/Run";
          if (resolution.includes("540p")) return "$0.40/Run";
        } else if (duration.includes("9s")) {
          if (resolution.includes("4k")) return "$11.47/Run";
          if (resolution.includes("1080p")) return "$2.87/Run";
          if (resolution.includes("720p")) return "$1.28/Run";
          if (resolution.includes("540p")) return "$0.72/Run";
        }
      } else if (model.includes("ray-1-6")) {
        return "$0.35/Run";
      }
      return "$0.55/Run";
    }, "displayPrice")
  },
  MinimaxImageToVideoNode: {
    displayPrice: "$0.43/Run"
  },
  MinimaxTextToVideoNode: {
    displayPrice: "$0.43/Run"
  },
  MinimaxHailuoVideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      if (!resolutionWidget || !durationWidget) {
        return "$0.28-0.56/Run (varies with resolution & duration)";
      }
      const resolution = String(resolutionWidget.value);
      const duration = String(durationWidget.value);
      if (resolution.includes("768P")) {
        if (duration.includes("6")) return "$0.28/Run";
        if (duration.includes("10")) return "$0.56/Run";
      } else if (resolution.includes("1080P")) {
        if (duration.includes("6")) return "$0.49/Run";
      }
      return "$0.43/Run";
    }, "displayPrice")
  },
  OpenAIDalle2: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const sizeWidget = node.widgets?.find(
        (w) => w.name === "size"
      );
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!sizeWidget) return "$0.016-0.02 x n/Run (varies with size & n)";
      const size2 = String(sizeWidget.value);
      const n = Number(nWidget?.value) || 1;
      let basePrice = 0.02;
      if (size2.includes("1024x1024")) {
        basePrice = 0.02;
      } else if (size2.includes("512x512")) {
        basePrice = 0.018;
      } else if (size2.includes("256x256")) {
        basePrice = 0.016;
      }
      const totalCost = (basePrice * n).toFixed(3);
      return `$${totalCost}/Run`;
    }, "displayPrice")
  },
  OpenAIDalle3: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const sizeWidget = node.widgets?.find(
        (w) => w.name === "size"
      );
      const qualityWidget = node.widgets?.find(
        (w) => w.name === "quality"
      );
      if (!sizeWidget || !qualityWidget)
        return "$0.04-0.12/Run (varies with size & quality)";
      const size2 = String(sizeWidget.value);
      const quality = String(qualityWidget.value);
      if (size2.includes("1024x1024")) {
        return quality.includes("hd") ? "$0.08/Run" : "$0.04/Run";
      } else if (size2.includes("1792x1024") || size2.includes("1024x1792")) {
        return quality.includes("hd") ? "$0.12/Run" : "$0.08/Run";
      }
      return "$0.04/Run";
    }, "displayPrice")
  },
  OpenAIGPTImage1: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const qualityWidget = node.widgets?.find(
        (w) => w.name === "quality"
      );
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!qualityWidget)
        return "$0.011-0.30 x n/Run (varies with quality & n)";
      const quality = String(qualityWidget.value);
      const n = Number(nWidget?.value) || 1;
      let basePriceRange = "$0.046-0.07";
      if (quality.includes("high")) {
        basePriceRange = "$0.167-0.30";
      } else if (quality.includes("medium")) {
        basePriceRange = "$0.046-0.07";
      } else if (quality.includes("low")) {
        basePriceRange = "$0.011-0.02";
      }
      if (n === 1) {
        return `${basePriceRange}/Run`;
      } else {
        return `${basePriceRange} x ${n}/Run`;
      }
    }, "displayPrice")
  },
  PikaImageToVideoNode2_2: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      if (!durationWidget || !resolutionWidget) {
        return "$0.2-1.0/Run (varies with duration & resolution)";
      }
      const duration = String(durationWidget.value);
      const resolution = String(resolutionWidget.value);
      if (duration.includes("5")) {
        if (resolution.includes("1080p")) return "$0.45/Run";
        if (resolution.includes("720p")) return "$0.2/Run";
      } else if (duration.includes("10")) {
        if (resolution.includes("1080p")) return "$1.0/Run";
        if (resolution.includes("720p")) return "$0.6/Run";
      }
      return "$0.2/Run";
    }, "displayPrice")
  },
  PikaScenesV2_2: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      if (!durationWidget || !resolutionWidget) {
        return "$0.2-1.0/Run (varies with duration & resolution)";
      }
      const duration = String(durationWidget.value);
      const resolution = String(resolutionWidget.value);
      if (duration.includes("5")) {
        if (resolution.includes("720p")) return "$0.3/Run";
        if (resolution.includes("1080p")) return "$0.5/Run";
      } else if (duration.includes("10")) {
        if (resolution.includes("720p")) return "$0.4/Run";
        if (resolution.includes("1080p")) return "$1.5/Run";
      }
      return "$0.3/Run";
    }, "displayPrice")
  },
  PikaStartEndFrameNode2_2: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      if (!durationWidget || !resolutionWidget) {
        return "$0.2-1.0/Run (varies with duration & resolution)";
      }
      const duration = String(durationWidget.value);
      const resolution = String(resolutionWidget.value);
      if (duration.includes("5")) {
        if (resolution.includes("720p")) return "$0.2/Run";
        if (resolution.includes("1080p")) return "$0.3/Run";
      } else if (duration.includes("10")) {
        if (resolution.includes("720p")) return "$0.25/Run";
        if (resolution.includes("1080p")) return "$1.0/Run";
      }
      return "$0.2/Run";
    }, "displayPrice")
  },
  PikaTextToVideoNode2_2: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration"
      );
      const resolutionWidget = node.widgets?.find(
        (w) => w.name === "resolution"
      );
      if (!durationWidget || !resolutionWidget) {
        return "$0.2-1.5/Run (varies with duration & resolution)";
      }
      const duration = String(durationWidget.value);
      const resolution = String(resolutionWidget.value);
      if (duration.includes("5")) {
        if (resolution.includes("1080p")) return "$0.45/Run";
        if (resolution.includes("720p")) return "$0.2/Run";
      } else if (duration.includes("10")) {
        if (resolution.includes("1080p")) return "$1.0/Run";
        if (resolution.includes("720p")) return "$0.6/Run";
      }
      return "$0.45/Run";
    }, "displayPrice")
  },
  Pikadditions: {
    displayPrice: "$0.3/Run"
  },
  Pikaffects: {
    displayPrice: "$0.45/Run"
  },
  Pikaswaps: {
    displayPrice: "$0.3/Run"
  },
  PixverseImageToVideoNode: {
    displayPrice: pixversePricingCalculator
  },
  PixverseTextToVideoNode: {
    displayPrice: pixversePricingCalculator
  },
  PixverseTransitionVideoNode: {
    displayPrice: pixversePricingCalculator
  },
  RecraftCreativeUpscaleNode: {
    displayPrice: "$0.25/Run"
  },
  RecraftCrispUpscaleNode: {
    displayPrice: "$0.004/Run"
  },
  RecraftGenerateColorFromImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.04 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.04 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftGenerateImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.04 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.04 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftGenerateVectorImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.08 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.08 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftImageInpaintingNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.04 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.04 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftImageToImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.04 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.04 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftRemoveBackgroundNode: {
    displayPrice: "$0.01/Run"
  },
  RecraftReplaceBackgroundNode: {
    displayPrice: "$0.04/Run"
  },
  RecraftTextToImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.04 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.04 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftTextToVectorNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.08 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.08 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  RecraftVectorizeImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const nWidget = node.widgets?.find(
        (w) => w.name === "n"
      );
      if (!nWidget) return "$0.01 x n/Run";
      const n = Number(nWidget.value) || 1;
      const cost = (0.01 * n).toFixed(2);
      return `$${cost}/Run`;
    }, "displayPrice")
  },
  StabilityStableImageSD_3_5Node: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      if (!modelWidget) return "$0.035-0.065/Run (varies with model)";
      const model = String(modelWidget.value).toLowerCase();
      if (model.includes("large")) {
        return "$0.065/Run";
      } else if (model.includes("medium")) {
        return "$0.035/Run";
      }
      return "$0.035/Run";
    }, "displayPrice")
  },
  StabilityStableImageUltraNode: {
    displayPrice: "$0.08/Run"
  },
  StabilityUpscaleConservativeNode: {
    displayPrice: "$0.25/Run"
  },
  StabilityUpscaleCreativeNode: {
    displayPrice: "$0.25/Run"
  },
  StabilityUpscaleFastNode: {
    displayPrice: "$0.01/Run"
  },
  StabilityTextToAudio: {
    displayPrice: "$0.20/Run"
  },
  StabilityAudioToAudio: {
    displayPrice: "$0.20/Run"
  },
  StabilityAudioInpaint: {
    displayPrice: "$0.20/Run"
  },
  VeoVideoGenerationNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const durationWidget = node.widgets?.find(
        (w) => w.name === "duration_seconds"
      );
      if (!durationWidget) return "$2.50-5.0/Run (varies with duration)";
      const price = 0.5 * Number(durationWidget.value);
      return `$${price.toFixed(2)}/Run`;
    }, "displayPrice")
  },
  Veo3VideoGenerationNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      const generateAudioWidget = node.widgets?.find(
        (w) => w.name === "generate_audio"
      );
      if (!modelWidget || !generateAudioWidget) {
        return "$0.80-3.20/Run (varies with model & audio generation)";
      }
      const model = String(modelWidget.value);
      const generateAudio = String(generateAudioWidget.value).toLowerCase() === "true";
      if (model.includes("veo-3.0-fast-generate-001")) {
        return generateAudio ? "$1.20/Run" : "$0.80/Run";
      } else if (model.includes("veo-3.0-generate-001")) {
        return generateAudio ? "$3.20/Run" : "$1.60/Run";
      }
      return "$0.80-3.20/Run";
    }, "displayPrice")
  },
  LumaImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      const aspectRatioWidget = node.widgets?.find(
        (w) => w.name === "aspect_ratio"
      );
      if (!modelWidget || !aspectRatioWidget) {
        return "$0.0045-0.0182/Run (varies with model & aspect ratio)";
      }
      const model = String(modelWidget.value);
      if (model.includes("photon-flash-1")) {
        return "$0.0019/Run";
      } else if (model.includes("photon-1")) {
        return "$0.0073/Run";
      }
      return "$0.0172/Run";
    }, "displayPrice")
  },
  LumaImageModifyNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      if (!modelWidget) {
        return "$0.0019-0.0073/Run (varies with model)";
      }
      const model = String(modelWidget.value);
      if (model.includes("photon-flash-1")) {
        return "$0.0019/Run";
      } else if (model.includes("photon-1")) {
        return "$0.0073/Run";
      }
      return "$0.0172/Run";
    }, "displayPrice")
  },
  MoonvalleyTxt2VideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const lengthWidget = node.widgets?.find(
        (w) => w.name === "length"
      );
      if (!lengthWidget) return "$1.50/Run";
      const length = String(lengthWidget.value);
      if (length === "5s") {
        return "$1.50/Run";
      } else if (length === "10s") {
        return "$3.00/Run";
      }
      return "$1.50/Run";
    }, "displayPrice")
  },
  MoonvalleyImg2VideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const lengthWidget = node.widgets?.find(
        (w) => w.name === "length"
      );
      if (!lengthWidget) return "$1.50/Run";
      const length = String(lengthWidget.value);
      if (length === "5s") {
        return "$1.50/Run";
      } else if (length === "10s") {
        return "$3.00/Run";
      }
      return "$1.50/Run";
    }, "displayPrice")
  },
  MoonvalleyVideo2VideoNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const lengthWidget = node.widgets?.find(
        (w) => w.name === "length"
      );
      if (!lengthWidget) return "$2.25/Run";
      const length = String(lengthWidget.value);
      if (length === "5s") {
        return "$2.25/Run";
      } else if (length === "10s") {
        return "$4.00/Run";
      }
      return "$2.25/Run";
    }, "displayPrice")
  },
  // Runway nodes - using actual node names from ComfyUI
  RunwayTextToImageNode: {
    displayPrice: "$0.08/Run"
  },
  RunwayImageToVideoNodeGen3a: {
    displayPrice: calculateRunwayDurationPrice
  },
  RunwayImageToVideoNodeGen4: {
    displayPrice: calculateRunwayDurationPrice
  },
  RunwayFirstLastFrameNode: {
    displayPrice: calculateRunwayDurationPrice
  },
  // Rodin nodes - all have the same pricing structure
  Rodin3D_Regular: {
    displayPrice: "$0.4/Run"
  },
  Rodin3D_Detail: {
    displayPrice: "$0.4/Run"
  },
  Rodin3D_Smooth: {
    displayPrice: "$0.4/Run"
  },
  Rodin3D_Sketch: {
    displayPrice: "$0.4/Run"
  },
  // Tripo nodes - using actual node names from ComfyUI
  TripoTextToModelNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const quadWidget = node.widgets?.find(
        (w) => w.name === "quad"
      );
      const styleWidget = node.widgets?.find(
        (w) => w.name === "style"
      );
      const textureWidget = node.widgets?.find(
        (w) => w.name === "texture"
      );
      const textureQualityWidget = node.widgets?.find(
        (w) => w.name === "texture_quality"
      );
      if (!quadWidget || !styleWidget || !textureWidget)
        return "$0.1-0.4/Run (varies with quad, style, texture & quality)";
      const quad = String(quadWidget.value).toLowerCase() === "true";
      const style = String(styleWidget.value).toLowerCase();
      const texture = String(textureWidget.value).toLowerCase() === "true";
      const textureQuality = String(
        textureQualityWidget?.value || "standard"
      ).toLowerCase();
      if (style.includes("none")) {
        if (!quad) {
          if (!texture) return "$0.10/Run";
          else return "$0.15/Run";
        } else {
          if (textureQuality.includes("detailed")) {
            if (!texture) return "$0.30/Run";
            else return "$0.35/Run";
          } else {
            if (!texture) return "$0.20/Run";
            else return "$0.25/Run";
          }
        }
      } else {
        if (!quad) {
          if (!texture) return "$0.15/Run";
          else return "$0.20/Run";
        } else {
          if (textureQuality.includes("detailed")) {
            if (!texture) return "$0.35/Run";
            else return "$0.40/Run";
          } else {
            if (!texture) return "$0.25/Run";
            else return "$0.30/Run";
          }
        }
      }
    }, "displayPrice")
  },
  TripoImageToModelNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const quadWidget = node.widgets?.find(
        (w) => w.name === "quad"
      );
      const styleWidget = node.widgets?.find(
        (w) => w.name === "style"
      );
      const textureWidget = node.widgets?.find(
        (w) => w.name === "texture"
      );
      const textureQualityWidget = node.widgets?.find(
        (w) => w.name === "texture_quality"
      );
      if (!quadWidget || !styleWidget || !textureWidget)
        return "$0.2-0.5/Run (varies with quad, style, texture & quality)";
      const quad = String(quadWidget.value).toLowerCase() === "true";
      const style = String(styleWidget.value).toLowerCase();
      const texture = String(textureWidget.value).toLowerCase() === "true";
      const textureQuality = String(
        textureQualityWidget?.value || "standard"
      ).toLowerCase();
      if (style.includes("none")) {
        if (!quad) {
          if (!texture) return "$0.20/Run";
          else return "$0.25/Run";
        } else {
          if (textureQuality.includes("detailed")) {
            if (!texture) return "$0.40/Run";
            else return "$0.45/Run";
          } else {
            if (!texture) return "$0.30/Run";
            else return "$0.35/Run";
          }
        }
      } else {
        if (!quad) {
          if (!texture) return "$0.25/Run";
          else return "$0.30/Run";
        } else {
          if (textureQuality.includes("detailed")) {
            if (!texture) return "$0.45/Run";
            else return "$0.50/Run";
          } else {
            if (!texture) return "$0.35/Run";
            else return "$0.40/Run";
          }
        }
      }
    }, "displayPrice")
  },
  TripoRefineNode: {
    displayPrice: "$0.3/Run"
  },
  TripoTextureNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const textureQualityWidget = node.widgets?.find(
        (w) => w.name === "texture_quality"
      );
      if (!textureQualityWidget) return "$0.1-0.2/Run (varies with quality)";
      const textureQuality = String(textureQualityWidget.value);
      return textureQuality.includes("detailed") ? "$0.2/Run" : "$0.1/Run";
    }, "displayPrice")
  },
  TripoConvertModelNode: {
    displayPrice: "$0.10/Run"
  },
  TripoRetargetRiggedModelNode: {
    displayPrice: "$0.10/Run"
  },
  TripoMultiviewToModelNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const quadWidget = node.widgets?.find(
        (w) => w.name === "quad"
      );
      const styleWidget = node.widgets?.find(
        (w) => w.name === "style"
      );
      const textureWidget = node.widgets?.find(
        (w) => w.name === "texture"
      );
      const textureQualityWidget = node.widgets?.find(
        (w) => w.name === "texture_quality"
      );
      if (!quadWidget || !styleWidget || !textureWidget)
        return "$0.2-0.5/Run (varies with quad, style, texture & quality)";
      const quad = String(quadWidget.value).toLowerCase() === "true";
      const style = String(styleWidget.value).toLowerCase();
      const texture = String(textureWidget.value).toLowerCase() === "true";
      const textureQuality = String(
        textureQualityWidget?.value || "standard"
      ).toLowerCase();
      if (style.includes("none")) {
        if (!quad) {
          if (!texture) return "$0.20/Run";
          else return "$0.25/Run";
        } else {
          if (textureQuality.includes("detailed")) {
            if (!texture) return "$0.40/Run";
            else return "$0.45/Run";
          } else {
            if (!texture) return "$0.30/Run";
            else return "$0.35/Run";
          }
        }
      } else {
        if (!quad) {
          if (!texture) return "$0.25/Run";
          else return "$0.30/Run";
        } else {
          if (textureQuality.includes("detailed")) {
            if (!texture) return "$0.45/Run";
            else return "$0.50/Run";
          } else {
            if (!texture) return "$0.35/Run";
            else return "$0.40/Run";
          }
        }
      }
    }, "displayPrice")
  },
  // Google/Gemini nodes
  GeminiNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      if (!modelWidget) return "Token-based";
      const model = String(modelWidget.value);
      if (model.includes("veo-2.0")) {
        return "$0.5/second";
      } else if (model.includes("gemini-2.5-flash-preview-04-17")) {
        return "$0.0003/$0.0025 per 1K tokens";
      } else if (model.includes("gemini-2.5-flash")) {
        return "$0.0003/$0.0025 per 1K tokens";
      } else if (model.includes("gemini-2.5-pro-preview-05-06")) {
        return "$0.00125/$0.01 per 1K tokens";
      } else if (model.includes("gemini-2.5-pro")) {
        return "$0.00125/$0.01 per 1K tokens";
      }
      return "Token-based";
    }, "displayPrice")
  },
  GeminiImageNode: {
    displayPrice: "$0.03 per 1K tokens"
  },
  // OpenAI nodes
  OpenAIChatNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      if (!modelWidget) return "Token-based";
      const model = String(modelWidget.value);
      if (model.includes("o4-mini")) {
        return "$0.0011/$0.0044 per 1K tokens";
      } else if (model.includes("o1-pro")) {
        return "$0.15/$0.60 per 1K tokens";
      } else if (model.includes("o1")) {
        return "$0.015/$0.06 per 1K tokens";
      } else if (model.includes("o3-mini")) {
        return "$0.0011/$0.0044 per 1K tokens";
      } else if (model.includes("o3")) {
        return "$0.01/$0.04 per 1K tokens";
      } else if (model.includes("gpt-4o")) {
        return "$0.0025/$0.01 per 1K tokens";
      } else if (model.includes("gpt-4.1-nano")) {
        return "$0.0001/$0.0004 per 1K tokens";
      } else if (model.includes("gpt-4.1-mini")) {
        return "$0.0004/$0.0016 per 1K tokens";
      } else if (model.includes("gpt-4.1")) {
        return "$0.002/$0.008 per 1K tokens";
      } else if (model.includes("gpt-5-nano")) {
        return "$0.00005/$0.0004 per 1K tokens";
      } else if (model.includes("gpt-5-mini")) {
        return "$0.00025/$0.002 per 1K tokens";
      } else if (model.includes("gpt-5")) {
        return "$0.00125/$0.01 per 1K tokens";
      }
      return "Token-based";
    }, "displayPrice")
  },
  ViduTextToVideoNode: {
    displayPrice: "$0.4/Run"
  },
  ViduImageToVideoNode: {
    displayPrice: "$0.4/Run"
  },
  ViduReferenceVideoNode: {
    displayPrice: "$0.4/Run"
  },
  ViduStartEndToVideoNode: {
    displayPrice: "$0.4/Run"
  },
  ByteDanceImageNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      if (!modelWidget) return "Token-based";
      const model = String(modelWidget.value);
      if (model.includes("seedream-3-0-t2i")) {
        return "$0.03/Run";
      }
      return "Token-based";
    }, "displayPrice")
  },
  ByteDanceImageEditNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const modelWidget = node.widgets?.find(
        (w) => w.name === "model"
      );
      if (!modelWidget) return "Token-based";
      const model = String(modelWidget.value);
      if (model.includes("seededit-3-0-i2i")) {
        return "$0.03/Run";
      }
      return "Token-based";
    }, "displayPrice")
  },
  ByteDanceSeedreamNode: {
    displayPrice: /* @__PURE__ */ __name((node) => {
      const sequentialGenerationWidget = node.widgets?.find(
        (w) => w.name === "sequential_image_generation"
      );
      const maxImagesWidget = node.widgets?.find(
        (w) => w.name === "max_images"
      );
      if (!sequentialGenerationWidget || !maxImagesWidget)
        return "$0.03/Run ($0.03 for one output image)";
      if (String(sequentialGenerationWidget.value).toLowerCase() === "disabled") {
        return "$0.03/Run";
      }
      const maxImages = Number(maxImagesWidget.value);
      if (maxImages === 1) {
        return "$0.03/Run";
      }
      const cost = (0.03 * maxImages).toFixed(2);
      return `$${cost}/Run ($0.03 for one output image)`;
    }, "displayPrice")
  },
  ByteDanceTextToVideoNode: {
    displayPrice: byteDanceVideoPricingCalculator
  },
  ByteDanceImageToVideoNode: {
    displayPrice: byteDanceVideoPricingCalculator
  },
  ByteDanceFirstLastFrameNode: {
    displayPrice: byteDanceVideoPricingCalculator
  },
  ByteDanceImageReferenceNode: {
    displayPrice: byteDanceVideoPricingCalculator
  }
};
const useNodePricing = /* @__PURE__ */ __name(() => {
  const getNodeDisplayPrice = /* @__PURE__ */ __name((node) => {
    if (!node.constructor?.nodeData?.api_node) return "";
    const nodeName = node.constructor.nodeData.name;
    const priceConfig = apiNodeCosts[nodeName];
    if (!priceConfig) return "";
    if (typeof priceConfig.displayPrice === "function") {
      return safePricingExecution(priceConfig.displayPrice, node, "");
    }
    return priceConfig.displayPrice;
  }, "getNodeDisplayPrice");
  const getNodePricingConfig = /* @__PURE__ */ __name((node) => apiNodeCosts[node.constructor.nodeData?.name ?? ""], "getNodePricingConfig");
  const getRelevantWidgetNames = /* @__PURE__ */ __name((nodeType) => {
    const widgetMap = {
      KlingTextToVideoNode: ["mode", "model_name", "duration"],
      KlingImage2VideoNode: ["mode", "model_name", "duration"],
      KlingImageGenerationNode: ["modality", "model_name", "n"],
      KlingDualCharacterVideoEffectNode: ["mode", "model_name", "duration"],
      KlingSingleImageVideoEffectNode: ["effect_scene"],
      KlingStartEndFrameNode: ["mode", "model_name", "duration"],
      MinimaxHailuoVideoNode: ["resolution", "duration"],
      OpenAIDalle3: ["size", "quality"],
      OpenAIDalle2: ["size", "n"],
      OpenAIGPTImage1: ["quality", "n"],
      IdeogramV1: ["num_images", "turbo"],
      IdeogramV2: ["num_images", "turbo"],
      IdeogramV3: ["rendering_speed", "num_images", "character_image"],
      FluxProKontextProNode: [],
      FluxProKontextMaxNode: [],
      VeoVideoGenerationNode: ["duration_seconds"],
      Veo3VideoGenerationNode: ["model", "generate_audio"],
      LumaVideoNode: ["model", "resolution", "duration"],
      LumaImageToVideoNode: ["model", "resolution", "duration"],
      LumaImageNode: ["model", "aspect_ratio"],
      LumaImageModifyNode: ["model", "aspect_ratio"],
      PikaTextToVideoNode2_2: ["duration", "resolution"],
      PikaImageToVideoNode2_2: ["duration", "resolution"],
      PikaScenesV2_2: ["duration", "resolution"],
      PikaStartEndFrameNode2_2: ["duration", "resolution"],
      PixverseTextToVideoNode: ["duration_seconds", "quality", "motion_mode"],
      PixverseTransitionVideoNode: [
        "duration_seconds",
        "motion_mode",
        "quality"
      ],
      PixverseImageToVideoNode: ["duration_seconds", "quality", "motion_mode"],
      StabilityStableImageSD_3_5Node: ["model"],
      RecraftTextToImageNode: ["n"],
      RecraftImageToImageNode: ["n"],
      RecraftImageInpaintingNode: ["n"],
      RecraftTextToVectorNode: ["n"],
      RecraftVectorizeImageNode: ["n"],
      RecraftGenerateColorFromImageNode: ["n"],
      RecraftGenerateImageNode: ["n"],
      RecraftGenerateVectorImageNode: ["n"],
      MoonvalleyTxt2VideoNode: ["length"],
      MoonvalleyImg2VideoNode: ["length"],
      MoonvalleyVideo2VideoNode: ["length"],
      // Runway nodes
      RunwayImageToVideoNodeGen3a: ["duration"],
      RunwayImageToVideoNodeGen4: ["duration"],
      RunwayFirstLastFrameNode: ["duration"],
      // Tripo nodes
      TripoTextToModelNode: ["quad", "style", "texture", "texture_quality"],
      TripoImageToModelNode: ["quad", "style", "texture", "texture_quality"],
      TripoTextureNode: ["texture_quality"],
      // Google/Gemini nodes
      GeminiNode: ["model"],
      // OpenAI nodes
      OpenAIChatNode: ["model"],
      // ByteDance
      ByteDanceImageNode: ["model"],
      ByteDanceImageEditNode: ["model"],
      ByteDanceSeedreamNode: [
        "model",
        "sequential_image_generation",
        "max_images"
      ],
      ByteDanceTextToVideoNode: ["model", "duration", "resolution"],
      ByteDanceImageToVideoNode: ["model", "duration", "resolution"],
      ByteDanceFirstLastFrameNode: ["model", "duration", "resolution"],
      ByteDanceImageReferenceNode: ["model", "duration", "resolution"]
    };
    return widgetMap[nodeType] || [];
  }, "getRelevantWidgetNames");
  return {
    getNodeDisplayPrice,
    getNodePricingConfig,
    getRelevantWidgetNames
  };
}, "useNodePricing");
const useComputedWithWidgetWatch = /* @__PURE__ */ __name((node, options = {}) => {
  const { widgetNames, triggerCanvasRedraw = false } = options;
  const widgetValues = ref({});
  if (node.widgets) {
    const widgetsToObserve = widgetNames ? node.widgets.filter((widget) => widgetNames.includes(widget.name)) : node.widgets;
    const currentValues = {};
    widgetsToObserve.forEach((widget) => {
      currentValues[widget.name] = widget.value;
    });
    widgetValues.value = currentValues;
    widgetsToObserve.forEach((widget) => {
      widget.callback = useChainCallback(widget.callback, () => {
        widgetValues.value = {
          ...widgetValues.value,
          [widget.name]: widget.value
        };
        if (triggerCanvasRedraw) {
          node.graph?.setDirtyCanvas(true, true);
        }
      });
    });
    if (widgetNames && widgetNames.length > widgetsToObserve.length) {
      const indexesToObserve = widgetNames.map(
        (name) => widgetsToObserve.some((w) => w.name == name) ? -1 : node.inputs.findIndex((i) => i.name == name)
      ).filter((i) => i >= 0);
      node.onConnectionsChange = useChainCallback(
        node.onConnectionsChange,
        (_type, index, isConnected) => {
          if (!indexesToObserve.includes(index)) return;
          widgetValues.value = {
            ...widgetValues.value,
            [indexesToObserve[index]]: isConnected
          };
          if (triggerCanvasRedraw) {
            node.graph?.setDirtyCanvas(true, true);
          }
        }
      );
    }
  }
  return (computeFn) => {
    return computedWithControl$1(widgetValues, computeFn);
  };
}, "useComputedWithWidgetWatch");
const useNodeBadge = /* @__PURE__ */ __name(() => {
  const settingStore = useSettingStore();
  const extensionStore = useExtensionStore();
  const colorPaletteStore = useColorPaletteStore();
  const nodeSourceBadgeMode = computed(
    () => settingStore.get("Comfy.NodeBadge.NodeSourceBadgeMode")
  );
  const nodeIdBadgeMode = computed(
    () => settingStore.get("Comfy.NodeBadge.NodeIdBadgeMode")
  );
  const nodeLifeCycleBadgeMode = computed(
    () => settingStore.get(
      "Comfy.NodeBadge.NodeLifeCycleBadgeMode"
    )
  );
  const showApiPricingBadge = computed(
    () => settingStore.get("Comfy.NodeBadge.ShowApiPricing")
  );
  watch(
    [
      nodeSourceBadgeMode,
      nodeIdBadgeMode,
      nodeLifeCycleBadgeMode,
      showApiPricingBadge
    ],
    () => {
      app.graph?.setDirtyCanvas(true, true);
    }
  );
  const nodeDefStore = useNodeDefStore();
  function badgeTextVisible(nodeDef, badgeMode) {
    return !(badgeMode === NodeBadgeMode.None || nodeDef?.isCoreNode && badgeMode === NodeBadgeMode.HideBuiltIn);
  }
  __name(badgeTextVisible, "badgeTextVisible");
  onMounted(() => {
    const nodePricing = useNodePricing();
    extensionStore.registerExtension({
      name: "Comfy.NodeBadge",
      nodeCreated(node) {
        node.badgePosition = BadgePosition.TopRight;
        const badge = computed(() => {
          const nodeDef = nodeDefStore.fromLGraphNode(node);
          return new LGraphBadge({
            text: toolkit.truncate(
              [
                badgeTextVisible(nodeDef, nodeIdBadgeMode.value) ? `#${node.id}` : "",
                badgeTextVisible(nodeDef, nodeLifeCycleBadgeMode.value) ? nodeDef?.nodeLifeCycleBadgeText ?? "" : "",
                badgeTextVisible(nodeDef, nodeSourceBadgeMode.value) ? nodeDef?.nodeSource?.badgeText ?? "" : ""
              ].filter((s) => s.length > 0).join(" "),
              {
                length: 31
              }
            ),
            fgColor: colorPaletteStore.completedActivePalette.colors.litegraph_base.BADGE_FG_COLOR,
            bgColor: colorPaletteStore.completedActivePalette.colors.litegraph_base.BADGE_BG_COLOR
          });
        });
        node.badges.push(() => badge.value);
        if (node.constructor.nodeData?.api_node && showApiPricingBadge.value) {
          const pricingConfig = nodePricing.getNodePricingConfig(node);
          const hasDynamicPricing = typeof pricingConfig?.displayPrice === "function";
          let creditsBadge;
          const createBadge = /* @__PURE__ */ __name(() => {
            const price = nodePricing.getNodeDisplayPrice(node);
            const isLightTheme = colorPaletteStore.completedActivePalette.light_theme;
            return new LGraphBadge({
              text: price,
              iconOptions: {
                unicode: "",
                fontFamily: "PrimeIcons",
                color: isLightTheme ? adjustColor("#FABC25", { lightness: 0.5 }) : "#FABC25",
                bgColor: isLightTheme ? adjustColor("#654020", { lightness: 0.5 }) : "#654020",
                fontSize: 8
              },
              fgColor: colorPaletteStore.completedActivePalette.colors.litegraph_base.BADGE_FG_COLOR,
              bgColor: isLightTheme ? adjustColor("#8D6932", { lightness: 0.5 }) : "#8D6932"
            });
          }, "createBadge");
          if (hasDynamicPricing) {
            const relevantWidgetNames = nodePricing.getRelevantWidgetNames(
              node.constructor.nodeData?.name
            );
            const computedWithWidgetWatch = useComputedWithWidgetWatch(node, {
              widgetNames: relevantWidgetNames,
              triggerCanvasRedraw: true
            });
            creditsBadge = computedWithWidgetWatch(createBadge);
          } else {
            creditsBadge = computed(createBadge);
          }
          node.badges.push(() => creditsBadge.value);
        }
      }
    });
  });
}, "useNodeBadge");
const useCanvasDrop = /* @__PURE__ */ __name((canvasRef) => {
  const modelToNodeStore = useModelToNodeStore();
  const litegraphService = useLitegraphService();
  const workflowService = useWorkflowService();
  usePragmaticDroppable(() => canvasRef.value, {
    getDropEffect: /* @__PURE__ */ __name((args) => args.source.data.type === "tree-explorer-node" ? "copy" : "move", "getDropEffect"),
    onDrop: /* @__PURE__ */ __name(async (event) => {
      const loc = event.location.current.input;
      const dndData = event.source.data;
      if (dndData.type === "tree-explorer-node") {
        const node = dndData.data;
        const conv = useSharedCanvasPositionConversion();
        const basePos = conv.clientPosToCanvasPos([loc.clientX, loc.clientY]);
        if (node.data instanceof ComfyNodeDefImpl) {
          const nodeDef = node.data;
          const pos = [...basePos];
          pos[1] += LiteGraph.NODE_TITLE_HEIGHT;
          litegraphService.addNodeOnGraph(nodeDef, { pos });
        } else if (node.data instanceof ComfyModelDef) {
          const model = node.data;
          const pos = basePos;
          const nodeAtPos = app.graph.getNodeOnPos(pos[0], pos[1]);
          let targetProvider = null;
          let targetGraphNode = null;
          if (nodeAtPos) {
            const providers = modelToNodeStore.getAllNodeProviders(
              model.directory
            );
            for (const provider of providers) {
              if (provider.nodeDef.name === nodeAtPos.comfyClass) {
                targetGraphNode = nodeAtPos;
                targetProvider = provider;
              }
            }
          }
          if (!targetGraphNode) {
            const provider = modelToNodeStore.getNodeProvider(model.directory);
            if (provider) {
              targetGraphNode = litegraphService.addNodeOnGraph(
                provider.nodeDef,
                {
                  pos
                }
              );
              targetProvider = provider;
            }
          }
          if (targetGraphNode) {
            const widget = targetGraphNode.widgets?.find(
              (widget2) => widget2.name === targetProvider?.key
            );
            if (widget) {
              widget.value = model.file_name;
            }
          }
        } else if (node.data instanceof ComfyWorkflow) {
          const workflow = node.data;
          await workflowService.insertWorkflow(workflow, { position: basePos });
        }
      }
    }, "onDrop")
  });
}, "useCanvasDrop");
const useContextMenuTranslation = /* @__PURE__ */ __name(() => {
  const f = LGraphCanvas.prototype.getCanvasMenuOptions;
  const getCanvasCenterMenuOptions = /* @__PURE__ */ __name(function(...args) {
    const res = f.apply(this, args);
    for (const item of res) {
      if (item?.content) {
        item.content = st(`contextMenu.${item.content}`, item.content);
      }
    }
    return res;
  }, "getCanvasCenterMenuOptions");
  LGraphCanvas.prototype.getCanvasMenuOptions = getCanvasCenterMenuOptions;
  function translateMenus(values, options) {
    if (!values) return;
    const reInput = /Convert (.*) to input/;
    const reWidget = /Convert (.*) to widget/;
    const cvt = st("contextMenu.Convert ", "Convert ");
    const tinp = st("contextMenu. to input", " to input");
    const twgt = st("contextMenu. to widget", " to widget");
    for (const value of values) {
      if (typeof value === "string") continue;
      translateMenus(value?.submenu?.options, options);
      if (!value?.content) {
        continue;
      }
      if (te(`contextMenu.${value.content}`)) {
        value.content = st(`contextMenu.${value.content}`, value.content);
      }
      const extraInfo = options.extra || options.parentMenu?.options?.extra;
      const matchInput = value.content?.match(reInput);
      if (matchInput) {
        let match = matchInput[1];
        extraInfo?.inputs?.find((i) => {
          if (i.name != match) return false;
          match = i.label ? i.label : i.name;
        });
        extraInfo?.widgets?.find((i) => {
          if (i.name != match) return false;
          match = i.label ? i.label : i.name;
        });
        value.content = cvt + match + tinp;
        continue;
      }
      const matchWidget = value.content?.match(reWidget);
      if (matchWidget) {
        let match = matchWidget[1];
        extraInfo?.inputs?.find((i) => {
          if (i.name != match) return false;
          match = i.label ? i.label : i.name;
        });
        extraInfo?.widgets?.find((i) => {
          if (i.name != match) return false;
          match = i.label ? i.label : i.name;
        });
        value.content = cvt + match + twgt;
        continue;
      }
    }
  }
  __name(translateMenus, "translateMenus");
  const OriginalContextMenu = LiteGraph.ContextMenu;
  function ContextMenu2(values, options) {
    if (options.title) {
      options.title = st(
        `nodeDefs.${normalizeI18nKey(options.title)}.display_name`,
        options.title
      );
    }
    translateMenus(values, options);
    const ctx = new OriginalContextMenu(values, options);
    return ctx;
  }
  __name(ContextMenu2, "ContextMenu");
  LiteGraph.ContextMenu = ContextMenu2;
  LiteGraph.ContextMenu.prototype = OriginalContextMenu.prototype;
}, "useContextMenuTranslation");
const useCopy = /* @__PURE__ */ __name(() => {
  const canvasStore = useCanvasStore();
  useEventListener$1(document, "copy", (e) => {
    if (!(e.target instanceof Element)) {
      return;
    }
    if (e.target instanceof HTMLTextAreaElement && e.target.type === "textarea" || e.target instanceof HTMLInputElement && e.target.type === "text") {
      return;
    }
    const isTargetInGraph = e.target.classList.contains("litegraph") || e.target.classList.contains("graph-canvas-container") || e.target.id === "graph-canvas";
    const canvas = canvasStore.canvas;
    if (isTargetInGraph && canvas?.selectedItems) {
      canvas.copyToClipboard();
      e.clipboardData?.setData("text", " ");
      e.preventDefault();
      e.stopImmediatePropagation();
      return false;
    }
  });
}, "useCopy");
const useGlobalLitegraph = /* @__PURE__ */ __name(() => {
  window["LiteGraph"] = LiteGraph;
  window["LGraph"] = LGraph;
  window["LLink"] = LLink;
  window["LGraphNode"] = LGraphNode;
  window["LGraphGroup"] = LGraphGroup;
  window["DragAndScale"] = DragAndScale;
  window["LGraphCanvas"] = LGraphCanvas;
  window["ContextMenu"] = ContextMenu$1;
  window["LGraphBadge"] = LGraphBadge;
}, "useGlobalLitegraph");
const usePaste = /* @__PURE__ */ __name(() => {
  const workspaceStore = useWorkspaceStore();
  const canvasStore = useCanvasStore();
  const pasteItemsOnNode = /* @__PURE__ */ __name((items, node, contentType) => {
    if (!node) return;
    const filteredItems = Array.from(items).filter(
      (item) => item.type.startsWith(contentType)
    );
    const blob = filteredItems[0]?.getAsFile();
    if (!blob) return;
    node.pasteFile?.(blob);
    node.pasteFiles?.(
      Array.from(filteredItems).map((i) => i.getAsFile()).filter((f) => f !== null)
    );
  }, "pasteItemsOnNode");
  useEventListener$1(document, "paste", async (e) => {
    const isTargetInGraph = e.target instanceof Element && (e.target.classList.contains("litegraph") || e.target.classList.contains("graph-canvas-container") || e.target.id === "graph-canvas");
    if (!isTargetInGraph) return;
    if (workspaceStore.shiftDown) return;
    const { canvas } = canvasStore;
    if (!canvas) return;
    const { graph } = canvas;
    let data = e.clipboardData;
    if (!data) throw new Error("No clipboard data on clipboard event");
    const { items } = data;
    const currentNode = canvas.current_node;
    const isNodeSelected = currentNode?.is_selected;
    const isImageNodeSelected = isNodeSelected && isImageNode(currentNode);
    const isVideoNodeSelected = isNodeSelected && isVideoNode(currentNode);
    const isAudioNodeSelected = isNodeSelected && isAudioNode(currentNode);
    let imageNode = isImageNodeSelected ? currentNode : null;
    let audioNode = isAudioNodeSelected ? currentNode : null;
    const videoNode = isVideoNodeSelected ? currentNode : null;
    for (const item of items) {
      if (item.type.startsWith("image/")) {
        if (!imageNode) {
          const newNode = LiteGraph.createNode("LoadImage");
          if (newNode) {
            newNode.pos = [canvas.graph_mouse[0], canvas.graph_mouse[1]];
            imageNode = graph?.add(newNode) ?? null;
          }
          graph?.change();
        }
        pasteItemsOnNode(items, imageNode, "image");
        return;
      } else if (item.type.startsWith("video/")) {
        if (!videoNode) {
        } else {
          pasteItemsOnNode(items, videoNode, "video");
          return;
        }
      } else if (item.type.startsWith("audio/")) {
        if (!audioNode) {
          const newNode = LiteGraph.createNode("LoadAudio");
          if (newNode) {
            newNode.pos = [canvas.graph_mouse[0], canvas.graph_mouse[1]];
            audioNode = graph?.add(newNode) ?? null;
          }
          graph?.change();
        }
        pasteItemsOnNode(items, audioNode, "audio");
        return;
      }
    }
    data = data.getData("text/plain");
    let workflow = null;
    try {
      data = data.slice(data.indexOf("{"));
      workflow = JSON.parse(data);
    } catch (err) {
      try {
        data = data.slice(data.indexOf("workflow\n"));
        data = data.slice(data.indexOf("{"));
        workflow = JSON.parse(data);
      } catch (error) {
        workflow = null;
      }
    }
    if (workflow && workflow.version && workflow.nodes && workflow.extra) {
      await app.loadGraphData(workflow);
    } else {
      if (e.target instanceof HTMLTextAreaElement && e.target.type === "textarea" || e.target instanceof HTMLInputElement && e.target.type === "text") {
        return;
      }
      canvas.pasteFromClipboard();
    }
  });
}, "usePaste");
const useLitegraphSettings = /* @__PURE__ */ __name(() => {
  const settingStore = useSettingStore();
  const canvasStore = useCanvasStore();
  watchEffect(() => {
    const canvasInfoEnabled = settingStore.get("Comfy.Graph.CanvasInfo");
    if (canvasStore.canvas) {
      canvasStore.canvas.show_info = canvasInfoEnabled;
      canvasStore.canvas.draw(false, true);
    }
  });
  watchEffect(() => {
    const zoomSpeed = settingStore.get("Comfy.Graph.ZoomSpeed");
    if (canvasStore.canvas) {
      canvasStore.canvas.zoom_speed = zoomSpeed;
    }
  });
  watchEffect(() => {
    LiteGraph.snaps_for_comfy = settingStore.get(
      "Comfy.Node.AutoSnapLinkToSlot"
    );
  });
  watchEffect(() => {
    LiteGraph.snap_highlights_node = settingStore.get(
      "Comfy.Node.SnapHighlightsNode"
    );
  });
  watchEffect(() => {
    LGraphNode.keepAllLinksOnBypass = settingStore.get(
      "Comfy.Node.BypassAllLinksOnDelete"
    );
  });
  watchEffect(() => {
    LiteGraph.middle_click_slot_add_default_node = settingStore.get(
      "Comfy.Node.MiddleClickRerouteNode"
    );
  });
  watchEffect(() => {
    const linkRenderMode = settingStore.get("Comfy.LinkRenderMode");
    if (canvasStore.canvas) {
      canvasStore.canvas.links_render_mode = linkRenderMode;
      canvasStore.canvas.setDirty(
        /* fg */
        false,
        /* bg */
        true
      );
    }
  });
  watchEffect(() => {
    const minFontSizeForLOD = settingStore.get(
      "LiteGraph.Canvas.MinFontSizeForLOD"
    );
    if (canvasStore.canvas) {
      canvasStore.canvas.min_font_size_for_lod = minFontSizeForLOD;
      canvasStore.canvas.setDirty(
        /* fg */
        true,
        /* bg */
        true
      );
    }
  });
  watchEffect(() => {
    const linkMarkerShape = settingStore.get("Comfy.Graph.LinkMarkers");
    const { canvas } = canvasStore;
    if (canvas) {
      canvas.linkMarkerShape = linkMarkerShape;
      canvas.setDirty(false, true);
    }
  });
  watchEffect(() => {
    const maximumFps = settingStore.get("LiteGraph.Canvas.MaximumFps");
    const { canvas } = canvasStore;
    if (canvas) canvas.maximumFps = maximumFps;
  });
  watchEffect(() => {
    const dragZoomEnabled = settingStore.get("Comfy.Graph.CtrlShiftZoom");
    const { canvas } = canvasStore;
    if (canvas) canvas.dragZoomEnabled = dragZoomEnabled;
  });
  watchEffect(() => {
    CanvasPointer.doubleClickTime = settingStore.get(
      "Comfy.Pointer.DoubleClickTime"
    );
  });
  watchEffect(() => {
    CanvasPointer.bufferTime = settingStore.get("Comfy.Pointer.ClickBufferTime");
  });
  watchEffect(() => {
    CanvasPointer.maxClickDrift = settingStore.get("Comfy.Pointer.ClickDrift");
  });
  watchEffect(() => {
    LiteGraph.CANVAS_GRID_SIZE = settingStore.get("Comfy.SnapToGrid.GridSize");
  });
  watchEffect(() => {
    LiteGraph.alwaysSnapToGrid = settingStore.get("pysssss.SnapToGrid");
  });
  watchEffect(() => {
    LiteGraph.context_menu_scaling = settingStore.get(
      "LiteGraph.ContextMenu.Scaling"
    );
  });
  watchEffect(() => {
    LiteGraph.Reroute.maxSplineOffset = settingStore.get(
      "LiteGraph.Reroute.SplineOffset"
    );
  });
  watchEffect(() => {
    const navigationMode = settingStore.get("Comfy.Canvas.NavigationMode");
    LiteGraph.canvasNavigationMode = navigationMode;
    LiteGraph.macTrackpadGestures = navigationMode === "standard";
  });
  watchEffect(() => {
    const leftMouseBehavior = settingStore.get(
      "Comfy.Canvas.LeftMouseClickBehavior"
    );
    LiteGraph.leftMouseClickBehavior = leftMouseBehavior;
  });
  watchEffect(() => {
    const mouseWheelScroll = settingStore.get(
      "Comfy.Canvas.MouseWheelScroll"
    );
    LiteGraph.mouseWheelScroll = mouseWheelScroll;
  });
  watchEffect(() => {
    LiteGraph.saveViewportWithGraph = settingStore.get(
      "Comfy.EnableWorkflowViewRestore"
    );
  });
}, "useLitegraphSettings");
const CORE_SETTINGS = [
  {
    id: "Comfy.Memory.AllowManualUnload",
    name: "Allow manual unload of models and execution cache via user command",
    type: "hidden",
    defaultValue: true,
    versionAdded: "1.18.0"
  },
  {
    id: "Comfy.Validation.Workflows",
    name: "Validate workflows",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.NodeSearchBoxImpl",
    category: ["Comfy", "Node Search Box", "Implementation"],
    experimental: true,
    name: "Node search box implementation",
    type: "combo",
    options: ["default", "litegraph (legacy)"],
    defaultValue: "default"
  },
  {
    id: "Comfy.LinkRelease.Action",
    category: ["LiteGraph", "LinkRelease", "Action"],
    name: "Action on link release (No modifier)",
    type: "combo",
    options: Object.values(LinkReleaseTriggerAction),
    defaultValue: LinkReleaseTriggerAction.CONTEXT_MENU,
    defaultsByInstallVersion: {
      "1.24.1": LinkReleaseTriggerAction.SEARCH_BOX
    }
  },
  {
    id: "Comfy.LinkRelease.ActionShift",
    category: ["LiteGraph", "LinkRelease", "ActionShift"],
    name: "Action on link release (Shift)",
    type: "combo",
    options: Object.values(LinkReleaseTriggerAction),
    defaultValue: LinkReleaseTriggerAction.SEARCH_BOX,
    defaultsByInstallVersion: {
      "1.24.1": LinkReleaseTriggerAction.CONTEXT_MENU
    }
  },
  {
    id: "Comfy.NodeSearchBoxImpl.NodePreview",
    category: ["Comfy", "Node Search Box", "NodePreview"],
    name: "Node preview",
    tooltip: "Only applies to the default implementation",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.NodeSearchBoxImpl.ShowCategory",
    category: ["Comfy", "Node Search Box", "ShowCategory"],
    name: "Show node category in search results",
    tooltip: "Only applies to the default implementation",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.NodeSearchBoxImpl.ShowIdName",
    category: ["Comfy", "Node Search Box", "ShowIdName"],
    name: "Show node id name in search results",
    tooltip: "Only applies to the default implementation",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.NodeSearchBoxImpl.ShowNodeFrequency",
    category: ["Comfy", "Node Search Box", "ShowNodeFrequency"],
    name: "Show node frequency in search results",
    tooltip: "Only applies to the default implementation",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.Sidebar.Location",
    category: ["Appearance", "Sidebar", "Location"],
    name: "Sidebar location",
    type: "combo",
    options: ["left", "right"],
    defaultValue: "left"
  },
  {
    id: "Comfy.Sidebar.Size",
    category: ["Appearance", "Sidebar", "Size"],
    name: "Sidebar size",
    type: "combo",
    options: ["normal", "small"],
    // Default to small if the window is less than 1536px(2xl) wide.
    defaultValue: /* @__PURE__ */ __name(() => window.innerWidth < 1536 ? "small" : "normal", "defaultValue")
  },
  {
    id: "Comfy.Sidebar.UnifiedWidth",
    category: ["Appearance", "Sidebar", "UnifiedWidth"],
    name: "Unified sidebar width",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.18.1"
  },
  {
    id: "Comfy.TextareaWidget.FontSize",
    category: ["Appearance", "Node Widget", "TextareaWidget", "FontSize"],
    name: "Textarea widget font size",
    type: "slider",
    defaultValue: 10,
    attrs: {
      min: 8,
      max: 24
    }
  },
  {
    id: "Comfy.TextareaWidget.Spellcheck",
    category: ["Comfy", "Node Widget", "TextareaWidget", "Spellcheck"],
    name: "Textarea widget spellcheck",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.Workflow.SortNodeIdOnSave",
    name: "Sort node IDs when saving workflow",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.Canvas.NavigationMode",
    category: ["LiteGraph", "Canvas Navigation", "NavigationMode"],
    name: "Navigation Mode",
    defaultValue: "legacy",
    type: "combo",
    sortOrder: 100,
    options: [
      { value: "standard", text: "Standard (New)" },
      { value: "legacy", text: "Drag Navigation" },
      { value: "custom", text: "Custom" }
    ],
    versionAdded: "1.25.0",
    defaultsByInstallVersion: {
      "1.25.0": "legacy"
    },
    onChange: /* @__PURE__ */ __name(async (newValue) => {
      const settingStore = useSettingStore();
      if (newValue === "standard") {
        await settingStore.set("Comfy.Canvas.LeftMouseClickBehavior", "select");
        await settingStore.set("Comfy.Canvas.MouseWheelScroll", "panning");
      } else if (newValue === "legacy") {
        await settingStore.set("Comfy.Canvas.LeftMouseClickBehavior", "panning");
        await settingStore.set("Comfy.Canvas.MouseWheelScroll", "zoom");
      }
    }, "onChange")
  },
  {
    id: "Comfy.Canvas.LeftMouseClickBehavior",
    category: ["LiteGraph", "Canvas Navigation", "LeftMouseClickBehavior"],
    name: "Left Mouse Click Behavior",
    defaultValue: "panning",
    type: "radio",
    sortOrder: 50,
    options: [
      { value: "panning", text: "Panning" },
      { value: "select", text: "Select" }
    ],
    versionAdded: "1.27.4",
    onChange: /* @__PURE__ */ __name(async (newValue) => {
      const settingStore = useSettingStore();
      const navigationMode = settingStore.get("Comfy.Canvas.NavigationMode");
      if (navigationMode !== "custom") {
        if (newValue === "select" && navigationMode === "standard" || newValue === "panning" && navigationMode === "legacy") {
          return;
        }
        await settingStore.set("Comfy.Canvas.NavigationMode", "custom");
      }
    }, "onChange")
  },
  {
    id: "Comfy.Canvas.MouseWheelScroll",
    category: ["LiteGraph", "Canvas Navigation", "MouseWheelScroll"],
    name: "Mouse Wheel Scroll",
    defaultValue: "zoom",
    type: "radio",
    options: [
      { value: "panning", text: "Panning" },
      { value: "zoom", text: "Zoom in/out" }
    ],
    versionAdded: "1.27.4",
    onChange: /* @__PURE__ */ __name(async (newValue) => {
      const settingStore = useSettingStore();
      const navigationMode = settingStore.get("Comfy.Canvas.NavigationMode");
      if (navigationMode !== "custom") {
        if (newValue === "panning" && navigationMode === "standard" || newValue === "zoom" && navigationMode === "legacy") {
          return;
        }
        await settingStore.set("Comfy.Canvas.NavigationMode", "custom");
      }
    }, "onChange")
  },
  {
    id: "Comfy.Graph.CanvasInfo",
    category: ["LiteGraph", "Canvas", "CanvasInfo"],
    name: "Show canvas info on bottom left corner (fps, etc.)",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Node.ShowDeprecated",
    name: "Show deprecated nodes in search",
    tooltip: "Deprecated nodes are hidden by default in the UI, but remain functional in existing workflows that use them.",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.Node.ShowExperimental",
    name: "Show experimental nodes in search",
    tooltip: "Experimental nodes are marked as such in the UI and may be subject to significant changes or removal in future versions. Use with caution in production workflows",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Node.Opacity",
    category: ["Appearance", "Node", "Opacity"],
    name: "Node opacity",
    type: "slider",
    defaultValue: 1,
    attrs: {
      min: 0.01,
      max: 1,
      step: 0.01
    }
  },
  {
    id: "Comfy.Workflow.ShowMissingNodesWarning",
    name: "Show missing nodes warning",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Workflow.ShowMissingModelsWarning",
    name: "Show missing models warning",
    type: "boolean",
    defaultValue: true,
    experimental: true
  },
  {
    id: "Comfy.Workflow.WarnBlueprintOverwrite",
    name: "Require confirmation to overwrite an existing subgraph blueprint",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Graph.ZoomSpeed",
    category: ["LiteGraph", "Canvas", "ZoomSpeed"],
    name: "Canvas zoom speed",
    type: "slider",
    defaultValue: 1.1,
    attrs: {
      min: 1.01,
      max: 2.5,
      step: 0.01
    }
  },
  // Bookmarks are stored in the settings store.
  // Bookmarks are in format of category/display_name. e.g. "conditioning/CLIPTextEncode"
  {
    id: "Comfy.NodeLibrary.Bookmarks",
    name: "Node library bookmarks with display name (deprecated)",
    type: "hidden",
    defaultValue: [],
    deprecated: true
  },
  {
    id: "Comfy.NodeLibrary.Bookmarks.V2",
    name: "Node library bookmarks v2 with unique name",
    type: "hidden",
    defaultValue: []
  },
  // Stores mapping from bookmark folder name to its customization.
  {
    id: "Comfy.NodeLibrary.BookmarksCustomization",
    name: "Node library bookmarks customization",
    type: "hidden",
    defaultValue: {}
  },
  // Hidden setting used by the queue for how to fit images
  {
    id: "Comfy.Queue.ImageFit",
    name: "Queue image fit",
    type: "hidden",
    defaultValue: "cover"
  },
  {
    id: "Comfy.GroupSelectedNodes.Padding",
    category: ["LiteGraph", "Group", "Padding"],
    name: "Group selected nodes padding",
    type: "slider",
    defaultValue: 10,
    attrs: {
      min: 0,
      max: 100
    }
  },
  {
    id: "Comfy.Node.DoubleClickTitleToEdit",
    category: ["LiteGraph", "Node", "DoubleClickTitleToEdit"],
    name: "Double click node title to edit",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Node.AllowImageSizeDraw",
    category: ["LiteGraph", "Node Widget", "AllowImageSizeDraw"],
    name: "Show width × height below the image preview",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Group.DoubleClickTitleToEdit",
    category: ["LiteGraph", "Group", "DoubleClickTitleToEdit"],
    name: "Double click group title to edit",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Window.UnloadConfirmation",
    name: "Show confirmation when closing window",
    type: "boolean",
    defaultValue: true,
    versionModified: "1.7.12"
  },
  {
    id: "Comfy.TreeExplorer.ItemPadding",
    category: ["Appearance", "Tree Explorer", "ItemPadding"],
    name: "Tree explorer item padding",
    type: "slider",
    defaultValue: 2,
    attrs: {
      min: 0,
      max: 8,
      step: 1
    }
  },
  {
    id: "Comfy.ModelLibrary.AutoLoadAll",
    name: "Automatically load all model folders",
    tooltip: "If true, all folders will load as soon as you open the model library (this may cause delays while it loads). If false, root level model folders will only load once you click on them.",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.ModelLibrary.NameFormat",
    name: "What name to display in the model library tree view",
    tooltip: 'Select "filename" to render a simplified view of the raw filename (without directory or ".safetensors" extension) in the model list. Select "title" to display the configurable model metadata title.',
    type: "combo",
    options: ["filename", "title"],
    defaultValue: "title"
  },
  {
    id: "Comfy.Locale",
    name: "Language",
    type: "combo",
    options: [
      { value: "en", text: "English" },
      { value: "zh", text: "中文" },
      { value: "zh-TW", text: "繁體中文" },
      { value: "ru", text: "Русский" },
      { value: "ja", text: "日本語" },
      { value: "ko", text: "한국어" },
      { value: "fr", text: "Français" },
      { value: "es", text: "Español" },
      { value: "ar", text: "عربي" }
    ],
    defaultValue: /* @__PURE__ */ __name(() => navigator.language.split("-")[0] || "en", "defaultValue")
  },
  {
    id: "Comfy.NodeBadge.NodeSourceBadgeMode",
    category: ["LiteGraph", "Node", "NodeSourceBadgeMode"],
    name: "Node source badge mode",
    type: "combo",
    options: Object.values(NodeBadgeMode),
    defaultValue: NodeBadgeMode.HideBuiltIn
  },
  {
    id: "Comfy.NodeBadge.NodeIdBadgeMode",
    category: ["LiteGraph", "Node", "NodeIdBadgeMode"],
    name: "Node ID badge mode",
    type: "combo",
    options: [NodeBadgeMode.None, NodeBadgeMode.ShowAll],
    defaultValue: NodeBadgeMode.None
  },
  {
    id: "Comfy.NodeBadge.NodeLifeCycleBadgeMode",
    category: ["LiteGraph", "Node", "NodeLifeCycleBadgeMode"],
    name: "Node life cycle badge mode",
    type: "combo",
    options: [NodeBadgeMode.None, NodeBadgeMode.ShowAll],
    defaultValue: NodeBadgeMode.ShowAll
  },
  {
    id: "Comfy.NodeBadge.ShowApiPricing",
    category: ["Comfy", "API Nodes"],
    name: "Show API node pricing badge",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.20.3"
  },
  {
    id: "Comfy.Notification.ShowVersionUpdates",
    category: ["Comfy", "Notification Preferences"],
    name: "Show version updates",
    tooltip: "Show updates for new models, and major new features.",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.ConfirmClear",
    category: ["Comfy", "Workflow", "ConfirmClear"],
    name: "Require confirmation when clearing workflow",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.PromptFilename",
    category: ["Comfy", "Workflow", "PromptFilename"],
    name: "Prompt for filename when saving workflow",
    type: "boolean",
    defaultValue: true
  },
  /**
   * file format for preview
   *
   * format;quality
   *
   * ex)
   * webp;50 -> webp, quality 50
   * jpeg;80 -> rgb, jpeg, quality 80
   *
   * @type {string}
   */
  {
    id: "Comfy.PreviewFormat",
    category: ["LiteGraph", "Node Widget", "PreviewFormat"],
    name: "Preview image format",
    tooltip: "When displaying a preview in the image widget, convert it to a lightweight image, e.g. webp, jpeg, webp;50, etc.",
    type: "text",
    defaultValue: ""
  },
  {
    id: "Comfy.DisableSliders",
    category: ["LiteGraph", "Node Widget", "DisableSliders"],
    name: "Disable node widget sliders",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.DisableFloatRounding",
    category: ["LiteGraph", "Node Widget", "DisableFloatRounding"],
    name: "Disable default float widget rounding.",
    tooltip: "(requires page reload) Cannot disable round when round is set by the node in the backend.",
    type: "boolean",
    defaultValue: false
  },
  {
    id: "Comfy.FloatRoundingPrecision",
    category: ["LiteGraph", "Node Widget", "FloatRoundingPrecision"],
    name: "Float widget rounding decimal places [0 = auto].",
    tooltip: "(requires page reload)",
    type: "slider",
    attrs: {
      min: 0,
      max: 6,
      step: 1
    },
    defaultValue: 0
  },
  {
    id: "LiteGraph.Node.TooltipDelay",
    name: "Tooltip Delay",
    type: "number",
    attrs: {
      min: 100,
      max: 3e3,
      step: 50
    },
    defaultValue: 500,
    versionAdded: "1.9.0"
  },
  {
    id: "Comfy.EnableTooltips",
    category: ["LiteGraph", "Node", "EnableTooltips"],
    name: "Enable Tooltips",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.DevMode",
    name: "Enable dev mode options (API save, etc.)",
    type: "boolean",
    defaultValue: false,
    onChange: /* @__PURE__ */ __name((value) => {
      const element = document.getElementById("comfy-dev-save-api-button");
      if (element) {
        element.style.display = value ? "flex" : "none";
      }
    }, "onChange")
  },
  {
    id: "Comfy.UseNewMenu",
    category: ["Comfy", "Menu", "UseNewMenu"],
    defaultValue: "Top",
    name: "Use new menu",
    type: "combo",
    options: ["Disabled", "Top", "Bottom"],
    tooltip: "Menu bar position. On mobile devices, the menu is always shown at the top.",
    migrateDeprecatedValue: /* @__PURE__ */ __name((value) => {
      if (value === "Floating") {
        return "Top";
      }
      return value;
    }, "migrateDeprecatedValue")
  },
  {
    id: "Comfy.Workflow.WorkflowTabsPosition",
    name: "Opened workflows position",
    type: "combo",
    options: ["Sidebar", "Topbar", "Topbar (2nd-row)"],
    // Default to topbar (2nd-row) if the window is less than 1536px(2xl) wide.
    defaultValue: /* @__PURE__ */ __name(() => window.innerWidth < 1536 ? "Topbar (2nd-row)" : "Topbar", "defaultValue")
  },
  {
    id: "Comfy.Graph.CanvasMenu",
    category: ["LiteGraph", "Canvas", "CanvasMenu"],
    name: "Show graph canvas menu",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.QueueButton.BatchCountLimit",
    name: "Batch count limit",
    tooltip: "The maximum number of tasks added to the queue at one button click",
    type: "number",
    defaultValue: 100,
    versionAdded: "1.3.5"
  },
  {
    id: "Comfy.Keybinding.UnsetBindings",
    name: "Keybindings unset by the user",
    type: "hidden",
    defaultValue: [],
    versionAdded: "1.3.7",
    versionModified: "1.7.3",
    migrateDeprecatedValue: /* @__PURE__ */ __name((value) => {
      return value.map((keybinding) => {
        if (keybinding["targetSelector"] === "#graph-canvas") {
          keybinding["targetElementId"] = "graph-canvas";
        }
        return keybinding;
      });
    }, "migrateDeprecatedValue")
  },
  {
    id: "Comfy.Keybinding.NewBindings",
    name: "Keybindings set by the user",
    type: "hidden",
    defaultValue: [],
    versionAdded: "1.3.7"
  },
  {
    id: "Comfy.Extension.Disabled",
    name: "Disabled extension names",
    type: "hidden",
    defaultValue: [],
    versionAdded: "1.3.11"
  },
  {
    id: "Comfy.LinkRenderMode",
    category: ["LiteGraph", "Graph", "LinkRenderMode"],
    name: "Link Render Mode",
    defaultValue: 2,
    type: "combo",
    options: [
      { value: LiteGraph.STRAIGHT_LINK, text: "Straight" },
      { value: LiteGraph.LINEAR_LINK, text: "Linear" },
      { value: LiteGraph.SPLINE_LINK, text: "Spline" },
      { value: LiteGraph.HIDDEN_LINK, text: "Hidden" }
    ]
  },
  {
    id: "Comfy.Node.AutoSnapLinkToSlot",
    category: ["LiteGraph", "Node", "AutoSnapLinkToSlot"],
    name: "Auto snap link to node slot",
    tooltip: "When dragging a link over a node, the link automatically snap to a viable input slot on the node",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.3.29"
  },
  {
    id: "Comfy.Node.SnapHighlightsNode",
    category: ["LiteGraph", "Node", "SnapHighlightsNode"],
    name: "Snap highlights node",
    tooltip: "When dragging a link over a node with viable input slot, highlight the node",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.3.29"
  },
  {
    id: "Comfy.Node.BypassAllLinksOnDelete",
    category: ["LiteGraph", "Node", "BypassAllLinksOnDelete"],
    name: "Keep all links when deleting nodes",
    tooltip: "When deleting a node, attempt to reconnect all of its input and output links (bypassing the deleted node)",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.3.40"
  },
  {
    id: "Comfy.Node.MiddleClickRerouteNode",
    category: ["LiteGraph", "Node", "MiddleClickRerouteNode"],
    name: "Middle-click creates a new Reroute node",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.3.42"
  },
  {
    id: "Comfy.Graph.LinkMarkers",
    category: ["LiteGraph", "Link", "LinkMarkers"],
    name: "Link midpoint markers",
    defaultValue: LinkMarkerShape.Circle,
    type: "combo",
    options: [
      { value: LinkMarkerShape.None, text: "None" },
      { value: LinkMarkerShape.Circle, text: "Circle" },
      { value: LinkMarkerShape.Arrow, text: "Arrow" }
    ],
    versionAdded: "1.3.42"
  },
  {
    id: "Comfy.DOMClippingEnabled",
    category: ["LiteGraph", "Node", "DOMClippingEnabled"],
    name: "Enable DOM element clipping (enabling may reduce performance)",
    type: "boolean",
    defaultValue: true
  },
  {
    id: "Comfy.Graph.CtrlShiftZoom",
    category: ["LiteGraph", "Canvas", "CtrlShiftZoom"],
    name: "Enable fast-zoom shortcut (Ctrl + Shift + Drag)",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.4.0"
  },
  {
    id: "Comfy.Pointer.ClickDrift",
    category: ["LiteGraph", "Pointer", "ClickDrift"],
    name: "Pointer click drift (maximum distance)",
    tooltip: "If the pointer moves more than this distance while holding a button down, it is considered dragging (rather than clicking).\n\nHelps prevent objects from being unintentionally nudged if the pointer is moved whilst clicking.",
    experimental: true,
    type: "slider",
    attrs: {
      min: 0,
      max: 20,
      step: 1
    },
    defaultValue: 6,
    versionAdded: "1.4.3"
  },
  {
    id: "Comfy.Pointer.ClickBufferTime",
    category: ["LiteGraph", "Pointer", "ClickBufferTime"],
    name: "Pointer click drift delay",
    tooltip: "After pressing a pointer button down, this is the maximum time (in milliseconds) that pointer movement can be ignored for.\n\nHelps prevent objects from being unintentionally nudged if the pointer is moved whilst clicking.",
    experimental: true,
    type: "slider",
    attrs: {
      min: 0,
      max: 1e3,
      step: 25
    },
    defaultValue: 150,
    versionAdded: "1.4.3"
  },
  {
    id: "Comfy.Pointer.DoubleClickTime",
    category: ["LiteGraph", "Pointer", "DoubleClickTime"],
    name: "Double click interval (maximum)",
    tooltip: "The maximum time in milliseconds between the two clicks of a double-click.  Increasing this value may assist if double-clicks are sometimes not registered.",
    type: "slider",
    attrs: {
      min: 100,
      max: 1e3,
      step: 50
    },
    defaultValue: 300,
    versionAdded: "1.4.3"
  },
  {
    id: "Comfy.SnapToGrid.GridSize",
    category: ["LiteGraph", "Canvas", "GridSize"],
    name: "Snap to grid size",
    type: "slider",
    attrs: {
      min: 1,
      max: 500
    },
    tooltip: "When dragging and resizing nodes while holding shift they will be aligned to the grid, this controls the size of that grid.",
    defaultValue: LiteGraph.CANVAS_GRID_SIZE
  },
  // Keep the 'pysssss.SnapToGrid' setting id so we don't need to migrate setting values.
  // Using a new setting id can cause existing users to lose their existing settings.
  {
    id: "pysssss.SnapToGrid",
    category: ["LiteGraph", "Canvas", "AlwaysSnapToGrid"],
    name: "Always snap to grid",
    type: "boolean",
    defaultValue: false,
    versionAdded: "1.3.13"
  },
  {
    id: "Comfy.Server.ServerConfigValues",
    name: "Server config values for frontend display",
    tooltip: "Server config values used for frontend display only",
    type: "hidden",
    // Mapping from server config id to value.
    defaultValue: {},
    versionAdded: "1.4.8"
  },
  {
    id: "Comfy.Server.LaunchArgs",
    name: "Server launch arguments",
    tooltip: "These are the actual arguments that are passed to the server when it is launched.",
    type: "hidden",
    defaultValue: {},
    versionAdded: "1.4.8"
  },
  {
    id: "Comfy.Queue.MaxHistoryItems",
    name: "Queue history size",
    tooltip: "The maximum number of tasks that show in the queue history.",
    type: "slider",
    attrs: {
      min: 2,
      max: 256,
      step: 2
    },
    defaultValue: 64,
    versionAdded: "1.4.12"
  },
  {
    id: "LiteGraph.Canvas.MaximumFps",
    name: "Maximum FPS",
    tooltip: "The maximum frames per second that the canvas is allowed to render. Caps GPU usage at the cost of smoothness. If 0, the screen refresh rate is used. Default: 0",
    type: "slider",
    attrs: {
      min: 0,
      max: 120
    },
    defaultValue: 0,
    versionAdded: "1.5.1"
  },
  {
    id: "Comfy.EnableWorkflowViewRestore",
    category: ["Comfy", "Workflow", "EnableWorkflowViewRestore"],
    name: "Save and restore canvas position and zoom level in workflows",
    type: "boolean",
    defaultValue: true,
    versionModified: "1.5.4"
  },
  {
    id: "Comfy.Workflow.ConfirmDelete",
    name: "Show confirmation when deleting workflows",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.5.6"
  },
  {
    id: "Comfy.ColorPalette",
    name: "The active color palette id",
    type: "hidden",
    defaultValue: "dark",
    versionModified: "1.6.7",
    migrateDeprecatedValue(value) {
      return value.startsWith("custom_") ? value.replace("custom_", "") : value;
    }
  },
  {
    id: "Comfy.CustomColorPalettes",
    name: "Custom color palettes",
    type: "hidden",
    defaultValue: {},
    versionModified: "1.6.7"
  },
  {
    id: "Comfy.WidgetControlMode",
    category: ["Comfy", "Node Widget", "WidgetControlMode"],
    name: "Widget control mode",
    tooltip: "Controls when widget values are updated (randomize/increment/decrement), either before the prompt is queued or after.",
    type: "combo",
    defaultValue: "after",
    options: ["before", "after"],
    versionModified: "1.6.10"
  },
  {
    id: "Comfy.TutorialCompleted",
    name: "Tutorial completed",
    type: "hidden",
    defaultValue: false,
    versionAdded: "1.8.7"
  },
  {
    id: "Comfy.InstalledVersion",
    name: "The frontend version that was running when the user first installed ComfyUI",
    type: "hidden",
    defaultValue: null,
    versionAdded: "1.24.0"
  },
  {
    id: "LiteGraph.ContextMenu.Scaling",
    name: "Scale node combo widget menus (lists) when zoomed in",
    defaultValue: false,
    type: "boolean",
    versionAdded: "1.8.8"
  },
  {
    id: "LiteGraph.Canvas.LowQualityRenderingZoomThreshold",
    type: "hidden",
    deprecated: true,
    name: "Low quality rendering zoom threshold (deprecated)",
    tooltip: "Zoom level threshold for performance mode. Lower values (0.1) = quality at all zoom levels. Higher values (1.0) = performance mode even when zoomed in. Performance mode simplifies rendering by hiding text labels, shadows, and details.",
    attrs: {
      min: 0.1,
      max: 1,
      step: 0.01
    },
    defaultValue: 0.6,
    versionAdded: "1.9.1",
    versionModified: "1.26.7"
  },
  {
    id: "LiteGraph.Canvas.MinFontSizeForLOD",
    name: "Zoom Node Level of Detail - font size threshold",
    tooltip: "Controls when the nodes switch to low quality LOD rendering. Uses font size in pixels to determine when to switch. Set to 0 to disable. Values 1-24 set the minimum font size threshold for LOD - higher values (24px) = switch nodes to simplified rendering sooner when zooming out, lower values (1px) = maintain full node quality longer.",
    type: "slider",
    attrs: {
      min: 0,
      max: 24,
      step: 1
    },
    defaultValue: 8,
    versionAdded: "1.26.7"
  },
  {
    id: "Comfy.Canvas.SelectionToolbox",
    category: ["LiteGraph", "Canvas", "SelectionToolbox"],
    name: "Show selection toolbox",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.10.5"
  },
  {
    id: "LiteGraph.Reroute.SplineOffset",
    name: "Reroute spline offset",
    tooltip: "The bezier control point offset from the reroute centre point",
    type: "slider",
    defaultValue: 20,
    attrs: {
      min: 0,
      max: 400
    },
    versionAdded: "1.15.7"
  },
  {
    id: "Comfy.Toast.DisableReconnectingToast",
    name: "Disable toasts when reconnecting or reconnected",
    type: "hidden",
    defaultValue: false,
    versionAdded: "1.15.12"
  },
  {
    id: "Comfy.Minimap.Visible",
    name: "Display minimap on canvas",
    type: "hidden",
    defaultValue: true,
    versionAdded: "1.25.0"
  },
  {
    id: "Comfy.Minimap.NodeColors",
    name: "Display node with its original color on minimap",
    type: "hidden",
    defaultValue: false,
    versionAdded: "1.26.0"
  },
  {
    id: "Comfy.Minimap.ShowLinks",
    name: "Display links on minimap",
    type: "hidden",
    defaultValue: true,
    versionAdded: "1.26.0"
  },
  {
    id: "Comfy.Minimap.ShowGroups",
    name: "Display node groups on minimap",
    type: "hidden",
    defaultValue: true,
    versionAdded: "1.26.0"
  },
  {
    id: "Comfy.Minimap.RenderBypassState",
    name: "Render bypass state on minimap",
    type: "hidden",
    defaultValue: true,
    versionAdded: "1.26.0"
  },
  {
    id: "Comfy.Minimap.RenderErrorState",
    name: "Render error state on minimap",
    type: "hidden",
    defaultValue: true,
    versionAdded: "1.26.0"
  },
  {
    id: "Comfy.Workflow.AutoSaveDelay",
    name: "Auto Save Delay (ms)",
    defaultValue: 1e3,
    type: "number",
    tooltip: 'Only applies if Auto Save is set to "after delay".',
    versionAdded: "1.16.0"
  },
  {
    id: "Comfy.Workflow.AutoSave",
    name: "Auto Save",
    type: "combo",
    options: ["off", "after delay"],
    // Room for other options like on focus change, tab change, window change
    defaultValue: "off",
    // Popular requst by users (https://github.com/Comfy-Org/ComfyUI_frontend/issues/1584#issuecomment-2536610154)
    versionAdded: "1.16.0"
  },
  {
    id: "Comfy.Workflow.Persist",
    name: "Persist workflow state and restore on page (re)load",
    type: "boolean",
    defaultValue: true,
    versionAdded: "1.16.1"
  },
  {
    id: "LiteGraph.Node.DefaultPadding",
    name: "Always shrink new nodes",
    tooltip: "Resize nodes to the smallest possible size when created. When disabled, a newly added node will be widened slightly to show widget values.",
    type: "boolean",
    defaultValue: false,
    versionAdded: "1.18.0"
  },
  {
    id: "Comfy.Canvas.BackgroundImage",
    category: ["Appearance", "Canvas", "Background"],
    name: "Canvas background image",
    type: "backgroundImage",
    tooltip: 'Image URL for the canvas background. You can right-click an image in the outputs panel and select "Set as Background" to use it, or upload your own image using the upload button.',
    defaultValue: "",
    versionAdded: "1.20.4",
    versionModified: "1.20.5"
  },
  // Release data stored in settings
  {
    id: "Comfy.Release.Version",
    name: "Last seen release version",
    type: "hidden",
    defaultValue: ""
  },
  {
    id: "Comfy.Release.Status",
    name: "Release status",
    type: "hidden",
    defaultValue: "skipped"
  },
  {
    id: "Comfy.Release.Timestamp",
    name: "Release seen timestamp",
    type: "hidden",
    defaultValue: 0
  },
  /**
   * Vue Node System Settings
   */
  {
    id: "Comfy.VueNodes.Enabled",
    name: "Enable Vue node rendering (hidden)",
    type: "hidden",
    tooltip: "Render nodes as Vue components instead of canvas. Hidden; toggle via Experimental keybinding.",
    defaultValue: false,
    experimental: true,
    versionAdded: "1.27.1"
  },
  {
    id: "Comfy.Assets.UseAssetAPI",
    name: "Use Asset API for model library",
    type: "boolean",
    tooltip: "Use new Asset API for model browsing",
    defaultValue: false,
    experimental: true
  }
];
function useWorkflowAutoSave() {
  const workflowStore = useWorkflowStore();
  const settingStore = useSettingStore();
  const workflowService = useWorkflowService();
  const autoSaveSetting = computed(
    () => settingStore.get("Comfy.Workflow.AutoSave")
  );
  const autoSaveDelay = computed(
    () => settingStore.get("Comfy.Workflow.AutoSaveDelay")
  );
  let autoSaveTimeout = null;
  let isSaving = false;
  let needsAutoSave = false;
  const scheduleAutoSave = /* @__PURE__ */ __name(() => {
    if (autoSaveTimeout) {
      clearTimeout(autoSaveTimeout);
      autoSaveTimeout = null;
    }
    if (autoSaveSetting.value === "after delay") {
      if (isSaving) {
        needsAutoSave = true;
        return;
      }
      const delay2 = autoSaveDelay.value;
      autoSaveTimeout = setTimeout(async () => {
        const activeWorkflow = workflowStore.activeWorkflow;
        if (activeWorkflow?.isModified && activeWorkflow.isPersisted) {
          try {
            isSaving = true;
            await workflowService.saveWorkflow(activeWorkflow);
          } catch (err) {
            console.error("Auto save failed:", err);
          } finally {
            isSaving = false;
            if (needsAutoSave) {
              needsAutoSave = false;
              scheduleAutoSave();
            }
          }
        }
      }, delay2);
    }
  }, "scheduleAutoSave");
  watch(
    autoSaveSetting,
    (newSetting) => {
      if (autoSaveTimeout) {
        clearTimeout(autoSaveTimeout);
        autoSaveTimeout = null;
      }
      if (newSetting === "after delay" && workflowStore.activeWorkflow?.isModified) {
        scheduleAutoSave();
      }
    },
    { immediate: true }
  );
  const onGraphChanged = /* @__PURE__ */ __name(() => {
    scheduleAutoSave();
  }, "onGraphChanged");
  api.addEventListener("graphChanged", onGraphChanged);
  onUnmounted(() => {
    if (autoSaveTimeout) {
      clearTimeout(autoSaveTimeout);
      autoSaveTimeout = null;
    }
    api.removeEventListener("graphChanged", onGraphChanged);
  });
}
__name(useWorkflowAutoSave, "useWorkflowAutoSave");
function useWorkflowPersistence() {
  const workflowStore = useWorkflowStore();
  const settingStore = useSettingStore();
  const workflowPersistenceEnabled = computed(
    () => settingStore.get("Comfy.Workflow.Persist")
  );
  const persistCurrentWorkflow = /* @__PURE__ */ __name(() => {
    if (!workflowPersistenceEnabled.value) return;
    const workflow = JSON.stringify(app.graph.serialize());
    localStorage.setItem("workflow", workflow);
    if (api.clientId) {
      sessionStorage.setItem(`workflow:${api.clientId}`, workflow);
    }
  }, "persistCurrentWorkflow");
  const loadWorkflowFromStorage = /* @__PURE__ */ __name(async (json, workflowName) => {
    if (!json) return false;
    const workflow = JSON.parse(json);
    await app.loadGraphData(workflow, true, true, workflowName);
    return true;
  }, "loadWorkflowFromStorage");
  const loadPreviousWorkflowFromStorage = /* @__PURE__ */ __name(async () => {
    const workflowName = getStorageValue("Comfy.PreviousWorkflow");
    const clientId = api.initialClientId ?? api.clientId;
    if (clientId) {
      const sessionWorkflow = sessionStorage.getItem(`workflow:${clientId}`);
      if (await loadWorkflowFromStorage(sessionWorkflow, workflowName)) {
        return true;
      }
    }
    const localWorkflow = localStorage.getItem("workflow");
    return await loadWorkflowFromStorage(localWorkflow, workflowName);
  }, "loadPreviousWorkflowFromStorage");
  const loadDefaultWorkflow = /* @__PURE__ */ __name(async () => {
    if (!settingStore.get("Comfy.TutorialCompleted")) {
      await settingStore.set("Comfy.TutorialCompleted", true);
      await useWorkflowService().loadBlankWorkflow();
      await useCommandStore().execute("Comfy.BrowseTemplates");
    } else {
      await app.loadGraphData();
    }
  }, "loadDefaultWorkflow");
  const restorePreviousWorkflow = /* @__PURE__ */ __name(async () => {
    if (!workflowPersistenceEnabled.value) return;
    try {
      const restored = await loadPreviousWorkflowFromStorage();
      if (!restored) {
        await loadDefaultWorkflow();
      }
    } catch (err) {
      console.error("Error loading previous workflow", err);
      await loadDefaultWorkflow();
    }
  }, "restorePreviousWorkflow");
  watch(
    () => workflowStore.activeWorkflow?.key,
    (activeWorkflowKey) => {
      if (!activeWorkflowKey) return;
      setStorageValue("Comfy.PreviousWorkflow", activeWorkflowKey);
      persistCurrentWorkflow();
    }
  );
  api.addEventListener("graphChanged", persistCurrentWorkflow);
  tryOnScopeDispose$1(() => {
    api.removeEventListener("graphChanged", persistCurrentWorkflow);
  });
  const openWorkflows = computed(() => workflowStore.openWorkflows);
  const activeWorkflow = computed(() => workflowStore.activeWorkflow);
  const restoreState = computed(
    () => {
      if (!openWorkflows.value || !activeWorkflow.value) {
        return { paths: [], activeIndex: -1 };
      }
      const paths = openWorkflows.value.filter((workflow) => workflow?.isPersisted && !workflow.isModified).map((workflow) => workflow.path);
      const activeIndex = openWorkflows.value.findIndex(
        (workflow) => workflow.path === activeWorkflow.value?.path
      );
      return { paths, activeIndex };
    }
  );
  const storedWorkflows = JSON.parse(
    getStorageValue("Comfy.OpenWorkflowsPaths") || "[]"
  );
  const storedActiveIndex = JSON.parse(
    getStorageValue("Comfy.ActiveWorkflowIndex") || "-1"
  );
  watch(restoreState, ({ paths, activeIndex }) => {
    if (workflowPersistenceEnabled.value) {
      setStorageValue("Comfy.OpenWorkflowsPaths", JSON.stringify(paths));
      setStorageValue("Comfy.ActiveWorkflowIndex", JSON.stringify(activeIndex));
    }
  });
  const restoreWorkflowTabsState = /* @__PURE__ */ __name(() => {
    if (!workflowPersistenceEnabled.value) return;
    const isRestorable = storedWorkflows?.length > 0 && storedActiveIndex >= 0;
    if (isRestorable) {
      workflowStore.openWorkflowsInBackground({
        left: storedWorkflows.slice(0, storedActiveIndex),
        right: storedWorkflows.slice(storedActiveIndex)
      });
    }
  }, "restoreWorkflowTabsState");
  return {
    restorePreviousWorkflow,
    restoreWorkflowTabsState
  };
}
__name(useWorkflowPersistence, "useWorkflowPersistence");
const SelectedNodeIdsKey = Symbol("selectedNodeIds");
const ExecutingNodeIdsKey = Symbol("executingNodeIds");
const NodeProgressStatesKey = Symbol("nodeProgressStates");
const TransformStateKey = Symbol("transformState");
function useCanvasTransformSync(canvas, syncFn, callbacks = {}, options = {}) {
  const { autoStart = true } = options;
  const { onStart, onUpdate, onStop } = callbacks;
  const isActive = ref(false);
  let rafId2 = null;
  const startSync = /* @__PURE__ */ __name(() => {
    if (isActive.value || !canvas) return;
    isActive.value = true;
    onStart?.();
    const sync = /* @__PURE__ */ __name(() => {
      if (!isActive.value || !canvas) return;
      try {
        const startTime = performance.now();
        syncFn(canvas);
        const endTime = performance.now();
        onUpdate?.(endTime - startTime);
      } catch (error) {
        console.warn("Canvas transform sync error:", error);
      }
      rafId2 = requestAnimationFrame(sync);
    }, "sync");
    sync();
  }, "startSync");
  const stopSync = /* @__PURE__ */ __name(() => {
    if (!isActive.value) return;
    if (rafId2 !== null) {
      cancelAnimationFrame(rafId2);
      rafId2 = null;
    }
    isActive.value = false;
    onStop?.();
  }, "stopSync");
  if (autoStart && canvas) {
    startSync();
  }
  onUnmounted(() => {
    stopSync();
  });
  return {
    isActive,
    startSync,
    stopSync
  };
}
__name(useCanvasTransformSync, "useCanvasTransformSync");
function useTransformSettling(target, options = {}) {
  const {
    settleDelay = 200,
    trackPan = false,
    pointerMoveThrottle = 16,
    passive = true
  } = options;
  const isTransforming = ref(false);
  let isPanning = false;
  const markTransformActive = /* @__PURE__ */ __name(() => {
    isTransforming.value = true;
  }, "markTransformActive");
  const markTransformSettled = useDebounceFn$1(() => {
    isTransforming.value = false;
  }, settleDelay);
  const handleTransformEvent = /* @__PURE__ */ __name(() => {
    markTransformActive();
    void markTransformSettled();
  }, "handleTransformEvent");
  const handleWheel = /* @__PURE__ */ __name(() => {
    handleTransformEvent();
  }, "handleWheel");
  const handlePointerDown2 = /* @__PURE__ */ __name(() => {
    if (trackPan) {
      isPanning = true;
      handleTransformEvent();
    }
  }, "handlePointerDown");
  const handlePointerMove2 = trackPan ? useThrottleFn$1(() => {
    if (isPanning) {
      handleTransformEvent();
    }
  }, pointerMoveThrottle) : void 0;
  const handlePointerEnd = /* @__PURE__ */ __name(() => {
    if (trackPan) {
      isPanning = false;
    }
  }, "handlePointerEnd");
  useEventListener$1(target, "wheel", handleWheel, {
    capture: true,
    passive
  });
  if (trackPan) {
    useEventListener$1(target, "pointerdown", handlePointerDown2, {
      capture: true
    });
    if (handlePointerMove2) {
      useEventListener$1(target, "pointermove", handlePointerMove2, {
        capture: true,
        passive
      });
    }
    useEventListener$1(target, "pointerup", handlePointerEnd, {
      capture: true
    });
    useEventListener$1(target, "pointercancel", handlePointerEnd, {
      capture: true
    });
  }
  return {
    isTransforming
  };
}
__name(useTransformSettling, "useTransformSettling");
const useTransformState = /* @__PURE__ */ __name(() => {
  const camera = reactive({
    x: 0,
    y: 0,
    z: 1
  });
  const transformStyle = computed(() => ({
    // Match LiteGraph DragAndScale.toCanvasContext():
    // ctx.scale(scale); ctx.translate(offset)
    // CSS applies right-to-left, so "scale() translate()" -> translate first, then scale
    // Effective mapping: screen = (canvas + offset) * scale
    transform: `scale(${camera.z}) translate(${camera.x}px, ${camera.y}px)`,
    transformOrigin: "0 0"
  }));
  const syncWithCanvas = /* @__PURE__ */ __name((canvas) => {
    if (!canvas || !canvas.ds) return;
    camera.x = canvas.ds.offset[0];
    camera.y = canvas.ds.offset[1];
    camera.z = canvas.ds.scale || 1;
  }, "syncWithCanvas");
  const canvasToScreen = /* @__PURE__ */ __name((point) => {
    return {
      x: (point.x + camera.x) * camera.z,
      y: (point.y + camera.y) * camera.z
    };
  }, "canvasToScreen");
  const screenToCanvas = /* @__PURE__ */ __name((point) => {
    return {
      x: point.x / camera.z - camera.x,
      y: point.y / camera.z - camera.y
    };
  }, "screenToCanvas");
  const getNodeScreenBounds = /* @__PURE__ */ __name((pos, size2) => {
    const topLeft = canvasToScreen({ x: pos[0], y: pos[1] });
    const width = size2[0] * camera.z;
    const height = size2[1] * camera.z;
    return new DOMRect(topLeft.x, topLeft.y, width, height);
  }, "getNodeScreenBounds");
  const calculateAdjustedMargin = /* @__PURE__ */ __name((baseMargin) => {
    if (camera.z < 0.1) return Math.min(baseMargin * 5, 2);
    if (camera.z > 3) return Math.max(baseMargin * 0.5, 0.05);
    return baseMargin;
  }, "calculateAdjustedMargin");
  const isNodeTooSmall = /* @__PURE__ */ __name((nodeSize) => {
    const nodeScreenSize = Math.max(nodeSize[0], nodeSize[1]) * camera.z;
    return nodeScreenSize < 4;
  }, "isNodeTooSmall");
  const getExpandedViewportBounds = /* @__PURE__ */ __name((viewport, margin) => {
    const marginX = viewport.width * margin;
    const marginY = viewport.height * margin;
    return {
      left: -marginX,
      right: viewport.width + marginX,
      top: -marginY,
      bottom: viewport.height + marginY
    };
  }, "getExpandedViewportBounds");
  const testViewportIntersection = /* @__PURE__ */ __name((screenPos, nodeSize, bounds) => {
    const nodeRight = screenPos.x + nodeSize[0] * camera.z;
    const nodeBottom = screenPos.y + nodeSize[1] * camera.z;
    return !(nodeRight < bounds.left || screenPos.x > bounds.right || nodeBottom < bounds.top || screenPos.y > bounds.bottom);
  }, "testViewportIntersection");
  const isNodeInViewport = /* @__PURE__ */ __name((nodePos, nodeSize, viewport, margin = 0.2) => {
    if (isNodeTooSmall(nodeSize)) return false;
    const screenPos = canvasToScreen({ x: nodePos[0], y: nodePos[1] });
    const adjustedMargin = calculateAdjustedMargin(margin);
    const bounds = getExpandedViewportBounds(viewport, adjustedMargin);
    return testViewportIntersection(screenPos, nodeSize, bounds);
  }, "isNodeInViewport");
  const getViewportBounds = /* @__PURE__ */ __name((viewport, margin = 0.2) => {
    const marginX = viewport.width * margin;
    const marginY = viewport.height * margin;
    const topLeft = screenToCanvas({ x: -marginX, y: -marginY });
    const bottomRight = screenToCanvas({
      x: viewport.width + marginX,
      y: viewport.height + marginY
    });
    return {
      x: topLeft.x,
      y: topLeft.y,
      width: bottomRight.x - topLeft.x,
      height: bottomRight.y - topLeft.y
    };
  }, "getViewportBounds");
  return {
    camera: readonly(camera),
    transformStyle,
    syncWithCanvas,
    canvasToScreen,
    screenToCanvas,
    getNodeScreenBounds,
    isNodeInViewport,
    getViewportBounds
  };
}, "useTransformState");
const _sfc_main$Z = /* @__PURE__ */ defineComponent({
  __name: "TransformPane",
  props: {
    canvas: {}
  },
  emits: ["rafStatusChange", "transformUpdate"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const {
      camera,
      transformStyle,
      syncWithCanvas,
      canvasToScreen,
      screenToCanvas,
      isNodeInViewport
    } = useTransformState();
    const canvasElement = computed(() => props2.canvas?.canvas);
    const { isTransforming: isInteracting } = useTransformSettling(canvasElement, {
      settleDelay: 200,
      trackPan: true
    });
    provide(TransformStateKey, {
      camera,
      canvasToScreen,
      screenToCanvas,
      isNodeInViewport
    });
    const handlePointerDown2 = /* @__PURE__ */ __name((event) => {
      const target = event.target;
      const nodeElement = target.closest("[data-node-id]");
      if (nodeElement) {
      }
    }, "handlePointerDown");
    const emit = __emit;
    useCanvasTransformSync(props2.canvas, syncWithCanvas, {
      onStart: /* @__PURE__ */ __name(() => emit("rafStatusChange", true), "onStart"),
      onUpdate: /* @__PURE__ */ __name((duration) => emit("transformUpdate", duration), "onUpdate"),
      onStop: /* @__PURE__ */ __name(() => emit("rafStatusChange", false), "onStop")
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["transform-pane", { "transform-pane--interacting": unref(isInteracting) }]),
        style: normalizeStyle(unref(transformStyle)),
        onPointerdown: handlePointerDown2
      }, [
        renderSlot(_ctx.$slots, "default", {}, void 0, true)
      ], 38);
    };
  }
});
const TransformPane = /* @__PURE__ */ _export_sfc(_sfc_main$Z, [["__scopeId", "data-v-23fc5704"]]);
const _hoisted_1$16 = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$l(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$16, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M18 6L6 18M6 6l12 12"
    }, null, -1)
  ]));
}
__name(render$l, "render$l");
const __unplugin_components_3$4 = markRaw({ name: "lucide-x", render: render$l });
const _hoisted_1$15 = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$k(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$15, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M14 17H5M19 7h-9" }),
      createElementVNode("circle", {
        cx: "17",
        cy: "17",
        r: "3"
      }),
      createElementVNode("circle", {
        cx: "7",
        cy: "7",
        r: "3"
      })
    ], -1)
  ]));
}
__name(render$k, "render$k");
const __unplugin_components_0$6 = markRaw({ name: "lucide-settings2", render: render$k });
const _hoisted_1$14 = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$j(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$14, _cache[0] || (_cache[0] = [
    createElementVNode("path", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M2.992 16.342a2 2 0 0 1 .094 1.167l-1.065 3.29a1 1 0 0 0 1.236 1.168l3.413-.998a2 2 0 0 1 1.099.092a10 10 0 1 0-4.777-4.719M12 8v4m0 4h.01"
    }, null, -1)
  ]));
}
__name(render$j, "render$j");
const __unplugin_components_4$1 = markRaw({ name: "lucide-message-circle-warning", render: render$j });
const _hoisted_1$13 = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$i(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$13, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M22 2L2 22" }),
      createElementVNode("circle", {
        cx: "12",
        cy: "12",
        r: "10"
      })
    ], -1)
  ]));
}
__name(render$i, "render$i");
const __unplugin_components_3$3 = markRaw({ name: "lucide-circle-slash2", render: render$i });
const _hoisted_1$12 = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$h(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$12, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("circle", {
        cx: "6",
        cy: "19",
        r: "3"
      }),
      createElementVNode("path", { d: "M9 19h8.5a3.5 3.5 0 0 0 0-7h-11a3.5 3.5 0 0 1 0-7H15" }),
      createElementVNode("circle", {
        cx: "18",
        cy: "5",
        r: "3"
      })
    ], -1)
  ]));
}
__name(render$h, "render$h");
const __unplugin_components_1$3 = markRaw({ name: "lucide-route", render: render$h });
const _hoisted_1$11 = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$g(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$11, _cache[0] || (_cache[0] = [
    createStaticVNode('<g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M12 22a1 1 0 0 1 0-20a10 9 0 0 1 10 9a5 5 0 0 1-5 5h-2.25a1.75 1.75 0 0 0-1.4 2.8l.3.4a1.75 1.75 0 0 1-1.4 2.8z"></path><circle cx="13.5" cy="6.5" r=".5" fill="currentColor"></circle><circle cx="17.5" cy="10.5" r=".5" fill="currentColor"></circle><circle cx="6.5" cy="12.5" r=".5" fill="currentColor"></circle><circle cx="8.5" cy="7.5" r=".5" fill="currentColor"></circle></g>', 1)
  ]));
}
__name(render$g, "render$g");
const __unplugin_components_0$5 = markRaw({ name: "lucide-palette", render: render$g });
const _hoisted_1$10 = { class: "flex items-center gap-2" };
const _hoisted_2$v = { for: "node-colors" };
const _hoisted_3$h = { class: "flex items-center gap-2" };
const _hoisted_4$d = { for: "show-links" };
const _hoisted_5$6 = { class: "flex items-center gap-2" };
const _hoisted_6$4 = { for: "show-groups" };
const _hoisted_7$3 = { class: "flex items-center gap-2" };
const _hoisted_8$3 = { for: "render-bypass" };
const _hoisted_9$2 = { class: "flex items-center gap-2" };
const _hoisted_10$2 = { for: "render-error" };
const _sfc_main$Y = /* @__PURE__ */ defineComponent({
  __name: "MiniMapPanel",
  props: {
    panelStyles: {},
    nodeColors: { type: Boolean },
    showLinks: { type: Boolean },
    showGroups: { type: Boolean },
    renderBypass: { type: Boolean },
    renderError: { type: Boolean }
  },
  emits: ["updateOption"],
  setup(__props) {
    return (_ctx, _cache) => {
      const _component_i_lucide58palette = __unplugin_components_0$5;
      const _component_i_lucide58route = __unplugin_components_1$3;
      const _component_i_lucide58frame = __unplugin_components_2$3;
      const _component_i_lucide58circle_slash_2 = __unplugin_components_3$3;
      const _component_i_lucide58message_circle_warning = __unplugin_components_4$1;
      return openBlock(), createElementBlock("div", {
        class: "minimap-panel p-3 mr-2 flex flex-col gap-3 text-sm",
        style: normalizeStyle(_ctx.panelStyles)
      }, [
        createElementVNode("div", _hoisted_1$10, [
          createVNode(unref(Checkbox), {
            "input-id": "node-colors",
            name: "node-colors",
            "model-value": _ctx.nodeColors,
            binary: "",
            "onUpdate:modelValue": _cache[0] || (_cache[0] = (value) => _ctx.$emit("updateOption", "Comfy.Minimap.NodeColors", value))
          }, null, 8, ["model-value"]),
          createVNode(_component_i_lucide58palette),
          createElementVNode("label", _hoisted_2$v, toDisplayString(_ctx.$t("minimap.nodeColors")), 1)
        ]),
        createElementVNode("div", _hoisted_3$h, [
          createVNode(unref(Checkbox), {
            "input-id": "show-links",
            name: "show-links",
            "model-value": _ctx.showLinks,
            binary: "",
            "onUpdate:modelValue": _cache[1] || (_cache[1] = (value) => _ctx.$emit("updateOption", "Comfy.Minimap.ShowLinks", value))
          }, null, 8, ["model-value"]),
          createVNode(_component_i_lucide58route),
          createElementVNode("label", _hoisted_4$d, toDisplayString(_ctx.$t("minimap.showLinks")), 1)
        ]),
        createElementVNode("div", _hoisted_5$6, [
          createVNode(unref(Checkbox), {
            "input-id": "show-groups",
            name: "show-groups",
            "model-value": _ctx.showGroups,
            binary: "",
            "onUpdate:modelValue": _cache[2] || (_cache[2] = (value) => _ctx.$emit("updateOption", "Comfy.Minimap.ShowGroups", value))
          }, null, 8, ["model-value"]),
          createVNode(_component_i_lucide58frame),
          createElementVNode("label", _hoisted_6$4, toDisplayString(_ctx.$t("minimap.showGroups")), 1)
        ]),
        createElementVNode("div", _hoisted_7$3, [
          createVNode(unref(Checkbox), {
            "input-id": "render-bypass",
            name: "render-bypass",
            "model-value": _ctx.renderBypass,
            binary: "",
            "onUpdate:modelValue": _cache[3] || (_cache[3] = (value) => _ctx.$emit("updateOption", "Comfy.Minimap.RenderBypassState", value))
          }, null, 8, ["model-value"]),
          createVNode(_component_i_lucide58circle_slash_2),
          createElementVNode("label", _hoisted_8$3, toDisplayString(_ctx.$t("minimap.renderBypassState")), 1)
        ]),
        createElementVNode("div", _hoisted_9$2, [
          createVNode(unref(Checkbox), {
            "input-id": "render-error",
            name: "render-error",
            "model-value": _ctx.renderError,
            binary: "",
            "onUpdate:modelValue": _cache[4] || (_cache[4] = (value) => _ctx.$emit("updateOption", "Comfy.Minimap.RenderErrorState", value))
          }, null, 8, ["model-value"]),
          createVNode(_component_i_lucide58message_circle_warning),
          createElementVNode("label", _hoisted_10$2, toDisplayString(_ctx.$t("minimap.renderErrorState")), 1)
        ])
      ], 4);
    };
  }
});
const _hoisted_1$$ = ["width", "height"];
const _sfc_main$X = /* @__PURE__ */ defineComponent({
  __name: "MiniMap",
  setup(__props) {
    const commandStore = useCommandStore();
    const minimapRef = ref();
    const {
      initialized,
      visible,
      containerRef,
      canvasRef,
      containerStyles,
      viewportStyles,
      width,
      height,
      panelStyles,
      nodeColors,
      showLinks,
      showGroups,
      renderBypass,
      renderError,
      updateOption,
      destroy,
      handlePointerDown: handlePointerDown2,
      handlePointerMove: handlePointerMove2,
      handlePointerUp: handlePointerUp2,
      handleWheel,
      setMinimapRef
    } = useMinimap();
    const showOptionsPanel = ref(false);
    const toggleOptionsPanel = /* @__PURE__ */ __name(() => {
      showOptionsPanel.value = !showOptionsPanel.value;
    }, "toggleOptionsPanel");
    onMounted(() => {
      if (minimapRef.value) {
        setMinimapRef(minimapRef.value);
      }
    });
    onUnmounted(() => {
      destroy();
    });
    return (_ctx, _cache) => {
      const _component_i_lucide58settings_2 = __unplugin_components_0$6;
      const _component_i_lucide58x = __unplugin_components_3$4;
      return unref(visible) && unref(initialized) ? (openBlock(), createElementBlock("div", {
        key: 0,
        ref_key: "minimapRef",
        ref: minimapRef,
        class: "minimap-main-container flex absolute bottom-[66px] right-2 md:right-11 z-1000"
      }, [
        showOptionsPanel.value ? (openBlock(), createBlock(_sfc_main$Y, {
          key: 0,
          "panel-styles": unref(panelStyles),
          "node-colors": unref(nodeColors),
          "show-links": unref(showLinks),
          "show-groups": unref(showGroups),
          "render-bypass": unref(renderBypass),
          "render-error": unref(renderError),
          onUpdateOption: unref(updateOption)
        }, null, 8, ["panel-styles", "node-colors", "show-links", "show-groups", "render-bypass", "render-error", "onUpdateOption"])) : createCommentVNode("", true),
        createElementVNode("div", {
          ref_key: "containerRef",
          ref: containerRef,
          class: "litegraph-minimap relative",
          style: normalizeStyle(unref(containerStyles))
        }, [
          createVNode(unref(Button), {
            class: "absolute z-10",
            size: "small",
            text: "",
            severity: "secondary",
            onClick: withModifiers(toggleOptionsPanel, ["stop"])
          }, {
            icon: withCtx(() => [
              createVNode(_component_i_lucide58settings_2)
            ]),
            _: 1
          }),
          createVNode(unref(Button), {
            class: "absolute z-10 right-0",
            size: "small",
            text: "",
            severity: "secondary",
            "data-testid": "close-minmap-button",
            onClick: _cache[0] || (_cache[0] = withModifiers(() => unref(commandStore).execute("Comfy.Canvas.ToggleMinimap"), ["stop"]))
          }, {
            icon: withCtx(() => [
              createVNode(_component_i_lucide58x)
            ]),
            _: 1
          }),
          createElementVNode("hr", {
            class: "absolute top-5 bg-[#E1DED5] dark-theme:bg-[#262729] h-[1px] border-0",
            style: normalizeStyle({
              width: unref(containerStyles).width
            })
          }, null, 4),
          createElementVNode("canvas", {
            ref_key: "canvasRef",
            ref: canvasRef,
            width: unref(width),
            height: unref(height),
            class: "minimap-canvas"
          }, null, 8, _hoisted_1$$),
          createElementVNode("div", {
            class: "minimap-viewport",
            style: normalizeStyle(unref(viewportStyles))
          }, null, 4),
          createElementVNode("div", {
            class: "absolute inset-0",
            onPointerdown: _cache[1] || (_cache[1] = //@ts-ignore
            (...args) => unref(handlePointerDown2) && unref(handlePointerDown2)(...args)),
            onPointermove: _cache[2] || (_cache[2] = //@ts-ignore
            (...args) => unref(handlePointerMove2) && unref(handlePointerMove2)(...args)),
            onPointerup: _cache[3] || (_cache[3] = //@ts-ignore
            (...args) => unref(handlePointerUp2) && unref(handlePointerUp2)(...args)),
            onPointerleave: _cache[4] || (_cache[4] = //@ts-ignore
            (...args) => unref(handlePointerUp2) && unref(handlePointerUp2)(...args)),
            onWheel: _cache[5] || (_cache[5] = //@ts-ignore
            (...args) => unref(handleWheel) && unref(handleWheel)(...args))
          }, null, 32)
        ], 4)
      ], 512)) : createCommentVNode("", true);
    };
  }
});
const MiniMap = /* @__PURE__ */ _export_sfc(_sfc_main$X, [["__scopeId", "data-v-76fd1812"]]);
const useNodeExecutionState = /* @__PURE__ */ __name((nodeId) => {
  const executingNodeIds = inject(ExecutingNodeIdsKey, ref(/* @__PURE__ */ new Set()));
  const nodeProgressStates = inject(
    NodeProgressStatesKey,
    ref({})
  );
  const executing = computed(() => {
    return executingNodeIds.value.has(nodeId);
  });
  const progress = computed(() => {
    const state = nodeProgressStates.value[nodeId];
    return state?.max > 0 ? state.value / state.max : void 0;
  });
  const progressState = computed(() => nodeProgressStates.value[nodeId]);
  const progressPercentage = computed(() => {
    const prog = progress.value;
    return prog !== void 0 ? Math.round(prog * 100) : void 0;
  });
  const executionState = computed(() => {
    const state = progressState.value;
    if (!state) return "idle";
    return state.state;
  });
  return {
    executing,
    progress,
    progressPercentage,
    progressState,
    executionState
  };
}, "useNodeExecutionState");
function useNodeLayout(nodeId) {
  const store = layoutStore;
  const mutations = useLayoutMutations();
  const transformState = inject(TransformStateKey);
  const layoutRef = store.getNodeLayoutRef(nodeId);
  const position = computed(() => {
    const layout = layoutRef.value;
    const pos = layout?.position ?? { x: 0, y: 0 };
    return pos;
  });
  const size2 = computed(
    () => layoutRef.value?.size ?? { width: 200, height: 100 }
  );
  const bounds = computed(
    () => layoutRef.value?.bounds ?? {
      x: position.value.x,
      y: position.value.y,
      width: size2.value.width,
      height: size2.value.height
    }
  );
  const isVisible = computed(() => layoutRef.value?.visible ?? true);
  const zIndex = computed(() => layoutRef.value?.zIndex ?? 0);
  let isDragging = false;
  let dragStartPos = null;
  let dragStartMouse = null;
  let otherSelectedNodesStartPositions = null;
  const selectedNodeIds = inject(SelectedNodeIdsKey, null);
  function startDrag(event) {
    if (!layoutRef.value) return;
    isDragging = true;
    dragStartPos = { ...position.value };
    dragStartMouse = { x: event.clientX, y: event.clientY };
    if (selectedNodeIds?.value?.has(nodeId) && selectedNodeIds.value.size > 1) {
      otherSelectedNodesStartPositions = /* @__PURE__ */ new Map();
      for (const id of selectedNodeIds.value) {
        if (id === nodeId) continue;
        const nodeLayout = layoutStore.getNodeLayoutRef(id).value;
        if (nodeLayout) {
          otherSelectedNodesStartPositions.set(id, { ...nodeLayout.position });
        }
      }
    } else {
      otherSelectedNodesStartPositions = null;
    }
    mutations.setSource(LayoutSource.Vue);
    const target = event.target;
    target.setPointerCapture(event.pointerId);
  }
  __name(startDrag, "startDrag");
  const handleDrag = /* @__PURE__ */ __name((event) => {
    if (!isDragging || !dragStartPos || !dragStartMouse || !transformState) {
      return;
    }
    const mouseDelta = {
      x: event.clientX - dragStartMouse.x,
      y: event.clientY - dragStartMouse.y
    };
    const canvasOrigin = transformState.screenToCanvas({ x: 0, y: 0 });
    const canvasWithDelta = transformState.screenToCanvas(mouseDelta);
    const canvasDelta = {
      x: canvasWithDelta.x - canvasOrigin.x,
      y: canvasWithDelta.y - canvasOrigin.y
    };
    const newPosition = {
      x: dragStartPos.x + canvasDelta.x,
      y: dragStartPos.y + canvasDelta.y
    };
    mutations.moveNode(nodeId, newPosition);
    if (otherSelectedNodesStartPositions && otherSelectedNodesStartPositions.size > 0) {
      for (const [otherNodeId, startPos] of otherSelectedNodesStartPositions) {
        const newOtherPosition = {
          x: startPos.x + canvasDelta.x,
          y: startPos.y + canvasDelta.y
        };
        mutations.moveNode(otherNodeId, newOtherPosition);
      }
    }
  }, "handleDrag");
  function endDrag(event) {
    if (!isDragging) return;
    isDragging = false;
    dragStartPos = null;
    dragStartMouse = null;
    otherSelectedNodesStartPositions = null;
    const target = event.target;
    target.releasePointerCapture(event.pointerId);
  }
  __name(endDrag, "endDrag");
  function moveTo(position2) {
    mutations.setSource(LayoutSource.Vue);
    mutations.moveNode(nodeId, position2);
  }
  __name(moveTo, "moveTo");
  function resize(newSize) {
    mutations.setSource(LayoutSource.Vue);
    mutations.resizeNode(nodeId, newSize);
  }
  __name(resize, "resize");
  return {
    // Reactive state (via customRef)
    layoutRef,
    position,
    size: size2,
    bounds,
    isVisible,
    zIndex,
    // Mutations
    moveTo,
    resize,
    // Drag handlers
    startDrag,
    handleDrag,
    endDrag,
    // Computed styles for Vue templates
    nodeStyle: computed(() => ({
      position: "absolute",
      left: `${position.value.x}px`,
      top: `${position.value.y}px`,
      width: `${size2.value.width}px`,
      height: `${size2.value.height}px`,
      zIndex: zIndex.value,
      cursor: isDragging ? "grabbing" : "grab"
    }))
  };
}
__name(useNodeLayout, "useNodeLayout");
var LODLevel = /* @__PURE__ */ ((LODLevel2) => {
  LODLevel2["MINIMAL"] = "minimal";
  LODLevel2["REDUCED"] = "reduced";
  LODLevel2["FULL"] = "full";
  return LODLevel2;
})(LODLevel || {});
const LOD_CONFIGS = {
  [
    "full"
    /* FULL */
  ]: {
    renderWidgets: true,
    renderSlots: true,
    renderContent: true,
    renderSlotLabels: true,
    renderWidgetLabels: true,
    cssClass: "lg-node--lod-full"
  },
  [
    "reduced"
    /* REDUCED */
  ]: {
    renderWidgets: true,
    renderSlots: true,
    renderContent: false,
    renderSlotLabels: false,
    renderWidgetLabels: false,
    cssClass: "lg-node--lod-reduced"
  },
  [
    "minimal"
    /* MINIMAL */
  ]: {
    renderWidgets: false,
    renderSlots: false,
    renderContent: false,
    renderSlotLabels: false,
    renderWidgetLabels: false,
    cssClass: "lg-node--lod-minimal"
  }
};
function useLOD(zoomRef) {
  const lodScore = computed(() => {
    const zoom = zoomRef.value;
    return Math.max(0, Math.min(1, zoom));
  });
  const lodLevel = computed(() => {
    const zoom = zoomRef.value;
    if (zoom > 0.8) return "full";
    if (zoom > 0.4) return "reduced";
    return "minimal";
  });
  const lodConfig = computed(() => LOD_CONFIGS[lodLevel.value]);
  const shouldRenderWidgets = computed(() => lodConfig.value.renderWidgets);
  const shouldRenderSlots = computed(() => lodConfig.value.renderSlots);
  const shouldRenderContent = computed(() => lodConfig.value.renderContent);
  const shouldRenderSlotLabels = computed(
    () => lodConfig.value.renderSlotLabels
  );
  const shouldRenderWidgetLabels = computed(
    () => lodConfig.value.renderWidgetLabels
  );
  const lodCssClass = computed(() => lodConfig.value.cssClass);
  const getEssentialWidgets = /* @__PURE__ */ __name((widgets2) => {
    if (lodLevel.value === "full") return widgets2;
    if (lodLevel.value === "minimal") return [];
    return widgets2.filter((widget) => {
      const type = widget?.type?.toLowerCase();
      return [
        "combo",
        "select",
        "toggle",
        "boolean",
        "slider",
        "number"
      ].includes(type);
    });
  }, "getEssentialWidgets");
  const lodMetrics = computed(() => ({
    level: lodLevel.value,
    zoom: zoomRef.value,
    widgetCount: shouldRenderWidgets.value ? "full" : "none",
    slotCount: shouldRenderSlots.value ? "full" : "none"
  }));
  return {
    // Core LOD state
    lodLevel: readonly(lodLevel),
    lodConfig: readonly(lodConfig),
    lodScore: readonly(lodScore),
    // Rendering decisions
    shouldRenderWidgets,
    shouldRenderSlots,
    shouldRenderContent,
    shouldRenderSlotLabels,
    shouldRenderWidgetLabels,
    // Styling
    lodCssClass,
    // Utilities
    getEssentialWidgets,
    lodMetrics
  };
}
__name(useLOD, "useLOD");
const LOD_THRESHOLDS = {
  FULL_THRESHOLD: 0.8,
  REDUCED_THRESHOLD: 0.4,
  MINIMAL_THRESHOLD: 0
};
function supportsFeatureAtZoom(zoom, feature) {
  const level = zoom > 0.8 ? "full" : zoom > 0.4 ? "reduced" : "minimal";
  return LOD_CONFIGS[level][feature];
}
__name(supportsFeatureAtZoom, "supportsFeatureAtZoom");
const useNodePreviewState = /* @__PURE__ */ __name((nodeId, options) => {
  const workflowStore = useWorkflowStore();
  const { nodePreviewImages } = storeToRefs(useNodeOutputStore());
  const locatorId = computed(() => workflowStore.nodeIdToNodeLocatorId(nodeId));
  const previewUrls = computed(() => {
    const key = locatorId.value;
    if (!key) return void 0;
    const urls = nodePreviewImages.value[key];
    return urls?.length ? urls : void 0;
  });
  const hasPreview = computed(() => !!previewUrls.value?.length);
  const latestPreviewUrl = computed(() => {
    const urls = previewUrls.value;
    return urls?.length ? urls.at(-1) : "";
  });
  const shouldShowPreviewImg = computed(() => {
    if (!options?.isMinimalLOD || !options?.isCollapsed) {
      return hasPreview.value;
    }
    return !options.isMinimalLOD.value && !options.isCollapsed.value && hasPreview.value;
  });
  return {
    locatorId,
    previewUrls,
    hasPreview,
    latestPreviewUrl,
    shouldShowPreviewImg
  };
}, "useNodePreviewState");
const useNodeSlotRegistryStore = defineStore("nodeSlotRegistry", () => {
  const registry = markRaw(/* @__PURE__ */ new Map());
  function getNode(nodeId) {
    return registry.get(nodeId);
  }
  __name(getNode, "getNode");
  function ensureNode(nodeId) {
    let node = registry.get(nodeId);
    if (!node) {
      node = {
        nodeId,
        slots: markRaw(/* @__PURE__ */ new Map())
      };
      registry.set(nodeId, node);
    }
    return node;
  }
  __name(ensureNode, "ensureNode");
  function deleteNode(nodeId) {
    registry.delete(nodeId);
  }
  __name(deleteNode, "deleteNode");
  function clear() {
    registry.clear();
  }
  __name(clear, "clear");
  return {
    getNode,
    ensureNode,
    deleteNode,
    clear
  };
});
const pendingNodes = /* @__PURE__ */ new Set();
let rafId = null;
function scheduleSlotLayoutSync(nodeId) {
  pendingNodes.add(nodeId);
  if (rafId == null) {
    rafId = requestAnimationFrame(() => {
      rafId = null;
      flushScheduledSlotLayoutSync();
    });
  }
}
__name(scheduleSlotLayoutSync, "scheduleSlotLayoutSync");
function flushScheduledSlotLayoutSync() {
  if (pendingNodes.size === 0) return;
  const conv = useSharedCanvasPositionConversion();
  for (const nodeId of Array.from(pendingNodes)) {
    pendingNodes.delete(nodeId);
    syncNodeSlotLayoutsFromDOM(nodeId, conv);
  }
}
__name(flushScheduledSlotLayoutSync, "flushScheduledSlotLayoutSync");
function syncNodeSlotLayoutsFromDOM(nodeId, conv) {
  const nodeSlotRegistryStore = useNodeSlotRegistryStore();
  const node = nodeSlotRegistryStore.getNode(nodeId);
  if (!node) return;
  const nodeLayout = layoutStore.getNodeLayoutRef(nodeId).value;
  if (!nodeLayout) return;
  const batch = [];
  for (const [slotKey, entry] of node.slots) {
    const rect = entry.el.getBoundingClientRect();
    const screenCenter = [
      rect.left + rect.width / 2,
      rect.top + rect.height / 2
    ];
    const [x, y] = (conv ?? useSharedCanvasPositionConversion()).clientPosToCanvasPos(screenCenter);
    const centerCanvas = { x, y };
    entry.cachedOffset = {
      x: centerCanvas.x - nodeLayout.position.x,
      y: centerCanvas.y - nodeLayout.position.y
    };
    const size2 = LiteGraph.NODE_SLOT_HEIGHT;
    const half = size2 / 2;
    batch.push({
      key: slotKey,
      layout: {
        nodeId,
        index: entry.index,
        type: entry.type,
        position: { x: centerCanvas.x, y: centerCanvas.y },
        bounds: {
          x: centerCanvas.x - half,
          y: centerCanvas.y - half,
          width: size2,
          height: size2
        }
      }
    });
  }
  if (batch.length) layoutStore.batchUpdateSlotLayouts(batch);
}
__name(syncNodeSlotLayoutsFromDOM, "syncNodeSlotLayoutsFromDOM");
function updateNodeSlotsFromCache(nodeId) {
  const nodeSlotRegistryStore = useNodeSlotRegistryStore();
  const node = nodeSlotRegistryStore.getNode(nodeId);
  if (!node) return;
  const nodeLayout = layoutStore.getNodeLayoutRef(nodeId).value;
  if (!nodeLayout) return;
  const batch = [];
  for (const [slotKey, entry] of node.slots) {
    if (!entry.cachedOffset) {
      scheduleSlotLayoutSync(nodeId);
      continue;
    }
    const centerCanvas = {
      x: nodeLayout.position.x + entry.cachedOffset.x,
      y: nodeLayout.position.y + entry.cachedOffset.y
    };
    const size2 = LiteGraph.NODE_SLOT_HEIGHT;
    const half = size2 / 2;
    batch.push({
      key: slotKey,
      layout: {
        nodeId,
        index: entry.index,
        type: entry.type,
        position: { x: centerCanvas.x, y: centerCanvas.y },
        bounds: {
          x: centerCanvas.x - half,
          y: centerCanvas.y - half,
          width: size2,
          height: size2
        }
      }
    });
  }
  if (batch.length) layoutStore.batchUpdateSlotLayouts(batch);
}
__name(updateNodeSlotsFromCache, "updateNodeSlotsFromCache");
function useSlotElementTracking(options) {
  const { nodeId, index, type, element } = options;
  const nodeSlotRegistryStore = useNodeSlotRegistryStore();
  onMounted(() => {
    if (!nodeId) return;
    const stop = watch(
      element,
      (el) => {
        if (!el) return;
        const node = nodeSlotRegistryStore.ensureNode(nodeId);
        if (!node.stopWatch) {
          const layoutRef = layoutStore.getNodeLayoutRef(nodeId);
          const stopPositionWatch = watch(
            () => layoutRef.value?.position,
            (newPosition, oldPosition) => {
              if (!newPosition) return;
              if (!oldPosition || !isPointEqual(newPosition, oldPosition)) {
                updateNodeSlotsFromCache(nodeId);
              }
            }
          );
          const stopSizeWatch = watch(
            () => layoutRef.value?.size,
            (newSize, oldSize) => {
              if (!newSize) return;
              if (!oldSize || !isSizeEqual(newSize, oldSize)) {
                scheduleSlotLayoutSync(nodeId);
              }
            }
          );
          node.stopWatch = () => {
            stopPositionWatch();
            stopSizeWatch();
          };
        }
        const slotKey = getSlotKey(nodeId, index, type === "input");
        node.slots.set(slotKey, { el, index, type });
        scheduleSlotLayoutSync(nodeId);
        stop();
      },
      { immediate: true, flush: "post" }
    );
  });
  onUnmounted(() => {
    if (!nodeId) return;
    const node = nodeSlotRegistryStore.getNode(nodeId);
    if (!node) return;
    const slotKey = getSlotKey(nodeId, index, type === "input");
    node.slots.delete(slotKey);
    layoutStore.deleteSlotLayout(slotKey);
    if (node.slots.size === 0) {
      if (node.stopWatch) node.stopWatch();
      nodeSlotRegistryStore.deleteNode(nodeId);
    }
  });
  return {
    requestSlotLayoutSync: /* @__PURE__ */ __name(() => scheduleSlotLayoutSync(nodeId), "requestSlotLayoutSync")
  };
}
__name(useSlotElementTracking, "useSlotElementTracking");
const trackingConfigs = /* @__PURE__ */ new Map([
  [
    "node",
    {
      dataAttribute: "nodeId",
      updateHandler: /* @__PURE__ */ __name((updates) => {
        const nodeUpdates = updates.map(({ id, bounds }) => ({
          nodeId: id,
          bounds
        }));
        layoutStore.batchUpdateNodeBounds(nodeUpdates);
      }, "updateHandler")
    }
  ]
]);
const resizeObserver = new ResizeObserver((entries) => {
  const conv = useSharedCanvasPositionConversion();
  const updatesByType = /* @__PURE__ */ new Map();
  const nodesNeedingSlotResync = /* @__PURE__ */ new Set();
  for (const entry of entries) {
    if (!(entry.target instanceof HTMLElement)) continue;
    const element = entry.target;
    let elementType;
    let elementId;
    for (const [type, config2] of trackingConfigs) {
      const id = element.dataset[config2.dataAttribute];
      if (id) {
        elementType = type;
        elementId = id;
        break;
      }
    }
    if (!elementType || !elementId) continue;
    const contentBox = Array.isArray(entry.contentBoxSize) ? entry.contentBoxSize[0] : {
      inlineSize: entry.contentRect.width,
      blockSize: entry.contentRect.height
    };
    const width = contentBox.inlineSize;
    const height = contentBox.blockSize;
    const rect = element.getBoundingClientRect();
    const [cx, cy] = conv.clientPosToCanvasPos([rect.left, rect.top]);
    const topLeftCanvas = { x: cx, y: cy };
    const bounds = {
      x: topLeftCanvas.x,
      y: topLeftCanvas.y + LiteGraph.NODE_TITLE_HEIGHT,
      width: Math.max(0, width),
      height: Math.max(0, height - LiteGraph.NODE_TITLE_HEIGHT)
    };
    let updates = updatesByType.get(elementType);
    if (!updates) {
      updates = [];
      updatesByType.set(elementType, updates);
    }
    updates.push({ id: elementId, bounds });
    if (elementType === "node" && elementId) {
      nodesNeedingSlotResync.add(elementId);
    }
  }
  for (const [type, updates] of updatesByType) {
    const config2 = trackingConfigs.get(type);
    if (config2 && updates.length) config2.updateHandler(updates);
  }
  if (nodesNeedingSlotResync.size > 0) {
    for (const nodeId of nodesNeedingSlotResync) {
      syncNodeSlotLayoutsFromDOM(nodeId);
    }
  }
});
function useVueElementTracking(appIdentifier, trackingType) {
  onMounted(() => {
    const element = getCurrentInstance()?.proxy?.$el;
    if (!(element instanceof HTMLElement) || !appIdentifier) return;
    const config2 = trackingConfigs.get(trackingType);
    if (!config2) return;
    element.dataset[config2.dataAttribute] = appIdentifier;
    resizeObserver.observe(element);
  });
  onUnmounted(() => {
    const element = getCurrentInstance()?.proxy?.$el;
    if (!(element instanceof HTMLElement)) return;
    const config2 = trackingConfigs.get(trackingType);
    if (!config2) return;
    delete element.dataset[config2.dataAttribute];
    resizeObserver.unobserve(element);
  });
}
__name(useVueElementTracking, "useVueElementTracking");
const _hoisted_1$_ = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$f(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$_, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M12 15V3m9 12v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4" }),
      createElementVNode("path", { d: "m7 10l5 5l5-5" })
    ], -1)
  ]));
}
__name(render$f, "render$f");
const __unplugin_components_2$2 = markRaw({ name: "lucide-download", render: render$f });
const _hoisted_1$Z = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$e(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$Z, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "M18 11c-1.5 0-2.5.5-3 2" }),
      createElementVNode("path", { d: "M4 6a2 2 0 0 0-2 2v4a5 5 0 0 0 5 5a8 8 0 0 1 5 2a8 8 0 0 1 5-2a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3a8 8 0 0 0-5 2a8 8 0 0 0-5-2z" }),
      createElementVNode("path", { d: "M6 11c1.5 0 2.5.5 3 2" })
    ], -1)
  ]));
}
__name(render$e, "render$e");
const __unplugin_components_1$2 = markRaw({ name: "lucide-venetian-mask", render: render$e });
const _hoisted_1$Y = {
  viewBox: "0 0 24 24",
  width: "1.2em",
  height: "1.2em"
};
function render$d(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$Y, _cache[0] || (_cache[0] = [
    createElementVNode("g", {
      fill: "none",
      stroke: "currentColor",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2"
    }, [
      createElementVNode("path", { d: "m2 2l20 20M10.41 10.41a2 2 0 1 1-2.83-2.83m5.92 5.92L6 21m12-9l3 3" }),
      createElementVNode("path", { d: "M3.59 3.59A2 2 0 0 0 3 5v14a2 2 0 0 0 2 2h14c.55 0 1.052-.22 1.41-.59M21 15V5a2 2 0 0 0-2-2H9" })
    ], -1)
  ]));
}
__name(render$d, "render$d");
const __unplugin_components_0$4 = markRaw({ name: "lucide-image-off", render: render$d });
const _hoisted_1$X = ["aria-label"];
const _hoisted_2$u = { class: "relative rounded-[5px] overflow-hidden w-full max-w-[352px] bg-[#262729]" };
const _hoisted_3$g = {
  key: 0,
  class: "w-full h-[352px] flex flex-col items-center justify-center text-white text-center bg-gray-800/50"
};
const _hoisted_4$c = { class: "text-sm text-gray-300" };
const _hoisted_5$5 = { class: "text-xs text-gray-400 mt-1" };
const _hoisted_6$3 = ["src", "alt"];
const _hoisted_7$2 = {
  key: 3,
  class: "actions absolute top-2 right-2 flex gap-1"
};
const _hoisted_8$2 = ["title", "aria-label"];
const _hoisted_9$1 = ["title", "aria-label"];
const _hoisted_10$1 = ["title", "aria-label"];
const _hoisted_11$1 = {
  key: 4,
  class: "absolute bottom-2 left-2 right-2 flex justify-center gap-1"
};
const _hoisted_12$1 = ["aria-label", "onClick"];
const _hoisted_13$1 = { class: "text-white text-xs text-center mt-2" };
const _hoisted_14$1 = {
  key: 0,
  class: "text-red-400"
};
const _hoisted_15$1 = {
  key: 1,
  class: "text-gray-400"
};
const _hoisted_16$1 = { key: 2 };
const _sfc_main$W = /* @__PURE__ */ defineComponent({
  __name: "ImagePreview",
  props: {
    imageUrls: {},
    nodeId: {}
  },
  setup(__props) {
    const props2 = __props;
    const { t: t2 } = useI18n();
    const commandStore = useCommandStore();
    const nodeOutputStore = useNodeOutputStore();
    const currentIndex = ref(0);
    const isHovered = ref(false);
    const actualDimensions = ref(null);
    const imageError = ref(false);
    const isLoading = ref(false);
    const currentImageUrl = computed(() => props2.imageUrls[currentIndex.value]);
    const hasMultipleImages = computed(() => props2.imageUrls.length > 1);
    const imageAltText = computed(() => `Node output ${currentIndex.value + 1}`);
    watch(
      () => props2.imageUrls,
      (newUrls) => {
        if (currentIndex.value >= newUrls.length) {
          currentIndex.value = 0;
        }
        actualDimensions.value = null;
        imageError.value = false;
        isLoading.value = false;
      },
      { deep: true }
    );
    const handleImageLoad = /* @__PURE__ */ __name((event) => {
      if (!event.target || !(event.target instanceof HTMLImageElement)) return;
      const img = event.target;
      isLoading.value = false;
      imageError.value = false;
      if (img.naturalWidth && img.naturalHeight) {
        actualDimensions.value = `${img.naturalWidth} x ${img.naturalHeight}`;
      }
    }, "handleImageLoad");
    const handleImageError = /* @__PURE__ */ __name(() => {
      isLoading.value = false;
      imageError.value = true;
      actualDimensions.value = null;
    }, "handleImageError");
    const handleEditMask = /* @__PURE__ */ __name(() => {
      void commandStore.execute("Comfy.MaskEditor.OpenMaskEditor");
    }, "handleEditMask");
    const handleDownload = /* @__PURE__ */ __name(() => {
      try {
        downloadFile(currentImageUrl.value);
      } catch (error) {
        useToast().add({
          severity: "error",
          summary: "Error",
          detail: t2("g.failedToDownloadImage"),
          life: 3e3,
          group: "image-preview"
        });
      }
    }, "handleDownload");
    const handleRemove = /* @__PURE__ */ __name(() => {
      if (!props2.nodeId) return;
      nodeOutputStore.removeNodeOutputs(props2.nodeId);
    }, "handleRemove");
    const setCurrentIndex = /* @__PURE__ */ __name((index) => {
      if (index >= 0 && index < props2.imageUrls.length) {
        currentIndex.value = index;
        actualDimensions.value = null;
        isLoading.value = true;
        imageError.value = false;
      }
    }, "setCurrentIndex");
    const handleMouseEnter = /* @__PURE__ */ __name(() => {
      isHovered.value = true;
    }, "handleMouseEnter");
    const handleMouseLeave = /* @__PURE__ */ __name(() => {
      isHovered.value = false;
    }, "handleMouseLeave");
    const getNavigationDotClass = /* @__PURE__ */ __name((index) => {
      return [
        "w-2 h-2 rounded-full transition-all duration-200 border-0 cursor-pointer",
        index === currentIndex.value ? "bg-white" : "bg-white/50 hover:bg-white/80"
      ];
    }, "getNavigationDotClass");
    const handleKeyDown = /* @__PURE__ */ __name((event) => {
      if (props2.imageUrls.length <= 1) return;
      switch (event.key) {
        case "ArrowLeft":
          event.preventDefault();
          setCurrentIndex(
            currentIndex.value > 0 ? currentIndex.value - 1 : props2.imageUrls.length - 1
          );
          break;
        case "ArrowRight":
          event.preventDefault();
          setCurrentIndex(
            currentIndex.value < props2.imageUrls.length - 1 ? currentIndex.value + 1 : 0
          );
          break;
        case "Home":
          event.preventDefault();
          setCurrentIndex(0);
          break;
        case "End":
          event.preventDefault();
          setCurrentIndex(props2.imageUrls.length - 1);
          break;
      }
    }, "handleKeyDown");
    return (_ctx, _cache) => {
      const _component_i_lucide58image_off = __unplugin_components_0$4;
      const _component_i_lucide58venetian_mask = __unplugin_components_1$2;
      const _component_i_lucide58download = __unplugin_components_2$2;
      const _component_i_lucide58x = __unplugin_components_3$4;
      return _ctx.imageUrls.length > 0 ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: "image-preview relative group flex flex-col items-center",
        tabindex: "0",
        role: "region",
        "aria-label": _ctx.$t("g.imagePreview"),
        onMouseenter: handleMouseEnter,
        onMouseleave: handleMouseLeave,
        onKeydown: handleKeyDown
      }, [
        createElementVNode("div", _hoisted_2$u, [
          imageError.value ? (openBlock(), createElementBlock("div", _hoisted_3$g, [
            createVNode(_component_i_lucide58image_off, { class: "w-12 h-12 mb-2 text-gray-400" }),
            createElementVNode("p", _hoisted_4$c, toDisplayString(_ctx.$t("g.imageFailedToLoad")), 1),
            createElementVNode("p", _hoisted_5$5, toDisplayString(currentImageUrl.value), 1)
          ])) : isLoading.value ? (openBlock(), createBlock(unref(Skeleton), {
            key: 1,
            class: "w-full h-[352px]",
            "border-radius": "5px"
          })) : (openBlock(), createElementBlock("img", {
            key: 2,
            src: currentImageUrl.value,
            alt: imageAltText.value,
            class: "w-full h-[352px] object-cover block",
            onLoad: handleImageLoad,
            onError: handleImageError
          }, null, 40, _hoisted_6$3)),
          isHovered.value ? (openBlock(), createElementBlock("div", _hoisted_7$2, [
            !hasMultipleImages.value ? (openBlock(), createElementBlock("button", {
              key: 0,
              class: "action-btn bg-white text-black hover:bg-gray-100 rounded-lg p-2 shadow-sm transition-all duration-200 border-0 cursor-pointer",
              title: _ctx.$t("g.editOrMaskImage"),
              "aria-label": _ctx.$t("g.editOrMaskImage"),
              onClick: handleEditMask
            }, [
              createVNode(_component_i_lucide58venetian_mask, { class: "w-4 h-4" })
            ], 8, _hoisted_8$2)) : createCommentVNode("", true),
            createElementVNode("button", {
              class: "action-btn bg-white text-black hover:bg-gray-100 rounded-lg p-2 shadow-sm transition-all duration-200 border-0 cursor-pointer",
              title: _ctx.$t("g.downloadImage"),
              "aria-label": _ctx.$t("g.downloadImage"),
              onClick: handleDownload
            }, [
              createVNode(_component_i_lucide58download, { class: "w-4 h-4" })
            ], 8, _hoisted_9$1),
            createElementVNode("button", {
              class: "action-btn bg-white text-black hover:bg-gray-100 rounded-lg p-2 shadow-sm transition-all duration-200 border-0 cursor-pointer",
              title: _ctx.$t("g.removeImage"),
              "aria-label": _ctx.$t("g.removeImage"),
              onClick: handleRemove
            }, [
              createVNode(_component_i_lucide58x, { class: "w-4 h-4" })
            ], 8, _hoisted_10$1)
          ])) : createCommentVNode("", true),
          hasMultipleImages.value ? (openBlock(), createElementBlock("div", _hoisted_11$1, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.imageUrls, (_, index) => {
              return openBlock(), createElementBlock("button", {
                key: index,
                class: normalizeClass(getNavigationDotClass(index)),
                "aria-label": _ctx.$t("g.viewImageOfTotal", {
                  index: index + 1,
                  total: _ctx.imageUrls.length
                }),
                onClick: /* @__PURE__ */ __name(($event) => setCurrentIndex(index), "onClick")
              }, null, 10, _hoisted_12$1);
            }), 128))
          ])) : createCommentVNode("", true)
        ]),
        createElementVNode("div", _hoisted_13$1, [
          imageError.value ? (openBlock(), createElementBlock("span", _hoisted_14$1, toDisplayString(_ctx.$t("g.errorLoadingImage")), 1)) : isLoading.value ? (openBlock(), createElementBlock("span", _hoisted_15$1, toDisplayString(_ctx.$t("g.loading")) + "... ", 1)) : (openBlock(), createElementBlock("span", _hoisted_16$1, toDisplayString(actualDimensions.value || _ctx.$t("g.calculatingDimensions")), 1))
        ])
      ], 40, _hoisted_1$X)) : createCommentVNode("", true);
    };
  }
});
const _hoisted_1$W = {
  key: 0,
  class: "node-error p-2 text-red-500 text-sm"
};
const _hoisted_2$t = {
  key: 1,
  class: "lg-node-content"
};
const _sfc_main$V = /* @__PURE__ */ defineComponent({
  __name: "NodeContent",
  props: {
    node: {},
    nodeData: {},
    readonly: { type: Boolean },
    lodLevel: {},
    imageUrls: {}
  },
  setup(__props) {
    const props2 = __props;
    const hasImages = computed(() => props2.imageUrls && props2.imageUrls.length > 0);
    const nodeId = computed(() => {
      return props2.nodeData?.id?.toString() || props2.node?.id?.toString();
    });
    const renderError = ref(null);
    const { toastErrorHandler } = useErrorHandling();
    onErrorCaptured((error) => {
      renderError.value = error.message;
      toastErrorHandler(error);
      return false;
    });
    return (_ctx, _cache) => {
      return renderError.value ? (openBlock(), createElementBlock("div", _hoisted_1$W, toDisplayString(_ctx.$t("Node Content Error")), 1)) : (openBlock(), createElementBlock("div", _hoisted_2$t, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          hasImages.value ? (openBlock(), createBlock(_sfc_main$W, {
            key: 0,
            "image-urls": props2.imageUrls || [],
            "node-id": nodeId.value,
            class: "mt-2"
          }, null, 8, ["image-urls", "node-id"])) : createCommentVNode("", true)
        ])
      ]));
    };
  }
});
const _hoisted_1$V = {
  key: 0,
  class: "node-error p-4 text-red-500 text-sm"
};
const _hoisted_2$s = ["data-testid"];
const _hoisted_3$f = {
  class: "text-sm font-bold truncate flex-1",
  "data-testid": "node-title"
};
const _sfc_main$U = /* @__PURE__ */ defineComponent({
  __name: "NodeHeader",
  props: {
    node: {},
    nodeData: {},
    readonly: { type: Boolean },
    lodLevel: {},
    collapsed: { type: Boolean }
  },
  emits: ["collapse", "update:title"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const renderError = ref(null);
    const { toastErrorHandler } = useErrorHandling();
    onErrorCaptured((error) => {
      renderError.value = error.message;
      toastErrorHandler(error);
      return false;
    });
    const isEditing = ref(false);
    const nodeInfo = computed(() => props2.nodeData || props2.node);
    const resolveTitle = /* @__PURE__ */ __name((info) => {
      const title = (info?.title ?? "").trim();
      if (title.length > 0) return title;
      const type = (info?.type ?? "").trim();
      return type.length > 0 ? type : "Untitled";
    }, "resolveTitle");
    const displayTitle = ref(resolveTitle(nodeInfo.value));
    watch(
      () => [nodeInfo.value?.title, nodeInfo.value?.type],
      () => {
        const next = resolveTitle(nodeInfo.value);
        if (next !== displayTitle.value) {
          displayTitle.value = next;
        }
      }
    );
    const handleCollapse = /* @__PURE__ */ __name(() => {
      emit("collapse");
    }, "handleCollapse");
    const handleDoubleClick = /* @__PURE__ */ __name(() => {
      if (!props2.readonly) {
        isEditing.value = true;
      }
    }, "handleDoubleClick");
    const handleTitleEdit = /* @__PURE__ */ __name((newTitle) => {
      isEditing.value = false;
      const trimmedTitle = newTitle.trim();
      if (trimmedTitle && trimmedTitle !== displayTitle.value) {
        emit("update:title", trimmedTitle);
      }
    }, "handleTitleEdit");
    const handleTitleCancel = /* @__PURE__ */ __name(() => {
      isEditing.value = false;
    }, "handleTitleCancel");
    return (_ctx, _cache) => {
      return renderError.value ? (openBlock(), createElementBlock("div", _hoisted_1$V, toDisplayString(_ctx.$t("Node Header Error")), 1)) : (openBlock(), createElementBlock("div", {
        key: 1,
        class: "lg-node-header flex items-center justify-between p-4 rounded-t-2xl cursor-move",
        "data-testid": `node-header-${nodeInfo.value?.id || ""}`,
        onDblclick: handleDoubleClick
      }, [
        withDirectives(createElementVNode("button", {
          class: "bg-transparent border-transparent flex items-center",
          "data-testid": "node-collapse-button",
          onClick: withModifiers(handleCollapse, ["stop"]),
          onDblclick: _cache[0] || (_cache[0] = withModifiers(() => {
          }, ["stop"]))
        }, [
          createElementVNode("i", {
            class: normalizeClass([_ctx.collapsed ? "pi pi-chevron-right" : "pi pi-chevron-down", "text-xs leading-none relative top-px text-stone-200 dark-theme:text-slate-300"])
          }, null, 2)
        ], 544), [
          [vShow, !_ctx.readonly]
        ]),
        createElementVNode("div", _hoisted_3$f, [
          createVNode(EditableText, {
            "model-value": displayTitle.value,
            "is-editing": isEditing.value,
            "input-attrs": { "data-testid": "node-title-input" },
            onEdit: handleTitleEdit,
            onCancel: handleTitleCancel
          }, null, 8, ["model-value", "is-editing"])
        ])
      ], 40, _hoisted_2$s));
    };
  }
});
const SLOT_TYPE_COLORS = {
  number: "#AAD",
  string: "#DCA",
  boolean: "#DAA",
  vec2: "#ADA",
  vec3: "#ADA",
  vec4: "#ADA",
  color: "#DDA",
  image: "#353",
  latent: "#858",
  conditioning: "#FFA",
  control_net: "#F8F",
  clip: "#FFD",
  vae: "#F82",
  model: "#B98",
  "*": "#AAA"
  // Default color
};
function getSlotColor(type) {
  if (!type) return SLOT_TYPE_COLORS["*"];
  const typeStr = String(type).toLowerCase();
  return SLOT_TYPE_COLORS[typeStr] || SLOT_TYPE_COLORS["*"];
}
__name(getSlotColor, "getSlotColor");
const _sfc_main$T = /* @__PURE__ */ defineComponent({
  __name: "SlotConnectionDot",
  props: {
    color: {},
    multi: { type: Boolean },
    class: { type: [Array, Object, String, Number, null, Boolean] }
  },
  setup(__props, { expose: __expose }) {
    const props2 = __props;
    const slotElRef = useTemplateRef("slot-el");
    __expose({
      slotElRef
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(
          unref(cn)("size-6 flex items-center justify-center group/slot", props2.class)
        )
      }, [
        createElementVNode("div", {
          ref: "slot-el",
          style: normalizeStyle({ backgroundColor: _ctx.color }),
          class: normalizeClass(
            unref(cn)(
              "bg-[#5B5E7D] rounded-full",
              "transition-all duration-150",
              "cursor-crosshair",
              "border border-solid border-black/5 dark-theme:border-white/10",
              "group-hover/slot:border-black/20 dark-theme:group-hover/slot:border-white/50 group-hover/slot:scale-125",
              _ctx.multi ? "w-3 h-6" : "size-3"
            )
          )
        }, null, 6)
      ], 2);
    };
  }
});
const _hoisted_1$U = {
  key: 0,
  class: "node-error p-1 text-red-500 text-xs"
};
const _hoisted_2$r = {
  key: 0,
  class: "whitespace-nowrap text-sm font-normal dark-theme:text-slate-200 text-stone-200"
};
const _sfc_main$S = /* @__PURE__ */ defineComponent({
  __name: "InputSlot",
  props: {
    node: {},
    nodeId: {},
    slotData: {},
    index: {},
    connected: { type: Boolean },
    compatible: { type: Boolean },
    readonly: { type: Boolean },
    dotOnly: { type: Boolean }
  },
  setup(__props) {
    const props2 = __props;
    const renderError = ref(null);
    const { toastErrorHandler } = useErrorHandling();
    onErrorCaptured((error) => {
      renderError.value = error.message;
      toastErrorHandler(error);
      return false;
    });
    const slotColor = computed(() => getSlotColor(props2.slotData.type));
    const connectionDotRef = ref(null);
    const slotElRef = ref(null);
    watchEffect(() => {
      const el = connectionDotRef.value?.slotElRef;
      slotElRef.value = el || null;
    });
    useSlotElementTracking({
      nodeId: props2.nodeId ?? "",
      index: props2.index,
      type: "input",
      element: slotElRef
    });
    return (_ctx, _cache) => {
      return renderError.value ? (openBlock(), createElementBlock("div", _hoisted_1$U, "⚠️")) : (openBlock(), createElementBlock("div", {
        key: 1,
        class: normalizeClass(["lg-slot lg-slot--input flex items-center cursor-crosshair group rounded-r-lg h-6", {
          "opacity-70": _ctx.readonly,
          "lg-slot--connected": _ctx.connected,
          "lg-slot--compatible": _ctx.compatible,
          "lg-slot--dot-only": _ctx.dotOnly,
          "pr-6 hover:bg-black/5 hover:dark:bg-white/5": !_ctx.dotOnly
        }])
      }, [
        createVNode(_sfc_main$T, {
          ref_key: "connectionDotRef",
          ref: connectionDotRef,
          color: slotColor.value,
          class: "-translate-x-1/2"
        }, null, 8, ["color"]),
        !_ctx.dotOnly ? (openBlock(), createElementBlock("span", _hoisted_2$r, toDisplayString(_ctx.slotData.localized_name || _ctx.slotData.name || `Input ${_ctx.index}`), 1)) : createCommentVNode("", true)
      ], 2));
    };
  }
});
const _hoisted_1$T = {
  key: 0,
  class: "node-error p-1 text-red-500 text-xs"
};
const _hoisted_2$q = {
  key: 0,
  class: "whitespace-nowrap text-sm font-normal dark-theme:text-slate-200 text-stone-200"
};
const _sfc_main$R = /* @__PURE__ */ defineComponent({
  __name: "OutputSlot",
  props: {
    node: {},
    nodeId: {},
    slotData: {},
    index: {},
    connected: { type: Boolean },
    compatible: { type: Boolean },
    readonly: { type: Boolean },
    dotOnly: { type: Boolean }
  },
  setup(__props) {
    const props2 = __props;
    const renderError = ref(null);
    const { toastErrorHandler } = useErrorHandling();
    onErrorCaptured((error) => {
      renderError.value = error.message;
      toastErrorHandler(error);
      return false;
    });
    const slotColor = computed(() => getSlotColor(props2.slotData.type));
    const connectionDotRef = ref(null);
    const slotElRef = ref(null);
    watchEffect(() => {
      const el = connectionDotRef.value?.slotElRef;
      slotElRef.value = el || null;
    });
    useSlotElementTracking({
      nodeId: props2.nodeId ?? "",
      index: props2.index,
      type: "output",
      element: slotElRef
    });
    return (_ctx, _cache) => {
      return renderError.value ? (openBlock(), createElementBlock("div", _hoisted_1$T, "⚠️")) : (openBlock(), createElementBlock("div", {
        key: 1,
        class: normalizeClass(["lg-slot lg-slot--output flex items-center cursor-crosshair justify-end group rounded-l-lg h-6", {
          "opacity-70": _ctx.readonly,
          "lg-slot--connected": _ctx.connected,
          "lg-slot--compatible": _ctx.compatible,
          "lg-slot--dot-only": _ctx.dotOnly,
          "pl-6 hover:bg-black/5 hover:dark:bg-white/5": !_ctx.dotOnly,
          "justify-center": _ctx.dotOnly
        }])
      }, [
        !_ctx.dotOnly ? (openBlock(), createElementBlock("span", _hoisted_2$q, toDisplayString(_ctx.slotData.name || `Output ${_ctx.index}`), 1)) : createCommentVNode("", true),
        createVNode(_sfc_main$T, {
          ref_key: "connectionDotRef",
          ref: connectionDotRef,
          color: slotColor.value,
          class: "translate-x-1/2"
        }, null, 8, ["color"])
      ], 2));
    };
  }
});
const _hoisted_1$S = {
  key: 0,
  class: "node-error p-2 text-red-500 text-sm"
};
const _hoisted_2$p = {
  key: 1,
  class: "lg-node-slots flex justify-between"
};
const _hoisted_3$e = {
  key: 0,
  class: "flex flex-col gap-1"
};
const _hoisted_4$b = {
  key: 1,
  class: "flex flex-col gap-1 ml-auto"
};
const _sfc_main$Q = /* @__PURE__ */ defineComponent({
  __name: "NodeSlots",
  props: {
    node: {},
    nodeData: {},
    readonly: { type: Boolean },
    lodLevel: {}
  },
  setup(__props) {
    const props2 = __props;
    const nodeInfo = computed(() => props2.nodeData || props2.node || null);
    const filteredInputs = computed(() => {
      if (!nodeInfo.value?.inputs) return [];
      return nodeInfo.value.inputs.filter((input) => {
        if (isSlotObject(input) && "widget" in input && input.widget) {
          return false;
        }
        return true;
      }).map(
        (input) => isSlotObject(input) ? input : {
          name: typeof input === "string" ? input : "",
          type: "any",
          boundingRect: [0, 0, 0, 0]
        }
      );
    });
    const filteredOutputs = computed(() => {
      const outputs = nodeInfo.value?.outputs || [];
      return outputs.map(
        (output) => isSlotObject(output) ? output : {
          name: typeof output === "string" ? output : "",
          type: "any",
          boundingRect: [0, 0, 0, 0]
        }
      );
    });
    const getActualInputIndex = /* @__PURE__ */ __name((input, filteredIndex) => {
      if (!nodeInfo.value?.inputs) return filteredIndex;
      const actualIndex = nodeInfo.value.inputs.findIndex((i) => i === input);
      return actualIndex !== -1 ? actualIndex : filteredIndex;
    }, "getActualInputIndex");
    const renderError = ref(null);
    const { toastErrorHandler } = useErrorHandling();
    onErrorCaptured((error) => {
      renderError.value = error.message;
      toastErrorHandler(error);
      return false;
    });
    return (_ctx, _cache) => {
      return renderError.value ? (openBlock(), createElementBlock("div", _hoisted_1$S, toDisplayString(_ctx.$t("Node Slots Error")), 1)) : (openBlock(), createElementBlock("div", _hoisted_2$p, [
        filteredInputs.value.length ? (openBlock(), createElementBlock("div", _hoisted_3$e, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(filteredInputs.value, (input, index) => {
            return openBlock(), createBlock(_sfc_main$S, {
              key: `input-${index}`,
              "slot-data": input,
              "node-id": nodeInfo.value?.id != null ? String(nodeInfo.value.id) : "",
              index: getActualInputIndex(input, index),
              readonly: _ctx.readonly
            }, null, 8, ["slot-data", "node-id", "index", "readonly"]);
          }), 128))
        ])) : createCommentVNode("", true),
        filteredOutputs.value.length ? (openBlock(), createElementBlock("div", _hoisted_4$b, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(filteredOutputs.value, (output, index) => {
            return openBlock(), createBlock(_sfc_main$R, {
              key: `output-${index}`,
              "slot-data": output,
              "node-id": nodeInfo.value?.id != null ? String(nodeInfo.value.id) : "",
              index,
              readonly: _ctx.readonly
            }, null, 8, ["slot-data", "node-id", "index", "readonly"]);
          }), 128))
        ])) : createCommentVNode("", true)
      ]));
    };
  }
});
function useWidgetValue({
  widget,
  modelValue,
  defaultValue,
  emit,
  transform: transform2
}) {
  const localValue = ref(modelValue ?? defaultValue);
  const onChange = /* @__PURE__ */ __name((newValue) => {
    let processedValue;
    if (transform2) {
      processedValue = transform2(newValue);
    } else {
      if (typeof newValue === typeof defaultValue || newValue === null || newValue === void 0) {
        processedValue = newValue ?? defaultValue;
      } else {
        console.warn(
          `useWidgetValue: Type mismatch for widget ${widget.name}. Expected ${typeof defaultValue}, got ${typeof newValue}`
        );
        processedValue = defaultValue;
      }
    }
    localValue.value = processedValue;
    emit("update:modelValue", processedValue);
  }, "onChange");
  watch(
    () => modelValue,
    (newValue) => {
      localValue.value = newValue ?? defaultValue;
    }
  );
  return {
    localValue,
    onChange
  };
}
__name(useWidgetValue, "useWidgetValue");
function useStringWidgetValue(widget, modelValue, emit) {
  return useWidgetValue({
    widget,
    modelValue,
    defaultValue: "",
    emit,
    transform: /* @__PURE__ */ __name((value) => String(value || ""), "transform")
    // Handle undefined from PrimeVue
  });
}
__name(useStringWidgetValue, "useStringWidgetValue");
function useNumberWidgetValue(widget, modelValue, emit) {
  return useWidgetValue({
    widget,
    modelValue,
    defaultValue: 0,
    emit,
    transform: /* @__PURE__ */ __name((value) => {
      if (Array.isArray(value)) {
        return value.length > 0 ? value[0] ?? 0 : 0;
      }
      return Number(value) || 0;
    }, "transform")
  });
}
__name(useNumberWidgetValue, "useNumberWidgetValue");
function useBooleanWidgetValue(widget, modelValue, emit) {
  return useWidgetValue({
    widget,
    modelValue,
    defaultValue: false,
    emit,
    transform: /* @__PURE__ */ __name((value) => Boolean(value), "transform")
  });
}
__name(useBooleanWidgetValue, "useBooleanWidgetValue");
const STANDARD_EXCLUDED_PROPS = [
  "style",
  "class",
  "dt",
  "pt",
  "ptOptions",
  "unstyled"
];
const INPUT_EXCLUDED_PROPS = [
  ...STANDARD_EXCLUDED_PROPS,
  "inputClass",
  "inputStyle"
];
const PANEL_EXCLUDED_PROPS = [
  ...STANDARD_EXCLUDED_PROPS,
  "panelClass",
  "panelStyle",
  "overlayClass"
];
const GALLERIA_EXCLUDED_PROPS = [
  ...STANDARD_EXCLUDED_PROPS,
  "thumbnailsPosition",
  "verticalThumbnailViewPortHeight",
  "indicatorsPosition",
  "maskClass",
  "containerStyle",
  "containerClass",
  "galleriaClass"
];
const BADGE_EXCLUDED_PROPS = [
  ...STANDARD_EXCLUDED_PROPS,
  "badgeClass"
];
function filterWidgetProps(props2, excludeList) {
  if (!props2) return {};
  const filtered = {};
  for (const [key, value] of Object.entries(props2)) {
    if (!excludeList.includes(key)) {
      filtered[key] = value;
    }
  }
  return filtered;
}
__name(filterWidgetProps, "filterWidgetProps");
const WidgetInputBaseClass = cn([
  // Background
  "bg-zinc-500/10",
  // Outline
  "border-none",
  "outline",
  "outline-1",
  "outline-offset-[-1px]",
  "outline-zinc-300/10",
  // Rounded
  "!rounded-lg",
  // Hover
  "hover:outline-blue-500/80"
]);
function at(arr, indices) {
  const result = new Array(indices.length);
  const length = arr.length;
  for (let i = 0; i < indices.length; i++) {
    let index = indices[i];
    index = Number.isInteger(index) ? index : Math.trunc(index) || 0;
    if (index < 0) {
      index += length;
    }
    result[i] = arr[index];
  }
  return result;
}
__name(at, "at");
function countBy(arr, mapper) {
  const result = {};
  for (let i = 0; i < arr.length; i++) {
    const item = arr[i];
    const key = mapper(item);
    result[key] = (result[key] ?? 0) + 1;
  }
  return result;
}
__name(countBy, "countBy");
function flatMap(arr, iteratee, depth = 1) {
  return flatten$1(arr.map((item) => iteratee(item)), depth);
}
__name(flatMap, "flatMap");
function flattenDeep(arr) {
  return flatten$1(arr, Infinity);
}
__name(flattenDeep, "flattenDeep");
function flatMapDeep(arr, iteratee) {
  return flattenDeep(arr.map((item) => iteratee(item)));
}
__name(flatMapDeep, "flatMapDeep");
function forEachRight(arr, callback) {
  for (let i = arr.length - 1; i >= 0; i--) {
    const element = arr[i];
    callback(element, i, arr);
  }
}
__name(forEachRight, "forEachRight");
function isSubset(superset, subset) {
  return difference(subset, superset).length === 0;
}
__name(isSubset, "isSubset");
function isSubsetWith(superset, subset, areItemsEqual) {
  return differenceWith(subset, superset, areItemsEqual).length === 0;
}
__name(isSubsetWith, "isSubsetWith");
function keyBy(arr, getKeyFromItem) {
  const result = {};
  for (let i = 0; i < arr.length; i++) {
    const item = arr[i];
    const key = getKeyFromItem(item);
    result[key] = item;
  }
  return result;
}
__name(keyBy, "keyBy");
function compareValues(a, b, order) {
  if (a < b) {
    return order === "asc" ? -1 : 1;
  }
  if (a > b) {
    return order === "asc" ? 1 : -1;
  }
  return 0;
}
__name(compareValues, "compareValues");
function orderBy(arr, criteria, orders) {
  return arr.slice().sort((a, b) => {
    const ordersLength = orders.length;
    for (let i = 0; i < criteria.length; i++) {
      const order = ordersLength > i ? orders[i] : orders[ordersLength - 1];
      const criterion = criteria[i];
      const criterionIsFunction = typeof criterion === "function";
      const valueA = criterionIsFunction ? criterion(a) : a[criterion];
      const valueB = criterionIsFunction ? criterion(b) : b[criterion];
      const result = compareValues(valueA, valueB, order);
      if (result !== 0) {
        return result;
      }
    }
    return 0;
  });
}
__name(orderBy, "orderBy");
function partition(arr, isInTruthy) {
  const truthy = [];
  const falsy = [];
  for (let i = 0; i < arr.length; i++) {
    const item = arr[i];
    if (isInTruthy(item)) {
      truthy.push(item);
    } else {
      falsy.push(item);
    }
  }
  return [truthy, falsy];
}
__name(partition, "partition");
function pullAt(arr, indicesToRemove) {
  const removed = at(arr, indicesToRemove);
  const indices = new Set(indicesToRemove.slice().sort((x, y) => y - x));
  for (const index of indices) {
    arr.splice(index, 1);
  }
  return removed;
}
__name(pullAt, "pullAt");
function sortBy(arr, criteria) {
  return orderBy(arr, criteria, ["asc"]);
}
__name(sortBy, "sortBy");
function takeRightWhile(arr, shouldContinueTaking) {
  for (let i = arr.length - 1; i >= 0; i--) {
    if (!shouldContinueTaking(arr[i])) {
      return arr.slice(i + 1);
    }
  }
  return arr.slice();
}
__name(takeRightWhile, "takeRightWhile");
function takeWhile(arr, shouldContinueTaking) {
  const result = [];
  for (let i = 0; i < arr.length; i++) {
    const item = arr[i];
    if (!shouldContinueTaking(item)) {
      break;
    }
    result.push(item);
  }
  return result;
}
__name(takeWhile, "takeWhile");
function toFilled(arr, value, start = 0, end = arr.length) {
  const length = arr.length;
  const finalStart = Math.max(start >= 0 ? start : length + start, 0);
  const finalEnd = Math.min(end >= 0 ? end : length + end, length);
  const newArr = arr.slice();
  for (let i = finalStart; i < finalEnd; i++) {
    newArr[i] = value;
  }
  return newArr;
}
__name(toFilled, "toFilled");
function union(arr1, arr2) {
  return uniq$1(arr1.concat(arr2));
}
__name(union, "union");
function unionBy(arr1, arr2, mapper) {
  return uniqBy(arr1.concat(arr2), mapper);
}
__name(unionBy, "unionBy");
function unionWith(arr1, arr2, areItemsEqual) {
  return uniqWith(arr1.concat(arr2), areItemsEqual);
}
__name(unionWith, "unionWith");
function unzipWith(target, iteratee) {
  const maxLength = Math.max(...target.map((innerArray) => innerArray.length));
  const result = new Array(maxLength);
  for (let i = 0; i < maxLength; i++) {
    const group = new Array(target.length);
    for (let j = 0; j < target.length; j++) {
      group[j] = target[j][i];
    }
    result[i] = iteratee(...group);
  }
  return result;
}
__name(unzipWith, "unzipWith");
function xor(arr1, arr2) {
  return difference(union(arr1, arr2), intersection(arr1, arr2));
}
__name(xor, "xor");
function xorBy(arr1, arr2, mapper) {
  const union2 = unionBy(arr1, arr2, mapper);
  const intersection2 = intersectionBy(arr1, arr2, mapper);
  return differenceBy(union2, intersection2, mapper);
}
__name(xorBy, "xorBy");
function xorWith(arr1, arr2, areElementsEqual) {
  const union2 = unionWith(arr1, arr2, areElementsEqual);
  const intersection2 = intersectionWith(arr1, arr2, areElementsEqual);
  return differenceWith(union2, intersection2, areElementsEqual);
}
__name(xorWith, "xorWith");
function zipObject(keys2, values) {
  const result = {};
  for (let i = 0; i < keys2.length; i++) {
    result[keys2[i]] = values[i];
  }
  return result;
}
__name(zipObject, "zipObject");
function zipWith(arr1, ...rest) {
  const arrs = [arr1, ...rest.slice(0, -1)];
  const combine = rest[rest.length - 1];
  const maxIndex = Math.max(...arrs.map((arr) => arr.length));
  const result = Array(maxIndex);
  for (let i = 0; i < maxIndex; i++) {
    const elements = arrs.map((arr) => arr[i]);
    result[i] = combine(...elements);
  }
  return result;
}
__name(zipWith, "zipWith");
class AbortError extends Error {
  static {
    __name(this, "AbortError");
  }
  constructor(message = "The operation was aborted") {
    super(message);
    this.name = "AbortError";
  }
}
class TimeoutError extends Error {
  static {
    __name(this, "TimeoutError");
  }
  constructor(message = "The operation was timed out") {
    super(message);
    this.name = "TimeoutError";
  }
}
async function asyncNoop() {
}
__name(asyncNoop, "asyncNoop");
function before(n, func) {
  if (!Number.isInteger(n) || n < 0) {
    throw new Error("n must be a non-negative integer.");
  }
  let counter = 0;
  return (...args) => {
    if (++counter < n) {
      return func(...args);
    }
    return void 0;
  };
}
__name(before, "before");
function curry(func) {
  if (func.length === 0 || func.length === 1) {
    return func;
  }
  return function(arg) {
    return makeCurry(func, func.length, [arg]);
  };
}
__name(curry, "curry");
function makeCurry(origin, argsLength, args) {
  if (args.length === argsLength) {
    return origin(...args);
  } else {
    const next = /* @__PURE__ */ __name(function(arg) {
      return makeCurry(origin, argsLength, [...args, arg]);
    }, "next");
    return next;
  }
}
__name(makeCurry, "makeCurry");
function curryRight(func) {
  if (func.length === 0 || func.length === 1) {
    return func;
  }
  return function(arg) {
    return makeCurryRight(func, func.length, [arg]);
  };
}
__name(curryRight, "curryRight");
function makeCurryRight(origin, argsLength, args) {
  if (args.length === argsLength) {
    return origin(...args);
  } else {
    const next = /* @__PURE__ */ __name(function(arg) {
      return makeCurryRight(origin, argsLength, [arg, ...args]);
    }, "next");
    return next;
  }
}
__name(makeCurryRight, "makeCurryRight");
function memoize(fn, options = {}) {
  const { cache = /* @__PURE__ */ new Map(), getCacheKey } = options;
  const memoizedFn = /* @__PURE__ */ __name(function(arg) {
    const key = getCacheKey ? getCacheKey(arg) : arg;
    if (cache.has(key)) {
      return cache.get(key);
    }
    const result = fn.call(this, arg);
    cache.set(key, result);
    return result;
  }, "memoizedFn");
  memoizedFn.cache = cache;
  return memoizedFn;
}
__name(memoize, "memoize");
function delay(ms, { signal } = {}) {
  return new Promise((resolve, reject) => {
    const abortError = /* @__PURE__ */ __name(() => {
      reject(new AbortError());
    }, "abortError");
    const abortHandler = /* @__PURE__ */ __name(() => {
      clearTimeout(timeoutId);
      abortError();
    }, "abortHandler");
    if (signal?.aborted) {
      return abortError();
    }
    const timeoutId = setTimeout(() => {
      signal?.removeEventListener("abort", abortHandler);
      resolve();
    }, ms);
    signal?.addEventListener("abort", abortHandler, { once: true });
  });
}
__name(delay, "delay");
const DEFAULT_DELAY$1 = 0;
const DEFAULT_RETRIES = Number.POSITIVE_INFINITY;
async function retry(func, _options) {
  let delay$1;
  let retries;
  let signal;
  if (typeof _options === "number") {
    delay$1 = DEFAULT_DELAY$1;
    retries = _options;
    signal = void 0;
  } else {
    delay$1 = _options?.delay ?? DEFAULT_DELAY$1;
    retries = _options?.retries ?? DEFAULT_RETRIES;
    signal = _options?.signal;
  }
  let error;
  for (let attempts = 0; attempts < retries; attempts++) {
    if (signal?.aborted) {
      throw error ?? new Error(`The retry operation was aborted due to an abort signal.`);
    }
    try {
      return await func();
    } catch (err) {
      error = err;
      const currentDelay = typeof delay$1 === "function" ? delay$1(attempts) : delay$1;
      await delay(currentDelay);
    }
  }
  throw error;
}
__name(retry, "retry");
function spread(func) {
  return function(argsArr) {
    return func.apply(this, argsArr);
  };
}
__name(spread, "spread");
function throttle(func, throttleMs, { signal, edges = ["leading", "trailing"] } = {}) {
  let pendingAt = null;
  const debounced = debounce$3(func, throttleMs, { signal, edges });
  const throttled = /* @__PURE__ */ __name(function(...args) {
    if (pendingAt == null) {
      pendingAt = Date.now();
    } else {
      if (Date.now() - pendingAt >= throttleMs) {
        pendingAt = Date.now();
        debounced.cancel();
      }
    }
    debounced(...args);
  }, "throttled");
  throttled.cancel = debounced.cancel;
  throttled.flush = debounced.flush;
  return throttled;
}
__name(throttle, "throttle");
function unary(func) {
  return ary(func, 1);
}
__name(unary, "unary");
function median(nums) {
  if (nums.length === 0) {
    return NaN;
  }
  const sorted = nums.slice().sort((a, b) => a - b);
  const middleIndex = Math.floor(sorted.length / 2);
  if (sorted.length % 2 === 0) {
    return (sorted[middleIndex - 1] + sorted[middleIndex]) / 2;
  } else {
    return sorted[middleIndex];
  }
}
__name(median, "median");
function medianBy(items, getValue2) {
  const nums = items.map((x) => getValue2(x));
  return median(nums);
}
__name(medianBy, "medianBy");
function rangeRight(start, end, step = 1) {
  if (end == null) {
    end = start;
    start = 0;
  }
  if (!Number.isInteger(step) || step === 0) {
    throw new Error(`The step value must be a non-zero integer.`);
  }
  const length = Math.max(Math.ceil((end - start) / step), 0);
  const result = new Array(length);
  for (let i = 0; i < length; i++) {
    result[i] = start + (length - i - 1) * step;
  }
  return result;
}
__name(rangeRight, "rangeRight");
function round$1(value, precision = 0) {
  if (!Number.isInteger(precision)) {
    throw new Error("Precision must be an integer.");
  }
  const multiplier = Math.pow(10, precision);
  return Math.round(value * multiplier) / multiplier;
}
__name(round$1, "round$1");
function sumBy(items, getValue2) {
  let result = 0;
  for (let i = 0; i < items.length; i++) {
    result += getValue2(items[i]);
  }
  return result;
}
__name(sumBy, "sumBy");
function flattenObject(object, { delimiter = "." } = {}) {
  return flattenObjectImpl(object, "", delimiter);
}
__name(flattenObject, "flattenObject");
function flattenObjectImpl(object, prefix = "", delimiter = ".") {
  const result = {};
  const keys2 = Object.keys(object);
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    const value = object[key];
    const prefixedKey = prefix ? `${prefix}${delimiter}${key}` : key;
    if (isPlainObject$1(value) && Object.keys(value).length > 0) {
      Object.assign(result, flattenObjectImpl(value, prefixedKey, delimiter));
      continue;
    }
    if (Array.isArray(value)) {
      Object.assign(result, flattenObjectImpl(value, prefixedKey, delimiter));
      continue;
    }
    result[prefixedKey] = value;
  }
  return result;
}
__name(flattenObjectImpl, "flattenObjectImpl");
function merge(target, source) {
  const sourceKeys = Object.keys(source);
  for (let i = 0; i < sourceKeys.length; i++) {
    const key = sourceKeys[i];
    if (isUnsafeProperty(key)) {
      continue;
    }
    const sourceValue = source[key];
    const targetValue = target[key];
    if (Array.isArray(sourceValue)) {
      if (Array.isArray(targetValue)) {
        target[key] = merge(targetValue, sourceValue);
      } else {
        target[key] = merge([], sourceValue);
      }
    } else if (isPlainObject$1(sourceValue)) {
      if (isPlainObject$1(targetValue)) {
        target[key] = merge(targetValue, sourceValue);
      } else {
        target[key] = merge({}, sourceValue);
      }
    } else if (targetValue === void 0 || sourceValue !== void 0) {
      target[key] = sourceValue;
    }
  }
  return target;
}
__name(merge, "merge");
function mergeWith(target, source, merge2) {
  const sourceKeys = Object.keys(source);
  for (let i = 0; i < sourceKeys.length; i++) {
    const key = sourceKeys[i];
    if (isUnsafeProperty(key)) {
      continue;
    }
    const sourceValue = source[key];
    const targetValue = target[key];
    const merged = merge2(targetValue, sourceValue, key, target, source);
    if (merged !== void 0) {
      target[key] = merged;
    } else if (Array.isArray(sourceValue)) {
      target[key] = mergeWith(targetValue ?? [], sourceValue, merge2);
    } else if (isObjectLike(targetValue) && isObjectLike(sourceValue)) {
      target[key] = mergeWith(targetValue ?? {}, sourceValue, merge2);
    } else if (targetValue === void 0 || sourceValue !== void 0) {
      target[key] = sourceValue;
    }
  }
  return target;
}
__name(mergeWith, "mergeWith");
function omit(obj, keys2) {
  const result = { ...obj };
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    delete result[key];
  }
  return result;
}
__name(omit, "omit");
function omitBy(obj, shouldOmit) {
  const result = {};
  const keys2 = Object.keys(obj);
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    const value = obj[key];
    if (!shouldOmit(value, key)) {
      result[key] = value;
    }
  }
  return result;
}
__name(omitBy, "omitBy");
function pick(obj, keys2) {
  const result = {};
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    if (Object.hasOwn(obj, key)) {
      result[key] = obj[key];
    }
  }
  return result;
}
__name(pick, "pick");
function pickBy(obj, shouldPick) {
  const result = {};
  const keys2 = Object.keys(obj);
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    const value = obj[key];
    if (shouldPick(value, key)) {
      result[key] = value;
    }
  }
  return result;
}
__name(pickBy, "pickBy");
function toCamelCaseKeys(obj) {
  if (isArray(obj)) {
    return obj.map((item) => toCamelCaseKeys(item));
  }
  if (isPlainObject$1(obj)) {
    const result = {};
    const keys2 = Object.keys(obj);
    for (let i = 0; i < keys2.length; i++) {
      const key = keys2[i];
      const camelKey = camelCase(key);
      const camelCaseKeys = toCamelCaseKeys(obj[key]);
      result[camelKey] = camelCaseKeys;
    }
    return result;
  }
  return obj;
}
__name(toCamelCaseKeys, "toCamelCaseKeys");
function toMerged(target, source) {
  return merge(cloneDeep(target), source);
}
__name(toMerged, "toMerged");
function toSnakeCaseKeys(obj) {
  if (isArray(obj)) {
    return obj.map((item) => toSnakeCaseKeys(item));
  }
  if (isPlainObject$2(obj)) {
    const result = {};
    const keys2 = Object.keys(obj);
    for (let i = 0; i < keys2.length; i++) {
      const key = keys2[i];
      const snakeKey = snakeCase(key);
      const snakeCaseKeys = toSnakeCaseKeys(obj[key]);
      result[snakeKey] = snakeCaseKeys;
    }
    return result;
  }
  return obj;
}
__name(toSnakeCaseKeys, "toSnakeCaseKeys");
function isBlob(x) {
  if (typeof Blob === "undefined") {
    return false;
  }
  return x instanceof Blob;
}
__name(isBlob, "isBlob");
function isBoolean(x) {
  return typeof x === "boolean";
}
__name(isBoolean, "isBoolean");
function isBrowser$1() {
  return typeof window !== "undefined" && window?.document != null;
}
__name(isBrowser$1, "isBrowser$1");
function isError(value) {
  return value instanceof Error;
}
__name(isError, "isError");
function isFile(x) {
  if (typeof File === "undefined") {
    return false;
  }
  return isBlob(x) && x instanceof File;
}
__name(isFile, "isFile");
function isJSON(value) {
  if (typeof value !== "string") {
    return false;
  }
  try {
    JSON.parse(value);
    return true;
  } catch {
    return false;
  }
}
__name(isJSON, "isJSON");
function isJSONValue(value) {
  switch (typeof value) {
    case "object": {
      return value === null || isJSONArray(value) || isJSONObject(value);
    }
    case "string":
    case "number":
    case "boolean": {
      return true;
    }
    default: {
      return false;
    }
  }
}
__name(isJSONValue, "isJSONValue");
function isJSONArray(value) {
  if (!Array.isArray(value)) {
    return false;
  }
  return value.every((item) => isJSONValue(item));
}
__name(isJSONArray, "isJSONArray");
function isJSONObject(obj) {
  if (!isPlainObject$1(obj)) {
    return false;
  }
  const keys2 = Reflect.ownKeys(obj);
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    const value = obj[key];
    if (typeof key !== "string") {
      return false;
    }
    if (!isJSONValue(value)) {
      return false;
    }
  }
  return true;
}
__name(isJSONObject, "isJSONObject");
function isNode$1() {
  return typeof process !== "undefined" && process?.versions?.node != null;
}
__name(isNode$1, "isNode$1");
function isNotNil(x) {
  return x != null;
}
__name(isNotNil, "isNotNil");
function isPromise(value) {
  return value instanceof Promise;
}
__name(isPromise, "isPromise");
function isString(value) {
  return typeof value === "string";
}
__name(isString, "isString");
class Semaphore {
  static {
    __name(this, "Semaphore");
  }
  capacity;
  available;
  deferredTasks = [];
  constructor(capacity) {
    this.capacity = capacity;
    this.available = capacity;
  }
  async acquire() {
    if (this.available > 0) {
      this.available--;
      return;
    }
    return new Promise((resolve) => {
      this.deferredTasks.push(resolve);
    });
  }
  release() {
    const deferredTask = this.deferredTasks.shift();
    if (deferredTask != null) {
      deferredTask();
      return;
    }
    if (this.available < this.capacity) {
      this.available++;
    }
  }
}
class Mutex {
  static {
    __name(this, "Mutex");
  }
  semaphore = new Semaphore(1);
  get isLocked() {
    return this.semaphore.available === 0;
  }
  async acquire() {
    return this.semaphore.acquire();
  }
  release() {
    this.semaphore.release();
  }
}
async function timeout(ms) {
  await delay(ms);
  throw new TimeoutError();
}
__name(timeout, "timeout");
async function withTimeout(run, ms) {
  return Promise.race([run(), timeout(ms)]);
}
__name(withTimeout, "withTimeout");
function constantCase(str) {
  const words$1 = words(str);
  return words$1.map((word) => word.toUpperCase()).join("_");
}
__name(constantCase, "constantCase");
function pascalCase(str) {
  const words$1 = words(str);
  return words$1.map((word) => capitalize(word)).join("");
}
__name(pascalCase, "pascalCase");
function reverseString(value) {
  return [...value].reverse().join("");
}
__name(reverseString, "reverseString");
function startCase(str) {
  const words$1 = words(str.trim());
  let result = "";
  for (let i = 0; i < words$1.length; i++) {
    const word = words$1[i];
    if (result) {
      result += " ";
    }
    result += word[0].toUpperCase() + word.slice(1).toLowerCase();
  }
  return result;
}
__name(startCase, "startCase");
function attempt(func) {
  try {
    return [null, func()];
  } catch (error) {
    return [error, null];
  }
}
__name(attempt, "attempt");
async function attemptAsync(func) {
  try {
    const result = await func();
    return [null, result];
  } catch (error) {
    return [error, null];
  }
}
__name(attemptAsync, "attemptAsync");
function invariant(condition, message) {
  if (condition) {
    return;
  }
  if (typeof message === "string") {
    throw new Error(message);
  }
  throw message;
}
__name(invariant, "invariant");
const _hoisted_1$R = { class: "flex items-center justify-between gap-2 h-[30px] overscroll-contain" };
const _hoisted_2$o = {
  key: 0,
  class: "text-sm text-stone-200 dark-theme:text-slate-200 font-normal flex-1 truncate w-20"
};
const _sfc_main$P = /* @__PURE__ */ defineComponent({
  __name: "WidgetLayoutField",
  props: {
    widget: {}
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$R, [
        _ctx.widget.name ? (openBlock(), createElementBlock("p", _hoisted_2$o, toDisplayString(_ctx.widget.name), 1)) : createCommentVNode("", true),
        createElementVNode("div", {
          class: "w-75 cursor-default",
          onPointerdown: _cache[0] || (_cache[0] = withModifiers(
            //@ts-ignore
            (...args) => unref(noop$1) && unref(noop$1)(...args),
            ["stop"]
          )),
          onPointermove: _cache[1] || (_cache[1] = withModifiers(
            //@ts-ignore
            (...args) => unref(noop$1) && unref(noop$1)(...args),
            ["stop"]
          )),
          onPointerup: _cache[2] || (_cache[2] = withModifiers(
            //@ts-ignore
            (...args) => unref(noop$1) && unref(noop$1)(...args),
            ["stop"]
          ))
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 32)
      ]);
    };
  }
});
const _sfc_main$O = /* @__PURE__ */ defineComponent({
  __name: "WidgetInputText",
  props: {
    widget: {},
    modelValue: {},
    readonly: { type: Boolean }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const { localValue, onChange } = useStringWidgetValue(
      props2.widget,
      props2.modelValue,
      emit
    );
    const filteredProps = computed(
      () => filterWidgetProps(props2.widget.options, INPUT_EXCLUDED_PROPS)
    );
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$P, { widget: _ctx.widget }, {
        default: withCtx(() => [
          createVNode(unref(InputText), mergeProps({
            modelValue: unref(localValue),
            "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => isRef(localValue) ? localValue.value = $event : null)
          }, filteredProps.value, {
            disabled: _ctx.readonly,
            class: unref(cn)(unref(WidgetInputBaseClass), "w-full text-xs py-2 px-4"),
            size: "small",
            "onUpdate:modelValue": unref(onChange)
          }), null, 16, ["modelValue", "disabled", "class", "onUpdate:modelValue"])
        ]),
        _: 1
      }, 8, ["widget"]);
    };
  }
});
const _hoisted_1$Q = { class: "flex flex-col gap-1" };
const _hoisted_2$n = {
  key: 0,
  class: "text-sm opacity-80"
};
const _sfc_main$N = /* @__PURE__ */ defineComponent({
  __name: "WidgetButton",
  props: {
    widget: {},
    readonly: { type: Boolean }
  },
  setup(__props) {
    const props2 = __props;
    const BUTTON_EXCLUDED_PROPS = [...BADGE_EXCLUDED_PROPS, "iconClass"];
    const filteredProps = computed(
      () => filterWidgetProps(props2.widget.options, BUTTON_EXCLUDED_PROPS)
    );
    const handleClick = /* @__PURE__ */ __name(() => {
      if (!props2.readonly && props2.widget.callback) {
        props2.widget.callback();
      }
    }, "handleClick");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$Q, [
        _ctx.widget.name ? (openBlock(), createElementBlock("label", _hoisted_2$n, toDisplayString(_ctx.widget.name), 1)) : createCommentVNode("", true),
        createVNode(unref(Button), mergeProps(filteredProps.value, {
          disabled: _ctx.readonly,
          size: "small",
          onClick: handleClick
        }), null, 16, ["disabled"])
      ]);
    };
  }
});
const _hoisted_1$P = { class: "flex flex-col gap-1" };
const _hoisted_2$m = { class: "p-4 border border-gray-300 dark-theme:border-gray-600 rounded max-h-[48rem]" };
const _sfc_main$M = /* @__PURE__ */ defineComponent({
  __name: "WidgetChart",
  props: /* @__PURE__ */ mergeModels({
    widget: {},
    readonly: { type: Boolean }
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const value = useModel(__props, "modelValue");
    const props2 = __props;
    const chartType = computed(() => props2.widget.options?.type ?? "line");
    const chartData = computed(() => value.value || { labels: [], datasets: [] });
    const chartOptions = computed(() => ({
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          labels: {
            color: "#FFF",
            usePointStyle: true,
            pointStyle: "circle"
          }
        }
      },
      scales: {
        x: {
          ticks: {
            color: "#9FA2BD"
          },
          grid: {
            display: true,
            color: "#9FA2BD",
            drawTicks: false,
            drawOnChartArea: true,
            drawBorder: false
          },
          border: {
            display: true,
            color: "#9FA2BD"
          }
        },
        y: {
          ticks: {
            color: "#9FA2BD"
          },
          grid: {
            display: false,
            drawTicks: false,
            drawOnChartArea: false,
            drawBorder: false
          },
          border: {
            display: true,
            color: "#9FA2BD"
          }
        }
      }
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$P, [
        createElementVNode("div", _hoisted_2$m, [
          createVNode(unref(Chart), {
            type: chartType.value,
            data: chartData.value,
            options: chartOptions.value
          }, null, 8, ["type", "data", "options"])
        ])
      ]);
    };
  }
});
const _hoisted_1$O = {
  class: "text-xs",
  "data-testid": "widget-color-text"
};
const _sfc_main$L = /* @__PURE__ */ defineComponent({
  __name: "WidgetColorPicker",
  props: {
    widget: {},
    modelValue: {},
    readonly: { type: Boolean }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const format = computed(() => {
      const optionFormat = props2.widget.options?.format;
      return isColorFormat(optionFormat) ? optionFormat : "hex";
    });
    const localValue = ref(
      toHexFromFormat(
        props2.modelValue || "#000000",
        isColorFormat(props2.widget.options?.format) ? props2.widget.options.format : "hex"
      )
    );
    watch(
      () => props2.modelValue,
      (newVal) => {
        localValue.value = toHexFromFormat(newVal || "#000000", format.value);
      }
    );
    function onPickerUpdate(val) {
      localValue.value = val;
      emit("update:modelValue", toHexFromFormat(val, format.value));
    }
    __name(onPickerUpdate, "onPickerUpdate");
    const COLOR_PICKER_EXCLUDED_PROPS = [...PANEL_EXCLUDED_PROPS];
    const filteredProps = computed(
      () => filterWidgetProps(props2.widget.options, COLOR_PICKER_EXCLUDED_PROPS)
    );
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$P, { widget: _ctx.widget }, {
        default: withCtx(() => [
          createElementVNode("label", {
            class: normalizeClass(
              unref(cn)(unref(WidgetInputBaseClass), "flex items-center gap-2 w-full px-4 py-2")
            )
          }, [
            createVNode(unref(ColorPicker), mergeProps({
              modelValue: localValue.value,
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => localValue.value = $event)
            }, filteredProps.value, {
              disabled: _ctx.readonly,
              class: "w-8 h-4 !rounded-full overflow-hidden border-none",
              pt: {
                preview: "!w-full !h-full !border-none"
              },
              "onUpdate:modelValue": onPickerUpdate
            }), null, 16, ["modelValue", "disabled"]),
            createElementVNode("span", _hoisted_1$O, toDisplayString(unref(toHexFromFormat)(localValue.value, format.value)), 1)
          ], 2)
        ]),
        _: 1
      }, 8, ["widget"]);
    };
  }
});
function useTransformCompatOverlayProps(overrides = {}) {
  return computed(() => ({
    appendTo: "self",
    ...overrides
  }));
}
__name(useTransformCompatOverlayProps, "useTransformCompatOverlayProps");
const _hoisted_1$N = {
  key: 0,
  class: "relative -mx-2",
  style: { "width": "calc(100% + 1rem)" }
};
const _hoisted_2$l = { class: "flex items-center justify-between gap-4 mb-2 px-2" };
const _hoisted_3$d = {
  key: 0,
  class: "text-xs opacity-80 min-w-[4em] truncate"
};
const _hoisted_4$a = { class: "flex items-center gap-1" };
const _hoisted_5$4 = { class: "relative group" };
const _hoisted_6$2 = ["src", "alt"];
const _hoisted_7$1 = {
  key: 0,
  class: "absolute top-2 right-2 flex gap-1 opacity-0 group-hover:opacity-100 transition-opacity duration-200"
};
const _hoisted_8$1 = {
  key: 1,
  class: "relative -mx-2",
  style: { "width": "calc(100% + 1rem)" }
};
const _hoisted_9 = { class: "flex items-center justify-between gap-4 mb-2 px-2" };
const _hoisted_10 = {
  key: 0,
  class: "text-xs opacity-80 min-w-[4em] truncate"
};
const _hoisted_11 = { class: "flex items-center gap-1" };
const _hoisted_12 = { class: "relative group px-2" };
const _hoisted_13 = {
  class: "bg-[#1a1b1e] rounded-lg p-4 flex items-center gap-4",
  style: { "border": "1px solid #262729" }
};
const _hoisted_14 = { class: "flex-1" };
const _hoisted_15 = { class: "text-sm font-medium mb-1" };
const _hoisted_16 = { class: "text-xs opacity-60" };
const _hoisted_17 = {
  key: 0,
  class: "flex gap-1"
};
const _hoisted_18 = {
  key: 2,
  class: "flex flex-col gap-1 w-full border border-solid p-1 rounded-lg",
  style: { borderColor: "#262729" }
};
const _hoisted_19 = {
  class: "border border-dashed p-1 rounded-md transition-colors duration-200 hover:border-[#5B5E7D]",
  style: { borderColor: "#262729" }
};
const _hoisted_20 = { class: "flex flex-col items-center gap-2 w-full py-4" };
const _hoisted_21 = { class: "text-xs opacity-60" };
const _hoisted_22 = ["accept", "disabled"];
const _sfc_main$K = /* @__PURE__ */ defineComponent({
  __name: "WidgetFileUpload",
  props: {
    widget: {},
    modelValue: {},
    readonly: { type: Boolean, default: false }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const { localValue, onChange } = useWidgetValue({
      widget: __props.widget,
      modelValue: __props.modelValue,
      defaultValue: null,
      emit
    });
    const transformCompatProps = useTransformCompatOverlayProps();
    const fileInputRef = ref(null);
    const selectedFile = computed(() => {
      const files = localValue.value || [];
      return files.length > 0 ? files[0] : null;
    });
    const detectFileType = /* @__PURE__ */ __name((file) => {
      const type = file.type?.toLowerCase() || "";
      const name = file.name?.toLowerCase() || "";
      if (type.startsWith("image/") || name.match(/\.(jpg|jpeg|png|gif|webp|svg)$/)) {
        return "image";
      }
      if (type.startsWith("video/") || name.match(/\.(mp4|webm|ogg|mov)$/)) {
        return "video";
      }
      if (type.startsWith("audio/") || name.match(/\.(mp3|wav|ogg|flac)$/)) {
        return "audio";
      }
      if (type === "application/pdf" || name.endsWith(".pdf")) {
        return "pdf";
      }
      if (type.includes("zip") || name.match(/\.(zip|rar|7z|tar|gz)$/)) {
        return "archive";
      }
      return "file";
    }, "detectFileType");
    const hasImageFile = computed(() => {
      return selectedFile.value && detectFileType(selectedFile.value) === "image";
    });
    const hasAudioFile = computed(() => {
      return selectedFile.value && detectFileType(selectedFile.value) === "audio";
    });
    const imageUrl = computed(() => {
      if (hasImageFile.value && selectedFile.value) {
        return URL.createObjectURL(selectedFile.value);
      }
      return "";
    });
    watch(imageUrl, (newUrl, oldUrl) => {
      if (oldUrl && oldUrl !== newUrl) {
        URL.revokeObjectURL(oldUrl);
      }
    });
    const triggerFileInput = /* @__PURE__ */ __name(() => {
      fileInputRef.value?.click();
    }, "triggerFileInput");
    const handleFileChange = /* @__PURE__ */ __name((event) => {
      const target = event.target;
      if (!__props.readonly && target.files && target.files.length > 0) {
        const file = target.files[0];
        onChange([file]);
        target.value = "";
      }
    }, "handleFileChange");
    const clearFile = /* @__PURE__ */ __name(() => {
      onChange(null);
      if (fileInputRef.value) {
        fileInputRef.value.value = "";
      }
    }, "clearFile");
    const handleEdit = /* @__PURE__ */ __name(() => {
    }, "handleEdit");
    watch(localValue, (newValue) => {
      if (!newValue || newValue.length === 0) {
        if (fileInputRef.value) {
          fileInputRef.value.value = "";
        }
      }
    });
    onUnmounted(() => {
      if (imageUrl.value) {
        URL.revokeObjectURL(imageUrl.value);
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        hasImageFile.value ? (openBlock(), createElementBlock("div", _hoisted_1$N, [
          createElementVNode("div", _hoisted_2$l, [
            _ctx.widget.name ? (openBlock(), createElementBlock("label", _hoisted_3$d, toDisplayString(_ctx.widget.name), 1)) : createCommentVNode("", true),
            createElementVNode("div", _hoisted_4$a, [
              createVNode(unref(Select), mergeProps({
                "model-value": selectedFile.value?.name,
                options: [selectedFile.value?.name || ""],
                disabled: true
              }, unref(transformCompatProps), {
                class: "min-w-[8em] max-w-[20em] text-xs",
                size: "small",
                pt: {
                  option: "text-xs"
                }
              }), null, 16, ["model-value", "options"]),
              createVNode(unref(Button), {
                icon: "pi pi-folder",
                size: "small",
                class: "!w-8 !h-8",
                disabled: _ctx.readonly,
                onClick: triggerFileInput
              }, null, 8, ["disabled"])
            ])
          ]),
          createElementVNode("div", _hoisted_5$4, [
            createElementVNode("img", {
              src: imageUrl.value,
              alt: selectedFile.value?.name,
              class: "w-full h-auto"
            }, null, 8, _hoisted_6$2),
            _cache[2] || (_cache[2] = createElementVNode("div", { class: "absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-20 transition-all duration-200 pointer-events-none" }, null, -1)),
            !_ctx.readonly ? (openBlock(), createElementBlock("div", _hoisted_7$1, [
              createElementVNode("button", {
                class: "w-6 h-6 rounded flex items-center justify-center transition-all duration-150 focus:outline-none border-none",
                style: { "background-color": "#262729" },
                onClick: handleEdit
              }, _cache[0] || (_cache[0] = [
                createElementVNode("i", { class: "pi pi-pencil text-white text-xs" }, null, -1)
              ])),
              createElementVNode("button", {
                class: "w-6 h-6 rounded flex items-center justify-center transition-all duration-150 focus:outline-none border-none",
                style: { "background-color": "#262729" },
                onClick: clearFile
              }, _cache[1] || (_cache[1] = [
                createElementVNode("i", { class: "pi pi-times text-white text-xs" }, null, -1)
              ]))
            ])) : createCommentVNode("", true)
          ])
        ])) : hasAudioFile.value ? (openBlock(), createElementBlock("div", _hoisted_8$1, [
          createElementVNode("div", _hoisted_9, [
            _ctx.widget.name ? (openBlock(), createElementBlock("label", _hoisted_10, toDisplayString(_ctx.widget.name), 1)) : createCommentVNode("", true),
            createElementVNode("div", _hoisted_11, [
              createVNode(unref(Select), mergeProps({
                "model-value": selectedFile.value?.name,
                options: [selectedFile.value?.name || ""],
                disabled: true
              }, unref(transformCompatProps), {
                class: "min-w-[8em] max-w-[20em] text-xs",
                size: "small",
                pt: {
                  option: "text-xs"
                }
              }), null, 16, ["model-value", "options"]),
              createVNode(unref(Button), {
                icon: "pi pi-folder",
                size: "small",
                class: "!w-8 !h-8",
                disabled: _ctx.readonly,
                onClick: triggerFileInput
              }, null, 8, ["disabled"])
            ])
          ]),
          createElementVNode("div", _hoisted_12, [
            createElementVNode("div", _hoisted_13, [
              _cache[4] || (_cache[4] = createElementVNode("div", { class: "flex-shrink-0" }, [
                createElementVNode("i", { class: "pi pi-volume-up text-2xl opacity-60" })
              ], -1)),
              createElementVNode("div", _hoisted_14, [
                createElementVNode("div", _hoisted_15, toDisplayString(selectedFile.value?.name), 1),
                createElementVNode("div", _hoisted_16, toDisplayString(selectedFile.value ? (selectedFile.value.size / 1024).toFixed(1) + " KB" : ""), 1)
              ]),
              !_ctx.readonly ? (openBlock(), createElementBlock("div", _hoisted_17, [
                createElementVNode("button", {
                  class: "w-8 h-8 rounded flex items-center justify-center transition-all duration-150 focus:outline-none border-none hover:bg-[#262729]",
                  onClick: clearFile
                }, _cache[3] || (_cache[3] = [
                  createElementVNode("i", { class: "pi pi-times text-white text-sm" }, null, -1)
                ]))
              ])) : createCommentVNode("", true)
            ])
          ])
        ])) : (openBlock(), createElementBlock("div", _hoisted_18, [
          createElementVNode("div", _hoisted_19, [
            createElementVNode("div", _hoisted_20, [
              createElementVNode("span", _hoisted_21, toDisplayString(_ctx.$t("Drop your file or")), 1),
              createElementVNode("div", null, [
                createVNode(unref(Button), {
                  label: "Browse Files",
                  size: "small",
                  severity: "secondary",
                  class: "text-xs",
                  disabled: _ctx.readonly,
                  onClick: triggerFileInput
                }, null, 8, ["disabled"])
              ])
            ])
          ])
        ])),
        createElementVNode("input", {
          ref_key: "fileInputRef",
          ref: fileInputRef,
          type: "file",
          class: "hidden",
          accept: _ctx.widget.options?.accept,
          multiple: false,
          disabled: _ctx.readonly,
          onChange: handleFileChange
        }, null, 40, _hoisted_22)
      ], 64);
    };
  }
});
const _hoisted_1$M = { class: "flex flex-col gap-1" };
const _hoisted_2$k = ["src", "alt"];
const _hoisted_3$c = { class: "p-1 w-full h-full" };
const _hoisted_4$9 = ["src", "alt"];
const _sfc_main$J = /* @__PURE__ */ defineComponent({
  __name: "WidgetGalleria",
  props: /* @__PURE__ */ mergeModels({
    widget: {},
    readonly: { type: Boolean }
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const value = useModel(__props, "modelValue");
    const props2 = __props;
    const activeIndex = ref(0);
    const { t: t2 } = useI18n();
    const filteredProps = computed(
      () => filterWidgetProps(props2.widget.options, GALLERIA_EXCLUDED_PROPS)
    );
    const galleryImages = computed(() => {
      if (!value.value || !Array.isArray(value.value)) return [];
      return value.value.filter((item) => item !== null && item !== void 0).map((item, index) => {
        if (typeof item === "string") {
          return {
            itemImageSrc: item,
            thumbnailImageSrc: item,
            alt: `Image ${index}`
          };
        }
        return item ?? {};
      });
    });
    const showThumbnails = computed(() => {
      return props2.widget.options?.showThumbnails !== false && galleryImages.value.length > 1;
    });
    const showNavButtons = computed(() => {
      return props2.widget.options?.showItemNavigators !== false && galleryImages.value.length > 1;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$M, [
        createVNode(unref(Galleria), mergeProps({
          "active-index": activeIndex.value,
          "onUpdate:activeIndex": _cache[0] || (_cache[0] = ($event) => activeIndex.value = $event),
          value: galleryImages.value
        }, filteredProps.value, {
          "show-thumbnails": showThumbnails.value,
          "show-item-navigators": showNavButtons.value,
          class: "max-w-full",
          pt: {
            thumbnails: {
              class: "overflow-hidden"
            },
            thumbnailContent: {
              class: "py-4 px-2"
            },
            thumbnailPrevButton: {
              class: "m-0"
            },
            thumbnailNextButton: {
              class: "m-0"
            }
          }
        }), {
          item: withCtx(({ item }) => [
            createElementVNode("img", {
              src: item?.itemImageSrc || item?.src || "",
              alt: item?.alt || `${unref(t2)("g.galleryImage")} ${activeIndex.value + 1} of ${galleryImages.value.length}`,
              class: "w-full h-auto max-h-64 object-contain"
            }, null, 8, _hoisted_2$k)
          ]),
          thumbnail: withCtx(({ item }) => [
            createElementVNode("div", _hoisted_3$c, [
              createElementVNode("img", {
                src: item?.thumbnailImageSrc || item?.src || "",
                alt: item?.alt || `${unref(t2)("g.galleryThumbnail")} ${galleryImages.value.findIndex((img) => img === item) + 1} of ${galleryImages.value.length}`,
                class: "w-full h-full object-cover rounded-lg"
              }, null, 8, _hoisted_4$9)
            ])
          ]),
          _: 1
        }, 16, ["active-index", "value", "show-thumbnails", "show-item-navigators"])
      ]);
    };
  }
});
const WidgetGalleria = /* @__PURE__ */ _export_sfc(_sfc_main$J, [["__scopeId", "data-v-1cf4c28b"]]);
const _hoisted_1$L = ["src", "alt"];
const _hoisted_2$j = ["src", "alt"];
const _sfc_main$I = /* @__PURE__ */ defineComponent({
  __name: "WidgetImageCompare",
  props: {
    widget: {},
    readonly: { type: Boolean }
  },
  setup(__props) {
    const props2 = __props;
    const beforeImage = computed(() => {
      const value = props2.widget.value;
      return typeof value === "string" ? value : value?.before || "";
    });
    const afterImage = computed(() => {
      const value = props2.widget.value;
      return typeof value === "string" ? "" : value?.after || "";
    });
    const beforeAlt = computed(() => {
      const value = props2.widget.value;
      return typeof value === "object" && value?.beforeAlt ? value.beforeAlt : "Before image";
    });
    const afterAlt = computed(() => {
      const value = props2.widget.value;
      return typeof value === "object" && value?.afterAlt ? value.afterAlt : "After image";
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ImageCompare), {
        tabindex: _ctx.widget.options?.tabindex ?? 0,
        "aria-label": _ctx.widget.options?.ariaLabel,
        "aria-labelledby": _ctx.widget.options?.ariaLabelledby,
        pt: _ctx.widget.options?.pt,
        "pt-options": _ctx.widget.options?.ptOptions,
        unstyled: _ctx.widget.options?.unstyled
      }, {
        left: withCtx(() => [
          createElementVNode("img", {
            src: beforeImage.value,
            alt: beforeAlt.value,
            class: "w-full h-full object-cover"
          }, null, 8, _hoisted_1$L)
        ]),
        right: withCtx(() => [
          createElementVNode("img", {
            src: afterImage.value,
            alt: afterAlt.value,
            class: "w-full h-full object-cover"
          }, null, 8, _hoisted_2$j)
        ]),
        _: 1
      }, 8, ["tabindex", "aria-label", "aria-labelledby", "pt", "pt-options", "unstyled"]);
    };
  }
});
const _sfc_main$H = /* @__PURE__ */ defineComponent({
  __name: "WidgetInputNumberInput",
  props: /* @__PURE__ */ mergeModels({
    widget: {},
    readonly: { type: Boolean }
  }, {
    "modelValue": { default: 0 },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const props2 = __props;
    const modelValue = useModel(__props, "modelValue");
    const filteredProps = computed(
      () => filterWidgetProps(props2.widget.options, INPUT_EXCLUDED_PROPS)
    );
    const precision = computed(() => {
      const p = props2.widget.options?.precision;
      return typeof p === "number" && p >= 0 ? p : void 0;
    });
    const stepValue = computed(() => {
      if (props2.widget.options?.step2 !== void 0) {
        return Number(props2.widget.options.step2);
      }
      if (precision.value !== void 0) {
        if (precision.value === 0) {
          return 1;
        }
        return Number((1 / Math.pow(10, precision.value)).toFixed(precision.value));
      }
      return 0;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$P, { widget: _ctx.widget }, {
        default: withCtx(() => [
          createVNode(unref(InputNumber$1), mergeProps({
            modelValue: modelValue.value,
            "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => modelValue.value = $event)
          }, filteredProps.value, {
            "show-buttons": "",
            "button-layout": "horizontal",
            size: "small",
            disabled: _ctx.readonly,
            step: stepValue.value,
            class: unref(cn)(unref(WidgetInputBaseClass), "w-full text-xs"),
            pt: {
              incrementButton: "!rounded-r-lg bg-transparent border-none hover:bg-zinc-500/30 active:bg-zinc-500/40",
              decrementButton: "!rounded-l-lg bg-transparent border-none hover:bg-zinc-500/30 active:bg-zinc-500/40"
            }
          }), {
            incrementicon: withCtx(() => _cache[1] || (_cache[1] = [
              createElementVNode("span", { class: "pi pi-plus text-sm" }, null, -1)
            ])),
            decrementicon: withCtx(() => _cache[2] || (_cache[2] = [
              createElementVNode("span", { class: "pi pi-minus text-sm" }, null, -1)
            ])),
            _: 1
          }, 16, ["modelValue", "disabled", "step", "class"])
        ]),
        _: 1
      }, 8, ["widget"]);
    };
  }
});
const WidgetInputNumberInput = /* @__PURE__ */ _export_sfc(_sfc_main$H, [["__scopeId", "data-v-b02bb182"]]);
function serialize(o) {
  return typeof o == "string" ? `'${o}'` : new c().serialize(o);
}
__name(serialize, "serialize");
const c = /* @__PURE__ */ function() {
  class o {
    static {
      __name(this, "o");
    }
    #t = /* @__PURE__ */ new Map();
    compare(t2, r2) {
      const e = typeof t2, n = typeof r2;
      return e === "string" && n === "string" ? t2.localeCompare(r2) : e === "number" && n === "number" ? t2 - r2 : String.prototype.localeCompare.call(this.serialize(t2, true), this.serialize(r2, true));
    }
    serialize(t2, r2) {
      if (t2 === null) return "null";
      switch (typeof t2) {
        case "string":
          return r2 ? t2 : `'${t2}'`;
        case "bigint":
          return `${t2}n`;
        case "object":
          return this.$object(t2);
        case "function":
          return this.$function(t2);
      }
      return String(t2);
    }
    serializeObject(t2) {
      const r2 = Object.prototype.toString.call(t2);
      if (r2 !== "[object Object]") return this.serializeBuiltInType(r2.length < 10 ? `unknown:${r2}` : r2.slice(8, -1), t2);
      const e = t2.constructor, n = e === Object || e === void 0 ? "" : e.name;
      if (n !== "" && globalThis[n] === e) return this.serializeBuiltInType(n, t2);
      if (typeof t2.toJSON == "function") {
        const i = t2.toJSON();
        return n + (i !== null && typeof i == "object" ? this.$object(i) : `(${this.serialize(i)})`);
      }
      return this.serializeObjectEntries(n, Object.entries(t2));
    }
    serializeBuiltInType(t2, r2) {
      const e = this["$" + t2];
      if (e) return e.call(this, r2);
      if (typeof r2?.entries == "function") return this.serializeObjectEntries(t2, r2.entries());
      throw new Error(`Cannot serialize ${t2}`);
    }
    serializeObjectEntries(t2, r2) {
      const e = Array.from(r2).sort((i, a) => this.compare(i[0], a[0]));
      let n = `${t2}{`;
      for (let i = 0; i < e.length; i++) {
        const [a, l2] = e[i];
        n += `${this.serialize(a, true)}:${this.serialize(l2)}`, i < e.length - 1 && (n += ",");
      }
      return n + "}";
    }
    $object(t2) {
      let r2 = this.#t.get(t2);
      return r2 === void 0 && (this.#t.set(t2, `#${this.#t.size}`), r2 = this.serializeObject(t2), this.#t.set(t2, r2)), r2;
    }
    $function(t2) {
      const r2 = Function.prototype.toString.call(t2);
      return r2.slice(-15) === "[native code] }" ? `${t2.name || ""}()[native]` : `${t2.name}(${t2.length})${r2.replace(/\s*\n\s*/g, "")}`;
    }
    $Array(t2) {
      let r2 = "[";
      for (let e = 0; e < t2.length; e++) r2 += this.serialize(t2[e]), e < t2.length - 1 && (r2 += ",");
      return r2 + "]";
    }
    $Date(t2) {
      try {
        return `Date(${t2.toISOString()})`;
      } catch {
        return "Date(null)";
      }
    }
    $ArrayBuffer(t2) {
      return `ArrayBuffer[${new Uint8Array(t2).join(",")}]`;
    }
    $Set(t2) {
      return `Set${this.$Array(Array.from(t2).sort((r2, e) => this.compare(r2, e)))}`;
    }
    $Map(t2) {
      return this.serializeObjectEntries("Map", t2.entries());
    }
  }
  for (const s of ["Error", "RegExp", "URL"]) o.prototype["$" + s] = function(t2) {
    return `${s}(${t2})`;
  };
  for (const s of ["Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Uint16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array"]) o.prototype["$" + s] = function(t2) {
    return `${s}[${t2.join(",")}]`;
  };
  for (const s of ["BigInt64Array", "BigUint64Array"]) o.prototype["$" + s] = function(t2) {
    return `${s}[${t2.join("n,")}${t2.length > 0 ? "n" : ""}]`;
  };
  return o;
}();
function isEqual(object1, object2) {
  if (object1 === object2) {
    return true;
  }
  if (serialize(object1) === serialize(object2)) {
    return true;
  }
  return false;
}
__name(isEqual, "isEqual");
const z = [1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225], R = [1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998], S = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", r = [];
class k {
  static {
    __name(this, "k");
  }
  _data = new l();
  _hash = new l([...z]);
  _nDataBytes = 0;
  _minBufferSize = 0;
  finalize(e) {
    e && this._append(e);
    const s = this._nDataBytes * 8, t2 = this._data.sigBytes * 8;
    return this._data.words[t2 >>> 5] |= 128 << 24 - t2 % 32, this._data.words[(t2 + 64 >>> 9 << 4) + 14] = Math.floor(s / 4294967296), this._data.words[(t2 + 64 >>> 9 << 4) + 15] = s, this._data.sigBytes = this._data.words.length * 4, this._process(), this._hash;
  }
  _doProcessBlock(e, s) {
    const t2 = this._hash.words;
    let i = t2[0], o = t2[1], a = t2[2], c2 = t2[3], h2 = t2[4], g = t2[5], f = t2[6], y = t2[7];
    for (let n = 0; n < 64; n++) {
      if (n < 16) r[n] = e[s + n] | 0;
      else {
        const d = r[n - 15], j = (d << 25 | d >>> 7) ^ (d << 14 | d >>> 18) ^ d >>> 3, B = r[n - 2], x = (B << 15 | B >>> 17) ^ (B << 13 | B >>> 19) ^ B >>> 10;
        r[n] = j + r[n - 7] + x + r[n - 16];
      }
      const m = h2 & g ^ ~h2 & f, p = i & o ^ i & a ^ o & a, u = (i << 30 | i >>> 2) ^ (i << 19 | i >>> 13) ^ (i << 10 | i >>> 22), b = (h2 << 26 | h2 >>> 6) ^ (h2 << 21 | h2 >>> 11) ^ (h2 << 7 | h2 >>> 25), w = y + b + m + R[n] + r[n], M = u + p;
      y = f, f = g, g = h2, h2 = c2 + w | 0, c2 = a, a = o, o = i, i = w + M | 0;
    }
    t2[0] = t2[0] + i | 0, t2[1] = t2[1] + o | 0, t2[2] = t2[2] + a | 0, t2[3] = t2[3] + c2 | 0, t2[4] = t2[4] + h2 | 0, t2[5] = t2[5] + g | 0, t2[6] = t2[6] + f | 0, t2[7] = t2[7] + y | 0;
  }
  _append(e) {
    typeof e == "string" && (e = l.fromUtf8(e)), this._data.concat(e), this._nDataBytes += e.sigBytes;
  }
  _process(e) {
    let s, t2 = this._data.sigBytes / 64;
    e ? t2 = Math.ceil(t2) : t2 = Math.max((t2 | 0) - this._minBufferSize, 0);
    const i = t2 * 16, o = Math.min(i * 4, this._data.sigBytes);
    if (i) {
      for (let a = 0; a < i; a += 16) this._doProcessBlock(this._data.words, a);
      s = this._data.words.splice(0, i), this._data.sigBytes -= o;
    }
    return new l(s, o);
  }
}
class l {
  static {
    __name(this, "l");
  }
  words;
  sigBytes;
  constructor(e, s) {
    e = this.words = e || [], this.sigBytes = s === void 0 ? e.length * 4 : s;
  }
  static fromUtf8(e) {
    const s = unescape(encodeURIComponent(e)), t2 = s.length, i = [];
    for (let o = 0; o < t2; o++) i[o >>> 2] |= (s.charCodeAt(o) & 255) << 24 - o % 4 * 8;
    return new l(i, t2);
  }
  toBase64() {
    const e = [];
    for (let s = 0; s < this.sigBytes; s += 3) {
      const t2 = this.words[s >>> 2] >>> 24 - s % 4 * 8 & 255, i = this.words[s + 1 >>> 2] >>> 24 - (s + 1) % 4 * 8 & 255, o = this.words[s + 2 >>> 2] >>> 24 - (s + 2) % 4 * 8 & 255, a = t2 << 16 | i << 8 | o;
      for (let c2 = 0; c2 < 4 && s * 8 + c2 * 6 < this.sigBytes * 8; c2++) e.push(S.charAt(a >>> 6 * (3 - c2) & 63));
    }
    return e.join("");
  }
  concat(e) {
    if (this.words[this.sigBytes >>> 2] &= 4294967295 << 32 - this.sigBytes % 4 * 8, this.words.length = Math.ceil(this.sigBytes / 4), this.sigBytes % 4) for (let s = 0; s < e.sigBytes; s++) {
      const t2 = e.words[s >>> 2] >>> 24 - s % 4 * 8 & 255;
      this.words[this.sigBytes + s >>> 2] |= t2 << 24 - (this.sigBytes + s) % 4 * 8;
    }
    else for (let s = 0; s < e.sigBytes; s += 4) this.words[this.sigBytes + s >>> 2] = e.words[s >>> 2];
    this.sigBytes += e.sigBytes;
  }
}
function digest(_) {
  return new k().finalize(_).toBase64();
}
__name(digest, "digest");
function hash(input) {
  return digest(serialize(input));
}
__name(hash, "hash");
function areEqual(arrayA, arrayB) {
  if (arrayA.length !== arrayB.length) return false;
  for (let index = 0; index < arrayA.length; index++) if (arrayA[index] !== arrayB[index]) return false;
  return true;
}
__name(areEqual, "areEqual");
function findValuesBetween(array, start, end) {
  const startIndex = array.findIndex((i) => isEqual(i, start));
  const endIndex = array.findIndex((i) => isEqual(i, end));
  if (startIndex === -1 || endIndex === -1) return [];
  const [minIndex, maxIndex] = [startIndex, endIndex].sort((a, b) => a - b);
  return array.slice(minIndex, maxIndex + 1);
}
__name(findValuesBetween, "findValuesBetween");
const isBrowser = typeof document !== "undefined";
function clamp$2(value, min2 = Number.NEGATIVE_INFINITY, max2 = Number.POSITIVE_INFINITY) {
  return Math.min(max2, Math.max(min2, value));
}
__name(clamp$2, "clamp$2");
function roundToStepPrecision(value, step) {
  let roundedValue = value;
  const stepString = step.toString();
  const pointIndex = stepString.indexOf(".");
  const precision = pointIndex >= 0 ? stepString.length - pointIndex : 0;
  if (precision > 0) {
    const pow = 10 ** precision;
    roundedValue = Math.round(roundedValue * pow) / pow;
  }
  return roundedValue;
}
__name(roundToStepPrecision, "roundToStepPrecision");
function snapValueToStep(value, min2, max2, step) {
  min2 = Number(min2);
  max2 = Number(max2);
  const remainder = (value - (Number.isNaN(min2) ? 0 : min2)) % step;
  let snappedValue = roundToStepPrecision(Math.abs(remainder) * 2 >= step ? value + Math.sign(remainder) * (step - Math.abs(remainder)) : value - remainder, step);
  if (!Number.isNaN(min2)) {
    if (snappedValue < min2) snappedValue = min2;
    else if (!Number.isNaN(max2) && snappedValue > max2) snappedValue = min2 + Math.floor(roundToStepPrecision((max2 - min2) / step, step)) * step;
  } else if (!Number.isNaN(max2) && snappedValue > max2) snappedValue = Math.floor(roundToStepPrecision(max2 / step, step)) * step;
  snappedValue = roundToStepPrecision(snappedValue, step);
  return snappedValue;
}
__name(snapValueToStep, "snapValueToStep");
function createContext(providerComponentName, contextName) {
  const symbolDescription = typeof providerComponentName === "string" && !contextName ? `${providerComponentName}Context` : contextName;
  const injectionKey = Symbol(symbolDescription);
  const injectContext = /* @__PURE__ */ __name((fallback) => {
    const context2 = inject(injectionKey, fallback);
    if (context2) return context2;
    if (context2 === null) return context2;
    throw new Error(`Injection \`${injectionKey.toString()}\` not found. Component must be used within ${Array.isArray(providerComponentName) ? `one of the following components: ${providerComponentName.join(", ")}` : `\`${providerComponentName}\``}`);
  }, "injectContext");
  const provideContext = /* @__PURE__ */ __name((contextValue) => {
    provide(injectionKey, contextValue);
    return contextValue;
  }, "provideContext");
  return [injectContext, provideContext];
}
__name(createContext, "createContext");
function getActiveElement() {
  let activeElement = document.activeElement;
  if (activeElement == null) return null;
  while (activeElement != null && activeElement.shadowRoot != null && activeElement.shadowRoot.activeElement != null) activeElement = activeElement.shadowRoot.activeElement;
  return activeElement;
}
__name(getActiveElement, "getActiveElement");
function handleAndDispatchCustomEvent$1(name, handler, detail) {
  const target = detail.originalEvent.target;
  const event = new CustomEvent(name, {
    bubbles: false,
    cancelable: true,
    detail
  });
  if (handler) target.addEventListener(name, handler, { once: true });
  target.dispatchEvent(event);
}
__name(handleAndDispatchCustomEvent$1, "handleAndDispatchCustomEvent$1");
function isNullish(value) {
  return value === null || value === void 0;
}
__name(isNullish, "isNullish");
function isValueEqualOrExist(base, current) {
  if (isNullish(base)) return false;
  if (Array.isArray(base)) return base.some((val) => isEqual(val, current));
  else return isEqual(base, current);
}
__name(isValueEqualOrExist, "isValueEqualOrExist");
function renderSlotFragments(children) {
  if (!children) return [];
  return children.flatMap((child) => {
    if (child.type === Fragment) return renderSlotFragments(child.children);
    return [child];
  });
}
__name(renderSlotFragments, "renderSlotFragments");
const ignoredElement = ["INPUT", "TEXTAREA"];
function useArrowNavigation(e, currentElement, parentElement, options = {}) {
  if (!currentElement || options.enableIgnoredElement && ignoredElement.includes(currentElement.nodeName)) return null;
  const { arrowKeyOptions = "both", attributeName = "[data-reka-collection-item]", itemsArray = [], loop = true, dir = "ltr", preventScroll = true, focus: focus2 = false } = options;
  const [right, left, up, down, home, end] = [
    e.key === "ArrowRight",
    e.key === "ArrowLeft",
    e.key === "ArrowUp",
    e.key === "ArrowDown",
    e.key === "Home",
    e.key === "End"
  ];
  const goingVertical = up || down;
  const goingHorizontal = right || left;
  if (!home && !end && (!goingVertical && !goingHorizontal || arrowKeyOptions === "vertical" && goingHorizontal || arrowKeyOptions === "horizontal" && goingVertical)) return null;
  const allCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(attributeName)) : itemsArray;
  if (!allCollectionItems.length) return null;
  if (preventScroll) e.preventDefault();
  let item = null;
  if (goingHorizontal || goingVertical) {
    const goForward = goingVertical ? down : dir === "ltr" ? right : left;
    item = findNextFocusableElement(allCollectionItems, currentElement, {
      goForward,
      loop
    });
  } else if (home) item = allCollectionItems.at(0) || null;
  else if (end) item = allCollectionItems.at(-1) || null;
  if (focus2) item?.focus();
  return item;
}
__name(useArrowNavigation, "useArrowNavigation");
function findNextFocusableElement(elements, currentElement, options, iterations = elements.length) {
  if (--iterations === 0) return null;
  const index = elements.indexOf(currentElement);
  const newIndex = options.goForward ? index + 1 : index - 1;
  if (!options.loop && (newIndex < 0 || newIndex >= elements.length)) return null;
  const adjustedNewIndex = (newIndex + elements.length) % elements.length;
  const candidate = elements[adjustedNewIndex];
  if (!candidate) return null;
  const isDisabled = candidate.hasAttribute("disabled") && candidate.getAttribute("disabled") !== "false";
  if (isDisabled) return findNextFocusableElement(elements, candidate, options, iterations);
  return candidate;
}
__name(findNextFocusableElement, "findNextFocusableElement");
const [injectConfigProviderContext, provideConfigProviderContext] = createContext("ConfigProvider");
var ConfigProvider_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
  inheritAttrs: false,
  __name: "ConfigProvider",
  props: {
    dir: {
      type: String,
      required: false,
      default: "ltr"
    },
    locale: {
      type: String,
      required: false,
      default: "en"
    },
    scrollBody: {
      type: [Boolean, Object],
      required: false,
      default: true
    },
    nonce: {
      type: String,
      required: false,
      default: void 0
    },
    useId: {
      type: Function,
      required: false,
      default: void 0
    }
  },
  setup(__props) {
    const props2 = __props;
    const { dir, locale, scrollBody, nonce } = toRefs$1(props2);
    provideConfigProviderContext({
      dir,
      locale,
      scrollBody,
      nonce,
      useId: props2.useId
    });
    return (_ctx, _cache) => {
      return renderSlot(_ctx.$slots, "default");
    };
  }
});
var ConfigProvider_default = ConfigProvider_vue_vue_type_script_setup_true_lang_default;
function computedEager(fn, options) {
  var _a;
  const result = shallowRef();
  watchEffect(() => {
    result.value = fn();
  }, {
    ...options,
    flush: (_a = options == null ? void 0 : options.flush) != null ? _a : "sync"
  });
  return readonly(result);
}
__name(computedEager, "computedEager");
function computedWithControl(source, fn) {
  let v = void 0;
  let track;
  let trigger;
  const dirty = shallowRef(true);
  const update = /* @__PURE__ */ __name(() => {
    dirty.value = true;
    trigger();
  }, "update");
  watch(source, update, { flush: "sync" });
  const get2 = typeof fn === "function" ? fn : fn.get;
  const set2 = typeof fn === "function" ? void 0 : fn.set;
  const result = customRef((_track, _trigger) => {
    track = _track;
    trigger = _trigger;
    return {
      get() {
        if (dirty.value) {
          v = get2(v);
          dirty.value = false;
        }
        track();
        return v;
      },
      set(v2) {
        set2 == null ? void 0 : set2(v2);
      }
    };
  });
  if (Object.isExtensible(result))
    result.trigger = update;
  return result;
}
__name(computedWithControl, "computedWithControl");
function tryOnScopeDispose(fn) {
  if (getCurrentScope()) {
    onScopeDispose(fn);
    return true;
  }
  return false;
}
__name(tryOnScopeDispose, "tryOnScopeDispose");
function createEventHook() {
  const fns = /* @__PURE__ */ new Set();
  const off = /* @__PURE__ */ __name((fn) => {
    fns.delete(fn);
  }, "off");
  const clear = /* @__PURE__ */ __name(() => {
    fns.clear();
  }, "clear");
  const on = /* @__PURE__ */ __name((fn) => {
    fns.add(fn);
    const offFn = /* @__PURE__ */ __name(() => off(fn), "offFn");
    tryOnScopeDispose(offFn);
    return {
      off: offFn
    };
  }, "on");
  const trigger = /* @__PURE__ */ __name((...args) => {
    return Promise.all(Array.from(fns).map((fn) => fn(...args)));
  }, "trigger");
  return {
    on,
    off,
    trigger,
    clear
  };
}
__name(createEventHook, "createEventHook");
function createGlobalState(stateFactory) {
  let initialized = false;
  let state;
  const scope = effectScope(true);
  return (...args) => {
    if (!initialized) {
      state = scope.run(() => stateFactory(...args));
      initialized = true;
    }
    return state;
  };
}
__name(createGlobalState, "createGlobalState");
const localProvidedStateMap = /* @__PURE__ */ new WeakMap();
const injectLocal = /* @__PURE__ */ __name((...args) => {
  var _a;
  const key = args[0];
  const instance = (_a = getCurrentInstance()) == null ? void 0 : _a.proxy;
  if (instance == null && !hasInjectionContext())
    throw new Error("injectLocal must be called in setup");
  if (instance && localProvidedStateMap.has(instance) && key in localProvidedStateMap.get(instance))
    return localProvidedStateMap.get(instance)[key];
  return inject(...args);
}, "injectLocal");
const provideLocal = /* @__PURE__ */ __name((key, value) => {
  var _a;
  const instance = (_a = getCurrentInstance()) == null ? void 0 : _a.proxy;
  if (instance == null)
    throw new Error("provideLocal must be called in setup");
  if (!localProvidedStateMap.has(instance))
    localProvidedStateMap.set(instance, /* @__PURE__ */ Object.create(null));
  const localProvidedState = localProvidedStateMap.get(instance);
  localProvidedState[key] = value;
  provide(key, value);
}, "provideLocal");
function createInjectionState(composable, options) {
  const key = (options == null ? void 0 : options.injectionKey) || Symbol(composable.name || "InjectionState");
  const defaultValue = options == null ? void 0 : options.defaultValue;
  const useProvidingState = /* @__PURE__ */ __name((...args) => {
    const state = composable(...args);
    provideLocal(key, state);
    return state;
  }, "useProvidingState");
  const useInjectedState = /* @__PURE__ */ __name(() => injectLocal(key, defaultValue), "useInjectedState");
  return [useProvidingState, useInjectedState];
}
__name(createInjectionState, "createInjectionState");
function createRef(value, deep) {
  if (deep === true) {
    return ref(value);
  } else {
    return shallowRef(value);
  }
}
__name(createRef, "createRef");
function createSharedComposable(composable) {
  let subscribers = 0;
  let state;
  let scope;
  const dispose = /* @__PURE__ */ __name(() => {
    subscribers -= 1;
    if (scope && subscribers <= 0) {
      scope.stop();
      state = void 0;
      scope = void 0;
    }
  }, "dispose");
  return (...args) => {
    subscribers += 1;
    if (!scope) {
      scope = effectScope(true);
      state = scope.run(() => composable(...args));
    }
    tryOnScopeDispose(dispose);
    return state;
  };
}
__name(createSharedComposable, "createSharedComposable");
function extendRef(ref2, extend, { enumerable = false, unwrap = true } = {}) {
  for (const [key, value] of Object.entries(extend)) {
    if (key === "value")
      continue;
    if (isRef(value) && unwrap) {
      Object.defineProperty(ref2, key, {
        get() {
          return value.value;
        },
        set(v) {
          value.value = v;
        },
        enumerable
      });
    } else {
      Object.defineProperty(ref2, key, { value, enumerable });
    }
  }
  return ref2;
}
__name(extendRef, "extendRef");
function get(obj, key) {
  if (key == null)
    return unref(obj);
  return unref(obj)[key];
}
__name(get, "get");
function isDefined(v) {
  return unref(v) != null;
}
__name(isDefined, "isDefined");
function makeDestructurable(obj, arr) {
  if (typeof Symbol !== "undefined") {
    const clone = { ...obj };
    Object.defineProperty(clone, Symbol.iterator, {
      enumerable: false,
      value() {
        let index = 0;
        return {
          next: /* @__PURE__ */ __name(() => ({
            value: arr[index++],
            done: index > arr.length
          }), "next")
        };
      }
    });
    return clone;
  } else {
    return Object.assign([...arr], obj);
  }
}
__name(makeDestructurable, "makeDestructurable");
function reactify(fn, options) {
  const unrefFn = (options == null ? void 0 : options.computedGetter) === false ? unref : toValue$2;
  return function(...args) {
    return computed(() => fn.apply(this, args.map((i) => unrefFn(i))));
  };
}
__name(reactify, "reactify");
function reactifyObject(obj, optionsOrKeys = {}) {
  let keys2 = [];
  let options;
  if (Array.isArray(optionsOrKeys)) {
    keys2 = optionsOrKeys;
  } else {
    options = optionsOrKeys;
    const { includeOwnProperties = true } = optionsOrKeys;
    keys2.push(...Object.keys(obj));
    if (includeOwnProperties)
      keys2.push(...Object.getOwnPropertyNames(obj));
  }
  return Object.fromEntries(
    keys2.map((key) => {
      const value = obj[key];
      return [
        key,
        typeof value === "function" ? reactify(value.bind(obj), options) : value
      ];
    })
  );
}
__name(reactifyObject, "reactifyObject");
function toReactive(objectRef) {
  if (!isRef(objectRef))
    return reactive(objectRef);
  const proxy = new Proxy({}, {
    get(_, p, receiver) {
      return unref(Reflect.get(objectRef.value, p, receiver));
    },
    set(_, p, value) {
      if (isRef(objectRef.value[p]) && !isRef(value))
        objectRef.value[p].value = value;
      else
        objectRef.value[p] = value;
      return true;
    },
    deleteProperty(_, p) {
      return Reflect.deleteProperty(objectRef.value, p);
    },
    has(_, p) {
      return Reflect.has(objectRef.value, p);
    },
    ownKeys() {
      return Object.keys(objectRef.value);
    },
    getOwnPropertyDescriptor() {
      return {
        enumerable: true,
        configurable: true
      };
    }
  });
  return reactive(proxy);
}
__name(toReactive, "toReactive");
function reactiveComputed(fn) {
  return toReactive(computed(fn));
}
__name(reactiveComputed, "reactiveComputed");
function reactiveOmit(obj, ...keys2) {
  const flatKeys = keys2.flat();
  const predicate = flatKeys[0];
  return reactiveComputed(() => typeof predicate === "function" ? Object.fromEntries(Object.entries(toRefs$1(obj)).filter(([k2, v]) => !predicate(toValue$2(v), k2))) : Object.fromEntries(Object.entries(toRefs$1(obj)).filter((e) => !flatKeys.includes(e[0]))));
}
__name(reactiveOmit, "reactiveOmit");
const isClient = typeof window !== "undefined" && typeof document !== "undefined";
const isWorker = typeof WorkerGlobalScope !== "undefined" && globalThis instanceof WorkerGlobalScope;
const isDef = /* @__PURE__ */ __name((val) => typeof val !== "undefined", "isDef");
const notNullish = /* @__PURE__ */ __name((val) => val != null, "notNullish");
const assert$1 = /* @__PURE__ */ __name((condition, ...infos) => {
  if (!condition)
    console.warn(...infos);
}, "assert$1");
const toString = Object.prototype.toString;
const isObject = /* @__PURE__ */ __name((val) => toString.call(val) === "[object Object]", "isObject");
const now = /* @__PURE__ */ __name(() => Date.now(), "now");
const timestamp = /* @__PURE__ */ __name(() => +Date.now(), "timestamp");
const clamp$1 = /* @__PURE__ */ __name((n, min2, max2) => Math.min(max2, Math.max(min2, n)), "clamp$1");
const noop = /* @__PURE__ */ __name(() => {
}, "noop");
const rand = /* @__PURE__ */ __name((min2, max2) => {
  min2 = Math.ceil(min2);
  max2 = Math.floor(max2);
  return Math.floor(Math.random() * (max2 - min2 + 1)) + min2;
}, "rand");
const hasOwn = /* @__PURE__ */ __name((val, key) => Object.prototype.hasOwnProperty.call(val, key), "hasOwn");
const isIOS = /* @__PURE__ */ getIsIOS();
function getIsIOS() {
  var _a, _b;
  return isClient && ((_a = window == null ? void 0 : window.navigator) == null ? void 0 : _a.userAgent) && (/iP(?:ad|hone|od)/.test(window.navigator.userAgent) || ((_b = window == null ? void 0 : window.navigator) == null ? void 0 : _b.maxTouchPoints) > 2 && /iPad|Macintosh/.test(window == null ? void 0 : window.navigator.userAgent));
}
__name(getIsIOS, "getIsIOS");
function createFilterWrapper(filter, fn) {
  function wrapper(...args) {
    return new Promise((resolve, reject) => {
      Promise.resolve(filter(() => fn.apply(this, args), { fn, thisArg: this, args })).then(resolve).catch(reject);
    });
  }
  __name(wrapper, "wrapper");
  return wrapper;
}
__name(createFilterWrapper, "createFilterWrapper");
const bypassFilter = /* @__PURE__ */ __name((invoke2) => {
  return invoke2();
}, "bypassFilter");
function debounceFilter(ms, options = {}) {
  let timer;
  let maxTimer;
  let lastRejector = noop;
  const _clearTimeout = /* @__PURE__ */ __name((timer2) => {
    clearTimeout(timer2);
    lastRejector();
    lastRejector = noop;
  }, "_clearTimeout");
  let lastInvoker;
  const filter = /* @__PURE__ */ __name((invoke2) => {
    const duration = toValue$2(ms);
    const maxDuration = toValue$2(options.maxWait);
    if (timer)
      _clearTimeout(timer);
    if (duration <= 0 || maxDuration !== void 0 && maxDuration <= 0) {
      if (maxTimer) {
        _clearTimeout(maxTimer);
        maxTimer = null;
      }
      return Promise.resolve(invoke2());
    }
    return new Promise((resolve, reject) => {
      lastRejector = options.rejectOnCancel ? reject : resolve;
      lastInvoker = invoke2;
      if (maxDuration && !maxTimer) {
        maxTimer = setTimeout(() => {
          if (timer)
            _clearTimeout(timer);
          maxTimer = null;
          resolve(lastInvoker());
        }, maxDuration);
      }
      timer = setTimeout(() => {
        if (maxTimer)
          _clearTimeout(maxTimer);
        maxTimer = null;
        resolve(invoke2());
      }, duration);
    });
  }, "filter");
  return filter;
}
__name(debounceFilter, "debounceFilter");
function throttleFilter(...args) {
  let lastExec = 0;
  let timer;
  let isLeading = true;
  let lastRejector = noop;
  let lastValue;
  let ms;
  let trailing;
  let leading;
  let rejectOnCancel;
  if (!isRef(args[0]) && typeof args[0] === "object")
    ({ delay: ms, trailing = true, leading = true, rejectOnCancel = false } = args[0]);
  else
    [ms, trailing = true, leading = true, rejectOnCancel = false] = args;
  const clear = /* @__PURE__ */ __name(() => {
    if (timer) {
      clearTimeout(timer);
      timer = void 0;
      lastRejector();
      lastRejector = noop;
    }
  }, "clear");
  const filter = /* @__PURE__ */ __name((_invoke) => {
    const duration = toValue$2(ms);
    const elapsed = Date.now() - lastExec;
    const invoke2 = /* @__PURE__ */ __name(() => {
      return lastValue = _invoke();
    }, "invoke");
    clear();
    if (duration <= 0) {
      lastExec = Date.now();
      return invoke2();
    }
    if (elapsed > duration && (leading || !isLeading)) {
      lastExec = Date.now();
      invoke2();
    } else if (trailing) {
      lastValue = new Promise((resolve, reject) => {
        lastRejector = rejectOnCancel ? reject : resolve;
        timer = setTimeout(() => {
          lastExec = Date.now();
          isLeading = true;
          resolve(invoke2());
          clear();
        }, Math.max(0, duration - elapsed));
      });
    }
    if (!leading && !timer)
      timer = setTimeout(() => isLeading = true, duration);
    isLeading = false;
    return lastValue;
  }, "filter");
  return filter;
}
__name(throttleFilter, "throttleFilter");
function pausableFilter(extendFilter = bypassFilter, options = {}) {
  const {
    initialState = "active"
  } = options;
  const isActive = toRef(initialState === "active");
  function pause() {
    isActive.value = false;
  }
  __name(pause, "pause");
  function resume() {
    isActive.value = true;
  }
  __name(resume, "resume");
  const eventFilter = /* @__PURE__ */ __name((...args) => {
    if (isActive.value)
      extendFilter(...args);
  }, "eventFilter");
  return { isActive: readonly(isActive), pause, resume, eventFilter };
}
__name(pausableFilter, "pausableFilter");
function cacheStringFunction(fn) {
  const cache = /* @__PURE__ */ Object.create(null);
  return (str) => {
    const hit = cache[str];
    return hit || (cache[str] = fn(str));
  };
}
__name(cacheStringFunction, "cacheStringFunction");
const hyphenateRE = /\B([A-Z])/g;
const hyphenate = cacheStringFunction((str) => str.replace(hyphenateRE, "-$1").toLowerCase());
const camelizeRE = /-(\w)/g;
const camelize = cacheStringFunction((str) => {
  return str.replace(camelizeRE, (_, c2) => c2 ? c2.toUpperCase() : "");
});
function promiseTimeout(ms, throwOnTimeout = false, reason = "Timeout") {
  return new Promise((resolve, reject) => {
    if (throwOnTimeout)
      setTimeout(() => reject(reason), ms);
    else
      setTimeout(resolve, ms);
  });
}
__name(promiseTimeout, "promiseTimeout");
function identity(arg) {
  return arg;
}
__name(identity, "identity");
function createSingletonPromise(fn) {
  let _promise;
  function wrapper() {
    if (!_promise)
      _promise = fn();
    return _promise;
  }
  __name(wrapper, "wrapper");
  wrapper.reset = async () => {
    const _prev = _promise;
    _promise = void 0;
    if (_prev)
      await _prev;
  };
  return wrapper;
}
__name(createSingletonPromise, "createSingletonPromise");
function invoke(fn) {
  return fn();
}
__name(invoke, "invoke");
function containsProp(obj, ...props2) {
  return props2.some((k2) => k2 in obj);
}
__name(containsProp, "containsProp");
function increaseWithUnit(target, delta) {
  var _a;
  if (typeof target === "number")
    return target + delta;
  const value = ((_a = target.match(/^-?\d+\.?\d*/)) == null ? void 0 : _a[0]) || "";
  const unit = target.slice(value.length);
  const result = Number.parseFloat(value) + delta;
  if (Number.isNaN(result))
    return target;
  return result + unit;
}
__name(increaseWithUnit, "increaseWithUnit");
function pxValue(px) {
  return px.endsWith("rem") ? Number.parseFloat(px) * 16 : Number.parseFloat(px);
}
__name(pxValue, "pxValue");
function objectPick(obj, keys2, omitUndefined = false) {
  return keys2.reduce((n, k2) => {
    if (k2 in obj) {
      if (!omitUndefined || obj[k2] !== void 0)
        n[k2] = obj[k2];
    }
    return n;
  }, {});
}
__name(objectPick, "objectPick");
function objectOmit(obj, keys2, omitUndefined = false) {
  return Object.fromEntries(Object.entries(obj).filter(([key, value]) => {
    return (!omitUndefined || value !== void 0) && !keys2.includes(key);
  }));
}
__name(objectOmit, "objectOmit");
function objectEntries(obj) {
  return Object.entries(obj);
}
__name(objectEntries, "objectEntries");
function getLifeCycleTarget(target) {
  return target || getCurrentInstance();
}
__name(getLifeCycleTarget, "getLifeCycleTarget");
function toArray(value) {
  return Array.isArray(value) ? value : [value];
}
__name(toArray, "toArray");
function toRef(...args) {
  if (args.length !== 1)
    return toRef$1(...args);
  const r2 = args[0];
  return typeof r2 === "function" ? readonly(customRef(() => ({ get: r2, set: noop }))) : ref(r2);
}
__name(toRef, "toRef");
const resolveRef = toRef;
function reactivePick(obj, ...keys2) {
  const flatKeys = keys2.flat();
  const predicate = flatKeys[0];
  return reactiveComputed(() => typeof predicate === "function" ? Object.fromEntries(Object.entries(toRefs$1(obj)).filter(([k2, v]) => predicate(toValue$2(v), k2))) : Object.fromEntries(flatKeys.map((k2) => [k2, toRef(obj, k2)])));
}
__name(reactivePick, "reactivePick");
function refAutoReset(defaultValue, afterMs = 1e4) {
  return customRef((track, trigger) => {
    let value = toValue$2(defaultValue);
    let timer;
    const resetAfter = /* @__PURE__ */ __name(() => setTimeout(() => {
      value = toValue$2(defaultValue);
      trigger();
    }, toValue$2(afterMs)), "resetAfter");
    tryOnScopeDispose(() => {
      clearTimeout(timer);
    });
    return {
      get() {
        track();
        return value;
      },
      set(newValue) {
        value = newValue;
        trigger();
        clearTimeout(timer);
        timer = resetAfter();
      }
    };
  });
}
__name(refAutoReset, "refAutoReset");
function useDebounceFn(fn, ms = 200, options = {}) {
  return createFilterWrapper(
    debounceFilter(ms, options),
    fn
  );
}
__name(useDebounceFn, "useDebounceFn");
function refDebounced(value, ms = 200, options = {}) {
  const debounced = ref(value.value);
  const updater = useDebounceFn(() => {
    debounced.value = value.value;
  }, ms, options);
  watch(value, () => updater());
  return debounced;
}
__name(refDebounced, "refDebounced");
function refDefault(source, defaultValue) {
  return computed({
    get() {
      var _a;
      return (_a = source.value) != null ? _a : defaultValue;
    },
    set(value) {
      source.value = value;
    }
  });
}
__name(refDefault, "refDefault");
function useThrottleFn(fn, ms = 200, trailing = false, leading = true, rejectOnCancel = false) {
  return createFilterWrapper(
    throttleFilter(ms, trailing, leading, rejectOnCancel),
    fn
  );
}
__name(useThrottleFn, "useThrottleFn");
function refThrottled(value, delay2 = 200, trailing = true, leading = true) {
  if (delay2 <= 0)
    return value;
  const throttled = ref(value.value);
  const updater = useThrottleFn(() => {
    throttled.value = value.value;
  }, delay2, trailing, leading);
  watch(value, () => updater());
  return throttled;
}
__name(refThrottled, "refThrottled");
function refWithControl(initial, options = {}) {
  let source = initial;
  let track;
  let trigger;
  const ref2 = customRef((_track, _trigger) => {
    track = _track;
    trigger = _trigger;
    return {
      get() {
        return get2();
      },
      set(v) {
        set2(v);
      }
    };
  });
  function get2(tracking = true) {
    if (tracking)
      track();
    return source;
  }
  __name(get2, "get");
  function set2(value, triggering = true) {
    var _a, _b;
    if (value === source)
      return;
    const old = source;
    if (((_a = options.onBeforeChange) == null ? void 0 : _a.call(options, value, old)) === false)
      return;
    source = value;
    (_b = options.onChanged) == null ? void 0 : _b.call(options, value, old);
    if (triggering)
      trigger();
  }
  __name(set2, "set");
  const untrackedGet = /* @__PURE__ */ __name(() => get2(false), "untrackedGet");
  const silentSet = /* @__PURE__ */ __name((v) => set2(v, false), "silentSet");
  const peek = /* @__PURE__ */ __name(() => get2(false), "peek");
  const lay = /* @__PURE__ */ __name((v) => set2(v, false), "lay");
  return extendRef(
    ref2,
    {
      get: get2,
      set: set2,
      untrackedGet,
      silentSet,
      peek,
      lay
    },
    { enumerable: true }
  );
}
__name(refWithControl, "refWithControl");
const controlledRef = refWithControl;
function set(...args) {
  if (args.length === 2) {
    const [ref2, value] = args;
    ref2.value = value;
  }
  if (args.length === 3) {
    const [target, key, value] = args;
    target[key] = value;
  }
}
__name(set, "set");
function watchWithFilter(source, cb, options = {}) {
  const {
    eventFilter = bypassFilter,
    ...watchOptions
  } = options;
  return watch(
    source,
    createFilterWrapper(
      eventFilter,
      cb
    ),
    watchOptions
  );
}
__name(watchWithFilter, "watchWithFilter");
function watchPausable(source, cb, options = {}) {
  const {
    eventFilter: filter,
    initialState = "active",
    ...watchOptions
  } = options;
  const { eventFilter, pause, resume, isActive } = pausableFilter(filter, { initialState });
  const stop = watchWithFilter(
    source,
    cb,
    {
      ...watchOptions,
      eventFilter
    }
  );
  return { stop, pause, resume, isActive };
}
__name(watchPausable, "watchPausable");
function syncRef(left, right, ...[options]) {
  const {
    flush = "sync",
    deep = false,
    immediate = true,
    direction = "both",
    transform: transform2 = {}
  } = options || {};
  const watchers = [];
  const transformLTR = "ltr" in transform2 && transform2.ltr || ((v) => v);
  const transformRTL = "rtl" in transform2 && transform2.rtl || ((v) => v);
  if (direction === "both" || direction === "ltr") {
    watchers.push(watchPausable(
      left,
      (newValue) => {
        watchers.forEach((w) => w.pause());
        right.value = transformLTR(newValue);
        watchers.forEach((w) => w.resume());
      },
      { flush, deep, immediate }
    ));
  }
  if (direction === "both" || direction === "rtl") {
    watchers.push(watchPausable(
      right,
      (newValue) => {
        watchers.forEach((w) => w.pause());
        left.value = transformRTL(newValue);
        watchers.forEach((w) => w.resume());
      },
      { flush, deep, immediate }
    ));
  }
  const stop = /* @__PURE__ */ __name(() => {
    watchers.forEach((w) => w.stop());
  }, "stop");
  return stop;
}
__name(syncRef, "syncRef");
function syncRefs(source, targets, options = {}) {
  const {
    flush = "sync",
    deep = false,
    immediate = true
  } = options;
  const targetsArray = toArray(targets);
  return watch(
    source,
    (newValue) => targetsArray.forEach((target) => target.value = newValue),
    { flush, deep, immediate }
  );
}
__name(syncRefs, "syncRefs");
function toRefs(objectRef, options = {}) {
  if (!isRef(objectRef))
    return toRefs$1(objectRef);
  const result = Array.isArray(objectRef.value) ? Array.from({ length: objectRef.value.length }) : {};
  for (const key in objectRef.value) {
    result[key] = customRef(() => ({
      get() {
        return objectRef.value[key];
      },
      set(v) {
        var _a;
        const replaceRef = (_a = toValue$2(options.replaceRef)) != null ? _a : true;
        if (replaceRef) {
          if (Array.isArray(objectRef.value)) {
            const copy = [...objectRef.value];
            copy[key] = v;
            objectRef.value = copy;
          } else {
            const newObject = { ...objectRef.value, [key]: v };
            Object.setPrototypeOf(newObject, Object.getPrototypeOf(objectRef.value));
            objectRef.value = newObject;
          }
        } else {
          objectRef.value[key] = v;
        }
      }
    }));
  }
  return result;
}
__name(toRefs, "toRefs");
const toValue$1 = toValue$2;
const resolveUnref = toValue$2;
function tryOnBeforeMount(fn, sync = true, target) {
  const instance = getLifeCycleTarget(target);
  if (instance)
    onBeforeMount(fn, target);
  else if (sync)
    fn();
  else
    nextTick(fn);
}
__name(tryOnBeforeMount, "tryOnBeforeMount");
function tryOnBeforeUnmount(fn, target) {
  const instance = getLifeCycleTarget(target);
  if (instance)
    onBeforeUnmount(fn, target);
}
__name(tryOnBeforeUnmount, "tryOnBeforeUnmount");
function tryOnMounted(fn, sync = true, target) {
  const instance = getLifeCycleTarget();
  if (instance)
    onMounted(fn, target);
  else if (sync)
    fn();
  else
    nextTick(fn);
}
__name(tryOnMounted, "tryOnMounted");
function tryOnUnmounted(fn, target) {
  const instance = getLifeCycleTarget(target);
  if (instance)
    onUnmounted(fn, target);
}
__name(tryOnUnmounted, "tryOnUnmounted");
function createUntil(r2, isNot = false) {
  function toMatch(condition, { flush = "sync", deep = false, timeout: timeout2, throwOnTimeout } = {}) {
    let stop = null;
    const watcher = new Promise((resolve) => {
      stop = watch(
        r2,
        (v) => {
          if (condition(v) !== isNot) {
            if (stop)
              stop();
            else
              nextTick(() => stop == null ? void 0 : stop());
            resolve(v);
          }
        },
        {
          flush,
          deep,
          immediate: true
        }
      );
    });
    const promises = [watcher];
    if (timeout2 != null) {
      promises.push(
        promiseTimeout(timeout2, throwOnTimeout).then(() => toValue$2(r2)).finally(() => stop == null ? void 0 : stop())
      );
    }
    return Promise.race(promises);
  }
  __name(toMatch, "toMatch");
  function toBe(value, options) {
    if (!isRef(value))
      return toMatch((v) => v === value, options);
    const { flush = "sync", deep = false, timeout: timeout2, throwOnTimeout } = options != null ? options : {};
    let stop = null;
    const watcher = new Promise((resolve) => {
      stop = watch(
        [r2, value],
        ([v1, v2]) => {
          if (isNot !== (v1 === v2)) {
            if (stop)
              stop();
            else
              nextTick(() => stop == null ? void 0 : stop());
            resolve(v1);
          }
        },
        {
          flush,
          deep,
          immediate: true
        }
      );
    });
    const promises = [watcher];
    if (timeout2 != null) {
      promises.push(
        promiseTimeout(timeout2, throwOnTimeout).then(() => toValue$2(r2)).finally(() => {
          stop == null ? void 0 : stop();
          return toValue$2(r2);
        })
      );
    }
    return Promise.race(promises);
  }
  __name(toBe, "toBe");
  function toBeTruthy(options) {
    return toMatch((v) => Boolean(v), options);
  }
  __name(toBeTruthy, "toBeTruthy");
  function toBeNull(options) {
    return toBe(null, options);
  }
  __name(toBeNull, "toBeNull");
  function toBeUndefined(options) {
    return toBe(void 0, options);
  }
  __name(toBeUndefined, "toBeUndefined");
  function toBeNaN(options) {
    return toMatch(Number.isNaN, options);
  }
  __name(toBeNaN, "toBeNaN");
  function toContains(value, options) {
    return toMatch((v) => {
      const array = Array.from(v);
      return array.includes(value) || array.includes(toValue$2(value));
    }, options);
  }
  __name(toContains, "toContains");
  function changed(options) {
    return changedTimes(1, options);
  }
  __name(changed, "changed");
  function changedTimes(n = 1, options) {
    let count2 = -1;
    return toMatch(() => {
      count2 += 1;
      return count2 >= n;
    }, options);
  }
  __name(changedTimes, "changedTimes");
  if (Array.isArray(toValue$2(r2))) {
    const instance = {
      toMatch,
      toContains,
      changed,
      changedTimes,
      get not() {
        return createUntil(r2, !isNot);
      }
    };
    return instance;
  } else {
    const instance = {
      toMatch,
      toBe,
      toBeTruthy,
      toBeNull,
      toBeNaN,
      toBeUndefined,
      changed,
      changedTimes,
      get not() {
        return createUntil(r2, !isNot);
      }
    };
    return instance;
  }
}
__name(createUntil, "createUntil");
function until(r2) {
  return createUntil(r2);
}
__name(until, "until");
function defaultComparator(value, othVal) {
  return value === othVal;
}
__name(defaultComparator, "defaultComparator");
function useArrayDifference(...args) {
  var _a, _b;
  const list = args[0];
  const values = args[1];
  let compareFn = (_a = args[2]) != null ? _a : defaultComparator;
  const {
    symmetric = false
  } = (_b = args[3]) != null ? _b : {};
  if (typeof compareFn === "string") {
    const key = compareFn;
    compareFn = /* @__PURE__ */ __name((value, othVal) => value[key] === othVal[key], "compareFn");
  }
  const diff1 = computed(() => toValue$2(list).filter((x) => toValue$2(values).findIndex((y) => compareFn(x, y)) === -1));
  if (symmetric) {
    const diff2 = computed(() => toValue$2(values).filter((x) => toValue$2(list).findIndex((y) => compareFn(x, y)) === -1));
    return computed(() => symmetric ? [...toValue$2(diff1), ...toValue$2(diff2)] : toValue$2(diff1));
  } else {
    return diff1;
  }
}
__name(useArrayDifference, "useArrayDifference");
function useArrayEvery(list, fn) {
  return computed(() => toValue$2(list).every((element, index, array) => fn(toValue$2(element), index, array)));
}
__name(useArrayEvery, "useArrayEvery");
function useArrayFilter(list, fn) {
  return computed(() => toValue$2(list).map((i) => toValue$2(i)).filter(fn));
}
__name(useArrayFilter, "useArrayFilter");
function useArrayFind(list, fn) {
  return computed(() => toValue$2(
    toValue$2(list).find((element, index, array) => fn(toValue$2(element), index, array))
  ));
}
__name(useArrayFind, "useArrayFind");
function useArrayFindIndex(list, fn) {
  return computed(() => toValue$2(list).findIndex((element, index, array) => fn(toValue$2(element), index, array)));
}
__name(useArrayFindIndex, "useArrayFindIndex");
function findLast(arr, cb) {
  let index = arr.length;
  while (index-- > 0) {
    if (cb(arr[index], index, arr))
      return arr[index];
  }
  return void 0;
}
__name(findLast, "findLast");
function useArrayFindLast(list, fn) {
  return computed(() => toValue$2(
    !Array.prototype.findLast ? findLast(toValue$2(list), (element, index, array) => fn(toValue$2(element), index, array)) : toValue$2(list).findLast((element, index, array) => fn(toValue$2(element), index, array))
  ));
}
__name(useArrayFindLast, "useArrayFindLast");
function isArrayIncludesOptions(obj) {
  return isObject(obj) && containsProp(obj, "formIndex", "comparator");
}
__name(isArrayIncludesOptions, "isArrayIncludesOptions");
function useArrayIncludes(...args) {
  var _a;
  const list = args[0];
  const value = args[1];
  let comparator = args[2];
  let formIndex = 0;
  if (isArrayIncludesOptions(comparator)) {
    formIndex = (_a = comparator.fromIndex) != null ? _a : 0;
    comparator = comparator.comparator;
  }
  if (typeof comparator === "string") {
    const key = comparator;
    comparator = /* @__PURE__ */ __name((element, value2) => element[key] === toValue$2(value2), "comparator");
  }
  comparator = comparator != null ? comparator : (element, value2) => element === toValue$2(value2);
  return computed(() => toValue$2(list).slice(formIndex).some((element, index, array) => comparator(
    toValue$2(element),
    toValue$2(value),
    index,
    toValue$2(array)
  )));
}
__name(useArrayIncludes, "useArrayIncludes");
function useArrayJoin(list, separator) {
  return computed(() => toValue$2(list).map((i) => toValue$2(i)).join(toValue$2(separator)));
}
__name(useArrayJoin, "useArrayJoin");
function useArrayMap(list, fn) {
  return computed(() => toValue$2(list).map((i) => toValue$2(i)).map(fn));
}
__name(useArrayMap, "useArrayMap");
function useArrayReduce(list, reducer, ...args) {
  const reduceCallback = /* @__PURE__ */ __name((sum, value, index) => reducer(toValue$2(sum), toValue$2(value), index), "reduceCallback");
  return computed(() => {
    const resolved = toValue$2(list);
    return args.length ? resolved.reduce(reduceCallback, typeof args[0] === "function" ? toValue$2(args[0]()) : toValue$2(args[0])) : resolved.reduce(reduceCallback);
  });
}
__name(useArrayReduce, "useArrayReduce");
function useArraySome(list, fn) {
  return computed(() => toValue$2(list).some((element, index, array) => fn(toValue$2(element), index, array)));
}
__name(useArraySome, "useArraySome");
function uniq(array) {
  return Array.from(new Set(array));
}
__name(uniq, "uniq");
function uniqueElementsBy(array, fn) {
  return array.reduce((acc, v) => {
    if (!acc.some((x) => fn(v, x, array)))
      acc.push(v);
    return acc;
  }, []);
}
__name(uniqueElementsBy, "uniqueElementsBy");
function useArrayUnique(list, compareFn) {
  return computed(() => {
    const resolvedList = toValue$2(list).map((element) => toValue$2(element));
    return compareFn ? uniqueElementsBy(resolvedList, compareFn) : uniq(resolvedList);
  });
}
__name(useArrayUnique, "useArrayUnique");
function useCounter(initialValue = 0, options = {}) {
  let _initialValue = unref(initialValue);
  const count2 = shallowRef(initialValue);
  const {
    max: max2 = Number.POSITIVE_INFINITY,
    min: min2 = Number.NEGATIVE_INFINITY
  } = options;
  const inc = /* @__PURE__ */ __name((delta = 1) => count2.value = Math.max(Math.min(max2, count2.value + delta), min2), "inc");
  const dec = /* @__PURE__ */ __name((delta = 1) => count2.value = Math.min(Math.max(min2, count2.value - delta), max2), "dec");
  const get2 = /* @__PURE__ */ __name(() => count2.value, "get");
  const set2 = /* @__PURE__ */ __name((val) => count2.value = Math.max(min2, Math.min(max2, val)), "set");
  const reset = /* @__PURE__ */ __name((val = _initialValue) => {
    _initialValue = val;
    return set2(val);
  }, "reset");
  return { count: count2, inc, dec, get: get2, set: set2, reset };
}
__name(useCounter, "useCounter");
const REGEX_PARSE = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[T\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/i;
const REGEX_FORMAT = /[YMDHhms]o|\[([^\]]+)\]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a{1,2}|A{1,2}|m{1,2}|s{1,2}|Z{1,2}|z{1,4}|SSS/g;
function defaultMeridiem(hours, minutes, isLowercase, hasPeriod) {
  let m = hours < 12 ? "AM" : "PM";
  if (hasPeriod)
    m = m.split("").reduce((acc, curr) => acc += `${curr}.`, "");
  return isLowercase ? m.toLowerCase() : m;
}
__name(defaultMeridiem, "defaultMeridiem");
function formatOrdinal(num) {
  const suffixes = ["th", "st", "nd", "rd"];
  const v = num % 100;
  return num + (suffixes[(v - 20) % 10] || suffixes[v] || suffixes[0]);
}
__name(formatOrdinal, "formatOrdinal");
function formatDate(date, formatStr, options = {}) {
  var _a;
  const years = date.getFullYear();
  const month = date.getMonth();
  const days = date.getDate();
  const hours = date.getHours();
  const minutes = date.getMinutes();
  const seconds = date.getSeconds();
  const milliseconds = date.getMilliseconds();
  const day = date.getDay();
  const meridiem = (_a = options.customMeridiem) != null ? _a : defaultMeridiem;
  const stripTimeZone = /* @__PURE__ */ __name((dateString) => {
    var _a2;
    return (_a2 = dateString.split(" ")[1]) != null ? _a2 : "";
  }, "stripTimeZone");
  const matches = {
    Yo: /* @__PURE__ */ __name(() => formatOrdinal(years), "Yo"),
    YY: /* @__PURE__ */ __name(() => String(years).slice(-2), "YY"),
    YYYY: /* @__PURE__ */ __name(() => years, "YYYY"),
    M: /* @__PURE__ */ __name(() => month + 1, "M"),
    Mo: /* @__PURE__ */ __name(() => formatOrdinal(month + 1), "Mo"),
    MM: /* @__PURE__ */ __name(() => `${month + 1}`.padStart(2, "0"), "MM"),
    MMM: /* @__PURE__ */ __name(() => date.toLocaleDateString(toValue$2(options.locales), { month: "short" }), "MMM"),
    MMMM: /* @__PURE__ */ __name(() => date.toLocaleDateString(toValue$2(options.locales), { month: "long" }), "MMMM"),
    D: /* @__PURE__ */ __name(() => String(days), "D"),
    Do: /* @__PURE__ */ __name(() => formatOrdinal(days), "Do"),
    DD: /* @__PURE__ */ __name(() => `${days}`.padStart(2, "0"), "DD"),
    H: /* @__PURE__ */ __name(() => String(hours), "H"),
    Ho: /* @__PURE__ */ __name(() => formatOrdinal(hours), "Ho"),
    HH: /* @__PURE__ */ __name(() => `${hours}`.padStart(2, "0"), "HH"),
    h: /* @__PURE__ */ __name(() => `${hours % 12 || 12}`.padStart(1, "0"), "h"),
    ho: /* @__PURE__ */ __name(() => formatOrdinal(hours % 12 || 12), "ho"),
    hh: /* @__PURE__ */ __name(() => `${hours % 12 || 12}`.padStart(2, "0"), "hh"),
    m: /* @__PURE__ */ __name(() => String(minutes), "m"),
    mo: /* @__PURE__ */ __name(() => formatOrdinal(minutes), "mo"),
    mm: /* @__PURE__ */ __name(() => `${minutes}`.padStart(2, "0"), "mm"),
    s: /* @__PURE__ */ __name(() => String(seconds), "s"),
    so: /* @__PURE__ */ __name(() => formatOrdinal(seconds), "so"),
    ss: /* @__PURE__ */ __name(() => `${seconds}`.padStart(2, "0"), "ss"),
    SSS: /* @__PURE__ */ __name(() => `${milliseconds}`.padStart(3, "0"), "SSS"),
    d: /* @__PURE__ */ __name(() => day, "d"),
    dd: /* @__PURE__ */ __name(() => date.toLocaleDateString(toValue$2(options.locales), { weekday: "narrow" }), "dd"),
    ddd: /* @__PURE__ */ __name(() => date.toLocaleDateString(toValue$2(options.locales), { weekday: "short" }), "ddd"),
    dddd: /* @__PURE__ */ __name(() => date.toLocaleDateString(toValue$2(options.locales), { weekday: "long" }), "dddd"),
    A: /* @__PURE__ */ __name(() => meridiem(hours, minutes), "A"),
    AA: /* @__PURE__ */ __name(() => meridiem(hours, minutes, false, true), "AA"),
    a: /* @__PURE__ */ __name(() => meridiem(hours, minutes, true), "a"),
    aa: /* @__PURE__ */ __name(() => meridiem(hours, minutes, true, true), "aa"),
    z: /* @__PURE__ */ __name(() => stripTimeZone(date.toLocaleDateString(toValue$2(options.locales), { timeZoneName: "shortOffset" })), "z"),
    zz: /* @__PURE__ */ __name(() => stripTimeZone(date.toLocaleDateString(toValue$2(options.locales), { timeZoneName: "shortOffset" })), "zz"),
    zzz: /* @__PURE__ */ __name(() => stripTimeZone(date.toLocaleDateString(toValue$2(options.locales), { timeZoneName: "shortOffset" })), "zzz"),
    zzzz: /* @__PURE__ */ __name(() => stripTimeZone(date.toLocaleDateString(toValue$2(options.locales), { timeZoneName: "longOffset" })), "zzzz")
  };
  return formatStr.replace(REGEX_FORMAT, (match, $1) => {
    var _a2, _b;
    return (_b = $1 != null ? $1 : (_a2 = matches[match]) == null ? void 0 : _a2.call(matches)) != null ? _b : match;
  });
}
__name(formatDate, "formatDate");
function normalizeDate(date) {
  if (date === null)
    return new Date(Number.NaN);
  if (date === void 0)
    return /* @__PURE__ */ new Date();
  if (date instanceof Date)
    return new Date(date);
  if (typeof date === "string" && !/Z$/i.test(date)) {
    const d = date.match(REGEX_PARSE);
    if (d) {
      const m = d[2] - 1 || 0;
      const ms = (d[7] || "0").substring(0, 3);
      return new Date(d[1], m, d[3] || 1, d[4] || 0, d[5] || 0, d[6] || 0, ms);
    }
  }
  return new Date(date);
}
__name(normalizeDate, "normalizeDate");
function useDateFormat(date, formatStr = "HH:mm:ss", options = {}) {
  return computed(() => formatDate(normalizeDate(toValue$2(date)), toValue$2(formatStr), options));
}
__name(useDateFormat, "useDateFormat");
function useIntervalFn(cb, interval = 1e3, options = {}) {
  const {
    immediate = true,
    immediateCallback = false
  } = options;
  let timer = null;
  const isActive = shallowRef(false);
  function clean() {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  }
  __name(clean, "clean");
  function pause() {
    isActive.value = false;
    clean();
  }
  __name(pause, "pause");
  function resume() {
    const intervalValue = toValue$2(interval);
    if (intervalValue <= 0)
      return;
    isActive.value = true;
    if (immediateCallback)
      cb();
    clean();
    if (isActive.value)
      timer = setInterval(cb, intervalValue);
  }
  __name(resume, "resume");
  if (immediate && isClient)
    resume();
  if (isRef(interval) || typeof interval === "function") {
    const stopWatch = watch(interval, () => {
      if (isActive.value && isClient)
        resume();
    });
    tryOnScopeDispose(stopWatch);
  }
  tryOnScopeDispose(pause);
  return {
    isActive,
    pause,
    resume
  };
}
__name(useIntervalFn, "useIntervalFn");
function useInterval(interval = 1e3, options = {}) {
  const {
    controls: exposeControls = false,
    immediate = true,
    callback
  } = options;
  const counter = shallowRef(0);
  const update = /* @__PURE__ */ __name(() => counter.value += 1, "update");
  const reset = /* @__PURE__ */ __name(() => {
    counter.value = 0;
  }, "reset");
  const controls = useIntervalFn(
    callback ? () => {
      update();
      callback(counter.value);
    } : update,
    interval,
    { immediate }
  );
  if (exposeControls) {
    return {
      counter,
      reset,
      ...controls
    };
  } else {
    return counter;
  }
}
__name(useInterval, "useInterval");
function useLastChanged(source, options = {}) {
  var _a;
  const ms = shallowRef((_a = options.initialValue) != null ? _a : null);
  watch(
    source,
    () => ms.value = timestamp(),
    options
  );
  return ms;
}
__name(useLastChanged, "useLastChanged");
function useTimeoutFn(cb, interval, options = {}) {
  const {
    immediate = true,
    immediateCallback = false
  } = options;
  const isPending = shallowRef(false);
  let timer = null;
  function clear() {
    if (timer) {
      clearTimeout(timer);
      timer = null;
    }
  }
  __name(clear, "clear");
  function stop() {
    isPending.value = false;
    clear();
  }
  __name(stop, "stop");
  function start(...args) {
    if (immediateCallback)
      cb();
    clear();
    isPending.value = true;
    timer = setTimeout(() => {
      isPending.value = false;
      timer = null;
      cb(...args);
    }, toValue$2(interval));
  }
  __name(start, "start");
  if (immediate) {
    isPending.value = true;
    if (isClient)
      start();
  }
  tryOnScopeDispose(stop);
  return {
    isPending: readonly(isPending),
    start,
    stop
  };
}
__name(useTimeoutFn, "useTimeoutFn");
function useTimeout(interval = 1e3, options = {}) {
  const {
    controls: exposeControls = false,
    callback
  } = options;
  const controls = useTimeoutFn(
    callback != null ? callback : noop,
    interval,
    options
  );
  const ready = computed(() => !controls.isPending.value);
  if (exposeControls) {
    return {
      ready,
      ...controls
    };
  } else {
    return ready;
  }
}
__name(useTimeout, "useTimeout");
function useToNumber(value, options = {}) {
  const {
    method = "parseFloat",
    radix,
    nanToZero
  } = options;
  return computed(() => {
    let resolved = toValue$2(value);
    if (typeof method === "function")
      resolved = method(resolved);
    else if (typeof resolved === "string")
      resolved = Number[method](resolved, radix);
    if (nanToZero && Number.isNaN(resolved))
      resolved = 0;
    return resolved;
  });
}
__name(useToNumber, "useToNumber");
function useToString(value) {
  return computed(() => `${toValue$2(value)}`);
}
__name(useToString, "useToString");
function useToggle(initialValue = false, options = {}) {
  const {
    truthyValue = true,
    falsyValue = false
  } = options;
  const valueIsRef = isRef(initialValue);
  const _value = shallowRef(initialValue);
  function toggle(value) {
    if (arguments.length) {
      _value.value = value;
      return _value.value;
    } else {
      const truthy = toValue$2(truthyValue);
      _value.value = _value.value === truthy ? toValue$2(falsyValue) : truthy;
      return _value.value;
    }
  }
  __name(toggle, "toggle");
  if (valueIsRef)
    return toggle;
  else
    return [_value, toggle];
}
__name(useToggle, "useToggle");
function watchArray(source, cb, options) {
  let oldList = (options == null ? void 0 : options.immediate) ? [] : [...typeof source === "function" ? source() : Array.isArray(source) ? source : toValue$2(source)];
  return watch(source, (newList, _, onCleanup) => {
    const oldListRemains = Array.from({ length: oldList.length });
    const added = [];
    for (const obj of newList) {
      let found = false;
      for (let i = 0; i < oldList.length; i++) {
        if (!oldListRemains[i] && obj === oldList[i]) {
          oldListRemains[i] = true;
          found = true;
          break;
        }
      }
      if (!found)
        added.push(obj);
    }
    const removed = oldList.filter((_2, i) => !oldListRemains[i]);
    cb(newList, oldList, added, removed, onCleanup);
    oldList = [...newList];
  }, options);
}
__name(watchArray, "watchArray");
function watchAtMost(source, cb, options) {
  const {
    count: count2,
    ...watchOptions
  } = options;
  const current = shallowRef(0);
  const stop = watchWithFilter(
    source,
    (...args) => {
      current.value += 1;
      if (current.value >= toValue$2(count2))
        nextTick(() => stop());
      cb(...args);
    },
    watchOptions
  );
  return { count: current, stop };
}
__name(watchAtMost, "watchAtMost");
function watchDebounced(source, cb, options = {}) {
  const {
    debounce: debounce2 = 0,
    maxWait = void 0,
    ...watchOptions
  } = options;
  return watchWithFilter(
    source,
    cb,
    {
      ...watchOptions,
      eventFilter: debounceFilter(debounce2, { maxWait })
    }
  );
}
__name(watchDebounced, "watchDebounced");
function watchDeep(source, cb, options) {
  return watch(
    source,
    cb,
    {
      ...options,
      deep: true
    }
  );
}
__name(watchDeep, "watchDeep");
function watchIgnorable(source, cb, options = {}) {
  const {
    eventFilter = bypassFilter,
    ...watchOptions
  } = options;
  const filteredCb = createFilterWrapper(
    eventFilter,
    cb
  );
  let ignoreUpdates;
  let ignorePrevAsyncUpdates;
  let stop;
  if (watchOptions.flush === "sync") {
    const ignore = shallowRef(false);
    ignorePrevAsyncUpdates = /* @__PURE__ */ __name(() => {
    }, "ignorePrevAsyncUpdates");
    ignoreUpdates = /* @__PURE__ */ __name((updater) => {
      ignore.value = true;
      updater();
      ignore.value = false;
    }, "ignoreUpdates");
    stop = watch(
      source,
      (...args) => {
        if (!ignore.value)
          filteredCb(...args);
      },
      watchOptions
    );
  } else {
    const disposables = [];
    const ignoreCounter = shallowRef(0);
    const syncCounter = shallowRef(0);
    ignorePrevAsyncUpdates = /* @__PURE__ */ __name(() => {
      ignoreCounter.value = syncCounter.value;
    }, "ignorePrevAsyncUpdates");
    disposables.push(
      watch(
        source,
        () => {
          syncCounter.value++;
        },
        { ...watchOptions, flush: "sync" }
      )
    );
    ignoreUpdates = /* @__PURE__ */ __name((updater) => {
      const syncCounterPrev = syncCounter.value;
      updater();
      ignoreCounter.value += syncCounter.value - syncCounterPrev;
    }, "ignoreUpdates");
    disposables.push(
      watch(
        source,
        (...args) => {
          const ignore = ignoreCounter.value > 0 && ignoreCounter.value === syncCounter.value;
          ignoreCounter.value = 0;
          syncCounter.value = 0;
          if (ignore)
            return;
          filteredCb(...args);
        },
        watchOptions
      )
    );
    stop = /* @__PURE__ */ __name(() => {
      disposables.forEach((fn) => fn());
    }, "stop");
  }
  return { stop, ignoreUpdates, ignorePrevAsyncUpdates };
}
__name(watchIgnorable, "watchIgnorable");
function watchImmediate(source, cb, options) {
  return watch(
    source,
    cb,
    {
      ...options,
      immediate: true
    }
  );
}
__name(watchImmediate, "watchImmediate");
function watchOnce(source, cb, options) {
  const stop = watch(source, (...args) => {
    nextTick(() => stop());
    return cb(...args);
  }, options);
  return stop;
}
__name(watchOnce, "watchOnce");
function watchThrottled(source, cb, options = {}) {
  const {
    throttle: throttle2 = 0,
    trailing = true,
    leading = true,
    ...watchOptions
  } = options;
  return watchWithFilter(
    source,
    cb,
    {
      ...watchOptions,
      eventFilter: throttleFilter(throttle2, trailing, leading)
    }
  );
}
__name(watchThrottled, "watchThrottled");
function watchTriggerable(source, cb, options = {}) {
  let cleanupFn;
  function onEffect() {
    if (!cleanupFn)
      return;
    const fn = cleanupFn;
    cleanupFn = void 0;
    fn();
  }
  __name(onEffect, "onEffect");
  function onCleanup(callback) {
    cleanupFn = callback;
  }
  __name(onCleanup, "onCleanup");
  const _cb = /* @__PURE__ */ __name((value, oldValue) => {
    onEffect();
    return cb(value, oldValue, onCleanup);
  }, "_cb");
  const res = watchIgnorable(source, _cb, options);
  const { ignoreUpdates } = res;
  const trigger = /* @__PURE__ */ __name(() => {
    let res2;
    ignoreUpdates(() => {
      res2 = _cb(getWatchSources(source), getOldValue(source));
    });
    return res2;
  }, "trigger");
  return {
    ...res,
    trigger
  };
}
__name(watchTriggerable, "watchTriggerable");
function getWatchSources(sources) {
  if (isReactive(sources))
    return sources;
  if (Array.isArray(sources))
    return sources.map((item) => toValue$2(item));
  return toValue$2(sources);
}
__name(getWatchSources, "getWatchSources");
function getOldValue(source) {
  return Array.isArray(source) ? source.map(() => void 0) : void 0;
}
__name(getOldValue, "getOldValue");
function whenever(source, cb, options) {
  const stop = watch(
    source,
    (v, ov, onInvalidate) => {
      if (v) {
        if (options == null ? void 0 : options.once)
          nextTick(() => stop());
        cb(v, ov, onInvalidate);
      }
    },
    {
      ...options,
      once: false
    }
  );
  return stop;
}
__name(whenever, "whenever");
function computedAsync(evaluationCallback, initialState, optionsOrRef) {
  let options;
  if (isRef(optionsOrRef)) {
    options = {
      evaluating: optionsOrRef
    };
  } else {
    options = optionsOrRef || {};
  }
  const {
    lazy = false,
    evaluating = void 0,
    shallow = true,
    onError = noop
  } = options;
  const started = shallowRef(!lazy);
  const current = shallow ? shallowRef(initialState) : ref(initialState);
  let counter = 0;
  watchEffect(async (onInvalidate) => {
    if (!started.value)
      return;
    counter++;
    const counterAtBeginning = counter;
    let hasFinished = false;
    if (evaluating) {
      Promise.resolve().then(() => {
        evaluating.value = true;
      });
    }
    try {
      const result = await evaluationCallback((cancelCallback) => {
        onInvalidate(() => {
          if (evaluating)
            evaluating.value = false;
          if (!hasFinished)
            cancelCallback();
        });
      });
      if (counterAtBeginning === counter)
        current.value = result;
    } catch (e) {
      onError(e);
    } finally {
      if (evaluating && counterAtBeginning === counter)
        evaluating.value = false;
      hasFinished = true;
    }
  });
  if (lazy) {
    return computed(() => {
      started.value = true;
      return current.value;
    });
  } else {
    return current;
  }
}
__name(computedAsync, "computedAsync");
function computedInject(key, options, defaultSource, treatDefaultAsFactory) {
  let source = inject(key);
  if (defaultSource)
    source = inject(key, defaultSource);
  if (treatDefaultAsFactory)
    source = inject(key, defaultSource, treatDefaultAsFactory);
  if (typeof options === "function") {
    return computed((ctx) => options(source, ctx));
  } else {
    return computed({
      get: /* @__PURE__ */ __name((ctx) => options.get(source, ctx), "get"),
      set: options.set
    });
  }
}
__name(computedInject, "computedInject");
function createReusableTemplate(options = {}) {
  const {
    inheritAttrs = true
  } = options;
  const render2 = shallowRef();
  const define = /* @__PURE__ */ defineComponent({
    setup(_, { slots }) {
      return () => {
        render2.value = slots.default;
      };
    }
  });
  const reuse = /* @__PURE__ */ defineComponent({
    inheritAttrs,
    props: options.props,
    setup(props2, { attrs, slots }) {
      return () => {
        var _a;
        if (!render2.value && false)
          throw new Error("[VueUse] Failed to find the definition of reusable template");
        const vnode = (_a = render2.value) == null ? void 0 : _a.call(render2, {
          ...options.props == null ? keysToCamelKebabCase(attrs) : props2,
          $slots: slots
        });
        return inheritAttrs && (vnode == null ? void 0 : vnode.length) === 1 ? vnode[0] : vnode;
      };
    }
  });
  return makeDestructurable(
    { define, reuse },
    [define, reuse]
  );
}
__name(createReusableTemplate, "createReusableTemplate");
function keysToCamelKebabCase(obj) {
  const newObj = {};
  for (const key in obj)
    newObj[camelize(key)] = obj[key];
  return newObj;
}
__name(keysToCamelKebabCase, "keysToCamelKebabCase");
function createTemplatePromise(options = {}) {
  let index = 0;
  const instances = ref([]);
  function create(...args) {
    const props2 = shallowReactive({
      key: index++,
      args,
      promise: void 0,
      resolve: /* @__PURE__ */ __name(() => {
      }, "resolve"),
      reject: /* @__PURE__ */ __name(() => {
      }, "reject"),
      isResolving: false,
      options
    });
    instances.value.push(props2);
    props2.promise = new Promise((_resolve, _reject) => {
      props2.resolve = (v) => {
        props2.isResolving = true;
        return _resolve(v);
      };
      props2.reject = _reject;
    }).finally(() => {
      props2.promise = void 0;
      const index2 = instances.value.indexOf(props2);
      if (index2 !== -1)
        instances.value.splice(index2, 1);
    });
    return props2.promise;
  }
  __name(create, "create");
  function start(...args) {
    if (options.singleton && instances.value.length > 0)
      return instances.value[0].promise;
    return create(...args);
  }
  __name(start, "start");
  const component = /* @__PURE__ */ defineComponent((_, { slots }) => {
    const renderList2 = /* @__PURE__ */ __name(() => instances.value.map((props2) => {
      var _a;
      return h(Fragment, { key: props2.key }, (_a = slots.default) == null ? void 0 : _a.call(slots, props2));
    }), "renderList");
    if (options.transition)
      return () => h(TransitionGroup, options.transition, renderList2);
    return renderList2;
  });
  component.start = start;
  return component;
}
__name(createTemplatePromise, "createTemplatePromise");
function createUnrefFn(fn) {
  return function(...args) {
    return fn.apply(this, args.map((i) => toValue$2(i)));
  };
}
__name(createUnrefFn, "createUnrefFn");
const defaultWindow = isClient ? window : void 0;
const defaultDocument = isClient ? window.document : void 0;
const defaultNavigator = isClient ? window.navigator : void 0;
const defaultLocation = isClient ? window.location : void 0;
function unrefElement(elRef) {
  var _a;
  const plain = toValue$2(elRef);
  return (_a = plain == null ? void 0 : plain.$el) != null ? _a : plain;
}
__name(unrefElement, "unrefElement");
function useEventListener(...args) {
  const cleanups = [];
  const cleanup = /* @__PURE__ */ __name(() => {
    cleanups.forEach((fn) => fn());
    cleanups.length = 0;
  }, "cleanup");
  const register = /* @__PURE__ */ __name((el, event, listener, options) => {
    el.addEventListener(event, listener, options);
    return () => el.removeEventListener(event, listener, options);
  }, "register");
  const firstParamTargets = computed(() => {
    const test = toArray(toValue$2(args[0])).filter((e) => e != null);
    return test.every((e) => typeof e !== "string") ? test : void 0;
  });
  const stopWatch = watchImmediate(
    () => {
      var _a, _b;
      return [
        (_b = (_a = firstParamTargets.value) == null ? void 0 : _a.map((e) => unrefElement(e))) != null ? _b : [defaultWindow].filter((e) => e != null),
        toArray(toValue$2(firstParamTargets.value ? args[1] : args[0])),
        toArray(unref(firstParamTargets.value ? args[2] : args[1])),
        // @ts-expect-error - TypeScript gets the correct types, but somehow still complains
        toValue$2(firstParamTargets.value ? args[3] : args[2])
      ];
    },
    ([raw_targets, raw_events, raw_listeners, raw_options]) => {
      cleanup();
      if (!(raw_targets == null ? void 0 : raw_targets.length) || !(raw_events == null ? void 0 : raw_events.length) || !(raw_listeners == null ? void 0 : raw_listeners.length))
        return;
      const optionsClone = isObject(raw_options) ? { ...raw_options } : raw_options;
      cleanups.push(
        ...raw_targets.flatMap(
          (el) => raw_events.flatMap(
            (event) => raw_listeners.map((listener) => register(el, event, listener, optionsClone))
          )
        )
      );
    },
    { flush: "post" }
  );
  const stop = /* @__PURE__ */ __name(() => {
    stopWatch();
    cleanup();
  }, "stop");
  tryOnScopeDispose(cleanup);
  return stop;
}
__name(useEventListener, "useEventListener");
let _iOSWorkaround = false;
function onClickOutside(target, handler, options = {}) {
  const { window: window2 = defaultWindow, ignore = [], capture = true, detectIframe = false, controls = false } = options;
  if (!window2) {
    return controls ? { stop: noop, cancel: noop, trigger: noop } : noop;
  }
  if (isIOS && !_iOSWorkaround) {
    _iOSWorkaround = true;
    const listenerOptions = { passive: true };
    Array.from(window2.document.body.children).forEach((el) => useEventListener(el, "click", noop, listenerOptions));
    useEventListener(window2.document.documentElement, "click", noop, listenerOptions);
  }
  let shouldListen = true;
  const shouldIgnore = /* @__PURE__ */ __name((event) => {
    return toValue$2(ignore).some((target2) => {
      if (typeof target2 === "string") {
        return Array.from(window2.document.querySelectorAll(target2)).some((el) => el === event.target || event.composedPath().includes(el));
      } else {
        const el = unrefElement(target2);
        return el && (event.target === el || event.composedPath().includes(el));
      }
    });
  }, "shouldIgnore");
  function hasMultipleRoots(target2) {
    const vm = toValue$2(target2);
    return vm && vm.$.subTree.shapeFlag === 16;
  }
  __name(hasMultipleRoots, "hasMultipleRoots");
  function checkMultipleRoots(target2, event) {
    const vm = toValue$2(target2);
    const children = vm.$.subTree && vm.$.subTree.children;
    if (children == null || !Array.isArray(children))
      return false;
    return children.some((child) => child.el === event.target || event.composedPath().includes(child.el));
  }
  __name(checkMultipleRoots, "checkMultipleRoots");
  const listener = /* @__PURE__ */ __name((event) => {
    const el = unrefElement(target);
    if (event.target == null)
      return;
    if (!(el instanceof Element) && hasMultipleRoots(target) && checkMultipleRoots(target, event))
      return;
    if (!el || el === event.target || event.composedPath().includes(el))
      return;
    if ("detail" in event && event.detail === 0)
      shouldListen = !shouldIgnore(event);
    if (!shouldListen) {
      shouldListen = true;
      return;
    }
    handler(event);
  }, "listener");
  let isProcessingClick = false;
  const cleanup = [
    useEventListener(window2, "click", (event) => {
      if (!isProcessingClick) {
        isProcessingClick = true;
        setTimeout(() => {
          isProcessingClick = false;
        }, 0);
        listener(event);
      }
    }, { passive: true, capture }),
    useEventListener(window2, "pointerdown", (e) => {
      const el = unrefElement(target);
      shouldListen = !shouldIgnore(e) && !!(el && !e.composedPath().includes(el));
    }, { passive: true }),
    detectIframe && useEventListener(window2, "blur", (event) => {
      setTimeout(() => {
        var _a;
        const el = unrefElement(target);
        if (((_a = window2.document.activeElement) == null ? void 0 : _a.tagName) === "IFRAME" && !(el == null ? void 0 : el.contains(window2.document.activeElement))) {
          handler(event);
        }
      }, 0);
    }, { passive: true })
  ].filter(Boolean);
  const stop = /* @__PURE__ */ __name(() => cleanup.forEach((fn) => fn()), "stop");
  if (controls) {
    return {
      stop,
      cancel: /* @__PURE__ */ __name(() => {
        shouldListen = false;
      }, "cancel"),
      trigger: /* @__PURE__ */ __name((event) => {
        shouldListen = true;
        listener(event);
        shouldListen = false;
      }, "trigger")
    };
  }
  return stop;
}
__name(onClickOutside, "onClickOutside");
function useMounted() {
  const isMounted = shallowRef(false);
  const instance = getCurrentInstance();
  if (instance) {
    onMounted(() => {
      isMounted.value = true;
    }, instance);
  }
  return isMounted;
}
__name(useMounted, "useMounted");
function useSupported(callback) {
  const isMounted = useMounted();
  return computed(() => {
    isMounted.value;
    return Boolean(callback());
  });
}
__name(useSupported, "useSupported");
function useMutationObserver(target, callback, options = {}) {
  const { window: window2 = defaultWindow, ...mutationOptions } = options;
  let observer;
  const isSupported2 = useSupported(() => window2 && "MutationObserver" in window2);
  const cleanup = /* @__PURE__ */ __name(() => {
    if (observer) {
      observer.disconnect();
      observer = void 0;
    }
  }, "cleanup");
  const targets = computed(() => {
    const value = toValue$2(target);
    const items = toArray(value).map(unrefElement).filter(notNullish);
    return new Set(items);
  });
  const stopWatch = watch(
    () => targets.value,
    (targets2) => {
      cleanup();
      if (isSupported2.value && targets2.size) {
        observer = new MutationObserver(callback);
        targets2.forEach((el) => observer.observe(el, mutationOptions));
      }
    },
    { immediate: true, flush: "post" }
  );
  const takeRecords = /* @__PURE__ */ __name(() => {
    return observer == null ? void 0 : observer.takeRecords();
  }, "takeRecords");
  const stop = /* @__PURE__ */ __name(() => {
    stopWatch();
    cleanup();
  }, "stop");
  tryOnScopeDispose(stop);
  return {
    isSupported: isSupported2,
    stop,
    takeRecords
  };
}
__name(useMutationObserver, "useMutationObserver");
function onElementRemoval(target, callback, options = {}) {
  const {
    window: window2 = defaultWindow,
    document: document2 = window2 == null ? void 0 : window2.document,
    flush = "sync"
  } = options;
  if (!window2 || !document2)
    return noop;
  let stopFn;
  const cleanupAndUpdate = /* @__PURE__ */ __name((fn) => {
    stopFn == null ? void 0 : stopFn();
    stopFn = fn;
  }, "cleanupAndUpdate");
  const stopWatch = watchEffect(() => {
    const el = unrefElement(target);
    if (el) {
      const { stop } = useMutationObserver(
        document2,
        (mutationsList) => {
          const targetRemoved = mutationsList.map((mutation) => [...mutation.removedNodes]).flat().some((node) => node === el || node.contains(el));
          if (targetRemoved) {
            callback(mutationsList);
          }
        },
        {
          window: window2,
          childList: true,
          subtree: true
        }
      );
      cleanupAndUpdate(stop);
    }
  }, { flush });
  const stopHandle = /* @__PURE__ */ __name(() => {
    stopWatch();
    cleanupAndUpdate();
  }, "stopHandle");
  tryOnScopeDispose(stopHandle);
  return stopHandle;
}
__name(onElementRemoval, "onElementRemoval");
function createKeyPredicate(keyFilter) {
  if (typeof keyFilter === "function")
    return keyFilter;
  else if (typeof keyFilter === "string")
    return (event) => event.key === keyFilter;
  else if (Array.isArray(keyFilter))
    return (event) => keyFilter.includes(event.key);
  return () => true;
}
__name(createKeyPredicate, "createKeyPredicate");
function onKeyStroke(...args) {
  let key;
  let handler;
  let options = {};
  if (args.length === 3) {
    key = args[0];
    handler = args[1];
    options = args[2];
  } else if (args.length === 2) {
    if (typeof args[1] === "object") {
      key = true;
      handler = args[0];
      options = args[1];
    } else {
      key = args[0];
      handler = args[1];
    }
  } else {
    key = true;
    handler = args[0];
  }
  const {
    target = defaultWindow,
    eventName = "keydown",
    passive = false,
    dedupe = false
  } = options;
  const predicate = createKeyPredicate(key);
  const listener = /* @__PURE__ */ __name((e) => {
    if (e.repeat && toValue$2(dedupe))
      return;
    if (predicate(e))
      handler(e);
  }, "listener");
  return useEventListener(target, eventName, listener, passive);
}
__name(onKeyStroke, "onKeyStroke");
function onKeyDown(key, handler, options = {}) {
  return onKeyStroke(key, handler, { ...options, eventName: "keydown" });
}
__name(onKeyDown, "onKeyDown");
function onKeyPressed(key, handler, options = {}) {
  return onKeyStroke(key, handler, { ...options, eventName: "keypress" });
}
__name(onKeyPressed, "onKeyPressed");
function onKeyUp(key, handler, options = {}) {
  return onKeyStroke(key, handler, { ...options, eventName: "keyup" });
}
__name(onKeyUp, "onKeyUp");
const DEFAULT_DELAY = 500;
const DEFAULT_THRESHOLD = 10;
function onLongPress(target, handler, options) {
  var _a, _b;
  const elementRef = computed(() => unrefElement(target));
  let timeout2;
  let posStart;
  let startTimestamp;
  let hasLongPressed = false;
  function clear() {
    if (timeout2) {
      clearTimeout(timeout2);
      timeout2 = void 0;
    }
    posStart = void 0;
    startTimestamp = void 0;
    hasLongPressed = false;
  }
  __name(clear, "clear");
  function onRelease(ev) {
    var _a2, _b2, _c;
    const [_startTimestamp, _posStart, _hasLongPressed] = [startTimestamp, posStart, hasLongPressed];
    clear();
    if (!(options == null ? void 0 : options.onMouseUp) || !_posStart || !_startTimestamp)
      return;
    if (((_a2 = options == null ? void 0 : options.modifiers) == null ? void 0 : _a2.self) && ev.target !== elementRef.value)
      return;
    if ((_b2 = options == null ? void 0 : options.modifiers) == null ? void 0 : _b2.prevent)
      ev.preventDefault();
    if ((_c = options == null ? void 0 : options.modifiers) == null ? void 0 : _c.stop)
      ev.stopPropagation();
    const dx = ev.x - _posStart.x;
    const dy = ev.y - _posStart.y;
    const distance = Math.sqrt(dx * dx + dy * dy);
    options.onMouseUp(ev.timeStamp - _startTimestamp, distance, _hasLongPressed);
  }
  __name(onRelease, "onRelease");
  function onDown(ev) {
    var _a2, _b2, _c, _d;
    if (((_a2 = options == null ? void 0 : options.modifiers) == null ? void 0 : _a2.self) && ev.target !== elementRef.value)
      return;
    clear();
    if ((_b2 = options == null ? void 0 : options.modifiers) == null ? void 0 : _b2.prevent)
      ev.preventDefault();
    if ((_c = options == null ? void 0 : options.modifiers) == null ? void 0 : _c.stop)
      ev.stopPropagation();
    posStart = {
      x: ev.x,
      y: ev.y
    };
    startTimestamp = ev.timeStamp;
    timeout2 = setTimeout(
      () => {
        hasLongPressed = true;
        handler(ev);
      },
      (_d = options == null ? void 0 : options.delay) != null ? _d : DEFAULT_DELAY
    );
  }
  __name(onDown, "onDown");
  function onMove(ev) {
    var _a2, _b2, _c, _d;
    if (((_a2 = options == null ? void 0 : options.modifiers) == null ? void 0 : _a2.self) && ev.target !== elementRef.value)
      return;
    if (!posStart || (options == null ? void 0 : options.distanceThreshold) === false)
      return;
    if ((_b2 = options == null ? void 0 : options.modifiers) == null ? void 0 : _b2.prevent)
      ev.preventDefault();
    if ((_c = options == null ? void 0 : options.modifiers) == null ? void 0 : _c.stop)
      ev.stopPropagation();
    const dx = ev.x - posStart.x;
    const dy = ev.y - posStart.y;
    const distance = Math.sqrt(dx * dx + dy * dy);
    if (distance >= ((_d = options == null ? void 0 : options.distanceThreshold) != null ? _d : DEFAULT_THRESHOLD))
      clear();
  }
  __name(onMove, "onMove");
  const listenerOptions = {
    capture: (_a = options == null ? void 0 : options.modifiers) == null ? void 0 : _a.capture,
    once: (_b = options == null ? void 0 : options.modifiers) == null ? void 0 : _b.once
  };
  const cleanup = [
    useEventListener(elementRef, "pointerdown", onDown, listenerOptions),
    useEventListener(elementRef, "pointermove", onMove, listenerOptions),
    useEventListener(elementRef, ["pointerup", "pointerleave"], onRelease, listenerOptions)
  ];
  const stop = /* @__PURE__ */ __name(() => cleanup.forEach((fn) => fn()), "stop");
  return stop;
}
__name(onLongPress, "onLongPress");
function isFocusedElementEditable() {
  const { activeElement, body } = document;
  if (!activeElement)
    return false;
  if (activeElement === body)
    return false;
  switch (activeElement.tagName) {
    case "INPUT":
    case "TEXTAREA":
      return true;
  }
  return activeElement.hasAttribute("contenteditable");
}
__name(isFocusedElementEditable, "isFocusedElementEditable");
function isTypedCharValid({
  keyCode,
  metaKey,
  ctrlKey,
  altKey
}) {
  if (metaKey || ctrlKey || altKey)
    return false;
  if (keyCode >= 48 && keyCode <= 57 || keyCode >= 96 && keyCode <= 105)
    return true;
  if (keyCode >= 65 && keyCode <= 90)
    return true;
  return false;
}
__name(isTypedCharValid, "isTypedCharValid");
function onStartTyping(callback, options = {}) {
  const { document: document2 = defaultDocument } = options;
  const keydown = /* @__PURE__ */ __name((event) => {
    if (!isFocusedElementEditable() && isTypedCharValid(event)) {
      callback(event);
    }
  }, "keydown");
  if (document2)
    useEventListener(document2, "keydown", keydown, { passive: true });
}
__name(onStartTyping, "onStartTyping");
function templateRef(key, initialValue = null) {
  const instance = getCurrentInstance();
  let _trigger = /* @__PURE__ */ __name(() => {
  }, "_trigger");
  const element = customRef((track, trigger) => {
    _trigger = trigger;
    return {
      get() {
        var _a, _b;
        track();
        return (_b = (_a = instance == null ? void 0 : instance.proxy) == null ? void 0 : _a.$refs[key]) != null ? _b : initialValue;
      },
      set() {
      }
    };
  });
  tryOnMounted(_trigger);
  onUpdated(_trigger);
  return element;
}
__name(templateRef, "templateRef");
function useActiveElement(options = {}) {
  var _a;
  const {
    window: window2 = defaultWindow,
    deep = true,
    triggerOnRemoval = false
  } = options;
  const document2 = (_a = options.document) != null ? _a : window2 == null ? void 0 : window2.document;
  const getDeepActiveElement = /* @__PURE__ */ __name(() => {
    var _a2;
    let element = document2 == null ? void 0 : document2.activeElement;
    if (deep) {
      while (element == null ? void 0 : element.shadowRoot)
        element = (_a2 = element == null ? void 0 : element.shadowRoot) == null ? void 0 : _a2.activeElement;
    }
    return element;
  }, "getDeepActiveElement");
  const activeElement = shallowRef();
  const trigger = /* @__PURE__ */ __name(() => {
    activeElement.value = getDeepActiveElement();
  }, "trigger");
  if (window2) {
    const listenerOptions = {
      capture: true,
      passive: true
    };
    useEventListener(
      window2,
      "blur",
      (event) => {
        if (event.relatedTarget !== null)
          return;
        trigger();
      },
      listenerOptions
    );
    useEventListener(
      window2,
      "focus",
      trigger,
      listenerOptions
    );
  }
  if (triggerOnRemoval) {
    onElementRemoval(activeElement, trigger, { document: document2 });
  }
  trigger();
  return activeElement;
}
__name(useActiveElement, "useActiveElement");
function useRafFn(fn, options = {}) {
  const {
    immediate = true,
    fpsLimit = void 0,
    window: window2 = defaultWindow,
    once = false
  } = options;
  const isActive = shallowRef(false);
  const intervalLimit = computed(() => {
    return fpsLimit ? 1e3 / toValue$2(fpsLimit) : null;
  });
  let previousFrameTimestamp = 0;
  let rafId2 = null;
  function loop(timestamp2) {
    if (!isActive.value || !window2)
      return;
    if (!previousFrameTimestamp)
      previousFrameTimestamp = timestamp2;
    const delta = timestamp2 - previousFrameTimestamp;
    if (intervalLimit.value && delta < intervalLimit.value) {
      rafId2 = window2.requestAnimationFrame(loop);
      return;
    }
    previousFrameTimestamp = timestamp2;
    fn({ delta, timestamp: timestamp2 });
    if (once) {
      isActive.value = false;
      rafId2 = null;
      return;
    }
    rafId2 = window2.requestAnimationFrame(loop);
  }
  __name(loop, "loop");
  function resume() {
    if (!isActive.value && window2) {
      isActive.value = true;
      previousFrameTimestamp = 0;
      rafId2 = window2.requestAnimationFrame(loop);
    }
  }
  __name(resume, "resume");
  function pause() {
    isActive.value = false;
    if (rafId2 != null && window2) {
      window2.cancelAnimationFrame(rafId2);
      rafId2 = null;
    }
  }
  __name(pause, "pause");
  if (immediate)
    resume();
  tryOnScopeDispose(pause);
  return {
    isActive: readonly(isActive),
    pause,
    resume
  };
}
__name(useRafFn, "useRafFn");
function useAnimate(target, keyframes, options) {
  let config2;
  let animateOptions;
  if (isObject(options)) {
    config2 = options;
    animateOptions = objectOmit(options, ["window", "immediate", "commitStyles", "persist", "onReady", "onError"]);
  } else {
    config2 = { duration: options };
    animateOptions = options;
  }
  const {
    window: window2 = defaultWindow,
    immediate = true,
    commitStyles,
    persist,
    playbackRate: _playbackRate = 1,
    onReady,
    onError = /* @__PURE__ */ __name((e) => {
      console.error(e);
    }, "onError")
  } = config2;
  const isSupported2 = useSupported(() => window2 && HTMLElement && "animate" in HTMLElement.prototype);
  const animate = shallowRef(void 0);
  const store = shallowReactive({
    startTime: null,
    currentTime: null,
    timeline: null,
    playbackRate: _playbackRate,
    pending: false,
    playState: immediate ? "idle" : "paused",
    replaceState: "active"
  });
  const pending = computed(() => store.pending);
  const playState = computed(() => store.playState);
  const replaceState = computed(() => store.replaceState);
  const startTime = computed({
    get() {
      return store.startTime;
    },
    set(value) {
      store.startTime = value;
      if (animate.value)
        animate.value.startTime = value;
    }
  });
  const currentTime = computed({
    get() {
      return store.currentTime;
    },
    set(value) {
      store.currentTime = value;
      if (animate.value) {
        animate.value.currentTime = value;
        syncResume();
      }
    }
  });
  const timeline = computed({
    get() {
      return store.timeline;
    },
    set(value) {
      store.timeline = value;
      if (animate.value)
        animate.value.timeline = value;
    }
  });
  const playbackRate = computed({
    get() {
      return store.playbackRate;
    },
    set(value) {
      store.playbackRate = value;
      if (animate.value)
        animate.value.playbackRate = value;
    }
  });
  const play = /* @__PURE__ */ __name(() => {
    if (animate.value) {
      try {
        animate.value.play();
        syncResume();
      } catch (e) {
        syncPause();
        onError(e);
      }
    } else {
      update();
    }
  }, "play");
  const pause = /* @__PURE__ */ __name(() => {
    var _a;
    try {
      (_a = animate.value) == null ? void 0 : _a.pause();
      syncPause();
    } catch (e) {
      onError(e);
    }
  }, "pause");
  const reverse = /* @__PURE__ */ __name(() => {
    var _a;
    if (!animate.value)
      update();
    try {
      (_a = animate.value) == null ? void 0 : _a.reverse();
      syncResume();
    } catch (e) {
      syncPause();
      onError(e);
    }
  }, "reverse");
  const finish = /* @__PURE__ */ __name(() => {
    var _a;
    try {
      (_a = animate.value) == null ? void 0 : _a.finish();
      syncPause();
    } catch (e) {
      onError(e);
    }
  }, "finish");
  const cancel = /* @__PURE__ */ __name(() => {
    var _a;
    try {
      (_a = animate.value) == null ? void 0 : _a.cancel();
      syncPause();
    } catch (e) {
      onError(e);
    }
  }, "cancel");
  watch(() => unrefElement(target), (el) => {
    if (el) {
      update();
    } else {
      animate.value = void 0;
    }
  });
  watch(() => keyframes, (value) => {
    if (animate.value) {
      update();
      const targetEl = unrefElement(target);
      if (targetEl) {
        animate.value.effect = new KeyframeEffect(
          targetEl,
          toValue$2(value),
          animateOptions
        );
      }
    }
  }, { deep: true });
  tryOnMounted(() => update(true), false);
  tryOnScopeDispose(cancel);
  function update(init) {
    const el = unrefElement(target);
    if (!isSupported2.value || !el)
      return;
    if (!animate.value)
      animate.value = el.animate(toValue$2(keyframes), animateOptions);
    if (persist)
      animate.value.persist();
    if (_playbackRate !== 1)
      animate.value.playbackRate = _playbackRate;
    if (init && !immediate)
      animate.value.pause();
    else
      syncResume();
    onReady == null ? void 0 : onReady(animate.value);
  }
  __name(update, "update");
  const listenerOptions = { passive: true };
  useEventListener(animate, ["cancel", "finish", "remove"], syncPause, listenerOptions);
  useEventListener(animate, "finish", () => {
    var _a;
    if (commitStyles)
      (_a = animate.value) == null ? void 0 : _a.commitStyles();
  }, listenerOptions);
  const { resume: resumeRef, pause: pauseRef } = useRafFn(() => {
    if (!animate.value)
      return;
    store.pending = animate.value.pending;
    store.playState = animate.value.playState;
    store.replaceState = animate.value.replaceState;
    store.startTime = animate.value.startTime;
    store.currentTime = animate.value.currentTime;
    store.timeline = animate.value.timeline;
    store.playbackRate = animate.value.playbackRate;
  }, { immediate: false });
  function syncResume() {
    if (isSupported2.value)
      resumeRef();
  }
  __name(syncResume, "syncResume");
  function syncPause() {
    if (isSupported2.value && window2)
      window2.requestAnimationFrame(pauseRef);
  }
  __name(syncPause, "syncPause");
  return {
    isSupported: isSupported2,
    animate,
    // actions
    play,
    pause,
    reverse,
    finish,
    cancel,
    // state
    pending,
    playState,
    replaceState,
    startTime,
    currentTime,
    timeline,
    playbackRate
  };
}
__name(useAnimate, "useAnimate");
function useAsyncQueue(tasks, options) {
  const {
    interrupt = true,
    onError = noop,
    onFinished = noop,
    signal
  } = options || {};
  const promiseState = {
    aborted: "aborted",
    fulfilled: "fulfilled",
    pending: "pending",
    rejected: "rejected"
  };
  const initialResult = Array.from(Array.from({ length: tasks.length }), () => ({ state: promiseState.pending, data: null }));
  const result = reactive(initialResult);
  const activeIndex = shallowRef(-1);
  if (!tasks || tasks.length === 0) {
    onFinished();
    return {
      activeIndex,
      result
    };
  }
  function updateResult(state, res) {
    activeIndex.value++;
    result[activeIndex.value].data = res;
    result[activeIndex.value].state = state;
  }
  __name(updateResult, "updateResult");
  tasks.reduce((prev, curr) => {
    return prev.then((prevRes) => {
      var _a;
      if (signal == null ? void 0 : signal.aborted) {
        updateResult(promiseState.aborted, new Error("aborted"));
        return;
      }
      if (((_a = result[activeIndex.value]) == null ? void 0 : _a.state) === promiseState.rejected && interrupt) {
        onFinished();
        return;
      }
      const done = curr(prevRes).then((currentRes) => {
        updateResult(promiseState.fulfilled, currentRes);
        if (activeIndex.value === tasks.length - 1)
          onFinished();
        return currentRes;
      });
      if (!signal)
        return done;
      return Promise.race([done, whenAborted(signal)]);
    }).catch((e) => {
      if (signal == null ? void 0 : signal.aborted) {
        updateResult(promiseState.aborted, e);
        return e;
      }
      updateResult(promiseState.rejected, e);
      onError();
      return e;
    });
  }, Promise.resolve());
  return {
    activeIndex,
    result
  };
}
__name(useAsyncQueue, "useAsyncQueue");
function whenAborted(signal) {
  return new Promise((resolve, reject) => {
    const error = new Error("aborted");
    if (signal.aborted)
      reject(error);
    else
      signal.addEventListener("abort", () => reject(error), { once: true });
  });
}
__name(whenAborted, "whenAborted");
function useAsyncState(promise, initialState, options) {
  const {
    immediate = true,
    delay: delay2 = 0,
    onError = noop,
    onSuccess = noop,
    resetOnExecute = true,
    shallow = true,
    throwError
  } = options != null ? options : {};
  const state = shallow ? shallowRef(initialState) : ref(initialState);
  const isReady = shallowRef(false);
  const isLoading = shallowRef(false);
  const error = shallowRef(void 0);
  async function execute(delay22 = 0, ...args) {
    if (resetOnExecute)
      state.value = initialState;
    error.value = void 0;
    isReady.value = false;
    isLoading.value = true;
    if (delay22 > 0)
      await promiseTimeout(delay22);
    const _promise = typeof promise === "function" ? promise(...args) : promise;
    try {
      const data = await _promise;
      state.value = data;
      isReady.value = true;
      onSuccess(data);
    } catch (e) {
      error.value = e;
      onError(e);
      if (throwError)
        throw e;
    } finally {
      isLoading.value = false;
    }
    return state.value;
  }
  __name(execute, "execute");
  if (immediate) {
    execute(delay2);
  }
  const shell = {
    state,
    isReady,
    isLoading,
    error,
    execute
  };
  function waitUntilIsLoaded() {
    return new Promise((resolve, reject) => {
      until(isLoading).toBe(false).then(() => resolve(shell)).catch(reject);
    });
  }
  __name(waitUntilIsLoaded, "waitUntilIsLoaded");
  return {
    ...shell,
    then(onFulfilled, onRejected) {
      return waitUntilIsLoaded().then(onFulfilled, onRejected);
    }
  };
}
__name(useAsyncState, "useAsyncState");
const defaults = {
  array: /* @__PURE__ */ __name((v) => JSON.stringify(v), "array"),
  object: /* @__PURE__ */ __name((v) => JSON.stringify(v), "object"),
  set: /* @__PURE__ */ __name((v) => JSON.stringify(Array.from(v)), "set"),
  map: /* @__PURE__ */ __name((v) => JSON.stringify(Object.fromEntries(v)), "map"),
  null: /* @__PURE__ */ __name(() => "", "null")
};
function getDefaultSerialization(target) {
  if (!target)
    return defaults.null;
  if (target instanceof Map)
    return defaults.map;
  else if (target instanceof Set)
    return defaults.set;
  else if (Array.isArray(target))
    return defaults.array;
  else
    return defaults.object;
}
__name(getDefaultSerialization, "getDefaultSerialization");
function useBase64(target, options) {
  const base64 = shallowRef("");
  const promise = shallowRef();
  function execute() {
    if (!isClient)
      return;
    promise.value = new Promise((resolve, reject) => {
      try {
        const _target = toValue$2(target);
        if (_target == null) {
          resolve("");
        } else if (typeof _target === "string") {
          resolve(blobToBase64(new Blob([_target], { type: "text/plain" })));
        } else if (_target instanceof Blob) {
          resolve(blobToBase64(_target));
        } else if (_target instanceof ArrayBuffer) {
          resolve(window.btoa(String.fromCharCode(...new Uint8Array(_target))));
        } else if (_target instanceof HTMLCanvasElement) {
          resolve(_target.toDataURL(options == null ? void 0 : options.type, options == null ? void 0 : options.quality));
        } else if (_target instanceof HTMLImageElement) {
          const img = _target.cloneNode(false);
          img.crossOrigin = "Anonymous";
          imgLoaded(img).then(() => {
            const canvas = document.createElement("canvas");
            const ctx = canvas.getContext("2d");
            canvas.width = img.width;
            canvas.height = img.height;
            ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
            resolve(canvas.toDataURL(options == null ? void 0 : options.type, options == null ? void 0 : options.quality));
          }).catch(reject);
        } else if (typeof _target === "object") {
          const _serializeFn = (options == null ? void 0 : options.serializer) || getDefaultSerialization(_target);
          const serialized = _serializeFn(_target);
          return resolve(blobToBase64(new Blob([serialized], { type: "application/json" })));
        } else {
          reject(new Error("target is unsupported types"));
        }
      } catch (error) {
        reject(error);
      }
    });
    promise.value.then((res) => {
      base64.value = (options == null ? void 0 : options.dataUrl) === false ? res.replace(/^data:.*?;base64,/, "") : res;
    });
    return promise.value;
  }
  __name(execute, "execute");
  if (isRef(target) || typeof target === "function")
    watch(target, execute, { immediate: true });
  else
    execute();
  return {
    base64,
    promise,
    execute
  };
}
__name(useBase64, "useBase64");
function imgLoaded(img) {
  return new Promise((resolve, reject) => {
    if (!img.complete) {
      img.onload = () => {
        resolve();
      };
      img.onerror = reject;
    } else {
      resolve();
    }
  });
}
__name(imgLoaded, "imgLoaded");
function blobToBase64(blob) {
  return new Promise((resolve, reject) => {
    const fr = new FileReader();
    fr.onload = (e) => {
      resolve(e.target.result);
    };
    fr.onerror = reject;
    fr.readAsDataURL(blob);
  });
}
__name(blobToBase64, "blobToBase64");
function useBattery(options = {}) {
  const { navigator: navigator2 = defaultNavigator } = options;
  const events2 = ["chargingchange", "chargingtimechange", "dischargingtimechange", "levelchange"];
  const isSupported2 = useSupported(() => navigator2 && "getBattery" in navigator2 && typeof navigator2.getBattery === "function");
  const charging = shallowRef(false);
  const chargingTime = shallowRef(0);
  const dischargingTime = shallowRef(0);
  const level = shallowRef(1);
  let battery;
  function updateBatteryInfo() {
    charging.value = this.charging;
    chargingTime.value = this.chargingTime || 0;
    dischargingTime.value = this.dischargingTime || 0;
    level.value = this.level;
  }
  __name(updateBatteryInfo, "updateBatteryInfo");
  if (isSupported2.value) {
    navigator2.getBattery().then((_battery) => {
      battery = _battery;
      updateBatteryInfo.call(battery);
      useEventListener(battery, events2, updateBatteryInfo, { passive: true });
    });
  }
  return {
    isSupported: isSupported2,
    charging,
    chargingTime,
    dischargingTime,
    level
  };
}
__name(useBattery, "useBattery");
function useBluetooth(options) {
  let {
    acceptAllDevices = false
  } = options || {};
  const {
    filters = void 0,
    optionalServices = void 0,
    navigator: navigator2 = defaultNavigator
  } = options || {};
  const isSupported2 = useSupported(() => navigator2 && "bluetooth" in navigator2);
  const device = shallowRef();
  const error = shallowRef(null);
  watch(device, () => {
    connectToBluetoothGATTServer();
  });
  async function requestDevice() {
    if (!isSupported2.value)
      return;
    error.value = null;
    if (filters && filters.length > 0)
      acceptAllDevices = false;
    try {
      device.value = await (navigator2 == null ? void 0 : navigator2.bluetooth.requestDevice({
        acceptAllDevices,
        filters,
        optionalServices
      }));
    } catch (err) {
      error.value = err;
    }
  }
  __name(requestDevice, "requestDevice");
  const server = shallowRef();
  const isConnected = shallowRef(false);
  function reset() {
    isConnected.value = false;
    device.value = void 0;
    server.value = void 0;
  }
  __name(reset, "reset");
  async function connectToBluetoothGATTServer() {
    error.value = null;
    if (device.value && device.value.gatt) {
      useEventListener(device, "gattserverdisconnected", reset, { passive: true });
      try {
        server.value = await device.value.gatt.connect();
        isConnected.value = server.value.connected;
      } catch (err) {
        error.value = err;
      }
    }
  }
  __name(connectToBluetoothGATTServer, "connectToBluetoothGATTServer");
  tryOnMounted(() => {
    var _a;
    if (device.value)
      (_a = device.value.gatt) == null ? void 0 : _a.connect();
  });
  tryOnScopeDispose(() => {
    var _a;
    if (device.value)
      (_a = device.value.gatt) == null ? void 0 : _a.disconnect();
  });
  return {
    isSupported: isSupported2,
    isConnected: readonly(isConnected),
    // Device:
    device,
    requestDevice,
    // Server:
    server,
    // Errors:
    error
  };
}
__name(useBluetooth, "useBluetooth");
const ssrWidthSymbol = Symbol("vueuse-ssr-width");
function useSSRWidth() {
  const ssrWidth = hasInjectionContext() ? injectLocal(ssrWidthSymbol, null) : null;
  return typeof ssrWidth === "number" ? ssrWidth : void 0;
}
__name(useSSRWidth, "useSSRWidth");
function provideSSRWidth(width, app2) {
  if (app2 !== void 0) {
    app2.provide(ssrWidthSymbol, width);
  } else {
    provideLocal(ssrWidthSymbol, width);
  }
}
__name(provideSSRWidth, "provideSSRWidth");
function useMediaQuery(query, options = {}) {
  const { window: window2 = defaultWindow, ssrWidth = useSSRWidth() } = options;
  const isSupported2 = useSupported(() => window2 && "matchMedia" in window2 && typeof window2.matchMedia === "function");
  const ssrSupport = shallowRef(typeof ssrWidth === "number");
  const mediaQuery = shallowRef();
  const matches = shallowRef(false);
  const handler = /* @__PURE__ */ __name((event) => {
    matches.value = event.matches;
  }, "handler");
  watchEffect(() => {
    if (ssrSupport.value) {
      ssrSupport.value = !isSupported2.value;
      const queryStrings = toValue$2(query).split(",");
      matches.value = queryStrings.some((queryString) => {
        const not = queryString.includes("not all");
        const minWidth = queryString.match(/\(\s*min-width:\s*(-?\d+(?:\.\d*)?[a-z]+\s*)\)/);
        const maxWidth = queryString.match(/\(\s*max-width:\s*(-?\d+(?:\.\d*)?[a-z]+\s*)\)/);
        let res = Boolean(minWidth || maxWidth);
        if (minWidth && res) {
          res = ssrWidth >= pxValue(minWidth[1]);
        }
        if (maxWidth && res) {
          res = ssrWidth <= pxValue(maxWidth[1]);
        }
        return not ? !res : res;
      });
      return;
    }
    if (!isSupported2.value)
      return;
    mediaQuery.value = window2.matchMedia(toValue$2(query));
    matches.value = mediaQuery.value.matches;
  });
  useEventListener(mediaQuery, "change", handler, { passive: true });
  return computed(() => matches.value);
}
__name(useMediaQuery, "useMediaQuery");
const breakpointsTailwind = {
  "sm": 640,
  "md": 768,
  "lg": 1024,
  "xl": 1280,
  "2xl": 1536
};
const breakpointsBootstrapV5 = {
  xs: 0,
  sm: 576,
  md: 768,
  lg: 992,
  xl: 1200,
  xxl: 1400
};
const breakpointsVuetifyV2 = {
  xs: 0,
  sm: 600,
  md: 960,
  lg: 1264,
  xl: 1904
};
const breakpointsVuetifyV3 = {
  xs: 0,
  sm: 600,
  md: 960,
  lg: 1280,
  xl: 1920,
  xxl: 2560
};
const breakpointsVuetify = breakpointsVuetifyV2;
const breakpointsAntDesign = {
  xs: 480,
  sm: 576,
  md: 768,
  lg: 992,
  xl: 1200,
  xxl: 1600
};
const breakpointsQuasar = {
  xs: 0,
  sm: 600,
  md: 1024,
  lg: 1440,
  xl: 1920
};
const breakpointsSematic = {
  mobileS: 320,
  mobileM: 375,
  mobileL: 425,
  tablet: 768,
  laptop: 1024,
  laptopL: 1440,
  desktop4K: 2560
};
const breakpointsMasterCss = {
  "3xs": 360,
  "2xs": 480,
  "xs": 600,
  "sm": 768,
  "md": 1024,
  "lg": 1280,
  "xl": 1440,
  "2xl": 1600,
  "3xl": 1920,
  "4xl": 2560
};
const breakpointsPrimeFlex = {
  sm: 576,
  md: 768,
  lg: 992,
  xl: 1200
};
const breakpointsElement = {
  xs: 0,
  sm: 768,
  md: 992,
  lg: 1200,
  xl: 1920
};
function useBreakpoints(breakpoints, options = {}) {
  function getValue2(k2, delta) {
    let v = toValue$2(breakpoints[toValue$2(k2)]);
    if (delta != null)
      v = increaseWithUnit(v, delta);
    if (typeof v === "number")
      v = `${v}px`;
    return v;
  }
  __name(getValue2, "getValue2");
  const { window: window2 = defaultWindow, strategy = "min-width", ssrWidth = useSSRWidth() } = options;
  const ssrSupport = typeof ssrWidth === "number";
  const mounted = ssrSupport ? shallowRef(false) : { value: true };
  if (ssrSupport) {
    tryOnMounted(() => mounted.value = !!window2);
  }
  function match(query, size2) {
    if (!mounted.value && ssrSupport) {
      return query === "min" ? ssrWidth >= pxValue(size2) : ssrWidth <= pxValue(size2);
    }
    if (!window2)
      return false;
    return window2.matchMedia(`(${query}-width: ${size2})`).matches;
  }
  __name(match, "match");
  const greaterOrEqual = /* @__PURE__ */ __name((k2) => {
    return useMediaQuery(() => `(min-width: ${getValue2(k2)})`, options);
  }, "greaterOrEqual");
  const smallerOrEqual = /* @__PURE__ */ __name((k2) => {
    return useMediaQuery(() => `(max-width: ${getValue2(k2)})`, options);
  }, "smallerOrEqual");
  const shortcutMethods = Object.keys(breakpoints).reduce((shortcuts, k2) => {
    Object.defineProperty(shortcuts, k2, {
      get: /* @__PURE__ */ __name(() => strategy === "min-width" ? greaterOrEqual(k2) : smallerOrEqual(k2), "get"),
      enumerable: true,
      configurable: true
    });
    return shortcuts;
  }, {});
  function current() {
    const points = Object.keys(breakpoints).map((k2) => [k2, shortcutMethods[k2], pxValue(getValue2(k2))]).sort((a, b) => a[2] - b[2]);
    return computed(() => points.filter(([, v]) => v.value).map(([k2]) => k2));
  }
  __name(current, "current");
  return Object.assign(shortcutMethods, {
    greaterOrEqual,
    smallerOrEqual,
    greater(k2) {
      return useMediaQuery(() => `(min-width: ${getValue2(k2, 0.1)})`, options);
    },
    smaller(k2) {
      return useMediaQuery(() => `(max-width: ${getValue2(k2, -0.1)})`, options);
    },
    between(a, b) {
      return useMediaQuery(() => `(min-width: ${getValue2(a)}) and (max-width: ${getValue2(b, -0.1)})`, options);
    },
    isGreater(k2) {
      return match("min", getValue2(k2, 0.1));
    },
    isGreaterOrEqual(k2) {
      return match("min", getValue2(k2));
    },
    isSmaller(k2) {
      return match("max", getValue2(k2, -0.1));
    },
    isSmallerOrEqual(k2) {
      return match("max", getValue2(k2));
    },
    isInBetween(a, b) {
      return match("min", getValue2(a)) && match("max", getValue2(b, -0.1));
    },
    current,
    active() {
      const bps = current();
      return computed(() => bps.value.length === 0 ? "" : bps.value.at(strategy === "min-width" ? -1 : 0));
    }
  });
}
__name(useBreakpoints, "useBreakpoints");
function useBroadcastChannel(options) {
  const {
    name,
    window: window2 = defaultWindow
  } = options;
  const isSupported2 = useSupported(() => window2 && "BroadcastChannel" in window2);
  const isClosed = shallowRef(false);
  const channel = ref();
  const data = ref();
  const error = shallowRef(null);
  const post = /* @__PURE__ */ __name((data2) => {
    if (channel.value)
      channel.value.postMessage(data2);
  }, "post");
  const close = /* @__PURE__ */ __name(() => {
    if (channel.value)
      channel.value.close();
    isClosed.value = true;
  }, "close");
  if (isSupported2.value) {
    tryOnMounted(() => {
      error.value = null;
      channel.value = new BroadcastChannel(name);
      const listenerOptions = {
        passive: true
      };
      useEventListener(channel, "message", (e) => {
        data.value = e.data;
      }, listenerOptions);
      useEventListener(channel, "messageerror", (e) => {
        error.value = e;
      }, listenerOptions);
      useEventListener(channel, "close", () => {
        isClosed.value = true;
      }, listenerOptions);
    });
  }
  tryOnScopeDispose(() => {
    close();
  });
  return {
    isSupported: isSupported2,
    channel,
    data,
    post,
    close,
    error,
    isClosed
  };
}
__name(useBroadcastChannel, "useBroadcastChannel");
const WRITABLE_PROPERTIES = [
  "hash",
  "host",
  "hostname",
  "href",
  "pathname",
  "port",
  "protocol",
  "search"
];
function useBrowserLocation(options = {}) {
  const { window: window2 = defaultWindow } = options;
  const refs = Object.fromEntries(
    WRITABLE_PROPERTIES.map((key) => [key, ref()])
  );
  for (const [key, ref2] of objectEntries(refs)) {
    watch(ref2, (value) => {
      if (!(window2 == null ? void 0 : window2.location) || window2.location[key] === value)
        return;
      window2.location[key] = value;
    });
  }
  const buildState = /* @__PURE__ */ __name((trigger) => {
    var _a;
    const { state: state2, length } = (window2 == null ? void 0 : window2.history) || {};
    const { origin } = (window2 == null ? void 0 : window2.location) || {};
    for (const key of WRITABLE_PROPERTIES)
      refs[key].value = (_a = window2 == null ? void 0 : window2.location) == null ? void 0 : _a[key];
    return reactive({
      trigger,
      state: state2,
      length,
      origin,
      ...refs
    });
  }, "buildState");
  const state = ref(buildState("load"));
  if (window2) {
    const listenerOptions = { passive: true };
    useEventListener(window2, "popstate", () => state.value = buildState("popstate"), listenerOptions);
    useEventListener(window2, "hashchange", () => state.value = buildState("hashchange"), listenerOptions);
  }
  return state;
}
__name(useBrowserLocation, "useBrowserLocation");
function useCached(refValue, comparator = (a, b) => a === b, options) {
  const { deepRefs = true, ...watchOptions } = options || {};
  const cachedValue = createRef(refValue.value, deepRefs);
  watch(() => refValue.value, (value) => {
    if (!comparator(value, cachedValue.value))
      cachedValue.value = value;
  }, watchOptions);
  return cachedValue;
}
__name(useCached, "useCached");
function usePermission(permissionDesc, options = {}) {
  const {
    controls = false,
    navigator: navigator2 = defaultNavigator
  } = options;
  const isSupported2 = useSupported(() => navigator2 && "permissions" in navigator2);
  const permissionStatus = shallowRef();
  const desc = typeof permissionDesc === "string" ? { name: permissionDesc } : permissionDesc;
  const state = shallowRef();
  const update = /* @__PURE__ */ __name(() => {
    var _a, _b;
    state.value = (_b = (_a = permissionStatus.value) == null ? void 0 : _a.state) != null ? _b : "prompt";
  }, "update");
  useEventListener(permissionStatus, "change", update, { passive: true });
  const query = createSingletonPromise(async () => {
    if (!isSupported2.value)
      return;
    if (!permissionStatus.value) {
      try {
        permissionStatus.value = await navigator2.permissions.query(desc);
      } catch (e) {
        permissionStatus.value = void 0;
      } finally {
        update();
      }
    }
    if (controls)
      return toRaw(permissionStatus.value);
  });
  query();
  if (controls) {
    return {
      state,
      isSupported: isSupported2,
      query
    };
  } else {
    return state;
  }
}
__name(usePermission, "usePermission");
function useClipboard(options = {}) {
  const {
    navigator: navigator2 = defaultNavigator,
    read = false,
    source,
    copiedDuring = 1500,
    legacy = false
  } = options;
  const isClipboardApiSupported = useSupported(() => navigator2 && "clipboard" in navigator2);
  const permissionRead = usePermission("clipboard-read");
  const permissionWrite = usePermission("clipboard-write");
  const isSupported2 = computed(() => isClipboardApiSupported.value || legacy);
  const text = shallowRef("");
  const copied = shallowRef(false);
  const timeout2 = useTimeoutFn(() => copied.value = false, copiedDuring, { immediate: false });
  async function updateText() {
    let useLegacy = !(isClipboardApiSupported.value && isAllowed(permissionRead.value));
    if (!useLegacy) {
      try {
        text.value = await navigator2.clipboard.readText();
      } catch (e) {
        useLegacy = true;
      }
    }
    if (useLegacy) {
      text.value = legacyRead();
    }
  }
  __name(updateText, "updateText");
  if (isSupported2.value && read)
    useEventListener(["copy", "cut"], updateText, { passive: true });
  async function copy(value = toValue$2(source)) {
    if (isSupported2.value && value != null) {
      let useLegacy = !(isClipboardApiSupported.value && isAllowed(permissionWrite.value));
      if (!useLegacy) {
        try {
          await navigator2.clipboard.writeText(value);
        } catch (e) {
          useLegacy = true;
        }
      }
      if (useLegacy)
        legacyCopy(value);
      text.value = value;
      copied.value = true;
      timeout2.start();
    }
  }
  __name(copy, "copy");
  function legacyCopy(value) {
    const ta = document.createElement("textarea");
    ta.value = value != null ? value : "";
    ta.style.position = "absolute";
    ta.style.opacity = "0";
    document.body.appendChild(ta);
    ta.select();
    document.execCommand("copy");
    ta.remove();
  }
  __name(legacyCopy, "legacyCopy");
  function legacyRead() {
    var _a, _b, _c;
    return (_c = (_b = (_a = document == null ? void 0 : document.getSelection) == null ? void 0 : _a.call(document)) == null ? void 0 : _b.toString()) != null ? _c : "";
  }
  __name(legacyRead, "legacyRead");
  function isAllowed(status) {
    return status === "granted" || status === "prompt";
  }
  __name(isAllowed, "isAllowed");
  return {
    isSupported: isSupported2,
    text,
    copied,
    copy
  };
}
__name(useClipboard, "useClipboard");
function useClipboardItems(options = {}) {
  const {
    navigator: navigator2 = defaultNavigator,
    read = false,
    source,
    copiedDuring = 1500
  } = options;
  const isSupported2 = useSupported(() => navigator2 && "clipboard" in navigator2);
  const content = ref([]);
  const copied = shallowRef(false);
  const timeout2 = useTimeoutFn(() => copied.value = false, copiedDuring, { immediate: false });
  function updateContent() {
    if (isSupported2.value) {
      navigator2.clipboard.read().then((items) => {
        content.value = items;
      });
    }
  }
  __name(updateContent, "updateContent");
  if (isSupported2.value && read)
    useEventListener(["copy", "cut"], updateContent, { passive: true });
  async function copy(value = toValue$2(source)) {
    if (isSupported2.value && value != null) {
      await navigator2.clipboard.write(value);
      content.value = value;
      copied.value = true;
      timeout2.start();
    }
  }
  __name(copy, "copy");
  return {
    isSupported: isSupported2,
    content,
    copied,
    copy
  };
}
__name(useClipboardItems, "useClipboardItems");
function cloneFnJSON(source) {
  return JSON.parse(JSON.stringify(source));
}
__name(cloneFnJSON, "cloneFnJSON");
function useCloned(source, options = {}) {
  const cloned = ref({});
  const isModified = shallowRef(false);
  let _lastSync = false;
  const {
    manual,
    clone = cloneFnJSON,
    // watch options
    deep = true,
    immediate = true
  } = options;
  watch(cloned, () => {
    if (_lastSync) {
      _lastSync = false;
      return;
    }
    isModified.value = true;
  }, {
    deep: true,
    flush: "sync"
  });
  function sync() {
    _lastSync = true;
    isModified.value = false;
    cloned.value = clone(toValue$2(source));
  }
  __name(sync, "sync");
  if (!manual && (isRef(source) || typeof source === "function")) {
    watch(source, sync, {
      ...options,
      deep,
      immediate
    });
  } else {
    sync();
  }
  return { cloned, isModified, sync };
}
__name(useCloned, "useCloned");
const _global = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
const globalKey = "__vueuse_ssr_handlers__";
const handlers = /* @__PURE__ */ getHandlers();
function getHandlers() {
  if (!(globalKey in _global))
    _global[globalKey] = _global[globalKey] || {};
  return _global[globalKey];
}
__name(getHandlers, "getHandlers");
function getSSRHandler(key, fallback) {
  return handlers[key] || fallback;
}
__name(getSSRHandler, "getSSRHandler");
function setSSRHandler(key, fn) {
  handlers[key] = fn;
}
__name(setSSRHandler, "setSSRHandler");
function usePreferredDark(options) {
  return useMediaQuery("(prefers-color-scheme: dark)", options);
}
__name(usePreferredDark, "usePreferredDark");
function guessSerializerType(rawInit) {
  return rawInit == null ? "any" : rawInit instanceof Set ? "set" : rawInit instanceof Map ? "map" : rawInit instanceof Date ? "date" : typeof rawInit === "boolean" ? "boolean" : typeof rawInit === "string" ? "string" : typeof rawInit === "object" ? "object" : !Number.isNaN(rawInit) ? "number" : "any";
}
__name(guessSerializerType, "guessSerializerType");
const StorageSerializers = {
  boolean: {
    read: /* @__PURE__ */ __name((v) => v === "true", "read"),
    write: /* @__PURE__ */ __name((v) => String(v), "write")
  },
  object: {
    read: /* @__PURE__ */ __name((v) => JSON.parse(v), "read"),
    write: /* @__PURE__ */ __name((v) => JSON.stringify(v), "write")
  },
  number: {
    read: /* @__PURE__ */ __name((v) => Number.parseFloat(v), "read"),
    write: /* @__PURE__ */ __name((v) => String(v), "write")
  },
  any: {
    read: /* @__PURE__ */ __name((v) => v, "read"),
    write: /* @__PURE__ */ __name((v) => String(v), "write")
  },
  string: {
    read: /* @__PURE__ */ __name((v) => v, "read"),
    write: /* @__PURE__ */ __name((v) => String(v), "write")
  },
  map: {
    read: /* @__PURE__ */ __name((v) => new Map(JSON.parse(v)), "read"),
    write: /* @__PURE__ */ __name((v) => JSON.stringify(Array.from(v.entries())), "write")
  },
  set: {
    read: /* @__PURE__ */ __name((v) => new Set(JSON.parse(v)), "read"),
    write: /* @__PURE__ */ __name((v) => JSON.stringify(Array.from(v)), "write")
  },
  date: {
    read: /* @__PURE__ */ __name((v) => new Date(v), "read"),
    write: /* @__PURE__ */ __name((v) => v.toISOString(), "write")
  }
};
const customStorageEventName = "vueuse-storage";
function useStorage(key, defaults2, storage, options = {}) {
  var _a;
  const {
    flush = "pre",
    deep = true,
    listenToStorageChanges = true,
    writeDefaults = true,
    mergeDefaults: mergeDefaults2 = false,
    shallow,
    window: window2 = defaultWindow,
    eventFilter,
    onError = /* @__PURE__ */ __name((e) => {
      console.error(e);
    }, "onError"),
    initOnMounted
  } = options;
  const data = (shallow ? shallowRef : ref)(typeof defaults2 === "function" ? defaults2() : defaults2);
  const keyComputed = computed(() => toValue$2(key));
  if (!storage) {
    try {
      storage = getSSRHandler("getDefaultStorage", () => {
        var _a2;
        return (_a2 = defaultWindow) == null ? void 0 : _a2.localStorage;
      })();
    } catch (e) {
      onError(e);
    }
  }
  if (!storage)
    return data;
  const rawInit = toValue$2(defaults2);
  const type = guessSerializerType(rawInit);
  const serializer = (_a = options.serializer) != null ? _a : StorageSerializers[type];
  const { pause: pauseWatch, resume: resumeWatch } = watchPausable(
    data,
    () => write(data.value),
    { flush, deep, eventFilter }
  );
  watch(keyComputed, () => update(), { flush });
  if (window2 && listenToStorageChanges) {
    tryOnMounted(() => {
      if (storage instanceof Storage)
        useEventListener(window2, "storage", update, { passive: true });
      else
        useEventListener(window2, customStorageEventName, updateFromCustomEvent);
      if (initOnMounted)
        update();
    });
  }
  if (!initOnMounted)
    update();
  function dispatchWriteEvent(oldValue, newValue) {
    if (window2) {
      const payload = {
        key: keyComputed.value,
        oldValue,
        newValue,
        storageArea: storage
      };
      window2.dispatchEvent(storage instanceof Storage ? new StorageEvent("storage", payload) : new CustomEvent(customStorageEventName, {
        detail: payload
      }));
    }
  }
  __name(dispatchWriteEvent, "dispatchWriteEvent");
  function write(v) {
    try {
      const oldValue = storage.getItem(keyComputed.value);
      if (v == null) {
        dispatchWriteEvent(oldValue, null);
        storage.removeItem(keyComputed.value);
      } else {
        const serialized = serializer.write(v);
        if (oldValue !== serialized) {
          storage.setItem(keyComputed.value, serialized);
          dispatchWriteEvent(oldValue, serialized);
        }
      }
    } catch (e) {
      onError(e);
    }
  }
  __name(write, "write");
  function read(event) {
    const rawValue = event ? event.newValue : storage.getItem(keyComputed.value);
    if (rawValue == null) {
      if (writeDefaults && rawInit != null)
        storage.setItem(keyComputed.value, serializer.write(rawInit));
      return rawInit;
    } else if (!event && mergeDefaults2) {
      const value = serializer.read(rawValue);
      if (typeof mergeDefaults2 === "function")
        return mergeDefaults2(value, rawInit);
      else if (type === "object" && !Array.isArray(value))
        return { ...rawInit, ...value };
      return value;
    } else if (typeof rawValue !== "string") {
      return rawValue;
    } else {
      return serializer.read(rawValue);
    }
  }
  __name(read, "read");
  function update(event) {
    if (event && event.storageArea !== storage)
      return;
    if (event && event.key == null) {
      data.value = rawInit;
      return;
    }
    if (event && event.key !== keyComputed.value)
      return;
    pauseWatch();
    try {
      if ((event == null ? void 0 : event.newValue) !== serializer.write(data.value))
        data.value = read(event);
    } catch (e) {
      onError(e);
    } finally {
      if (event)
        nextTick(resumeWatch);
      else
        resumeWatch();
    }
  }
  __name(update, "update");
  function updateFromCustomEvent(event) {
    update(event.detail);
  }
  __name(updateFromCustomEvent, "updateFromCustomEvent");
  return data;
}
__name(useStorage, "useStorage");
const CSS_DISABLE_TRANS = "*,*::before,*::after{-webkit-transition:none!important;-moz-transition:none!important;-o-transition:none!important;-ms-transition:none!important;transition:none!important}";
function useColorMode(options = {}) {
  const {
    selector = "html",
    attribute = "class",
    initialValue = "auto",
    window: window2 = defaultWindow,
    storage,
    storageKey = "vueuse-color-scheme",
    listenToStorageChanges = true,
    storageRef,
    emitAuto,
    disableTransition = true
  } = options;
  const modes = {
    auto: "",
    light: "light",
    dark: "dark",
    ...options.modes || {}
  };
  const preferredDark = usePreferredDark({ window: window2 });
  const system = computed(() => preferredDark.value ? "dark" : "light");
  const store = storageRef || (storageKey == null ? toRef(initialValue) : useStorage(storageKey, initialValue, storage, { window: window2, listenToStorageChanges }));
  const state = computed(() => store.value === "auto" ? system.value : store.value);
  const updateHTMLAttrs = getSSRHandler(
    "updateHTMLAttrs",
    (selector2, attribute2, value) => {
      const el = typeof selector2 === "string" ? window2 == null ? void 0 : window2.document.querySelector(selector2) : unrefElement(selector2);
      if (!el)
        return;
      const classesToAdd = /* @__PURE__ */ new Set();
      const classesToRemove = /* @__PURE__ */ new Set();
      let attributeToChange = null;
      if (attribute2 === "class") {
        const current = value.split(/\s/g);
        Object.values(modes).flatMap((i) => (i || "").split(/\s/g)).filter(Boolean).forEach((v) => {
          if (current.includes(v))
            classesToAdd.add(v);
          else
            classesToRemove.add(v);
        });
      } else {
        attributeToChange = { key: attribute2, value };
      }
      if (classesToAdd.size === 0 && classesToRemove.size === 0 && attributeToChange === null)
        return;
      let style;
      if (disableTransition) {
        style = window2.document.createElement("style");
        style.appendChild(document.createTextNode(CSS_DISABLE_TRANS));
        window2.document.head.appendChild(style);
      }
      for (const c2 of classesToAdd) {
        el.classList.add(c2);
      }
      for (const c2 of classesToRemove) {
        el.classList.remove(c2);
      }
      if (attributeToChange) {
        el.setAttribute(attributeToChange.key, attributeToChange.value);
      }
      if (disableTransition) {
        window2.getComputedStyle(style).opacity;
        document.head.removeChild(style);
      }
    }
  );
  function defaultOnChanged(mode) {
    var _a;
    updateHTMLAttrs(selector, attribute, (_a = modes[mode]) != null ? _a : mode);
  }
  __name(defaultOnChanged, "defaultOnChanged");
  function onChanged(mode) {
    if (options.onChanged)
      options.onChanged(mode, defaultOnChanged);
    else
      defaultOnChanged(mode);
  }
  __name(onChanged, "onChanged");
  watch(state, onChanged, { flush: "post", immediate: true });
  tryOnMounted(() => onChanged(state.value));
  const auto = computed({
    get() {
      return emitAuto ? store.value : state.value;
    },
    set(v) {
      store.value = v;
    }
  });
  return Object.assign(auto, { store, system, state });
}
__name(useColorMode, "useColorMode");
function useConfirmDialog(revealed = shallowRef(false)) {
  const confirmHook = createEventHook();
  const cancelHook = createEventHook();
  const revealHook = createEventHook();
  let _resolve = noop;
  const reveal = /* @__PURE__ */ __name((data) => {
    revealHook.trigger(data);
    revealed.value = true;
    return new Promise((resolve) => {
      _resolve = resolve;
    });
  }, "reveal");
  const confirm2 = /* @__PURE__ */ __name((data) => {
    revealed.value = false;
    confirmHook.trigger(data);
    _resolve({ data, isCanceled: false });
  }, "confirm");
  const cancel = /* @__PURE__ */ __name((data) => {
    revealed.value = false;
    cancelHook.trigger(data);
    _resolve({ data, isCanceled: true });
  }, "cancel");
  return {
    isRevealed: computed(() => revealed.value),
    reveal,
    confirm: confirm2,
    cancel,
    onReveal: revealHook.on,
    onConfirm: confirmHook.on,
    onCancel: cancelHook.on
  };
}
__name(useConfirmDialog, "useConfirmDialog");
function useCountdown(initialCountdown, options) {
  var _a, _b;
  const remaining = shallowRef(toValue$2(initialCountdown));
  const intervalController = useIntervalFn(() => {
    var _a2, _b2;
    const value = remaining.value - 1;
    remaining.value = value < 0 ? 0 : value;
    (_a2 = options == null ? void 0 : options.onTick) == null ? void 0 : _a2.call(options);
    if (remaining.value <= 0) {
      intervalController.pause();
      (_b2 = options == null ? void 0 : options.onComplete) == null ? void 0 : _b2.call(options);
    }
  }, (_a = options == null ? void 0 : options.interval) != null ? _a : 1e3, { immediate: (_b = options == null ? void 0 : options.immediate) != null ? _b : false });
  const reset = /* @__PURE__ */ __name((countdown) => {
    var _a2;
    remaining.value = (_a2 = toValue$2(countdown)) != null ? _a2 : toValue$2(initialCountdown);
  }, "reset");
  const stop = /* @__PURE__ */ __name(() => {
    intervalController.pause();
    reset();
  }, "stop");
  const resume = /* @__PURE__ */ __name(() => {
    if (!intervalController.isActive.value) {
      if (remaining.value > 0) {
        intervalController.resume();
      }
    }
  }, "resume");
  const start = /* @__PURE__ */ __name((countdown) => {
    reset(countdown);
    intervalController.resume();
  }, "start");
  return {
    remaining,
    reset,
    stop,
    start,
    pause: intervalController.pause,
    resume,
    isActive: intervalController.isActive
  };
}
__name(useCountdown, "useCountdown");
function useCssVar(prop, target, options = {}) {
  const { window: window2 = defaultWindow, initialValue, observe = false } = options;
  const variable = shallowRef(initialValue);
  const elRef = computed(() => {
    var _a;
    return unrefElement(target) || ((_a = window2 == null ? void 0 : window2.document) == null ? void 0 : _a.documentElement);
  });
  function updateCssVar() {
    var _a;
    const key = toValue$2(prop);
    const el = toValue$2(elRef);
    if (el && window2 && key) {
      const value = (_a = window2.getComputedStyle(el).getPropertyValue(key)) == null ? void 0 : _a.trim();
      variable.value = value || variable.value || initialValue;
    }
  }
  __name(updateCssVar, "updateCssVar");
  if (observe) {
    useMutationObserver(elRef, updateCssVar, {
      attributeFilter: ["style", "class"],
      window: window2
    });
  }
  watch(
    [elRef, () => toValue$2(prop)],
    (_, old) => {
      if (old[0] && old[1])
        old[0].style.removeProperty(old[1]);
      updateCssVar();
    },
    { immediate: true }
  );
  watch(
    [variable, elRef],
    ([val, el]) => {
      const raw_prop = toValue$2(prop);
      if ((el == null ? void 0 : el.style) && raw_prop) {
        if (val == null)
          el.style.removeProperty(raw_prop);
        else
          el.style.setProperty(raw_prop, val);
      }
    },
    { immediate: true }
  );
  return variable;
}
__name(useCssVar, "useCssVar");
function useCurrentElement(rootComponent) {
  const vm = getCurrentInstance();
  const currentElement = computedWithControl(
    () => null,
    () => rootComponent ? unrefElement(rootComponent) : vm.proxy.$el
  );
  onUpdated(currentElement.trigger);
  onMounted(currentElement.trigger);
  return currentElement;
}
__name(useCurrentElement, "useCurrentElement");
function useCycleList(list, options) {
  const state = shallowRef(getInitialValue());
  const listRef = toRef(list);
  const index = computed({
    get() {
      var _a;
      const targetList = listRef.value;
      let index2 = (options == null ? void 0 : options.getIndexOf) ? options.getIndexOf(state.value, targetList) : targetList.indexOf(state.value);
      if (index2 < 0)
        index2 = (_a = options == null ? void 0 : options.fallbackIndex) != null ? _a : 0;
      return index2;
    },
    set(v) {
      set2(v);
    }
  });
  function set2(i) {
    const targetList = listRef.value;
    const length = targetList.length;
    const index2 = (i % length + length) % length;
    const value = targetList[index2];
    state.value = value;
    return value;
  }
  __name(set2, "set");
  function shift2(delta = 1) {
    return set2(index.value + delta);
  }
  __name(shift2, "shift");
  function next(n = 1) {
    return shift2(n);
  }
  __name(next, "next");
  function prev(n = 1) {
    return shift2(-n);
  }
  __name(prev, "prev");
  function getInitialValue() {
    var _a, _b;
    return (_b = toValue$2((_a = options == null ? void 0 : options.initialValue) != null ? _a : toValue$2(list)[0])) != null ? _b : void 0;
  }
  __name(getInitialValue, "getInitialValue");
  watch(listRef, () => set2(index.value));
  return {
    state,
    index,
    next,
    prev,
    go: set2
  };
}
__name(useCycleList, "useCycleList");
function useDark(options = {}) {
  const {
    valueDark = "dark",
    valueLight = ""
  } = options;
  const mode = useColorMode({
    ...options,
    onChanged: /* @__PURE__ */ __name((mode2, defaultHandler) => {
      var _a;
      if (options.onChanged)
        (_a = options.onChanged) == null ? void 0 : _a.call(options, mode2 === "dark", defaultHandler, mode2);
      else
        defaultHandler(mode2);
    }, "onChanged"),
    modes: {
      dark: valueDark,
      light: valueLight
    }
  });
  const system = computed(() => mode.system.value);
  const isDark = computed({
    get() {
      return mode.value === "dark";
    },
    set(v) {
      const modeVal = v ? "dark" : "light";
      if (system.value === modeVal)
        mode.value = "auto";
      else
        mode.value = modeVal;
    }
  });
  return isDark;
}
__name(useDark, "useDark");
function fnBypass(v) {
  return v;
}
__name(fnBypass, "fnBypass");
function fnSetSource(source, value) {
  return source.value = value;
}
__name(fnSetSource, "fnSetSource");
function defaultDump(clone) {
  return clone ? typeof clone === "function" ? clone : cloneFnJSON : fnBypass;
}
__name(defaultDump, "defaultDump");
function defaultParse(clone) {
  return clone ? typeof clone === "function" ? clone : cloneFnJSON : fnBypass;
}
__name(defaultParse, "defaultParse");
function useManualRefHistory(source, options = {}) {
  const {
    clone = false,
    dump = defaultDump(clone),
    parse = defaultParse(clone),
    setSource = fnSetSource
  } = options;
  function _createHistoryRecord() {
    return markRaw({
      snapshot: dump(source.value),
      timestamp: timestamp()
    });
  }
  __name(_createHistoryRecord, "_createHistoryRecord");
  const last = ref(_createHistoryRecord());
  const undoStack = ref([]);
  const redoStack = ref([]);
  const _setSource = /* @__PURE__ */ __name((record) => {
    setSource(source, parse(record.snapshot));
    last.value = record;
  }, "_setSource");
  const commit = /* @__PURE__ */ __name(() => {
    undoStack.value.unshift(last.value);
    last.value = _createHistoryRecord();
    if (options.capacity && undoStack.value.length > options.capacity)
      undoStack.value.splice(options.capacity, Number.POSITIVE_INFINITY);
    if (redoStack.value.length)
      redoStack.value.splice(0, redoStack.value.length);
  }, "commit");
  const clear = /* @__PURE__ */ __name(() => {
    undoStack.value.splice(0, undoStack.value.length);
    redoStack.value.splice(0, redoStack.value.length);
  }, "clear");
  const undo = /* @__PURE__ */ __name(() => {
    const state = undoStack.value.shift();
    if (state) {
      redoStack.value.unshift(last.value);
      _setSource(state);
    }
  }, "undo");
  const redo = /* @__PURE__ */ __name(() => {
    const state = redoStack.value.shift();
    if (state) {
      undoStack.value.unshift(last.value);
      _setSource(state);
    }
  }, "redo");
  const reset = /* @__PURE__ */ __name(() => {
    _setSource(last.value);
  }, "reset");
  const history = computed(() => [last.value, ...undoStack.value]);
  const canUndo = computed(() => undoStack.value.length > 0);
  const canRedo = computed(() => redoStack.value.length > 0);
  return {
    source,
    undoStack,
    redoStack,
    last,
    history,
    canUndo,
    canRedo,
    clear,
    commit,
    reset,
    undo,
    redo
  };
}
__name(useManualRefHistory, "useManualRefHistory");
function useRefHistory(source, options = {}) {
  const {
    deep = false,
    flush = "pre",
    eventFilter
  } = options;
  const {
    eventFilter: composedFilter,
    pause,
    resume: resumeTracking,
    isActive: isTracking
  } = pausableFilter(eventFilter);
  const {
    ignoreUpdates,
    ignorePrevAsyncUpdates,
    stop
  } = watchIgnorable(
    source,
    commit,
    { deep, flush, eventFilter: composedFilter }
  );
  function setSource(source2, value) {
    ignorePrevAsyncUpdates();
    ignoreUpdates(() => {
      source2.value = value;
    });
  }
  __name(setSource, "setSource");
  const manualHistory = useManualRefHistory(source, { ...options, clone: options.clone || deep, setSource });
  const { clear, commit: manualCommit } = manualHistory;
  function commit() {
    ignorePrevAsyncUpdates();
    manualCommit();
  }
  __name(commit, "commit");
  function resume(commitNow) {
    resumeTracking();
    if (commitNow)
      commit();
  }
  __name(resume, "resume");
  function batch(fn) {
    let canceled = false;
    const cancel = /* @__PURE__ */ __name(() => canceled = true, "cancel");
    ignoreUpdates(() => {
      fn(cancel);
    });
    if (!canceled)
      commit();
  }
  __name(batch, "batch");
  function dispose() {
    stop();
    clear();
  }
  __name(dispose, "dispose");
  return {
    ...manualHistory,
    isTracking,
    pause,
    resume,
    commit,
    batch,
    dispose
  };
}
__name(useRefHistory, "useRefHistory");
function useDebouncedRefHistory(source, options = {}) {
  const filter = options.debounce ? debounceFilter(options.debounce) : void 0;
  const history = useRefHistory(source, { ...options, eventFilter: filter });
  return {
    ...history
  };
}
__name(useDebouncedRefHistory, "useDebouncedRefHistory");
function useDeviceMotion(options = {}) {
  const {
    window: window2 = defaultWindow,
    requestPermissions = false,
    eventFilter = bypassFilter
  } = options;
  const isSupported2 = useSupported(() => typeof DeviceMotionEvent !== "undefined");
  const requirePermissions = useSupported(() => isSupported2.value && "requestPermission" in DeviceMotionEvent && typeof DeviceMotionEvent.requestPermission === "function");
  const permissionGranted = shallowRef(false);
  const acceleration = ref({ x: null, y: null, z: null });
  const rotationRate = ref({ alpha: null, beta: null, gamma: null });
  const interval = shallowRef(0);
  const accelerationIncludingGravity = ref({
    x: null,
    y: null,
    z: null
  });
  function init() {
    if (window2) {
      const onDeviceMotion = createFilterWrapper(
        eventFilter,
        (event) => {
          var _a, _b, _c, _d, _e, _f, _g, _h, _i;
          acceleration.value = {
            x: ((_a = event.acceleration) == null ? void 0 : _a.x) || null,
            y: ((_b = event.acceleration) == null ? void 0 : _b.y) || null,
            z: ((_c = event.acceleration) == null ? void 0 : _c.z) || null
          };
          accelerationIncludingGravity.value = {
            x: ((_d = event.accelerationIncludingGravity) == null ? void 0 : _d.x) || null,
            y: ((_e = event.accelerationIncludingGravity) == null ? void 0 : _e.y) || null,
            z: ((_f = event.accelerationIncludingGravity) == null ? void 0 : _f.z) || null
          };
          rotationRate.value = {
            alpha: ((_g = event.rotationRate) == null ? void 0 : _g.alpha) || null,
            beta: ((_h = event.rotationRate) == null ? void 0 : _h.beta) || null,
            gamma: ((_i = event.rotationRate) == null ? void 0 : _i.gamma) || null
          };
          interval.value = event.interval;
        }
      );
      useEventListener(window2, "devicemotion", onDeviceMotion, { passive: true });
    }
  }
  __name(init, "init");
  const ensurePermissions = /* @__PURE__ */ __name(async () => {
    if (!requirePermissions.value)
      permissionGranted.value = true;
    if (permissionGranted.value)
      return;
    if (requirePermissions.value) {
      const requestPermission = DeviceMotionEvent.requestPermission;
      try {
        const response = await requestPermission();
        if (response === "granted") {
          permissionGranted.value = true;
          init();
        }
      } catch (error) {
        console.error(error);
      }
    }
  }, "ensurePermissions");
  if (isSupported2.value) {
    if (requestPermissions && requirePermissions.value) {
      ensurePermissions().then(() => init());
    } else {
      init();
    }
  }
  return {
    acceleration,
    accelerationIncludingGravity,
    rotationRate,
    interval,
    isSupported: isSupported2,
    requirePermissions,
    ensurePermissions,
    permissionGranted
  };
}
__name(useDeviceMotion, "useDeviceMotion");
function useDeviceOrientation(options = {}) {
  const { window: window2 = defaultWindow } = options;
  const isSupported2 = useSupported(() => window2 && "DeviceOrientationEvent" in window2);
  const isAbsolute = shallowRef(false);
  const alpha = shallowRef(null);
  const beta = shallowRef(null);
  const gamma = shallowRef(null);
  if (window2 && isSupported2.value) {
    useEventListener(window2, "deviceorientation", (event) => {
      isAbsolute.value = event.absolute;
      alpha.value = event.alpha;
      beta.value = event.beta;
      gamma.value = event.gamma;
    }, { passive: true });
  }
  return {
    isSupported: isSupported2,
    isAbsolute,
    alpha,
    beta,
    gamma
  };
}
__name(useDeviceOrientation, "useDeviceOrientation");
function useDevicePixelRatio(options = {}) {
  const {
    window: window2 = defaultWindow
  } = options;
  const pixelRatio = shallowRef(1);
  const query = useMediaQuery(() => `(resolution: ${pixelRatio.value}dppx)`, options);
  let stop = noop;
  if (window2) {
    stop = watchImmediate(query, () => pixelRatio.value = window2.devicePixelRatio);
  }
  return {
    pixelRatio: readonly(pixelRatio),
    stop
  };
}
__name(useDevicePixelRatio, "useDevicePixelRatio");
function useDevicesList(options = {}) {
  const {
    navigator: navigator2 = defaultNavigator,
    requestPermissions = false,
    constraints = { audio: true, video: true },
    onUpdated: onUpdated2
  } = options;
  const devices = ref([]);
  const videoInputs = computed(() => devices.value.filter((i) => i.kind === "videoinput"));
  const audioInputs = computed(() => devices.value.filter((i) => i.kind === "audioinput"));
  const audioOutputs = computed(() => devices.value.filter((i) => i.kind === "audiooutput"));
  const isSupported2 = useSupported(() => navigator2 && navigator2.mediaDevices && navigator2.mediaDevices.enumerateDevices);
  const permissionGranted = shallowRef(false);
  let stream;
  async function update() {
    if (!isSupported2.value)
      return;
    devices.value = await navigator2.mediaDevices.enumerateDevices();
    onUpdated2 == null ? void 0 : onUpdated2(devices.value);
    if (stream) {
      stream.getTracks().forEach((t2) => t2.stop());
      stream = null;
    }
  }
  __name(update, "update");
  async function ensurePermissions() {
    const deviceName = constraints.video ? "camera" : "microphone";
    if (!isSupported2.value)
      return false;
    if (permissionGranted.value)
      return true;
    const { state, query } = usePermission(deviceName, { controls: true });
    await query();
    if (state.value !== "granted") {
      let granted = true;
      try {
        stream = await navigator2.mediaDevices.getUserMedia(constraints);
      } catch (e) {
        stream = null;
        granted = false;
      }
      update();
      permissionGranted.value = granted;
    } else {
      permissionGranted.value = true;
    }
    return permissionGranted.value;
  }
  __name(ensurePermissions, "ensurePermissions");
  if (isSupported2.value) {
    if (requestPermissions)
      ensurePermissions();
    useEventListener(navigator2.mediaDevices, "devicechange", update, { passive: true });
    update();
  }
  return {
    devices,
    ensurePermissions,
    permissionGranted,
    videoInputs,
    audioInputs,
    audioOutputs,
    isSupported: isSupported2
  };
}
__name(useDevicesList, "useDevicesList");
function useDisplayMedia(options = {}) {
  var _a;
  const enabled = shallowRef((_a = options.enabled) != null ? _a : false);
  const video = options.video;
  const audio = options.audio;
  const { navigator: navigator2 = defaultNavigator } = options;
  const isSupported2 = useSupported(() => {
    var _a2;
    return (_a2 = navigator2 == null ? void 0 : navigator2.mediaDevices) == null ? void 0 : _a2.getDisplayMedia;
  });
  const constraint = { audio, video };
  const stream = shallowRef();
  async function _start() {
    var _a2;
    if (!isSupported2.value || stream.value)
      return;
    stream.value = await navigator2.mediaDevices.getDisplayMedia(constraint);
    (_a2 = stream.value) == null ? void 0 : _a2.getTracks().forEach((t2) => useEventListener(t2, "ended", stop, { passive: true }));
    return stream.value;
  }
  __name(_start, "_start");
  async function _stop() {
    var _a2;
    (_a2 = stream.value) == null ? void 0 : _a2.getTracks().forEach((t2) => t2.stop());
    stream.value = void 0;
  }
  __name(_stop, "_stop");
  function stop() {
    _stop();
    enabled.value = false;
  }
  __name(stop, "stop");
  async function start() {
    await _start();
    if (stream.value)
      enabled.value = true;
    return stream.value;
  }
  __name(start, "start");
  watch(
    enabled,
    (v) => {
      if (v)
        _start();
      else
        _stop();
    },
    { immediate: true }
  );
  return {
    isSupported: isSupported2,
    stream,
    start,
    stop,
    enabled
  };
}
__name(useDisplayMedia, "useDisplayMedia");
function useDocumentVisibility(options = {}) {
  const { document: document2 = defaultDocument } = options;
  if (!document2)
    return shallowRef("visible");
  const visibility = shallowRef(document2.visibilityState);
  useEventListener(document2, "visibilitychange", () => {
    visibility.value = document2.visibilityState;
  }, { passive: true });
  return visibility;
}
__name(useDocumentVisibility, "useDocumentVisibility");
function useDraggable(target, options = {}) {
  var _a;
  const {
    pointerTypes,
    preventDefault: preventDefault2,
    stopPropagation,
    exact,
    onMove,
    onEnd,
    onStart,
    initialValue,
    axis = "both",
    draggingElement = defaultWindow,
    containerElement,
    handle: draggingHandle = target,
    buttons = [0]
  } = options;
  const position = ref(
    (_a = toValue$2(initialValue)) != null ? _a : { x: 0, y: 0 }
  );
  const pressedDelta = ref();
  const filterEvent = /* @__PURE__ */ __name((e) => {
    if (pointerTypes)
      return pointerTypes.includes(e.pointerType);
    return true;
  }, "filterEvent");
  const handleEvent = /* @__PURE__ */ __name((e) => {
    if (toValue$2(preventDefault2))
      e.preventDefault();
    if (toValue$2(stopPropagation))
      e.stopPropagation();
  }, "handleEvent");
  const start = /* @__PURE__ */ __name((e) => {
    var _a2;
    if (!toValue$2(buttons).includes(e.button))
      return;
    if (toValue$2(options.disabled) || !filterEvent(e))
      return;
    if (toValue$2(exact) && e.target !== toValue$2(target))
      return;
    const container = toValue$2(containerElement);
    const containerRect = (_a2 = container == null ? void 0 : container.getBoundingClientRect) == null ? void 0 : _a2.call(container);
    const targetRect = toValue$2(target).getBoundingClientRect();
    const pos = {
      x: e.clientX - (container ? targetRect.left - containerRect.left + container.scrollLeft : targetRect.left),
      y: e.clientY - (container ? targetRect.top - containerRect.top + container.scrollTop : targetRect.top)
    };
    if ((onStart == null ? void 0 : onStart(pos, e)) === false)
      return;
    pressedDelta.value = pos;
    handleEvent(e);
  }, "start");
  const move = /* @__PURE__ */ __name((e) => {
    if (toValue$2(options.disabled) || !filterEvent(e))
      return;
    if (!pressedDelta.value)
      return;
    const container = toValue$2(containerElement);
    const targetRect = toValue$2(target).getBoundingClientRect();
    let { x, y } = position.value;
    if (axis === "x" || axis === "both") {
      x = e.clientX - pressedDelta.value.x;
      if (container)
        x = Math.min(Math.max(0, x), container.scrollWidth - targetRect.width);
    }
    if (axis === "y" || axis === "both") {
      y = e.clientY - pressedDelta.value.y;
      if (container)
        y = Math.min(Math.max(0, y), container.scrollHeight - targetRect.height);
    }
    position.value = {
      x,
      y
    };
    onMove == null ? void 0 : onMove(position.value, e);
    handleEvent(e);
  }, "move");
  const end = /* @__PURE__ */ __name((e) => {
    if (toValue$2(options.disabled) || !filterEvent(e))
      return;
    if (!pressedDelta.value)
      return;
    pressedDelta.value = void 0;
    onEnd == null ? void 0 : onEnd(position.value, e);
    handleEvent(e);
  }, "end");
  if (isClient) {
    const config2 = /* @__PURE__ */ __name(() => {
      var _a2;
      return {
        capture: (_a2 = options.capture) != null ? _a2 : true,
        passive: !toValue$2(preventDefault2)
      };
    }, "config");
    useEventListener(draggingHandle, "pointerdown", start, config2);
    useEventListener(draggingElement, "pointermove", move, config2);
    useEventListener(draggingElement, "pointerup", end, config2);
  }
  return {
    ...toRefs(position),
    position,
    isDragging: computed(() => !!pressedDelta.value),
    style: computed(
      () => `left:${position.value.x}px;top:${position.value.y}px;`
    )
  };
}
__name(useDraggable, "useDraggable");
function useDropZone(target, options = {}) {
  var _a, _b;
  const isOverDropZone = shallowRef(false);
  const files = shallowRef(null);
  let counter = 0;
  let isValid = true;
  if (isClient) {
    const _options = typeof options === "function" ? { onDrop: options } : options;
    const multiple = (_a = _options.multiple) != null ? _a : true;
    const preventDefaultForUnhandled = (_b = _options.preventDefaultForUnhandled) != null ? _b : false;
    const getFiles = /* @__PURE__ */ __name((event) => {
      var _a2, _b2;
      const list = Array.from((_b2 = (_a2 = event.dataTransfer) == null ? void 0 : _a2.files) != null ? _b2 : []);
      return list.length === 0 ? null : multiple ? list : [list[0]];
    }, "getFiles");
    const checkDataTypes = /* @__PURE__ */ __name((types) => {
      const dataTypes = unref(_options.dataTypes);
      if (typeof dataTypes === "function")
        return dataTypes(types);
      if (!(dataTypes == null ? void 0 : dataTypes.length))
        return true;
      if (types.length === 0)
        return false;
      return types.every(
        (type) => dataTypes.some((allowedType) => type.includes(allowedType))
      );
    }, "checkDataTypes");
    const checkValidity = /* @__PURE__ */ __name((items) => {
      const types = Array.from(items != null ? items : []).map((item) => item.type);
      const dataTypesValid = checkDataTypes(types);
      const multipleFilesValid = multiple || items.length <= 1;
      return dataTypesValid && multipleFilesValid;
    }, "checkValidity");
    const isSafari = /* @__PURE__ */ __name(() => /^(?:(?!chrome|android).)*safari/i.test(navigator.userAgent) && !("chrome" in window), "isSafari");
    const handleDragEvent = /* @__PURE__ */ __name((event, eventType) => {
      var _a2, _b2, _c, _d, _e, _f;
      const dataTransferItemList = (_a2 = event.dataTransfer) == null ? void 0 : _a2.items;
      isValid = (_b2 = dataTransferItemList && checkValidity(dataTransferItemList)) != null ? _b2 : false;
      if (preventDefaultForUnhandled) {
        event.preventDefault();
      }
      if (!isSafari() && !isValid) {
        if (event.dataTransfer) {
          event.dataTransfer.dropEffect = "none";
        }
        return;
      }
      event.preventDefault();
      if (event.dataTransfer) {
        event.dataTransfer.dropEffect = "copy";
      }
      const currentFiles = getFiles(event);
      switch (eventType) {
        case "enter":
          counter += 1;
          isOverDropZone.value = true;
          (_c = _options.onEnter) == null ? void 0 : _c.call(_options, null, event);
          break;
        case "over":
          (_d = _options.onOver) == null ? void 0 : _d.call(_options, null, event);
          break;
        case "leave":
          counter -= 1;
          if (counter === 0)
            isOverDropZone.value = false;
          (_e = _options.onLeave) == null ? void 0 : _e.call(_options, null, event);
          break;
        case "drop":
          counter = 0;
          isOverDropZone.value = false;
          if (isValid) {
            files.value = currentFiles;
            (_f = _options.onDrop) == null ? void 0 : _f.call(_options, currentFiles, event);
          }
          break;
      }
    }, "handleDragEvent");
    useEventListener(target, "dragenter", (event) => handleDragEvent(event, "enter"));
    useEventListener(target, "dragover", (event) => handleDragEvent(event, "over"));
    useEventListener(target, "dragleave", (event) => handleDragEvent(event, "leave"));
    useEventListener(target, "drop", (event) => handleDragEvent(event, "drop"));
  }
  return {
    files,
    isOverDropZone
  };
}
__name(useDropZone, "useDropZone");
function useResizeObserver(target, callback, options = {}) {
  const { window: window2 = defaultWindow, ...observerOptions } = options;
  let observer;
  const isSupported2 = useSupported(() => window2 && "ResizeObserver" in window2);
  const cleanup = /* @__PURE__ */ __name(() => {
    if (observer) {
      observer.disconnect();
      observer = void 0;
    }
  }, "cleanup");
  const targets = computed(() => {
    const _targets = toValue$2(target);
    return Array.isArray(_targets) ? _targets.map((el) => unrefElement(el)) : [unrefElement(_targets)];
  });
  const stopWatch = watch(
    targets,
    (els) => {
      cleanup();
      if (isSupported2.value && window2) {
        observer = new ResizeObserver(callback);
        for (const _el of els) {
          if (_el)
            observer.observe(_el, observerOptions);
        }
      }
    },
    { immediate: true, flush: "post" }
  );
  const stop = /* @__PURE__ */ __name(() => {
    cleanup();
    stopWatch();
  }, "stop");
  tryOnScopeDispose(stop);
  return {
    isSupported: isSupported2,
    stop
  };
}
__name(useResizeObserver, "useResizeObserver");
function useElementBounding(target, options = {}) {
  const {
    reset = true,
    windowResize = true,
    windowScroll: windowScroll2 = true,
    immediate = true,
    updateTiming = "sync"
  } = options;
  const height = shallowRef(0);
  const bottom = shallowRef(0);
  const left = shallowRef(0);
  const right = shallowRef(0);
  const top = shallowRef(0);
  const width = shallowRef(0);
  const x = shallowRef(0);
  const y = shallowRef(0);
  function recalculate() {
    const el = unrefElement(target);
    if (!el) {
      if (reset) {
        height.value = 0;
        bottom.value = 0;
        left.value = 0;
        right.value = 0;
        top.value = 0;
        width.value = 0;
        x.value = 0;
        y.value = 0;
      }
      return;
    }
    const rect = el.getBoundingClientRect();
    height.value = rect.height;
    bottom.value = rect.bottom;
    left.value = rect.left;
    right.value = rect.right;
    top.value = rect.top;
    width.value = rect.width;
    x.value = rect.x;
    y.value = rect.y;
  }
  __name(recalculate, "recalculate");
  function update() {
    if (updateTiming === "sync")
      recalculate();
    else if (updateTiming === "next-frame")
      requestAnimationFrame(() => recalculate());
  }
  __name(update, "update");
  useResizeObserver(target, update);
  watch(() => unrefElement(target), (ele) => !ele && update());
  useMutationObserver(target, update, {
    attributeFilter: ["style", "class"]
  });
  if (windowScroll2)
    useEventListener("scroll", update, { capture: true, passive: true });
  if (windowResize)
    useEventListener("resize", update, { passive: true });
  tryOnMounted(() => {
    if (immediate)
      update();
  });
  return {
    height,
    bottom,
    left,
    right,
    top,
    width,
    x,
    y,
    update
  };
}
__name(useElementBounding, "useElementBounding");
function useElementByPoint(options) {
  const {
    x,
    y,
    document: document2 = defaultDocument,
    multiple,
    interval = "requestAnimationFrame",
    immediate = true
  } = options;
  const isSupported2 = useSupported(() => {
    if (toValue$2(multiple))
      return document2 && "elementsFromPoint" in document2;
    return document2 && "elementFromPoint" in document2;
  });
  const element = shallowRef(null);
  const cb = /* @__PURE__ */ __name(() => {
    var _a, _b;
    element.value = toValue$2(multiple) ? (_a = document2 == null ? void 0 : document2.elementsFromPoint(toValue$2(x), toValue$2(y))) != null ? _a : [] : (_b = document2 == null ? void 0 : document2.elementFromPoint(toValue$2(x), toValue$2(y))) != null ? _b : null;
  }, "cb");
  const controls = interval === "requestAnimationFrame" ? useRafFn(cb, { immediate }) : useIntervalFn(cb, interval, { immediate });
  return {
    isSupported: isSupported2,
    element,
    ...controls
  };
}
__name(useElementByPoint, "useElementByPoint");
function useElementHover(el, options = {}) {
  const {
    delayEnter = 0,
    delayLeave = 0,
    triggerOnRemoval = false,
    window: window2 = defaultWindow
  } = options;
  const isHovered = shallowRef(false);
  let timer;
  const toggle = /* @__PURE__ */ __name((entering) => {
    const delay2 = entering ? delayEnter : delayLeave;
    if (timer) {
      clearTimeout(timer);
      timer = void 0;
    }
    if (delay2)
      timer = setTimeout(() => isHovered.value = entering, delay2);
    else
      isHovered.value = entering;
  }, "toggle");
  if (!window2)
    return isHovered;
  useEventListener(el, "mouseenter", () => toggle(true), { passive: true });
  useEventListener(el, "mouseleave", () => toggle(false), { passive: true });
  if (triggerOnRemoval) {
    onElementRemoval(
      computed(() => unrefElement(el)),
      () => toggle(false)
    );
  }
  return isHovered;
}
__name(useElementHover, "useElementHover");
function useElementSize(target, initialSize = { width: 0, height: 0 }, options = {}) {
  const { window: window2 = defaultWindow, box = "content-box" } = options;
  const isSVG = computed(() => {
    var _a, _b;
    return (_b = (_a = unrefElement(target)) == null ? void 0 : _a.namespaceURI) == null ? void 0 : _b.includes("svg");
  });
  const width = shallowRef(initialSize.width);
  const height = shallowRef(initialSize.height);
  const { stop: stop1 } = useResizeObserver(
    target,
    ([entry]) => {
      const boxSize = box === "border-box" ? entry.borderBoxSize : box === "content-box" ? entry.contentBoxSize : entry.devicePixelContentBoxSize;
      if (window2 && isSVG.value) {
        const $elem = unrefElement(target);
        if ($elem) {
          const rect = $elem.getBoundingClientRect();
          width.value = rect.width;
          height.value = rect.height;
        }
      } else {
        if (boxSize) {
          const formatBoxSize = toArray(boxSize);
          width.value = formatBoxSize.reduce((acc, { inlineSize }) => acc + inlineSize, 0);
          height.value = formatBoxSize.reduce((acc, { blockSize }) => acc + blockSize, 0);
        } else {
          width.value = entry.contentRect.width;
          height.value = entry.contentRect.height;
        }
      }
    },
    options
  );
  tryOnMounted(() => {
    const ele = unrefElement(target);
    if (ele) {
      width.value = "offsetWidth" in ele ? ele.offsetWidth : initialSize.width;
      height.value = "offsetHeight" in ele ? ele.offsetHeight : initialSize.height;
    }
  });
  const stop2 = watch(
    () => unrefElement(target),
    (ele) => {
      width.value = ele ? initialSize.width : 0;
      height.value = ele ? initialSize.height : 0;
    }
  );
  function stop() {
    stop1();
    stop2();
  }
  __name(stop, "stop");
  return {
    width,
    height,
    stop
  };
}
__name(useElementSize, "useElementSize");
function useIntersectionObserver(target, callback, options = {}) {
  const {
    root,
    rootMargin = "0px",
    threshold = 0,
    window: window2 = defaultWindow,
    immediate = true
  } = options;
  const isSupported2 = useSupported(() => window2 && "IntersectionObserver" in window2);
  const targets = computed(() => {
    const _target = toValue$2(target);
    return toArray(_target).map(unrefElement).filter(notNullish);
  });
  let cleanup = noop;
  const isActive = shallowRef(immediate);
  const stopWatch = isSupported2.value ? watch(
    () => [targets.value, unrefElement(root), isActive.value],
    ([targets2, root2]) => {
      cleanup();
      if (!isActive.value)
        return;
      if (!targets2.length)
        return;
      const observer = new IntersectionObserver(
        callback,
        {
          root: unrefElement(root2),
          rootMargin,
          threshold
        }
      );
      targets2.forEach((el) => el && observer.observe(el));
      cleanup = /* @__PURE__ */ __name(() => {
        observer.disconnect();
        cleanup = noop;
      }, "cleanup");
    },
    { immediate, flush: "post" }
  ) : noop;
  const stop = /* @__PURE__ */ __name(() => {
    cleanup();
    stopWatch();
    isActive.value = false;
  }, "stop");
  tryOnScopeDispose(stop);
  return {
    isSupported: isSupported2,
    isActive,
    pause() {
      cleanup();
      isActive.value = false;
    },
    resume() {
      isActive.value = true;
    },
    stop
  };
}
__name(useIntersectionObserver, "useIntersectionObserver");
function useElementVisibility(element, options = {}) {
  const {
    window: window2 = defaultWindow,
    scrollTarget,
    threshold = 0,
    rootMargin,
    once = false
  } = options;
  const elementIsVisible = shallowRef(false);
  const { stop } = useIntersectionObserver(
    element,
    (intersectionObserverEntries) => {
      let isIntersecting = elementIsVisible.value;
      let latestTime = 0;
      for (const entry of intersectionObserverEntries) {
        if (entry.time >= latestTime) {
          latestTime = entry.time;
          isIntersecting = entry.isIntersecting;
        }
      }
      elementIsVisible.value = isIntersecting;
      if (once) {
        watchOnce(elementIsVisible, () => {
          stop();
        });
      }
    },
    {
      root: scrollTarget,
      window: window2,
      threshold,
      rootMargin: toValue$2(rootMargin)
    }
  );
  return elementIsVisible;
}
__name(useElementVisibility, "useElementVisibility");
const events = /* @__PURE__ */ new Map();
function useEventBus(key) {
  const scope = getCurrentScope();
  function on(listener) {
    var _a;
    const listeners = events.get(key) || /* @__PURE__ */ new Set();
    listeners.add(listener);
    events.set(key, listeners);
    const _off = /* @__PURE__ */ __name(() => off(listener), "_off");
    (_a = scope == null ? void 0 : scope.cleanups) == null ? void 0 : _a.push(_off);
    return _off;
  }
  __name(on, "on");
  function once(listener) {
    function _listener(...args) {
      off(_listener);
      listener(...args);
    }
    __name(_listener, "_listener");
    return on(_listener);
  }
  __name(once, "once");
  function off(listener) {
    const listeners = events.get(key);
    if (!listeners)
      return;
    listeners.delete(listener);
    if (!listeners.size)
      reset();
  }
  __name(off, "off");
  function reset() {
    events.delete(key);
  }
  __name(reset, "reset");
  function emit(event, payload) {
    var _a;
    (_a = events.get(key)) == null ? void 0 : _a.forEach((v) => v(event, payload));
  }
  __name(emit, "emit");
  return { on, once, off, emit, reset };
}
__name(useEventBus, "useEventBus");
function resolveNestedOptions$1(options) {
  if (options === true)
    return {};
  return options;
}
__name(resolveNestedOptions$1, "resolveNestedOptions$1");
function useEventSource(url, events2 = [], options = {}) {
  const event = shallowRef(null);
  const data = shallowRef(null);
  const status = shallowRef("CONNECTING");
  const eventSource = ref(null);
  const error = shallowRef(null);
  const urlRef = toRef(url);
  const lastEventId = shallowRef(null);
  let explicitlyClosed = false;
  let retried = 0;
  const {
    withCredentials = false,
    immediate = true,
    autoConnect = true,
    autoReconnect
  } = options;
  const close = /* @__PURE__ */ __name(() => {
    if (isClient && eventSource.value) {
      eventSource.value.close();
      eventSource.value = null;
      status.value = "CLOSED";
      explicitlyClosed = true;
    }
  }, "close");
  const _init = /* @__PURE__ */ __name(() => {
    if (explicitlyClosed || typeof urlRef.value === "undefined")
      return;
    const es = new EventSource(urlRef.value, { withCredentials });
    status.value = "CONNECTING";
    eventSource.value = es;
    es.onopen = () => {
      status.value = "OPEN";
      error.value = null;
    };
    es.onerror = (e) => {
      status.value = "CLOSED";
      error.value = e;
      if (es.readyState === 2 && !explicitlyClosed && autoReconnect) {
        es.close();
        const {
          retries = -1,
          delay: delay2 = 1e3,
          onFailed
        } = resolveNestedOptions$1(autoReconnect);
        retried += 1;
        if (typeof retries === "number" && (retries < 0 || retried < retries))
          setTimeout(_init, delay2);
        else if (typeof retries === "function" && retries())
          setTimeout(_init, delay2);
        else
          onFailed == null ? void 0 : onFailed();
      }
    };
    es.onmessage = (e) => {
      event.value = null;
      data.value = e.data;
      lastEventId.value = e.lastEventId;
    };
    for (const event_name of events2) {
      useEventListener(es, event_name, (e) => {
        event.value = event_name;
        data.value = e.data || null;
      }, { passive: true });
    }
  }, "_init");
  const open = /* @__PURE__ */ __name(() => {
    if (!isClient)
      return;
    close();
    explicitlyClosed = false;
    retried = 0;
    _init();
  }, "open");
  if (immediate)
    open();
  if (autoConnect)
    watch(urlRef, open);
  tryOnScopeDispose(close);
  return {
    eventSource,
    event,
    data,
    status,
    error,
    open,
    close,
    lastEventId
  };
}
__name(useEventSource, "useEventSource");
function useEyeDropper(options = {}) {
  const { initialValue = "" } = options;
  const isSupported2 = useSupported(() => typeof window !== "undefined" && "EyeDropper" in window);
  const sRGBHex = shallowRef(initialValue);
  async function open(openOptions) {
    if (!isSupported2.value)
      return;
    const eyeDropper = new window.EyeDropper();
    const result = await eyeDropper.open(openOptions);
    sRGBHex.value = result.sRGBHex;
    return result;
  }
  __name(open, "open");
  return { isSupported: isSupported2, sRGBHex, open };
}
__name(useEyeDropper, "useEyeDropper");
function useFavicon(newIcon = null, options = {}) {
  const {
    baseUrl = "",
    rel = "icon",
    document: document2 = defaultDocument
  } = options;
  const favicon = toRef(newIcon);
  const applyIcon = /* @__PURE__ */ __name((icon) => {
    const elements = document2 == null ? void 0 : document2.head.querySelectorAll(`link[rel*="${rel}"]`);
    if (!elements || elements.length === 0) {
      const link = document2 == null ? void 0 : document2.createElement("link");
      if (link) {
        link.rel = rel;
        link.href = `${baseUrl}${icon}`;
        link.type = `image/${icon.split(".").pop()}`;
        document2 == null ? void 0 : document2.head.append(link);
      }
      return;
    }
    elements == null ? void 0 : elements.forEach((el) => el.href = `${baseUrl}${icon}`);
  }, "applyIcon");
  watch(
    favicon,
    (i, o) => {
      if (typeof i === "string" && i !== o)
        applyIcon(i);
    },
    { immediate: true }
  );
  return favicon;
}
__name(useFavicon, "useFavicon");
const payloadMapping = {
  json: "application/json",
  text: "text/plain"
};
function isFetchOptions(obj) {
  return obj && containsProp(obj, "immediate", "refetch", "initialData", "timeout", "beforeFetch", "afterFetch", "onFetchError", "fetch", "updateDataOnError");
}
__name(isFetchOptions, "isFetchOptions");
const reAbsolute = /^(?:[a-z][a-z\d+\-.]*:)?\/\//i;
function isAbsoluteURL(url) {
  return reAbsolute.test(url);
}
__name(isAbsoluteURL, "isAbsoluteURL");
function headersToObject(headers) {
  if (typeof Headers !== "undefined" && headers instanceof Headers)
    return Object.fromEntries(headers.entries());
  return headers;
}
__name(headersToObject, "headersToObject");
function combineCallbacks(combination, ...callbacks) {
  if (combination === "overwrite") {
    return async (ctx) => {
      let callback;
      for (let i = callbacks.length - 1; i >= 0; i--) {
        if (callbacks[i] != null) {
          callback = callbacks[i];
          break;
        }
      }
      if (callback)
        return { ...ctx, ...await callback(ctx) };
      return ctx;
    };
  } else {
    return async (ctx) => {
      for (const callback of callbacks) {
        if (callback)
          ctx = { ...ctx, ...await callback(ctx) };
      }
      return ctx;
    };
  }
}
__name(combineCallbacks, "combineCallbacks");
function createFetch(config2 = {}) {
  const _combination = config2.combination || "chain";
  const _options = config2.options || {};
  const _fetchOptions = config2.fetchOptions || {};
  function useFactoryFetch(url, ...args) {
    const computedUrl = computed(() => {
      const baseUrl = toValue$2(config2.baseUrl);
      const targetUrl = toValue$2(url);
      return baseUrl && !isAbsoluteURL(targetUrl) ? joinPaths(baseUrl, targetUrl) : targetUrl;
    });
    let options = _options;
    let fetchOptions = _fetchOptions;
    if (args.length > 0) {
      if (isFetchOptions(args[0])) {
        options = {
          ...options,
          ...args[0],
          beforeFetch: combineCallbacks(_combination, _options.beforeFetch, args[0].beforeFetch),
          afterFetch: combineCallbacks(_combination, _options.afterFetch, args[0].afterFetch),
          onFetchError: combineCallbacks(_combination, _options.onFetchError, args[0].onFetchError)
        };
      } else {
        fetchOptions = {
          ...fetchOptions,
          ...args[0],
          headers: {
            ...headersToObject(fetchOptions.headers) || {},
            ...headersToObject(args[0].headers) || {}
          }
        };
      }
    }
    if (args.length > 1 && isFetchOptions(args[1])) {
      options = {
        ...options,
        ...args[1],
        beforeFetch: combineCallbacks(_combination, _options.beforeFetch, args[1].beforeFetch),
        afterFetch: combineCallbacks(_combination, _options.afterFetch, args[1].afterFetch),
        onFetchError: combineCallbacks(_combination, _options.onFetchError, args[1].onFetchError)
      };
    }
    return useFetch(computedUrl, fetchOptions, options);
  }
  __name(useFactoryFetch, "useFactoryFetch");
  return useFactoryFetch;
}
__name(createFetch, "createFetch");
function useFetch(url, ...args) {
  var _a;
  const supportsAbort = typeof AbortController === "function";
  let fetchOptions = {};
  let options = {
    immediate: true,
    refetch: false,
    timeout: 0,
    updateDataOnError: false
  };
  const config2 = {
    method: "GET",
    type: "text",
    payload: void 0
  };
  if (args.length > 0) {
    if (isFetchOptions(args[0]))
      options = { ...options, ...args[0] };
    else
      fetchOptions = args[0];
  }
  if (args.length > 1) {
    if (isFetchOptions(args[1]))
      options = { ...options, ...args[1] };
  }
  const {
    fetch = (_a = defaultWindow) == null ? void 0 : _a.fetch,
    initialData,
    timeout: timeout2
  } = options;
  const responseEvent = createEventHook();
  const errorEvent = createEventHook();
  const finallyEvent = createEventHook();
  const isFinished = shallowRef(false);
  const isFetching = shallowRef(false);
  const aborted = shallowRef(false);
  const statusCode = shallowRef(null);
  const response = shallowRef(null);
  const error = shallowRef(null);
  const data = shallowRef(initialData || null);
  const canAbort = computed(() => supportsAbort && isFetching.value);
  let controller;
  let timer;
  const abort = /* @__PURE__ */ __name(() => {
    if (supportsAbort) {
      controller == null ? void 0 : controller.abort();
      controller = new AbortController();
      controller.signal.onabort = () => aborted.value = true;
      fetchOptions = {
        ...fetchOptions,
        signal: controller.signal
      };
    }
  }, "abort");
  const loading = /* @__PURE__ */ __name((isLoading) => {
    isFetching.value = isLoading;
    isFinished.value = !isLoading;
  }, "loading");
  if (timeout2)
    timer = useTimeoutFn(abort, timeout2, { immediate: false });
  let executeCounter = 0;
  const execute = /* @__PURE__ */ __name(async (throwOnFailed = false) => {
    var _a2, _b;
    abort();
    loading(true);
    error.value = null;
    statusCode.value = null;
    aborted.value = false;
    executeCounter += 1;
    const currentExecuteCounter = executeCounter;
    const defaultFetchOptions = {
      method: config2.method,
      headers: {}
    };
    const payload = toValue$2(config2.payload);
    if (payload) {
      const headers = headersToObject(defaultFetchOptions.headers);
      const proto = Object.getPrototypeOf(payload);
      if (!config2.payloadType && payload && (proto === Object.prototype || Array.isArray(proto)) && !(payload instanceof FormData))
        config2.payloadType = "json";
      if (config2.payloadType)
        headers["Content-Type"] = (_a2 = payloadMapping[config2.payloadType]) != null ? _a2 : config2.payloadType;
      defaultFetchOptions.body = config2.payloadType === "json" ? JSON.stringify(payload) : payload;
    }
    let isCanceled = false;
    const context2 = {
      url: toValue$2(url),
      options: {
        ...defaultFetchOptions,
        ...fetchOptions
      },
      cancel: /* @__PURE__ */ __name(() => {
        isCanceled = true;
      }, "cancel")
    };
    if (options.beforeFetch)
      Object.assign(context2, await options.beforeFetch(context2));
    if (isCanceled || !fetch) {
      loading(false);
      return Promise.resolve(null);
    }
    let responseData = null;
    if (timer)
      timer.start();
    return fetch(
      context2.url,
      {
        ...defaultFetchOptions,
        ...context2.options,
        headers: {
          ...headersToObject(defaultFetchOptions.headers),
          ...headersToObject((_b = context2.options) == null ? void 0 : _b.headers)
        }
      }
    ).then(async (fetchResponse) => {
      response.value = fetchResponse;
      statusCode.value = fetchResponse.status;
      responseData = await fetchResponse.clone()[config2.type]();
      if (!fetchResponse.ok) {
        data.value = initialData || null;
        throw new Error(fetchResponse.statusText);
      }
      if (options.afterFetch) {
        ({ data: responseData } = await options.afterFetch({
          data: responseData,
          response: fetchResponse,
          context: context2,
          execute
        }));
      }
      data.value = responseData;
      responseEvent.trigger(fetchResponse);
      return fetchResponse;
    }).catch(async (fetchError) => {
      let errorData = fetchError.message || fetchError.name;
      if (options.onFetchError) {
        ({ error: errorData, data: responseData } = await options.onFetchError({
          data: responseData,
          error: fetchError,
          response: response.value,
          context: context2,
          execute
        }));
      }
      error.value = errorData;
      if (options.updateDataOnError)
        data.value = responseData;
      errorEvent.trigger(fetchError);
      if (throwOnFailed)
        throw fetchError;
      return null;
    }).finally(() => {
      if (currentExecuteCounter === executeCounter)
        loading(false);
      if (timer)
        timer.stop();
      finallyEvent.trigger(null);
    });
  }, "execute");
  const refetch = toRef(options.refetch);
  watch(
    [
      refetch,
      toRef(url)
    ],
    ([refetch2]) => refetch2 && execute(),
    { deep: true }
  );
  const shell = {
    isFinished: readonly(isFinished),
    isFetching: readonly(isFetching),
    statusCode,
    response,
    error,
    data,
    canAbort,
    aborted,
    abort,
    execute,
    onFetchResponse: responseEvent.on,
    onFetchError: errorEvent.on,
    onFetchFinally: finallyEvent.on,
    // method
    get: setMethod("GET"),
    put: setMethod("PUT"),
    post: setMethod("POST"),
    delete: setMethod("DELETE"),
    patch: setMethod("PATCH"),
    head: setMethod("HEAD"),
    options: setMethod("OPTIONS"),
    // type
    json: setType("json"),
    text: setType("text"),
    blob: setType("blob"),
    arrayBuffer: setType("arrayBuffer"),
    formData: setType("formData")
  };
  function setMethod(method) {
    return (payload, payloadType) => {
      if (!isFetching.value) {
        config2.method = method;
        config2.payload = payload;
        config2.payloadType = payloadType;
        if (isRef(config2.payload)) {
          watch(
            [
              refetch,
              toRef(config2.payload)
            ],
            ([refetch2]) => refetch2 && execute(),
            { deep: true }
          );
        }
        return {
          ...shell,
          then(onFulfilled, onRejected) {
            return waitUntilFinished().then(onFulfilled, onRejected);
          }
        };
      }
      return void 0;
    };
  }
  __name(setMethod, "setMethod");
  function waitUntilFinished() {
    return new Promise((resolve, reject) => {
      until(isFinished).toBe(true).then(() => resolve(shell)).catch(reject);
    });
  }
  __name(waitUntilFinished, "waitUntilFinished");
  function setType(type) {
    return () => {
      if (!isFetching.value) {
        config2.type = type;
        return {
          ...shell,
          then(onFulfilled, onRejected) {
            return waitUntilFinished().then(onFulfilled, onRejected);
          }
        };
      }
      return void 0;
    };
  }
  __name(setType, "setType");
  if (options.immediate)
    Promise.resolve().then(() => execute());
  return {
    ...shell,
    then(onFulfilled, onRejected) {
      return waitUntilFinished().then(onFulfilled, onRejected);
    }
  };
}
__name(useFetch, "useFetch");
function joinPaths(start, end) {
  if (!start.endsWith("/") && !end.startsWith("/")) {
    return `${start}/${end}`;
  }
  if (start.endsWith("/") && end.startsWith("/")) {
    return `${start.slice(0, -1)}${end}`;
  }
  return `${start}${end}`;
}
__name(joinPaths, "joinPaths");
const DEFAULT_OPTIONS = {
  multiple: true,
  accept: "*",
  reset: false,
  directory: false
};
function prepareInitialFiles(files) {
  if (!files)
    return null;
  if (files instanceof FileList)
    return files;
  const dt = new DataTransfer();
  for (const file of files) {
    dt.items.add(file);
  }
  return dt.files;
}
__name(prepareInitialFiles, "prepareInitialFiles");
function useFileDialog(options = {}) {
  const {
    document: document2 = defaultDocument
  } = options;
  const files = ref(prepareInitialFiles(options.initialFiles));
  const { on: onChange, trigger: changeTrigger } = createEventHook();
  const { on: onCancel, trigger: cancelTrigger } = createEventHook();
  let input;
  if (document2) {
    input = document2.createElement("input");
    input.type = "file";
    input.onchange = (event) => {
      const result = event.target;
      files.value = result.files;
      changeTrigger(files.value);
    };
    input.oncancel = () => {
      cancelTrigger();
    };
  }
  const reset = /* @__PURE__ */ __name(() => {
    files.value = null;
    if (input && input.value) {
      input.value = "";
      changeTrigger(null);
    }
  }, "reset");
  const open = /* @__PURE__ */ __name((localOptions) => {
    if (!input)
      return;
    const _options = {
      ...DEFAULT_OPTIONS,
      ...options,
      ...localOptions
    };
    input.multiple = _options.multiple;
    input.accept = _options.accept;
    input.webkitdirectory = _options.directory;
    if (hasOwn(_options, "capture"))
      input.capture = _options.capture;
    if (_options.reset)
      reset();
    input.click();
  }, "open");
  return {
    files: readonly(files),
    open,
    reset,
    onCancel,
    onChange
  };
}
__name(useFileDialog, "useFileDialog");
function useFileSystemAccess(options = {}) {
  const {
    window: _window = defaultWindow,
    dataType = "Text"
  } = options;
  const window2 = _window;
  const isSupported2 = useSupported(() => window2 && "showSaveFilePicker" in window2 && "showOpenFilePicker" in window2);
  const fileHandle = shallowRef();
  const data = shallowRef();
  const file = shallowRef();
  const fileName = computed(() => {
    var _a, _b;
    return (_b = (_a = file.value) == null ? void 0 : _a.name) != null ? _b : "";
  });
  const fileMIME = computed(() => {
    var _a, _b;
    return (_b = (_a = file.value) == null ? void 0 : _a.type) != null ? _b : "";
  });
  const fileSize = computed(() => {
    var _a, _b;
    return (_b = (_a = file.value) == null ? void 0 : _a.size) != null ? _b : 0;
  });
  const fileLastModified = computed(() => {
    var _a, _b;
    return (_b = (_a = file.value) == null ? void 0 : _a.lastModified) != null ? _b : 0;
  });
  async function open(_options = {}) {
    if (!isSupported2.value)
      return;
    const [handle] = await window2.showOpenFilePicker({ ...toValue$2(options), ..._options });
    fileHandle.value = handle;
    await updateData();
  }
  __name(open, "open");
  async function create(_options = {}) {
    if (!isSupported2.value)
      return;
    fileHandle.value = await window2.showSaveFilePicker({ ...options, ..._options });
    data.value = void 0;
    await updateData();
  }
  __name(create, "create");
  async function save(_options = {}) {
    if (!isSupported2.value)
      return;
    if (!fileHandle.value)
      return saveAs(_options);
    if (data.value) {
      const writableStream = await fileHandle.value.createWritable();
      await writableStream.write(data.value);
      await writableStream.close();
    }
    await updateFile();
  }
  __name(save, "save");
  async function saveAs(_options = {}) {
    if (!isSupported2.value)
      return;
    fileHandle.value = await window2.showSaveFilePicker({ ...options, ..._options });
    if (data.value) {
      const writableStream = await fileHandle.value.createWritable();
      await writableStream.write(data.value);
      await writableStream.close();
    }
    await updateFile();
  }
  __name(saveAs, "saveAs");
  async function updateFile() {
    var _a;
    file.value = await ((_a = fileHandle.value) == null ? void 0 : _a.getFile());
  }
  __name(updateFile, "updateFile");
  async function updateData() {
    var _a, _b;
    await updateFile();
    const type = toValue$2(dataType);
    if (type === "Text")
      data.value = await ((_a = file.value) == null ? void 0 : _a.text());
    else if (type === "ArrayBuffer")
      data.value = await ((_b = file.value) == null ? void 0 : _b.arrayBuffer());
    else if (type === "Blob")
      data.value = file.value;
  }
  __name(updateData, "updateData");
  watch(() => toValue$2(dataType), updateData);
  return {
    isSupported: isSupported2,
    data,
    file,
    fileName,
    fileMIME,
    fileSize,
    fileLastModified,
    open,
    create,
    save,
    saveAs,
    updateData
  };
}
__name(useFileSystemAccess, "useFileSystemAccess");
function useFocus(target, options = {}) {
  const { initialValue = false, focusVisible = false, preventScroll = false } = options;
  const innerFocused = shallowRef(false);
  const targetElement = computed(() => unrefElement(target));
  const listenerOptions = { passive: true };
  useEventListener(targetElement, "focus", (event) => {
    var _a, _b;
    if (!focusVisible || ((_b = (_a = event.target).matches) == null ? void 0 : _b.call(_a, ":focus-visible")))
      innerFocused.value = true;
  }, listenerOptions);
  useEventListener(targetElement, "blur", () => innerFocused.value = false, listenerOptions);
  const focused = computed({
    get: /* @__PURE__ */ __name(() => innerFocused.value, "get"),
    set(value) {
      var _a, _b;
      if (!value && innerFocused.value)
        (_a = targetElement.value) == null ? void 0 : _a.blur();
      else if (value && !innerFocused.value)
        (_b = targetElement.value) == null ? void 0 : _b.focus({ preventScroll });
    }
  });
  watch(
    targetElement,
    () => {
      focused.value = initialValue;
    },
    { immediate: true, flush: "post" }
  );
  return { focused };
}
__name(useFocus, "useFocus");
const EVENT_FOCUS_IN = "focusin";
const EVENT_FOCUS_OUT = "focusout";
const PSEUDO_CLASS_FOCUS_WITHIN = ":focus-within";
function useFocusWithin(target, options = {}) {
  const { window: window2 = defaultWindow } = options;
  const targetElement = computed(() => unrefElement(target));
  const _focused = shallowRef(false);
  const focused = computed(() => _focused.value);
  const activeElement = useActiveElement(options);
  if (!window2 || !activeElement.value) {
    return { focused };
  }
  const listenerOptions = { passive: true };
  useEventListener(targetElement, EVENT_FOCUS_IN, () => _focused.value = true, listenerOptions);
  useEventListener(targetElement, EVENT_FOCUS_OUT, () => {
    var _a, _b, _c;
    return _focused.value = (_c = (_b = (_a = targetElement.value) == null ? void 0 : _a.matches) == null ? void 0 : _b.call(_a, PSEUDO_CLASS_FOCUS_WITHIN)) != null ? _c : false;
  }, listenerOptions);
  return { focused };
}
__name(useFocusWithin, "useFocusWithin");
function useFps(options) {
  var _a;
  const fps = shallowRef(0);
  if (typeof performance === "undefined")
    return fps;
  const every = (_a = options == null ? void 0 : options.every) != null ? _a : 10;
  let last = performance.now();
  let ticks = 0;
  useRafFn(() => {
    ticks += 1;
    if (ticks >= every) {
      const now2 = performance.now();
      const diff = now2 - last;
      fps.value = Math.round(1e3 / (diff / ticks));
      last = now2;
      ticks = 0;
    }
  });
  return fps;
}
__name(useFps, "useFps");
const eventHandlers = [
  "fullscreenchange",
  "webkitfullscreenchange",
  "webkitendfullscreen",
  "mozfullscreenchange",
  "MSFullscreenChange"
];
function useFullscreen(target, options = {}) {
  const {
    document: document2 = defaultDocument,
    autoExit = false
  } = options;
  const targetRef = computed(() => {
    var _a;
    return (_a = unrefElement(target)) != null ? _a : document2 == null ? void 0 : document2.documentElement;
  });
  const isFullscreen = shallowRef(false);
  const requestMethod = computed(() => {
    return [
      "requestFullscreen",
      "webkitRequestFullscreen",
      "webkitEnterFullscreen",
      "webkitEnterFullScreen",
      "webkitRequestFullScreen",
      "mozRequestFullScreen",
      "msRequestFullscreen"
    ].find((m) => document2 && m in document2 || targetRef.value && m in targetRef.value);
  });
  const exitMethod = computed(() => {
    return [
      "exitFullscreen",
      "webkitExitFullscreen",
      "webkitExitFullScreen",
      "webkitCancelFullScreen",
      "mozCancelFullScreen",
      "msExitFullscreen"
    ].find((m) => document2 && m in document2 || targetRef.value && m in targetRef.value);
  });
  const fullscreenEnabled = computed(() => {
    return [
      "fullScreen",
      "webkitIsFullScreen",
      "webkitDisplayingFullscreen",
      "mozFullScreen",
      "msFullscreenElement"
    ].find((m) => document2 && m in document2 || targetRef.value && m in targetRef.value);
  });
  const fullscreenElementMethod = [
    "fullscreenElement",
    "webkitFullscreenElement",
    "mozFullScreenElement",
    "msFullscreenElement"
  ].find((m) => document2 && m in document2);
  const isSupported2 = useSupported(() => targetRef.value && document2 && requestMethod.value !== void 0 && exitMethod.value !== void 0 && fullscreenEnabled.value !== void 0);
  const isCurrentElementFullScreen = /* @__PURE__ */ __name(() => {
    if (fullscreenElementMethod)
      return (document2 == null ? void 0 : document2[fullscreenElementMethod]) === targetRef.value;
    return false;
  }, "isCurrentElementFullScreen");
  const isElementFullScreen = /* @__PURE__ */ __name(() => {
    if (fullscreenEnabled.value) {
      if (document2 && document2[fullscreenEnabled.value] != null) {
        return document2[fullscreenEnabled.value];
      } else {
        const target2 = targetRef.value;
        if ((target2 == null ? void 0 : target2[fullscreenEnabled.value]) != null) {
          return Boolean(target2[fullscreenEnabled.value]);
        }
      }
    }
    return false;
  }, "isElementFullScreen");
  async function exit() {
    if (!isSupported2.value || !isFullscreen.value)
      return;
    if (exitMethod.value) {
      if ((document2 == null ? void 0 : document2[exitMethod.value]) != null) {
        await document2[exitMethod.value]();
      } else {
        const target2 = targetRef.value;
        if ((target2 == null ? void 0 : target2[exitMethod.value]) != null)
          await target2[exitMethod.value]();
      }
    }
    isFullscreen.value = false;
  }
  __name(exit, "exit");
  async function enter() {
    if (!isSupported2.value || isFullscreen.value)
      return;
    if (isElementFullScreen())
      await exit();
    const target2 = targetRef.value;
    if (requestMethod.value && (target2 == null ? void 0 : target2[requestMethod.value]) != null) {
      await target2[requestMethod.value]();
      isFullscreen.value = true;
    }
  }
  __name(enter, "enter");
  async function toggle() {
    await (isFullscreen.value ? exit() : enter());
  }
  __name(toggle, "toggle");
  const handlerCallback = /* @__PURE__ */ __name(() => {
    const isElementFullScreenValue = isElementFullScreen();
    if (!isElementFullScreenValue || isElementFullScreenValue && isCurrentElementFullScreen())
      isFullscreen.value = isElementFullScreenValue;
  }, "handlerCallback");
  const listenerOptions = { capture: false, passive: true };
  useEventListener(document2, eventHandlers, handlerCallback, listenerOptions);
  useEventListener(() => unrefElement(targetRef), eventHandlers, handlerCallback, listenerOptions);
  if (autoExit)
    tryOnScopeDispose(exit);
  return {
    isSupported: isSupported2,
    isFullscreen,
    enter,
    exit,
    toggle
  };
}
__name(useFullscreen, "useFullscreen");
function mapGamepadToXbox360Controller(gamepad) {
  return computed(() => {
    if (gamepad.value) {
      return {
        buttons: {
          a: gamepad.value.buttons[0],
          b: gamepad.value.buttons[1],
          x: gamepad.value.buttons[2],
          y: gamepad.value.buttons[3]
        },
        bumper: {
          left: gamepad.value.buttons[4],
          right: gamepad.value.buttons[5]
        },
        triggers: {
          left: gamepad.value.buttons[6],
          right: gamepad.value.buttons[7]
        },
        stick: {
          left: {
            horizontal: gamepad.value.axes[0],
            vertical: gamepad.value.axes[1],
            button: gamepad.value.buttons[10]
          },
          right: {
            horizontal: gamepad.value.axes[2],
            vertical: gamepad.value.axes[3],
            button: gamepad.value.buttons[11]
          }
        },
        dpad: {
          up: gamepad.value.buttons[12],
          down: gamepad.value.buttons[13],
          left: gamepad.value.buttons[14],
          right: gamepad.value.buttons[15]
        },
        back: gamepad.value.buttons[8],
        start: gamepad.value.buttons[9]
      };
    }
    return null;
  });
}
__name(mapGamepadToXbox360Controller, "mapGamepadToXbox360Controller");
function useGamepad(options = {}) {
  const {
    navigator: navigator2 = defaultNavigator
  } = options;
  const isSupported2 = useSupported(() => navigator2 && "getGamepads" in navigator2);
  const gamepads = ref([]);
  const onConnectedHook = createEventHook();
  const onDisconnectedHook = createEventHook();
  const stateFromGamepad = /* @__PURE__ */ __name((gamepad) => {
    const hapticActuators = [];
    const vibrationActuator = "vibrationActuator" in gamepad ? gamepad.vibrationActuator : null;
    if (vibrationActuator)
      hapticActuators.push(vibrationActuator);
    if (gamepad.hapticActuators)
      hapticActuators.push(...gamepad.hapticActuators);
    return {
      id: gamepad.id,
      index: gamepad.index,
      connected: gamepad.connected,
      mapping: gamepad.mapping,
      timestamp: gamepad.timestamp,
      vibrationActuator: gamepad.vibrationActuator,
      hapticActuators,
      axes: gamepad.axes.map((axes) => axes),
      buttons: gamepad.buttons.map((button) => ({ pressed: button.pressed, touched: button.touched, value: button.value }))
    };
  }, "stateFromGamepad");
  const updateGamepadState = /* @__PURE__ */ __name(() => {
    const _gamepads = (navigator2 == null ? void 0 : navigator2.getGamepads()) || [];
    for (const gamepad of _gamepads) {
      if (gamepad && gamepads.value[gamepad.index])
        gamepads.value[gamepad.index] = stateFromGamepad(gamepad);
    }
  }, "updateGamepadState");
  const { isActive, pause, resume } = useRafFn(updateGamepadState);
  const onGamepadConnected = /* @__PURE__ */ __name((gamepad) => {
    if (!gamepads.value.some(({ index }) => index === gamepad.index)) {
      gamepads.value.push(stateFromGamepad(gamepad));
      onConnectedHook.trigger(gamepad.index);
    }
    resume();
  }, "onGamepadConnected");
  const onGamepadDisconnected = /* @__PURE__ */ __name((gamepad) => {
    gamepads.value = gamepads.value.filter((x) => x.index !== gamepad.index);
    onDisconnectedHook.trigger(gamepad.index);
  }, "onGamepadDisconnected");
  const listenerOptions = { passive: true };
  useEventListener("gamepadconnected", (e) => onGamepadConnected(e.gamepad), listenerOptions);
  useEventListener("gamepaddisconnected", (e) => onGamepadDisconnected(e.gamepad), listenerOptions);
  tryOnMounted(() => {
    const _gamepads = (navigator2 == null ? void 0 : navigator2.getGamepads()) || [];
    for (const gamepad of _gamepads) {
      if (gamepad && gamepads.value[gamepad.index])
        onGamepadConnected(gamepad);
    }
  });
  pause();
  return {
    isSupported: isSupported2,
    onConnected: onConnectedHook.on,
    onDisconnected: onDisconnectedHook.on,
    gamepads,
    pause,
    resume,
    isActive
  };
}
__name(useGamepad, "useGamepad");
function useGeolocation(options = {}) {
  const {
    enableHighAccuracy = true,
    maximumAge = 3e4,
    timeout: timeout2 = 27e3,
    navigator: navigator2 = defaultNavigator,
    immediate = true
  } = options;
  const isSupported2 = useSupported(() => navigator2 && "geolocation" in navigator2);
  const locatedAt = shallowRef(null);
  const error = shallowRef(null);
  const coords = ref({
    accuracy: 0,
    latitude: Number.POSITIVE_INFINITY,
    longitude: Number.POSITIVE_INFINITY,
    altitude: null,
    altitudeAccuracy: null,
    heading: null,
    speed: null
  });
  function updatePosition(position) {
    locatedAt.value = position.timestamp;
    coords.value = position.coords;
    error.value = null;
  }
  __name(updatePosition, "updatePosition");
  let watcher;
  function resume() {
    if (isSupported2.value) {
      watcher = navigator2.geolocation.watchPosition(
        updatePosition,
        (err) => error.value = err,
        {
          enableHighAccuracy,
          maximumAge,
          timeout: timeout2
        }
      );
    }
  }
  __name(resume, "resume");
  if (immediate)
    resume();
  function pause() {
    if (watcher && navigator2)
      navigator2.geolocation.clearWatch(watcher);
  }
  __name(pause, "pause");
  tryOnScopeDispose(() => {
    pause();
  });
  return {
    isSupported: isSupported2,
    coords,
    locatedAt,
    error,
    resume,
    pause
  };
}
__name(useGeolocation, "useGeolocation");
const defaultEvents$1 = ["mousemove", "mousedown", "resize", "keydown", "touchstart", "wheel"];
const oneMinute = 6e4;
function useIdle(timeout2 = oneMinute, options = {}) {
  const {
    initialState = false,
    listenForVisibilityChange = true,
    events: events2 = defaultEvents$1,
    window: window2 = defaultWindow,
    eventFilter = throttleFilter(50)
  } = options;
  const idle = shallowRef(initialState);
  const lastActive = shallowRef(timestamp());
  let timer;
  const reset = /* @__PURE__ */ __name(() => {
    idle.value = false;
    clearTimeout(timer);
    timer = setTimeout(() => idle.value = true, timeout2);
  }, "reset");
  const onEvent = createFilterWrapper(
    eventFilter,
    () => {
      lastActive.value = timestamp();
      reset();
    }
  );
  if (window2) {
    const document2 = window2.document;
    const listenerOptions = { passive: true };
    for (const event of events2)
      useEventListener(window2, event, onEvent, listenerOptions);
    if (listenForVisibilityChange) {
      useEventListener(document2, "visibilitychange", () => {
        if (!document2.hidden)
          onEvent();
      }, listenerOptions);
    }
    reset();
  }
  return {
    idle,
    lastActive,
    reset
  };
}
__name(useIdle, "useIdle");
async function loadImage(options) {
  return new Promise((resolve, reject) => {
    const img = new Image();
    const { src, srcset, sizes, class: clazz, loading, crossorigin, referrerPolicy, width, height, decoding, fetchPriority, ismap, usemap } = options;
    img.src = src;
    if (srcset != null)
      img.srcset = srcset;
    if (sizes != null)
      img.sizes = sizes;
    if (clazz != null)
      img.className = clazz;
    if (loading != null)
      img.loading = loading;
    if (crossorigin != null)
      img.crossOrigin = crossorigin;
    if (referrerPolicy != null)
      img.referrerPolicy = referrerPolicy;
    if (width != null)
      img.width = width;
    if (height != null)
      img.height = height;
    if (decoding != null)
      img.decoding = decoding;
    if (fetchPriority != null)
      img.fetchPriority = fetchPriority;
    if (ismap != null)
      img.isMap = ismap;
    if (usemap != null)
      img.useMap = usemap;
    img.onload = () => resolve(img);
    img.onerror = reject;
  });
}
__name(loadImage, "loadImage");
function useImage(options, asyncStateOptions = {}) {
  const state = useAsyncState(
    () => loadImage(toValue$2(options)),
    void 0,
    {
      resetOnExecute: true,
      ...asyncStateOptions
    }
  );
  watch(
    () => toValue$2(options),
    () => state.execute(asyncStateOptions.delay),
    { deep: true }
  );
  return state;
}
__name(useImage, "useImage");
function resolveElement(el) {
  if (typeof Window !== "undefined" && el instanceof Window)
    return el.document.documentElement;
  if (typeof Document !== "undefined" && el instanceof Document)
    return el.documentElement;
  return el;
}
__name(resolveElement, "resolveElement");
const ARRIVED_STATE_THRESHOLD_PIXELS = 1;
function useScroll(element, options = {}) {
  const {
    throttle: throttle2 = 0,
    idle = 200,
    onStop = noop,
    onScroll = noop,
    offset: offset2 = {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    eventListenerOptions = {
      capture: false,
      passive: true
    },
    behavior = "auto",
    window: window2 = defaultWindow,
    onError = /* @__PURE__ */ __name((e) => {
      console.error(e);
    }, "onError")
  } = options;
  const internalX = shallowRef(0);
  const internalY = shallowRef(0);
  const x = computed({
    get() {
      return internalX.value;
    },
    set(x2) {
      scrollTo(x2, void 0);
    }
  });
  const y = computed({
    get() {
      return internalY.value;
    },
    set(y2) {
      scrollTo(void 0, y2);
    }
  });
  function scrollTo(_x, _y) {
    var _a, _b, _c, _d;
    if (!window2)
      return;
    const _element = toValue$2(element);
    if (!_element)
      return;
    (_c = _element instanceof Document ? window2.document.body : _element) == null ? void 0 : _c.scrollTo({
      top: (_a = toValue$2(_y)) != null ? _a : y.value,
      left: (_b = toValue$2(_x)) != null ? _b : x.value,
      behavior: toValue$2(behavior)
    });
    const scrollContainer = ((_d = _element == null ? void 0 : _element.document) == null ? void 0 : _d.documentElement) || (_element == null ? void 0 : _element.documentElement) || _element;
    if (x != null)
      internalX.value = scrollContainer.scrollLeft;
    if (y != null)
      internalY.value = scrollContainer.scrollTop;
  }
  __name(scrollTo, "scrollTo");
  const isScrolling = shallowRef(false);
  const arrivedState = reactive({
    left: true,
    right: false,
    top: true,
    bottom: false
  });
  const directions = reactive({
    left: false,
    right: false,
    top: false,
    bottom: false
  });
  const onScrollEnd = /* @__PURE__ */ __name((e) => {
    if (!isScrolling.value)
      return;
    isScrolling.value = false;
    directions.left = false;
    directions.right = false;
    directions.top = false;
    directions.bottom = false;
    onStop(e);
  }, "onScrollEnd");
  const onScrollEndDebounced = useDebounceFn(onScrollEnd, throttle2 + idle);
  const setArrivedState = /* @__PURE__ */ __name((target) => {
    var _a;
    if (!window2)
      return;
    const el = ((_a = target == null ? void 0 : target.document) == null ? void 0 : _a.documentElement) || (target == null ? void 0 : target.documentElement) || unrefElement(target);
    const { display, flexDirection, direction } = getComputedStyle(el);
    const directionMultipler = direction === "rtl" ? -1 : 1;
    const scrollLeft = el.scrollLeft;
    directions.left = scrollLeft < internalX.value;
    directions.right = scrollLeft > internalX.value;
    const left = Math.abs(scrollLeft * directionMultipler) <= (offset2.left || 0);
    const right = Math.abs(scrollLeft * directionMultipler) + el.clientWidth >= el.scrollWidth - (offset2.right || 0) - ARRIVED_STATE_THRESHOLD_PIXELS;
    if (display === "flex" && flexDirection === "row-reverse") {
      arrivedState.left = right;
      arrivedState.right = left;
    } else {
      arrivedState.left = left;
      arrivedState.right = right;
    }
    internalX.value = scrollLeft;
    let scrollTop = el.scrollTop;
    if (target === window2.document && !scrollTop)
      scrollTop = window2.document.body.scrollTop;
    directions.top = scrollTop < internalY.value;
    directions.bottom = scrollTop > internalY.value;
    const top = Math.abs(scrollTop) <= (offset2.top || 0);
    const bottom = Math.abs(scrollTop) + el.clientHeight >= el.scrollHeight - (offset2.bottom || 0) - ARRIVED_STATE_THRESHOLD_PIXELS;
    if (display === "flex" && flexDirection === "column-reverse") {
      arrivedState.top = bottom;
      arrivedState.bottom = top;
    } else {
      arrivedState.top = top;
      arrivedState.bottom = bottom;
    }
    internalY.value = scrollTop;
  }, "setArrivedState");
  const onScrollHandler = /* @__PURE__ */ __name((e) => {
    var _a;
    if (!window2)
      return;
    const eventTarget = (_a = e.target.documentElement) != null ? _a : e.target;
    setArrivedState(eventTarget);
    isScrolling.value = true;
    onScrollEndDebounced(e);
    onScroll(e);
  }, "onScrollHandler");
  useEventListener(
    element,
    "scroll",
    throttle2 ? useThrottleFn(onScrollHandler, throttle2, true, false) : onScrollHandler,
    eventListenerOptions
  );
  tryOnMounted(() => {
    try {
      const _element = toValue$2(element);
      if (!_element)
        return;
      setArrivedState(_element);
    } catch (e) {
      onError(e);
    }
  });
  useEventListener(
    element,
    "scrollend",
    onScrollEnd,
    eventListenerOptions
  );
  return {
    x,
    y,
    isScrolling,
    arrivedState,
    directions,
    measure() {
      const _element = toValue$2(element);
      if (window2 && _element)
        setArrivedState(_element);
    }
  };
}
__name(useScroll, "useScroll");
function useInfiniteScroll(element, onLoadMore, options = {}) {
  var _a;
  const {
    direction = "bottom",
    interval = 100,
    canLoadMore = /* @__PURE__ */ __name(() => true, "canLoadMore")
  } = options;
  const state = reactive(useScroll(
    element,
    {
      ...options,
      offset: {
        [direction]: (_a = options.distance) != null ? _a : 0,
        ...options.offset
      }
    }
  ));
  const promise = ref();
  const isLoading = computed(() => !!promise.value);
  const observedElement = computed(() => {
    return resolveElement(toValue$2(element));
  });
  const isElementVisible = useElementVisibility(observedElement);
  function checkAndLoad() {
    state.measure();
    if (!observedElement.value || !isElementVisible.value || !canLoadMore(observedElement.value))
      return;
    const { scrollHeight, clientHeight, scrollWidth, clientWidth } = observedElement.value;
    const isNarrower = direction === "bottom" || direction === "top" ? scrollHeight <= clientHeight : scrollWidth <= clientWidth;
    if (state.arrivedState[direction] || isNarrower) {
      if (!promise.value) {
        promise.value = Promise.all([
          onLoadMore(state),
          new Promise((resolve) => setTimeout(resolve, interval))
        ]).finally(() => {
          promise.value = null;
          nextTick(() => checkAndLoad());
        });
      }
    }
  }
  __name(checkAndLoad, "checkAndLoad");
  const stop = watch(
    () => [state.arrivedState[direction], isElementVisible.value],
    checkAndLoad,
    { immediate: true }
  );
  tryOnUnmounted(stop);
  return {
    isLoading,
    reset() {
      nextTick(() => checkAndLoad());
    }
  };
}
__name(useInfiniteScroll, "useInfiniteScroll");
const defaultEvents = ["mousedown", "mouseup", "keydown", "keyup"];
function useKeyModifier(modifier, options = {}) {
  const {
    events: events2 = defaultEvents,
    document: document2 = defaultDocument,
    initial = null
  } = options;
  const state = shallowRef(initial);
  if (document2) {
    events2.forEach((listenerEvent) => {
      useEventListener(document2, listenerEvent, (evt) => {
        if (typeof evt.getModifierState === "function")
          state.value = evt.getModifierState(modifier);
      }, { passive: true });
    });
  }
  return state;
}
__name(useKeyModifier, "useKeyModifier");
function useLocalStorage(key, initialValue, options = {}) {
  const { window: window2 = defaultWindow } = options;
  return useStorage(key, initialValue, window2 == null ? void 0 : window2.localStorage, options);
}
__name(useLocalStorage, "useLocalStorage");
const DefaultMagicKeysAliasMap = {
  ctrl: "control",
  command: "meta",
  cmd: "meta",
  option: "alt",
  up: "arrowup",
  down: "arrowdown",
  left: "arrowleft",
  right: "arrowright"
};
function useMagicKeys(options = {}) {
  const {
    reactive: useReactive = false,
    target = defaultWindow,
    aliasMap: aliasMap2 = DefaultMagicKeysAliasMap,
    passive = true,
    onEventFired = noop
  } = options;
  const current = reactive(/* @__PURE__ */ new Set());
  const obj = {
    toJSON() {
      return {};
    },
    current
  };
  const refs = useReactive ? reactive(obj) : obj;
  const metaDeps = /* @__PURE__ */ new Set();
  const usedKeys = /* @__PURE__ */ new Set();
  function setRefs(key, value) {
    if (key in refs) {
      if (useReactive)
        refs[key] = value;
      else
        refs[key].value = value;
    }
  }
  __name(setRefs, "setRefs");
  function reset() {
    current.clear();
    for (const key of usedKeys)
      setRefs(key, false);
  }
  __name(reset, "reset");
  function updateRefs(e, value) {
    var _a, _b;
    const key = (_a = e.key) == null ? void 0 : _a.toLowerCase();
    const code = (_b = e.code) == null ? void 0 : _b.toLowerCase();
    const values = [code, key].filter(Boolean);
    if (key) {
      if (value)
        current.add(key);
      else
        current.delete(key);
    }
    for (const key2 of values) {
      usedKeys.add(key2);
      setRefs(key2, value);
    }
    if (key === "meta" && !value) {
      metaDeps.forEach((key2) => {
        current.delete(key2);
        setRefs(key2, false);
      });
      metaDeps.clear();
    } else if (typeof e.getModifierState === "function" && e.getModifierState("Meta") && value) {
      [...current, ...values].forEach((key2) => metaDeps.add(key2));
    }
  }
  __name(updateRefs, "updateRefs");
  useEventListener(target, "keydown", (e) => {
    updateRefs(e, true);
    return onEventFired(e);
  }, { passive });
  useEventListener(target, "keyup", (e) => {
    updateRefs(e, false);
    return onEventFired(e);
  }, { passive });
  useEventListener("blur", reset, { passive });
  useEventListener("focus", reset, { passive });
  const proxy = new Proxy(
    refs,
    {
      get(target2, prop, rec) {
        if (typeof prop !== "string")
          return Reflect.get(target2, prop, rec);
        prop = prop.toLowerCase();
        if (prop in aliasMap2)
          prop = aliasMap2[prop];
        if (!(prop in refs)) {
          if (/[+_-]/.test(prop)) {
            const keys2 = prop.split(/[+_-]/g).map((i) => i.trim());
            refs[prop] = computed(() => keys2.map((key) => toValue$2(proxy[key])).every(Boolean));
          } else {
            refs[prop] = shallowRef(false);
          }
        }
        const r2 = Reflect.get(target2, prop, rec);
        return useReactive ? toValue$2(r2) : r2;
      }
    }
  );
  return proxy;
}
__name(useMagicKeys, "useMagicKeys");
function usingElRef(source, cb) {
  if (toValue$2(source))
    cb(toValue$2(source));
}
__name(usingElRef, "usingElRef");
function timeRangeToArray(timeRanges) {
  let ranges = [];
  for (let i = 0; i < timeRanges.length; ++i)
    ranges = [...ranges, [timeRanges.start(i), timeRanges.end(i)]];
  return ranges;
}
__name(timeRangeToArray, "timeRangeToArray");
function tracksToArray(tracks) {
  return Array.from(tracks).map(({ label, kind, language, mode, activeCues, cues, inBandMetadataTrackDispatchType }, id) => ({ id, label, kind, language, mode, activeCues, cues, inBandMetadataTrackDispatchType }));
}
__name(tracksToArray, "tracksToArray");
const defaultOptions = {
  src: "",
  tracks: []
};
function useMediaControls(target, options = {}) {
  target = toRef(target);
  options = {
    ...defaultOptions,
    ...options
  };
  const {
    document: document2 = defaultDocument
  } = options;
  const listenerOptions = { passive: true };
  const currentTime = shallowRef(0);
  const duration = shallowRef(0);
  const seeking = shallowRef(false);
  const volume = shallowRef(1);
  const waiting = shallowRef(false);
  const ended = shallowRef(false);
  const playing = shallowRef(false);
  const rate = shallowRef(1);
  const stalled = shallowRef(false);
  const buffered = ref([]);
  const tracks = ref([]);
  const selectedTrack = shallowRef(-1);
  const isPictureInPicture = shallowRef(false);
  const muted = shallowRef(false);
  const supportsPictureInPicture = document2 && "pictureInPictureEnabled" in document2;
  const sourceErrorEvent = createEventHook();
  const playbackErrorEvent = createEventHook();
  const disableTrack = /* @__PURE__ */ __name((track) => {
    usingElRef(target, (el) => {
      if (track) {
        const id = typeof track === "number" ? track : track.id;
        el.textTracks[id].mode = "disabled";
      } else {
        for (let i = 0; i < el.textTracks.length; ++i)
          el.textTracks[i].mode = "disabled";
      }
      selectedTrack.value = -1;
    });
  }, "disableTrack");
  const enableTrack = /* @__PURE__ */ __name((track, disableTracks = true) => {
    usingElRef(target, (el) => {
      const id = typeof track === "number" ? track : track.id;
      if (disableTracks)
        disableTrack();
      el.textTracks[id].mode = "showing";
      selectedTrack.value = id;
    });
  }, "enableTrack");
  const togglePictureInPicture = /* @__PURE__ */ __name(() => {
    return new Promise((resolve, reject) => {
      usingElRef(target, async (el) => {
        if (supportsPictureInPicture) {
          if (!isPictureInPicture.value) {
            el.requestPictureInPicture().then(resolve).catch(reject);
          } else {
            document2.exitPictureInPicture().then(resolve).catch(reject);
          }
        }
      });
    });
  }, "togglePictureInPicture");
  watchEffect(() => {
    if (!document2)
      return;
    const el = toValue$2(target);
    if (!el)
      return;
    const src = toValue$2(options.src);
    let sources = [];
    if (!src)
      return;
    if (typeof src === "string")
      sources = [{ src }];
    else if (Array.isArray(src))
      sources = src;
    else if (isObject(src))
      sources = [src];
    el.querySelectorAll("source").forEach((e) => {
      e.remove();
    });
    sources.forEach(({ src: src2, type, media }) => {
      const source = document2.createElement("source");
      source.setAttribute("src", src2);
      source.setAttribute("type", type || "");
      source.setAttribute("media", media || "");
      useEventListener(source, "error", sourceErrorEvent.trigger, listenerOptions);
      el.appendChild(source);
    });
    el.load();
  });
  watch([target, volume], () => {
    const el = toValue$2(target);
    if (!el)
      return;
    el.volume = volume.value;
  });
  watch([target, muted], () => {
    const el = toValue$2(target);
    if (!el)
      return;
    el.muted = muted.value;
  });
  watch([target, rate], () => {
    const el = toValue$2(target);
    if (!el)
      return;
    el.playbackRate = rate.value;
  });
  watchEffect(() => {
    if (!document2)
      return;
    const textTracks = toValue$2(options.tracks);
    const el = toValue$2(target);
    if (!textTracks || !textTracks.length || !el)
      return;
    el.querySelectorAll("track").forEach((e) => e.remove());
    textTracks.forEach(({ default: isDefault, kind, label, src, srcLang }, i) => {
      const track = document2.createElement("track");
      track.default = isDefault || false;
      track.kind = kind;
      track.label = label;
      track.src = src;
      track.srclang = srcLang;
      if (track.default)
        selectedTrack.value = i;
      el.appendChild(track);
    });
  });
  const { ignoreUpdates: ignoreCurrentTimeUpdates } = watchIgnorable(currentTime, (time) => {
    const el = toValue$2(target);
    if (!el)
      return;
    el.currentTime = time;
  });
  const { ignoreUpdates: ignorePlayingUpdates } = watchIgnorable(playing, (isPlaying) => {
    const el = toValue$2(target);
    if (!el)
      return;
    if (isPlaying) {
      el.play().catch((e) => {
        playbackErrorEvent.trigger(e);
        throw e;
      });
    } else {
      el.pause();
    }
  });
  useEventListener(
    target,
    "timeupdate",
    () => ignoreCurrentTimeUpdates(() => currentTime.value = toValue$2(target).currentTime),
    listenerOptions
  );
  useEventListener(
    target,
    "durationchange",
    () => duration.value = toValue$2(target).duration,
    listenerOptions
  );
  useEventListener(
    target,
    "progress",
    () => buffered.value = timeRangeToArray(toValue$2(target).buffered),
    listenerOptions
  );
  useEventListener(
    target,
    "seeking",
    () => seeking.value = true,
    listenerOptions
  );
  useEventListener(
    target,
    "seeked",
    () => seeking.value = false,
    listenerOptions
  );
  useEventListener(
    target,
    ["waiting", "loadstart"],
    () => {
      waiting.value = true;
      ignorePlayingUpdates(() => playing.value = false);
    },
    listenerOptions
  );
  useEventListener(
    target,
    "loadeddata",
    () => waiting.value = false,
    listenerOptions
  );
  useEventListener(
    target,
    "playing",
    () => {
      waiting.value = false;
      ended.value = false;
      ignorePlayingUpdates(() => playing.value = true);
    },
    listenerOptions
  );
  useEventListener(
    target,
    "ratechange",
    () => rate.value = toValue$2(target).playbackRate,
    listenerOptions
  );
  useEventListener(
    target,
    "stalled",
    () => stalled.value = true,
    listenerOptions
  );
  useEventListener(
    target,
    "ended",
    () => ended.value = true,
    listenerOptions
  );
  useEventListener(
    target,
    "pause",
    () => ignorePlayingUpdates(() => playing.value = false),
    listenerOptions
  );
  useEventListener(
    target,
    "play",
    () => ignorePlayingUpdates(() => playing.value = true),
    listenerOptions
  );
  useEventListener(
    target,
    "enterpictureinpicture",
    () => isPictureInPicture.value = true,
    listenerOptions
  );
  useEventListener(
    target,
    "leavepictureinpicture",
    () => isPictureInPicture.value = false,
    listenerOptions
  );
  useEventListener(
    target,
    "volumechange",
    () => {
      const el = toValue$2(target);
      if (!el)
        return;
      volume.value = el.volume;
      muted.value = el.muted;
    },
    listenerOptions
  );
  const listeners = [];
  const stop = watch([target], () => {
    const el = toValue$2(target);
    if (!el)
      return;
    stop();
    listeners[0] = useEventListener(el.textTracks, "addtrack", () => tracks.value = tracksToArray(el.textTracks), listenerOptions);
    listeners[1] = useEventListener(el.textTracks, "removetrack", () => tracks.value = tracksToArray(el.textTracks), listenerOptions);
    listeners[2] = useEventListener(el.textTracks, "change", () => tracks.value = tracksToArray(el.textTracks), listenerOptions);
  });
  tryOnScopeDispose(() => listeners.forEach((listener) => listener()));
  return {
    currentTime,
    duration,
    waiting,
    seeking,
    ended,
    stalled,
    buffered,
    playing,
    rate,
    // Volume
    volume,
    muted,
    // Tracks
    tracks,
    selectedTrack,
    enableTrack,
    disableTrack,
    // Picture in Picture
    supportsPictureInPicture,
    togglePictureInPicture,
    isPictureInPicture,
    // Events
    onSourceError: sourceErrorEvent.on,
    onPlaybackError: playbackErrorEvent.on
  };
}
__name(useMediaControls, "useMediaControls");
function useMemoize(resolver, options) {
  const initCache = /* @__PURE__ */ __name(() => {
    if (options == null ? void 0 : options.cache)
      return shallowReactive(options.cache);
    return shallowReactive(/* @__PURE__ */ new Map());
  }, "initCache");
  const cache = initCache();
  const generateKey = /* @__PURE__ */ __name((...args) => (options == null ? void 0 : options.getKey) ? options.getKey(...args) : JSON.stringify(args), "generateKey");
  const _loadData = /* @__PURE__ */ __name((key, ...args) => {
    cache.set(key, resolver(...args));
    return cache.get(key);
  }, "_loadData");
  const loadData = /* @__PURE__ */ __name((...args) => _loadData(generateKey(...args), ...args), "loadData");
  const deleteData = /* @__PURE__ */ __name((...args) => {
    cache.delete(generateKey(...args));
  }, "deleteData");
  const clearData = /* @__PURE__ */ __name(() => {
    cache.clear();
  }, "clearData");
  const memoized = /* @__PURE__ */ __name((...args) => {
    const key = generateKey(...args);
    if (cache.has(key))
      return cache.get(key);
    return _loadData(key, ...args);
  }, "memoized");
  memoized.load = loadData;
  memoized.delete = deleteData;
  memoized.clear = clearData;
  memoized.generateKey = generateKey;
  memoized.cache = cache;
  return memoized;
}
__name(useMemoize, "useMemoize");
function useMemory(options = {}) {
  const memory = ref();
  const isSupported2 = useSupported(() => typeof performance !== "undefined" && "memory" in performance);
  if (isSupported2.value) {
    const { interval = 1e3 } = options;
    useIntervalFn(() => {
      memory.value = performance.memory;
    }, interval, { immediate: options.immediate, immediateCallback: options.immediateCallback });
  }
  return { isSupported: isSupported2, memory };
}
__name(useMemory, "useMemory");
const UseMouseBuiltinExtractors = {
  page: /* @__PURE__ */ __name((event) => [event.pageX, event.pageY], "page"),
  client: /* @__PURE__ */ __name((event) => [event.clientX, event.clientY], "client"),
  screen: /* @__PURE__ */ __name((event) => [event.screenX, event.screenY], "screen"),
  movement: /* @__PURE__ */ __name((event) => event instanceof MouseEvent ? [event.movementX, event.movementY] : null, "movement")
};
function useMouse(options = {}) {
  const {
    type = "page",
    touch = true,
    resetOnTouchEnds = false,
    initialValue = { x: 0, y: 0 },
    window: window2 = defaultWindow,
    target = window2,
    scroll = true,
    eventFilter
  } = options;
  let _prevMouseEvent = null;
  let _prevScrollX = 0;
  let _prevScrollY = 0;
  const x = shallowRef(initialValue.x);
  const y = shallowRef(initialValue.y);
  const sourceType = shallowRef(null);
  const extractor = typeof type === "function" ? type : UseMouseBuiltinExtractors[type];
  const mouseHandler = /* @__PURE__ */ __name((event) => {
    const result = extractor(event);
    _prevMouseEvent = event;
    if (result) {
      [x.value, y.value] = result;
      sourceType.value = "mouse";
    }
    if (window2) {
      _prevScrollX = window2.scrollX;
      _prevScrollY = window2.scrollY;
    }
  }, "mouseHandler");
  const touchHandler = /* @__PURE__ */ __name((event) => {
    if (event.touches.length > 0) {
      const result = extractor(event.touches[0]);
      if (result) {
        [x.value, y.value] = result;
        sourceType.value = "touch";
      }
    }
  }, "touchHandler");
  const scrollHandler = /* @__PURE__ */ __name(() => {
    if (!_prevMouseEvent || !window2)
      return;
    const pos = extractor(_prevMouseEvent);
    if (_prevMouseEvent instanceof MouseEvent && pos) {
      x.value = pos[0] + window2.scrollX - _prevScrollX;
      y.value = pos[1] + window2.scrollY - _prevScrollY;
    }
  }, "scrollHandler");
  const reset = /* @__PURE__ */ __name(() => {
    x.value = initialValue.x;
    y.value = initialValue.y;
  }, "reset");
  const mouseHandlerWrapper = eventFilter ? (event) => eventFilter(() => mouseHandler(event), {}) : (event) => mouseHandler(event);
  const touchHandlerWrapper = eventFilter ? (event) => eventFilter(() => touchHandler(event), {}) : (event) => touchHandler(event);
  const scrollHandlerWrapper = eventFilter ? () => eventFilter(() => scrollHandler(), {}) : () => scrollHandler();
  if (target) {
    const listenerOptions = { passive: true };
    useEventListener(target, ["mousemove", "dragover"], mouseHandlerWrapper, listenerOptions);
    if (touch && type !== "movement") {
      useEventListener(target, ["touchstart", "touchmove"], touchHandlerWrapper, listenerOptions);
      if (resetOnTouchEnds)
        useEventListener(target, "touchend", reset, listenerOptions);
    }
    if (scroll && type === "page")
      useEventListener(window2, "scroll", scrollHandlerWrapper, listenerOptions);
  }
  return {
    x,
    y,
    sourceType
  };
}
__name(useMouse, "useMouse");
function useMouseInElement(target, options = {}) {
  const {
    handleOutside = true,
    window: window2 = defaultWindow
  } = options;
  const type = options.type || "page";
  const { x, y, sourceType } = useMouse(options);
  const targetRef = shallowRef(target != null ? target : window2 == null ? void 0 : window2.document.body);
  const elementX = shallowRef(0);
  const elementY = shallowRef(0);
  const elementPositionX = shallowRef(0);
  const elementPositionY = shallowRef(0);
  const elementHeight = shallowRef(0);
  const elementWidth = shallowRef(0);
  const isOutside = shallowRef(true);
  let stop = /* @__PURE__ */ __name(() => {
  }, "stop");
  if (window2) {
    stop = watch(
      [targetRef, x, y],
      () => {
        const el = unrefElement(targetRef);
        if (!el || !(el instanceof Element))
          return;
        const {
          left,
          top,
          width,
          height
        } = el.getBoundingClientRect();
        elementPositionX.value = left + (type === "page" ? window2.pageXOffset : 0);
        elementPositionY.value = top + (type === "page" ? window2.pageYOffset : 0);
        elementHeight.value = height;
        elementWidth.value = width;
        const elX = x.value - elementPositionX.value;
        const elY = y.value - elementPositionY.value;
        isOutside.value = width === 0 || height === 0 || elX < 0 || elY < 0 || elX > width || elY > height;
        if (handleOutside || !isOutside.value) {
          elementX.value = elX;
          elementY.value = elY;
        }
      },
      { immediate: true }
    );
    useEventListener(
      document,
      "mouseleave",
      () => isOutside.value = true,
      { passive: true }
    );
  }
  return {
    x,
    y,
    sourceType,
    elementX,
    elementY,
    elementPositionX,
    elementPositionY,
    elementHeight,
    elementWidth,
    isOutside,
    stop
  };
}
__name(useMouseInElement, "useMouseInElement");
function useMousePressed(options = {}) {
  const {
    touch = true,
    drag = true,
    capture = false,
    initialValue = false,
    window: window2 = defaultWindow
  } = options;
  const pressed = shallowRef(initialValue);
  const sourceType = shallowRef(null);
  if (!window2) {
    return {
      pressed,
      sourceType
    };
  }
  const onPressed = /* @__PURE__ */ __name((srcType) => (event) => {
    var _a;
    pressed.value = true;
    sourceType.value = srcType;
    (_a = options.onPressed) == null ? void 0 : _a.call(options, event);
  }, "onPressed");
  const onReleased = /* @__PURE__ */ __name((event) => {
    var _a;
    pressed.value = false;
    sourceType.value = null;
    (_a = options.onReleased) == null ? void 0 : _a.call(options, event);
  }, "onReleased");
  const target = computed(() => unrefElement(options.target) || window2);
  const listenerOptions = { passive: true, capture };
  useEventListener(target, "mousedown", onPressed("mouse"), listenerOptions);
  useEventListener(window2, "mouseleave", onReleased, listenerOptions);
  useEventListener(window2, "mouseup", onReleased, listenerOptions);
  if (drag) {
    useEventListener(target, "dragstart", onPressed("mouse"), listenerOptions);
    useEventListener(window2, "drop", onReleased, listenerOptions);
    useEventListener(window2, "dragend", onReleased, listenerOptions);
  }
  if (touch) {
    useEventListener(target, "touchstart", onPressed("touch"), listenerOptions);
    useEventListener(window2, "touchend", onReleased, listenerOptions);
    useEventListener(window2, "touchcancel", onReleased, listenerOptions);
  }
  return {
    pressed,
    sourceType
  };
}
__name(useMousePressed, "useMousePressed");
function useNavigatorLanguage(options = {}) {
  const { window: window2 = defaultWindow } = options;
  const navigator2 = window2 == null ? void 0 : window2.navigator;
  const isSupported2 = useSupported(() => navigator2 && "language" in navigator2);
  const language = shallowRef(navigator2 == null ? void 0 : navigator2.language);
  useEventListener(window2, "languagechange", () => {
    if (navigator2)
      language.value = navigator2.language;
  }, { passive: true });
  return {
    isSupported: isSupported2,
    language
  };
}
__name(useNavigatorLanguage, "useNavigatorLanguage");
function useNetwork(options = {}) {
  const { window: window2 = defaultWindow } = options;
  const navigator2 = window2 == null ? void 0 : window2.navigator;
  const isSupported2 = useSupported(() => navigator2 && "connection" in navigator2);
  const isOnline = shallowRef(true);
  const saveData = shallowRef(false);
  const offlineAt = shallowRef(void 0);
  const onlineAt = shallowRef(void 0);
  const downlink = shallowRef(void 0);
  const downlinkMax = shallowRef(void 0);
  const rtt = shallowRef(void 0);
  const effectiveType = shallowRef(void 0);
  const type = shallowRef("unknown");
  const connection = isSupported2.value && navigator2.connection;
  function updateNetworkInformation() {
    if (!navigator2)
      return;
    isOnline.value = navigator2.onLine;
    offlineAt.value = isOnline.value ? void 0 : Date.now();
    onlineAt.value = isOnline.value ? Date.now() : void 0;
    if (connection) {
      downlink.value = connection.downlink;
      downlinkMax.value = connection.downlinkMax;
      effectiveType.value = connection.effectiveType;
      rtt.value = connection.rtt;
      saveData.value = connection.saveData;
      type.value = connection.type;
    }
  }
  __name(updateNetworkInformation, "updateNetworkInformation");
  const listenerOptions = { passive: true };
  if (window2) {
    useEventListener(window2, "offline", () => {
      isOnline.value = false;
      offlineAt.value = Date.now();
    }, listenerOptions);
    useEventListener(window2, "online", () => {
      isOnline.value = true;
      onlineAt.value = Date.now();
    }, listenerOptions);
  }
  if (connection)
    useEventListener(connection, "change", updateNetworkInformation, listenerOptions);
  updateNetworkInformation();
  return {
    isSupported: isSupported2,
    isOnline: readonly(isOnline),
    saveData: readonly(saveData),
    offlineAt: readonly(offlineAt),
    onlineAt: readonly(onlineAt),
    downlink: readonly(downlink),
    downlinkMax: readonly(downlinkMax),
    effectiveType: readonly(effectiveType),
    rtt: readonly(rtt),
    type: readonly(type)
  };
}
__name(useNetwork, "useNetwork");
function useNow(options = {}) {
  const {
    controls: exposeControls = false,
    interval = "requestAnimationFrame"
  } = options;
  const now2 = ref(/* @__PURE__ */ new Date());
  const update = /* @__PURE__ */ __name(() => now2.value = /* @__PURE__ */ new Date(), "update");
  const controls = interval === "requestAnimationFrame" ? useRafFn(update, { immediate: true }) : useIntervalFn(update, interval, { immediate: true });
  if (exposeControls) {
    return {
      now: now2,
      ...controls
    };
  } else {
    return now2;
  }
}
__name(useNow, "useNow");
function useObjectUrl(object) {
  const url = shallowRef();
  const release = /* @__PURE__ */ __name(() => {
    if (url.value)
      URL.revokeObjectURL(url.value);
    url.value = void 0;
  }, "release");
  watch(
    () => toValue$2(object),
    (newObject) => {
      release();
      if (newObject)
        url.value = URL.createObjectURL(newObject);
    },
    { immediate: true }
  );
  tryOnScopeDispose(release);
  return readonly(url);
}
__name(useObjectUrl, "useObjectUrl");
function useClamp(value, min2, max2) {
  if (typeof value === "function" || isReadonly(value))
    return computed(() => clamp$1(toValue$2(value), toValue$2(min2), toValue$2(max2)));
  const _value = ref(value);
  return computed({
    get() {
      return _value.value = clamp$1(_value.value, toValue$2(min2), toValue$2(max2));
    },
    set(value2) {
      _value.value = clamp$1(value2, toValue$2(min2), toValue$2(max2));
    }
  });
}
__name(useClamp, "useClamp");
function useOffsetPagination(options) {
  const {
    total = Number.POSITIVE_INFINITY,
    pageSize = 10,
    page = 1,
    onPageChange = noop,
    onPageSizeChange = noop,
    onPageCountChange = noop
  } = options;
  const currentPageSize = useClamp(pageSize, 1, Number.POSITIVE_INFINITY);
  const pageCount = computed(() => Math.max(
    1,
    Math.ceil(toValue$2(total) / toValue$2(currentPageSize))
  ));
  const currentPage = useClamp(page, 1, pageCount);
  const isFirstPage = computed(() => currentPage.value === 1);
  const isLastPage = computed(() => currentPage.value === pageCount.value);
  if (isRef(page)) {
    syncRef(page, currentPage, {
      direction: isReadonly(page) ? "ltr" : "both"
    });
  }
  if (isRef(pageSize)) {
    syncRef(pageSize, currentPageSize, {
      direction: isReadonly(pageSize) ? "ltr" : "both"
    });
  }
  function prev() {
    currentPage.value--;
  }
  __name(prev, "prev");
  function next() {
    currentPage.value++;
  }
  __name(next, "next");
  const returnValue = {
    currentPage,
    currentPageSize,
    pageCount,
    isFirstPage,
    isLastPage,
    prev,
    next
  };
  watch(currentPage, () => {
    onPageChange(reactive(returnValue));
  });
  watch(currentPageSize, () => {
    onPageSizeChange(reactive(returnValue));
  });
  watch(pageCount, () => {
    onPageCountChange(reactive(returnValue));
  });
  return returnValue;
}
__name(useOffsetPagination, "useOffsetPagination");
function useOnline(options = {}) {
  const { isOnline } = useNetwork(options);
  return isOnline;
}
__name(useOnline, "useOnline");
function usePageLeave(options = {}) {
  const { window: window2 = defaultWindow } = options;
  const isLeft = shallowRef(false);
  const handler = /* @__PURE__ */ __name((event) => {
    if (!window2)
      return;
    event = event || window2.event;
    const from = event.relatedTarget || event.toElement;
    isLeft.value = !from;
  }, "handler");
  if (window2) {
    const listenerOptions = { passive: true };
    useEventListener(window2, "mouseout", handler, listenerOptions);
    useEventListener(window2.document, "mouseleave", handler, listenerOptions);
    useEventListener(window2.document, "mouseenter", handler, listenerOptions);
  }
  return isLeft;
}
__name(usePageLeave, "usePageLeave");
function useScreenOrientation(options = {}) {
  const {
    window: window2 = defaultWindow
  } = options;
  const isSupported2 = useSupported(() => window2 && "screen" in window2 && "orientation" in window2.screen);
  const screenOrientation = isSupported2.value ? window2.screen.orientation : {};
  const orientation = ref(screenOrientation.type);
  const angle = shallowRef(screenOrientation.angle || 0);
  if (isSupported2.value) {
    useEventListener(window2, "orientationchange", () => {
      orientation.value = screenOrientation.type;
      angle.value = screenOrientation.angle;
    }, { passive: true });
  }
  const lockOrientation = /* @__PURE__ */ __name((type) => {
    if (isSupported2.value && typeof screenOrientation.lock === "function")
      return screenOrientation.lock(type);
    return Promise.reject(new Error("Not supported"));
  }, "lockOrientation");
  const unlockOrientation = /* @__PURE__ */ __name(() => {
    if (isSupported2.value && typeof screenOrientation.unlock === "function")
      screenOrientation.unlock();
  }, "unlockOrientation");
  return {
    isSupported: isSupported2,
    orientation,
    angle,
    lockOrientation,
    unlockOrientation
  };
}
__name(useScreenOrientation, "useScreenOrientation");
function useParallax(target, options = {}) {
  const {
    deviceOrientationTiltAdjust = /* @__PURE__ */ __name((i) => i, "deviceOrientationTiltAdjust"),
    deviceOrientationRollAdjust = /* @__PURE__ */ __name((i) => i, "deviceOrientationRollAdjust"),
    mouseTiltAdjust = /* @__PURE__ */ __name((i) => i, "mouseTiltAdjust"),
    mouseRollAdjust = /* @__PURE__ */ __name((i) => i, "mouseRollAdjust"),
    window: window2 = defaultWindow
  } = options;
  const orientation = reactive(useDeviceOrientation({ window: window2 }));
  const screenOrientation = reactive(useScreenOrientation({ window: window2 }));
  const {
    elementX: x,
    elementY: y,
    elementWidth: width,
    elementHeight: height
  } = useMouseInElement(target, { handleOutside: false, window: window2 });
  const source = computed(() => {
    if (orientation.isSupported && (orientation.alpha != null && orientation.alpha !== 0 || orientation.gamma != null && orientation.gamma !== 0)) {
      return "deviceOrientation";
    }
    return "mouse";
  });
  const roll = computed(() => {
    if (source.value === "deviceOrientation") {
      let value;
      switch (screenOrientation.orientation) {
        case "landscape-primary":
          value = orientation.gamma / 90;
          break;
        case "landscape-secondary":
          value = -orientation.gamma / 90;
          break;
        case "portrait-primary":
          value = -orientation.beta / 90;
          break;
        case "portrait-secondary":
          value = orientation.beta / 90;
          break;
        default:
          value = -orientation.beta / 90;
      }
      return deviceOrientationRollAdjust(value);
    } else {
      const value = -(y.value - height.value / 2) / height.value;
      return mouseRollAdjust(value);
    }
  });
  const tilt = computed(() => {
    if (source.value === "deviceOrientation") {
      let value;
      switch (screenOrientation.orientation) {
        case "landscape-primary":
          value = orientation.beta / 90;
          break;
        case "landscape-secondary":
          value = -orientation.beta / 90;
          break;
        case "portrait-primary":
          value = orientation.gamma / 90;
          break;
        case "portrait-secondary":
          value = -orientation.gamma / 90;
          break;
        default:
          value = orientation.gamma / 90;
      }
      return deviceOrientationTiltAdjust(value);
    } else {
      const value = (x.value - width.value / 2) / width.value;
      return mouseTiltAdjust(value);
    }
  });
  return { roll, tilt, source };
}
__name(useParallax, "useParallax");
function useParentElement(element = useCurrentElement()) {
  const parentElement = shallowRef();
  const update = /* @__PURE__ */ __name(() => {
    const el = unrefElement(element);
    if (el)
      parentElement.value = el.parentElement;
  }, "update");
  tryOnMounted(update);
  watch(() => toValue$2(element), update);
  return parentElement;
}
__name(useParentElement, "useParentElement");
function usePerformanceObserver(options, callback) {
  const {
    window: window2 = defaultWindow,
    immediate = true,
    ...performanceOptions
  } = options;
  const isSupported2 = useSupported(() => window2 && "PerformanceObserver" in window2);
  let observer;
  const stop = /* @__PURE__ */ __name(() => {
    observer == null ? void 0 : observer.disconnect();
  }, "stop");
  const start = /* @__PURE__ */ __name(() => {
    if (isSupported2.value) {
      stop();
      observer = new PerformanceObserver(callback);
      observer.observe(performanceOptions);
    }
  }, "start");
  tryOnScopeDispose(stop);
  if (immediate)
    start();
  return {
    isSupported: isSupported2,
    start,
    stop
  };
}
__name(usePerformanceObserver, "usePerformanceObserver");
const defaultState = {
  x: 0,
  y: 0,
  pointerId: 0,
  pressure: 0,
  tiltX: 0,
  tiltY: 0,
  width: 0,
  height: 0,
  twist: 0,
  pointerType: null
};
const keys = /* @__PURE__ */ Object.keys(defaultState);
function usePointer(options = {}) {
  const {
    target = defaultWindow
  } = options;
  const isInside = shallowRef(false);
  const state = ref(options.initialValue || {});
  Object.assign(state.value, defaultState, state.value);
  const handler = /* @__PURE__ */ __name((event) => {
    isInside.value = true;
    if (options.pointerTypes && !options.pointerTypes.includes(event.pointerType))
      return;
    state.value = objectPick(event, keys, false);
  }, "handler");
  if (target) {
    const listenerOptions = { passive: true };
    useEventListener(target, ["pointerdown", "pointermove", "pointerup"], handler, listenerOptions);
    useEventListener(target, "pointerleave", () => isInside.value = false, listenerOptions);
  }
  return {
    ...toRefs(state),
    isInside
  };
}
__name(usePointer, "usePointer");
function usePointerLock(target, options = {}) {
  const { document: document2 = defaultDocument } = options;
  const isSupported2 = useSupported(() => document2 && "pointerLockElement" in document2);
  const element = shallowRef();
  const triggerElement = shallowRef();
  let targetElement;
  if (isSupported2.value) {
    const listenerOptions = { passive: true };
    useEventListener(document2, "pointerlockchange", () => {
      var _a;
      const currentElement = (_a = document2.pointerLockElement) != null ? _a : element.value;
      if (targetElement && currentElement === targetElement) {
        element.value = document2.pointerLockElement;
        if (!element.value)
          targetElement = triggerElement.value = null;
      }
    }, listenerOptions);
    useEventListener(document2, "pointerlockerror", () => {
      var _a;
      const currentElement = (_a = document2.pointerLockElement) != null ? _a : element.value;
      if (targetElement && currentElement === targetElement) {
        const action = document2.pointerLockElement ? "release" : "acquire";
        throw new Error(`Failed to ${action} pointer lock.`);
      }
    }, listenerOptions);
  }
  async function lock(e) {
    var _a;
    if (!isSupported2.value)
      throw new Error("Pointer Lock API is not supported by your browser.");
    triggerElement.value = e instanceof Event ? e.currentTarget : null;
    targetElement = e instanceof Event ? (_a = unrefElement(target)) != null ? _a : triggerElement.value : unrefElement(e);
    if (!targetElement)
      throw new Error("Target element undefined.");
    targetElement.requestPointerLock();
    return await until(element).toBe(targetElement);
  }
  __name(lock, "lock");
  async function unlock() {
    if (!element.value)
      return false;
    document2.exitPointerLock();
    await until(element).toBeNull();
    return true;
  }
  __name(unlock, "unlock");
  return {
    isSupported: isSupported2,
    element,
    triggerElement,
    lock,
    unlock
  };
}
__name(usePointerLock, "usePointerLock");
function usePointerSwipe(target, options = {}) {
  const targetRef = toRef(target);
  const {
    threshold = 50,
    onSwipe,
    onSwipeEnd,
    onSwipeStart,
    disableTextSelect = false
  } = options;
  const posStart = reactive({ x: 0, y: 0 });
  const updatePosStart = /* @__PURE__ */ __name((x, y) => {
    posStart.x = x;
    posStart.y = y;
  }, "updatePosStart");
  const posEnd = reactive({ x: 0, y: 0 });
  const updatePosEnd = /* @__PURE__ */ __name((x, y) => {
    posEnd.x = x;
    posEnd.y = y;
  }, "updatePosEnd");
  const distanceX = computed(() => posStart.x - posEnd.x);
  const distanceY = computed(() => posStart.y - posEnd.y);
  const { max: max2, abs } = Math;
  const isThresholdExceeded = computed(() => max2(abs(distanceX.value), abs(distanceY.value)) >= threshold);
  const isSwiping = shallowRef(false);
  const isPointerDown2 = shallowRef(false);
  const direction = computed(() => {
    if (!isThresholdExceeded.value)
      return "none";
    if (abs(distanceX.value) > abs(distanceY.value)) {
      return distanceX.value > 0 ? "left" : "right";
    } else {
      return distanceY.value > 0 ? "up" : "down";
    }
  });
  const eventIsAllowed = /* @__PURE__ */ __name((e) => {
    var _a, _b, _c;
    const isReleasingButton = e.buttons === 0;
    const isPrimaryButton = e.buttons === 1;
    return (_c = (_b = (_a = options.pointerTypes) == null ? void 0 : _a.includes(e.pointerType)) != null ? _b : isReleasingButton || isPrimaryButton) != null ? _c : true;
  }, "eventIsAllowed");
  const listenerOptions = { passive: true };
  const stops = [
    useEventListener(target, "pointerdown", (e) => {
      if (!eventIsAllowed(e))
        return;
      isPointerDown2.value = true;
      const eventTarget = e.target;
      eventTarget == null ? void 0 : eventTarget.setPointerCapture(e.pointerId);
      const { clientX: x, clientY: y } = e;
      updatePosStart(x, y);
      updatePosEnd(x, y);
      onSwipeStart == null ? void 0 : onSwipeStart(e);
    }, listenerOptions),
    useEventListener(target, "pointermove", (e) => {
      if (!eventIsAllowed(e))
        return;
      if (!isPointerDown2.value)
        return;
      const { clientX: x, clientY: y } = e;
      updatePosEnd(x, y);
      if (!isSwiping.value && isThresholdExceeded.value)
        isSwiping.value = true;
      if (isSwiping.value)
        onSwipe == null ? void 0 : onSwipe(e);
    }, listenerOptions),
    useEventListener(target, "pointerup", (e) => {
      if (!eventIsAllowed(e))
        return;
      if (isSwiping.value)
        onSwipeEnd == null ? void 0 : onSwipeEnd(e, direction.value);
      isPointerDown2.value = false;
      isSwiping.value = false;
    }, listenerOptions)
  ];
  tryOnMounted(() => {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    (_b = (_a = targetRef.value) == null ? void 0 : _a.style) == null ? void 0 : _b.setProperty("touch-action", "none");
    if (disableTextSelect) {
      (_d = (_c = targetRef.value) == null ? void 0 : _c.style) == null ? void 0 : _d.setProperty("-webkit-user-select", "none");
      (_f = (_e = targetRef.value) == null ? void 0 : _e.style) == null ? void 0 : _f.setProperty("-ms-user-select", "none");
      (_h = (_g = targetRef.value) == null ? void 0 : _g.style) == null ? void 0 : _h.setProperty("user-select", "none");
    }
  });
  const stop = /* @__PURE__ */ __name(() => stops.forEach((s) => s()), "stop");
  return {
    isSwiping: readonly(isSwiping),
    direction: readonly(direction),
    posStart: readonly(posStart),
    posEnd: readonly(posEnd),
    distanceX,
    distanceY,
    stop
  };
}
__name(usePointerSwipe, "usePointerSwipe");
function usePreferredColorScheme(options) {
  const isLight = useMediaQuery("(prefers-color-scheme: light)", options);
  const isDark = useMediaQuery("(prefers-color-scheme: dark)", options);
  return computed(() => {
    if (isDark.value)
      return "dark";
    if (isLight.value)
      return "light";
    return "no-preference";
  });
}
__name(usePreferredColorScheme, "usePreferredColorScheme");
function usePreferredContrast(options) {
  const isMore = useMediaQuery("(prefers-contrast: more)", options);
  const isLess = useMediaQuery("(prefers-contrast: less)", options);
  const isCustom = useMediaQuery("(prefers-contrast: custom)", options);
  return computed(() => {
    if (isMore.value)
      return "more";
    if (isLess.value)
      return "less";
    if (isCustom.value)
      return "custom";
    return "no-preference";
  });
}
__name(usePreferredContrast, "usePreferredContrast");
function usePreferredLanguages(options = {}) {
  const { window: window2 = defaultWindow } = options;
  if (!window2)
    return ref(["en"]);
  const navigator2 = window2.navigator;
  const value = ref(navigator2.languages);
  useEventListener(window2, "languagechange", () => {
    value.value = navigator2.languages;
  }, { passive: true });
  return value;
}
__name(usePreferredLanguages, "usePreferredLanguages");
function usePreferredReducedMotion(options) {
  const isReduced = useMediaQuery("(prefers-reduced-motion: reduce)", options);
  return computed(() => {
    if (isReduced.value)
      return "reduce";
    return "no-preference";
  });
}
__name(usePreferredReducedMotion, "usePreferredReducedMotion");
function usePreferredReducedTransparency(options) {
  const isReduced = useMediaQuery("(prefers-reduced-transparency: reduce)", options);
  return computed(() => {
    if (isReduced.value)
      return "reduce";
    return "no-preference";
  });
}
__name(usePreferredReducedTransparency, "usePreferredReducedTransparency");
function usePrevious(value, initialValue) {
  const previous = shallowRef(initialValue);
  watch(
    toRef(value),
    (_, oldValue) => {
      previous.value = oldValue;
    },
    { flush: "sync" }
  );
  return readonly(previous);
}
__name(usePrevious, "usePrevious");
const topVarName = "--vueuse-safe-area-top";
const rightVarName = "--vueuse-safe-area-right";
const bottomVarName = "--vueuse-safe-area-bottom";
const leftVarName = "--vueuse-safe-area-left";
function useScreenSafeArea() {
  const top = shallowRef("");
  const right = shallowRef("");
  const bottom = shallowRef("");
  const left = shallowRef("");
  if (isClient) {
    const topCssVar = useCssVar(topVarName);
    const rightCssVar = useCssVar(rightVarName);
    const bottomCssVar = useCssVar(bottomVarName);
    const leftCssVar = useCssVar(leftVarName);
    topCssVar.value = "env(safe-area-inset-top, 0px)";
    rightCssVar.value = "env(safe-area-inset-right, 0px)";
    bottomCssVar.value = "env(safe-area-inset-bottom, 0px)";
    leftCssVar.value = "env(safe-area-inset-left, 0px)";
    update();
    useEventListener("resize", useDebounceFn(update), { passive: true });
  }
  function update() {
    top.value = getValue(topVarName);
    right.value = getValue(rightVarName);
    bottom.value = getValue(bottomVarName);
    left.value = getValue(leftVarName);
  }
  __name(update, "update");
  return {
    top,
    right,
    bottom,
    left,
    update
  };
}
__name(useScreenSafeArea, "useScreenSafeArea");
function getValue(position) {
  return getComputedStyle(document.documentElement).getPropertyValue(position);
}
__name(getValue, "getValue");
function useScriptTag(src, onLoaded = noop, options = {}) {
  const {
    immediate = true,
    manual = false,
    type = "text/javascript",
    async = true,
    crossOrigin,
    referrerPolicy,
    noModule,
    defer,
    document: document2 = defaultDocument,
    attrs = {}
  } = options;
  const scriptTag = shallowRef(null);
  let _promise = null;
  const loadScript = /* @__PURE__ */ __name((waitForScriptLoad) => new Promise((resolve, reject) => {
    const resolveWithElement = /* @__PURE__ */ __name((el2) => {
      scriptTag.value = el2;
      resolve(el2);
      return el2;
    }, "resolveWithElement");
    if (!document2) {
      resolve(false);
      return;
    }
    let shouldAppend = false;
    let el = document2.querySelector(`script[src="${toValue$2(src)}"]`);
    if (!el) {
      el = document2.createElement("script");
      el.type = type;
      el.async = async;
      el.src = toValue$2(src);
      if (defer)
        el.defer = defer;
      if (crossOrigin)
        el.crossOrigin = crossOrigin;
      if (noModule)
        el.noModule = noModule;
      if (referrerPolicy)
        el.referrerPolicy = referrerPolicy;
      Object.entries(attrs).forEach(([name, value]) => el == null ? void 0 : el.setAttribute(name, value));
      shouldAppend = true;
    } else if (el.hasAttribute("data-loaded")) {
      resolveWithElement(el);
    }
    const listenerOptions = {
      passive: true
    };
    useEventListener(el, "error", (event) => reject(event), listenerOptions);
    useEventListener(el, "abort", (event) => reject(event), listenerOptions);
    useEventListener(el, "load", () => {
      el.setAttribute("data-loaded", "true");
      onLoaded(el);
      resolveWithElement(el);
    }, listenerOptions);
    if (shouldAppend)
      el = document2.head.appendChild(el);
    if (!waitForScriptLoad)
      resolveWithElement(el);
  }), "loadScript");
  const load = /* @__PURE__ */ __name((waitForScriptLoad = true) => {
    if (!_promise)
      _promise = loadScript(waitForScriptLoad);
    return _promise;
  }, "load");
  const unload = /* @__PURE__ */ __name(() => {
    if (!document2)
      return;
    _promise = null;
    if (scriptTag.value)
      scriptTag.value = null;
    const el = document2.querySelector(`script[src="${toValue$2(src)}"]`);
    if (el)
      document2.head.removeChild(el);
  }, "unload");
  if (immediate && !manual)
    tryOnMounted(load);
  if (!manual)
    tryOnUnmounted(unload);
  return { scriptTag, load, unload };
}
__name(useScriptTag, "useScriptTag");
function checkOverflowScroll$1(ele) {
  const style = window.getComputedStyle(ele);
  if (style.overflowX === "scroll" || style.overflowY === "scroll" || style.overflowX === "auto" && ele.clientWidth < ele.scrollWidth || style.overflowY === "auto" && ele.clientHeight < ele.scrollHeight) {
    return true;
  } else {
    const parent = ele.parentNode;
    if (!parent || parent.tagName === "BODY")
      return false;
    return checkOverflowScroll$1(parent);
  }
}
__name(checkOverflowScroll$1, "checkOverflowScroll$1");
function preventDefault$1(rawEvent) {
  const e = rawEvent || window.event;
  const _target = e.target;
  if (checkOverflowScroll$1(_target))
    return false;
  if (e.touches.length > 1)
    return true;
  if (e.preventDefault)
    e.preventDefault();
  return false;
}
__name(preventDefault$1, "preventDefault$1");
const elInitialOverflow = /* @__PURE__ */ new WeakMap();
function useScrollLock(element, initialState = false) {
  const isLocked = shallowRef(initialState);
  let stopTouchMoveListener = null;
  let initialOverflow = "";
  watch(toRef(element), (el) => {
    const target = resolveElement(toValue$2(el));
    if (target) {
      const ele = target;
      if (!elInitialOverflow.get(ele))
        elInitialOverflow.set(ele, ele.style.overflow);
      if (ele.style.overflow !== "hidden")
        initialOverflow = ele.style.overflow;
      if (ele.style.overflow === "hidden")
        return isLocked.value = true;
      if (isLocked.value)
        return ele.style.overflow = "hidden";
    }
  }, {
    immediate: true
  });
  const lock = /* @__PURE__ */ __name(() => {
    const el = resolveElement(toValue$2(element));
    if (!el || isLocked.value)
      return;
    if (isIOS) {
      stopTouchMoveListener = useEventListener(
        el,
        "touchmove",
        (e) => {
          preventDefault$1(e);
        },
        { passive: false }
      );
    }
    el.style.overflow = "hidden";
    isLocked.value = true;
  }, "lock");
  const unlock = /* @__PURE__ */ __name(() => {
    const el = resolveElement(toValue$2(element));
    if (!el || !isLocked.value)
      return;
    if (isIOS)
      stopTouchMoveListener == null ? void 0 : stopTouchMoveListener();
    el.style.overflow = initialOverflow;
    elInitialOverflow.delete(el);
    isLocked.value = false;
  }, "unlock");
  tryOnScopeDispose(unlock);
  return computed({
    get() {
      return isLocked.value;
    },
    set(v) {
      if (v)
        lock();
      else unlock();
    }
  });
}
__name(useScrollLock, "useScrollLock");
function useSessionStorage(key, initialValue, options = {}) {
  const { window: window2 = defaultWindow } = options;
  return useStorage(key, initialValue, window2 == null ? void 0 : window2.sessionStorage, options);
}
__name(useSessionStorage, "useSessionStorage");
function useShare(shareOptions = {}, options = {}) {
  const { navigator: navigator2 = defaultNavigator } = options;
  const _navigator = navigator2;
  const isSupported2 = useSupported(() => _navigator && "canShare" in _navigator);
  const share = /* @__PURE__ */ __name(async (overrideOptions = {}) => {
    if (isSupported2.value) {
      const data = {
        ...toValue$2(shareOptions),
        ...toValue$2(overrideOptions)
      };
      let granted = true;
      if (data.files && _navigator.canShare)
        granted = _navigator.canShare({ files: data.files });
      if (granted)
        return _navigator.share(data);
    }
  }, "share");
  return {
    isSupported: isSupported2,
    share
  };
}
__name(useShare, "useShare");
const defaultSortFn = /* @__PURE__ */ __name((source, compareFn) => source.sort(compareFn), "defaultSortFn");
const defaultCompare = /* @__PURE__ */ __name((a, b) => a - b, "defaultCompare");
function useSorted(...args) {
  var _a, _b, _c, _d;
  const [source] = args;
  let compareFn = defaultCompare;
  let options = {};
  if (args.length === 2) {
    if (typeof args[1] === "object") {
      options = args[1];
      compareFn = (_a = options.compareFn) != null ? _a : defaultCompare;
    } else {
      compareFn = (_b = args[1]) != null ? _b : defaultCompare;
    }
  } else if (args.length > 2) {
    compareFn = (_c = args[1]) != null ? _c : defaultCompare;
    options = (_d = args[2]) != null ? _d : {};
  }
  const {
    dirty = false,
    sortFn = defaultSortFn
  } = options;
  if (!dirty)
    return computed(() => sortFn([...toValue$2(source)], compareFn));
  watchEffect(() => {
    const result = sortFn(toValue$2(source), compareFn);
    if (isRef(source))
      source.value = result;
    else
      source.splice(0, source.length, ...result);
  });
  return source;
}
__name(useSorted, "useSorted");
function useSpeechRecognition(options = {}) {
  const {
    interimResults = true,
    continuous = true,
    maxAlternatives = 1,
    window: window2 = defaultWindow
  } = options;
  const lang = toRef(options.lang || "en-US");
  const isListening = shallowRef(false);
  const isFinal = shallowRef(false);
  const result = shallowRef("");
  const error = shallowRef(void 0);
  let recognition;
  const start = /* @__PURE__ */ __name(() => {
    isListening.value = true;
  }, "start");
  const stop = /* @__PURE__ */ __name(() => {
    isListening.value = false;
  }, "stop");
  const toggle = /* @__PURE__ */ __name((value = !isListening.value) => {
    if (value) {
      start();
    } else {
      stop();
    }
  }, "toggle");
  const SpeechRecognition = window2 && (window2.SpeechRecognition || window2.webkitSpeechRecognition);
  const isSupported2 = useSupported(() => SpeechRecognition);
  if (isSupported2.value) {
    recognition = new SpeechRecognition();
    recognition.continuous = continuous;
    recognition.interimResults = interimResults;
    recognition.lang = toValue$2(lang);
    recognition.maxAlternatives = maxAlternatives;
    recognition.onstart = () => {
      isListening.value = true;
      isFinal.value = false;
    };
    watch(lang, (lang2) => {
      if (recognition && !isListening.value)
        recognition.lang = lang2;
    });
    recognition.onresult = (event) => {
      const currentResult = event.results[event.resultIndex];
      const { transcript } = currentResult[0];
      isFinal.value = currentResult.isFinal;
      result.value = transcript;
      error.value = void 0;
    };
    recognition.onerror = (event) => {
      error.value = event;
    };
    recognition.onend = () => {
      isListening.value = false;
      recognition.lang = toValue$2(lang);
    };
    watch(isListening, (newValue, oldValue) => {
      if (newValue === oldValue)
        return;
      if (newValue)
        recognition.start();
      else
        recognition.stop();
    });
  }
  tryOnScopeDispose(() => {
    stop();
  });
  return {
    isSupported: isSupported2,
    isListening,
    isFinal,
    recognition,
    result,
    error,
    toggle,
    start,
    stop
  };
}
__name(useSpeechRecognition, "useSpeechRecognition");
function useSpeechSynthesis(text, options = {}) {
  const {
    pitch = 1,
    rate = 1,
    volume = 1,
    window: window2 = defaultWindow
  } = options;
  const synth = window2 && window2.speechSynthesis;
  const isSupported2 = useSupported(() => synth);
  const isPlaying = shallowRef(false);
  const status = shallowRef("init");
  const spokenText = toRef(text || "");
  const lang = toRef(options.lang || "en-US");
  const error = shallowRef(void 0);
  const toggle = /* @__PURE__ */ __name((value = !isPlaying.value) => {
    isPlaying.value = value;
  }, "toggle");
  const bindEventsForUtterance = /* @__PURE__ */ __name((utterance2) => {
    utterance2.lang = toValue$2(lang);
    utterance2.voice = toValue$2(options.voice) || null;
    utterance2.pitch = toValue$2(pitch);
    utterance2.rate = toValue$2(rate);
    utterance2.volume = volume;
    utterance2.onstart = () => {
      isPlaying.value = true;
      status.value = "play";
    };
    utterance2.onpause = () => {
      isPlaying.value = false;
      status.value = "pause";
    };
    utterance2.onresume = () => {
      isPlaying.value = true;
      status.value = "play";
    };
    utterance2.onend = () => {
      isPlaying.value = false;
      status.value = "end";
    };
    utterance2.onerror = (event) => {
      error.value = event;
    };
  }, "bindEventsForUtterance");
  const utterance = computed(() => {
    isPlaying.value = false;
    status.value = "init";
    const newUtterance = new SpeechSynthesisUtterance(spokenText.value);
    bindEventsForUtterance(newUtterance);
    return newUtterance;
  });
  const speak = /* @__PURE__ */ __name(() => {
    synth.cancel();
    if (utterance)
      synth.speak(utterance.value);
  }, "speak");
  const stop = /* @__PURE__ */ __name(() => {
    synth.cancel();
    isPlaying.value = false;
  }, "stop");
  if (isSupported2.value) {
    bindEventsForUtterance(utterance.value);
    watch(lang, (lang2) => {
      if (utterance.value && !isPlaying.value)
        utterance.value.lang = lang2;
    });
    if (options.voice) {
      watch(options.voice, () => {
        synth.cancel();
      });
    }
    watch(isPlaying, () => {
      if (isPlaying.value)
        synth.resume();
      else
        synth.pause();
    });
  }
  tryOnScopeDispose(() => {
    isPlaying.value = false;
  });
  return {
    isSupported: isSupported2,
    isPlaying,
    status,
    utterance,
    error,
    stop,
    toggle,
    speak
  };
}
__name(useSpeechSynthesis, "useSpeechSynthesis");
function useStepper(steps, initialStep) {
  const stepsRef = ref(steps);
  const stepNames = computed(() => Array.isArray(stepsRef.value) ? stepsRef.value : Object.keys(stepsRef.value));
  const index = ref(stepNames.value.indexOf(initialStep != null ? initialStep : stepNames.value[0]));
  const current = computed(() => at2(index.value));
  const isFirst = computed(() => index.value === 0);
  const isLast = computed(() => index.value === stepNames.value.length - 1);
  const next = computed(() => stepNames.value[index.value + 1]);
  const previous = computed(() => stepNames.value[index.value - 1]);
  function at2(index2) {
    if (Array.isArray(stepsRef.value))
      return stepsRef.value[index2];
    return stepsRef.value[stepNames.value[index2]];
  }
  __name(at2, "at");
  function get2(step) {
    if (!stepNames.value.includes(step))
      return;
    return at2(stepNames.value.indexOf(step));
  }
  __name(get2, "get");
  function goTo(step) {
    if (stepNames.value.includes(step))
      index.value = stepNames.value.indexOf(step);
  }
  __name(goTo, "goTo");
  function goToNext() {
    if (isLast.value)
      return;
    index.value++;
  }
  __name(goToNext, "goToNext");
  function goToPrevious() {
    if (isFirst.value)
      return;
    index.value--;
  }
  __name(goToPrevious, "goToPrevious");
  function goBackTo(step) {
    if (isAfter2(step))
      goTo(step);
  }
  __name(goBackTo, "goBackTo");
  function isNext(step) {
    return stepNames.value.indexOf(step) === index.value + 1;
  }
  __name(isNext, "isNext");
  function isPrevious(step) {
    return stepNames.value.indexOf(step) === index.value - 1;
  }
  __name(isPrevious, "isPrevious");
  function isCurrent(step) {
    return stepNames.value.indexOf(step) === index.value;
  }
  __name(isCurrent, "isCurrent");
  function isBefore2(step) {
    return index.value < stepNames.value.indexOf(step);
  }
  __name(isBefore2, "isBefore");
  function isAfter2(step) {
    return index.value > stepNames.value.indexOf(step);
  }
  __name(isAfter2, "isAfter");
  return {
    steps: stepsRef,
    stepNames,
    index,
    current,
    next,
    previous,
    isFirst,
    isLast,
    at: at2,
    get: get2,
    goTo,
    goToNext,
    goToPrevious,
    goBackTo,
    isNext,
    isPrevious,
    isCurrent,
    isBefore: isBefore2,
    isAfter: isAfter2
  };
}
__name(useStepper, "useStepper");
function useStorageAsync(key, initialValue, storage, options = {}) {
  var _a;
  const {
    flush = "pre",
    deep = true,
    listenToStorageChanges = true,
    writeDefaults = true,
    mergeDefaults: mergeDefaults2 = false,
    shallow,
    window: window2 = defaultWindow,
    eventFilter,
    onError = /* @__PURE__ */ __name((e) => {
      console.error(e);
    }, "onError")
  } = options;
  const rawInit = toValue$2(initialValue);
  const type = guessSerializerType(rawInit);
  const data = (shallow ? shallowRef : ref)(toValue$2(initialValue));
  const serializer = (_a = options.serializer) != null ? _a : StorageSerializers[type];
  if (!storage) {
    try {
      storage = getSSRHandler("getDefaultStorageAsync", () => {
        var _a2;
        return (_a2 = defaultWindow) == null ? void 0 : _a2.localStorage;
      })();
    } catch (e) {
      onError(e);
    }
  }
  async function read(event) {
    if (!storage || event && event.key !== key)
      return;
    try {
      const rawValue = event ? event.newValue : await storage.getItem(key);
      if (rawValue == null) {
        data.value = rawInit;
        if (writeDefaults && rawInit !== null)
          await storage.setItem(key, await serializer.write(rawInit));
      } else if (mergeDefaults2) {
        const value = await serializer.read(rawValue);
        if (typeof mergeDefaults2 === "function")
          data.value = mergeDefaults2(value, rawInit);
        else if (type === "object" && !Array.isArray(value))
          data.value = { ...rawInit, ...value };
        else data.value = value;
      } else {
        data.value = await serializer.read(rawValue);
      }
    } catch (e) {
      onError(e);
    }
  }
  __name(read, "read");
  read();
  if (window2 && listenToStorageChanges)
    useEventListener(window2, "storage", (e) => Promise.resolve().then(() => read(e)), { passive: true });
  if (storage) {
    watchWithFilter(
      data,
      async () => {
        try {
          if (data.value == null)
            await storage.removeItem(key);
          else
            await storage.setItem(key, await serializer.write(data.value));
        } catch (e) {
          onError(e);
        }
      },
      {
        flush,
        deep,
        eventFilter
      }
    );
  }
  return data;
}
__name(useStorageAsync, "useStorageAsync");
let _id = 0;
function useStyleTag(css, options = {}) {
  const isLoaded = shallowRef(false);
  const {
    document: document2 = defaultDocument,
    immediate = true,
    manual = false,
    id = `vueuse_styletag_${++_id}`
  } = options;
  const cssRef = shallowRef(css);
  let stop = /* @__PURE__ */ __name(() => {
  }, "stop");
  const load = /* @__PURE__ */ __name(() => {
    if (!document2)
      return;
    const el = document2.getElementById(id) || document2.createElement("style");
    if (!el.isConnected) {
      el.id = id;
      if (options.media)
        el.media = options.media;
      document2.head.appendChild(el);
    }
    if (isLoaded.value)
      return;
    stop = watch(
      cssRef,
      (value) => {
        el.textContent = value;
      },
      { immediate: true }
    );
    isLoaded.value = true;
  }, "load");
  const unload = /* @__PURE__ */ __name(() => {
    if (!document2 || !isLoaded.value)
      return;
    stop();
    document2.head.removeChild(document2.getElementById(id));
    isLoaded.value = false;
  }, "unload");
  if (immediate && !manual)
    tryOnMounted(load);
  if (!manual)
    tryOnScopeDispose(unload);
  return {
    id,
    css: cssRef,
    unload,
    load,
    isLoaded: readonly(isLoaded)
  };
}
__name(useStyleTag, "useStyleTag");
function useSwipe(target, options = {}) {
  const {
    threshold = 50,
    onSwipe,
    onSwipeEnd,
    onSwipeStart,
    passive = true
  } = options;
  const coordsStart = reactive({ x: 0, y: 0 });
  const coordsEnd = reactive({ x: 0, y: 0 });
  const diffX = computed(() => coordsStart.x - coordsEnd.x);
  const diffY = computed(() => coordsStart.y - coordsEnd.y);
  const { max: max2, abs } = Math;
  const isThresholdExceeded = computed(() => max2(abs(diffX.value), abs(diffY.value)) >= threshold);
  const isSwiping = shallowRef(false);
  const direction = computed(() => {
    if (!isThresholdExceeded.value)
      return "none";
    if (abs(diffX.value) > abs(diffY.value)) {
      return diffX.value > 0 ? "left" : "right";
    } else {
      return diffY.value > 0 ? "up" : "down";
    }
  });
  const getTouchEventCoords = /* @__PURE__ */ __name((e) => [e.touches[0].clientX, e.touches[0].clientY], "getTouchEventCoords");
  const updateCoordsStart = /* @__PURE__ */ __name((x, y) => {
    coordsStart.x = x;
    coordsStart.y = y;
  }, "updateCoordsStart");
  const updateCoordsEnd = /* @__PURE__ */ __name((x, y) => {
    coordsEnd.x = x;
    coordsEnd.y = y;
  }, "updateCoordsEnd");
  const listenerOptions = { passive, capture: !passive };
  const onTouchEnd = /* @__PURE__ */ __name((e) => {
    if (isSwiping.value)
      onSwipeEnd == null ? void 0 : onSwipeEnd(e, direction.value);
    isSwiping.value = false;
  }, "onTouchEnd");
  const stops = [
    useEventListener(target, "touchstart", (e) => {
      if (e.touches.length !== 1)
        return;
      const [x, y] = getTouchEventCoords(e);
      updateCoordsStart(x, y);
      updateCoordsEnd(x, y);
      onSwipeStart == null ? void 0 : onSwipeStart(e);
    }, listenerOptions),
    useEventListener(target, "touchmove", (e) => {
      if (e.touches.length !== 1)
        return;
      const [x, y] = getTouchEventCoords(e);
      updateCoordsEnd(x, y);
      if (listenerOptions.capture && !listenerOptions.passive && Math.abs(diffX.value) > Math.abs(diffY.value))
        e.preventDefault();
      if (!isSwiping.value && isThresholdExceeded.value)
        isSwiping.value = true;
      if (isSwiping.value)
        onSwipe == null ? void 0 : onSwipe(e);
    }, listenerOptions),
    useEventListener(target, ["touchend", "touchcancel"], onTouchEnd, listenerOptions)
  ];
  const stop = /* @__PURE__ */ __name(() => stops.forEach((s) => s()), "stop");
  return {
    isSwiping,
    direction,
    coordsStart,
    coordsEnd,
    lengthX: diffX,
    lengthY: diffY,
    stop,
    // TODO: Remove in the next major version
    isPassiveEventSupported: true
  };
}
__name(useSwipe, "useSwipe");
function useTemplateRefsList() {
  const refs = ref([]);
  refs.value.set = (el) => {
    if (el)
      refs.value.push(el);
  };
  onBeforeUpdate(() => {
    refs.value.length = 0;
  });
  return refs;
}
__name(useTemplateRefsList, "useTemplateRefsList");
function useTextDirection(options = {}) {
  const {
    document: document2 = defaultDocument,
    selector = "html",
    observe = false,
    initialValue = "ltr"
  } = options;
  function getValue2() {
    var _a, _b;
    return (_b = (_a = document2 == null ? void 0 : document2.querySelector(selector)) == null ? void 0 : _a.getAttribute("dir")) != null ? _b : initialValue;
  }
  __name(getValue2, "getValue2");
  const dir = ref(getValue2());
  tryOnMounted(() => dir.value = getValue2());
  if (observe && document2) {
    useMutationObserver(
      document2.querySelector(selector),
      () => dir.value = getValue2(),
      { attributes: true }
    );
  }
  return computed({
    get() {
      return dir.value;
    },
    set(v) {
      var _a, _b;
      dir.value = v;
      if (!document2)
        return;
      if (dir.value)
        (_a = document2.querySelector(selector)) == null ? void 0 : _a.setAttribute("dir", dir.value);
      else
        (_b = document2.querySelector(selector)) == null ? void 0 : _b.removeAttribute("dir");
    }
  });
}
__name(useTextDirection, "useTextDirection");
function getRangesFromSelection(selection) {
  var _a;
  const rangeCount = (_a = selection.rangeCount) != null ? _a : 0;
  return Array.from({ length: rangeCount }, (_, i) => selection.getRangeAt(i));
}
__name(getRangesFromSelection, "getRangesFromSelection");
function useTextSelection(options = {}) {
  const {
    window: window2 = defaultWindow
  } = options;
  const selection = ref(null);
  const text = computed(() => {
    var _a, _b;
    return (_b = (_a = selection.value) == null ? void 0 : _a.toString()) != null ? _b : "";
  });
  const ranges = computed(() => selection.value ? getRangesFromSelection(selection.value) : []);
  const rects = computed(() => ranges.value.map((range2) => range2.getBoundingClientRect()));
  function onSelectionChange() {
    selection.value = null;
    if (window2)
      selection.value = window2.getSelection();
  }
  __name(onSelectionChange, "onSelectionChange");
  if (window2)
    useEventListener(window2.document, "selectionchange", onSelectionChange, { passive: true });
  return {
    text,
    rects,
    ranges,
    selection
  };
}
__name(useTextSelection, "useTextSelection");
function tryRequestAnimationFrame(window2 = defaultWindow, fn) {
  if (window2 && typeof window2.requestAnimationFrame === "function") {
    window2.requestAnimationFrame(fn);
  } else {
    fn();
  }
}
__name(tryRequestAnimationFrame, "tryRequestAnimationFrame");
function useTextareaAutosize(options = {}) {
  var _a, _b;
  const { window: window2 = defaultWindow } = options;
  const textarea = toRef(options == null ? void 0 : options.element);
  const input = toRef((_a = options == null ? void 0 : options.input) != null ? _a : "");
  const styleProp = (_b = options == null ? void 0 : options.styleProp) != null ? _b : "height";
  const textareaScrollHeight = shallowRef(1);
  const textareaOldWidth = shallowRef(0);
  function triggerResize() {
    var _a2;
    if (!textarea.value)
      return;
    let height = "";
    textarea.value.style[styleProp] = "1px";
    textareaScrollHeight.value = (_a2 = textarea.value) == null ? void 0 : _a2.scrollHeight;
    const _styleTarget = toValue$2(options == null ? void 0 : options.styleTarget);
    if (_styleTarget)
      _styleTarget.style[styleProp] = `${textareaScrollHeight.value}px`;
    else
      height = `${textareaScrollHeight.value}px`;
    textarea.value.style[styleProp] = height;
  }
  __name(triggerResize, "triggerResize");
  watch([input, textarea], () => nextTick(triggerResize), { immediate: true });
  watch(textareaScrollHeight, () => {
    var _a2;
    return (_a2 = options == null ? void 0 : options.onResize) == null ? void 0 : _a2.call(options);
  });
  useResizeObserver(textarea, ([{ contentRect }]) => {
    if (textareaOldWidth.value === contentRect.width)
      return;
    tryRequestAnimationFrame(window2, () => {
      textareaOldWidth.value = contentRect.width;
      triggerResize();
    });
  });
  if (options == null ? void 0 : options.watch)
    watch(options.watch, triggerResize, { immediate: true, deep: true });
  return {
    textarea,
    input,
    triggerResize
  };
}
__name(useTextareaAutosize, "useTextareaAutosize");
function useThrottledRefHistory(source, options = {}) {
  const { throttle: throttle2 = 200, trailing = true } = options;
  const filter = throttleFilter(throttle2, trailing);
  const history = useRefHistory(source, { ...options, eventFilter: filter });
  return {
    ...history
  };
}
__name(useThrottledRefHistory, "useThrottledRefHistory");
const DEFAULT_UNITS = [
  { max: 6e4, value: 1e3, name: "second" },
  { max: 276e4, value: 6e4, name: "minute" },
  { max: 72e6, value: 36e5, name: "hour" },
  { max: 5184e5, value: 864e5, name: "day" },
  { max: 24192e5, value: 6048e5, name: "week" },
  { max: 28512e6, value: 2592e6, name: "month" },
  { max: Number.POSITIVE_INFINITY, value: 31536e6, name: "year" }
];
const DEFAULT_MESSAGES = {
  justNow: "just now",
  past: /* @__PURE__ */ __name((n) => n.match(/\d/) ? `${n} ago` : n, "past"),
  future: /* @__PURE__ */ __name((n) => n.match(/\d/) ? `in ${n}` : n, "future"),
  month: /* @__PURE__ */ __name((n, past) => n === 1 ? past ? "last month" : "next month" : `${n} month${n > 1 ? "s" : ""}`, "month"),
  year: /* @__PURE__ */ __name((n, past) => n === 1 ? past ? "last year" : "next year" : `${n} year${n > 1 ? "s" : ""}`, "year"),
  day: /* @__PURE__ */ __name((n, past) => n === 1 ? past ? "yesterday" : "tomorrow" : `${n} day${n > 1 ? "s" : ""}`, "day"),
  week: /* @__PURE__ */ __name((n, past) => n === 1 ? past ? "last week" : "next week" : `${n} week${n > 1 ? "s" : ""}`, "week"),
  hour: /* @__PURE__ */ __name((n) => `${n} hour${n > 1 ? "s" : ""}`, "hour"),
  minute: /* @__PURE__ */ __name((n) => `${n} minute${n > 1 ? "s" : ""}`, "minute"),
  second: /* @__PURE__ */ __name((n) => `${n} second${n > 1 ? "s" : ""}`, "second"),
  invalid: ""
};
function DEFAULT_FORMATTER(date) {
  return date.toISOString().slice(0, 10);
}
__name(DEFAULT_FORMATTER, "DEFAULT_FORMATTER");
function useTimeAgo(time, options = {}) {
  const {
    controls: exposeControls = false,
    updateInterval = 3e4
  } = options;
  const { now: now2, ...controls } = useNow({ interval: updateInterval, controls: true });
  const timeAgo = computed(() => formatTimeAgo(new Date(toValue$2(time)), options, toValue$2(now2)));
  if (exposeControls) {
    return {
      timeAgo,
      ...controls
    };
  } else {
    return timeAgo;
  }
}
__name(useTimeAgo, "useTimeAgo");
function formatTimeAgo(from, options = {}, now2 = Date.now()) {
  var _a;
  const {
    max: max2,
    messages = DEFAULT_MESSAGES,
    fullDateFormatter = DEFAULT_FORMATTER,
    units = DEFAULT_UNITS,
    showSecond = false,
    rounding = "round"
  } = options;
  const roundFn = typeof rounding === "number" ? (n) => +n.toFixed(rounding) : Math[rounding];
  const diff = +now2 - +from;
  const absDiff = Math.abs(diff);
  function getValue2(diff2, unit) {
    return roundFn(Math.abs(diff2) / unit.value);
  }
  __name(getValue2, "getValue2");
  function format(diff2, unit) {
    const val = getValue2(diff2, unit);
    const past = diff2 > 0;
    const str = applyFormat(unit.name, val, past);
    return applyFormat(past ? "past" : "future", str, past);
  }
  __name(format, "format");
  function applyFormat(name, val, isPast) {
    const formatter = messages[name];
    if (typeof formatter === "function")
      return formatter(val, isPast);
    return formatter.replace("{0}", val.toString());
  }
  __name(applyFormat, "applyFormat");
  if (absDiff < 6e4 && !showSecond)
    return messages.justNow;
  if (typeof max2 === "number" && absDiff > max2)
    return fullDateFormatter(new Date(from));
  if (typeof max2 === "string") {
    const unitMax = (_a = units.find((i) => i.name === max2)) == null ? void 0 : _a.max;
    if (unitMax && absDiff > unitMax)
      return fullDateFormatter(new Date(from));
  }
  for (const [idx, unit] of units.entries()) {
    const val = getValue2(diff, unit);
    if (val <= 0 && units[idx - 1])
      return format(diff, units[idx - 1]);
    if (absDiff < unit.max)
      return format(diff, unit);
  }
  return messages.invalid;
}
__name(formatTimeAgo, "formatTimeAgo");
function useTimeoutPoll(fn, interval, options = {}) {
  const {
    immediate = true,
    immediateCallback = false
  } = options;
  const { start } = useTimeoutFn(loop, interval, { immediate });
  const isActive = shallowRef(false);
  async function loop() {
    if (!isActive.value)
      return;
    await fn();
    start();
  }
  __name(loop, "loop");
  function resume() {
    if (!isActive.value) {
      isActive.value = true;
      if (immediateCallback)
        fn();
      start();
    }
  }
  __name(resume, "resume");
  function pause() {
    isActive.value = false;
  }
  __name(pause, "pause");
  if (immediate && isClient)
    resume();
  tryOnScopeDispose(pause);
  return {
    isActive,
    pause,
    resume
  };
}
__name(useTimeoutPoll, "useTimeoutPoll");
function useTimestamp(options = {}) {
  const {
    controls: exposeControls = false,
    offset: offset2 = 0,
    immediate = true,
    interval = "requestAnimationFrame",
    callback
  } = options;
  const ts = shallowRef(timestamp() + offset2);
  const update = /* @__PURE__ */ __name(() => ts.value = timestamp() + offset2, "update");
  const cb = callback ? () => {
    update();
    callback(ts.value);
  } : update;
  const controls = interval === "requestAnimationFrame" ? useRafFn(cb, { immediate }) : useIntervalFn(cb, interval, { immediate });
  if (exposeControls) {
    return {
      timestamp: ts,
      ...controls
    };
  } else {
    return ts;
  }
}
__name(useTimestamp, "useTimestamp");
function useTitle(newTitle = null, options = {}) {
  var _a, _b, _c;
  const {
    document: document2 = defaultDocument,
    restoreOnUnmount = /* @__PURE__ */ __name((t2) => t2, "restoreOnUnmount")
  } = options;
  const originalTitle = (_a = document2 == null ? void 0 : document2.title) != null ? _a : "";
  const title = toRef((_b = newTitle != null ? newTitle : document2 == null ? void 0 : document2.title) != null ? _b : null);
  const isReadonly2 = !!(newTitle && typeof newTitle === "function");
  function format(t2) {
    if (!("titleTemplate" in options))
      return t2;
    const template = options.titleTemplate || "%s";
    return typeof template === "function" ? template(t2) : toValue$2(template).replace(/%s/g, t2);
  }
  __name(format, "format");
  watch(
    title,
    (newValue, oldValue) => {
      if (newValue !== oldValue && document2)
        document2.title = format(newValue != null ? newValue : "");
    },
    { immediate: true }
  );
  if (options.observe && !options.titleTemplate && document2 && !isReadonly2) {
    useMutationObserver(
      (_c = document2.head) == null ? void 0 : _c.querySelector("title"),
      () => {
        if (document2 && document2.title !== title.value)
          title.value = format(document2.title);
      },
      { childList: true }
    );
  }
  tryOnScopeDispose(() => {
    if (restoreOnUnmount) {
      const restoredTitle = restoreOnUnmount(originalTitle, title.value || "");
      if (restoredTitle != null && document2)
        document2.title = restoredTitle;
    }
  });
  return title;
}
__name(useTitle, "useTitle");
const _TransitionPresets = {
  easeInSine: [0.12, 0, 0.39, 0],
  easeOutSine: [0.61, 1, 0.88, 1],
  easeInOutSine: [0.37, 0, 0.63, 1],
  easeInQuad: [0.11, 0, 0.5, 0],
  easeOutQuad: [0.5, 1, 0.89, 1],
  easeInOutQuad: [0.45, 0, 0.55, 1],
  easeInCubic: [0.32, 0, 0.67, 0],
  easeOutCubic: [0.33, 1, 0.68, 1],
  easeInOutCubic: [0.65, 0, 0.35, 1],
  easeInQuart: [0.5, 0, 0.75, 0],
  easeOutQuart: [0.25, 1, 0.5, 1],
  easeInOutQuart: [0.76, 0, 0.24, 1],
  easeInQuint: [0.64, 0, 0.78, 0],
  easeOutQuint: [0.22, 1, 0.36, 1],
  easeInOutQuint: [0.83, 0, 0.17, 1],
  easeInExpo: [0.7, 0, 0.84, 0],
  easeOutExpo: [0.16, 1, 0.3, 1],
  easeInOutExpo: [0.87, 0, 0.13, 1],
  easeInCirc: [0.55, 0, 1, 0.45],
  easeOutCirc: [0, 0.55, 0.45, 1],
  easeInOutCirc: [0.85, 0, 0.15, 1],
  easeInBack: [0.36, 0, 0.66, -0.56],
  easeOutBack: [0.34, 1.56, 0.64, 1],
  easeInOutBack: [0.68, -0.6, 0.32, 1.6]
};
const TransitionPresets = /* @__PURE__ */ Object.assign({}, { linear: identity }, _TransitionPresets);
function createEasingFunction([p0, p1, p2, p3]) {
  const a = /* @__PURE__ */ __name((a1, a2) => 1 - 3 * a2 + 3 * a1, "a");
  const b = /* @__PURE__ */ __name((a1, a2) => 3 * a2 - 6 * a1, "b");
  const c2 = /* @__PURE__ */ __name((a1) => 3 * a1, "c");
  const calcBezier = /* @__PURE__ */ __name((t2, a1, a2) => ((a(a1, a2) * t2 + b(a1, a2)) * t2 + c2(a1)) * t2, "calcBezier");
  const getSlope = /* @__PURE__ */ __name((t2, a1, a2) => 3 * a(a1, a2) * t2 * t2 + 2 * b(a1, a2) * t2 + c2(a1), "getSlope");
  const getTforX = /* @__PURE__ */ __name((x) => {
    let aGuessT = x;
    for (let i = 0; i < 4; ++i) {
      const currentSlope = getSlope(aGuessT, p0, p2);
      if (currentSlope === 0)
        return aGuessT;
      const currentX = calcBezier(aGuessT, p0, p2) - x;
      aGuessT -= currentX / currentSlope;
    }
    return aGuessT;
  }, "getTforX");
  return (x) => p0 === p1 && p2 === p3 ? x : calcBezier(getTforX(x), p1, p3);
}
__name(createEasingFunction, "createEasingFunction");
function lerp(a, b, alpha) {
  return a + alpha * (b - a);
}
__name(lerp, "lerp");
function toVec(t2) {
  return (typeof t2 === "number" ? [t2] : t2) || [];
}
__name(toVec, "toVec");
function executeTransition(source, from, to, options = {}) {
  var _a, _b;
  const fromVal = toValue$2(from);
  const toVal = toValue$2(to);
  const v1 = toVec(fromVal);
  const v2 = toVec(toVal);
  const duration = (_a = toValue$2(options.duration)) != null ? _a : 1e3;
  const startedAt = Date.now();
  const endAt = Date.now() + duration;
  const trans = typeof options.transition === "function" ? options.transition : (_b = toValue$2(options.transition)) != null ? _b : identity;
  const ease = typeof trans === "function" ? trans : createEasingFunction(trans);
  return new Promise((resolve) => {
    source.value = fromVal;
    const tick = /* @__PURE__ */ __name(() => {
      var _a2;
      if ((_a2 = options.abort) == null ? void 0 : _a2.call(options)) {
        resolve();
        return;
      }
      const now2 = Date.now();
      const alpha = ease((now2 - startedAt) / duration);
      const arr = toVec(source.value).map((n, i) => lerp(v1[i], v2[i], alpha));
      if (Array.isArray(source.value))
        source.value = arr.map((n, i) => {
          var _a3, _b2;
          return lerp((_a3 = v1[i]) != null ? _a3 : 0, (_b2 = v2[i]) != null ? _b2 : 0, alpha);
        });
      else if (typeof source.value === "number")
        source.value = arr[0];
      if (now2 < endAt) {
        requestAnimationFrame(tick);
      } else {
        source.value = toVal;
        resolve();
      }
    }, "tick");
    tick();
  });
}
__name(executeTransition, "executeTransition");
function useTransition(source, options = {}) {
  let currentId = 0;
  const sourceVal = /* @__PURE__ */ __name(() => {
    const v = toValue$2(source);
    return typeof v === "number" ? v : v.map(toValue$2);
  }, "sourceVal");
  const outputRef = ref(sourceVal());
  watch(sourceVal, async (to) => {
    var _a, _b;
    if (toValue$2(options.disabled))
      return;
    const id = ++currentId;
    if (options.delay)
      await promiseTimeout(toValue$2(options.delay));
    if (id !== currentId)
      return;
    const toVal = Array.isArray(to) ? to.map(toValue$2) : toValue$2(to);
    (_a = options.onStarted) == null ? void 0 : _a.call(options);
    await executeTransition(outputRef, outputRef.value, toVal, {
      ...options,
      abort: /* @__PURE__ */ __name(() => {
        var _a2;
        return id !== currentId || ((_a2 = options.abort) == null ? void 0 : _a2.call(options));
      }, "abort")
    });
    (_b = options.onFinished) == null ? void 0 : _b.call(options);
  }, { deep: true });
  watch(() => toValue$2(options.disabled), (disabled) => {
    if (disabled) {
      currentId++;
      outputRef.value = sourceVal();
    }
  });
  tryOnScopeDispose(() => {
    currentId++;
  });
  return computed(() => toValue$2(options.disabled) ? sourceVal() : outputRef.value);
}
__name(useTransition, "useTransition");
function useUrlSearchParams(mode = "history", options = {}) {
  const {
    initialValue = {},
    removeNullishValues = true,
    removeFalsyValues = false,
    write: enableWrite = true,
    writeMode = "replace",
    window: window2 = defaultWindow
  } = options;
  if (!window2)
    return reactive(initialValue);
  const state = reactive({});
  function getRawParams() {
    if (mode === "history") {
      return window2.location.search || "";
    } else if (mode === "hash") {
      const hash2 = window2.location.hash || "";
      const index = hash2.indexOf("?");
      return index > 0 ? hash2.slice(index) : "";
    } else {
      return (window2.location.hash || "").replace(/^#/, "");
    }
  }
  __name(getRawParams, "getRawParams");
  function constructQuery(params) {
    const stringified = params.toString();
    if (mode === "history")
      return `${stringified ? `?${stringified}` : ""}${window2.location.hash || ""}`;
    if (mode === "hash-params")
      return `${window2.location.search || ""}${stringified ? `#${stringified}` : ""}`;
    const hash2 = window2.location.hash || "#";
    const index = hash2.indexOf("?");
    if (index > 0)
      return `${window2.location.search || ""}${hash2.slice(0, index)}${stringified ? `?${stringified}` : ""}`;
    return `${window2.location.search || ""}${hash2}${stringified ? `?${stringified}` : ""}`;
  }
  __name(constructQuery, "constructQuery");
  function read() {
    return new URLSearchParams(getRawParams());
  }
  __name(read, "read");
  function updateState(params) {
    const unusedKeys = new Set(Object.keys(state));
    for (const key of params.keys()) {
      const paramsForKey = params.getAll(key);
      state[key] = paramsForKey.length > 1 ? paramsForKey : params.get(key) || "";
      unusedKeys.delete(key);
    }
    Array.from(unusedKeys).forEach((key) => delete state[key]);
  }
  __name(updateState, "updateState");
  const { pause, resume } = watchPausable(
    state,
    () => {
      const params = new URLSearchParams("");
      Object.keys(state).forEach((key) => {
        const mapEntry = state[key];
        if (Array.isArray(mapEntry))
          mapEntry.forEach((value) => params.append(key, value));
        else if (removeNullishValues && mapEntry == null)
          params.delete(key);
        else if (removeFalsyValues && !mapEntry)
          params.delete(key);
        else
          params.set(key, mapEntry);
      });
      write(params, false);
    },
    { deep: true }
  );
  function write(params, shouldUpdate) {
    pause();
    if (shouldUpdate)
      updateState(params);
    if (writeMode === "replace") {
      window2.history.replaceState(
        window2.history.state,
        window2.document.title,
        window2.location.pathname + constructQuery(params)
      );
    } else {
      window2.history.pushState(
        window2.history.state,
        window2.document.title,
        window2.location.pathname + constructQuery(params)
      );
    }
    resume();
  }
  __name(write, "write");
  function onChanged() {
    if (!enableWrite)
      return;
    write(read(), true);
  }
  __name(onChanged, "onChanged");
  const listenerOptions = { passive: true };
  useEventListener(window2, "popstate", onChanged, listenerOptions);
  if (mode !== "history")
    useEventListener(window2, "hashchange", onChanged, listenerOptions);
  const initial = read();
  if (initial.keys().next().value)
    updateState(initial);
  else
    Object.assign(state, initialValue);
  return state;
}
__name(useUrlSearchParams, "useUrlSearchParams");
function useUserMedia(options = {}) {
  var _a, _b;
  const enabled = shallowRef((_a = options.enabled) != null ? _a : false);
  const autoSwitch = shallowRef((_b = options.autoSwitch) != null ? _b : true);
  const constraints = ref(options.constraints);
  const { navigator: navigator2 = defaultNavigator } = options;
  const isSupported2 = useSupported(() => {
    var _a2;
    return (_a2 = navigator2 == null ? void 0 : navigator2.mediaDevices) == null ? void 0 : _a2.getUserMedia;
  });
  const stream = shallowRef();
  function getDeviceOptions(type) {
    switch (type) {
      case "video": {
        if (constraints.value)
          return constraints.value.video || false;
        break;
      }
      case "audio": {
        if (constraints.value)
          return constraints.value.audio || false;
        break;
      }
    }
  }
  __name(getDeviceOptions, "getDeviceOptions");
  async function _start() {
    if (!isSupported2.value || stream.value)
      return;
    stream.value = await navigator2.mediaDevices.getUserMedia({
      video: getDeviceOptions("video"),
      audio: getDeviceOptions("audio")
    });
    return stream.value;
  }
  __name(_start, "_start");
  function _stop() {
    var _a2;
    (_a2 = stream.value) == null ? void 0 : _a2.getTracks().forEach((t2) => t2.stop());
    stream.value = void 0;
  }
  __name(_stop, "_stop");
  function stop() {
    _stop();
    enabled.value = false;
  }
  __name(stop, "stop");
  async function start() {
    await _start();
    if (stream.value)
      enabled.value = true;
    return stream.value;
  }
  __name(start, "start");
  async function restart() {
    _stop();
    return await start();
  }
  __name(restart, "restart");
  watch(
    enabled,
    (v) => {
      if (v)
        _start();
      else _stop();
    },
    { immediate: true }
  );
  watch(
    constraints,
    () => {
      if (autoSwitch.value && stream.value)
        restart();
    },
    { immediate: true }
  );
  tryOnScopeDispose(() => {
    stop();
  });
  return {
    isSupported: isSupported2,
    stream,
    start,
    stop,
    restart,
    constraints,
    enabled,
    autoSwitch
  };
}
__name(useUserMedia, "useUserMedia");
function useVModel(props2, key, emit, options = {}) {
  var _a, _b, _c;
  const {
    clone = false,
    passive = false,
    eventName,
    deep = false,
    defaultValue,
    shouldEmit
  } = options;
  const vm = getCurrentInstance();
  const _emit = emit || (vm == null ? void 0 : vm.emit) || ((_a = vm == null ? void 0 : vm.$emit) == null ? void 0 : _a.bind(vm)) || ((_c = (_b = vm == null ? void 0 : vm.proxy) == null ? void 0 : _b.$emit) == null ? void 0 : _c.bind(vm == null ? void 0 : vm.proxy));
  let event = eventName;
  if (!key) {
    key = "modelValue";
  }
  event = event || `update:${key.toString()}`;
  const cloneFn = /* @__PURE__ */ __name((val) => !clone ? val : typeof clone === "function" ? clone(val) : cloneFnJSON(val), "cloneFn");
  const getValue2 = /* @__PURE__ */ __name(() => isDef(props2[key]) ? cloneFn(props2[key]) : defaultValue, "getValue2");
  const triggerEmit = /* @__PURE__ */ __name((value) => {
    if (shouldEmit) {
      if (shouldEmit(value))
        _emit(event, value);
    } else {
      _emit(event, value);
    }
  }, "triggerEmit");
  if (passive) {
    const initialValue = getValue2();
    const proxy = ref(initialValue);
    let isUpdating = false;
    watch(
      () => props2[key],
      (v) => {
        if (!isUpdating) {
          isUpdating = true;
          proxy.value = cloneFn(v);
          nextTick(() => isUpdating = false);
        }
      }
    );
    watch(
      proxy,
      (v) => {
        if (!isUpdating && (v !== props2[key] || deep))
          triggerEmit(v);
      },
      { deep }
    );
    return proxy;
  } else {
    return computed({
      get() {
        return getValue2();
      },
      set(value) {
        triggerEmit(value);
      }
    });
  }
}
__name(useVModel, "useVModel");
function useVModels(props2, emit, options = {}) {
  const ret = {};
  for (const key in props2) {
    ret[key] = useVModel(
      props2,
      key,
      emit,
      options
    );
  }
  return ret;
}
__name(useVModels, "useVModels");
function useVibrate(options) {
  const {
    pattern = [],
    interval = 0,
    navigator: navigator2 = defaultNavigator
  } = options || {};
  const isSupported2 = useSupported(() => typeof navigator2 !== "undefined" && "vibrate" in navigator2);
  const patternRef = toRef(pattern);
  let intervalControls;
  const vibrate = /* @__PURE__ */ __name((pattern2 = patternRef.value) => {
    if (isSupported2.value)
      navigator2.vibrate(pattern2);
  }, "vibrate");
  const stop = /* @__PURE__ */ __name(() => {
    if (isSupported2.value)
      navigator2.vibrate(0);
    intervalControls == null ? void 0 : intervalControls.pause();
  }, "stop");
  if (interval > 0) {
    intervalControls = useIntervalFn(
      vibrate,
      interval,
      {
        immediate: false,
        immediateCallback: false
      }
    );
  }
  return {
    isSupported: isSupported2,
    pattern,
    intervalControls,
    vibrate,
    stop
  };
}
__name(useVibrate, "useVibrate");
function useVirtualList(list, options) {
  const { containerStyle, wrapperProps, scrollTo, calculateRange: calculateRange2, currentList, containerRef } = "itemHeight" in options ? useVerticalVirtualList(options, list) : useHorizontalVirtualList(options, list);
  return {
    list: currentList,
    scrollTo,
    containerProps: {
      ref: containerRef,
      onScroll: /* @__PURE__ */ __name(() => {
        calculateRange2();
      }, "onScroll"),
      style: containerStyle
    },
    wrapperProps
  };
}
__name(useVirtualList, "useVirtualList");
function useVirtualListResources(list) {
  const containerRef = shallowRef(null);
  const size2 = useElementSize(containerRef);
  const currentList = ref([]);
  const source = shallowRef(list);
  const state = ref({ start: 0, end: 10 });
  return { state, source, currentList, size: size2, containerRef };
}
__name(useVirtualListResources, "useVirtualListResources");
function createGetViewCapacity(state, source, itemSize) {
  return (containerSize) => {
    if (typeof itemSize === "number")
      return Math.ceil(containerSize / itemSize);
    const { start = 0 } = state.value;
    let sum = 0;
    let capacity = 0;
    for (let i = start; i < source.value.length; i++) {
      const size2 = itemSize(i);
      sum += size2;
      capacity = i;
      if (sum > containerSize)
        break;
    }
    return capacity - start;
  };
}
__name(createGetViewCapacity, "createGetViewCapacity");
function createGetOffset(source, itemSize) {
  return (scrollDirection) => {
    if (typeof itemSize === "number")
      return Math.floor(scrollDirection / itemSize) + 1;
    let sum = 0;
    let offset2 = 0;
    for (let i = 0; i < source.value.length; i++) {
      const size2 = itemSize(i);
      sum += size2;
      if (sum >= scrollDirection) {
        offset2 = i;
        break;
      }
    }
    return offset2 + 1;
  };
}
__name(createGetOffset, "createGetOffset");
function createCalculateRange(type, overscan, getOffset, getViewCapacity, { containerRef, state, currentList, source }) {
  return () => {
    const element = containerRef.value;
    if (element) {
      const offset2 = getOffset(type === "vertical" ? element.scrollTop : element.scrollLeft);
      const viewCapacity = getViewCapacity(type === "vertical" ? element.clientHeight : element.clientWidth);
      const from = offset2 - overscan;
      const to = offset2 + viewCapacity + overscan;
      state.value = {
        start: from < 0 ? 0 : from,
        end: to > source.value.length ? source.value.length : to
      };
      currentList.value = source.value.slice(state.value.start, state.value.end).map((ele, index) => ({
        data: ele,
        index: index + state.value.start
      }));
    }
  };
}
__name(createCalculateRange, "createCalculateRange");
function createGetDistance(itemSize, source) {
  return (index) => {
    if (typeof itemSize === "number") {
      const size22 = index * itemSize;
      return size22;
    }
    const size2 = source.value.slice(0, index).reduce((sum, _, i) => sum + itemSize(i), 0);
    return size2;
  };
}
__name(createGetDistance, "createGetDistance");
function useWatchForSizes(size2, list, containerRef, calculateRange2) {
  watch([size2.width, size2.height, list, containerRef], () => {
    calculateRange2();
  });
}
__name(useWatchForSizes, "useWatchForSizes");
function createComputedTotalSize(itemSize, source) {
  return computed(() => {
    if (typeof itemSize === "number")
      return source.value.length * itemSize;
    return source.value.reduce((sum, _, index) => sum + itemSize(index), 0);
  });
}
__name(createComputedTotalSize, "createComputedTotalSize");
const scrollToDictionaryForElementScrollKey = {
  horizontal: "scrollLeft",
  vertical: "scrollTop"
};
function createScrollTo(type, calculateRange2, getDistance, containerRef) {
  return (index) => {
    if (containerRef.value) {
      containerRef.value[scrollToDictionaryForElementScrollKey[type]] = getDistance(index);
      calculateRange2();
    }
  };
}
__name(createScrollTo, "createScrollTo");
function useHorizontalVirtualList(options, list) {
  const resources = useVirtualListResources(list);
  const { state, source, currentList, size: size2, containerRef } = resources;
  const containerStyle = { overflowX: "auto" };
  const { itemWidth, overscan = 5 } = options;
  const getViewCapacity = createGetViewCapacity(state, source, itemWidth);
  const getOffset = createGetOffset(source, itemWidth);
  const calculateRange2 = createCalculateRange("horizontal", overscan, getOffset, getViewCapacity, resources);
  const getDistanceLeft = createGetDistance(itemWidth, source);
  const offsetLeft = computed(() => getDistanceLeft(state.value.start));
  const totalWidth = createComputedTotalSize(itemWidth, source);
  useWatchForSizes(size2, list, containerRef, calculateRange2);
  const scrollTo = createScrollTo("horizontal", calculateRange2, getDistanceLeft, containerRef);
  const wrapperProps = computed(() => {
    return {
      style: {
        height: "100%",
        width: `${totalWidth.value - offsetLeft.value}px`,
        marginLeft: `${offsetLeft.value}px`,
        display: "flex"
      }
    };
  });
  return {
    scrollTo,
    calculateRange: calculateRange2,
    wrapperProps,
    containerStyle,
    currentList,
    containerRef
  };
}
__name(useHorizontalVirtualList, "useHorizontalVirtualList");
function useVerticalVirtualList(options, list) {
  const resources = useVirtualListResources(list);
  const { state, source, currentList, size: size2, containerRef } = resources;
  const containerStyle = { overflowY: "auto" };
  const { itemHeight, overscan = 5 } = options;
  const getViewCapacity = createGetViewCapacity(state, source, itemHeight);
  const getOffset = createGetOffset(source, itemHeight);
  const calculateRange2 = createCalculateRange("vertical", overscan, getOffset, getViewCapacity, resources);
  const getDistanceTop = createGetDistance(itemHeight, source);
  const offsetTop = computed(() => getDistanceTop(state.value.start));
  const totalHeight = createComputedTotalSize(itemHeight, source);
  useWatchForSizes(size2, list, containerRef, calculateRange2);
  const scrollTo = createScrollTo("vertical", calculateRange2, getDistanceTop, containerRef);
  const wrapperProps = computed(() => {
    return {
      style: {
        width: "100%",
        height: `${totalHeight.value - offsetTop.value}px`,
        marginTop: `${offsetTop.value}px`
      }
    };
  });
  return {
    calculateRange: calculateRange2,
    scrollTo,
    containerStyle,
    wrapperProps,
    currentList,
    containerRef
  };
}
__name(useVerticalVirtualList, "useVerticalVirtualList");
function useWakeLock(options = {}) {
  const {
    navigator: navigator2 = defaultNavigator,
    document: document2 = defaultDocument
  } = options;
  const requestedType = shallowRef(false);
  const sentinel = shallowRef(null);
  const documentVisibility = useDocumentVisibility({ document: document2 });
  const isSupported2 = useSupported(() => navigator2 && "wakeLock" in navigator2);
  const isActive = computed(() => !!sentinel.value && documentVisibility.value === "visible");
  if (isSupported2.value) {
    useEventListener(sentinel, "release", () => {
      var _a, _b;
      requestedType.value = (_b = (_a = sentinel.value) == null ? void 0 : _a.type) != null ? _b : false;
    }, { passive: true });
    whenever(
      () => documentVisibility.value === "visible" && (document2 == null ? void 0 : document2.visibilityState) === "visible" && requestedType.value,
      (type) => {
        requestedType.value = false;
        forceRequest(type);
      }
    );
  }
  async function forceRequest(type) {
    var _a;
    await ((_a = sentinel.value) == null ? void 0 : _a.release());
    sentinel.value = isSupported2.value ? await navigator2.wakeLock.request(type) : null;
  }
  __name(forceRequest, "forceRequest");
  async function request(type) {
    if (documentVisibility.value === "visible")
      await forceRequest(type);
    else
      requestedType.value = type;
  }
  __name(request, "request");
  async function release() {
    requestedType.value = false;
    const s = sentinel.value;
    sentinel.value = null;
    await (s == null ? void 0 : s.release());
  }
  __name(release, "release");
  return {
    sentinel,
    isSupported: isSupported2,
    isActive,
    request,
    forceRequest,
    release
  };
}
__name(useWakeLock, "useWakeLock");
function useWebNotification(options = {}) {
  const {
    window: window2 = defaultWindow,
    requestPermissions: _requestForPermissions = true
  } = options;
  const defaultWebNotificationOptions = options;
  const isSupported2 = useSupported(() => {
    if (!window2 || !("Notification" in window2))
      return false;
    if (Notification.permission === "granted")
      return true;
    try {
      const notification2 = new Notification("");
      notification2.onshow = () => {
        notification2.close();
      };
    } catch (e) {
      if (e.name === "TypeError")
        return false;
    }
    return true;
  });
  const permissionGranted = shallowRef(isSupported2.value && "permission" in Notification && Notification.permission === "granted");
  const notification = ref(null);
  const ensurePermissions = /* @__PURE__ */ __name(async () => {
    if (!isSupported2.value)
      return;
    if (!permissionGranted.value && Notification.permission !== "denied") {
      const result = await Notification.requestPermission();
      if (result === "granted")
        permissionGranted.value = true;
    }
    return permissionGranted.value;
  }, "ensurePermissions");
  const { on: onClick, trigger: clickTrigger } = createEventHook();
  const { on: onShow, trigger: showTrigger } = createEventHook();
  const { on: onError, trigger: errorTrigger } = createEventHook();
  const { on: onClose, trigger: closeTrigger } = createEventHook();
  const show = /* @__PURE__ */ __name(async (overrides) => {
    if (!isSupported2.value || !permissionGranted.value)
      return;
    const options2 = Object.assign({}, defaultWebNotificationOptions, overrides);
    notification.value = new Notification(options2.title || "", options2);
    notification.value.onclick = clickTrigger;
    notification.value.onshow = showTrigger;
    notification.value.onerror = errorTrigger;
    notification.value.onclose = closeTrigger;
    return notification.value;
  }, "show");
  const close = /* @__PURE__ */ __name(() => {
    if (notification.value)
      notification.value.close();
    notification.value = null;
  }, "close");
  if (_requestForPermissions)
    tryOnMounted(ensurePermissions);
  tryOnScopeDispose(close);
  if (isSupported2.value && window2) {
    const document2 = window2.document;
    useEventListener(document2, "visibilitychange", (e) => {
      e.preventDefault();
      if (document2.visibilityState === "visible") {
        close();
      }
    });
  }
  return {
    isSupported: isSupported2,
    notification,
    ensurePermissions,
    permissionGranted,
    show,
    close,
    onClick,
    onShow,
    onError,
    onClose
  };
}
__name(useWebNotification, "useWebNotification");
const DEFAULT_PING_MESSAGE = "ping";
function resolveNestedOptions(options) {
  if (options === true)
    return {};
  return options;
}
__name(resolveNestedOptions, "resolveNestedOptions");
function useWebSocket(url, options = {}) {
  const {
    onConnected,
    onDisconnected,
    onError,
    onMessage,
    immediate = true,
    autoConnect = true,
    autoClose = true,
    protocols = []
  } = options;
  const data = ref(null);
  const status = shallowRef("CLOSED");
  const wsRef = ref();
  const urlRef = toRef(url);
  let heartbeatPause;
  let heartbeatResume;
  let explicitlyClosed = false;
  let retried = 0;
  let bufferedData = [];
  let retryTimeout;
  let pongTimeoutWait;
  const _sendBuffer = /* @__PURE__ */ __name(() => {
    if (bufferedData.length && wsRef.value && status.value === "OPEN") {
      for (const buffer of bufferedData)
        wsRef.value.send(buffer);
      bufferedData = [];
    }
  }, "_sendBuffer");
  const resetRetry = /* @__PURE__ */ __name(() => {
    if (retryTimeout != null) {
      clearTimeout(retryTimeout);
      retryTimeout = void 0;
    }
  }, "resetRetry");
  const resetHeartbeat = /* @__PURE__ */ __name(() => {
    clearTimeout(pongTimeoutWait);
    pongTimeoutWait = void 0;
  }, "resetHeartbeat");
  const close = /* @__PURE__ */ __name((code = 1e3, reason) => {
    resetRetry();
    if (!isClient && !isWorker || !wsRef.value)
      return;
    explicitlyClosed = true;
    resetHeartbeat();
    heartbeatPause == null ? void 0 : heartbeatPause();
    wsRef.value.close(code, reason);
    wsRef.value = void 0;
  }, "close");
  const send = /* @__PURE__ */ __name((data2, useBuffer = true) => {
    if (!wsRef.value || status.value !== "OPEN") {
      if (useBuffer)
        bufferedData.push(data2);
      return false;
    }
    _sendBuffer();
    wsRef.value.send(data2);
    return true;
  }, "send");
  const _init = /* @__PURE__ */ __name(() => {
    if (explicitlyClosed || typeof urlRef.value === "undefined")
      return;
    const ws = new WebSocket(urlRef.value, protocols);
    wsRef.value = ws;
    status.value = "CONNECTING";
    ws.onopen = () => {
      status.value = "OPEN";
      retried = 0;
      onConnected == null ? void 0 : onConnected(ws);
      heartbeatResume == null ? void 0 : heartbeatResume();
      _sendBuffer();
    };
    ws.onclose = (ev) => {
      status.value = "CLOSED";
      resetHeartbeat();
      heartbeatPause == null ? void 0 : heartbeatPause();
      onDisconnected == null ? void 0 : onDisconnected(ws, ev);
      if (!explicitlyClosed && options.autoReconnect && (wsRef.value == null || ws === wsRef.value)) {
        const {
          retries = -1,
          delay: delay2 = 1e3,
          onFailed
        } = resolveNestedOptions(options.autoReconnect);
        const checkRetires = typeof retries === "function" ? retries : () => typeof retries === "number" && (retries < 0 || retried < retries);
        if (checkRetires(retried)) {
          retried += 1;
          retryTimeout = setTimeout(_init, delay2);
        } else {
          onFailed == null ? void 0 : onFailed();
        }
      }
    };
    ws.onerror = (e) => {
      onError == null ? void 0 : onError(ws, e);
    };
    ws.onmessage = (e) => {
      if (options.heartbeat) {
        resetHeartbeat();
        const {
          message = DEFAULT_PING_MESSAGE,
          responseMessage = message
        } = resolveNestedOptions(options.heartbeat);
        if (e.data === toValue$2(responseMessage))
          return;
      }
      data.value = e.data;
      onMessage == null ? void 0 : onMessage(ws, e);
    };
  }, "_init");
  if (options.heartbeat) {
    const {
      message = DEFAULT_PING_MESSAGE,
      interval = 1e3,
      pongTimeout = 1e3
    } = resolveNestedOptions(options.heartbeat);
    const { pause, resume } = useIntervalFn(
      () => {
        send(toValue$2(message), false);
        if (pongTimeoutWait != null)
          return;
        pongTimeoutWait = setTimeout(() => {
          close();
          explicitlyClosed = false;
        }, pongTimeout);
      },
      interval,
      { immediate: false }
    );
    heartbeatPause = pause;
    heartbeatResume = resume;
  }
  if (autoClose) {
    if (isClient)
      useEventListener("beforeunload", () => close(), { passive: true });
    tryOnScopeDispose(close);
  }
  const open = /* @__PURE__ */ __name(() => {
    if (!isClient && !isWorker)
      return;
    close();
    explicitlyClosed = false;
    retried = 0;
    _init();
  }, "open");
  if (immediate)
    open();
  if (autoConnect)
    watch(urlRef, open);
  return {
    data,
    status,
    close,
    send,
    open,
    ws: wsRef
  };
}
__name(useWebSocket, "useWebSocket");
function useWebWorker(arg0, workerOptions, options) {
  const {
    window: window2 = defaultWindow
  } = options != null ? options : {};
  const data = ref(null);
  const worker = shallowRef();
  const post = /* @__PURE__ */ __name((...args) => {
    if (!worker.value)
      return;
    worker.value.postMessage(...args);
  }, "post");
  const terminate = /* @__PURE__ */ __name(function terminate2() {
    if (!worker.value)
      return;
    worker.value.terminate();
  }, "terminate2");
  if (window2) {
    if (typeof arg0 === "string")
      worker.value = new Worker(arg0, workerOptions);
    else if (typeof arg0 === "function")
      worker.value = arg0();
    else
      worker.value = arg0;
    worker.value.onmessage = (e) => {
      data.value = e.data;
    };
    tryOnScopeDispose(() => {
      if (worker.value)
        worker.value.terminate();
    });
  }
  return {
    data,
    post,
    terminate,
    worker
  };
}
__name(useWebWorker, "useWebWorker");
function depsParser(deps, localDeps) {
  if (deps.length === 0 && localDeps.length === 0)
    return "";
  const depsString = deps.map((dep) => `'${dep}'`).toString();
  const depsFunctionString = localDeps.filter((dep) => typeof dep === "function").map((fn) => {
    const str = fn.toString();
    if (str.trim().startsWith("function")) {
      return str;
    } else {
      const name = fn.name;
      return `const ${name} = ${str}`;
    }
  }).join(";");
  const importString = `importScripts(${depsString});`;
  return `${depsString.trim() === "" ? "" : importString} ${depsFunctionString}`;
}
__name(depsParser, "depsParser");
function jobRunner(userFunc) {
  return (e) => {
    const userFuncArgs = e.data[0];
    return Promise.resolve(userFunc.apply(void 0, userFuncArgs)).then((result) => {
      postMessage(["SUCCESS", result]);
    }).catch((error) => {
      postMessage(["ERROR", error]);
    });
  };
}
__name(jobRunner, "jobRunner");
function createWorkerBlobUrl(fn, deps, localDeps) {
  const blobCode = `${depsParser(deps, localDeps)}; onmessage=(${jobRunner})(${fn})`;
  const blob = new Blob([blobCode], { type: "text/javascript" });
  const url = URL.createObjectURL(blob);
  return url;
}
__name(createWorkerBlobUrl, "createWorkerBlobUrl");
function useWebWorkerFn(fn, options = {}) {
  const {
    dependencies = [],
    localDependencies = [],
    timeout: timeout2,
    window: window2 = defaultWindow
  } = options;
  const worker = ref();
  const workerStatus = shallowRef("PENDING");
  const promise = ref({});
  const timeoutId = shallowRef();
  const workerTerminate = /* @__PURE__ */ __name((status = "PENDING") => {
    if (worker.value && worker.value._url && window2) {
      worker.value.terminate();
      URL.revokeObjectURL(worker.value._url);
      promise.value = {};
      worker.value = void 0;
      window2.clearTimeout(timeoutId.value);
      workerStatus.value = status;
    }
  }, "workerTerminate");
  workerTerminate();
  tryOnScopeDispose(workerTerminate);
  const generateWorker = /* @__PURE__ */ __name(() => {
    const blobUrl = createWorkerBlobUrl(fn, dependencies, localDependencies);
    const newWorker = new Worker(blobUrl);
    newWorker._url = blobUrl;
    newWorker.onmessage = (e) => {
      const { resolve = /* @__PURE__ */ __name(() => {
      }, "resolve"), reject = /* @__PURE__ */ __name(() => {
      }, "reject") } = promise.value;
      const [status, result] = e.data;
      switch (status) {
        case "SUCCESS":
          resolve(result);
          workerTerminate(status);
          break;
        default:
          reject(result);
          workerTerminate("ERROR");
          break;
      }
    };
    newWorker.onerror = (e) => {
      const { reject = /* @__PURE__ */ __name(() => {
      }, "reject") } = promise.value;
      e.preventDefault();
      reject(e);
      workerTerminate("ERROR");
    };
    if (timeout2) {
      timeoutId.value = setTimeout(
        () => workerTerminate("TIMEOUT_EXPIRED"),
        timeout2
      );
    }
    return newWorker;
  }, "generateWorker");
  const callWorker = /* @__PURE__ */ __name((...fnArgs) => new Promise((resolve, reject) => {
    var _a;
    promise.value = {
      resolve,
      reject
    };
    (_a = worker.value) == null ? void 0 : _a.postMessage([[...fnArgs]]);
    workerStatus.value = "RUNNING";
  }), "callWorker");
  const workerFn = /* @__PURE__ */ __name((...fnArgs) => {
    if (workerStatus.value === "RUNNING") {
      console.error(
        "[useWebWorkerFn] You can only run one instance of the worker at a time."
      );
      return Promise.reject();
    }
    worker.value = generateWorker();
    return callWorker(...fnArgs);
  }, "workerFn");
  return {
    workerFn,
    workerStatus,
    workerTerminate
  };
}
__name(useWebWorkerFn, "useWebWorkerFn");
function useWindowFocus(options = {}) {
  const { window: window2 = defaultWindow } = options;
  if (!window2)
    return shallowRef(false);
  const focused = shallowRef(window2.document.hasFocus());
  const listenerOptions = { passive: true };
  useEventListener(window2, "blur", () => {
    focused.value = false;
  }, listenerOptions);
  useEventListener(window2, "focus", () => {
    focused.value = true;
  }, listenerOptions);
  return focused;
}
__name(useWindowFocus, "useWindowFocus");
function useWindowScroll(options = {}) {
  const { window: window2 = defaultWindow, ...rest } = options;
  return useScroll(window2, rest);
}
__name(useWindowScroll, "useWindowScroll");
function useWindowSize(options = {}) {
  const {
    window: window2 = defaultWindow,
    initialWidth = Number.POSITIVE_INFINITY,
    initialHeight = Number.POSITIVE_INFINITY,
    listenOrientation = true,
    includeScrollbar = true,
    type = "inner"
  } = options;
  const width = shallowRef(initialWidth);
  const height = shallowRef(initialHeight);
  const update = /* @__PURE__ */ __name(() => {
    if (window2) {
      if (type === "outer") {
        width.value = window2.outerWidth;
        height.value = window2.outerHeight;
      } else if (type === "visual" && window2.visualViewport) {
        const { width: visualViewportWidth, height: visualViewportHeight, scale } = window2.visualViewport;
        width.value = Math.round(visualViewportWidth * scale);
        height.value = Math.round(visualViewportHeight * scale);
      } else if (includeScrollbar) {
        width.value = window2.innerWidth;
        height.value = window2.innerHeight;
      } else {
        width.value = window2.document.documentElement.clientWidth;
        height.value = window2.document.documentElement.clientHeight;
      }
    }
  }, "update");
  update();
  tryOnMounted(update);
  const listenerOptions = { passive: true };
  useEventListener("resize", update, listenerOptions);
  if (window2 && type === "visual" && window2.visualViewport) {
    useEventListener(window2.visualViewport, "resize", update, listenerOptions);
  }
  if (listenOrientation) {
    const matches = useMediaQuery("(orientation: portrait)");
    watch(matches, () => update());
  }
  return { width, height };
}
__name(useWindowSize, "useWindowSize");
function isPlainObject(value) {
  if (value === null || typeof value !== "object") {
    return false;
  }
  const prototype = Object.getPrototypeOf(value);
  if (prototype !== null && prototype !== Object.prototype && Object.getPrototypeOf(prototype) !== null) {
    return false;
  }
  if (Symbol.iterator in value) {
    return false;
  }
  if (Symbol.toStringTag in value) {
    return Object.prototype.toString.call(value) === "[object Module]";
  }
  return true;
}
__name(isPlainObject, "isPlainObject");
function _defu(baseObject, defaults2, namespace = ".", merger) {
  if (!isPlainObject(defaults2)) {
    return _defu(baseObject, {}, namespace, merger);
  }
  const object = Object.assign({}, defaults2);
  for (const key in baseObject) {
    if (key === "__proto__" || key === "constructor") {
      continue;
    }
    const value = baseObject[key];
    if (value === null || value === void 0) {
      continue;
    }
    if (merger && merger(object, key, value, namespace)) {
      continue;
    }
    if (Array.isArray(value) && Array.isArray(object[key])) {
      object[key] = [...value, ...object[key]];
    } else if (isPlainObject(value) && isPlainObject(object[key])) {
      object[key] = _defu(
        value,
        object[key],
        (namespace ? `${namespace}.` : "") + key.toString(),
        merger
      );
    } else {
      object[key] = value;
    }
  }
  return object;
}
__name(_defu, "_defu");
function createDefu(merger) {
  return (...arguments_) => (
    // eslint-disable-next-line unicorn/no-array-reduce
    arguments_.reduce((p, c2) => _defu(p, c2, "", merger), {})
  );
}
__name(createDefu, "createDefu");
const defu = createDefu();
const defuFn = createDefu((object, key, currentValue) => {
  if (object[key] !== void 0 && typeof currentValue === "function") {
    object[key] = currentValue(object[key]);
    return true;
  }
});
const defuArrayFn = createDefu((object, key, currentValue) => {
  if (Array.isArray(object[key]) && typeof currentValue === "function") {
    object[key] = currentValue(object[key]);
    return true;
  }
});
const useBodyLockStackCount = createSharedComposable(() => {
  const map = ref(/* @__PURE__ */ new Map());
  const initialOverflow = ref();
  const locked = computed(() => {
    for (const value of map.value.values()) if (value) return true;
    return false;
  });
  const context2 = injectConfigProviderContext({ scrollBody: ref(true) });
  let stopTouchMoveListener = null;
  const resetBodyStyle = /* @__PURE__ */ __name(() => {
    document.body.style.paddingRight = "";
    document.body.style.marginRight = "";
    document.body.style.pointerEvents = "";
    document.documentElement.style.removeProperty("--scrollbar-width");
    document.body.style.overflow = initialOverflow.value ?? "";
    isIOS && stopTouchMoveListener?.();
    initialOverflow.value = void 0;
  }, "resetBodyStyle");
  watch(locked, (val, oldVal) => {
    if (!isClient) return;
    if (!val) {
      if (oldVal) resetBodyStyle();
      return;
    }
    if (initialOverflow.value === void 0) initialOverflow.value = document.body.style.overflow;
    const verticalScrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
    const defaultConfig = {
      padding: verticalScrollbarWidth,
      margin: 0
    };
    const config2 = context2.scrollBody?.value ? typeof context2.scrollBody.value === "object" ? defu({
      padding: context2.scrollBody.value.padding === true ? verticalScrollbarWidth : context2.scrollBody.value.padding,
      margin: context2.scrollBody.value.margin === true ? verticalScrollbarWidth : context2.scrollBody.value.margin
    }, defaultConfig) : defaultConfig : {
      padding: 0,
      margin: 0
    };
    if (verticalScrollbarWidth > 0) {
      document.body.style.paddingRight = typeof config2.padding === "number" ? `${config2.padding}px` : String(config2.padding);
      document.body.style.marginRight = typeof config2.margin === "number" ? `${config2.margin}px` : String(config2.margin);
      document.documentElement.style.setProperty("--scrollbar-width", `${verticalScrollbarWidth}px`);
      document.body.style.overflow = "hidden";
    }
    if (isIOS) stopTouchMoveListener = useEventListener(document, "touchmove", (e) => preventDefault(e), { passive: false });
    nextTick(() => {
      document.body.style.pointerEvents = "none";
      document.body.style.overflow = "hidden";
    });
  }, {
    immediate: true,
    flush: "sync"
  });
  return map;
});
function useBodyScrollLock(initialState) {
  const id = Math.random().toString(36).substring(2, 7);
  const map = useBodyLockStackCount();
  map.value.set(id, initialState ?? false);
  const locked = computed({
    get: /* @__PURE__ */ __name(() => map.value.get(id) ?? false, "get"),
    set: /* @__PURE__ */ __name((value) => map.value.set(id, value), "set")
  });
  tryOnBeforeUnmount(() => {
    map.value.delete(id);
  });
  return locked;
}
__name(useBodyScrollLock, "useBodyScrollLock");
function checkOverflowScroll(ele) {
  const style = window.getComputedStyle(ele);
  if (style.overflowX === "scroll" || style.overflowY === "scroll" || style.overflowX === "auto" && ele.clientWidth < ele.scrollWidth || style.overflowY === "auto" && ele.clientHeight < ele.scrollHeight) return true;
  else {
    const parent = ele.parentNode;
    if (!(parent instanceof Element) || parent.tagName === "BODY") return false;
    return checkOverflowScroll(parent);
  }
}
__name(checkOverflowScroll, "checkOverflowScroll");
function preventDefault(rawEvent) {
  const e = rawEvent || window.event;
  const _target = e.target;
  if (_target instanceof Element && checkOverflowScroll(_target)) return false;
  if (e.touches.length > 1) return true;
  if (e.preventDefault && e.cancelable) e.preventDefault();
  return false;
}
__name(preventDefault, "preventDefault");
function $2b4dce13dd5a17fa$export$842a2cf37af977e1(amount, numerator) {
  return amount - numerator * Math.floor(amount / numerator);
}
__name($2b4dce13dd5a17fa$export$842a2cf37af977e1, "$2b4dce13dd5a17fa$export$842a2cf37af977e1");
const $3b62074eb05584b2$var$EPOCH = 1721426;
function $3b62074eb05584b2$export$f297eb839006d339(era, year, month, day) {
  year = $3b62074eb05584b2$export$c36e0ecb2d4fa69d(era, year);
  let y1 = year - 1;
  let monthOffset = -2;
  if (month <= 2) monthOffset = 0;
  else if ($3b62074eb05584b2$export$553d7fa8e3805fc0(year)) monthOffset = -1;
  return $3b62074eb05584b2$var$EPOCH - 1 + 365 * y1 + Math.floor(y1 / 4) - Math.floor(y1 / 100) + Math.floor(y1 / 400) + Math.floor((367 * month - 362) / 12 + monthOffset + day);
}
__name($3b62074eb05584b2$export$f297eb839006d339, "$3b62074eb05584b2$export$f297eb839006d339");
function $3b62074eb05584b2$export$553d7fa8e3805fc0(year) {
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
__name($3b62074eb05584b2$export$553d7fa8e3805fc0, "$3b62074eb05584b2$export$553d7fa8e3805fc0");
function $3b62074eb05584b2$export$c36e0ecb2d4fa69d(era, year) {
  return era === "BC" ? 1 - year : year;
}
__name($3b62074eb05584b2$export$c36e0ecb2d4fa69d, "$3b62074eb05584b2$export$c36e0ecb2d4fa69d");
function $3b62074eb05584b2$export$4475b7e617eb123c(year) {
  let era = "AD";
  if (year <= 0) {
    era = "BC";
    year = 1 - year;
  }
  return [
    era,
    year
  ];
}
__name($3b62074eb05584b2$export$4475b7e617eb123c, "$3b62074eb05584b2$export$4475b7e617eb123c");
const $3b62074eb05584b2$var$daysInMonth = {
  standard: [
    31,
    28,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
  ],
  leapyear: [
    31,
    29,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
  ]
};
class $3b62074eb05584b2$export$80ee6245ec4f29ec {
  static {
    __name(this, "$3b62074eb05584b2$export$80ee6245ec4f29ec");
  }
  fromJulianDay(jd) {
    let jd0 = jd;
    let depoch = jd0 - $3b62074eb05584b2$var$EPOCH;
    let quadricent = Math.floor(depoch / 146097);
    let dqc = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(depoch, 146097);
    let cent = Math.floor(dqc / 36524);
    let dcent = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(dqc, 36524);
    let quad = Math.floor(dcent / 1461);
    let dquad = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(dcent, 1461);
    let yindex = Math.floor(dquad / 365);
    let extendedYear = quadricent * 400 + cent * 100 + quad * 4 + yindex + (cent !== 4 && yindex !== 4 ? 1 : 0);
    let [era, year] = $3b62074eb05584b2$export$4475b7e617eb123c(extendedYear);
    let yearDay = jd0 - $3b62074eb05584b2$export$f297eb839006d339(era, year, 1, 1);
    let leapAdj = 2;
    if (jd0 < $3b62074eb05584b2$export$f297eb839006d339(era, year, 3, 1)) leapAdj = 0;
    else if ($3b62074eb05584b2$export$553d7fa8e3805fc0(year)) leapAdj = 1;
    let month = Math.floor(((yearDay + leapAdj) * 12 + 373) / 367);
    let day = jd0 - $3b62074eb05584b2$export$f297eb839006d339(era, year, month, 1) + 1;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, month, day);
  }
  toJulianDay(date) {
    return $3b62074eb05584b2$export$f297eb839006d339(date.era, date.year, date.month, date.day);
  }
  getDaysInMonth(date) {
    return $3b62074eb05584b2$var$daysInMonth[$3b62074eb05584b2$export$553d7fa8e3805fc0(date.year) ? "leapyear" : "standard"][date.month - 1];
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getMonthsInYear(date) {
    return 12;
  }
  getDaysInYear(date) {
    return $3b62074eb05584b2$export$553d7fa8e3805fc0(date.year) ? 366 : 365;
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getYearsInEra(date) {
    return 9999;
  }
  getEras() {
    return [
      "BC",
      "AD"
    ];
  }
  isInverseEra(date) {
    return date.era === "BC";
  }
  balanceDate(date) {
    if (date.year <= 0) {
      date.era = date.era === "BC" ? "AD" : "BC";
      date.year = 1 - date.year;
    }
  }
  constructor() {
    this.identifier = "gregory";
  }
}
const $2fe286d2fb449abb$export$7a5acbd77d414bd9 = {
  "001": 1,
  AD: 1,
  AE: 6,
  AF: 6,
  AI: 1,
  AL: 1,
  AM: 1,
  AN: 1,
  AR: 1,
  AT: 1,
  AU: 1,
  AX: 1,
  AZ: 1,
  BA: 1,
  BE: 1,
  BG: 1,
  BH: 6,
  BM: 1,
  BN: 1,
  BY: 1,
  CH: 1,
  CL: 1,
  CM: 1,
  CN: 1,
  CR: 1,
  CY: 1,
  CZ: 1,
  DE: 1,
  DJ: 6,
  DK: 1,
  DZ: 6,
  EC: 1,
  EE: 1,
  EG: 6,
  ES: 1,
  FI: 1,
  FJ: 1,
  FO: 1,
  FR: 1,
  GB: 1,
  GE: 1,
  GF: 1,
  GP: 1,
  GR: 1,
  HR: 1,
  HU: 1,
  IE: 1,
  IQ: 6,
  IR: 6,
  IS: 1,
  IT: 1,
  JO: 6,
  KG: 1,
  KW: 6,
  KZ: 1,
  LB: 1,
  LI: 1,
  LK: 1,
  LT: 1,
  LU: 1,
  LV: 1,
  LY: 6,
  MC: 1,
  MD: 1,
  ME: 1,
  MK: 1,
  MN: 1,
  MQ: 1,
  MV: 5,
  MY: 1,
  NL: 1,
  NO: 1,
  NZ: 1,
  OM: 6,
  PL: 1,
  QA: 6,
  RE: 1,
  RO: 1,
  RS: 1,
  RU: 1,
  SD: 6,
  SE: 1,
  SI: 1,
  SK: 1,
  SM: 1,
  SY: 6,
  TJ: 1,
  TM: 1,
  TR: 1,
  UA: 1,
  UY: 1,
  UZ: 1,
  VA: 1,
  VN: 1,
  XK: 1
};
function $14e0f24ef4ac5c92$export$ea39ec197993aef0(a, b) {
  b = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b, a.calendar);
  return a.era === b.era && a.year === b.year && a.month === b.month && a.day === b.day;
}
__name($14e0f24ef4ac5c92$export$ea39ec197993aef0, "$14e0f24ef4ac5c92$export$ea39ec197993aef0");
function $14e0f24ef4ac5c92$export$a18c89cbd24170ff(a, b) {
  b = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b, a.calendar);
  a = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(a);
  b = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(b);
  return a.era === b.era && a.year === b.year && a.month === b.month;
}
__name($14e0f24ef4ac5c92$export$a18c89cbd24170ff, "$14e0f24ef4ac5c92$export$a18c89cbd24170ff");
function $14e0f24ef4ac5c92$export$5841f9eb9773f25f(a, b) {
  b = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b, a.calendar);
  a = $14e0f24ef4ac5c92$export$f91e89d3d0406102(a);
  b = $14e0f24ef4ac5c92$export$f91e89d3d0406102(b);
  return a.era === b.era && a.year === b.year;
}
__name($14e0f24ef4ac5c92$export$5841f9eb9773f25f, "$14e0f24ef4ac5c92$export$5841f9eb9773f25f");
function $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(a, b) {
  return $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a.calendar, b.calendar) && $14e0f24ef4ac5c92$export$ea39ec197993aef0(a, b);
}
__name($14e0f24ef4ac5c92$export$91b62ebf2ba703ee, "$14e0f24ef4ac5c92$export$91b62ebf2ba703ee");
function $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(a, b) {
  return $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a.calendar, b.calendar) && $14e0f24ef4ac5c92$export$a18c89cbd24170ff(a, b);
}
__name($14e0f24ef4ac5c92$export$5a8da0c44a3afdf2, "$14e0f24ef4ac5c92$export$5a8da0c44a3afdf2");
function $14e0f24ef4ac5c92$export$ea840f5a6dda8147(a, b) {
  return $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a.calendar, b.calendar) && $14e0f24ef4ac5c92$export$5841f9eb9773f25f(a, b);
}
__name($14e0f24ef4ac5c92$export$ea840f5a6dda8147, "$14e0f24ef4ac5c92$export$ea840f5a6dda8147");
function $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a, b) {
  var _a_isEqual, _b_isEqual;
  var _a_isEqual1, _ref;
  return (_ref = (_a_isEqual1 = (_a_isEqual = a.isEqual) === null || _a_isEqual === void 0 ? void 0 : _a_isEqual.call(a, b)) !== null && _a_isEqual1 !== void 0 ? _a_isEqual1 : (_b_isEqual = b.isEqual) === null || _b_isEqual === void 0 ? void 0 : _b_isEqual.call(b, a)) !== null && _ref !== void 0 ? _ref : a.identifier === b.identifier;
}
__name($14e0f24ef4ac5c92$export$dbc69fd56b53d5e, "$14e0f24ef4ac5c92$export$dbc69fd56b53d5e");
function $14e0f24ef4ac5c92$export$629b0a497aa65267(date, timeZone) {
  return $14e0f24ef4ac5c92$export$ea39ec197993aef0(date, $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3(timeZone));
}
__name($14e0f24ef4ac5c92$export$629b0a497aa65267, "$14e0f24ef4ac5c92$export$629b0a497aa65267");
const $14e0f24ef4ac5c92$var$DAY_MAP = {
  sun: 0,
  mon: 1,
  tue: 2,
  wed: 3,
  thu: 4,
  fri: 5,
  sat: 6
};
function $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale, firstDayOfWeek) {
  let julian = date.calendar.toJulianDay(date);
  let weekStart = firstDayOfWeek ? $14e0f24ef4ac5c92$var$DAY_MAP[firstDayOfWeek] : $14e0f24ef4ac5c92$var$getWeekStart(locale);
  let dayOfWeek = Math.ceil(julian + 1 - weekStart) % 7;
  if (dayOfWeek < 0) dayOfWeek += 7;
  return dayOfWeek;
}
__name($14e0f24ef4ac5c92$export$2061056d06d7cdf7, "$14e0f24ef4ac5c92$export$2061056d06d7cdf7");
function $14e0f24ef4ac5c92$export$461939dd4422153(timeZone) {
  return (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(Date.now(), timeZone);
}
__name($14e0f24ef4ac5c92$export$461939dd4422153, "$14e0f24ef4ac5c92$export$461939dd4422153");
function $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3(timeZone) {
  return (0, $11d87f3f76e88657$export$93522d1a439f3617)($14e0f24ef4ac5c92$export$461939dd4422153(timeZone));
}
__name($14e0f24ef4ac5c92$export$d0bdf45af03a6ea3, "$14e0f24ef4ac5c92$export$d0bdf45af03a6ea3");
function $14e0f24ef4ac5c92$export$68781ddf31c0090f(a, b) {
  return a.calendar.toJulianDay(a) - b.calendar.toJulianDay(b);
}
__name($14e0f24ef4ac5c92$export$68781ddf31c0090f, "$14e0f24ef4ac5c92$export$68781ddf31c0090f");
function $14e0f24ef4ac5c92$export$c19a80a9721b80f6(a, b) {
  return $14e0f24ef4ac5c92$var$timeToMs(a) - $14e0f24ef4ac5c92$var$timeToMs(b);
}
__name($14e0f24ef4ac5c92$export$c19a80a9721b80f6, "$14e0f24ef4ac5c92$export$c19a80a9721b80f6");
function $14e0f24ef4ac5c92$var$timeToMs(a) {
  return a.hour * 36e5 + a.minute * 6e4 + a.second * 1e3 + a.millisecond;
}
__name($14e0f24ef4ac5c92$var$timeToMs, "$14e0f24ef4ac5c92$var$timeToMs");
function $14e0f24ef4ac5c92$export$126c91c941de7e(a, timeZone) {
  let ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(a, timeZone);
  let tomorrow = a.add({
    days: 1
  });
  let tomorrowMs = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(tomorrow, timeZone);
  return (tomorrowMs - ms) / 36e5;
}
__name($14e0f24ef4ac5c92$export$126c91c941de7e, "$14e0f24ef4ac5c92$export$126c91c941de7e");
let $14e0f24ef4ac5c92$var$localTimeZone = null;
function $14e0f24ef4ac5c92$export$aa8b41735afcabd2() {
  if ($14e0f24ef4ac5c92$var$localTimeZone == null) $14e0f24ef4ac5c92$var$localTimeZone = new Intl.DateTimeFormat().resolvedOptions().timeZone;
  return $14e0f24ef4ac5c92$var$localTimeZone;
}
__name($14e0f24ef4ac5c92$export$aa8b41735afcabd2, "$14e0f24ef4ac5c92$export$aa8b41735afcabd2");
function $14e0f24ef4ac5c92$export$61a9d83ceb59a3dd(timeZone) {
  $14e0f24ef4ac5c92$var$localTimeZone = timeZone;
}
__name($14e0f24ef4ac5c92$export$61a9d83ceb59a3dd, "$14e0f24ef4ac5c92$export$61a9d83ceb59a3dd");
function $14e0f24ef4ac5c92$export$55753838ffe79333() {
  $14e0f24ef4ac5c92$var$localTimeZone = null;
}
__name($14e0f24ef4ac5c92$export$55753838ffe79333, "$14e0f24ef4ac5c92$export$55753838ffe79333");
function $14e0f24ef4ac5c92$export$a5a3b454ada2268e(date) {
  return date.subtract({
    days: date.day - 1
  });
}
__name($14e0f24ef4ac5c92$export$a5a3b454ada2268e, "$14e0f24ef4ac5c92$export$a5a3b454ada2268e");
function $14e0f24ef4ac5c92$export$a2258d9c4118825c(date) {
  return date.add({
    days: date.calendar.getDaysInMonth(date) - date.day
  });
}
__name($14e0f24ef4ac5c92$export$a2258d9c4118825c, "$14e0f24ef4ac5c92$export$a2258d9c4118825c");
function $14e0f24ef4ac5c92$export$f91e89d3d0406102(date) {
  return $14e0f24ef4ac5c92$export$a5a3b454ada2268e(date.subtract({
    months: date.month - 1
  }));
}
__name($14e0f24ef4ac5c92$export$f91e89d3d0406102, "$14e0f24ef4ac5c92$export$f91e89d3d0406102");
function $14e0f24ef4ac5c92$export$8b7aa55c66d5569e(date) {
  return $14e0f24ef4ac5c92$export$a2258d9c4118825c(date.add({
    months: date.calendar.getMonthsInYear(date) - date.month
  }));
}
__name($14e0f24ef4ac5c92$export$8b7aa55c66d5569e, "$14e0f24ef4ac5c92$export$8b7aa55c66d5569e");
function $14e0f24ef4ac5c92$export$5412ac11713b72ad(date) {
  if (date.calendar.getMinimumMonthInYear) return date.calendar.getMinimumMonthInYear(date);
  return 1;
}
__name($14e0f24ef4ac5c92$export$5412ac11713b72ad, "$14e0f24ef4ac5c92$export$5412ac11713b72ad");
function $14e0f24ef4ac5c92$export$b2f4953d301981d5(date) {
  if (date.calendar.getMinimumDayInMonth) return date.calendar.getMinimumDayInMonth(date);
  return 1;
}
__name($14e0f24ef4ac5c92$export$b2f4953d301981d5, "$14e0f24ef4ac5c92$export$b2f4953d301981d5");
function $14e0f24ef4ac5c92$export$42c81a444fbfb5d4(date, locale, firstDayOfWeek) {
  let dayOfWeek = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale, firstDayOfWeek);
  return date.subtract({
    days: dayOfWeek
  });
}
__name($14e0f24ef4ac5c92$export$42c81a444fbfb5d4, "$14e0f24ef4ac5c92$export$42c81a444fbfb5d4");
function $14e0f24ef4ac5c92$export$ef8b6d9133084f4e(date, locale, firstDayOfWeek) {
  return $14e0f24ef4ac5c92$export$42c81a444fbfb5d4(date, locale, firstDayOfWeek).add({
    days: 6
  });
}
__name($14e0f24ef4ac5c92$export$ef8b6d9133084f4e, "$14e0f24ef4ac5c92$export$ef8b6d9133084f4e");
const $14e0f24ef4ac5c92$var$cachedRegions = /* @__PURE__ */ new Map();
function $14e0f24ef4ac5c92$var$getRegion(locale) {
  if (Intl.Locale) {
    let region = $14e0f24ef4ac5c92$var$cachedRegions.get(locale);
    if (!region) {
      region = new Intl.Locale(locale).maximize().region;
      if (region) $14e0f24ef4ac5c92$var$cachedRegions.set(locale, region);
    }
    return region;
  }
  let part = locale.split("-")[1];
  return part === "u" ? void 0 : part;
}
__name($14e0f24ef4ac5c92$var$getRegion, "$14e0f24ef4ac5c92$var$getRegion");
function $14e0f24ef4ac5c92$var$getWeekStart(locale) {
  let region = $14e0f24ef4ac5c92$var$getRegion(locale);
  return region ? (0, $2fe286d2fb449abb$export$7a5acbd77d414bd9)[region] || 0 : 0;
}
__name($14e0f24ef4ac5c92$var$getWeekStart, "$14e0f24ef4ac5c92$var$getWeekStart");
function $14e0f24ef4ac5c92$export$ccc1b2479e7dd654(date, locale, firstDayOfWeek) {
  let days = date.calendar.getDaysInMonth(date);
  return Math.ceil(($14e0f24ef4ac5c92$export$2061056d06d7cdf7($14e0f24ef4ac5c92$export$a5a3b454ada2268e(date), locale, firstDayOfWeek) + days) / 7);
}
__name($14e0f24ef4ac5c92$export$ccc1b2479e7dd654, "$14e0f24ef4ac5c92$export$ccc1b2479e7dd654");
function $14e0f24ef4ac5c92$export$5c333a116e949cdd(a, b) {
  if (a && b) return a.compare(b) <= 0 ? a : b;
  return a || b;
}
__name($14e0f24ef4ac5c92$export$5c333a116e949cdd, "$14e0f24ef4ac5c92$export$5c333a116e949cdd");
function $14e0f24ef4ac5c92$export$a75f2bff57811055(a, b) {
  if (a && b) return a.compare(b) >= 0 ? a : b;
  return a || b;
}
__name($14e0f24ef4ac5c92$export$a75f2bff57811055, "$14e0f24ef4ac5c92$export$a75f2bff57811055");
const $14e0f24ef4ac5c92$var$WEEKEND_DATA = {
  AF: [
    4,
    5
  ],
  AE: [
    5,
    6
  ],
  BH: [
    5,
    6
  ],
  DZ: [
    5,
    6
  ],
  EG: [
    5,
    6
  ],
  IL: [
    5,
    6
  ],
  IQ: [
    5,
    6
  ],
  IR: [
    5,
    5
  ],
  JO: [
    5,
    6
  ],
  KW: [
    5,
    6
  ],
  LY: [
    5,
    6
  ],
  OM: [
    5,
    6
  ],
  QA: [
    5,
    6
  ],
  SA: [
    5,
    6
  ],
  SD: [
    5,
    6
  ],
  SY: [
    5,
    6
  ],
  YE: [
    5,
    6
  ]
};
function $14e0f24ef4ac5c92$export$618d60ea299da42(date, locale) {
  let julian = date.calendar.toJulianDay(date);
  let dayOfWeek = Math.ceil(julian + 1) % 7;
  if (dayOfWeek < 0) dayOfWeek += 7;
  let region = $14e0f24ef4ac5c92$var$getRegion(locale);
  let [start, end] = $14e0f24ef4ac5c92$var$WEEKEND_DATA[region] || [
    6,
    0
  ];
  return dayOfWeek === start || dayOfWeek === end;
}
__name($14e0f24ef4ac5c92$export$618d60ea299da42, "$14e0f24ef4ac5c92$export$618d60ea299da42");
function $14e0f24ef4ac5c92$export$ee9d87258e1d19ed(date, locale) {
  return !$14e0f24ef4ac5c92$export$618d60ea299da42(date, locale);
}
__name($14e0f24ef4ac5c92$export$ee9d87258e1d19ed, "$14e0f24ef4ac5c92$export$ee9d87258e1d19ed");
function $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) {
  date = $11d87f3f76e88657$export$b4a036af3fc0b032(date, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
  let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(date.era, date.year);
  return $11d87f3f76e88657$var$epochFromParts(year, date.month, date.day, date.hour, date.minute, date.second, date.millisecond);
}
__name($11d87f3f76e88657$export$bd4fb2bc8bb06fb, "$11d87f3f76e88657$export$bd4fb2bc8bb06fb");
function $11d87f3f76e88657$var$epochFromParts(year, month, day, hour, minute, second, millisecond) {
  let date = /* @__PURE__ */ new Date();
  date.setUTCHours(hour, minute, second, millisecond);
  date.setUTCFullYear(year, month - 1, day);
  return date.getTime();
}
__name($11d87f3f76e88657$var$epochFromParts, "$11d87f3f76e88657$var$epochFromParts");
function $11d87f3f76e88657$export$59c99f3515d3493f(ms, timeZone) {
  if (timeZone === "UTC") return 0;
  if (ms > 0 && timeZone === (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)()) return new Date(ms).getTimezoneOffset() * -6e4;
  let { year, month, day, hour, minute, second } = $11d87f3f76e88657$var$getTimeZoneParts(ms, timeZone);
  let utc = $11d87f3f76e88657$var$epochFromParts(year, month, day, hour, minute, second, 0);
  return utc - Math.floor(ms / 1e3) * 1e3;
}
__name($11d87f3f76e88657$export$59c99f3515d3493f, "$11d87f3f76e88657$export$59c99f3515d3493f");
const $11d87f3f76e88657$var$formattersByTimeZone = /* @__PURE__ */ new Map();
function $11d87f3f76e88657$var$getTimeZoneParts(ms, timeZone) {
  let formatter = $11d87f3f76e88657$var$formattersByTimeZone.get(timeZone);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat("en-US", {
      timeZone,
      hour12: false,
      era: "short",
      year: "numeric",
      month: "numeric",
      day: "numeric",
      hour: "numeric",
      minute: "numeric",
      second: "numeric"
    });
    $11d87f3f76e88657$var$formattersByTimeZone.set(timeZone, formatter);
  }
  let parts = formatter.formatToParts(new Date(ms));
  let namedParts = {};
  for (let part of parts) if (part.type !== "literal") namedParts[part.type] = part.value;
  return {
    // Firefox returns B instead of BC... https://bugzilla.mozilla.org/show_bug.cgi?id=1752253
    year: namedParts.era === "BC" || namedParts.era === "B" ? -namedParts.year + 1 : +namedParts.year,
    month: +namedParts.month,
    day: +namedParts.day,
    hour: namedParts.hour === "24" ? 0 : +namedParts.hour,
    minute: +namedParts.minute,
    second: +namedParts.second
  };
}
__name($11d87f3f76e88657$var$getTimeZoneParts, "$11d87f3f76e88657$var$getTimeZoneParts");
const $11d87f3f76e88657$var$DAYMILLIS = 864e5;
function $11d87f3f76e88657$export$136f38efe7caf549(date, timeZone) {
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date);
  let earlier = ms - $11d87f3f76e88657$export$59c99f3515d3493f(ms - $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let later = ms - $11d87f3f76e88657$export$59c99f3515d3493f(ms + $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  return $11d87f3f76e88657$var$getValidWallTimes(date, timeZone, earlier, later);
}
__name($11d87f3f76e88657$export$136f38efe7caf549, "$11d87f3f76e88657$export$136f38efe7caf549");
function $11d87f3f76e88657$var$getValidWallTimes(date, timeZone, earlier, later) {
  let found = earlier === later ? [
    earlier
  ] : [
    earlier,
    later
  ];
  return found.filter((absolute) => $11d87f3f76e88657$var$isValidWallTime(date, timeZone, absolute));
}
__name($11d87f3f76e88657$var$getValidWallTimes, "$11d87f3f76e88657$var$getValidWallTimes");
function $11d87f3f76e88657$var$isValidWallTime(date, timeZone, absolute) {
  let parts = $11d87f3f76e88657$var$getTimeZoneParts(absolute, timeZone);
  return date.year === parts.year && date.month === parts.month && date.day === parts.day && date.hour === parts.hour && date.minute === parts.minute && date.second === parts.second;
}
__name($11d87f3f76e88657$var$isValidWallTime, "$11d87f3f76e88657$var$isValidWallTime");
function $11d87f3f76e88657$export$5107c82f94518f5c(date, timeZone, disambiguation = "compatible") {
  let dateTime = $11d87f3f76e88657$export$b21e0b124e224484(date);
  if (timeZone === "UTC") return $11d87f3f76e88657$export$bd4fb2bc8bb06fb(dateTime);
  if (timeZone === (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)() && disambiguation === "compatible") {
    dateTime = $11d87f3f76e88657$export$b4a036af3fc0b032(dateTime, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
    let date2 = /* @__PURE__ */ new Date();
    let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(dateTime.era, dateTime.year);
    date2.setFullYear(year, dateTime.month - 1, dateTime.day);
    date2.setHours(dateTime.hour, dateTime.minute, dateTime.second, dateTime.millisecond);
    return date2.getTime();
  }
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(dateTime);
  let offsetBefore = $11d87f3f76e88657$export$59c99f3515d3493f(ms - $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let offsetAfter = $11d87f3f76e88657$export$59c99f3515d3493f(ms + $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let valid = $11d87f3f76e88657$var$getValidWallTimes(dateTime, timeZone, ms - offsetBefore, ms - offsetAfter);
  if (valid.length === 1) return valid[0];
  if (valid.length > 1) switch (disambiguation) {
    case "compatible":
    case "earlier":
      return valid[0];
    case "later":
      return valid[valid.length - 1];
    case "reject":
      throw new RangeError("Multiple possible absolute times found");
  }
  switch (disambiguation) {
    case "earlier":
      return Math.min(ms - offsetBefore, ms - offsetAfter);
    case "compatible":
    case "later":
      return Math.max(ms - offsetBefore, ms - offsetAfter);
    case "reject":
      throw new RangeError("No such absolute time found");
  }
}
__name($11d87f3f76e88657$export$5107c82f94518f5c, "$11d87f3f76e88657$export$5107c82f94518f5c");
function $11d87f3f76e88657$export$e67a095c620b86fe(dateTime, timeZone, disambiguation = "compatible") {
  return new Date($11d87f3f76e88657$export$5107c82f94518f5c(dateTime, timeZone, disambiguation));
}
__name($11d87f3f76e88657$export$e67a095c620b86fe, "$11d87f3f76e88657$export$e67a095c620b86fe");
function $11d87f3f76e88657$export$1b96692a1ba042ac(ms, timeZone) {
  let offset2 = $11d87f3f76e88657$export$59c99f3515d3493f(ms, timeZone);
  let date = new Date(ms + offset2);
  let year = date.getUTCFullYear();
  let month = date.getUTCMonth() + 1;
  let day = date.getUTCDate();
  let hour = date.getUTCHours();
  let minute = date.getUTCMinutes();
  let second = date.getUTCSeconds();
  let millisecond = date.getUTCMilliseconds();
  return new (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)(year < 1 ? "BC" : "AD", year < 1 ? -year + 1 : year, month, day, timeZone, offset2, hour, minute, second, millisecond);
}
__name($11d87f3f76e88657$export$1b96692a1ba042ac, "$11d87f3f76e88657$export$1b96692a1ba042ac");
function $11d87f3f76e88657$export$e57ff100d91bd4b9(date, timeZone) {
  return $11d87f3f76e88657$export$1b96692a1ba042ac(date.getTime(), timeZone);
}
__name($11d87f3f76e88657$export$e57ff100d91bd4b9, "$11d87f3f76e88657$export$e57ff100d91bd4b9");
function $11d87f3f76e88657$export$d7f92bcd3596b086(date) {
  return $11d87f3f76e88657$export$e57ff100d91bd4b9(date, (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)());
}
__name($11d87f3f76e88657$export$d7f92bcd3596b086, "$11d87f3f76e88657$export$d7f92bcd3596b086");
function $11d87f3f76e88657$export$93522d1a439f3617(dateTime) {
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(dateTime.calendar, dateTime.era, dateTime.year, dateTime.month, dateTime.day);
}
__name($11d87f3f76e88657$export$93522d1a439f3617, "$11d87f3f76e88657$export$93522d1a439f3617");
function $11d87f3f76e88657$export$6f4d78149f3f53ac(date) {
  return {
    era: date.era,
    year: date.year,
    month: date.month,
    day: date.day
  };
}
__name($11d87f3f76e88657$export$6f4d78149f3f53ac, "$11d87f3f76e88657$export$6f4d78149f3f53ac");
function $11d87f3f76e88657$export$4d0393e732857be5(date) {
  return {
    hour: date.hour,
    minute: date.minute,
    second: date.second,
    millisecond: date.millisecond
  };
}
__name($11d87f3f76e88657$export$4d0393e732857be5, "$11d87f3f76e88657$export$4d0393e732857be5");
function $11d87f3f76e88657$export$b21e0b124e224484(date, time) {
  let hour = 0, minute = 0, second = 0, millisecond = 0;
  if ("timeZone" in date) ({ hour, minute, second, millisecond } = date);
  else if ("hour" in date && !time) return date;
  if (time) ({ hour, minute, second, millisecond } = time);
  return new (0, $35ea8db9cb2ccb90$export$ca871e8dbb80966f)(date.calendar, date.era, date.year, date.month, date.day, hour, minute, second, millisecond);
}
__name($11d87f3f76e88657$export$b21e0b124e224484, "$11d87f3f76e88657$export$b21e0b124e224484");
function $11d87f3f76e88657$export$d33f79e3ffc3dc83(dateTime) {
  return new (0, $35ea8db9cb2ccb90$export$680ea196effce5f)(dateTime.hour, dateTime.minute, dateTime.second, dateTime.millisecond);
}
__name($11d87f3f76e88657$export$d33f79e3ffc3dc83, "$11d87f3f76e88657$export$d33f79e3ffc3dc83");
function $11d87f3f76e88657$export$b4a036af3fc0b032(date, calendar) {
  if ((0, $14e0f24ef4ac5c92$export$dbc69fd56b53d5e)(date.calendar, calendar)) return date;
  let calendarDate = calendar.fromJulianDay(date.calendar.toJulianDay(date));
  let copy = date.copy();
  copy.calendar = calendar;
  copy.era = calendarDate.era;
  copy.year = calendarDate.year;
  copy.month = calendarDate.month;
  copy.day = calendarDate.day;
  (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(copy);
  return copy;
}
__name($11d87f3f76e88657$export$b4a036af3fc0b032, "$11d87f3f76e88657$export$b4a036af3fc0b032");
function $11d87f3f76e88657$export$84c95a83c799e074(date, timeZone, disambiguation) {
  if (date instanceof (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)) {
    if (date.timeZone === timeZone) return date;
    return $11d87f3f76e88657$export$538b00033cc11c75(date, timeZone);
  }
  let ms = $11d87f3f76e88657$export$5107c82f94518f5c(date, timeZone, disambiguation);
  return $11d87f3f76e88657$export$1b96692a1ba042ac(ms, timeZone);
}
__name($11d87f3f76e88657$export$84c95a83c799e074, "$11d87f3f76e88657$export$84c95a83c799e074");
function $11d87f3f76e88657$export$83aac07b4c37b25(date) {
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) - date.offset;
  return new Date(ms);
}
__name($11d87f3f76e88657$export$83aac07b4c37b25, "$11d87f3f76e88657$export$83aac07b4c37b25");
function $11d87f3f76e88657$export$538b00033cc11c75(date, timeZone) {
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) - date.offset;
  return $11d87f3f76e88657$export$b4a036af3fc0b032($11d87f3f76e88657$export$1b96692a1ba042ac(ms, timeZone), date.calendar);
}
__name($11d87f3f76e88657$export$538b00033cc11c75, "$11d87f3f76e88657$export$538b00033cc11c75");
function $11d87f3f76e88657$export$d9b67bc93c097491(date) {
  return $11d87f3f76e88657$export$538b00033cc11c75(date, (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)());
}
__name($11d87f3f76e88657$export$d9b67bc93c097491, "$11d87f3f76e88657$export$d9b67bc93c097491");
const $735220c2d4774dd3$var$ONE_HOUR = 36e5;
function $735220c2d4774dd3$export$e16d8520af44a096(date, duration) {
  let mutableDate = date.copy();
  let days = "hour" in mutableDate ? $735220c2d4774dd3$var$addTimeFields(mutableDate, duration) : 0;
  $735220c2d4774dd3$var$addYears(mutableDate, duration.years || 0);
  if (mutableDate.calendar.balanceYearMonth) mutableDate.calendar.balanceYearMonth(mutableDate, date);
  mutableDate.month += duration.months || 0;
  $735220c2d4774dd3$var$balanceYearMonth(mutableDate);
  $735220c2d4774dd3$var$constrainMonthDay(mutableDate);
  mutableDate.day += (duration.weeks || 0) * 7;
  mutableDate.day += duration.days || 0;
  mutableDate.day += days;
  $735220c2d4774dd3$var$balanceDay(mutableDate);
  if (mutableDate.calendar.balanceDate) mutableDate.calendar.balanceDate(mutableDate);
  if (mutableDate.year < 1) {
    mutableDate.year = 1;
    mutableDate.month = 1;
    mutableDate.day = 1;
  }
  let maxYear = mutableDate.calendar.getYearsInEra(mutableDate);
  if (mutableDate.year > maxYear) {
    var _mutableDate_calendar_isInverseEra, _mutableDate_calendar;
    let isInverseEra = (_mutableDate_calendar_isInverseEra = (_mutableDate_calendar = mutableDate.calendar).isInverseEra) === null || _mutableDate_calendar_isInverseEra === void 0 ? void 0 : _mutableDate_calendar_isInverseEra.call(_mutableDate_calendar, mutableDate);
    mutableDate.year = maxYear;
    mutableDate.month = isInverseEra ? 1 : mutableDate.calendar.getMonthsInYear(mutableDate);
    mutableDate.day = isInverseEra ? 1 : mutableDate.calendar.getDaysInMonth(mutableDate);
  }
  if (mutableDate.month < 1) {
    mutableDate.month = 1;
    mutableDate.day = 1;
  }
  let maxMonth = mutableDate.calendar.getMonthsInYear(mutableDate);
  if (mutableDate.month > maxMonth) {
    mutableDate.month = maxMonth;
    mutableDate.day = mutableDate.calendar.getDaysInMonth(mutableDate);
  }
  mutableDate.day = Math.max(1, Math.min(mutableDate.calendar.getDaysInMonth(mutableDate), mutableDate.day));
  return mutableDate;
}
__name($735220c2d4774dd3$export$e16d8520af44a096, "$735220c2d4774dd3$export$e16d8520af44a096");
function $735220c2d4774dd3$var$addYears(date, years) {
  var _date_calendar_isInverseEra, _date_calendar;
  if ((_date_calendar_isInverseEra = (_date_calendar = date.calendar).isInverseEra) === null || _date_calendar_isInverseEra === void 0 ? void 0 : _date_calendar_isInverseEra.call(_date_calendar, date)) years = -years;
  date.year += years;
}
__name($735220c2d4774dd3$var$addYears, "$735220c2d4774dd3$var$addYears");
function $735220c2d4774dd3$var$balanceYearMonth(date) {
  while (date.month < 1) {
    $735220c2d4774dd3$var$addYears(date, -1);
    date.month += date.calendar.getMonthsInYear(date);
  }
  let monthsInYear = 0;
  while (date.month > (monthsInYear = date.calendar.getMonthsInYear(date))) {
    date.month -= monthsInYear;
    $735220c2d4774dd3$var$addYears(date, 1);
  }
}
__name($735220c2d4774dd3$var$balanceYearMonth, "$735220c2d4774dd3$var$balanceYearMonth");
function $735220c2d4774dd3$var$balanceDay(date) {
  while (date.day < 1) {
    date.month--;
    $735220c2d4774dd3$var$balanceYearMonth(date);
    date.day += date.calendar.getDaysInMonth(date);
  }
  while (date.day > date.calendar.getDaysInMonth(date)) {
    date.day -= date.calendar.getDaysInMonth(date);
    date.month++;
    $735220c2d4774dd3$var$balanceYearMonth(date);
  }
}
__name($735220c2d4774dd3$var$balanceDay, "$735220c2d4774dd3$var$balanceDay");
function $735220c2d4774dd3$var$constrainMonthDay(date) {
  date.month = Math.max(1, Math.min(date.calendar.getMonthsInYear(date), date.month));
  date.day = Math.max(1, Math.min(date.calendar.getDaysInMonth(date), date.day));
}
__name($735220c2d4774dd3$var$constrainMonthDay, "$735220c2d4774dd3$var$constrainMonthDay");
function $735220c2d4774dd3$export$c4e2ecac49351ef2(date) {
  if (date.calendar.constrainDate) date.calendar.constrainDate(date);
  date.year = Math.max(1, Math.min(date.calendar.getYearsInEra(date), date.year));
  $735220c2d4774dd3$var$constrainMonthDay(date);
}
__name($735220c2d4774dd3$export$c4e2ecac49351ef2, "$735220c2d4774dd3$export$c4e2ecac49351ef2");
function $735220c2d4774dd3$export$3e2544e88a25bff8(duration) {
  let inverseDuration = {};
  for (let key in duration) if (typeof duration[key] === "number") inverseDuration[key] = -duration[key];
  return inverseDuration;
}
__name($735220c2d4774dd3$export$3e2544e88a25bff8, "$735220c2d4774dd3$export$3e2544e88a25bff8");
function $735220c2d4774dd3$export$4e2d2ead65e5f7e3(date, duration) {
  return $735220c2d4774dd3$export$e16d8520af44a096(date, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
__name($735220c2d4774dd3$export$4e2d2ead65e5f7e3, "$735220c2d4774dd3$export$4e2d2ead65e5f7e3");
function $735220c2d4774dd3$export$adaa4cf7ef1b65be(date, fields) {
  let mutableDate = date.copy();
  if (fields.era != null) mutableDate.era = fields.era;
  if (fields.year != null) mutableDate.year = fields.year;
  if (fields.month != null) mutableDate.month = fields.month;
  if (fields.day != null) mutableDate.day = fields.day;
  $735220c2d4774dd3$export$c4e2ecac49351ef2(mutableDate);
  return mutableDate;
}
__name($735220c2d4774dd3$export$adaa4cf7ef1b65be, "$735220c2d4774dd3$export$adaa4cf7ef1b65be");
function $735220c2d4774dd3$export$e5d5e1c1822b6e56(value, fields) {
  let mutableValue = value.copy();
  if (fields.hour != null) mutableValue.hour = fields.hour;
  if (fields.minute != null) mutableValue.minute = fields.minute;
  if (fields.second != null) mutableValue.second = fields.second;
  if (fields.millisecond != null) mutableValue.millisecond = fields.millisecond;
  $735220c2d4774dd3$export$7555de1e070510cb(mutableValue);
  return mutableValue;
}
__name($735220c2d4774dd3$export$e5d5e1c1822b6e56, "$735220c2d4774dd3$export$e5d5e1c1822b6e56");
function $735220c2d4774dd3$var$balanceTime(time) {
  time.second += Math.floor(time.millisecond / 1e3);
  time.millisecond = $735220c2d4774dd3$var$nonNegativeMod(time.millisecond, 1e3);
  time.minute += Math.floor(time.second / 60);
  time.second = $735220c2d4774dd3$var$nonNegativeMod(time.second, 60);
  time.hour += Math.floor(time.minute / 60);
  time.minute = $735220c2d4774dd3$var$nonNegativeMod(time.minute, 60);
  let days = Math.floor(time.hour / 24);
  time.hour = $735220c2d4774dd3$var$nonNegativeMod(time.hour, 24);
  return days;
}
__name($735220c2d4774dd3$var$balanceTime, "$735220c2d4774dd3$var$balanceTime");
function $735220c2d4774dd3$export$7555de1e070510cb(time) {
  time.millisecond = Math.max(0, Math.min(time.millisecond, 1e3));
  time.second = Math.max(0, Math.min(time.second, 59));
  time.minute = Math.max(0, Math.min(time.minute, 59));
  time.hour = Math.max(0, Math.min(time.hour, 23));
}
__name($735220c2d4774dd3$export$7555de1e070510cb, "$735220c2d4774dd3$export$7555de1e070510cb");
function $735220c2d4774dd3$var$nonNegativeMod(a, b) {
  let result = a % b;
  if (result < 0) result += b;
  return result;
}
__name($735220c2d4774dd3$var$nonNegativeMod, "$735220c2d4774dd3$var$nonNegativeMod");
function $735220c2d4774dd3$var$addTimeFields(time, duration) {
  time.hour += duration.hours || 0;
  time.minute += duration.minutes || 0;
  time.second += duration.seconds || 0;
  time.millisecond += duration.milliseconds || 0;
  return $735220c2d4774dd3$var$balanceTime(time);
}
__name($735220c2d4774dd3$var$addTimeFields, "$735220c2d4774dd3$var$addTimeFields");
function $735220c2d4774dd3$export$7ed87b6bc2506470(time, duration) {
  let res = time.copy();
  $735220c2d4774dd3$var$addTimeFields(res, duration);
  return res;
}
__name($735220c2d4774dd3$export$7ed87b6bc2506470, "$735220c2d4774dd3$export$7ed87b6bc2506470");
function $735220c2d4774dd3$export$fe34d3a381cd7501(time, duration) {
  return $735220c2d4774dd3$export$7ed87b6bc2506470(time, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
__name($735220c2d4774dd3$export$fe34d3a381cd7501, "$735220c2d4774dd3$export$fe34d3a381cd7501");
function $735220c2d4774dd3$export$d52ced6badfb9a4c(value, field, amount, options) {
  let mutable = value.copy();
  switch (field) {
    case "era": {
      let eras = value.calendar.getEras();
      let eraIndex = eras.indexOf(value.era);
      if (eraIndex < 0) throw new Error("Invalid era: " + value.era);
      eraIndex = $735220c2d4774dd3$var$cycleValue(eraIndex, amount, 0, eras.length - 1, options === null || options === void 0 ? void 0 : options.round);
      mutable.era = eras[eraIndex];
      $735220c2d4774dd3$export$c4e2ecac49351ef2(mutable);
      break;
    }
    case "year":
      var _mutable_calendar_isInverseEra, _mutable_calendar;
      if ((_mutable_calendar_isInverseEra = (_mutable_calendar = mutable.calendar).isInverseEra) === null || _mutable_calendar_isInverseEra === void 0 ? void 0 : _mutable_calendar_isInverseEra.call(_mutable_calendar, mutable)) amount = -amount;
      mutable.year = $735220c2d4774dd3$var$cycleValue(value.year, amount, -Infinity, 9999, options === null || options === void 0 ? void 0 : options.round);
      if (mutable.year === -Infinity) mutable.year = 1;
      if (mutable.calendar.balanceYearMonth) mutable.calendar.balanceYearMonth(mutable, value);
      break;
    case "month":
      mutable.month = $735220c2d4774dd3$var$cycleValue(value.month, amount, 1, value.calendar.getMonthsInYear(value), options === null || options === void 0 ? void 0 : options.round);
      break;
    case "day":
      mutable.day = $735220c2d4774dd3$var$cycleValue(value.day, amount, 1, value.calendar.getDaysInMonth(value), options === null || options === void 0 ? void 0 : options.round);
      break;
    default:
      throw new Error("Unsupported field " + field);
  }
  if (value.calendar.balanceDate) value.calendar.balanceDate(mutable);
  $735220c2d4774dd3$export$c4e2ecac49351ef2(mutable);
  return mutable;
}
__name($735220c2d4774dd3$export$d52ced6badfb9a4c, "$735220c2d4774dd3$export$d52ced6badfb9a4c");
function $735220c2d4774dd3$export$dd02b3e0007dfe28(value, field, amount, options) {
  let mutable = value.copy();
  switch (field) {
    case "hour": {
      let hours = value.hour;
      let min2 = 0;
      let max2 = 23;
      if ((options === null || options === void 0 ? void 0 : options.hourCycle) === 12) {
        let isPM = hours >= 12;
        min2 = isPM ? 12 : 0;
        max2 = isPM ? 23 : 11;
      }
      mutable.hour = $735220c2d4774dd3$var$cycleValue(hours, amount, min2, max2, options === null || options === void 0 ? void 0 : options.round);
      break;
    }
    case "minute":
      mutable.minute = $735220c2d4774dd3$var$cycleValue(value.minute, amount, 0, 59, options === null || options === void 0 ? void 0 : options.round);
      break;
    case "second":
      mutable.second = $735220c2d4774dd3$var$cycleValue(value.second, amount, 0, 59, options === null || options === void 0 ? void 0 : options.round);
      break;
    case "millisecond":
      mutable.millisecond = $735220c2d4774dd3$var$cycleValue(value.millisecond, amount, 0, 999, options === null || options === void 0 ? void 0 : options.round);
      break;
    default:
      throw new Error("Unsupported field " + field);
  }
  return mutable;
}
__name($735220c2d4774dd3$export$dd02b3e0007dfe28, "$735220c2d4774dd3$export$dd02b3e0007dfe28");
function $735220c2d4774dd3$var$cycleValue(value, amount, min2, max2, round2 = false) {
  if (round2) {
    value += Math.sign(amount);
    if (value < min2) value = max2;
    let div = Math.abs(amount);
    if (amount > 0) value = Math.ceil(value / div) * div;
    else value = Math.floor(value / div) * div;
    if (value > max2) value = min2;
  } else {
    value += amount;
    if (value < min2) value = max2 - (min2 - value - 1);
    else if (value > max2) value = min2 + (value - max2 - 1);
  }
  return value;
}
__name($735220c2d4774dd3$var$cycleValue, "$735220c2d4774dd3$var$cycleValue");
function $735220c2d4774dd3$export$96b1d28349274637(dateTime, duration) {
  let ms;
  if (duration.years != null && duration.years !== 0 || duration.months != null && duration.months !== 0 || duration.weeks != null && duration.weeks !== 0 || duration.days != null && duration.days !== 0) {
    let res2 = $735220c2d4774dd3$export$e16d8520af44a096((0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime), {
      years: duration.years,
      months: duration.months,
      weeks: duration.weeks,
      days: duration.days
    });
    ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res2, dateTime.timeZone);
  } else
    ms = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(dateTime) - dateTime.offset;
  ms += duration.milliseconds || 0;
  ms += (duration.seconds || 0) * 1e3;
  ms += (duration.minutes || 0) * 6e4;
  ms += (duration.hours || 0) * 36e5;
  let res = (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone);
  return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(res, dateTime.calendar);
}
__name($735220c2d4774dd3$export$96b1d28349274637, "$735220c2d4774dd3$export$96b1d28349274637");
function $735220c2d4774dd3$export$6814caac34ca03c7(dateTime, duration) {
  return $735220c2d4774dd3$export$96b1d28349274637(dateTime, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
__name($735220c2d4774dd3$export$6814caac34ca03c7, "$735220c2d4774dd3$export$6814caac34ca03c7");
function $735220c2d4774dd3$export$9a297d111fc86b79(dateTime, field, amount, options) {
  switch (field) {
    case "hour": {
      let min2 = 0;
      let max2 = 23;
      if ((options === null || options === void 0 ? void 0 : options.hourCycle) === 12) {
        let isPM = dateTime.hour >= 12;
        min2 = isPM ? 12 : 0;
        max2 = isPM ? 23 : 11;
      }
      let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime);
      let minDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)($735220c2d4774dd3$export$e5d5e1c1822b6e56(plainDateTime, {
        hour: min2
      }), new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
      let minAbsolute = [
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(minDate, dateTime.timeZone, "earlier"),
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(minDate, dateTime.timeZone, "later")
      ].filter((ms2) => (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone).day === minDate.day)[0];
      let maxDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)($735220c2d4774dd3$export$e5d5e1c1822b6e56(plainDateTime, {
        hour: max2
      }), new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
      let maxAbsolute = [
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(maxDate, dateTime.timeZone, "earlier"),
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(maxDate, dateTime.timeZone, "later")
      ].filter((ms2) => (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone).day === maxDate.day).pop();
      let ms = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(dateTime) - dateTime.offset;
      let hours = Math.floor(ms / $735220c2d4774dd3$var$ONE_HOUR);
      let remainder = ms % $735220c2d4774dd3$var$ONE_HOUR;
      ms = $735220c2d4774dd3$var$cycleValue(hours, amount, Math.floor(minAbsolute / $735220c2d4774dd3$var$ONE_HOUR), Math.floor(maxAbsolute / $735220c2d4774dd3$var$ONE_HOUR), options === null || options === void 0 ? void 0 : options.round) * $735220c2d4774dd3$var$ONE_HOUR + remainder;
      return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone), dateTime.calendar);
    }
    case "minute":
    case "second":
    case "millisecond":
      return $735220c2d4774dd3$export$dd02b3e0007dfe28(dateTime, field, amount, options);
    case "era":
    case "year":
    case "month":
    case "day": {
      let res = $735220c2d4774dd3$export$d52ced6badfb9a4c((0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime), field, amount, options);
      let ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res, dateTime.timeZone);
      return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone), dateTime.calendar);
    }
    default:
      throw new Error("Unsupported field " + field);
  }
}
__name($735220c2d4774dd3$export$9a297d111fc86b79, "$735220c2d4774dd3$export$9a297d111fc86b79");
function $735220c2d4774dd3$export$31b5430eb18be4f8(dateTime, fields, disambiguation) {
  let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime);
  let res = $735220c2d4774dd3$export$e5d5e1c1822b6e56($735220c2d4774dd3$export$adaa4cf7ef1b65be(plainDateTime, fields), fields);
  if (res.compare(plainDateTime) === 0) return dateTime;
  let ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res, dateTime.timeZone, disambiguation);
  return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone), dateTime.calendar);
}
__name($735220c2d4774dd3$export$31b5430eb18be4f8, "$735220c2d4774dd3$export$31b5430eb18be4f8");
const $fae977aafc393c5c$var$TIME_RE = /^(\d{2})(?::(\d{2}))?(?::(\d{2}))?(\.\d+)?$/;
const $fae977aafc393c5c$var$DATE_RE = /^([+-]\d{6}|\d{4})-(\d{2})-(\d{2})$/;
const $fae977aafc393c5c$var$DATE_TIME_RE = /^([+-]\d{6}|\d{4})-(\d{2})-(\d{2})(?:T(\d{2}))?(?::(\d{2}))?(?::(\d{2}))?(\.\d+)?$/;
const $fae977aafc393c5c$var$ZONED_DATE_TIME_RE = /^([+-]\d{6}|\d{4})-(\d{2})-(\d{2})(?:T(\d{2}))?(?::(\d{2}))?(?::(\d{2}))?(\.\d+)?(?:([+-]\d{2})(?::?(\d{2}))?)?\[(.*?)\]$/;
const $fae977aafc393c5c$var$ABSOLUTE_RE = /^([+-]\d{6}|\d{4})-(\d{2})-(\d{2})(?:T(\d{2}))?(?::(\d{2}))?(?::(\d{2}))?(\.\d+)?(?:(?:([+-]\d{2})(?::?(\d{2}))?)|Z)$/;
const $fae977aafc393c5c$var$DATE_TIME_DURATION_RE = /^((?<negative>-)|\+)?P((?<years>\d*)Y)?((?<months>\d*)M)?((?<weeks>\d*)W)?((?<days>\d*)D)?((?<time>T)((?<hours>\d*[.,]?\d{1,9})H)?((?<minutes>\d*[.,]?\d{1,9})M)?((?<seconds>\d*[.,]?\d{1,9})S)?)?$/;
const $fae977aafc393c5c$var$requiredDurationTimeGroups = [
  "hours",
  "minutes",
  "seconds"
];
const $fae977aafc393c5c$var$requiredDurationGroups = [
  "years",
  "months",
  "weeks",
  "days",
  ...$fae977aafc393c5c$var$requiredDurationTimeGroups
];
function $fae977aafc393c5c$export$c9698ec7f05a07e1(value) {
  let m = value.match($fae977aafc393c5c$var$TIME_RE);
  if (!m) throw new Error("Invalid ISO 8601 time string: " + value);
  return new (0, $35ea8db9cb2ccb90$export$680ea196effce5f)($fae977aafc393c5c$var$parseNumber(m[1], 0, 23), m[2] ? $fae977aafc393c5c$var$parseNumber(m[2], 0, 59) : 0, m[3] ? $fae977aafc393c5c$var$parseNumber(m[3], 0, 59) : 0, m[4] ? $fae977aafc393c5c$var$parseNumber(m[4], 0, Infinity) * 1e3 : 0);
}
__name($fae977aafc393c5c$export$c9698ec7f05a07e1, "$fae977aafc393c5c$export$c9698ec7f05a07e1");
function $fae977aafc393c5c$export$6b862160d295c8e(value) {
  let m = value.match($fae977aafc393c5c$var$DATE_RE);
  if (!m) throw new Error("Invalid ISO 8601 date string: " + value);
  let date = new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)($fae977aafc393c5c$var$parseNumber(m[1], 0, 9999), $fae977aafc393c5c$var$parseNumber(m[2], 1, 12), 1);
  date.day = $fae977aafc393c5c$var$parseNumber(m[3], 1, date.calendar.getDaysInMonth(date));
  return date;
}
__name($fae977aafc393c5c$export$6b862160d295c8e, "$fae977aafc393c5c$export$6b862160d295c8e");
function $fae977aafc393c5c$export$588937bcd60ade55(value) {
  let m = value.match($fae977aafc393c5c$var$DATE_TIME_RE);
  if (!m) throw new Error("Invalid ISO 8601 date time string: " + value);
  let year = $fae977aafc393c5c$var$parseNumber(m[1], -9999, 9999);
  let era = year < 1 ? "BC" : "AD";
  let date = new (0, $35ea8db9cb2ccb90$export$ca871e8dbb80966f)(era, year < 1 ? -year + 1 : year, $fae977aafc393c5c$var$parseNumber(m[2], 1, 12), 1, m[4] ? $fae977aafc393c5c$var$parseNumber(m[4], 0, 23) : 0, m[5] ? $fae977aafc393c5c$var$parseNumber(m[5], 0, 59) : 0, m[6] ? $fae977aafc393c5c$var$parseNumber(m[6], 0, 59) : 0, m[7] ? $fae977aafc393c5c$var$parseNumber(m[7], 0, Infinity) * 1e3 : 0);
  date.day = $fae977aafc393c5c$var$parseNumber(m[3], 0, date.calendar.getDaysInMonth(date));
  return date;
}
__name($fae977aafc393c5c$export$588937bcd60ade55, "$fae977aafc393c5c$export$588937bcd60ade55");
function $fae977aafc393c5c$export$fd7893f06e92a6a4(value, disambiguation) {
  let m = value.match($fae977aafc393c5c$var$ZONED_DATE_TIME_RE);
  if (!m) throw new Error("Invalid ISO 8601 date time string: " + value);
  let year = $fae977aafc393c5c$var$parseNumber(m[1], -9999, 9999);
  let era = year < 1 ? "BC" : "AD";
  let date = new (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)(era, year < 1 ? -year + 1 : year, $fae977aafc393c5c$var$parseNumber(m[2], 1, 12), 1, m[10], 0, m[4] ? $fae977aafc393c5c$var$parseNumber(m[4], 0, 23) : 0, m[5] ? $fae977aafc393c5c$var$parseNumber(m[5], 0, 59) : 0, m[6] ? $fae977aafc393c5c$var$parseNumber(m[6], 0, 59) : 0, m[7] ? $fae977aafc393c5c$var$parseNumber(m[7], 0, Infinity) * 1e3 : 0);
  date.day = $fae977aafc393c5c$var$parseNumber(m[3], 0, date.calendar.getDaysInMonth(date));
  let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(date);
  let ms;
  if (m[8]) {
    var _m_;
    date.offset = $fae977aafc393c5c$var$parseNumber(m[8], -23, 23) * 36e5 + $fae977aafc393c5c$var$parseNumber((_m_ = m[9]) !== null && _m_ !== void 0 ? _m_ : "0", 0, 59) * 6e4;
    ms = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(date) - date.offset;
    let absolutes = (0, $11d87f3f76e88657$export$136f38efe7caf549)(plainDateTime, date.timeZone);
    if (!absolutes.includes(ms)) throw new Error(`Offset ${$fae977aafc393c5c$var$offsetToString(date.offset)} is invalid for ${$fae977aafc393c5c$export$4223de14708adc63(date)} in ${date.timeZone}`);
  } else
    ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)((0, $11d87f3f76e88657$export$b21e0b124e224484)(plainDateTime), date.timeZone, disambiguation);
  return (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, date.timeZone);
}
__name($fae977aafc393c5c$export$fd7893f06e92a6a4, "$fae977aafc393c5c$export$fd7893f06e92a6a4");
function $fae977aafc393c5c$export$5adfdab05168c219(value, timeZone) {
  let m = value.match($fae977aafc393c5c$var$ABSOLUTE_RE);
  if (!m) throw new Error("Invalid ISO 8601 date time string: " + value);
  let year = $fae977aafc393c5c$var$parseNumber(m[1], -9999, 9999);
  let era = year < 1 ? "BC" : "AD";
  let date = new (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)(era, year < 1 ? -year + 1 : year, $fae977aafc393c5c$var$parseNumber(m[2], 1, 12), 1, timeZone, 0, m[4] ? $fae977aafc393c5c$var$parseNumber(m[4], 0, 23) : 0, m[5] ? $fae977aafc393c5c$var$parseNumber(m[5], 0, 59) : 0, m[6] ? $fae977aafc393c5c$var$parseNumber(m[6], 0, 59) : 0, m[7] ? $fae977aafc393c5c$var$parseNumber(m[7], 0, Infinity) * 1e3 : 0);
  date.day = $fae977aafc393c5c$var$parseNumber(m[3], 0, date.calendar.getDaysInMonth(date));
  var _m_;
  if (m[8]) date.offset = $fae977aafc393c5c$var$parseNumber(m[8], -23, 23) * 36e5 + $fae977aafc393c5c$var$parseNumber((_m_ = m[9]) !== null && _m_ !== void 0 ? _m_ : "0", 0, 59) * 6e4;
  return (0, $11d87f3f76e88657$export$538b00033cc11c75)(date, timeZone);
}
__name($fae977aafc393c5c$export$5adfdab05168c219, "$fae977aafc393c5c$export$5adfdab05168c219");
function $fae977aafc393c5c$export$8e384432362ed0f0(value) {
  return $fae977aafc393c5c$export$5adfdab05168c219(value, (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)());
}
__name($fae977aafc393c5c$export$8e384432362ed0f0, "$fae977aafc393c5c$export$8e384432362ed0f0");
function $fae977aafc393c5c$var$parseNumber(value, min2, max2) {
  let val = Number(value);
  if (val < min2 || val > max2) throw new RangeError(`Value out of range: ${min2} <= ${val} <= ${max2}`);
  return val;
}
__name($fae977aafc393c5c$var$parseNumber, "$fae977aafc393c5c$var$parseNumber");
function $fae977aafc393c5c$export$f59dee82248f5ad4(time) {
  return `${String(time.hour).padStart(2, "0")}:${String(time.minute).padStart(2, "0")}:${String(time.second).padStart(2, "0")}${time.millisecond ? String(time.millisecond / 1e3).slice(1) : ""}`;
}
__name($fae977aafc393c5c$export$f59dee82248f5ad4, "$fae977aafc393c5c$export$f59dee82248f5ad4");
function $fae977aafc393c5c$export$60dfd74aa96791bd(date) {
  let gregorianDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(date, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
  let year;
  if (gregorianDate.era === "BC") year = gregorianDate.year === 1 ? "0000" : "-" + String(Math.abs(1 - gregorianDate.year)).padStart(6, "00");
  else year = String(gregorianDate.year).padStart(4, "0");
  return `${year}-${String(gregorianDate.month).padStart(2, "0")}-${String(gregorianDate.day).padStart(2, "0")}`;
}
__name($fae977aafc393c5c$export$60dfd74aa96791bd, "$fae977aafc393c5c$export$60dfd74aa96791bd");
function $fae977aafc393c5c$export$4223de14708adc63(date) {
  return `${$fae977aafc393c5c$export$60dfd74aa96791bd(date)}T${$fae977aafc393c5c$export$f59dee82248f5ad4(date)}`;
}
__name($fae977aafc393c5c$export$4223de14708adc63, "$fae977aafc393c5c$export$4223de14708adc63");
function $fae977aafc393c5c$var$offsetToString(offset2) {
  let sign = Math.sign(offset2) < 0 ? "-" : "+";
  offset2 = Math.abs(offset2);
  let offsetHours = Math.floor(offset2 / 36e5);
  let offsetMinutes = offset2 % 36e5 / 6e4;
  return `${sign}${String(offsetHours).padStart(2, "0")}:${String(offsetMinutes).padStart(2, "0")}`;
}
__name($fae977aafc393c5c$var$offsetToString, "$fae977aafc393c5c$var$offsetToString");
function $fae977aafc393c5c$export$bf79f1ebf4b18792(date) {
  return `${$fae977aafc393c5c$export$4223de14708adc63(date)}${$fae977aafc393c5c$var$offsetToString(date.offset)}[${date.timeZone}]`;
}
__name($fae977aafc393c5c$export$bf79f1ebf4b18792, "$fae977aafc393c5c$export$bf79f1ebf4b18792");
function $fae977aafc393c5c$export$ecae829bb3747ea6(value) {
  var _match_groups, _match_groups1, _match_groups2, _match_groups3, _match_groups4, _match_groups5, _match_groups6, _match_groups7, _match_groups8;
  const match = value.match($fae977aafc393c5c$var$DATE_TIME_DURATION_RE);
  if (!match) throw new Error(`Invalid ISO 8601 Duration string: ${value}`);
  const parseDurationGroup = /* @__PURE__ */ __name((group, isNegative2) => {
    if (!group) return 0;
    try {
      const sign = isNegative2 ? -1 : 1;
      return sign * Number(group.replace(",", "."));
    } catch {
      throw new Error(`Invalid ISO 8601 Duration string: ${value}`);
    }
  }, "parseDurationGroup");
  const isNegative = !!((_match_groups = match.groups) === null || _match_groups === void 0 ? void 0 : _match_groups.negative);
  const hasRequiredGroups = $fae977aafc393c5c$var$requiredDurationGroups.some((group) => {
    var _match_groups9;
    return (_match_groups9 = match.groups) === null || _match_groups9 === void 0 ? void 0 : _match_groups9[group];
  });
  if (!hasRequiredGroups) throw new Error(`Invalid ISO 8601 Duration string: ${value}`);
  const durationStringIncludesTime = (_match_groups1 = match.groups) === null || _match_groups1 === void 0 ? void 0 : _match_groups1.time;
  if (durationStringIncludesTime) {
    const hasRequiredDurationTimeGroups = $fae977aafc393c5c$var$requiredDurationTimeGroups.some((group) => {
      var _match_groups9;
      return (_match_groups9 = match.groups) === null || _match_groups9 === void 0 ? void 0 : _match_groups9[group];
    });
    if (!hasRequiredDurationTimeGroups) throw new Error(`Invalid ISO 8601 Duration string: ${value}`);
  }
  const duration = {
    years: parseDurationGroup((_match_groups2 = match.groups) === null || _match_groups2 === void 0 ? void 0 : _match_groups2.years, isNegative),
    months: parseDurationGroup((_match_groups3 = match.groups) === null || _match_groups3 === void 0 ? void 0 : _match_groups3.months, isNegative),
    weeks: parseDurationGroup((_match_groups4 = match.groups) === null || _match_groups4 === void 0 ? void 0 : _match_groups4.weeks, isNegative),
    days: parseDurationGroup((_match_groups5 = match.groups) === null || _match_groups5 === void 0 ? void 0 : _match_groups5.days, isNegative),
    hours: parseDurationGroup((_match_groups6 = match.groups) === null || _match_groups6 === void 0 ? void 0 : _match_groups6.hours, isNegative),
    minutes: parseDurationGroup((_match_groups7 = match.groups) === null || _match_groups7 === void 0 ? void 0 : _match_groups7.minutes, isNegative),
    seconds: parseDurationGroup((_match_groups8 = match.groups) === null || _match_groups8 === void 0 ? void 0 : _match_groups8.seconds, isNegative)
  };
  if (duration.hours !== void 0 && duration.hours % 1 !== 0 && (duration.minutes || duration.seconds)) throw new Error(`Invalid ISO 8601 Duration string: ${value} - only the smallest unit can be fractional`);
  if (duration.minutes !== void 0 && duration.minutes % 1 !== 0 && duration.seconds) throw new Error(`Invalid ISO 8601 Duration string: ${value} - only the smallest unit can be fractional`);
  return duration;
}
__name($fae977aafc393c5c$export$ecae829bb3747ea6, "$fae977aafc393c5c$export$ecae829bb3747ea6");
function _check_private_redeclaration(obj, privateCollection) {
  if (privateCollection.has(obj)) {
    throw new TypeError("Cannot initialize the same private elements twice on an object");
  }
}
__name(_check_private_redeclaration, "_check_private_redeclaration");
function _class_private_field_init(obj, privateMap, value) {
  _check_private_redeclaration(obj, privateMap);
  privateMap.set(obj, value);
}
__name(_class_private_field_init, "_class_private_field_init");
function $35ea8db9cb2ccb90$var$shiftArgs(args) {
  let calendar = typeof args[0] === "object" ? args.shift() : new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)();
  let era;
  if (typeof args[0] === "string") era = args.shift();
  else {
    let eras = calendar.getEras();
    era = eras[eras.length - 1];
  }
  let year = args.shift();
  let month = args.shift();
  let day = args.shift();
  return [
    calendar,
    era,
    year,
    month,
    day
  ];
}
__name($35ea8db9cb2ccb90$var$shiftArgs, "$35ea8db9cb2ccb90$var$shiftArgs");
var $35ea8db9cb2ccb90$var$_type = /* @__PURE__ */ new WeakMap();
class $35ea8db9cb2ccb90$export$99faa760c7908e4f {
  static {
    __name(this, "$35ea8db9cb2ccb90$export$99faa760c7908e4f");
  }
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new $35ea8db9cb2ccb90$export$99faa760c7908e4f(this.calendar, this.era, this.year, this.month, this.day);
    else return new $35ea8db9cb2ccb90$export$99faa760c7908e4f(this.calendar, this.year, this.month, this.day);
  }
  /** Returns a new `CalendarDate` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$e16d8520af44a096)(this, duration);
  }
  /** Returns a new `CalendarDate` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$4e2d2ead65e5f7e3)(this, duration);
  }
  /** Returns a new `CalendarDate` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$adaa4cf7ef1b65be)(this, fields);
  }
  /**
  * Returns a new `CalendarDate` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$d52ced6badfb9a4c)(this, field, amount, options);
  }
  /** Converts the date to a native JavaScript Date object, with the time set to midnight in the given time zone. */
  toDate(timeZone) {
    return (0, $11d87f3f76e88657$export$e67a095c620b86fe)(this, timeZone);
  }
  /** Converts the date to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$60dfd74aa96791bd)(this);
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b) {
    return (0, $14e0f24ef4ac5c92$export$68781ddf31c0090f)(this, b);
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
}
var $35ea8db9cb2ccb90$var$_type1 = /* @__PURE__ */ new WeakMap();
class $35ea8db9cb2ccb90$export$680ea196effce5f {
  static {
    __name(this, "$35ea8db9cb2ccb90$export$680ea196effce5f");
  }
  /** Returns a copy of this time. */
  copy() {
    return new $35ea8db9cb2ccb90$export$680ea196effce5f(this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `Time` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$7ed87b6bc2506470)(this, duration);
  }
  /** Returns a new `Time` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$fe34d3a381cd7501)(this, duration);
  }
  /** Returns a new `Time` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$e5d5e1c1822b6e56)(this, fields);
  }
  /**
  * Returns a new `Time` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$dd02b3e0007dfe28)(this, field, amount, options);
  }
  /** Converts the time to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$f59dee82248f5ad4)(this);
  }
  /** Compares this time with another. A negative result indicates that this time is before the given one, and a positive time indicates that it is after. */
  compare(b) {
    return (0, $14e0f24ef4ac5c92$export$c19a80a9721b80f6)(this, b);
  }
  constructor(hour = 0, minute = 0, second = 0, millisecond = 0) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type1, {
      writable: true,
      value: void 0
    });
    this.hour = hour;
    this.minute = minute;
    this.second = second;
    this.millisecond = millisecond;
    (0, $735220c2d4774dd3$export$7555de1e070510cb)(this);
  }
}
var $35ea8db9cb2ccb90$var$_type2 = /* @__PURE__ */ new WeakMap();
class $35ea8db9cb2ccb90$export$ca871e8dbb80966f {
  static {
    __name(this, "$35ea8db9cb2ccb90$export$ca871e8dbb80966f");
  }
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new $35ea8db9cb2ccb90$export$ca871e8dbb80966f(this.calendar, this.era, this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    else return new $35ea8db9cb2ccb90$export$ca871e8dbb80966f(this.calendar, this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `CalendarDateTime` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$e16d8520af44a096)(this, duration);
  }
  /** Returns a new `CalendarDateTime` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$4e2d2ead65e5f7e3)(this, duration);
  }
  /** Returns a new `CalendarDateTime` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$adaa4cf7ef1b65be)((0, $735220c2d4774dd3$export$e5d5e1c1822b6e56)(this, fields), fields);
  }
  /**
  * Returns a new `CalendarDateTime` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    switch (field) {
      case "era":
      case "year":
      case "month":
      case "day":
        return (0, $735220c2d4774dd3$export$d52ced6badfb9a4c)(this, field, amount, options);
      default:
        return (0, $735220c2d4774dd3$export$dd02b3e0007dfe28)(this, field, amount, options);
    }
  }
  /** Converts the date to a native JavaScript Date object in the given time zone. */
  toDate(timeZone, disambiguation) {
    return (0, $11d87f3f76e88657$export$e67a095c620b86fe)(this, timeZone, disambiguation);
  }
  /** Converts the date to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$4223de14708adc63)(this);
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b) {
    let res = (0, $14e0f24ef4ac5c92$export$68781ddf31c0090f)(this, b);
    if (res === 0) return (0, $14e0f24ef4ac5c92$export$c19a80a9721b80f6)(this, (0, $11d87f3f76e88657$export$b21e0b124e224484)(b));
    return res;
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type2, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    this.hour = args.shift() || 0;
    this.minute = args.shift() || 0;
    this.second = args.shift() || 0;
    this.millisecond = args.shift() || 0;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
}
var $35ea8db9cb2ccb90$var$_type3 = /* @__PURE__ */ new WeakMap();
class $35ea8db9cb2ccb90$export$d3b7288e7994edea {
  static {
    __name(this, "$35ea8db9cb2ccb90$export$d3b7288e7994edea");
  }
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new $35ea8db9cb2ccb90$export$d3b7288e7994edea(this.calendar, this.era, this.year, this.month, this.day, this.timeZone, this.offset, this.hour, this.minute, this.second, this.millisecond);
    else return new $35ea8db9cb2ccb90$export$d3b7288e7994edea(this.calendar, this.year, this.month, this.day, this.timeZone, this.offset, this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `ZonedDateTime` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$96b1d28349274637)(this, duration);
  }
  /** Returns a new `ZonedDateTime` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$6814caac34ca03c7)(this, duration);
  }
  /** Returns a new `ZonedDateTime` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields, disambiguation) {
    return (0, $735220c2d4774dd3$export$31b5430eb18be4f8)(this, fields, disambiguation);
  }
  /**
  * Returns a new `ZonedDateTime` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$9a297d111fc86b79)(this, field, amount, options);
  }
  /** Converts the date to a native JavaScript Date object. */
  toDate() {
    return (0, $11d87f3f76e88657$export$83aac07b4c37b25)(this);
  }
  /** Converts the date to an ISO 8601 formatted string, including the UTC offset and time zone identifier. */
  toString() {
    return (0, $fae977aafc393c5c$export$bf79f1ebf4b18792)(this);
  }
  /** Converts the date to an ISO 8601 formatted string in UTC. */
  toAbsoluteString() {
    return this.toDate().toISOString();
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b) {
    return this.toDate().getTime() - (0, $11d87f3f76e88657$export$84c95a83c799e074)(b, this.timeZone).toDate().getTime();
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type3, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    let timeZone = args.shift();
    let offset2 = args.shift();
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    this.timeZone = timeZone;
    this.offset = offset2;
    this.hour = args.shift() || 0;
    this.minute = args.shift() || 0;
    this.second = args.shift() || 0;
    this.millisecond = args.shift() || 0;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
}
const $62225008020f0a13$var$ERA_START_DATES = [
  [
    1868,
    9,
    8
  ],
  [
    1912,
    7,
    30
  ],
  [
    1926,
    12,
    25
  ],
  [
    1989,
    1,
    8
  ],
  [
    2019,
    5,
    1
  ]
];
const $62225008020f0a13$var$ERA_END_DATES = [
  [
    1912,
    7,
    29
  ],
  [
    1926,
    12,
    24
  ],
  [
    1989,
    1,
    7
  ],
  [
    2019,
    4,
    30
  ]
];
const $62225008020f0a13$var$ERA_ADDENDS = [
  1867,
  1911,
  1925,
  1988,
  2018
];
const $62225008020f0a13$var$ERA_NAMES = [
  "meiji",
  "taisho",
  "showa",
  "heisei",
  "reiwa"
];
function $62225008020f0a13$var$findEraFromGregorianDate(date) {
  const idx = $62225008020f0a13$var$ERA_START_DATES.findIndex(([year, month, day]) => {
    if (date.year < year) return true;
    if (date.year === year && date.month < month) return true;
    if (date.year === year && date.month === month && date.day < day) return true;
    return false;
  });
  if (idx === -1) return $62225008020f0a13$var$ERA_START_DATES.length - 1;
  if (idx === 0) return 0;
  return idx - 1;
}
__name($62225008020f0a13$var$findEraFromGregorianDate, "$62225008020f0a13$var$findEraFromGregorianDate");
function $62225008020f0a13$var$toGregorian(date) {
  let eraAddend = $62225008020f0a13$var$ERA_ADDENDS[$62225008020f0a13$var$ERA_NAMES.indexOf(date.era)];
  if (!eraAddend) throw new Error("Unknown era: " + date.era);
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(date.year + eraAddend, date.month, date.day);
}
__name($62225008020f0a13$var$toGregorian, "$62225008020f0a13$var$toGregorian");
class $62225008020f0a13$export$b746ab2b60cdffbf extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  static {
    __name(this, "$62225008020f0a13$export$b746ab2b60cdffbf");
  }
  fromJulianDay(jd) {
    let date = super.fromJulianDay(jd);
    let era = $62225008020f0a13$var$findEraFromGregorianDate(date);
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, $62225008020f0a13$var$ERA_NAMES[era], date.year - $62225008020f0a13$var$ERA_ADDENDS[era], date.month, date.day);
  }
  toJulianDay(date) {
    return super.toJulianDay($62225008020f0a13$var$toGregorian(date));
  }
  balanceDate(date) {
    let gregorianDate = $62225008020f0a13$var$toGregorian(date);
    let era = $62225008020f0a13$var$findEraFromGregorianDate(gregorianDate);
    if ($62225008020f0a13$var$ERA_NAMES[era] !== date.era) {
      date.era = $62225008020f0a13$var$ERA_NAMES[era];
      date.year = gregorianDate.year - $62225008020f0a13$var$ERA_ADDENDS[era];
    }
    this.constrainDate(date);
  }
  constrainDate(date) {
    let idx = $62225008020f0a13$var$ERA_NAMES.indexOf(date.era);
    let end = $62225008020f0a13$var$ERA_END_DATES[idx];
    if (end != null) {
      let [endYear, endMonth, endDay] = end;
      let maxYear = endYear - $62225008020f0a13$var$ERA_ADDENDS[idx];
      date.year = Math.max(1, Math.min(maxYear, date.year));
      if (date.year === maxYear) {
        date.month = Math.min(endMonth, date.month);
        if (date.month === endMonth) date.day = Math.min(endDay, date.day);
      }
    }
    if (date.year === 1 && idx >= 0) {
      let [, startMonth, startDay] = $62225008020f0a13$var$ERA_START_DATES[idx];
      date.month = Math.max(startMonth, date.month);
      if (date.month === startMonth) date.day = Math.max(startDay, date.day);
    }
  }
  getEras() {
    return $62225008020f0a13$var$ERA_NAMES;
  }
  getYearsInEra(date) {
    let era = $62225008020f0a13$var$ERA_NAMES.indexOf(date.era);
    let cur = $62225008020f0a13$var$ERA_START_DATES[era];
    let next = $62225008020f0a13$var$ERA_START_DATES[era + 1];
    if (next == null)
      return 9999 - cur[0] + 1;
    let years = next[0] - cur[0];
    if (date.month < next[1] || date.month === next[1] && date.day < next[2]) years++;
    return years;
  }
  getDaysInMonth(date) {
    return super.getDaysInMonth($62225008020f0a13$var$toGregorian(date));
  }
  getMinimumMonthInYear(date) {
    let start = $62225008020f0a13$var$getMinimums(date);
    return start ? start[1] : 1;
  }
  getMinimumDayInMonth(date) {
    let start = $62225008020f0a13$var$getMinimums(date);
    return start && date.month === start[1] ? start[2] : 1;
  }
  constructor(...args) {
    super(...args), this.identifier = "japanese";
  }
}
function $62225008020f0a13$var$getMinimums(date) {
  if (date.year === 1) {
    let idx = $62225008020f0a13$var$ERA_NAMES.indexOf(date.era);
    return $62225008020f0a13$var$ERA_START_DATES[idx];
  }
}
__name($62225008020f0a13$var$getMinimums, "$62225008020f0a13$var$getMinimums");
const $8d73d47422ca7302$var$BUDDHIST_ERA_START = -543;
class $8d73d47422ca7302$export$42d20a78301dee44 extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  static {
    __name(this, "$8d73d47422ca7302$export$42d20a78301dee44");
  }
  fromJulianDay(jd) {
    let gregorianDate = super.fromJulianDay(jd);
    let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(gregorianDate.era, gregorianDate.year);
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, year - $8d73d47422ca7302$var$BUDDHIST_ERA_START, gregorianDate.month, gregorianDate.day);
  }
  toJulianDay(date) {
    return super.toJulianDay($8d73d47422ca7302$var$toGregorian(date));
  }
  getEras() {
    return [
      "BE"
    ];
  }
  getDaysInMonth(date) {
    return super.getDaysInMonth($8d73d47422ca7302$var$toGregorian(date));
  }
  balanceDate() {
  }
  constructor(...args) {
    super(...args), this.identifier = "buddhist";
  }
}
function $8d73d47422ca7302$var$toGregorian(date) {
  let [era, year] = (0, $3b62074eb05584b2$export$4475b7e617eb123c)(date.year + $8d73d47422ca7302$var$BUDDHIST_ERA_START);
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, date.month, date.day);
}
__name($8d73d47422ca7302$var$toGregorian, "$8d73d47422ca7302$var$toGregorian");
const $5f31bd6f0c8940b2$var$TAIWAN_ERA_START = 1911;
function $5f31bd6f0c8940b2$var$gregorianYear(date) {
  return date.era === "minguo" ? date.year + $5f31bd6f0c8940b2$var$TAIWAN_ERA_START : 1 - date.year + $5f31bd6f0c8940b2$var$TAIWAN_ERA_START;
}
__name($5f31bd6f0c8940b2$var$gregorianYear, "$5f31bd6f0c8940b2$var$gregorianYear");
function $5f31bd6f0c8940b2$var$gregorianToTaiwan(year) {
  let y = year - $5f31bd6f0c8940b2$var$TAIWAN_ERA_START;
  if (y > 0) return [
    "minguo",
    y
  ];
  else return [
    "before_minguo",
    1 - y
  ];
}
__name($5f31bd6f0c8940b2$var$gregorianToTaiwan, "$5f31bd6f0c8940b2$var$gregorianToTaiwan");
class $5f31bd6f0c8940b2$export$65e01080afcb0799 extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  static {
    __name(this, "$5f31bd6f0c8940b2$export$65e01080afcb0799");
  }
  fromJulianDay(jd) {
    let date = super.fromJulianDay(jd);
    let extendedYear = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(date.era, date.year);
    let [era, year] = $5f31bd6f0c8940b2$var$gregorianToTaiwan(extendedYear);
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, era, year, date.month, date.day);
  }
  toJulianDay(date) {
    return super.toJulianDay($5f31bd6f0c8940b2$var$toGregorian(date));
  }
  getEras() {
    return [
      "before_minguo",
      "minguo"
    ];
  }
  balanceDate(date) {
    let [era, year] = $5f31bd6f0c8940b2$var$gregorianToTaiwan($5f31bd6f0c8940b2$var$gregorianYear(date));
    date.era = era;
    date.year = year;
  }
  isInverseEra(date) {
    return date.era === "before_minguo";
  }
  getDaysInMonth(date) {
    return super.getDaysInMonth($5f31bd6f0c8940b2$var$toGregorian(date));
  }
  getYearsInEra(date) {
    return date.era === "before_minguo" ? 9999 : 9999 - $5f31bd6f0c8940b2$var$TAIWAN_ERA_START;
  }
  constructor(...args) {
    super(...args), this.identifier = "roc";
  }
}
function $5f31bd6f0c8940b2$var$toGregorian(date) {
  let [era, year] = (0, $3b62074eb05584b2$export$4475b7e617eb123c)($5f31bd6f0c8940b2$var$gregorianYear(date));
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, date.month, date.day);
}
__name($5f31bd6f0c8940b2$var$toGregorian, "$5f31bd6f0c8940b2$var$toGregorian");
const $f3ed2e4472ae7e25$var$PERSIAN_EPOCH = 1948320;
const $f3ed2e4472ae7e25$var$MONTH_START = [
  0,
  31,
  62,
  93,
  124,
  155,
  186,
  216,
  246,
  276,
  306,
  336
  // Esfand
];
class $f3ed2e4472ae7e25$export$37fccdbfd14c5939 {
  static {
    __name(this, "$f3ed2e4472ae7e25$export$37fccdbfd14c5939");
  }
  fromJulianDay(jd) {
    let daysSinceEpoch = jd - $f3ed2e4472ae7e25$var$PERSIAN_EPOCH;
    let year = 1 + Math.floor((33 * daysSinceEpoch + 3) / 12053);
    let farvardin1 = 365 * (year - 1) + Math.floor((8 * year + 21) / 33);
    let dayOfYear = daysSinceEpoch - farvardin1;
    let month = dayOfYear < 216 ? Math.floor(dayOfYear / 31) : Math.floor((dayOfYear - 6) / 30);
    let day = dayOfYear - $f3ed2e4472ae7e25$var$MONTH_START[month] + 1;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, year, month + 1, day);
  }
  toJulianDay(date) {
    let jd = $f3ed2e4472ae7e25$var$PERSIAN_EPOCH - 1 + 365 * (date.year - 1) + Math.floor((8 * date.year + 21) / 33);
    jd += $f3ed2e4472ae7e25$var$MONTH_START[date.month - 1];
    jd += date.day;
    return jd;
  }
  getMonthsInYear() {
    return 12;
  }
  getDaysInMonth(date) {
    if (date.month <= 6) return 31;
    if (date.month <= 11) return 30;
    let isLeapYear = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(25 * date.year + 11, 33) < 8;
    return isLeapYear ? 30 : 29;
  }
  getEras() {
    return [
      "AP"
    ];
  }
  getYearsInEra() {
    return 9377;
  }
  constructor() {
    this.identifier = "persian";
  }
}
const $82c358003bdda0a8$var$INDIAN_ERA_START = 78;
const $82c358003bdda0a8$var$INDIAN_YEAR_START = 80;
class $82c358003bdda0a8$export$39f31c639fa15726 extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  static {
    __name(this, "$82c358003bdda0a8$export$39f31c639fa15726");
  }
  fromJulianDay(jd) {
    let date = super.fromJulianDay(jd);
    let indianYear = date.year - $82c358003bdda0a8$var$INDIAN_ERA_START;
    let yDay = jd - (0, $3b62074eb05584b2$export$f297eb839006d339)(date.era, date.year, 1, 1);
    let leapMonth;
    if (yDay < $82c358003bdda0a8$var$INDIAN_YEAR_START) {
      indianYear--;
      leapMonth = (0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(date.year - 1) ? 31 : 30;
      yDay += leapMonth + 155 + 90 + 10;
    } else {
      leapMonth = (0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(date.year) ? 31 : 30;
      yDay -= $82c358003bdda0a8$var$INDIAN_YEAR_START;
    }
    let indianMonth;
    let indianDay;
    if (yDay < leapMonth) {
      indianMonth = 1;
      indianDay = yDay + 1;
    } else {
      let mDay = yDay - leapMonth;
      if (mDay < 155) {
        indianMonth = Math.floor(mDay / 31) + 2;
        indianDay = mDay % 31 + 1;
      } else {
        mDay -= 155;
        indianMonth = Math.floor(mDay / 30) + 7;
        indianDay = mDay % 30 + 1;
      }
    }
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, indianYear, indianMonth, indianDay);
  }
  toJulianDay(date) {
    let extendedYear = date.year + $82c358003bdda0a8$var$INDIAN_ERA_START;
    let [era, year] = (0, $3b62074eb05584b2$export$4475b7e617eb123c)(extendedYear);
    let leapMonth;
    let jd;
    if ((0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(year)) {
      leapMonth = 31;
      jd = (0, $3b62074eb05584b2$export$f297eb839006d339)(era, year, 3, 21);
    } else {
      leapMonth = 30;
      jd = (0, $3b62074eb05584b2$export$f297eb839006d339)(era, year, 3, 22);
    }
    if (date.month === 1) return jd + date.day - 1;
    jd += leapMonth + Math.min(date.month - 2, 5) * 31;
    if (date.month >= 8) jd += (date.month - 7) * 30;
    jd += date.day - 1;
    return jd;
  }
  getDaysInMonth(date) {
    if (date.month === 1 && (0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(date.year + $82c358003bdda0a8$var$INDIAN_ERA_START)) return 31;
    if (date.month >= 2 && date.month <= 6) return 31;
    return 30;
  }
  getYearsInEra() {
    return 9919;
  }
  getEras() {
    return [
      "saka"
    ];
  }
  balanceDate() {
  }
  constructor(...args) {
    super(...args), this.identifier = "indian";
  }
}
const $f2f3e0e3a817edbd$var$CIVIL_EPOC = 1948440;
const $f2f3e0e3a817edbd$var$ASTRONOMICAL_EPOC = 1948439;
const $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START = 1300;
const $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END = 1600;
const $f2f3e0e3a817edbd$var$UMALQURA_START_DAYS = 460322;
function $f2f3e0e3a817edbd$var$islamicToJulianDay(epoch, year, month, day) {
  return day + Math.ceil(29.5 * (month - 1)) + (year - 1) * 354 + Math.floor((3 + 11 * year) / 30) + epoch - 1;
}
__name($f2f3e0e3a817edbd$var$islamicToJulianDay, "$f2f3e0e3a817edbd$var$islamicToJulianDay");
function $f2f3e0e3a817edbd$var$julianDayToIslamic(calendar, epoch, jd) {
  let year = Math.floor((30 * (jd - epoch) + 10646) / 10631);
  let month = Math.min(12, Math.ceil((jd - (29 + $f2f3e0e3a817edbd$var$islamicToJulianDay(epoch, year, 1, 1))) / 29.5) + 1);
  let day = jd - $f2f3e0e3a817edbd$var$islamicToJulianDay(epoch, year, month, 1) + 1;
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(calendar, year, month, day);
}
__name($f2f3e0e3a817edbd$var$julianDayToIslamic, "$f2f3e0e3a817edbd$var$julianDayToIslamic");
function $f2f3e0e3a817edbd$var$isLeapYear(year) {
  return (14 + 11 * year) % 30 < 11;
}
__name($f2f3e0e3a817edbd$var$isLeapYear, "$f2f3e0e3a817edbd$var$isLeapYear");
class $f2f3e0e3a817edbd$export$2066795aadd37bfc {
  static {
    __name(this, "$f2f3e0e3a817edbd$export$2066795aadd37bfc");
  }
  fromJulianDay(jd) {
    return $f2f3e0e3a817edbd$var$julianDayToIslamic(this, $f2f3e0e3a817edbd$var$CIVIL_EPOC, jd);
  }
  toJulianDay(date) {
    return $f2f3e0e3a817edbd$var$islamicToJulianDay($f2f3e0e3a817edbd$var$CIVIL_EPOC, date.year, date.month, date.day);
  }
  getDaysInMonth(date) {
    let length = 29 + date.month % 2;
    if (date.month === 12 && $f2f3e0e3a817edbd$var$isLeapYear(date.year)) length++;
    return length;
  }
  getMonthsInYear() {
    return 12;
  }
  getDaysInYear(date) {
    return $f2f3e0e3a817edbd$var$isLeapYear(date.year) ? 355 : 354;
  }
  getYearsInEra() {
    return 9665;
  }
  getEras() {
    return [
      "AH"
    ];
  }
  constructor() {
    this.identifier = "islamic-civil";
  }
}
class $f2f3e0e3a817edbd$export$37f0887f2f9d22f7 extends $f2f3e0e3a817edbd$export$2066795aadd37bfc {
  static {
    __name(this, "$f2f3e0e3a817edbd$export$37f0887f2f9d22f7");
  }
  fromJulianDay(jd) {
    return $f2f3e0e3a817edbd$var$julianDayToIslamic(this, $f2f3e0e3a817edbd$var$ASTRONOMICAL_EPOC, jd);
  }
  toJulianDay(date) {
    return $f2f3e0e3a817edbd$var$islamicToJulianDay($f2f3e0e3a817edbd$var$ASTRONOMICAL_EPOC, date.year, date.month, date.day);
  }
  constructor(...args) {
    super(...args), this.identifier = "islamic-tbla";
  }
}
const $f2f3e0e3a817edbd$var$UMALQURA_DATA = "qgpUDckO1AbqBmwDrQpVBakGkgepC9QF2gpcBS0NlQZKB1QLagutBa4ETwoXBYsGpQbVCtYCWwmdBE0KJg2VDawFtgm6AlsKKwWVCsoG6Qr0AnYJtgJWCcoKpAvSC9kF3AJtCU0FpQpSC6ULtAW2CVcFlwJLBaMGUgdlC2oFqworBZUMSg2lDcoF1gpXCasESwmlClILagt1BXYCtwhbBFUFqQW0BdoJ3QRuAjYJqgpUDbIN1QXaAlsJqwRVCkkLZAtxC7QFtQpVCiUNkg7JDtQG6QprCasEkwpJDaQNsg25CroEWworBZUKKgtVC1wFvQQ9Ah0JlQpKC1oLbQW2AjsJmwRVBqkGVAdqC2wFrQpVBSkLkgupC9QF2gpaBasKlQVJB2QHqgu1BbYCVgpNDiULUgtqC60FrgIvCZcESwalBqwG1gpdBZ0ETQoWDZUNqgW1BdoCWwmtBJUFygbkBuoK9QS2AlYJqgpUC9IL2QXqAm0JrQSVCkoLpQuyBbUJ1gSXCkcFkwZJB1ULagVrCisFiwpGDaMNygXWCtsEawJLCaUKUgtpC3UFdgG3CFsCKwVlBbQF2gntBG0BtgimClINqQ3UBdoKWwmrBFMGKQdiB6kLsgW1ClUFJQuSDckO0gbpCmsFqwRVCikNVA2qDbUJugQ7CpsETQqqCtUK2gJdCV4ELgqaDFUNsga5BroEXQotBZUKUguoC7QLuQXaAloJSgukDdEO6AZqC20FNQWVBkoNqA3UDdoGWwWdAisGFQtKC5ULqgWuCi4JjwwnBZUGqgbWCl0FnQI=";
let $f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH;
let $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE;
function $f2f3e0e3a817edbd$var$umalquraYearStart(year) {
  return $f2f3e0e3a817edbd$var$UMALQURA_START_DAYS + $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START];
}
__name($f2f3e0e3a817edbd$var$umalquraYearStart, "$f2f3e0e3a817edbd$var$umalquraYearStart");
function $f2f3e0e3a817edbd$var$umalquraMonthLength(year, month) {
  let idx = year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START;
  let mask = 1 << 11 - (month - 1);
  if (($f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH[idx] & mask) === 0) return 29;
  else return 30;
}
__name($f2f3e0e3a817edbd$var$umalquraMonthLength, "$f2f3e0e3a817edbd$var$umalquraMonthLength");
function $f2f3e0e3a817edbd$var$umalquraMonthStart(year, month) {
  let day = $f2f3e0e3a817edbd$var$umalquraYearStart(year);
  for (let i = 1; i < month; i++) day += $f2f3e0e3a817edbd$var$umalquraMonthLength(year, i);
  return day;
}
__name($f2f3e0e3a817edbd$var$umalquraMonthStart, "$f2f3e0e3a817edbd$var$umalquraMonthStart");
function $f2f3e0e3a817edbd$var$umalquraYearLength(year) {
  return $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year + 1 - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START] - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START];
}
__name($f2f3e0e3a817edbd$var$umalquraYearLength, "$f2f3e0e3a817edbd$var$umalquraYearLength");
class $f2f3e0e3a817edbd$export$5baab4758c231076 extends $f2f3e0e3a817edbd$export$2066795aadd37bfc {
  static {
    __name(this, "$f2f3e0e3a817edbd$export$5baab4758c231076");
  }
  fromJulianDay(jd) {
    let days = jd - $f2f3e0e3a817edbd$var$CIVIL_EPOC;
    let startDays = $f2f3e0e3a817edbd$var$umalquraYearStart($f2f3e0e3a817edbd$var$UMALQURA_YEAR_START);
    let endDays = $f2f3e0e3a817edbd$var$umalquraYearStart($f2f3e0e3a817edbd$var$UMALQURA_YEAR_END);
    if (days < startDays || days > endDays) return super.fromJulianDay(jd);
    else {
      let y = $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START - 1;
      let m = 1;
      let d = 1;
      while (d > 0) {
        y++;
        d = days - $f2f3e0e3a817edbd$var$umalquraYearStart(y) + 1;
        let yearLength = $f2f3e0e3a817edbd$var$umalquraYearLength(y);
        if (d === yearLength) {
          m = 12;
          break;
        } else if (d < yearLength) {
          let monthLength = $f2f3e0e3a817edbd$var$umalquraMonthLength(y, m);
          m = 1;
          while (d > monthLength) {
            d -= monthLength;
            m++;
            monthLength = $f2f3e0e3a817edbd$var$umalquraMonthLength(y, m);
          }
          break;
        }
      }
      return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, y, m, days - $f2f3e0e3a817edbd$var$umalquraMonthStart(y, m) + 1);
    }
  }
  toJulianDay(date) {
    if (date.year < $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START || date.year > $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END) return super.toJulianDay(date);
    return $f2f3e0e3a817edbd$var$CIVIL_EPOC + $f2f3e0e3a817edbd$var$umalquraMonthStart(date.year, date.month) + (date.day - 1);
  }
  getDaysInMonth(date) {
    if (date.year < $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START || date.year > $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END) return super.getDaysInMonth(date);
    return $f2f3e0e3a817edbd$var$umalquraMonthLength(date.year, date.month);
  }
  getDaysInYear(date) {
    if (date.year < $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START || date.year > $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END) return super.getDaysInYear(date);
    return $f2f3e0e3a817edbd$var$umalquraYearLength(date.year);
  }
  constructor() {
    super(), this.identifier = "islamic-umalqura";
    if (!$f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH) $f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH = new Uint16Array(Uint8Array.from(atob($f2f3e0e3a817edbd$var$UMALQURA_DATA), (c2) => c2.charCodeAt(0)).buffer);
    if (!$f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE) {
      $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE = new Uint32Array($f2f3e0e3a817edbd$var$UMALQURA_YEAR_END - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START + 1);
      let yearStart = 0;
      for (let year = $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START; year <= $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END; year++) {
        $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START] = yearStart;
        for (let i = 1; i <= 12; i++) yearStart += $f2f3e0e3a817edbd$var$umalquraMonthLength(year, i);
      }
    }
  }
}
const $7c5f6fbf42389787$var$HEBREW_EPOCH = 347997;
const $7c5f6fbf42389787$var$HOUR_PARTS = 1080;
const $7c5f6fbf42389787$var$DAY_PARTS = 24 * $7c5f6fbf42389787$var$HOUR_PARTS;
const $7c5f6fbf42389787$var$MONTH_DAYS = 29;
const $7c5f6fbf42389787$var$MONTH_FRACT = 12 * $7c5f6fbf42389787$var$HOUR_PARTS + 793;
const $7c5f6fbf42389787$var$MONTH_PARTS = $7c5f6fbf42389787$var$MONTH_DAYS * $7c5f6fbf42389787$var$DAY_PARTS + $7c5f6fbf42389787$var$MONTH_FRACT;
function $7c5f6fbf42389787$var$isLeapYear(year) {
  return (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(year * 7 + 1, 19) < 7;
}
__name($7c5f6fbf42389787$var$isLeapYear, "$7c5f6fbf42389787$var$isLeapYear");
function $7c5f6fbf42389787$var$hebrewDelay1(year) {
  let months = Math.floor((235 * year - 234) / 19);
  let parts = 12084 + 13753 * months;
  let day = months * 29 + Math.floor(parts / 25920);
  if ((0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(3 * (day + 1), 7) < 3) day += 1;
  return day;
}
__name($7c5f6fbf42389787$var$hebrewDelay1, "$7c5f6fbf42389787$var$hebrewDelay1");
function $7c5f6fbf42389787$var$hebrewDelay2(year) {
  let last = $7c5f6fbf42389787$var$hebrewDelay1(year - 1);
  let present = $7c5f6fbf42389787$var$hebrewDelay1(year);
  let next = $7c5f6fbf42389787$var$hebrewDelay1(year + 1);
  if (next - present === 356) return 2;
  if (present - last === 382) return 1;
  return 0;
}
__name($7c5f6fbf42389787$var$hebrewDelay2, "$7c5f6fbf42389787$var$hebrewDelay2");
function $7c5f6fbf42389787$var$startOfYear(year) {
  return $7c5f6fbf42389787$var$hebrewDelay1(year) + $7c5f6fbf42389787$var$hebrewDelay2(year);
}
__name($7c5f6fbf42389787$var$startOfYear, "$7c5f6fbf42389787$var$startOfYear");
function $7c5f6fbf42389787$var$getDaysInYear(year) {
  return $7c5f6fbf42389787$var$startOfYear(year + 1) - $7c5f6fbf42389787$var$startOfYear(year);
}
__name($7c5f6fbf42389787$var$getDaysInYear, "$7c5f6fbf42389787$var$getDaysInYear");
function $7c5f6fbf42389787$var$getYearType(year) {
  let yearLength = $7c5f6fbf42389787$var$getDaysInYear(year);
  if (yearLength > 380) yearLength -= 30;
  switch (yearLength) {
    case 353:
      return 0;
    case 354:
      return 1;
    case 355:
      return 2;
  }
}
__name($7c5f6fbf42389787$var$getYearType, "$7c5f6fbf42389787$var$getYearType");
function $7c5f6fbf42389787$var$getDaysInMonth(year, month) {
  if (month >= 6 && !$7c5f6fbf42389787$var$isLeapYear(year)) month++;
  if (month === 4 || month === 7 || month === 9 || month === 11 || month === 13) return 29;
  let yearType = $7c5f6fbf42389787$var$getYearType(year);
  if (month === 2) return yearType === 2 ? 30 : 29;
  if (month === 3) return yearType === 0 ? 29 : 30;
  if (month === 6) return $7c5f6fbf42389787$var$isLeapYear(year) ? 30 : 0;
  return 30;
}
__name($7c5f6fbf42389787$var$getDaysInMonth, "$7c5f6fbf42389787$var$getDaysInMonth");
class $7c5f6fbf42389787$export$ca405048b8fb5af {
  static {
    __name(this, "$7c5f6fbf42389787$export$ca405048b8fb5af");
  }
  fromJulianDay(jd) {
    let d = jd - $7c5f6fbf42389787$var$HEBREW_EPOCH;
    let m = d * $7c5f6fbf42389787$var$DAY_PARTS / $7c5f6fbf42389787$var$MONTH_PARTS;
    let year = Math.floor((19 * m + 234) / 235) + 1;
    let ys = $7c5f6fbf42389787$var$startOfYear(year);
    let dayOfYear = Math.floor(d - ys);
    while (dayOfYear < 1) {
      year--;
      ys = $7c5f6fbf42389787$var$startOfYear(year);
      dayOfYear = Math.floor(d - ys);
    }
    let month = 1;
    let monthStart = 0;
    while (monthStart < dayOfYear) {
      monthStart += $7c5f6fbf42389787$var$getDaysInMonth(year, month);
      month++;
    }
    month--;
    monthStart -= $7c5f6fbf42389787$var$getDaysInMonth(year, month);
    let day = dayOfYear - monthStart;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, year, month, day);
  }
  toJulianDay(date) {
    let jd = $7c5f6fbf42389787$var$startOfYear(date.year);
    for (let month = 1; month < date.month; month++) jd += $7c5f6fbf42389787$var$getDaysInMonth(date.year, month);
    return jd + date.day + $7c5f6fbf42389787$var$HEBREW_EPOCH;
  }
  getDaysInMonth(date) {
    return $7c5f6fbf42389787$var$getDaysInMonth(date.year, date.month);
  }
  getMonthsInYear(date) {
    return $7c5f6fbf42389787$var$isLeapYear(date.year) ? 13 : 12;
  }
  getDaysInYear(date) {
    return $7c5f6fbf42389787$var$getDaysInYear(date.year);
  }
  getYearsInEra() {
    return 9999;
  }
  getEras() {
    return [
      "AM"
    ];
  }
  balanceYearMonth(date, previousDate) {
    if (previousDate.year !== date.year) {
      if ($7c5f6fbf42389787$var$isLeapYear(previousDate.year) && !$7c5f6fbf42389787$var$isLeapYear(date.year) && previousDate.month > 6) date.month--;
      else if (!$7c5f6fbf42389787$var$isLeapYear(previousDate.year) && $7c5f6fbf42389787$var$isLeapYear(date.year) && previousDate.month > 6) date.month++;
    }
  }
  constructor() {
    this.identifier = "hebrew";
  }
}
const $b956b2d7a6cf451f$var$ETHIOPIC_EPOCH = 1723856;
const $b956b2d7a6cf451f$var$COPTIC_EPOCH = 1824665;
const $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA = 5500;
function $b956b2d7a6cf451f$var$ceToJulianDay(epoch, year, month, day) {
  return epoch + 365 * year + Math.floor(year / 4) + 30 * (month - 1) + day - 1;
}
__name($b956b2d7a6cf451f$var$ceToJulianDay, "$b956b2d7a6cf451f$var$ceToJulianDay");
function $b956b2d7a6cf451f$var$julianDayToCE(epoch, jd) {
  let year = Math.floor(4 * (jd - epoch) / 1461);
  let month = 1 + Math.floor((jd - $b956b2d7a6cf451f$var$ceToJulianDay(epoch, year, 1, 1)) / 30);
  let day = jd + 1 - $b956b2d7a6cf451f$var$ceToJulianDay(epoch, year, month, 1);
  return [
    year,
    month,
    day
  ];
}
__name($b956b2d7a6cf451f$var$julianDayToCE, "$b956b2d7a6cf451f$var$julianDayToCE");
function $b956b2d7a6cf451f$var$getLeapDay(year) {
  return Math.floor(year % 4 / 3);
}
__name($b956b2d7a6cf451f$var$getLeapDay, "$b956b2d7a6cf451f$var$getLeapDay");
function $b956b2d7a6cf451f$var$getDaysInMonth(year, month) {
  if (month % 13 !== 0)
    return 30;
  else
    return $b956b2d7a6cf451f$var$getLeapDay(year) + 5;
}
__name($b956b2d7a6cf451f$var$getDaysInMonth, "$b956b2d7a6cf451f$var$getDaysInMonth");
class $b956b2d7a6cf451f$export$26ba6eab5e20cd7d {
  static {
    __name(this, "$b956b2d7a6cf451f$export$26ba6eab5e20cd7d");
  }
  fromJulianDay(jd) {
    let [year, month, day] = $b956b2d7a6cf451f$var$julianDayToCE($b956b2d7a6cf451f$var$ETHIOPIC_EPOCH, jd);
    let era = "AM";
    if (year <= 0) {
      era = "AA";
      year += $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA;
    }
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, era, year, month, day);
  }
  toJulianDay(date) {
    let year = date.year;
    if (date.era === "AA") year -= $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA;
    return $b956b2d7a6cf451f$var$ceToJulianDay($b956b2d7a6cf451f$var$ETHIOPIC_EPOCH, year, date.month, date.day);
  }
  getDaysInMonth(date) {
    return $b956b2d7a6cf451f$var$getDaysInMonth(date.year, date.month);
  }
  getMonthsInYear() {
    return 13;
  }
  getDaysInYear(date) {
    return 365 + $b956b2d7a6cf451f$var$getLeapDay(date.year);
  }
  getYearsInEra(date) {
    return date.era === "AA" ? 9999 : 9991;
  }
  getEras() {
    return [
      "AA",
      "AM"
    ];
  }
  constructor() {
    this.identifier = "ethiopic";
  }
}
class $b956b2d7a6cf451f$export$d72e0c37005a4914 extends $b956b2d7a6cf451f$export$26ba6eab5e20cd7d {
  static {
    __name(this, "$b956b2d7a6cf451f$export$d72e0c37005a4914");
  }
  fromJulianDay(jd) {
    let [year, month, day] = $b956b2d7a6cf451f$var$julianDayToCE($b956b2d7a6cf451f$var$ETHIOPIC_EPOCH, jd);
    year += $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, "AA", year, month, day);
  }
  getEras() {
    return [
      "AA"
    ];
  }
  getYearsInEra() {
    return 9999;
  }
  constructor(...args) {
    super(...args), this.identifier = "ethioaa";
  }
}
class $b956b2d7a6cf451f$export$fe6243cbe1a4b7c1 extends $b956b2d7a6cf451f$export$26ba6eab5e20cd7d {
  static {
    __name(this, "$b956b2d7a6cf451f$export$fe6243cbe1a4b7c1");
  }
  fromJulianDay(jd) {
    let [year, month, day] = $b956b2d7a6cf451f$var$julianDayToCE($b956b2d7a6cf451f$var$COPTIC_EPOCH, jd);
    let era = "CE";
    if (year <= 0) {
      era = "BCE";
      year = 1 - year;
    }
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, era, year, month, day);
  }
  toJulianDay(date) {
    let year = date.year;
    if (date.era === "BCE") year = 1 - year;
    return $b956b2d7a6cf451f$var$ceToJulianDay($b956b2d7a6cf451f$var$COPTIC_EPOCH, year, date.month, date.day);
  }
  getDaysInMonth(date) {
    let year = date.year;
    if (date.era === "BCE") year = 1 - year;
    return $b956b2d7a6cf451f$var$getDaysInMonth(year, date.month);
  }
  isInverseEra(date) {
    return date.era === "BCE";
  }
  balanceDate(date) {
    if (date.year <= 0) {
      date.era = date.era === "BCE" ? "CE" : "BCE";
      date.year = 1 - date.year;
    }
  }
  getEras() {
    return [
      "BCE",
      "CE"
    ];
  }
  getYearsInEra(date) {
    return date.era === "BCE" ? 9999 : 9715;
  }
  constructor(...args) {
    super(...args), this.identifier = "coptic";
  }
}
function $64244302c3013299$export$dd0bbc9b26defe37(name) {
  switch (name) {
    case "buddhist":
      return new (0, $8d73d47422ca7302$export$42d20a78301dee44)();
    case "ethiopic":
      return new (0, $b956b2d7a6cf451f$export$26ba6eab5e20cd7d)();
    case "ethioaa":
      return new (0, $b956b2d7a6cf451f$export$d72e0c37005a4914)();
    case "coptic":
      return new (0, $b956b2d7a6cf451f$export$fe6243cbe1a4b7c1)();
    case "hebrew":
      return new (0, $7c5f6fbf42389787$export$ca405048b8fb5af)();
    case "indian":
      return new (0, $82c358003bdda0a8$export$39f31c639fa15726)();
    case "islamic-civil":
      return new (0, $f2f3e0e3a817edbd$export$2066795aadd37bfc)();
    case "islamic-tbla":
      return new (0, $f2f3e0e3a817edbd$export$37f0887f2f9d22f7)();
    case "islamic-umalqura":
      return new (0, $f2f3e0e3a817edbd$export$5baab4758c231076)();
    case "japanese":
      return new (0, $62225008020f0a13$export$b746ab2b60cdffbf)();
    case "persian":
      return new (0, $f3ed2e4472ae7e25$export$37fccdbfd14c5939)();
    case "roc":
      return new (0, $5f31bd6f0c8940b2$export$65e01080afcb0799)();
    case "gregory":
    default:
      return new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)();
  }
}
__name($64244302c3013299$export$dd0bbc9b26defe37, "$64244302c3013299$export$dd0bbc9b26defe37");
let $fb18d541ea1ad717$var$formatterCache = /* @__PURE__ */ new Map();
class $fb18d541ea1ad717$export$ad991b66133851cf {
  static {
    __name(this, "$fb18d541ea1ad717$export$ad991b66133851cf");
  }
  /** Formats a date as a string according to the locale and format options passed to the constructor. */
  format(value) {
    return this.formatter.format(value);
  }
  /** Formats a date to an array of parts such as separators, numbers, punctuation, and more. */
  formatToParts(value) {
    return this.formatter.formatToParts(value);
  }
  /** Formats a date range as a string. */
  formatRange(start, end) {
    if (typeof this.formatter.formatRange === "function")
      return this.formatter.formatRange(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    return `${this.formatter.format(start)} – ${this.formatter.format(end)}`;
  }
  /** Formats a date range as an array of parts. */
  formatRangeToParts(start, end) {
    if (typeof this.formatter.formatRangeToParts === "function")
      return this.formatter.formatRangeToParts(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    let startParts = this.formatter.formatToParts(start);
    let endParts = this.formatter.formatToParts(end);
    return [
      ...startParts.map((p) => ({
        ...p,
        source: "startRange"
      })),
      {
        type: "literal",
        value: " – ",
        source: "shared"
      },
      ...endParts.map((p) => ({
        ...p,
        source: "endRange"
      }))
    ];
  }
  /** Returns the resolved formatting options based on the values passed to the constructor. */
  resolvedOptions() {
    let resolvedOptions = this.formatter.resolvedOptions();
    if ($fb18d541ea1ad717$var$hasBuggyResolvedHourCycle()) {
      if (!this.resolvedHourCycle) this.resolvedHourCycle = $fb18d541ea1ad717$var$getResolvedHourCycle(resolvedOptions.locale, this.options);
      resolvedOptions.hourCycle = this.resolvedHourCycle;
      resolvedOptions.hour12 = this.resolvedHourCycle === "h11" || this.resolvedHourCycle === "h12";
    }
    if (resolvedOptions.calendar === "ethiopic-amete-alem") resolvedOptions.calendar = "ethioaa";
    return resolvedOptions;
  }
  constructor(locale, options = {}) {
    this.formatter = $fb18d541ea1ad717$var$getCachedDateFormatter(locale, options);
    this.options = options;
  }
}
const $fb18d541ea1ad717$var$hour12Preferences = {
  true: {
    // Only Japanese uses the h11 style for 12 hour time. All others use h12.
    ja: "h11"
  },
  false: {}
};
function $fb18d541ea1ad717$var$getCachedDateFormatter(locale, options = {}) {
  if (typeof options.hour12 === "boolean" && $fb18d541ea1ad717$var$hasBuggyHour12Behavior()) {
    options = {
      ...options
    };
    let pref = $fb18d541ea1ad717$var$hour12Preferences[String(options.hour12)][locale.split("-")[0]];
    let defaultHourCycle = options.hour12 ? "h12" : "h23";
    options.hourCycle = pref !== null && pref !== void 0 ? pref : defaultHourCycle;
    delete options.hour12;
  }
  let cacheKey = locale + (options ? Object.entries(options).sort((a, b) => a[0] < b[0] ? -1 : 1).join() : "");
  if ($fb18d541ea1ad717$var$formatterCache.has(cacheKey)) return $fb18d541ea1ad717$var$formatterCache.get(cacheKey);
  let numberFormatter = new Intl.DateTimeFormat(locale, options);
  $fb18d541ea1ad717$var$formatterCache.set(cacheKey, numberFormatter);
  return numberFormatter;
}
__name($fb18d541ea1ad717$var$getCachedDateFormatter, "$fb18d541ea1ad717$var$getCachedDateFormatter");
let $fb18d541ea1ad717$var$_hasBuggyHour12Behavior = null;
function $fb18d541ea1ad717$var$hasBuggyHour12Behavior() {
  if ($fb18d541ea1ad717$var$_hasBuggyHour12Behavior == null) $fb18d541ea1ad717$var$_hasBuggyHour12Behavior = new Intl.DateTimeFormat("en-US", {
    hour: "numeric",
    hour12: false
  }).format(new Date(2020, 2, 3, 0)) === "24";
  return $fb18d541ea1ad717$var$_hasBuggyHour12Behavior;
}
__name($fb18d541ea1ad717$var$hasBuggyHour12Behavior, "$fb18d541ea1ad717$var$hasBuggyHour12Behavior");
let $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle = null;
function $fb18d541ea1ad717$var$hasBuggyResolvedHourCycle() {
  if ($fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle == null) $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle = new Intl.DateTimeFormat("fr", {
    hour: "numeric",
    hour12: false
  }).resolvedOptions().hourCycle === "h12";
  return $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle;
}
__name($fb18d541ea1ad717$var$hasBuggyResolvedHourCycle, "$fb18d541ea1ad717$var$hasBuggyResolvedHourCycle");
function $fb18d541ea1ad717$var$getResolvedHourCycle(locale, options) {
  if (!options.timeStyle && !options.hour) return void 0;
  locale = locale.replace(/(-u-)?-nu-[a-zA-Z0-9]+/, "");
  locale += (locale.includes("-u-") ? "" : "-u") + "-nu-latn";
  let formatter = $fb18d541ea1ad717$var$getCachedDateFormatter(locale, {
    ...options,
    timeZone: void 0
    // use local timezone
  });
  let min2 = parseInt(formatter.formatToParts(new Date(2020, 2, 3, 0)).find((p) => p.type === "hour").value, 10);
  let max2 = parseInt(formatter.formatToParts(new Date(2020, 2, 3, 23)).find((p) => p.type === "hour").value, 10);
  if (min2 === 0 && max2 === 23) return "h23";
  if (min2 === 24 && max2 === 23) return "h24";
  if (min2 === 0 && max2 === 11) return "h11";
  if (min2 === 12 && max2 === 11) return "h12";
  throw new Error("Unexpected hour cycle result");
}
__name($fb18d541ea1ad717$var$getResolvedHourCycle, "$fb18d541ea1ad717$var$getResolvedHourCycle");
function parseStringToDateValue(dateStr, referenceVal) {
  let dateValue;
  if (isZonedDateTime(referenceVal)) dateValue = $fae977aafc393c5c$export$fd7893f06e92a6a4(dateStr);
  else if (isCalendarDateTime(referenceVal)) dateValue = $fae977aafc393c5c$export$588937bcd60ade55(dateStr);
  else dateValue = $fae977aafc393c5c$export$6b862160d295c8e(dateStr);
  return dateValue.calendar !== referenceVal.calendar ? $11d87f3f76e88657$export$b4a036af3fc0b032(dateValue, referenceVal.calendar) : dateValue;
}
__name(parseStringToDateValue, "parseStringToDateValue");
function toDate(dateValue, tz = $14e0f24ef4ac5c92$export$aa8b41735afcabd2()) {
  if (isZonedDateTime(dateValue)) return dateValue.toDate();
  else return dateValue.toDate(tz);
}
__name(toDate, "toDate");
function isCalendarDateTime(dateValue) {
  return dateValue instanceof $35ea8db9cb2ccb90$export$ca871e8dbb80966f;
}
__name(isCalendarDateTime, "isCalendarDateTime");
function isZonedDateTime(dateValue) {
  return dateValue instanceof $35ea8db9cb2ccb90$export$d3b7288e7994edea;
}
__name(isZonedDateTime, "isZonedDateTime");
function hasTime(dateValue) {
  return isCalendarDateTime(dateValue) || isZonedDateTime(dateValue);
}
__name(hasTime, "hasTime");
function getDaysInMonth(date) {
  if (date instanceof Date) {
    const year = date.getFullYear();
    const month = date.getMonth() + 1;
    return new Date(year, month, 0).getDate();
  } else return date.set({ day: 100 }).day;
}
__name(getDaysInMonth, "getDaysInMonth");
function isBefore(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) < 0;
}
__name(isBefore, "isBefore");
function isAfter(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) > 0;
}
__name(isAfter, "isAfter");
function isBeforeOrSame(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) <= 0;
}
__name(isBeforeOrSame, "isBeforeOrSame");
function isAfterOrSame(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) >= 0;
}
__name(isAfterOrSame, "isAfterOrSame");
function isBetweenInclusive(date, start, end) {
  return isAfterOrSame(date, start) && isBeforeOrSame(date, end);
}
__name(isBetweenInclusive, "isBetweenInclusive");
function isBetween(date, start, end) {
  return isAfter(date, start) && isBefore(date, end);
}
__name(isBetween, "isBetween");
function getLastFirstDayOfWeek(date, firstDayOfWeek, locale) {
  const day = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale);
  if (firstDayOfWeek > day) return date.subtract({ days: day + 7 - firstDayOfWeek });
  if (firstDayOfWeek === day) return date;
  return date.subtract({ days: day - firstDayOfWeek });
}
__name(getLastFirstDayOfWeek, "getLastFirstDayOfWeek");
function getNextLastDayOfWeek(date, firstDayOfWeek, locale) {
  const day = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale);
  const lastDayOfWeek = firstDayOfWeek === 0 ? 6 : firstDayOfWeek - 1;
  if (day === lastDayOfWeek) return date;
  if (day > lastDayOfWeek) return date.add({ days: 7 - day + lastDayOfWeek });
  return date.add({ days: lastDayOfWeek - day });
}
__name(getNextLastDayOfWeek, "getNextLastDayOfWeek");
function areAllDaysBetweenValid(start, end, isUnavailable, isDisabled, isHighlightable) {
  if (isUnavailable === void 0 && isDisabled === void 0 && isHighlightable === void 0) return true;
  let dCurrent = start.add({ days: 1 });
  if ((isDisabled?.(dCurrent) || isUnavailable?.(dCurrent)) && !isHighlightable?.(dCurrent)) return false;
  const dEnd = end;
  while (dCurrent.compare(dEnd) < 0) {
    dCurrent = dCurrent.add({ days: 1 });
    if ((isDisabled?.(dCurrent) || isUnavailable?.(dCurrent)) && !isHighlightable?.(dCurrent)) return false;
  }
  return true;
}
__name(areAllDaysBetweenValid, "areAllDaysBetweenValid");
function getDefaultDate(props2) {
  const { defaultValue, defaultPlaceholder, granularity = "day", locale = "en" } = props2;
  if (Array.isArray(defaultValue) && defaultValue.length) return defaultValue.at(-1).copy();
  if (defaultValue && !Array.isArray(defaultValue)) return defaultValue.copy();
  if (defaultPlaceholder) return defaultPlaceholder.copy();
  const date = /* @__PURE__ */ new Date();
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const day = date.getDate();
  const calendarDateTimeGranularities2 = [
    "hour",
    "minute",
    "second"
  ];
  const defaultFormatter = new $fb18d541ea1ad717$export$ad991b66133851cf(locale);
  const calendar = $64244302c3013299$export$dd0bbc9b26defe37(defaultFormatter.resolvedOptions().calendar);
  if (calendarDateTimeGranularities2.includes(granularity ?? "day")) return $11d87f3f76e88657$export$b4a036af3fc0b032(new $35ea8db9cb2ccb90$export$ca871e8dbb80966f(year, month, day, 0, 0, 0), calendar);
  return $11d87f3f76e88657$export$b4a036af3fc0b032(new $35ea8db9cb2ccb90$export$99faa760c7908e4f(year, month, day), calendar);
}
__name(getDefaultDate, "getDefaultDate");
function getDefaultTime(props2) {
  const { defaultValue, defaultPlaceholder } = props2;
  if (defaultValue) return defaultValue.copy();
  if (defaultPlaceholder) return defaultPlaceholder.copy();
  return new $35ea8db9cb2ccb90$export$680ea196effce5f(0, 0, 0);
}
__name(getDefaultTime, "getDefaultTime");
function chunk(arr, size2) {
  const result = [];
  for (let i = 0; i < arr.length; i += size2) result.push(arr.slice(i, i + size2));
  return result;
}
__name(chunk, "chunk");
function getOptsByGranularity(granularity, hourCycle, isTimeValue = false) {
  const opts = {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
    hour: "2-digit",
    minute: "2-digit",
    second: "2-digit",
    timeZoneName: "short",
    hourCycle: normalizeHourCycle(hourCycle),
    hour12: normalizeHour12(hourCycle)
  };
  if (isTimeValue) {
    delete opts.year;
    delete opts.month;
    delete opts.day;
  }
  if (granularity === "day") {
    delete opts.second;
    delete opts.hour;
    delete opts.minute;
    delete opts.timeZoneName;
  }
  if (granularity === "hour") {
    delete opts.minute;
    delete opts.second;
  }
  if (granularity === "minute") delete opts.second;
  return opts;
}
__name(getOptsByGranularity, "getOptsByGranularity");
function normalizeDateStep(props2) {
  return defu(props2?.step, {
    year: 1,
    month: 1,
    day: 1,
    hour: 1,
    minute: 1,
    second: 1,
    millisecond: 1
  });
}
__name(normalizeDateStep, "normalizeDateStep");
function handleCalendarInitialFocus(calendar) {
  const selectedDay = calendar.querySelector("[data-selected]");
  if (selectedDay) return selectedDay.focus();
  const today = calendar.querySelector("[data-today]");
  if (today) return today.focus();
  const firstDay = calendar.querySelector("[data-reka-calendar-day]");
  if (firstDay) return firstDay.focus();
}
__name(handleCalendarInitialFocus, "handleCalendarInitialFocus");
function normalizeHourCycle(hourCycle) {
  if (hourCycle === 24) return "h23";
  if (hourCycle === 12) return "h11";
  return void 0;
}
__name(normalizeHourCycle, "normalizeHourCycle");
function normalizeHour12(hourCycle) {
  if (hourCycle === 24) return false;
  if (hourCycle === 12) return true;
  return void 0;
}
__name(normalizeHour12, "normalizeHour12");
function getDaysBetween(start, end) {
  const days = [];
  let dCurrent = start.add({ days: 1 });
  const dEnd = end;
  while (dCurrent.compare(dEnd) < 0) {
    days.push(dCurrent);
    dCurrent = dCurrent.add({ days: 1 });
  }
  return days;
}
__name(getDaysBetween, "getDaysBetween");
function createMonth(props2) {
  const { dateObj, weekStartsOn, fixedWeeks, locale } = props2;
  const daysInMonth = getDaysInMonth(dateObj);
  const datesArray = Array.from({ length: daysInMonth }, (_, i) => dateObj.set({ day: i + 1 }));
  const firstDayOfMonth = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(dateObj);
  const lastDayOfMonth = $14e0f24ef4ac5c92$export$a2258d9c4118825c(dateObj);
  const lastSunday = getLastFirstDayOfWeek(firstDayOfMonth, weekStartsOn, locale);
  const nextSaturday = getNextLastDayOfWeek(lastDayOfMonth, weekStartsOn, locale);
  const lastMonthDays = getDaysBetween(lastSunday.subtract({ days: 1 }), firstDayOfMonth);
  const nextMonthDays = getDaysBetween(lastDayOfMonth, nextSaturday.add({ days: 1 }));
  const totalDays = lastMonthDays.length + datesArray.length + nextMonthDays.length;
  if (fixedWeeks && totalDays < 42) {
    const extraDays = 42 - totalDays;
    let startFrom = nextMonthDays[nextMonthDays.length - 1];
    if (!startFrom) startFrom = $14e0f24ef4ac5c92$export$a2258d9c4118825c(dateObj);
    const extraDaysArray = Array.from({ length: extraDays }, (_, i) => {
      const incr = i + 1;
      return startFrom.add({ days: incr });
    });
    nextMonthDays.push(...extraDaysArray);
  }
  const allDays = lastMonthDays.concat(datesArray, nextMonthDays);
  const weeks = chunk(allDays, 7);
  return {
    value: dateObj,
    cells: allDays,
    rows: weeks
  };
}
__name(createMonth, "createMonth");
function startOfDecade(dateObj) {
  return $14e0f24ef4ac5c92$export$f91e89d3d0406102(dateObj.subtract({ years: dateObj.year - Math.floor(dateObj.year / 10) * 10 }).set({
    day: 1,
    month: 1
  }));
}
__name(startOfDecade, "startOfDecade");
function endOfDecade(dateObj) {
  return $14e0f24ef4ac5c92$export$8b7aa55c66d5569e(dateObj.add({ years: Math.ceil((dateObj.year + 1) / 10) * 10 - dateObj.year - 1 }).set({
    day: 35,
    month: 12
  }));
}
__name(endOfDecade, "endOfDecade");
function createDecade(props2) {
  const { dateObj, startIndex, endIndex } = props2;
  const decadeArray = Array.from({ length: Math.abs(startIndex ?? 0) + endIndex }, (_, i) => i <= Math.abs(startIndex ?? 0) ? dateObj.subtract({ years: i }).set({
    day: 1,
    month: 1
  }) : dateObj.add({ years: i - endIndex }).set({
    day: 1,
    month: 1
  }));
  decadeArray.sort((a, b) => a.year - b.year);
  return decadeArray;
}
__name(createDecade, "createDecade");
function createYear(props2) {
  const { dateObj, numberOfMonths = 1, pagedNavigation = false } = props2;
  if (numberOfMonths && pagedNavigation) {
    const monthsArray$1 = Array.from({ length: Math.floor(12 / numberOfMonths) }, (_, i) => $14e0f24ef4ac5c92$export$a5a3b454ada2268e(dateObj.set({ month: i * numberOfMonths + 1 })));
    return monthsArray$1;
  }
  const monthsArray = Array.from({ length: 12 }, (_, i) => $14e0f24ef4ac5c92$export$a5a3b454ada2268e(dateObj.set({ month: i + 1 })));
  return monthsArray;
}
__name(createYear, "createYear");
function createMonths(props2) {
  const { numberOfMonths, dateObj, ...monthProps } = props2;
  const months = [];
  if (!numberOfMonths || numberOfMonths === 1) {
    months.push(createMonth({
      ...monthProps,
      dateObj
    }));
    return months;
  }
  months.push(createMonth({
    ...monthProps,
    dateObj
  }));
  for (let i = 1; i < numberOfMonths; i++) {
    const nextMonth = dateObj.add({ months: i });
    months.push(createMonth({
      ...monthProps,
      dateObj: nextMonth
    }));
  }
  return months;
}
__name(createMonths, "createMonths");
function createYearRange({ start, end }) {
  const years = [];
  if (!start || !end) return years;
  let current = $14e0f24ef4ac5c92$export$f91e89d3d0406102(start);
  while (current.compare(end) <= 0) {
    years.push(current);
    current = $14e0f24ef4ac5c92$export$f91e89d3d0406102(current.add({ years: 1 }));
  }
  return years;
}
__name(createYearRange, "createYearRange");
function createDateRange({ start, end }) {
  const dates = [];
  if (!start || !end) return dates;
  let current = start;
  while (current.compare(end) <= 0) {
    dates.push(current);
    current = current.add({ days: 1 });
  }
  return dates;
}
__name(createDateRange, "createDateRange");
function getWeekNumber(date, locale = "en-US", firstDayOfWeek) {
  const firstDayOfYear = new $35ea8db9cb2ccb90$export$99faa760c7908e4f(date.year, 1, 1);
  const firstDayOfYearWeekday = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(firstDayOfYear, locale, firstDayOfWeek);
  const firstWeekStart = firstDayOfYear.subtract({ days: firstDayOfYearWeekday });
  if (date.compare(firstWeekStart) < 0) {
    const prevYearDate = new $35ea8db9cb2ccb90$export$99faa760c7908e4f(date.year - 1, 12, 31);
    return getWeekNumber(prevYearDate, locale, firstDayOfWeek);
  }
  const days = getDaysBetween(firstWeekStart, date);
  return Math.floor(days.length / 7) + 1;
}
__name(getWeekNumber, "getWeekNumber");
function useDateFormatter(initialLocale, opts = {}) {
  const locale = ref(initialLocale);
  function getLocale() {
    return locale.value;
  }
  __name(getLocale, "getLocale");
  function setLocale(newLocale) {
    locale.value = newLocale;
  }
  __name(setLocale, "setLocale");
  function custom(date, options) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      ...options
    }).format(date);
  }
  __name(custom, "custom");
  function selectedDate(date, includeTime = true) {
    if (hasTime(date) && includeTime) return custom(toDate(date), {
      dateStyle: "long",
      timeStyle: "long"
    });
    else return custom(toDate(date), { dateStyle: "long" });
  }
  __name(selectedDate, "selectedDate");
  function fullMonthAndYear(date, options = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      month: "long",
      year: "numeric",
      ...options
    }).format(date);
  }
  __name(fullMonthAndYear, "fullMonthAndYear");
  function fullMonth(date, options = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      month: "long",
      ...options
    }).format(date);
  }
  __name(fullMonth, "fullMonth");
  function getMonths() {
    const defaultDate = $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3($14e0f24ef4ac5c92$export$aa8b41735afcabd2());
    const months = [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12
    ];
    return months.map((item) => ({
      label: fullMonth(toDate(defaultDate.set({ month: item }))),
      value: item
    }));
  }
  __name(getMonths, "getMonths");
  function fullYear(date, options = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      year: "numeric",
      ...options
    }).format(date);
  }
  __name(fullYear, "fullYear");
  function toParts(date, options) {
    if (isZonedDateTime(date)) return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      ...options,
      timeZone: date.timeZone
    }).formatToParts(toDate(date));
    else return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      ...options
    }).formatToParts(toDate(date));
  }
  __name(toParts, "toParts");
  function dayOfWeek(date, length = "narrow") {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      weekday: length
    }).format(date);
  }
  __name(dayOfWeek, "dayOfWeek");
  function dayPeriod(date) {
    const parts = new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      hour: "numeric",
      minute: "numeric"
    }).formatToParts(date);
    const value = parts.find((p) => p.type === "dayPeriod")?.value;
    if (value === "PM" || value === "p.m.") return "PM";
    return "AM";
  }
  __name(dayPeriod, "dayPeriod");
  const defaultPartOptions = {
    year: "numeric",
    month: "numeric",
    day: "numeric",
    hour: "numeric",
    minute: "numeric",
    second: "numeric"
  };
  function part(dateObj, type, options = {}) {
    const opts$1 = {
      ...defaultPartOptions,
      ...options
    };
    const parts = toParts(dateObj, opts$1);
    const part$1 = parts.find((p) => p.type === type);
    return part$1 ? part$1.value : "";
  }
  __name(part, "part");
  return {
    setLocale,
    getLocale,
    fullMonth,
    fullYear,
    fullMonthAndYear,
    toParts,
    custom,
    part,
    dayPeriod,
    selectedDate,
    dayOfWeek,
    getMonths
  };
}
__name(useDateFormatter, "useDateFormatter");
function useDirection(dir) {
  const context2 = injectConfigProviderContext({ dir: ref("ltr") });
  return computed(() => dir?.value || context2.dir?.value || "ltr");
}
__name(useDirection, "useDirection");
function useEmitAsProps(emit) {
  const vm = getCurrentInstance();
  const events2 = vm?.type.emits;
  const result = {};
  if (!events2?.length) console.warn(`No emitted event found. Please check component: ${vm?.type.__name}`);
  events2?.forEach((ev) => {
    result[toHandlerKey(camelize$1(ev))] = (...arg) => emit(ev, ...arg);
  });
  return result;
}
__name(useEmitAsProps, "useEmitAsProps");
function useFilter(options) {
  const computedOptions = computed(() => unref(options));
  const collator = computed(() => new Intl.Collator("en", {
    usage: "search",
    ...computedOptions.value
  }));
  const startsWith = /* @__PURE__ */ __name((string, substring) => {
    if (substring.length === 0) return true;
    string = string.normalize("NFC");
    substring = substring.normalize("NFC");
    return collator.value.compare(string.slice(0, substring.length), substring) === 0;
  }, "startsWith");
  const endsWith = /* @__PURE__ */ __name((string, substring) => {
    if (substring.length === 0) return true;
    string = string.normalize("NFC");
    substring = substring.normalize("NFC");
    return collator.value.compare(string.slice(-substring.length), substring) === 0;
  }, "endsWith");
  const contains = /* @__PURE__ */ __name((string, substring) => {
    if (substring.length === 0) return true;
    string = string.normalize("NFC");
    substring = substring.normalize("NFC");
    let scan = 0;
    const sliceLen = substring.length;
    for (; scan + sliceLen <= string.length; scan++) {
      const slice = string.slice(scan, scan + sliceLen);
      if (collator.value.compare(substring, slice) === 0) return true;
    }
    return false;
  }, "contains");
  return {
    startsWith,
    endsWith,
    contains
  };
}
__name(useFilter, "useFilter");
let count$1 = 0;
function useFocusGuards() {
  watchEffect((cleanupFn) => {
    if (!isClient) return;
    const edgeGuards = document.querySelectorAll("[data-reka-focus-guard]");
    document.body.insertAdjacentElement("afterbegin", edgeGuards[0] ?? createFocusGuard());
    document.body.insertAdjacentElement("beforeend", edgeGuards[1] ?? createFocusGuard());
    count$1++;
    cleanupFn(() => {
      if (count$1 === 1) document.querySelectorAll("[data-reka-focus-guard]").forEach((node) => node.remove());
      count$1--;
    });
  });
}
__name(useFocusGuards, "useFocusGuards");
function createFocusGuard() {
  const element = document.createElement("span");
  element.setAttribute("data-reka-focus-guard", "");
  element.tabIndex = 0;
  element.style.outline = "none";
  element.style.opacity = "0";
  element.style.position = "fixed";
  element.style.pointerEvents = "none";
  return element;
}
__name(createFocusGuard, "createFocusGuard");
function useFormControl(el) {
  return computed(() => toValue$1(el) ? Boolean(unrefElement(el)?.closest("form")) : true);
}
__name(useFormControl, "useFormControl");
function useForwardExpose() {
  const instance = getCurrentInstance();
  const currentRef = ref();
  const currentElement = computed(() => {
    return ["#text", "#comment"].includes(currentRef.value?.$el.nodeName) ? currentRef.value?.$el.nextElementSibling : unrefElement(currentRef);
  });
  const localExpose = Object.assign({}, instance.exposed);
  const ret = {};
  for (const key in instance.props) Object.defineProperty(ret, key, {
    enumerable: true,
    configurable: true,
    get: /* @__PURE__ */ __name(() => instance.props[key], "get")
  });
  if (Object.keys(localExpose).length > 0) for (const key in localExpose) Object.defineProperty(ret, key, {
    enumerable: true,
    configurable: true,
    get: /* @__PURE__ */ __name(() => localExpose[key], "get")
  });
  Object.defineProperty(ret, "$el", {
    enumerable: true,
    configurable: true,
    get: /* @__PURE__ */ __name(() => instance.vnode.el, "get")
  });
  instance.exposed = ret;
  function forwardRef(ref$1) {
    currentRef.value = ref$1;
    if (!ref$1) return;
    Object.defineProperty(ret, "$el", {
      enumerable: true,
      configurable: true,
      get: /* @__PURE__ */ __name(() => ref$1 instanceof Element ? ref$1 : ref$1.$el, "get")
    });
    instance.exposed = ret;
  }
  __name(forwardRef, "forwardRef");
  return {
    forwardRef,
    currentRef,
    currentElement
  };
}
__name(useForwardExpose, "useForwardExpose");
function useForwardProps(props2) {
  const vm = getCurrentInstance();
  const defaultProps = Object.keys(vm?.type.props ?? {}).reduce((prev, curr) => {
    const defaultValue = (vm?.type.props[curr]).default;
    if (defaultValue !== void 0) prev[curr] = defaultValue;
    return prev;
  }, {});
  const refProps = toRef$1(props2);
  return computed(() => {
    const preservedProps = {};
    const assignedProps = vm?.vnode.props ?? {};
    Object.keys(assignedProps).forEach((key) => {
      preservedProps[camelize$1(key)] = assignedProps[key];
    });
    return Object.keys({
      ...defaultProps,
      ...preservedProps
    }).reduce((prev, curr) => {
      if (refProps.value[curr] !== void 0) prev[curr] = refProps.value[curr];
      return prev;
    }, {});
  });
}
__name(useForwardProps, "useForwardProps");
function useForwardPropsEmits(props2, emit) {
  const parsedProps = useForwardProps(props2);
  const emitsAsProps = emit ? useEmitAsProps(emit) : {};
  return computed(() => ({
    ...parsedProps.value,
    ...emitsAsProps
  }));
}
__name(useForwardPropsEmits, "useForwardPropsEmits");
function useGraceArea(triggerElement, containerElement) {
  const isPointerInTransit = refAutoReset(false, 300);
  const pointerGraceArea = ref(null);
  const pointerExit = createEventHook();
  function handleRemoveGraceArea() {
    pointerGraceArea.value = null;
    isPointerInTransit.value = false;
  }
  __name(handleRemoveGraceArea, "handleRemoveGraceArea");
  function handleCreateGraceArea(event, hoverTarget) {
    const currentTarget = event.currentTarget;
    const exitPoint = {
      x: event.clientX,
      y: event.clientY
    };
    const exitSide = getExitSideFromRect(exitPoint, currentTarget.getBoundingClientRect());
    const paddedExitPoints = getPaddedExitPoints(exitPoint, exitSide);
    const hoverTargetPoints = getPointsFromRect(hoverTarget.getBoundingClientRect());
    const graceArea = getHull([...paddedExitPoints, ...hoverTargetPoints]);
    pointerGraceArea.value = graceArea;
    isPointerInTransit.value = true;
  }
  __name(handleCreateGraceArea, "handleCreateGraceArea");
  watchEffect((cleanupFn) => {
    if (triggerElement.value && containerElement.value) {
      const handleTriggerLeave = /* @__PURE__ */ __name((event) => handleCreateGraceArea(event, containerElement.value), "handleTriggerLeave");
      const handleContentLeave = /* @__PURE__ */ __name((event) => handleCreateGraceArea(event, triggerElement.value), "handleContentLeave");
      triggerElement.value.addEventListener("pointerleave", handleTriggerLeave);
      containerElement.value.addEventListener("pointerleave", handleContentLeave);
      cleanupFn(() => {
        triggerElement.value?.removeEventListener("pointerleave", handleTriggerLeave);
        containerElement.value?.removeEventListener("pointerleave", handleContentLeave);
      });
    }
  });
  watchEffect((cleanupFn) => {
    if (pointerGraceArea.value) {
      const handleTrackPointerGrace = /* @__PURE__ */ __name((event) => {
        if (!pointerGraceArea.value || !(event.target instanceof HTMLElement)) return;
        const target = event.target;
        const pointerPosition = {
          x: event.clientX,
          y: event.clientY
        };
        const hasEnteredTarget = triggerElement.value?.contains(target) || containerElement.value?.contains(target);
        const isPointerOutsideGraceArea = !isPointInPolygon$1(pointerPosition, pointerGraceA