from functools import reduce


def predict_number_of_row_from_conf(conf):
    """
    Precict the number of row of the fake data set generated by `fake_data_generator(conf)`
    This is the product of number of values for each label
    """
    num_uniques_by_label = [len(c.get('values', [])) for c in conf if c['type'] == 'label']
    if len(num_uniques_by_label) > 0:
        return reduce(lambda x, y: x * y, num_uniques_by_label)
    else:
        # There are no labels in `conf`. Therefore the generated data will be empty:
        return 0
