# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AccessControlList(TrackedResource):
    """The AccessControlList resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar address_family: IP address family. Example: ipv4 | ipv6. Required. Known values are:
     "ipv4" and "ipv6".
    :vartype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
    :ivar conditions: Access Control List conditions. Required.
    :vartype conditions:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "address_family": {"required": True},
        "conditions": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "address_family": {"key": "properties.addressFamily", "type": "str"},
        "conditions": {"key": "properties.conditions", "type": "[AccessControlListConditionProperties]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        address_family: Union[str, "_models.AddressFamily"],
        conditions: List["_models.AccessControlListConditionProperties"],
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword address_family: IP address family. Example: ipv4 | ipv6. Required. Known values are:
         "ipv4" and "ipv6".
        :paramtype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
        :keyword conditions: Access Control List conditions. Required.
        :paramtype conditions:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.address_family = address_family
        self.conditions = conditions
        self.provisioning_state = None


class AnnotationResource(_serialization.Model):
    """Switch configuration entries require a description to discern between configuration groups.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation


class AccessControlListConditionProperties(AnnotationResource):
    """Access Control List condition model.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar sequence_number: sequenceNumber of the Access Control List. Required.
    :vartype sequence_number: int
    :ivar action: action. Example: allow | deny. Required. Known values are: "allow" and "deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.ConditionActionType
    :ivar destination_address: destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10. Required.
    :vartype destination_address: str
    :ivar destination_port: destinationPort. Example: any | 1253. Required.
    :vartype destination_port: str
    :ivar source_address: sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10. Required.
    :vartype source_address: str
    :ivar source_port: sourcePort. Example: any | 1253. Required.
    :vartype source_port: str
    :ivar protocol: TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255
     (any) | 0 | 1. Required.
    :vartype protocol: int
    """

    _validation = {
        "sequence_number": {"required": True},
        "action": {"required": True},
        "destination_address": {"required": True},
        "destination_port": {"required": True},
        "source_address": {"required": True},
        "source_port": {"required": True},
        "protocol": {"required": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "action": {"key": "action", "type": "str"},
        "destination_address": {"key": "destinationAddress", "type": "str"},
        "destination_port": {"key": "destinationPort", "type": "str"},
        "source_address": {"key": "sourceAddress", "type": "str"},
        "source_port": {"key": "sourcePort", "type": "str"},
        "protocol": {"key": "protocol", "type": "int"},
    }

    def __init__(
        self,
        *,
        sequence_number: int,
        action: Union[str, "_models.ConditionActionType"],
        destination_address: str,
        destination_port: str,
        source_address: str,
        source_port: str,
        protocol: int,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword sequence_number: sequenceNumber of the Access Control List. Required.
        :paramtype sequence_number: int
        :keyword action: action. Example: allow | deny. Required. Known values are: "allow" and "deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.ConditionActionType
        :keyword destination_address: destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10.
         Required.
        :paramtype destination_address: str
        :keyword destination_port: destinationPort. Example: any | 1253. Required.
        :paramtype destination_port: str
        :keyword source_address: sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10. Required.
        :paramtype source_address: str
        :keyword source_port: sourcePort. Example: any | 1253. Required.
        :paramtype source_port: str
        :keyword protocol: TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255
         (any) | 0 | 1. Required.
        :paramtype protocol: int
        """
        super().__init__(annotation=annotation, **kwargs)
        self.sequence_number = sequence_number
        self.action = action
        self.destination_address = destination_address
        self.destination_port = destination_port
        self.source_address = source_address
        self.source_port = source_port
        self.protocol = protocol


class AccessControlListPatch(_serialization.Model):
    """The AccessControlList patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar address_family: IP address family. Example: ipv4 | ipv6. Known values are: "ipv4" and
     "ipv6".
    :vartype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
    :ivar conditions: Access Control List conditions.
    :vartype conditions:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "address_family": {"key": "properties.addressFamily", "type": "str"},
        "conditions": {"key": "properties.conditions", "type": "[AccessControlListConditionProperties]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        address_family: Optional[Union[str, "_models.AddressFamily"]] = None,
        conditions: Optional[List["_models.AccessControlListConditionProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword address_family: IP address family. Example: ipv4 | ipv6. Known values are: "ipv4" and
         "ipv6".
        :paramtype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
        :keyword conditions: Access Control List conditions.
        :paramtype conditions:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.annotation = annotation
        self.address_family = address_family
        self.conditions = conditions


class AccessControlListPatchProperties(AnnotationResource):
    """AccessControlListPatchProperties define the patchable resource properties.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar address_family: IP address family. Example: ipv4 | ipv6. Known values are: "ipv4" and
     "ipv6".
    :vartype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
    :ivar conditions: Access Control List conditions.
    :vartype conditions:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "address_family": {"key": "addressFamily", "type": "str"},
        "conditions": {"key": "conditions", "type": "[AccessControlListConditionProperties]"},
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        address_family: Optional[Union[str, "_models.AddressFamily"]] = None,
        conditions: Optional[List["_models.AccessControlListConditionProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword address_family: IP address family. Example: ipv4 | ipv6. Known values are: "ipv4" and
         "ipv6".
        :paramtype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
        :keyword conditions: Access Control List conditions.
        :paramtype conditions:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.address_family = address_family
        self.conditions = conditions


class AccessControlListProperties(AnnotationResource):
    """AccessControlListProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar address_family: IP address family. Example: ipv4 | ipv6. Required. Known values are:
     "ipv4" and "ipv6".
    :vartype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
    :ivar conditions: Access Control List conditions. Required.
    :vartype conditions:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "address_family": {"required": True},
        "conditions": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "address_family": {"key": "addressFamily", "type": "str"},
        "conditions": {"key": "conditions", "type": "[AccessControlListConditionProperties]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        address_family: Union[str, "_models.AddressFamily"],
        conditions: List["_models.AccessControlListConditionProperties"],
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword address_family: IP address family. Example: ipv4 | ipv6. Required. Known values are:
         "ipv4" and "ipv6".
        :paramtype address_family: str or ~azure.mgmt.managednetworkfabric.models.AddressFamily
        :keyword conditions: Access Control List conditions. Required.
        :paramtype conditions:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListConditionProperties]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.address_family = address_family
        self.conditions = conditions
        self.provisioning_state = None


class AccessControlListsListResult(_serialization.Model):
    """List of AccessControlLists.

    :ivar value: List of AccessControlList resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.AccessControlList]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessControlList]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessControlList"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of AccessControlList resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.AccessControlList]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpCommunitySetOperationProperties(_serialization.Model):
    """IP Community set operation properties.

    :ivar set: IP Community ID list properties.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpCommunityIdList"},
    }

    def __init__(self, *, set: Optional["_models.IpCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword set: IP Community ID list properties.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(**kwargs)
        self.set = set


class IpCommunityDeleteOperationProperties(_serialization.Model):
    """IP Community delete operation properties.

    :ivar delete: IP Community ID list properties.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "delete": {"key": "delete", "type": "IpCommunityIdList"},
    }

    def __init__(self, *, delete: Optional["_models.IpCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword delete: IP Community ID list properties.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(**kwargs)
        self.delete = delete


class IpCommunityAddOperationProperties(_serialization.Model):
    """IP Community add operation properties.

    :ivar add: IP Community ID list properties.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "add": {"key": "add", "type": "IpCommunityIdList"},
    }

    def __init__(self, *, add: Optional["_models.IpCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword add: IP Community ID list properties.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(**kwargs)
        self.add = add


class ActionIpCommunityProperties(
    IpCommunityAddOperationProperties, IpCommunityDeleteOperationProperties, IpCommunitySetOperationProperties
):
    """IP Community Properties.

    :ivar set: IP Community ID list properties.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    :ivar delete: IP Community ID list properties.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    :ivar add: IP Community ID list properties.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpCommunityIdList"},
        "delete": {"key": "delete", "type": "IpCommunityIdList"},
        "add": {"key": "add", "type": "IpCommunityIdList"},
    }

    def __init__(
        self,
        *,
        set: Optional["_models.IpCommunityIdList"] = None,
        delete: Optional["_models.IpCommunityIdList"] = None,
        add: Optional["_models.IpCommunityIdList"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword set: IP Community ID list properties.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        :keyword delete: IP Community ID list properties.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        :keyword add: IP Community ID list properties.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(add=add, delete=delete, set=set, **kwargs)
        self.set = set
        self.delete = delete
        self.add = add


class IpExtendedCommunitySetOperationProperties(_serialization.Model):
    """IP Extended Community set operation properties.

    :ivar set: IP Extended Community Id list properties.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(self, *, set: Optional["_models.IpExtendedCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword set: IP Extended Community Id list properties.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(**kwargs)
        self.set = set


class IpExtendedCommunityDeleteOperationProperties(_serialization.Model):
    """IP Extended Community delete operation properties.

    :ivar delete: IP Extended Community Id list properties.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "delete": {"key": "delete", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(self, *, delete: Optional["_models.IpExtendedCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword delete: IP Extended Community Id list properties.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(**kwargs)
        self.delete = delete


class IpExtendedCommunityAddOperationProperties(_serialization.Model):
    """IP Extended Community add operation properties.

    :ivar add: IP Extended Community Id list properties.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "add": {"key": "add", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(self, *, add: Optional["_models.IpExtendedCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword add: IP Extended Community Id list properties.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(**kwargs)
        self.add = add


class ActionIpExtendedCommunityProperties(
    IpExtendedCommunityAddOperationProperties,
    IpExtendedCommunityDeleteOperationProperties,
    IpExtendedCommunitySetOperationProperties,
):
    """IP Extended Community Properties.

    :ivar set: IP Extended Community Id list properties.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    :ivar delete: IP Extended Community Id list properties.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    :ivar add: IP Extended Community Id list properties.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpExtendedCommunityIdList"},
        "delete": {"key": "delete", "type": "IpExtendedCommunityIdList"},
        "add": {"key": "add", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(
        self,
        *,
        set: Optional["_models.IpExtendedCommunityIdList"] = None,
        delete: Optional["_models.IpExtendedCommunityIdList"] = None,
        add: Optional["_models.IpExtendedCommunityIdList"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword set: IP Extended Community Id list properties.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        :keyword delete: IP Extended Community Id list properties.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        :keyword add: IP Extended Community Id list properties.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(add=add, delete=delete, set=set, **kwargs)
        self.set = set
        self.delete = delete
        self.add = add


class AggregateRoute(_serialization.Model):
    """Aggregate Route properties.

    :ivar prefix: Prefix of the aggregate Route.
    :vartype prefix: str
    """

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
    }

    def __init__(self, *, prefix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword prefix: Prefix of the aggregate Route.
        :paramtype prefix: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix


class AggregateRouteConfiguration(_serialization.Model):
    """List of IPv4 and IPv6 route configurations.

    :ivar ipv4_routes: List of IPv4 Route prefixes.
    :vartype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
    :ivar ipv6_routes: List of IPv6 Routes prefixes.
    :vartype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
    """

    _attribute_map = {
        "ipv4_routes": {"key": "ipv4Routes", "type": "[AggregateRoute]"},
        "ipv6_routes": {"key": "ipv6Routes", "type": "[AggregateRoute]"},
    }

    def __init__(
        self,
        *,
        ipv4_routes: Optional[List["_models.AggregateRoute"]] = None,
        ipv6_routes: Optional[List["_models.AggregateRoute"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipv4_routes: List of IPv4 Route prefixes.
        :paramtype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
        :keyword ipv6_routes: List of IPv6 Routes prefixes.
        :paramtype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
        """
        super().__init__(**kwargs)
        self.ipv4_routes = ipv4_routes
        self.ipv6_routes = ipv6_routes


class ARPProperties(_serialization.Model):
    """Show ARP table entry properties.

    All required parameters must be populated in order to send to Azure.

    :ivar address: Ipv4 or Ipv6 address. Required.
    :vartype address: str
    :ivar age: Duration in seconds. Required.
    :vartype age: str
    :ivar mac_address: Hardware address. Required.
    :vartype mac_address: str
    :ivar interface: Layer 2 interface name. Required.
    :vartype interface: str
    :ivar state: ARP status.
    :vartype state: str
    """

    _validation = {
        "address": {"required": True},
        "age": {"required": True},
        "mac_address": {"required": True},
        "interface": {"required": True},
    }

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "age": {"key": "age", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "interface": {"key": "interface", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self, *, address: str, age: str, mac_address: str, interface: str, state: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword address: Ipv4 or Ipv6 address. Required.
        :paramtype address: str
        :keyword age: Duration in seconds. Required.
        :paramtype age: str
        :keyword mac_address: Hardware address. Required.
        :paramtype mac_address: str
        :keyword interface: Layer 2 interface name. Required.
        :paramtype interface: str
        :keyword state: ARP status.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.age = age
        self.mac_address = mac_address
        self.interface = interface
        self.state = state


class BfdConfiguration(_serialization.Model):
    """BFD configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar administrative_state: Administrative state of the BfdConfiguration. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar interval: interval in milliseconds. Example: 300.
    :vartype interval: int
    :ivar multiplier: Multiplier for the Bfd Configuration. Example: 3.
    :vartype multiplier: int
    """

    _validation = {
        "administrative_state": {"readonly": True},
        "interval": {"readonly": True},
        "multiplier": {"readonly": True},
    }

    _attribute_map = {
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "interval": {"key": "interval", "type": "int"},
        "multiplier": {"key": "multiplier", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.administrative_state = None
        self.interval = None
        self.multiplier = None


class BgpConfiguration(AnnotationResource):  # pylint: disable=too-many-instance-attributes
    """BGP configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar default_route_originate: Originate a defaultRoute. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype default_route_originate: str or
     ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar allow_as: Allows for routes to be received and processed even if the router detects its
     own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
    :vartype allow_as: int
    :ivar allow_as_override: Enable Or Disable state. Known values are: "Enable" and "Disable".
    :vartype allow_as_override: str or ~azure.mgmt.managednetworkfabric.models.AllowASOverride
    :ivar fabric_asn: ASN of Network Fabric. Example: 65048.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN. Example: 65047. Required.
    :vartype peer_asn: int
    :ivar ipv4_listen_range_prefixes: BGP Ipv4 ListenRange.
    :vartype ipv4_listen_range_prefixes: list[str]
    :ivar ipv6_listen_range_prefixes: BGP Ipv6 ListenRange.
    :vartype ipv6_listen_range_prefixes: list[str]
    :ivar ipv4_neighbor_address: List with stringified ipv4NeighborAddresses.
    :vartype ipv4_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
    :ivar ipv6_neighbor_address: List with stringified IPv6 Neighbor Address.
    :vartype ipv6_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
    """

    _validation = {
        "allow_as": {"maximum": 10, "minimum": 0},
        "fabric_asn": {"readonly": True},
        "peer_asn": {"required": True, "maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "default_route_originate": {"key": "defaultRouteOriginate", "type": "str"},
        "allow_as": {"key": "allowAS", "type": "int"},
        "allow_as_override": {"key": "allowASOverride", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "ipv4_listen_range_prefixes": {"key": "ipv4ListenRangePrefixes", "type": "[str]"},
        "ipv6_listen_range_prefixes": {"key": "ipv6ListenRangePrefixes", "type": "[str]"},
        "ipv4_neighbor_address": {"key": "ipv4NeighborAddress", "type": "[NeighborAddress]"},
        "ipv6_neighbor_address": {"key": "ipv6NeighborAddress", "type": "[NeighborAddress]"},
    }

    def __init__(
        self,
        *,
        peer_asn: int,
        annotation: Optional[str] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        default_route_originate: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        allow_as: int = 2,
        allow_as_override: Optional[Union[str, "_models.AllowASOverride"]] = None,
        ipv4_listen_range_prefixes: Optional[List[str]] = None,
        ipv6_listen_range_prefixes: Optional[List[str]] = None,
        ipv4_neighbor_address: Optional[List["_models.NeighborAddress"]] = None,
        ipv6_neighbor_address: Optional[List["_models.NeighborAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword default_route_originate: Originate a defaultRoute. Ex: "True" | "False". Known values
         are: "True" and "False".
        :paramtype default_route_originate: str or
         ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword allow_as: Allows for routes to be received and processed even if the router detects
         its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        :paramtype allow_as: int
        :keyword allow_as_override: Enable Or Disable state. Known values are: "Enable" and "Disable".
        :paramtype allow_as_override: str or ~azure.mgmt.managednetworkfabric.models.AllowASOverride
        :keyword peer_asn: Peer ASN. Example: 65047. Required.
        :paramtype peer_asn: int
        :keyword ipv4_listen_range_prefixes: BGP Ipv4 ListenRange.
        :paramtype ipv4_listen_range_prefixes: list[str]
        :keyword ipv6_listen_range_prefixes: BGP Ipv6 ListenRange.
        :paramtype ipv6_listen_range_prefixes: list[str]
        :keyword ipv4_neighbor_address: List with stringified ipv4NeighborAddresses.
        :paramtype ipv4_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
        :keyword ipv6_neighbor_address: List with stringified IPv6 Neighbor Address.
        :paramtype ipv6_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.bfd_configuration = bfd_configuration
        self.default_route_originate = default_route_originate
        self.allow_as = allow_as
        self.allow_as_override = allow_as_override
        self.fabric_asn = None
        self.peer_asn = peer_asn
        self.ipv4_listen_range_prefixes = ipv4_listen_range_prefixes
        self.ipv6_listen_range_prefixes = ipv6_listen_range_prefixes
        self.ipv4_neighbor_address = ipv4_neighbor_address
        self.ipv6_neighbor_address = ipv6_neighbor_address


class ConnectedSubnet(AnnotationResource):
    """Connected Subnet properties.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar prefix: Prefix of the connected Subnet.
    :vartype prefix: str
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "prefix": {"key": "prefix", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, prefix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword prefix: Prefix of the connected Subnet.
        :paramtype prefix: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.prefix = prefix


class DeviceInterfaceProperties(_serialization.Model):
    """Network device interface properties.

    :ivar identifier: Interface identifier. Example: HundredGigE0/0.
    :vartype identifier: str
    :ivar interface_type: Interface type.
    :vartype interface_type: str
    :ivar supported_connector_types: List of supported connector types.
    :vartype supported_connector_types:
     list[~azure.mgmt.managednetworkfabric.models.SupportedConnectorProperties]
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "interface_type": {"key": "interfaceType", "type": "str"},
        "supported_connector_types": {"key": "supportedConnectorTypes", "type": "[SupportedConnectorProperties]"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        interface_type: Optional[str] = None,
        supported_connector_types: Optional[List["_models.SupportedConnectorProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identifier: Interface identifier. Example: HundredGigE0/0.
        :paramtype identifier: str
        :keyword interface_type: Interface type.
        :paramtype interface_type: str
        :keyword supported_connector_types: List of supported connector types.
        :paramtype supported_connector_types:
         list[~azure.mgmt.managednetworkfabric.models.SupportedConnectorProperties]
        """
        super().__init__(**kwargs)
        self.identifier = identifier
        self.interface_type = interface_type
        self.supported_connector_types = supported_connector_types


class DeviceLimits(_serialization.Model):
    """Network device limits.

    :ivar physical_interface_count: Maximum number of physical interfaces.
    :vartype physical_interface_count: int
    :ivar max_sub_interfaces: Maximum number of sub-interfaces.
    :vartype max_sub_interfaces: int
    :ivar max_tunnel_interfaces: Maximum number of tunnel interfaces.
    :vartype max_tunnel_interfaces: int
    :ivar max_virtual_router_functions: Maximum number of virtual router functions.
    :vartype max_virtual_router_functions: int
    :ivar max_border_gateway_protocol_peers: Maximum number of Border Gateway Protocol (BGP) peers.
    :vartype max_border_gateway_protocol_peers: int
    :ivar max_bidirectional_forwarding_detection_peers: Maximum number of Bidirectional Forwarding
     Detection (BFD) peers.
    :vartype max_bidirectional_forwarding_detection_peers: int
    """

    _attribute_map = {
        "physical_interface_count": {"key": "physicalInterfaceCount", "type": "int"},
        "max_sub_interfaces": {"key": "maxSubInterfaces", "type": "int"},
        "max_tunnel_interfaces": {"key": "maxTunnelInterfaces", "type": "int"},
        "max_virtual_router_functions": {"key": "maxVirtualRouterFunctions", "type": "int"},
        "max_border_gateway_protocol_peers": {"key": "maxBorderGatewayProtocolPeers", "type": "int"},
        "max_bidirectional_forwarding_detection_peers": {
            "key": "maxBidirectionalForwardingDetectionPeers",
            "type": "int",
        },
    }

    def __init__(
        self,
        *,
        physical_interface_count: Optional[int] = None,
        max_sub_interfaces: Optional[int] = None,
        max_tunnel_interfaces: Optional[int] = None,
        max_virtual_router_functions: Optional[int] = None,
        max_border_gateway_protocol_peers: Optional[int] = None,
        max_bidirectional_forwarding_detection_peers: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword physical_interface_count: Maximum number of physical interfaces.
        :paramtype physical_interface_count: int
        :keyword max_sub_interfaces: Maximum number of sub-interfaces.
        :paramtype max_sub_interfaces: int
        :keyword max_tunnel_interfaces: Maximum number of tunnel interfaces.
        :paramtype max_tunnel_interfaces: int
        :keyword max_virtual_router_functions: Maximum number of virtual router functions.
        :paramtype max_virtual_router_functions: int
        :keyword max_border_gateway_protocol_peers: Maximum number of Border Gateway Protocol (BGP)
         peers.
        :paramtype max_border_gateway_protocol_peers: int
        :keyword max_bidirectional_forwarding_detection_peers: Maximum number of Bidirectional
         Forwarding Detection (BFD) peers.
        :paramtype max_bidirectional_forwarding_detection_peers: int
        """
        super().__init__(**kwargs)
        self.physical_interface_count = physical_interface_count
        self.max_sub_interfaces = max_sub_interfaces
        self.max_tunnel_interfaces = max_tunnel_interfaces
        self.max_virtual_router_functions = max_virtual_router_functions
        self.max_border_gateway_protocol_peers = max_border_gateway_protocol_peers
        self.max_bidirectional_forwarding_detection_peers = max_bidirectional_forwarding_detection_peers


class EnableDisableOnResources(_serialization.Model):
    """Update administrative state on list of resources.

    :ivar resource_ids: Network Fabrics or Network Rack resource Id.
    :vartype resource_ids: list[str]
    """

    _attribute_map = {
        "resource_ids": {"key": "resourceIds", "type": "[str]"},
    }

    def __init__(self, *, resource_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword resource_ids: Network Fabrics or Network Rack resource Id.
        :paramtype resource_ids: list[str]
        """
        super().__init__(**kwargs)
        self.resource_ids = resource_ids


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.managednetworkfabric.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.managednetworkfabric.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExpressRouteConnectionInformation(_serialization.Model):
    """The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC
    service.

    All required parameters must be populated in order to send to Azure.

    :ivar express_route_circuit_id: The express route circuit Azure resource ID, must be of type
     Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory
     attribute. Required.
    :vartype express_route_circuit_id: str
    :ivar express_route_authorization_key: Authorization key for the circuit, must be of type
     Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
     Required.
    :vartype express_route_authorization_key: str
    """

    _validation = {
        "express_route_circuit_id": {"required": True},
        "express_route_authorization_key": {"required": True},
    }

    _attribute_map = {
        "express_route_circuit_id": {"key": "expressRouteCircuitId", "type": "str"},
        "express_route_authorization_key": {"key": "expressRouteAuthorizationKey", "type": "str"},
    }

    def __init__(self, *, express_route_circuit_id: str, express_route_authorization_key: str, **kwargs: Any) -> None:
        """
        :keyword express_route_circuit_id: The express route circuit Azure resource ID, must be of type
         Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory
         attribute. Required.
        :paramtype express_route_circuit_id: str
        :keyword express_route_authorization_key: Authorization key for the circuit, must be of type
         Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
         Required.
        :paramtype express_route_authorization_key: str
        """
        super().__init__(**kwargs)
        self.express_route_circuit_id = express_route_circuit_id
        self.express_route_authorization_key = express_route_authorization_key


class ExpressRouteStatusDef(_serialization.Model):
    """ExpressRouteStatus defines the resource properties.

    :ivar express_route_circuit_id: The express route circuit Azure resource ID, must be of type
     Microsoft.Network/expressRouteCircuits/circuitName.
    :vartype express_route_circuit_id: str
    :ivar express_route_status: Express route connection state for the resource. Known values are:
     "Connecting", "Connected", and "Disconnected".
    :vartype express_route_status: str or
     ~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionState
    """

    _attribute_map = {
        "express_route_circuit_id": {"key": "expressRouteCircuitId", "type": "str"},
        "express_route_status": {"key": "expressRouteStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        express_route_circuit_id: Optional[str] = None,
        express_route_status: Optional[Union[str, "_models.ExpressRouteConnectionState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword express_route_circuit_id: The express route circuit Azure resource ID, must be of type
         Microsoft.Network/expressRouteCircuits/circuitName.
        :paramtype express_route_circuit_id: str
        :keyword express_route_status: Express route connection state for the resource. Known values
         are: "Connecting", "Connected", and "Disconnected".
        :paramtype express_route_status: str or
         ~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionState
        """
        super().__init__(**kwargs)
        self.express_route_circuit_id = express_route_circuit_id
        self.express_route_status = express_route_status


class ExtendedLocation(_serialization.Model):
    """The extended location.

    :ivar type: The extended location type.
    :vartype type: str
    :ivar name: The extended location name.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword name: The extended location name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ExternalNetwork(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the ExternalNetwork item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the
     resource.
    :vartype network_to_network_interconnect_id: str
    :ivar disabled_on_resources: List of resources the externalNetwork is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: AdministrativeState of the externalNetwork. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar peering_option: Peering option list. Required. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of exportRoutePolicy.
    :vartype export_route_policy_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "network_to_network_interconnect_id": {"readonly": True},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "peering_option": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_to_network_interconnect_id": {"key": "properties.networkToNetworkInterconnectId", "type": "str"},
        "disabled_on_resources": {"key": "properties.disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "peering_option": {"key": "properties.peeringOption", "type": "str"},
        "option_b_properties": {"key": "properties.optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {
            "key": "properties.optionAProperties",
            "type": "ExternalNetworkPropertiesOptionAProperties",
        },
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_option: Union[str, "_models.PeeringOption"],
        annotation: Optional[str] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.ExternalNetworkPropertiesOptionAProperties"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword peering_option: Peering option list. Required. Known values are: "OptionA" and
         "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :paramtype export_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.network_to_network_interconnect_id = None
        self.disabled_on_resources = None
        self.administrative_state = None
        self.provisioning_state = None
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id


class ExternalNetworkPatch(_serialization.Model):
    """The ExternalNetwork patch resource definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties: ~azure.mgmt.managednetworkfabric.models.Layer3OptionAProperties
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of exportRoutePolicy.
    :vartype export_route_policy_id: str
    """

    _attribute_map = {
        "annotation": {"key": "properties.annotation", "type": "str"},
        "peering_option": {"key": "properties.peeringOption", "type": "str"},
        "option_b_properties": {"key": "properties.optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {"key": "properties.optionAProperties", "type": "Layer3OptionAProperties"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        peering_option: Optional[Union[str, "_models.PeeringOption"]] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.Layer3OptionAProperties"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties: ~azure.mgmt.managednetworkfabric.models.Layer3OptionAProperties
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :paramtype export_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id


class ExternalNetworkPatchableProperties(_serialization.Model):
    """The ExternalNetwork patchable properties.

    :ivar peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties: ~azure.mgmt.managednetworkfabric.models.Layer3OptionAProperties
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of exportRoutePolicy.
    :vartype export_route_policy_id: str
    """

    _attribute_map = {
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {"key": "optionAProperties", "type": "Layer3OptionAProperties"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_option: Optional[Union[str, "_models.PeeringOption"]] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.Layer3OptionAProperties"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties: ~azure.mgmt.managednetworkfabric.models.Layer3OptionAProperties
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :paramtype export_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id


class ExternalNetworkPatchProperties(AnnotationResource, ExternalNetworkPatchableProperties):
    """External Network Patch properties.

    :ivar peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties: ~azure.mgmt.managednetworkfabric.models.Layer3OptionAProperties
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of exportRoutePolicy.
    :vartype export_route_policy_id: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {"key": "optionAProperties", "type": "Layer3OptionAProperties"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_option: Optional[Union[str, "_models.PeeringOption"]] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.Layer3OptionAProperties"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties: ~azure.mgmt.managednetworkfabric.models.Layer3OptionAProperties
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :paramtype export_route_policy_id: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(
            annotation=annotation,
            peering_option=peering_option,
            option_b_properties=option_b_properties,
            option_a_properties=option_a_properties,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            **kwargs
        )
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.annotation = annotation


class ExternalNetworkProperties(AnnotationResource):
    """External Network Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the
     resource.
    :vartype network_to_network_interconnect_id: str
    :ivar disabled_on_resources: List of resources the externalNetwork is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: AdministrativeState of the externalNetwork. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar peering_option: Peering option list. Required. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of exportRoutePolicy.
    :vartype export_route_policy_id: str
    """

    _validation = {
        "network_to_network_interconnect_id": {"readonly": True},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "peering_option": {"required": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_to_network_interconnect_id": {"key": "networkToNetworkInterconnectId", "type": "str"},
        "disabled_on_resources": {"key": "disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {"key": "optionAProperties", "type": "ExternalNetworkPropertiesOptionAProperties"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_option: Union[str, "_models.PeeringOption"],
        annotation: Optional[str] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.ExternalNetworkPropertiesOptionAProperties"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword peering_option: Peering option list. Required. Known values are: "OptionA" and
         "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of exportRoutePolicy.
        :paramtype export_route_policy_id: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_to_network_interconnect_id = None
        self.disabled_on_resources = None
        self.administrative_state = None
        self.provisioning_state = None
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id


class Layer3IpPrefixProperties(_serialization.Model):
    """Layer 3 primary and secondary ip address prefixes.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
     172.31.0.0/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
     3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
     Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
     Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
     be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
     and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
     are to be configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv6_prefix: str
    """

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
         172.31.0.0/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
         3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
         Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
         Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
         be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
         and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
         are to be configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv6_prefix: str
        """
        super().__init__(**kwargs)
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix


class Layer3OptionAProperties(Layer3IpPrefixProperties):
    """Peering optionA properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
     172.31.0.0/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
     3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
     Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
     Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
     be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
     and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
     are to be configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv6_prefix: str
    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan identifier. Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: Fabric ASN number. Example 65001.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
        "vlan_id": {"maximum": 4095, "minimum": 501},
        "fabric_asn": {"readonly": True, "maximum": 65535, "minimum": 1},
        "peer_asn": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
         172.31.0.0/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
         3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
         Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
         Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
         be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
         and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
         are to be configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv6_prefix: str
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan identifier. Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.fabric_asn = None
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration


class ExternalNetworkPropertiesOptionAProperties(Layer3OptionAProperties):
    """option A properties object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
     172.31.0.0/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
     3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
     Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
     Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
     be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
     and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
     are to be configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv6_prefix: str
    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan identifier. Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: Fabric ASN number. Example 65001.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
        "vlan_id": {"maximum": 4095, "minimum": 501},
        "fabric_asn": {"readonly": True, "maximum": 65535, "minimum": 1},
        "peer_asn": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
         172.31.0.0/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
         3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
         Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
         Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
         be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
         and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
         are to be configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv6_prefix: str
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan identifier. Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            mtu=mtu,
            vlan_id=vlan_id,
            peer_asn=peer_asn,
            bfd_configuration=bfd_configuration,
            **kwargs
        )


class ExternalNetworksList(_serialization.Model):
    """List of ExternalNetworks.

    :ivar value: List of ExternalNetworks resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.ExternalNetwork]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExternalNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExternalNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of ExternalNetworks resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.ExternalNetwork]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FabricBfdConfiguration(_serialization.Model):
    """BFD Configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar interval: interval in seconds. Example: 300.
    :vartype interval: int
    :ivar multiplier: multiplier. Example: 3.
    :vartype multiplier: int
    """

    _validation = {
        "interval": {"readonly": True},
        "multiplier": {"readonly": True},
    }

    _attribute_map = {
        "interval": {"key": "interval", "type": "int"},
        "multiplier": {"key": "multiplier", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.interval = None
        self.multiplier = None


class GetDeviceStatusProperties(_serialization.Model):
    """Get Device status response properties.

    All required parameters must be populated in order to send to Azure.

    :ivar operational_status: Primary or Secondary power end. Required. Known values are: "Booted",
     "BootPrompt", and "Ztp".
    :vartype operational_status: str or ~azure.mgmt.managednetworkfabric.models.OperationalStatus
    :ivar power_cycle_state: On or Off power cycle state. Required. Known values are: "On" and
     "Off".
    :vartype power_cycle_state: str or ~azure.mgmt.managednetworkfabric.models.PowerCycleState
    :ivar serial_number: The serial number of the device. Required.
    :vartype serial_number: str
    """

    _validation = {
        "operational_status": {"required": True},
        "power_cycle_state": {"required": True},
        "serial_number": {"required": True},
    }

    _attribute_map = {
        "operational_status": {"key": "operationalStatus", "type": "str"},
        "power_cycle_state": {"key": "powerCycleState", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        operational_status: Union[str, "_models.OperationalStatus"],
        power_cycle_state: Union[str, "_models.PowerCycleState"],
        serial_number: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword operational_status: Primary or Secondary power end. Required. Known values are:
         "Booted", "BootPrompt", and "Ztp".
        :paramtype operational_status: str or ~azure.mgmt.managednetworkfabric.models.OperationalStatus
        :keyword power_cycle_state: On or Off power cycle state. Required. Known values are: "On" and
         "Off".
        :paramtype power_cycle_state: str or ~azure.mgmt.managednetworkfabric.models.PowerCycleState
        :keyword serial_number: The serial number of the device. Required.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.operational_status = operational_status
        self.power_cycle_state = power_cycle_state
        self.serial_number = serial_number


class InterfaceStatus(_serialization.Model):
    """Interface running status properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar administrative_state: The interface administrative state. Known values are: "Enabled" and
     "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar operational_status: The interface operational status.
    :vartype operational_status: str
    :ivar phy_status: The physical status.
    :vartype phy_status: str
    :ivar transceiver_status: The interface transceiver type. Example: up or down.
    :vartype transceiver_status: str
    :ivar connected_to: Connected to ARM resource or external interface.
    :vartype connected_to: str
    """

    _validation = {
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "operational_status": {"key": "operationalStatus", "type": "str"},
        "phy_status": {"key": "phyStatus", "type": "str"},
        "transceiver_status": {"key": "transceiverStatus", "type": "str"},
        "connected_to": {"key": "connectedTo", "type": "str"},
    }

    def __init__(
        self,
        *,
        operational_status: Optional[str] = None,
        phy_status: Optional[str] = None,
        transceiver_status: Optional[str] = None,
        connected_to: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operational_status: The interface operational status.
        :paramtype operational_status: str
        :keyword phy_status: The physical status.
        :paramtype phy_status: str
        :keyword transceiver_status: The interface transceiver type. Example: up or down.
        :paramtype transceiver_status: str
        :keyword connected_to: Connected to ARM resource or external interface.
        :paramtype connected_to: str
        """
        super().__init__(**kwargs)
        self.administrative_state = None
        self.operational_status = operational_status
        self.phy_status = phy_status
        self.transceiver_status = transceiver_status
        self.connected_to = connected_to


class GetDynamicInterfaceMapsPropertiesItem(InterfaceStatus):
    """Get Device static interface maps as per topology.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar administrative_state: The interface administrative state. Known values are: "Enabled" and
     "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar operational_status: The interface operational status.
    :vartype operational_status: str
    :ivar phy_status: The physical status.
    :vartype phy_status: str
    :ivar transceiver_status: The interface transceiver type. Example: up or down.
    :vartype transceiver_status: str
    :ivar connected_to: Connected to ARM resource or external interface.
    :vartype connected_to: str
    :ivar name: The interface name.
    :vartype name: str
    """

    _validation = {
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "operational_status": {"key": "operationalStatus", "type": "str"},
        "phy_status": {"key": "phyStatus", "type": "str"},
        "transceiver_status": {"key": "transceiverStatus", "type": "str"},
        "connected_to": {"key": "connectedTo", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        operational_status: Optional[str] = None,
        phy_status: Optional[str] = None,
        transceiver_status: Optional[str] = None,
        connected_to: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operational_status: The interface operational status.
        :paramtype operational_status: str
        :keyword phy_status: The physical status.
        :paramtype phy_status: str
        :keyword transceiver_status: The interface transceiver type. Example: up or down.
        :paramtype transceiver_status: str
        :keyword connected_to: Connected to ARM resource or external interface.
        :paramtype connected_to: str
        :keyword name: The interface name.
        :paramtype name: str
        """
        super().__init__(
            operational_status=operational_status,
            phy_status=phy_status,
            transceiver_status=transceiver_status,
            connected_to=connected_to,
            **kwargs
        )
        self.name = name


class GetStaticInterfaceMapsPropertiesItem(_serialization.Model):
    """Get Device static interface maps as per topology.

    :ivar name: The interface name.
    :vartype name: str
    :ivar description: The interface description.
    :vartype description: str
    :ivar identifier: The interface identifier.
    :vartype identifier: str
    :ivar interface_type: The interface type. Example: Ethernet.
    :vartype interface_type: str
    :ivar connector_type: The physical cable connector type. Example: Optical.
    :vartype connector_type: str
    :ivar connected_to: Connected to ARM resource or external interface.
    :vartype connected_to: str
    :ivar speed: The interface speed. Example: 100.
    :vartype speed: float
    :ivar channel_group_id: The port channel group id.
    :vartype channel_group_id: float
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "identifier": {"key": "identifier", "type": "str"},
        "interface_type": {"key": "interfaceType", "type": "str"},
        "connector_type": {"key": "connectorType", "type": "str"},
        "connected_to": {"key": "connectedTo", "type": "str"},
        "speed": {"key": "speed", "type": "float"},
        "channel_group_id": {"key": "channelGroupId", "type": "float"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        identifier: Optional[str] = None,
        interface_type: Optional[str] = None,
        connector_type: Optional[str] = None,
        connected_to: Optional[str] = None,
        speed: Optional[float] = None,
        channel_group_id: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The interface name.
        :paramtype name: str
        :keyword description: The interface description.
        :paramtype description: str
        :keyword identifier: The interface identifier.
        :paramtype identifier: str
        :keyword interface_type: The interface type. Example: Ethernet.
        :paramtype interface_type: str
        :keyword connector_type: The physical cable connector type. Example: Optical.
        :paramtype connector_type: str
        :keyword connected_to: Connected to ARM resource or external interface.
        :paramtype connected_to: str
        :keyword speed: The interface speed. Example: 100.
        :paramtype speed: float
        :keyword channel_group_id: The port channel group id.
        :paramtype channel_group_id: float
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.identifier = identifier
        self.interface_type = interface_type
        self.connector_type = connector_type
        self.connected_to = connected_to
        self.speed = speed
        self.channel_group_id = channel_group_id


class InfrastructureServices(_serialization.Model):
    """InfrastructureServices IP ranges.

    :ivar ipv4_address_spaces: The IPv4 Address space is optional, if the value is not defined at
     the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address
     subnet is an optional attribute.
    :vartype ipv4_address_spaces: list[str]
    :ivar ipv6_address_spaces: The IPv6 is not supported right now.
    :vartype ipv6_address_spaces: list[str]
    """

    _attribute_map = {
        "ipv4_address_spaces": {"key": "ipv4AddressSpaces", "type": "[str]"},
        "ipv6_address_spaces": {"key": "ipv6AddressSpaces", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ipv4_address_spaces: Optional[List[str]] = None,
        ipv6_address_spaces: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipv4_address_spaces: The IPv4 Address space is optional, if the value is not defined
         at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address
         subnet is an optional attribute.
        :paramtype ipv4_address_spaces: list[str]
        :keyword ipv6_address_spaces: The IPv6 is not supported right now.
        :paramtype ipv6_address_spaces: list[str]
        """
        super().__init__(**kwargs)
        self.ipv4_address_spaces = ipv4_address_spaces
        self.ipv6_address_spaces = ipv6_address_spaces


class InternalNetwork(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the InternalNetwork item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List with object connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List with object connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype export_route_policy_id: str
    :ivar disabled_on_resources: List of resources the InternalNetwork is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: Administrative state of the InternalNetwork. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar bgp_disabled_on_resources: List of resources the BGP is disabled on. Can be either entire
     NetworkFabric or NetworkRack.
    :vartype bgp_disabled_on_resources: list[str]
    :ivar bfd_disabled_on_resources: List of resources the BFD for BGP is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype bfd_disabled_on_resources: list[str]
    :ivar bfd_for_static_routes_disabled_on_resources: List of resources the BFD of StaticRoutes is
     disabled on. Can be either entire NetworkFabric or NetworkRack.
    :vartype bfd_for_static_routes_disabled_on_resources: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar vlan_id: Vlan identifier. Example: 1001. Required.
    :vartype vlan_id: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "mtu": {"maximum": 9000, "minimum": 1500},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "bgp_disabled_on_resources": {"readonly": True},
        "bfd_disabled_on_resources": {"readonly": True},
        "bfd_for_static_routes_disabled_on_resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "vlan_id": {"required": True, "maximum": 4095, "minimum": 100},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "mtu": {"key": "properties.mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "properties.connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "properties.connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "static_route_configuration": {
            "key": "properties.staticRouteConfiguration",
            "type": "StaticRouteConfiguration",
        },
        "bgp_configuration": {"key": "properties.bgpConfiguration", "type": "BgpConfiguration"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
        "disabled_on_resources": {"key": "properties.disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
        "bgp_disabled_on_resources": {"key": "properties.bgpDisabledOnResources", "type": "[str]"},
        "bfd_disabled_on_resources": {"key": "properties.bfdDisabledOnResources", "type": "[str]"},
        "bfd_for_static_routes_disabled_on_resources": {
            "key": "properties.bfdForStaticRoutesDisabledOnResources",
            "type": "[str]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
    }

    def __init__(
        self,
        *,
        vlan_id: int,
        annotation: Optional[str] = None,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List with object connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List with object connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype export_route_policy_id: str
        :keyword vlan_id: Vlan identifier. Example: 1001. Required.
        :paramtype vlan_id: int
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.static_route_configuration = static_route_configuration
        self.bgp_configuration = bgp_configuration
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.disabled_on_resources = None
        self.administrative_state = None
        self.bgp_disabled_on_resources = None
        self.bfd_disabled_on_resources = None
        self.bfd_for_static_routes_disabled_on_resources = None
        self.provisioning_state = None
        self.vlan_id = vlan_id


class InternalNetworkPatch(_serialization.Model):
    """The InternalNetwork patch resource definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List with object connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List with object connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype export_route_policy_id: str
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
    }

    _attribute_map = {
        "annotation": {"key": "properties.annotation", "type": "str"},
        "mtu": {"key": "properties.mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "properties.connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "properties.connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "static_route_configuration": {
            "key": "properties.staticRouteConfiguration",
            "type": "StaticRouteConfiguration",
        },
        "bgp_configuration": {"key": "properties.bgpConfiguration", "type": "BgpConfiguration"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List with object connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List with object connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype export_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.static_route_configuration = static_route_configuration
        self.bgp_configuration = bgp_configuration
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id


class InternalNetworkPatchableProperties(_serialization.Model):
    """The ExternalNetwork patchable properties.

    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List with object connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List with object connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype export_route_policy_id: str
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "static_route_configuration": {"key": "staticRouteConfiguration", "type": "StaticRouteConfiguration"},
        "bgp_configuration": {"key": "bgpConfiguration", "type": "BgpConfiguration"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List with object connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List with object connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype export_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.static_route_configuration = static_route_configuration
        self.bgp_configuration = bgp_configuration
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id


class InternalNetworkPatchProperties(AnnotationResource, InternalNetworkPatchableProperties):
    """InternalNetwork Patch properties.

    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List with object connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List with object connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype export_route_policy_id: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "static_route_configuration": {"key": "staticRouteConfiguration", "type": "StaticRouteConfiguration"},
        "bgp_configuration": {"key": "bgpConfiguration", "type": "BgpConfiguration"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List with object connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List with object connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype export_route_policy_id: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(
            annotation=annotation,
            mtu=mtu,
            connected_i_pv4_subnets=connected_i_pv4_subnets,
            connected_i_pv6_subnets=connected_i_pv6_subnets,
            static_route_configuration=static_route_configuration,
            bgp_configuration=bgp_configuration,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            **kwargs
        )
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.static_route_configuration = static_route_configuration
        self.bgp_configuration = bgp_configuration
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.annotation = annotation


class InternalNetworkProperties(
    AnnotationResource, InternalNetworkPatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """Internal Network Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List with object connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List with object connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar import_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM resource ID of importRoutePolicy.
    :vartype export_route_policy_id: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar disabled_on_resources: List of resources the InternalNetwork is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: Administrative state of the InternalNetwork. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar bgp_disabled_on_resources: List of resources the BGP is disabled on. Can be either entire
     NetworkFabric or NetworkRack.
    :vartype bgp_disabled_on_resources: list[str]
    :ivar bfd_disabled_on_resources: List of resources the BFD for BGP is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype bfd_disabled_on_resources: list[str]
    :ivar bfd_for_static_routes_disabled_on_resources: List of resources the BFD of StaticRoutes is
     disabled on. Can be either entire NetworkFabric or NetworkRack.
    :vartype bfd_for_static_routes_disabled_on_resources: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar vlan_id: Vlan identifier. Example: 1001. Required.
    :vartype vlan_id: int
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "bgp_disabled_on_resources": {"readonly": True},
        "bfd_disabled_on_resources": {"readonly": True},
        "bfd_for_static_routes_disabled_on_resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "vlan_id": {"required": True, "maximum": 4095, "minimum": 100},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "static_route_configuration": {"key": "staticRouteConfiguration", "type": "StaticRouteConfiguration"},
        "bgp_configuration": {"key": "bgpConfiguration", "type": "BgpConfiguration"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
        "disabled_on_resources": {"key": "disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "bgp_disabled_on_resources": {"key": "bgpDisabledOnResources", "type": "[str]"},
        "bfd_disabled_on_resources": {"key": "bfdDisabledOnResources", "type": "[str]"},
        "bfd_for_static_routes_disabled_on_resources": {
            "key": "bfdForStaticRoutesDisabledOnResources",
            "type": "[str]",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "vlan_id": {"key": "vlanId", "type": "int"},
    }

    def __init__(
        self,
        *,
        vlan_id: int,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List with object connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List with object connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword import_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM resource ID of importRoutePolicy.
        :paramtype export_route_policy_id: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword vlan_id: Vlan identifier. Example: 1001. Required.
        :paramtype vlan_id: int
        """
        super().__init__(
            annotation=annotation,
            mtu=mtu,
            connected_i_pv4_subnets=connected_i_pv4_subnets,
            connected_i_pv6_subnets=connected_i_pv6_subnets,
            static_route_configuration=static_route_configuration,
            bgp_configuration=bgp_configuration,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            **kwargs
        )
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.static_route_configuration = static_route_configuration
        self.bgp_configuration = bgp_configuration
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.disabled_on_resources = None
        self.administrative_state = None
        self.bgp_disabled_on_resources = None
        self.bfd_disabled_on_resources = None
        self.bfd_for_static_routes_disabled_on_resources = None
        self.provisioning_state = None
        self.vlan_id = vlan_id
        self.annotation = annotation


class InternalNetworksList(_serialization.Model):
    """List of InternalNetworks.

    :ivar value: List of InternalNetworks resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.InternalNetwork]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InternalNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.InternalNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of InternalNetworks resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.InternalNetwork]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpCommunitiesListResult(_serialization.Model):
    """List of IPCommunities.

    :ivar value: List of IpCommunity resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.IpCommunity]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.IpCommunity"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of IpCommunity resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.IpCommunity]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpCommunity(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The IpCommunity resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Known values
     are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar well_known_communities: Supported well known Community List.
    :vartype well_known_communities: list[str or
     ~azure.mgmt.managednetworkfabric.models.WellKnownCommunities]
    :ivar community_members: List the communityMembers of IP Community .
    :vartype community_members: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "well_known_communities": {"unique": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "action": {"key": "properties.action", "type": "str"},
        "well_known_communities": {"key": "properties.wellKnownCommunities", "type": "[str]"},
        "community_members": {"key": "properties.communityMembers", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        action: Optional[Union[str, "_models.CommunityActionTypes"]] = None,
        well_known_communities: Optional[List[Union[str, "_models.WellKnownCommunities"]]] = None,
        community_members: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Known values
         are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword well_known_communities: Supported well known Community List.
        :paramtype well_known_communities: list[str or
         ~azure.mgmt.managednetworkfabric.models.WellKnownCommunities]
        :keyword community_members: List the communityMembers of IP Community .
        :paramtype community_members: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.action = action
        self.well_known_communities = well_known_communities
        self.community_members = community_members
        self.provisioning_state = None


class IpCommunityIdList(_serialization.Model):
    """IP Community ID list properties.

    :ivar ip_community_ids: List of IP Community resource IDs.
    :vartype ip_community_ids: list[str]
    """

    _attribute_map = {
        "ip_community_ids": {"key": "ipCommunityIds", "type": "[str]"},
    }

    def __init__(self, *, ip_community_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_community_ids: List of IP Community resource IDs.
        :paramtype ip_community_ids: list[str]
        """
        super().__init__(**kwargs)
        self.ip_community_ids = ip_community_ids


class IpCommunityPatch(_serialization.Model):
    """The IPCommunity patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class IpCommunityProperties(AnnotationResource):
    """IpCommunityProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Required. Known
     values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar well_known_communities: Supported well known Community List.
    :vartype well_known_communities: list[str or
     ~azure.mgmt.managednetworkfabric.models.WellKnownCommunities]
    :ivar community_members: List the communityMembers of IP Community . Required.
    :vartype community_members: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "action": {"required": True},
        "well_known_communities": {"unique": True},
        "community_members": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "well_known_communities": {"key": "wellKnownCommunities", "type": "[str]"},
        "community_members": {"key": "communityMembers", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.CommunityActionTypes"],
        community_members: List[str],
        annotation: Optional[str] = None,
        well_known_communities: Optional[List[Union[str, "_models.WellKnownCommunities"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Required.
         Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword well_known_communities: Supported well known Community List.
        :paramtype well_known_communities: list[str or
         ~azure.mgmt.managednetworkfabric.models.WellKnownCommunities]
        :keyword community_members: List the communityMembers of IP Community . Required.
        :paramtype community_members: list[str]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.action = action
        self.well_known_communities = well_known_communities
        self.community_members = community_members
        self.provisioning_state = None


class IpExtendedCommunity(TrackedResource):
    """The IpExtendedCommunity resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Known values
     are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar route_targets: Route Target List.The expected formats are ASN(plain):NN >> example
     4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example
     10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in
     range of 0-4294967295.
    :vartype route_targets: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "action": {"key": "properties.action", "type": "str"},
        "route_targets": {"key": "properties.routeTargets", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        action: Optional[Union[str, "_models.CommunityActionTypes"]] = None,
        route_targets: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Known values
         are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword route_targets: Route Target List.The expected formats are ASN(plain):NN >> example
         4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example
         10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in
         range of 0-4294967295.
        :paramtype route_targets: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.action = action
        self.route_targets = route_targets
        self.provisioning_state = None


class IpExtendedCommunityIdList(_serialization.Model):
    """IP Extended Community Id list properties.

    :ivar ip_extended_community_ids: List of IP Extended Community resource IDs.
    :vartype ip_extended_community_ids: list[str]
    """

    _attribute_map = {
        "ip_extended_community_ids": {"key": "ipExtendedCommunityIds", "type": "[str]"},
    }

    def __init__(self, *, ip_extended_community_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_extended_community_ids: List of IP Extended Community resource IDs.
        :paramtype ip_extended_community_ids: list[str]
        """
        super().__init__(**kwargs)
        self.ip_extended_community_ids = ip_extended_community_ids


class IpExtendedCommunityListResult(_serialization.Model):
    """List of IpExtendedCommunities.

    :ivar value: List of IpExtendedCommunities resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunity]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpExtendedCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.IpExtendedCommunity"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of IpExtendedCommunities resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunity]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpExtendedCommunityPatch(_serialization.Model):
    """The IpExtendedCommunities patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class IpExtendedCommunityProperties(AnnotationResource):
    """IpExtendedCommunityProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Required. Known
     values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar route_targets: Route Target List.The expected formats are ASN(plain):NN >> example
     4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example
     10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in
     range of 0-4294967295. Required.
    :vartype route_targets: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "action": {"required": True},
        "route_targets": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "route_targets": {"key": "routeTargets", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.CommunityActionTypes"],
        route_targets: List[str],
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Required.
         Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword route_targets: Route Target List.The expected formats are ASN(plain):NN >> example
         4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example
         10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in
         range of 0-4294967295. Required.
        :paramtype route_targets: list[str]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.action = action
        self.route_targets = route_targets
        self.provisioning_state = None


class IpPrefix(TrackedResource):
    """The IPPrefix resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_prefix_rules: IpPrefix contains the list of IP PrefixRules objects. Required.
    :vartype ip_prefix_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpPrefixPropertiesIpPrefixRulesItem]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "ip_prefix_rules": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "ip_prefix_rules": {"key": "properties.ipPrefixRules", "type": "[IpPrefixPropertiesIpPrefixRulesItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        ip_prefix_rules: List["_models.IpPrefixPropertiesIpPrefixRulesItem"],
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_prefix_rules: IpPrefix contains the list of IP PrefixRules objects. Required.
        :paramtype ip_prefix_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpPrefixPropertiesIpPrefixRulesItem]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.ip_prefix_rules = ip_prefix_rules
        self.provisioning_state = None


class IpPrefixesListResult(_serialization.Model):
    """List of IpPrefixes.

    :ivar value: List of IPPrefix resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.IpPrefix]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.IpPrefix"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of IPPrefix resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.IpPrefix]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpPrefixPatch(_serialization.Model):
    """The IPPrefix patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class IpPrefixProperties(AnnotationResource):
    """IpPrefixProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_prefix_rules: IpPrefix contains the list of IP PrefixRules objects. Required.
    :vartype ip_prefix_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpPrefixPropertiesIpPrefixRulesItem]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "ip_prefix_rules": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "ip_prefix_rules": {"key": "ipPrefixRules", "type": "[IpPrefixPropertiesIpPrefixRulesItem]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_prefix_rules: List["_models.IpPrefixPropertiesIpPrefixRulesItem"],
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_prefix_rules: IpPrefix contains the list of IP PrefixRules objects. Required.
        :paramtype ip_prefix_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpPrefixPropertiesIpPrefixRulesItem]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.ip_prefix_rules = ip_prefix_rules
        self.provisioning_state = None


class IpPrefixPropertiesIpPrefixRulesItem(_serialization.Model):
    """IpPrefixPropertiesIpPrefixRulesItem.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Required. Known
     values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
     evaluated starting with the lowest sequence number and continue down the list until a match is
     made. Once a match is made, the permit or deny statement is applied to that network and the
     rest of the list is ignored. Required.
    :vartype sequence_number: int
    :ivar network_prefix: Network Prefix specifying IPv4/IPv6 packets to be permitted or denied.
     Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126. Required.
    :vartype network_prefix: str
    :ivar condition: Specify prefix-list bounds. Known values are: "EqualTo",
     "GreaterThanOrEqualTo", and "LesserThanOrEqualTo".
    :vartype condition: str or ~azure.mgmt.managednetworkfabric.models.Condition
    :ivar subnet_mask_length: SubnetMaskLength gives the minimum NetworkPrefix length to be
     matched.Possible values for IPv4 are 1 - 32. Possible values of IPv6 are 1 - 128.
    :vartype subnet_mask_length: int
    """

    _validation = {
        "action": {"required": True},
        "sequence_number": {"required": True, "maximum": 4294967295, "minimum": 1},
        "network_prefix": {"required": True},
        "subnet_mask_length": {"maximum": 128, "minimum": 1},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "network_prefix": {"key": "networkPrefix", "type": "str"},
        "condition": {"key": "condition", "type": "str"},
        "subnet_mask_length": {"key": "subnetMaskLength", "type": "int"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.CommunityActionTypes"],
        sequence_number: int,
        network_prefix: str,
        condition: Optional[Union[str, "_models.Condition"]] = None,
        subnet_mask_length: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Required.
         Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
         evaluated starting with the lowest sequence number and continue down the list until a match is
         made. Once a match is made, the permit or deny statement is applied to that network and the
         rest of the list is ignored. Required.
        :paramtype sequence_number: int
        :keyword network_prefix: Network Prefix specifying IPv4/IPv6 packets to be permitted or denied.
         Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126. Required.
        :paramtype network_prefix: str
        :keyword condition: Specify prefix-list bounds. Known values are: "EqualTo",
         "GreaterThanOrEqualTo", and "LesserThanOrEqualTo".
        :paramtype condition: str or ~azure.mgmt.managednetworkfabric.models.Condition
        :keyword subnet_mask_length: SubnetMaskLength gives the minimum NetworkPrefix length to be
         matched.Possible values for IPv4 are 1 - 32. Possible values of IPv6 are 1 - 128.
        :paramtype subnet_mask_length: int
        """
        super().__init__(**kwargs)
        self.action = action
        self.sequence_number = sequence_number
        self.network_prefix = network_prefix
        self.condition = condition
        self.subnet_mask_length = subnet_mask_length


class L2IsolationDomain(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The L2IsolationDomain resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: Network Fabric ARM resource id.
    :vartype network_fabric_id: str
    :ivar vlan_id: vlanId. Example: 501.
    :vartype vlan_id: int
    :ivar mtu: maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar disabled_on_resources: List of resources the L2 Isolation Domain is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: state. Example: Enabled | Disabled. It indicates administrative
     state of the isolationDomain, whether it is enabled or disabled. If enabled, the configuration
     is applied on the devices. If disabled, the configuration is removed from the devices. Known
     values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "mtu": {"key": "properties.mtu", "type": "int"},
        "disabled_on_resources": {"key": "properties.disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        network_fabric_id: Optional[str] = None,
        vlan_id: Optional[int] = None,
        mtu: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: Network Fabric ARM resource id.
        :paramtype network_fabric_id: str
        :keyword vlan_id: vlanId. Example: 501.
        :paramtype vlan_id: int
        :keyword mtu: maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.network_fabric_id = network_fabric_id
        self.vlan_id = vlan_id
        self.mtu = mtu
        self.disabled_on_resources = None
        self.administrative_state = None
        self.provisioning_state = None


class L2IsolationDomainPatch(_serialization.Model):
    """The L2IsolationDomain patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "mtu": {"key": "properties.mtu", "type": "int"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        mtu: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.annotation = annotation
        self.mtu = mtu


class L2IsolationDomainPatchProperties(AnnotationResource):
    """L2IsolationDomainPatchProperties define the patchable resource properties.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
    }

    def __init__(self, *, annotation: Optional[str] = None, mtu: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(annotation=annotation, **kwargs)
        self.mtu = mtu


class L2IsolationDomainProperties(AnnotationResource):
    """L2IsolationDomainProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: Network Fabric ARM resource id. Required.
    :vartype network_fabric_id: str
    :ivar vlan_id: vlanId. Example: 501. Required.
    :vartype vlan_id: int
    :ivar mtu: maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar disabled_on_resources: List of resources the L2 Isolation Domain is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: state. Example: Enabled | Disabled. It indicates administrative
     state of the isolationDomain, whether it is enabled or disabled. If enabled, the configuration
     is applied on the devices. If disabled, the configuration is removed from the devices. Known
     values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "network_fabric_id": {"required": True},
        "vlan_id": {"required": True},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "mtu": {"key": "mtu", "type": "int"},
        "disabled_on_resources": {"key": "disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_id: str,
        vlan_id: int,
        annotation: Optional[str] = None,
        mtu: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: Network Fabric ARM resource id. Required.
        :paramtype network_fabric_id: str
        :keyword vlan_id: vlanId. Example: 501. Required.
        :paramtype vlan_id: int
        :keyword mtu: maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_fabric_id = network_fabric_id
        self.vlan_id = vlan_id
        self.mtu = mtu
        self.disabled_on_resources = None
        self.administrative_state = None
        self.provisioning_state = None


class L2IsolationDomainsListResult(_serialization.Model):
    """List of L2IsolationDomains.

    :ivar value: Displays list of L2IsolationDomain resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.L2IsolationDomain]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[L2IsolationDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.L2IsolationDomain"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Displays list of L2IsolationDomain resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.L2IsolationDomain]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class L3IsolationDomain(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The L3IsolationDomain resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar description: L3 Isolation Domain description.
    :vartype description: str
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
    :ivar network_fabric_id: Network Fabric ARM resource id.
    :vartype network_fabric_id: str
    :ivar disabled_on_resources: List of resources the L3 Isolation Domain is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: Administrative state of the IsolationDomain. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar option_b_disabled_on_resources: List of resources the OptionB is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype option_b_disabled_on_resources: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "option_b_disabled_on_resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "redistribute_connected_subnets": {"key": "properties.redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "properties.redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {
            "key": "properties.aggregateRouteConfiguration",
            "type": "AggregateRouteConfiguration",
        },
        "description": {"key": "properties.description", "type": "str"},
        "connected_subnet_route_policy": {
            "key": "properties.connectedSubnetRoutePolicy",
            "type": "L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy",
        },
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "disabled_on_resources": {"key": "properties.disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
        "option_b_disabled_on_resources": {"key": "properties.optionBDisabledOnResources", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        description: Optional[str] = None,
        connected_subnet_route_policy: Optional[
            "_models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy"
        ] = None,
        network_fabric_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword description: L3 Isolation Domain description.
        :paramtype description: str
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
        :keyword network_fabric_id: Network Fabric ARM resource id.
        :paramtype network_fabric_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.description = description
        self.connected_subnet_route_policy = connected_subnet_route_policy
        self.network_fabric_id = network_fabric_id
        self.disabled_on_resources = None
        self.administrative_state = None
        self.option_b_disabled_on_resources = None
        self.provisioning_state = None


class L3IsolationDomainPatch(_serialization.Model):
    """The L3IsolationDomain patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar description: L3 Isolation Domain description.
    :vartype description: str
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "redistribute_connected_subnets": {"key": "properties.redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "properties.redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {
            "key": "properties.aggregateRouteConfiguration",
            "type": "AggregateRouteConfiguration",
        },
        "description": {"key": "properties.description", "type": "str"},
        "connected_subnet_route_policy": {
            "key": "properties.connectedSubnetRoutePolicy",
            "type": "L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        description: Optional[str] = None,
        connected_subnet_route_policy: Optional[
            "_models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword description: L3 Isolation Domain description.
        :paramtype description: str
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.description = description
        self.connected_subnet_route_policy = connected_subnet_route_policy


class L3IsolationDomainPatchProperties(_serialization.Model):
    """L3IsolationDomainPatchProperties define the patch resource properties.

    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar description: L3 Isolation Domain description.
    :vartype description: str
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
    """

    _attribute_map = {
        "redistribute_connected_subnets": {"key": "redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {"key": "aggregateRouteConfiguration", "type": "AggregateRouteConfiguration"},
        "description": {"key": "description", "type": "str"},
        "connected_subnet_route_policy": {
            "key": "connectedSubnetRoutePolicy",
            "type": "L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy",
        },
    }

    def __init__(
        self,
        *,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        description: Optional[str] = None,
        connected_subnet_route_policy: Optional[
            "_models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword description: L3 Isolation Domain description.
        :paramtype description: str
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
        """
        super().__init__(**kwargs)
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.description = description
        self.connected_subnet_route_policy = connected_subnet_route_policy


class L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy(_serialization.Model):
    """Connected Subnet RoutePolicy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar export_route_policy_id: exportRoutePolicyId value.
    :vartype export_route_policy_id: str
    :ivar administrative_state: Enabled/Disabled connected subnet route policy. Ex: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    """

    _validation = {
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(self, *, export_route_policy_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword export_route_policy_id: exportRoutePolicyId value.
        :paramtype export_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.export_route_policy_id = export_route_policy_id
        self.administrative_state = None


class L3IsolationDomainProperties(
    AnnotationResource, L3IsolationDomainPatchProperties
):  # pylint: disable=too-many-instance-attributes
    """L3IsolationDomainProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar description: L3 Isolation Domain description.
    :vartype description: str
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: Network Fabric ARM resource id. Required.
    :vartype network_fabric_id: str
    :ivar disabled_on_resources: List of resources the L3 Isolation Domain is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype disabled_on_resources: list[str]
    :ivar administrative_state: Administrative state of the IsolationDomain. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar option_b_disabled_on_resources: List of resources the OptionB is disabled on. Can be
     either entire NetworkFabric or NetworkRack.
    :vartype option_b_disabled_on_resources: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "network_fabric_id": {"required": True},
        "disabled_on_resources": {"readonly": True},
        "administrative_state": {"readonly": True},
        "option_b_disabled_on_resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "redistribute_connected_subnets": {"key": "redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {"key": "aggregateRouteConfiguration", "type": "AggregateRouteConfiguration"},
        "description": {"key": "description", "type": "str"},
        "connected_subnet_route_policy": {
            "key": "connectedSubnetRoutePolicy",
            "type": "L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy",
        },
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "disabled_on_resources": {"key": "disabledOnResources", "type": "[str]"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "option_b_disabled_on_resources": {"key": "optionBDisabledOnResources", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_id: str,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        description: Optional[str] = None,
        connected_subnet_route_policy: Optional[
            "_models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy"
        ] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: List of Ipv4 and Ipv6 route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword description: L3 Isolation Domain description.
        :paramtype description: str
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicy
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: Network Fabric ARM resource id. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(
            annotation=annotation,
            redistribute_connected_subnets=redistribute_connected_subnets,
            redistribute_static_routes=redistribute_static_routes,
            aggregate_route_configuration=aggregate_route_configuration,
            description=description,
            connected_subnet_route_policy=connected_subnet_route_policy,
            **kwargs
        )
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.description = description
        self.connected_subnet_route_policy = connected_subnet_route_policy
        self.network_fabric_id = network_fabric_id
        self.disabled_on_resources = None
        self.administrative_state = None
        self.option_b_disabled_on_resources = None
        self.provisioning_state = None
        self.annotation = annotation


class L3IsolationDomainsListResult(_serialization.Model):
    """List of L3IsolationDomains.

    :ivar value: List of L3IsolationDomain resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.L3IsolationDomain]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[L3IsolationDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.L3IsolationDomain"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of L3IsolationDomain resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.L3IsolationDomain]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Layer2Configuration(_serialization.Model):
    """layer2Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar port_count: Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
    :vartype port_count: int
    :ivar mtu: MTU of the packets between PE & CE.
    :vartype mtu: int
    :ivar interfaces: List of network device interfaces resource IDs.
    :vartype interfaces: list[str]
    """

    _validation = {
        "mtu": {"required": True, "maximum": 9000, "minimum": 1500},
        "interfaces": {"readonly": True},
    }

    _attribute_map = {
        "port_count": {"key": "portCount", "type": "int"},
        "mtu": {"key": "mtu", "type": "int"},
        "interfaces": {"key": "interfaces", "type": "[str]"},
    }

    def __init__(self, *, mtu: int = 1500, port_count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword port_count: Number of ports connected between PE/CE. Maximum value depends on
         FabricSKU.
        :paramtype port_count: int
        :keyword mtu: MTU of the packets between PE & CE.
        :paramtype mtu: int
        """
        super().__init__(**kwargs)
        self.port_count = port_count
        self.mtu = mtu
        self.interfaces = None


class Layer3Configuration(Layer3IpPrefixProperties):
    """layer3Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
     172.31.0.0/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
     3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
     Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
     Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
     be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
     and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
     are to be configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv6_prefix: str
    :ivar import_route_policy_id: importRoutePolicyId.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: exportRoutePolicyId.
    :vartype export_route_policy_id: str
    :ivar peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28.
    :vartype peer_asn: int
    :ivar vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    """

    _validation = {
        "peer_asn": {"maximum": 65535, "minimum": 1},
        "vlan_id": {"maximum": 4095, "minimum": 501},
        "fabric_asn": {"readonly": True, "maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        peer_asn: Optional[int] = None,
        vlan_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
         172.31.0.0/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
         3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
         Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
         Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
         be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
         and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
         are to be configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv6_prefix: str
        :keyword import_route_policy_id: importRoutePolicyId.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: exportRoutePolicyId.
        :paramtype export_route_policy_id: str
        :keyword peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28.
        :paramtype peer_asn: int
        :keyword vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501.
        :paramtype vlan_id: int
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.peer_asn = peer_asn
        self.vlan_id = vlan_id
        self.fabric_asn = None


class ManagedResourceGroupConfiguration(_serialization.Model):
    """Managed Resource Group configuration properties.

    :ivar name: The NFC service will be hosted in a Managed resource group.
    :vartype name: str
    :ivar location: Managed resource group location.
    :vartype location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The NFC service will be hosted in a Managed resource group.
        :paramtype name: str
        :keyword location: Managed resource group location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location


class ManagementNetworkConfiguration(_serialization.Model):
    """Configuration to be used to setup the management network.

    All required parameters must be populated in order to send to Azure.

    :ivar infrastructure_vpn_configuration: Configuration for infrastructure vpn. Required.
    :vartype infrastructure_vpn_configuration:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
    :ivar workload_vpn_configuration: Configuration for workload vpn. Required.
    :vartype workload_vpn_configuration:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
    """

    _validation = {
        "infrastructure_vpn_configuration": {"required": True},
        "workload_vpn_configuration": {"required": True},
    }

    _attribute_map = {
        "infrastructure_vpn_configuration": {
            "key": "infrastructureVpnConfiguration",
            "type": "VpnConfigurationProperties",
        },
        "workload_vpn_configuration": {"key": "workloadVpnConfiguration", "type": "VpnConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        infrastructure_vpn_configuration: "_models.VpnConfigurationProperties",
        workload_vpn_configuration: "_models.VpnConfigurationProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_vpn_configuration: Configuration for infrastructure vpn. Required.
        :paramtype infrastructure_vpn_configuration:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
        :keyword workload_vpn_configuration: Configuration for workload vpn. Required.
        :paramtype workload_vpn_configuration:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
        """
        super().__init__(**kwargs)
        self.infrastructure_vpn_configuration = infrastructure_vpn_configuration
        self.workload_vpn_configuration = workload_vpn_configuration


class NeighborAddress(_serialization.Model):
    """Neighbor Address properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar address: IP Address.
    :vartype address: str
    :ivar operational_state: OperationalState of the NeighborAddress.
    :vartype operational_state: str
    """

    _validation = {
        "operational_state": {"readonly": True},
    }

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "operational_state": {"key": "operationalState", "type": "str"},
    }

    def __init__(self, *, address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address: IP Address.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.operational_state = None


class NetworkDevice(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkDevice resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar host_name: The host Name of the device.
    :vartype host_name: str
    :ivar serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
     Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
    :vartype serial_number: str
    :ivar version: Current version of the device as defined in SKU.
    :vartype version: str
    :ivar network_device_sku: Network Device SKU name.
    :vartype network_device_sku: str
    :ivar network_device_role: networkDeviceRole is the device role: Example: CE | ToR. Known
     values are: "CE", "ToR", "NPB", "TS", and "Management".
    :vartype network_device_role: str or
     ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleTypes
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar network_rack_id: Reference to network rack resource id.
    :vartype network_rack_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "version": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "network_rack_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "network_device_sku": {"key": "properties.networkDeviceSku", "type": "str"},
        "network_device_role": {"key": "properties.networkDeviceRole", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_rack_id": {"key": "properties.networkRackId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        network_device_sku: Optional[str] = None,
        network_device_role: Optional[Union[str, "_models.NetworkDeviceRoleTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword host_name: The host Name of the device.
        :paramtype host_name: str
        :keyword serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
         Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
        :paramtype serial_number: str
        :keyword network_device_sku: Network Device SKU name.
        :paramtype network_device_sku: str
        :keyword network_device_role: networkDeviceRole is the device role: Example: CE | ToR. Known
         values are: "CE", "ToR", "NPB", "TS", and "Management".
        :paramtype network_device_role: str or
         ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleTypes
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.host_name = host_name
        self.serial_number = serial_number
        self.version = None
        self.network_device_sku = network_device_sku
        self.network_device_role = network_device_role
        self.provisioning_state = None
        self.network_rack_id = None


class NetworkDevicePatchableProperties(_serialization.Model):
    """Network Device updatable properties.

    :ivar host_name: The host Name of the device.
    :vartype host_name: str
    :ivar serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
     Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
    :vartype serial_number: str
    """

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(self, *, host_name: Optional[str] = None, serial_number: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword host_name: The host Name of the device.
        :paramtype host_name: str
        :keyword serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
         Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name
        self.serial_number = serial_number


class NetworkDevicePatchParameters(_serialization.Model):
    """The NetworkDevicePatchParameters resource definition.

    :ivar tags: Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar host_name: The host Name of the device.
    :vartype host_name: str
    :ivar serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
     Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
    :vartype serial_number: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword host_name: The host Name of the device.
        :paramtype host_name: str
        :keyword serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
         Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.annotation = annotation
        self.host_name = host_name
        self.serial_number = serial_number


class NetworkDevicePatchParametersProperties(AnnotationResource, NetworkDevicePatchableProperties):
    """Network Device Patch properties.

    :ivar host_name: The host Name of the device.
    :vartype host_name: str
    :ivar serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
     Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
    :vartype serial_number: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_name: The host Name of the device.
        :paramtype host_name: str
        :keyword serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
         Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
        :paramtype serial_number: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, host_name=host_name, serial_number=serial_number, **kwargs)
        self.host_name = host_name
        self.serial_number = serial_number
        self.annotation = annotation


class NetworkDeviceProperties(AnnotationResource, NetworkDevicePatchableProperties):
    """NetworkDeviceProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar host_name: The host Name of the device.
    :vartype host_name: str
    :ivar serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
     Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
    :vartype serial_number: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar version: Current version of the device as defined in SKU.
    :vartype version: str
    :ivar network_device_sku: Network Device SKU name. Required.
    :vartype network_device_sku: str
    :ivar network_device_role: networkDeviceRole is the device role: Example: CE | ToR. Required.
     Known values are: "CE", "ToR", "NPB", "TS", and "Management".
    :vartype network_device_role: str or
     ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleTypes
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar network_rack_id: Reference to network rack resource id.
    :vartype network_rack_id: str
    """

    _validation = {
        "version": {"readonly": True},
        "network_device_sku": {"required": True},
        "network_device_role": {"required": True},
        "provisioning_state": {"readonly": True},
        "network_rack_id": {"readonly": True},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "network_device_sku": {"key": "networkDeviceSku", "type": "str"},
        "network_device_role": {"key": "networkDeviceRole", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "network_rack_id": {"key": "networkRackId", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_device_sku: str,
        network_device_role: Union[str, "_models.NetworkDeviceRoleTypes"],
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_name: The host Name of the device.
        :paramtype host_name: str
        :keyword serial_number: serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber.
         Example: Arista;DCS-7280DR3-24;12.05;JPE21116969.
        :paramtype serial_number: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_device_sku: Network Device SKU name. Required.
        :paramtype network_device_sku: str
        :keyword network_device_role: networkDeviceRole is the device role: Example: CE | ToR.
         Required. Known values are: "CE", "ToR", "NPB", "TS", and "Management".
        :paramtype network_device_role: str or
         ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleTypes
        """
        super().__init__(annotation=annotation, host_name=host_name, serial_number=serial_number, **kwargs)
        self.host_name = host_name
        self.serial_number = serial_number
        self.version = None
        self.network_device_sku = network_device_sku
        self.network_device_role = network_device_role
        self.provisioning_state = None
        self.network_rack_id = None
        self.annotation = annotation


class NetworkDeviceRoleProperties(_serialization.Model):
    """Network device properties / role for the Network Rack.

    :ivar network_device_sku_name: Name of the associated Network Device SKU.
    :vartype network_device_sku_name: str
    :ivar role_type: Role for the network device. Known values are: "CE", "ToR", "NPB", "TS", and
     "Management".
    :vartype role_type: str or ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRackRoleType
    :ivar rack_slot: Rack slot for the network device.
    :vartype rack_slot: int
    """

    _attribute_map = {
        "network_device_sku_name": {"key": "networkDeviceSkuName", "type": "str"},
        "role_type": {"key": "roleType", "type": "str"},
        "rack_slot": {"key": "rackSlot", "type": "int"},
    }

    def __init__(
        self,
        *,
        network_device_sku_name: Optional[str] = None,
        role_type: Optional[Union[str, "_models.NetworkDeviceRackRoleType"]] = None,
        rack_slot: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_device_sku_name: Name of the associated Network Device SKU.
        :paramtype network_device_sku_name: str
        :keyword role_type: Role for the network device. Known values are: "CE", "ToR", "NPB", "TS",
         and "Management".
        :paramtype role_type: str or ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRackRoleType
        :keyword rack_slot: Rack slot for the network device.
        :paramtype rack_slot: int
        """
        super().__init__(**kwargs)
        self.network_device_sku_name = network_device_sku_name
        self.role_type = role_type
        self.rack_slot = rack_slot


class NetworkDeviceSku(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkDeviceSku resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar model: Model of the network device. Required.
    :vartype model: str
    :ivar manufacturer: Manufacturer of the network device.
    :vartype manufacturer: str
    :ivar supported_versions: List of network device interfaces.
    :vartype supported_versions:
     list[~azure.mgmt.managednetworkfabric.models.SupportedVersionProperties]
    :ivar limits: Network device limits.
    :vartype limits: ~azure.mgmt.managednetworkfabric.models.DeviceLimits
    :ivar supported_role_types: Available roles for the network device.
    :vartype supported_role_types: list[str or
     ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleName]
    :ivar interfaces: List of network device interfaces.
    :vartype interfaces: list[~azure.mgmt.managednetworkfabric.models.DeviceInterfaceProperties]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "model": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "model": {"key": "properties.model", "type": "str"},
        "manufacturer": {"key": "properties.manufacturer", "type": "str"},
        "supported_versions": {"key": "properties.supportedVersions", "type": "[SupportedVersionProperties]"},
        "limits": {"key": "properties.limits", "type": "DeviceLimits"},
        "supported_role_types": {"key": "properties.supportedRoleTypes", "type": "[str]"},
        "interfaces": {"key": "properties.interfaces", "type": "[DeviceInterfaceProperties]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        model: str,
        manufacturer: Optional[str] = None,
        supported_versions: Optional[List["_models.SupportedVersionProperties"]] = None,
        limits: Optional["_models.DeviceLimits"] = None,
        supported_role_types: Optional[List[Union[str, "_models.NetworkDeviceRoleName"]]] = None,
        interfaces: Optional[List["_models.DeviceInterfaceProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword model: Model of the network device. Required.
        :paramtype model: str
        :keyword manufacturer: Manufacturer of the network device.
        :paramtype manufacturer: str
        :keyword supported_versions: List of network device interfaces.
        :paramtype supported_versions:
         list[~azure.mgmt.managednetworkfabric.models.SupportedVersionProperties]
        :keyword limits: Network device limits.
        :paramtype limits: ~azure.mgmt.managednetworkfabric.models.DeviceLimits
        :keyword supported_role_types: Available roles for the network device.
        :paramtype supported_role_types: list[str or
         ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleName]
        :keyword interfaces: List of network device interfaces.
        :paramtype interfaces: list[~azure.mgmt.managednetworkfabric.models.DeviceInterfaceProperties]
        """
        super().__init__(**kwargs)
        self.model = model
        self.manufacturer = manufacturer
        self.supported_versions = supported_versions
        self.limits = limits
        self.supported_role_types = supported_role_types
        self.interfaces = interfaces
        self.provisioning_state = None


class NetworkDeviceSkusListResult(_serialization.Model):
    """List of NetworkDeviceSkus.

    :ivar value: List of NetworkDeviceSku resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDeviceSku]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkDeviceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkDeviceSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkDeviceSku resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDeviceSku]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkDevicesListResult(_serialization.Model):
    """List of NetworkDevices.

    :ivar value: List of NetworkDevice resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDevice]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkDevice]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkDevice"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkDevice resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDevice]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkFabric(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkFabric resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2IsolationDomain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3IsolationDomain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    :ivar network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once
     the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The
     SKU determines whether it is a single / multi rack Network Fabric.
    :vartype network_fabric_sku: str
    :ivar rack_count: Number of racks associated to Network Fabric.Possible values are from 2-8.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar router_id: Router Id of CE to be used for MP-BGP between PE and CE.
    :vartype router_id: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    :ivar network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
     NetworkFabric belongs.
    :vartype network_fabric_controller_id: str
    :ivar terminal_server_configuration: Network and credentials configuration currently applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfiguration
    :ivar operational_state: Gets the operational state of the resource. Known values are:
     "Provisioning", "Provisioned", "ErrorProvisioning", "Deprovisioning", "Deprovisioned",
     "ErrorDeprovisioning", and "DeferredControl".
    :vartype operational_state: str or
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricOperationalState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
        "rack_count": {"maximum": 8, "minimum": 2},
        "server_count_per_rack": {"maximum": 16, "minimum": 1},
        "router_id": {"readonly": True},
        "fabric_asn": {"maximum": 65535, "minimum": 1},
        "operational_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "racks": {"key": "properties.racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "properties.l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "properties.l3IsolationDomains", "type": "[str]"},
        "network_fabric_sku": {"key": "properties.networkFabricSku", "type": "str"},
        "rack_count": {"key": "properties.rackCount", "type": "int"},
        "server_count_per_rack": {"key": "properties.serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "properties.ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "properties.ipv6Prefix", "type": "str"},
        "router_id": {"key": "properties.routerId", "type": "str"},
        "fabric_asn": {"key": "properties.fabricASN", "type": "int"},
        "network_fabric_controller_id": {"key": "properties.networkFabricControllerId", "type": "str"},
        "terminal_server_configuration": {
            "key": "properties.terminalServerConfiguration",
            "type": "TerminalServerConfiguration",
        },
        "management_network_configuration": {
            "key": "properties.managementNetworkConfiguration",
            "type": "ManagementNetworkConfiguration",
        },
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        network_fabric_sku: Optional[str] = None,
        rack_count: Optional[int] = None,
        server_count_per_rack: Optional[int] = None,
        ipv4_prefix: Optional[str] = None,
        ipv6_prefix: Optional[str] = None,
        fabric_asn: Optional[int] = None,
        network_fabric_controller_id: Optional[str] = None,
        terminal_server_configuration: Optional["_models.TerminalServerConfiguration"] = None,
        management_network_configuration: Optional["_models.ManagementNetworkConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks.
         Once the user chooses a particular SKU, only supported racks can be added to the Network
         Fabric. The SKU determines whether it is a single / multi rack Network Fabric.
        :paramtype network_fabric_sku: str
        :keyword rack_count: Number of racks associated to Network Fabric.Possible values are from 2-8.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity.
        :paramtype fabric_asn: int
        :keyword network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
         NetworkFabric belongs.
        :paramtype network_fabric_controller_id: str
        :keyword terminal_server_configuration: Network and credentials configuration currently applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfiguration
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None
        self.network_fabric_sku = network_fabric_sku
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.router_id = None
        self.fabric_asn = fabric_asn
        self.network_fabric_controller_id = network_fabric_controller_id
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration
        self.operational_state = None
        self.provisioning_state = None


class NetworkFabricController(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkFabricController resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar infrastructure_services: InfrastructureServices IP ranges.
    :vartype infrastructure_services:
     ~azure.mgmt.managednetworkfabric.models.InfrastructureServices
    :ivar workload_services: WorkloadServices IP ranges.
    :vartype workload_services: ~azure.mgmt.managednetworkfabric.models.WorkloadServices
    :ivar managed_resource_group_configuration: Managed Resource Group configuration properties.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
    :ivar network_fabric_ids: The NF-ID will be an input parameter used by the NF to link and get
     associated with the parent NFC Service.
    :vartype network_fabric_ids: list[str]
    :ivar workload_management_network: A workload management network is required for all the tenant
     (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to
     access internet or any other MSFT/Public endpoints.
    :vartype workload_management_network: bool
    :ivar ipv4_address_space: IPv4 Network Fabric Controller Address Space.
    :vartype ipv4_address_space: str
    :ivar ipv6_address_space: IPv6 Network Fabric Controller Address Space.
    :vartype ipv6_address_space: str
    :ivar operational_state: The Operational Status would always be NULL. Look only in to the
     Provisioning state for the latest status. Known values are: "Configuring", "Succeeded", and
     "Failed".
    :vartype operational_state: str or
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricControllerOperationalState
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of NFC provisioning. Known values are: "Succeeded", "Updating", "Canceled",
     "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "infrastructure_services": {"readonly": True},
        "workload_services": {"readonly": True},
        "network_fabric_ids": {"readonly": True},
        "workload_management_network": {"readonly": True},
        "operational_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "infrastructure_express_route_connections": {
            "key": "properties.infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "properties.workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "infrastructure_services": {"key": "properties.infrastructureServices", "type": "InfrastructureServices"},
        "workload_services": {"key": "properties.workloadServices", "type": "WorkloadServices"},
        "managed_resource_group_configuration": {
            "key": "properties.managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "network_fabric_ids": {"key": "properties.networkFabricIds", "type": "[str]"},
        "workload_management_network": {"key": "properties.workloadManagementNetwork", "type": "bool"},
        "ipv4_address_space": {"key": "properties.ipv4AddressSpace", "type": "str"},
        "ipv6_address_space": {"key": "properties.ipv6AddressSpace", "type": "str"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        ipv4_address_space: Optional[str] = None,
        ipv6_address_space: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword managed_resource_group_configuration: Managed Resource Group configuration properties.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
        :keyword ipv4_address_space: IPv4 Network Fabric Controller Address Space.
        :paramtype ipv4_address_space: str
        :keyword ipv6_address_space: IPv6 Network Fabric Controller Address Space.
        :paramtype ipv6_address_space: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections
        self.infrastructure_services = None
        self.workload_services = None
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.network_fabric_ids = None
        self.workload_management_network = None
        self.ipv4_address_space = ipv4_address_space
        self.ipv6_address_space = ipv6_address_space
        self.operational_state = None
        self.provisioning_state = None


class NetworkFabricControllerPatch(_serialization.Model):
    """The NetworkFabricControllerPatch payload definition.

    :ivar tags: Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "infrastructure_express_route_connections": {
            "key": "properties.infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "properties.workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections


class NetworkFabricControllerPatchableProperties(_serialization.Model):
    """Network Fabric Controller updatable properties.

    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    """

    _attribute_map = {
        "infrastructure_express_route_connections": {
            "key": "infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
    }

    def __init__(
        self,
        *,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        """
        super().__init__(**kwargs)
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections


class NetworkFabricControllerProperties(
    AnnotationResource, NetworkFabricControllerPatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """NetworkFabricControllerProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar infrastructure_services: InfrastructureServices IP ranges.
    :vartype infrastructure_services:
     ~azure.mgmt.managednetworkfabric.models.InfrastructureServices
    :ivar workload_services: WorkloadServices IP ranges.
    :vartype workload_services: ~azure.mgmt.managednetworkfabric.models.WorkloadServices
    :ivar managed_resource_group_configuration: Managed Resource Group configuration properties.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
    :ivar network_fabric_ids: The NF-ID will be an input parameter used by the NF to link and get
     associated with the parent NFC Service.
    :vartype network_fabric_ids: list[str]
    :ivar workload_management_network: A workload management network is required for all the tenant
     (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to
     access internet or any other MSFT/Public endpoints.
    :vartype workload_management_network: bool
    :ivar ipv4_address_space: IPv4 Network Fabric Controller Address Space.
    :vartype ipv4_address_space: str
    :ivar ipv6_address_space: IPv6 Network Fabric Controller Address Space.
    :vartype ipv6_address_space: str
    :ivar operational_state: The Operational Status would always be NULL. Look only in to the
     Provisioning state for the latest status. Known values are: "Configuring", "Succeeded", and
     "Failed".
    :vartype operational_state: str or
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricControllerOperationalState
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of NFC provisioning. Known values are: "Succeeded", "Updating", "Canceled",
     "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "infrastructure_services": {"readonly": True},
        "workload_services": {"readonly": True},
        "network_fabric_ids": {"readonly": True},
        "workload_management_network": {"readonly": True},
        "operational_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "infrastructure_express_route_connections": {
            "key": "infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "annotation": {"key": "annotation", "type": "str"},
        "infrastructure_services": {"key": "infrastructureServices", "type": "InfrastructureServices"},
        "workload_services": {"key": "workloadServices", "type": "WorkloadServices"},
        "managed_resource_group_configuration": {
            "key": "managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "network_fabric_ids": {"key": "networkFabricIds", "type": "[str]"},
        "workload_management_network": {"key": "workloadManagementNetwork", "type": "bool"},
        "ipv4_address_space": {"key": "ipv4AddressSpace", "type": "str"},
        "ipv6_address_space": {"key": "ipv6AddressSpace", "type": "str"},
        "operational_state": {"key": "operationalState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        annotation: Optional[str] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        ipv4_address_space: Optional[str] = None,
        ipv6_address_space: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword managed_resource_group_configuration: Managed Resource Group configuration properties.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
        :keyword ipv4_address_space: IPv4 Network Fabric Controller Address Space.
        :paramtype ipv4_address_space: str
        :keyword ipv6_address_space: IPv6 Network Fabric Controller Address Space.
        :paramtype ipv6_address_space: str
        """
        super().__init__(
            annotation=annotation,
            infrastructure_express_route_connections=infrastructure_express_route_connections,
            workload_express_route_connections=workload_express_route_connections,
            **kwargs
        )
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections
        self.infrastructure_services = None
        self.workload_services = None
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.network_fabric_ids = None
        self.workload_management_network = None
        self.ipv4_address_space = ipv4_address_space
        self.ipv6_address_space = ipv6_address_space
        self.operational_state = None
        self.provisioning_state = None
        self.annotation = annotation


class NetworkFabricControllersListResult(_serialization.Model):
    """List of NetworkFabricControllers.

    :ivar value: List of NetworkFabricController resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricController]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFabricController]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkFabricController"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkFabricController resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricController]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkFabricPatchableProperties(_serialization.Model):
    """Network Fabric updatable properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2IsolationDomain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3IsolationDomain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    """

    _validation = {
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
    }

    _attribute_map = {
        "racks": {"key": "racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "l3IsolationDomains", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None


class NetworkFabricPatchParameters(_serialization.Model):
    """The NetworkFabric resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar terminal_server_configuration: Network and credentials configuration already applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerPatchableProperties
    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2IsolationDomain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3IsolationDomain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    """

    _validation = {
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "terminal_server_configuration": {
            "key": "properties.terminalServerConfiguration",
            "type": "TerminalServerPatchableProperties",
        },
        "racks": {"key": "properties.racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "properties.l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "properties.l3IsolationDomains", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        terminal_server_configuration: Optional["_models.TerminalServerPatchableProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword terminal_server_configuration: Network and credentials configuration already applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerPatchableProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.annotation = annotation
        self.terminal_server_configuration = terminal_server_configuration
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None


class TerminalServerPatchParameters(_serialization.Model):
    """Terminal server patch parameters.

    :ivar terminal_server_configuration: Network and credentials configuration already applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerPatchableProperties
    """

    _attribute_map = {
        "terminal_server_configuration": {
            "key": "terminalServerConfiguration",
            "type": "TerminalServerPatchableProperties",
        },
    }

    def __init__(
        self,
        *,
        terminal_server_configuration: Optional["_models.TerminalServerPatchableProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword terminal_server_configuration: Network and credentials configuration already applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerPatchableProperties
        """
        super().__init__(**kwargs)
        self.terminal_server_configuration = terminal_server_configuration


class NetworkFabricPatchParametersProperties(
    AnnotationResource, TerminalServerPatchParameters, NetworkFabricPatchableProperties
):
    """Network Fabric Patch properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2IsolationDomain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3IsolationDomain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    :ivar terminal_server_configuration: Network and credentials configuration already applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerPatchableProperties
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _validation = {
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
    }

    _attribute_map = {
        "racks": {"key": "racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "l3IsolationDomains", "type": "[str]"},
        "terminal_server_configuration": {
            "key": "terminalServerConfiguration",
            "type": "TerminalServerPatchableProperties",
        },
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        terminal_server_configuration: Optional["_models.TerminalServerPatchableProperties"] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword terminal_server_configuration: Network and credentials configuration already applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerPatchableProperties
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, terminal_server_configuration=terminal_server_configuration, **kwargs)
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None
        self.terminal_server_configuration = terminal_server_configuration
        self.annotation = annotation


class NetworkFabricProperties(
    AnnotationResource, NetworkFabricPatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """NetworkFabricProperties - define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2IsolationDomain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3IsolationDomain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once
     the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The
     SKU determines whether it is a single / multi rack Network Fabric. Required.
    :vartype network_fabric_sku: str
    :ivar rack_count: Number of racks associated to Network Fabric.Possible values are from 2-8.
     Required.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16. Required.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar router_id: Router Id of CE to be used for MP-BGP between PE and CE.
    :vartype router_id: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity. Required.
    :vartype fabric_asn: int
    :ivar network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
     NetworkFabric belongs. Required.
    :vartype network_fabric_controller_id: str
    :ivar terminal_server_configuration: Network and credentials configuration currently applied to
     terminal server. Required.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network. Required.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfiguration
    :ivar operational_state: Gets the operational state of the resource. Known values are:
     "Provisioning", "Provisioned", "ErrorProvisioning", "Deprovisioning", "Deprovisioned",
     "ErrorDeprovisioning", and "DeferredControl".
    :vartype operational_state: str or
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricOperationalState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
        "network_fabric_sku": {"required": True},
        "rack_count": {"required": True, "maximum": 8, "minimum": 2},
        "server_count_per_rack": {"required": True, "maximum": 16, "minimum": 1},
        "router_id": {"readonly": True},
        "fabric_asn": {"required": True, "maximum": 65535, "minimum": 1},
        "network_fabric_controller_id": {"required": True},
        "terminal_server_configuration": {"required": True},
        "management_network_configuration": {"required": True},
        "operational_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "racks": {"key": "racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "l3IsolationDomains", "type": "[str]"},
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_sku": {"key": "networkFabricSku", "type": "str"},
        "rack_count": {"key": "rackCount", "type": "int"},
        "server_count_per_rack": {"key": "serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "ipv6Prefix", "type": "str"},
        "router_id": {"key": "routerId", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "network_fabric_controller_id": {"key": "networkFabricControllerId", "type": "str"},
        "terminal_server_configuration": {"key": "terminalServerConfiguration", "type": "TerminalServerConfiguration"},
        "management_network_configuration": {
            "key": "managementNetworkConfiguration",
            "type": "ManagementNetworkConfiguration",
        },
        "operational_state": {"key": "operationalState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_sku: str,
        rack_count: int,
        server_count_per_rack: int,
        fabric_asn: int,
        network_fabric_controller_id: str,
        terminal_server_configuration: "_models.TerminalServerConfiguration",
        management_network_configuration: "_models.ManagementNetworkConfiguration",
        annotation: Optional[str] = None,
        ipv4_prefix: Optional[str] = None,
        ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks.
         Once the user chooses a particular SKU, only supported racks can be added to the Network
         Fabric. The SKU determines whether it is a single / multi rack Network Fabric. Required.
        :paramtype network_fabric_sku: str
        :keyword rack_count: Number of racks associated to Network Fabric.Possible values are from 2-8.
         Required.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16. Required.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity. Required.
        :paramtype fabric_asn: int
        :keyword network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
         NetworkFabric belongs. Required.
        :paramtype network_fabric_controller_id: str
        :keyword terminal_server_configuration: Network and credentials configuration currently applied
         to terminal server. Required.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network. Required.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfiguration
        """
        super().__init__(annotation=annotation, **kwargs)
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None
        self.network_fabric_sku = network_fabric_sku
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.router_id = None
        self.fabric_asn = fabric_asn
        self.network_fabric_controller_id = network_fabric_controller_id
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration
        self.operational_state = None
        self.provisioning_state = None
        self.annotation = annotation


class NetworkFabricSku(ProxyResource):
    """The NetworkFabricSku resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar type_properties_type: Type of Network Fabric Sku.
    :vartype type_properties_type: str
    :ivar max_compute_racks: Maximum number of compute racks available for this Network Fabric SKU.
    :vartype max_compute_racks: int
    :ivar min_supported_ver: Minimum supported version.
    :vartype min_supported_ver: str
    :ivar max_supported_ver: Maximum supported version.
    :vartype max_supported_ver: str
    :ivar details_uri: The URI gives full details of sku.
    :vartype details_uri: str
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "type_properties_type": {"readonly": True},
        "min_supported_ver": {"readonly": True},
        "max_supported_ver": {"readonly": True},
        "details_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "max_compute_racks": {"key": "properties.maxComputeRacks", "type": "int"},
        "min_supported_ver": {"key": "properties.minSupportedVer", "type": "str"},
        "max_supported_ver": {"key": "properties.maxSupportedVer", "type": "str"},
        "details_uri": {"key": "properties.detailsUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, max_compute_racks: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword max_compute_racks: Maximum number of compute racks available for this Network Fabric
         SKU.
        :paramtype max_compute_racks: int
        """
        super().__init__(**kwargs)
        self.type_properties_type = None
        self.max_compute_racks = max_compute_racks
        self.min_supported_ver = None
        self.max_supported_ver = None
        self.details_uri = None
        self.provisioning_state = None


class NetworkFabricSkusListResult(_serialization.Model):
    """List of NetworkFabricSkus.

    :ivar value: List of NetworkFabricSku resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricSku]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFabricSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkFabricSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkFabricSku resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricSku]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkFabricsListResult(_serialization.Model):
    """List of NetworkFabrics.

    :ivar value: List of NetworkFabric resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabric]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFabric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkFabric"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkFabric resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabric]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkInterface(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the NetworkInterface resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar physical_identifier: physicalIdentifier of the network interface.
    :vartype physical_identifier: str
    :ivar administrative_state: administrativeState of the network interface. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar connected_to: The arm resource id of the interface or compute server its connected to.
    :vartype connected_to: str
    :ivar interface_type: The Interface Type. Example: Management/Data. Known values are:
     "Management" and "Data".
    :vartype interface_type: str or ~azure.mgmt.managednetworkfabric.models.InterfaceType
    :ivar ipv4_address: ipv4Address.
    :vartype ipv4_address: str
    :ivar ipv6_address: ipv6Address.
    :vartype ipv6_address: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "physical_identifier": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "connected_to": {"readonly": True},
        "interface_type": {"readonly": True},
        "ipv4_address": {"readonly": True},
        "ipv6_address": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "physical_identifier": {"key": "properties.physicalIdentifier", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "connected_to": {"key": "properties.connectedTo", "type": "str"},
        "interface_type": {"key": "properties.interfaceType", "type": "str"},
        "ipv4_address": {"key": "properties.ipv4Address", "type": "str"},
        "ipv6_address": {"key": "properties.ipv6Address", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.physical_identifier = None
        self.administrative_state = None
        self.provisioning_state = None
        self.connected_to = None
        self.interface_type = None
        self.ipv4_address = None
        self.ipv6_address = None


class NetworkInterfacePatch(_serialization.Model):
    """The NetworkInterfacePatch resource definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "annotation": {"key": "properties.annotation", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation


class NetworkInterfacePatchProperties(AnnotationResource):
    """Network Interface Patch properties.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, **kwargs)


class NetworkInterfaceProperties(AnnotationResource):
    """NetworkInterfaceProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar physical_identifier: physicalIdentifier of the network interface.
    :vartype physical_identifier: str
    :ivar administrative_state: administrativeState of the network interface. Example: Enabled |
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar connected_to: The arm resource id of the interface or compute server its connected to.
    :vartype connected_to: str
    :ivar interface_type: The Interface Type. Example: Management/Data. Known values are:
     "Management" and "Data".
    :vartype interface_type: str or ~azure.mgmt.managednetworkfabric.models.InterfaceType
    :ivar ipv4_address: ipv4Address.
    :vartype ipv4_address: str
    :ivar ipv6_address: ipv6Address.
    :vartype ipv6_address: str
    """

    _validation = {
        "physical_identifier": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "connected_to": {"readonly": True},
        "interface_type": {"readonly": True},
        "ipv4_address": {"readonly": True},
        "ipv6_address": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "physical_identifier": {"key": "physicalIdentifier", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "connected_to": {"key": "connectedTo", "type": "str"},
        "interface_type": {"key": "interfaceType", "type": "str"},
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
        "ipv6_address": {"key": "ipv6Address", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.physical_identifier = None
        self.administrative_state = None
        self.provisioning_state = None
        self.connected_to = None
        self.interface_type = None
        self.ipv4_address = None
        self.ipv6_address = None


class NetworkInterfacesList(_serialization.Model):
    """List of NetworkInterfaces.

    :ivar value: List of NetworkInterfaces resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkInterface]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterface]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkInterface"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkInterfaces resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkInterface]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkRack(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkRack resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_rack_sku: Network Rack SKU name. Required.
    :vartype network_rack_sku: str
    :ivar network_fabric_id: Network Fabric ARM resource id. Required.
    :vartype network_fabric_id: str
    :ivar network_devices: List of network device ARM resource ids.
    :vartype network_devices: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_rack_sku": {"required": True},
        "network_fabric_id": {"required": True},
        "network_devices": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_rack_sku": {"key": "properties.networkRackSku", "type": "str"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "network_devices": {"key": "properties.networkDevices", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_rack_sku: str,
        network_fabric_id: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_rack_sku: Network Rack SKU name. Required.
        :paramtype network_rack_sku: str
        :keyword network_fabric_id: Network Fabric ARM resource id. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.network_rack_sku = network_rack_sku
        self.network_fabric_id = network_fabric_id
        self.network_devices = None
        self.provisioning_state = None


class NetworkRackPatch(_serialization.Model):
    """The NetworkRack patch resource definition.

    :ivar properties: Resource properties.
    :vartype properties: JSON
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "object"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, properties: Optional[JSON] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Resource properties.
        :paramtype properties: JSON
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class NetworkRackProperties(AnnotationResource):
    """NetworkRackProperties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_rack_sku: Network Rack SKU name. Required.
    :vartype network_rack_sku: str
    :ivar network_fabric_id: Network Fabric ARM resource id. Required.
    :vartype network_fabric_id: str
    :ivar network_devices: List of network device ARM resource ids.
    :vartype network_devices: list[str]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "network_rack_sku": {"required": True},
        "network_fabric_id": {"required": True},
        "network_devices": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_rack_sku": {"key": "networkRackSku", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "network_devices": {"key": "networkDevices", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, network_rack_sku: str, network_fabric_id: str, annotation: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_rack_sku: Network Rack SKU name. Required.
        :paramtype network_rack_sku: str
        :keyword network_fabric_id: Network Fabric ARM resource id. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_rack_sku = network_rack_sku
        self.network_fabric_id = network_fabric_id
        self.network_devices = None
        self.provisioning_state = None


class NetworkRackSku(ProxyResource):
    """The NetworkRackSku resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar role_name: The role of the Network Rack: Aggregate or Compute. Required. Known values
     are: "ComputeRack" and "AggregateRack".
    :vartype role_name: str or ~azure.mgmt.managednetworkfabric.models.NetworkRackRoleName
    :ivar maximum_server_count: Maximum number of servers available for this SKU.
    :vartype maximum_server_count: int
    :ivar maximum_storage_count: Maximum number of storage devices available for this SKU.
    :vartype maximum_storage_count: int
    :ivar maximum_uplinks: Maximum number of network uplinks available for this SKU.
    :vartype maximum_uplinks: int
    :ivar network_devices: List of network device properties / role for the Network Rack.
    :vartype network_devices:
     list[~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleProperties]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "role_name": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "role_name": {"key": "properties.roleName", "type": "str"},
        "maximum_server_count": {"key": "properties.maximumServerCount", "type": "int"},
        "maximum_storage_count": {"key": "properties.maximumStorageCount", "type": "int"},
        "maximum_uplinks": {"key": "properties.maximumUplinks", "type": "int"},
        "network_devices": {"key": "properties.networkDevices", "type": "[NetworkDeviceRoleProperties]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        role_name: Union[str, "_models.NetworkRackRoleName"],
        maximum_server_count: Optional[int] = None,
        maximum_storage_count: Optional[int] = None,
        maximum_uplinks: Optional[int] = None,
        network_devices: Optional[List["_models.NetworkDeviceRoleProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: The role of the Network Rack: Aggregate or Compute. Required. Known values
         are: "ComputeRack" and "AggregateRack".
        :paramtype role_name: str or ~azure.mgmt.managednetworkfabric.models.NetworkRackRoleName
        :keyword maximum_server_count: Maximum number of servers available for this SKU.
        :paramtype maximum_server_count: int
        :keyword maximum_storage_count: Maximum number of storage devices available for this SKU.
        :paramtype maximum_storage_count: int
        :keyword maximum_uplinks: Maximum number of network uplinks available for this SKU.
        :paramtype maximum_uplinks: int
        :keyword network_devices: List of network device properties / role for the Network Rack.
        :paramtype network_devices:
         list[~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleProperties]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.maximum_server_count = maximum_server_count
        self.maximum_storage_count = maximum_storage_count
        self.maximum_uplinks = maximum_uplinks
        self.network_devices = network_devices
        self.provisioning_state = None


class NetworkRackSkusListResult(_serialization.Model):
    """List of NetworkRackSkus.

    :ivar value: List of NetworkRackSku resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkRackSku]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkRackSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkRackSku"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkRackSku resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkRackSku]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkRacksListResult(_serialization.Model):
    """List of NetworkRacks.

    :ivar value: List of NetworkRack resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkRack]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkRack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkRack"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkRack resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkRack]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkToNetworkInterconnect(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkToNetworkInterconnect resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar nni_type: Type of NNI used. Example: CE | NPB. Known values are: "CE" and "NPB".
    :vartype nni_type: str or ~azure.mgmt.managednetworkfabric.models.NniType
    :ivar administrative_state: Gets the administrativeState of the resource. Example
     -Enabled/Disabled. Known values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar is_management_type: Configuration to use NNI for Infrastructure Management. Example:
     True/False. Known values are: "True" and "False".
    :vartype is_management_type: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar use_option_b: Based on this parameter the layer2/layer3 is made as mandatory. Example:
     True/False. Known values are: "True" and "False".
    :vartype use_option_b: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar layer2_configuration: Common properties for Layer2Configuration.
    :vartype layer2_configuration: ~azure.mgmt.managednetworkfabric.models.Layer2Configuration
    :ivar layer3_configuration: Common properties for Layer3Configuration.
    :vartype layer3_configuration: ~azure.mgmt.managednetworkfabric.models.Layer3Configuration
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "administrative_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "nni_type": {"key": "properties.nniType", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
        "is_management_type": {"key": "properties.isManagementType", "type": "str"},
        "use_option_b": {"key": "properties.useOptionB", "type": "str"},
        "layer2_configuration": {"key": "properties.layer2Configuration", "type": "Layer2Configuration"},
        "layer3_configuration": {"key": "properties.layer3Configuration", "type": "Layer3Configuration"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        nni_type: Union[str, "_models.NniType"] = "CE",
        is_management_type: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        use_option_b: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        layer2_configuration: Optional["_models.Layer2Configuration"] = None,
        layer3_configuration: Optional["_models.Layer3Configuration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword nni_type: Type of NNI used. Example: CE | NPB. Known values are: "CE" and "NPB".
        :paramtype nni_type: str or ~azure.mgmt.managednetworkfabric.models.NniType
        :keyword is_management_type: Configuration to use NNI for Infrastructure Management. Example:
         True/False. Known values are: "True" and "False".
        :paramtype is_management_type: str or
         ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword use_option_b: Based on this parameter the layer2/layer3 is made as mandatory. Example:
         True/False. Known values are: "True" and "False".
        :paramtype use_option_b: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword layer2_configuration: Common properties for Layer2Configuration.
        :paramtype layer2_configuration: ~azure.mgmt.managednetworkfabric.models.Layer2Configuration
        :keyword layer3_configuration: Common properties for Layer3Configuration.
        :paramtype layer3_configuration: ~azure.mgmt.managednetworkfabric.models.Layer3Configuration
        """
        super().__init__(**kwargs)
        self.nni_type = nni_type
        self.administrative_state = None
        self.is_management_type = is_management_type
        self.use_option_b = use_option_b
        self.layer2_configuration = layer2_configuration
        self.layer3_configuration = layer3_configuration
        self.provisioning_state = None


class NetworkToNetworkInterconnectsList(_serialization.Model):
    """List of NetworkToNetworkInterconnects.

    :ivar value: List of NetworkToNetworkInterconnects resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkToNetworkInterconnect]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkToNetworkInterconnect]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkToNetworkInterconnect"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkToNetworkInterconnects resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkToNetworkInterconnect]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.managednetworkfabric.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.managednetworkfabric.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.managednetworkfabric.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.managednetworkfabric.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OptionAProperties(Layer3IpPrefixProperties):
    """Peering optionA properties.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
     172.31.0.0/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
     3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
     Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
     Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
     be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
     and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
     are to be configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv6_prefix: str
    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan identifier. Example : 501.
    :vartype vlan_id: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD Configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.FabricBfdConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9000, "minimum": 1500},
        "vlan_id": {"maximum": 4095, "minimum": 501},
        "peer_asn": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "FabricBfdConfiguration"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.FabricBfdConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
         172.31.0.0/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
         3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
         Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
         Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
         be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
         and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
         are to be configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv6_prefix: str
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan identifier. Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD Configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.FabricBfdConfiguration
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration


class OptionBProperties(_serialization.Model):
    """Option B configuration.

    :ivar import_route_targets: Route Targets to be applied for incoming routes into CE.
    :vartype import_route_targets: list[str]
    :ivar export_route_targets: Route Targets to be applied for outgoing routes from CE.
    :vartype export_route_targets: list[str]
    """

    _attribute_map = {
        "import_route_targets": {"key": "importRouteTargets", "type": "[str]"},
        "export_route_targets": {"key": "exportRouteTargets", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        import_route_targets: Optional[List[str]] = None,
        export_route_targets: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_route_targets: Route Targets to be applied for incoming routes into CE.
        :paramtype import_route_targets: list[str]
        :keyword export_route_targets: Route Targets to be applied for outgoing routes from CE.
        :paramtype export_route_targets: list[str]
        """
        super().__init__(**kwargs)
        self.import_route_targets = import_route_targets
        self.export_route_targets = export_route_targets


class OptionBPropertiesAutoGenerated(_serialization.Model):
    """Option B configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar import_route_targets: Route Targets to be applied for incoming routes into CE. Required.
    :vartype import_route_targets: list[str]
    :ivar export_route_targets: Route Targets to be applied for outgoing routes from CE. Required.
    :vartype export_route_targets: list[str]
    """

    _validation = {
        "import_route_targets": {"required": True},
        "export_route_targets": {"required": True},
    }

    _attribute_map = {
        "import_route_targets": {"key": "importRouteTargets", "type": "[str]"},
        "export_route_targets": {"key": "exportRouteTargets", "type": "[str]"},
    }

    def __init__(self, *, import_route_targets: List[str], export_route_targets: List[str], **kwargs: Any) -> None:
        """
        :keyword import_route_targets: Route Targets to be applied for incoming routes into CE.
         Required.
        :paramtype import_route_targets: list[str]
        :keyword export_route_targets: Route Targets to be applied for outgoing routes from CE.
         Required.
        :paramtype export_route_targets: list[str]
        """
        super().__init__(**kwargs)
        self.import_route_targets = import_route_targets
        self.export_route_targets = export_route_targets


class RoutePoliciesListResult(_serialization.Model):
    """List of RoutePolicies.

    :ivar value: List of RoutePolicy resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.RoutePolicy]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoutePolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RoutePolicy"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of RoutePolicy resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.RoutePolicy]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoutePolicy(TrackedResource):
    """The RoutePolicy resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar statements: Route Policy statements. Required.
    :vartype statements:
     list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "statements": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "statements": {"key": "properties.statements", "type": "[RoutePolicyStatementProperties]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        statements: List["_models.RoutePolicyStatementProperties"],
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword statements: Route Policy statements. Required.
        :paramtype statements:
         list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.statements = statements
        self.provisioning_state = None


class RoutePolicyPatch(_serialization.Model):
    """The RoutePolicy patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class RoutePolicyProperties(AnnotationResource):
    """RoutePolicy Properties define the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar statements: Route Policy statements. Required.
    :vartype statements:
     list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
    :ivar provisioning_state: Gets the provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Canceled", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "statements": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "statements": {"key": "statements", "type": "[RoutePolicyStatementProperties]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        statements: List["_models.RoutePolicyStatementProperties"],
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword statements: Route Policy statements. Required.
        :paramtype statements:
         list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.statements = statements
        self.provisioning_state = None


class RoutePolicyStatementProperties(AnnotationResource):
    """Route Policy Statement properties..

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar sequence_number: Sequence to insert to/delete from existing route. Required.
    :vartype sequence_number: int
    :ivar condition: Route policy condition properties. Required.
    :vartype condition: ~azure.mgmt.managednetworkfabric.models.StatementConditionProperties
    :ivar action: Route policy action properties. Required.
    :vartype action: ~azure.mgmt.managednetworkfabric.models.StatementActionProperties
    """

    _validation = {
        "sequence_number": {"required": True, "maximum": 4294967295, "minimum": 1},
        "condition": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "condition": {"key": "condition", "type": "StatementConditionProperties"},
        "action": {"key": "action", "type": "StatementActionProperties"},
    }

    def __init__(
        self,
        *,
        sequence_number: int,
        condition: "_models.StatementConditionProperties",
        action: "_models.StatementActionProperties",
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword sequence_number: Sequence to insert to/delete from existing route. Required.
        :paramtype sequence_number: int
        :keyword condition: Route policy condition properties. Required.
        :paramtype condition: ~azure.mgmt.managednetworkfabric.models.StatementConditionProperties
        :keyword action: Route policy action properties. Required.
        :paramtype action: ~azure.mgmt.managednetworkfabric.models.StatementActionProperties
        """
        super().__init__(annotation=annotation, **kwargs)
        self.sequence_number = sequence_number
        self.condition = condition
        self.action = action


class StatementActionProperties(_serialization.Model):
    """Route policy action properties.

    All required parameters must be populated in order to send to Azure.

    :ivar local_preference: localPreference of the route policy.
    :vartype local_preference: int
    :ivar action_type: action. Example: Permit | Deny. Required. Known values are: "Permit" and
     "Deny".
    :vartype action_type: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar ip_community_properties: IP Community Properties.
    :vartype ip_community_properties:
     ~azure.mgmt.managednetworkfabric.models.ActionIpCommunityProperties
    :ivar ip_extended_community_properties: IP Extended Community Properties.
    :vartype ip_extended_community_properties:
     ~azure.mgmt.managednetworkfabric.models.ActionIpExtendedCommunityProperties
    """

    _validation = {
        "local_preference": {"maximum": 4294967295, "minimum": 0},
        "action_type": {"required": True},
    }

    _attribute_map = {
        "local_preference": {"key": "localPreference", "type": "int"},
        "action_type": {"key": "actionType", "type": "str"},
        "ip_community_properties": {"key": "ipCommunityProperties", "type": "ActionIpCommunityProperties"},
        "ip_extended_community_properties": {
            "key": "ipExtendedCommunityProperties",
            "type": "ActionIpExtendedCommunityProperties",
        },
    }

    def __init__(
        self,
        *,
        action_type: Union[str, "_models.CommunityActionTypes"],
        local_preference: Optional[int] = None,
        ip_community_properties: Optional["_models.ActionIpCommunityProperties"] = None,
        ip_extended_community_properties: Optional["_models.ActionIpExtendedCommunityProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword local_preference: localPreference of the route policy.
        :paramtype local_preference: int
        :keyword action_type: action. Example: Permit | Deny. Required. Known values are: "Permit" and
         "Deny".
        :paramtype action_type: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword ip_community_properties: IP Community Properties.
        :paramtype ip_community_properties:
         ~azure.mgmt.managednetworkfabric.models.ActionIpCommunityProperties
        :keyword ip_extended_community_properties: IP Extended Community Properties.
        :paramtype ip_extended_community_properties:
         ~azure.mgmt.managednetworkfabric.models.ActionIpExtendedCommunityProperties
        """
        super().__init__(**kwargs)
        self.local_preference = local_preference
        self.action_type = action_type
        self.ip_community_properties = ip_community_properties
        self.ip_extended_community_properties = ip_extended_community_properties


class StatementConditionProperties(IpCommunityIdList, IpExtendedCommunityIdList):
    """Route policy statement condition properties.

    :ivar ip_extended_community_ids: List of IP Extended Community resource IDs.
    :vartype ip_extended_community_ids: list[str]
    :ivar ip_community_ids: List of IP Community resource IDs.
    :vartype ip_community_ids: list[str]
    :ivar ip_prefix_id: Arm Resource Id of IpPrefix.
    :vartype ip_prefix_id: str
    """

    _attribute_map = {
        "ip_extended_community_ids": {"key": "ipExtendedCommunityIds", "type": "[str]"},
        "ip_community_ids": {"key": "ipCommunityIds", "type": "[str]"},
        "ip_prefix_id": {"key": "ipPrefixId", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_extended_community_ids: Optional[List[str]] = None,
        ip_community_ids: Optional[List[str]] = None,
        ip_prefix_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_extended_community_ids: List of IP Extended Community resource IDs.
        :paramtype ip_extended_community_ids: list[str]
        :keyword ip_community_ids: List of IP Community resource IDs.
        :paramtype ip_community_ids: list[str]
        :keyword ip_prefix_id: Arm Resource Id of IpPrefix.
        :paramtype ip_prefix_id: str
        """
        super().__init__(
            ip_community_ids=ip_community_ids, ip_extended_community_ids=ip_extended_community_ids, **kwargs
        )
        self.ip_extended_community_ids = ip_extended_community_ids
        self.ip_prefix_id = ip_prefix_id
        self.ip_community_ids = ip_community_ids


class StaticRouteConfiguration(_serialization.Model):
    """staticRouteConfiguration model.

    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ipv4_routes: List with object IPv4Routes.
    :vartype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    :ivar ipv6_routes: List with object IPv6Routes.
    :vartype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    """

    _attribute_map = {
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ipv4_routes": {"key": "ipv4Routes", "type": "[StaticRouteProperties]"},
        "ipv6_routes": {"key": "ipv6Routes", "type": "[StaticRouteProperties]"},
    }

    def __init__(
        self,
        *,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ipv4_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        ipv6_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ipv4_routes: List with object IPv4Routes.
        :paramtype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        :keyword ipv6_routes: List with object IPv6Routes.
        :paramtype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        """
        super().__init__(**kwargs)
        self.bfd_configuration = bfd_configuration
        self.ipv4_routes = ipv4_routes
        self.ipv6_routes = ipv6_routes


class StaticRouteProperties(_serialization.Model):
    """Static Route properties.

    All required parameters must be populated in order to send to Azure.

    :ivar prefix: IPv4 | IPv6 Prefix. Required.
    :vartype prefix: str
    :ivar next_hop: List of next hop IPv4 | IPv6 addresses. Required.
    :vartype next_hop: list[str]
    """

    _validation = {
        "prefix": {"required": True},
        "next_hop": {"required": True},
    }

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "[str]"},
    }

    def __init__(self, *, prefix: str, next_hop: List[str], **kwargs: Any) -> None:
        """
        :keyword prefix: IPv4 | IPv6 Prefix. Required.
        :paramtype prefix: str
        :keyword next_hop: List of next hop IPv4 | IPv6 addresses. Required.
        :paramtype next_hop: list[str]
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.next_hop = next_hop


class SupportedConnectorProperties(_serialization.Model):
    """Supported connector properties.

    :ivar connector_type: Connector type. Example: Optical.
    :vartype connector_type: str
    :ivar max_speed_in_mbps: Maximum speed of the connector in Mbps.
    :vartype max_speed_in_mbps: int
    """

    _attribute_map = {
        "connector_type": {"key": "connectorType", "type": "str"},
        "max_speed_in_mbps": {"key": "maxSpeedInMbps", "type": "int"},
    }

    def __init__(
        self, *, connector_type: Optional[str] = None, max_speed_in_mbps: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connector_type: Connector type. Example: Optical.
        :paramtype connector_type: str
        :keyword max_speed_in_mbps: Maximum speed of the connector in Mbps.
        :paramtype max_speed_in_mbps: int
        """
        super().__init__(**kwargs)
        self.connector_type = connector_type
        self.max_speed_in_mbps = max_speed_in_mbps


class SupportedVersionProperties(_serialization.Model):
    """Network device supported version properties.

    :ivar version: Operating system and firmware combined versions.
    :vartype version: str
    :ivar vendor_os_version: Operating system version.
    :vartype vendor_os_version: str
    :ivar vendor_firmware_version: Firmware version.
    :vartype vendor_firmware_version: str
    :ivar is_current: If the current version is in use. Known values are: "true" and "false".
    :vartype is_current: str or ~azure.mgmt.managednetworkfabric.models.IsCurrentVersion
    :ivar is_test: If the current version is a test version. Known values are: "true" and "false".
    :vartype is_test: str or ~azure.mgmt.managednetworkfabric.models.IsTestVersion
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "vendor_os_version": {"key": "vendorOsVersion", "type": "str"},
        "vendor_firmware_version": {"key": "vendorFirmwareVersion", "type": "str"},
        "is_current": {"key": "isCurrent", "type": "str"},
        "is_test": {"key": "isTest", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        vendor_os_version: Optional[str] = None,
        vendor_firmware_version: Optional[str] = None,
        is_current: Optional[Union[str, "_models.IsCurrentVersion"]] = None,
        is_test: Optional[Union[str, "_models.IsTestVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Operating system and firmware combined versions.
        :paramtype version: str
        :keyword vendor_os_version: Operating system version.
        :paramtype vendor_os_version: str
        :keyword vendor_firmware_version: Firmware version.
        :paramtype vendor_firmware_version: str
        :keyword is_current: If the current version is in use. Known values are: "true" and "false".
        :paramtype is_current: str or ~azure.mgmt.managednetworkfabric.models.IsCurrentVersion
        :keyword is_test: If the current version is a test version. Known values are: "true" and
         "false".
        :paramtype is_test: str or ~azure.mgmt.managednetworkfabric.models.IsTestVersion
        """
        super().__init__(**kwargs)
        self.version = version
        self.vendor_os_version = vendor_os_version
        self.vendor_firmware_version = vendor_firmware_version
        self.is_current = is_current
        self.is_test = is_test


class SupportPackageProperties(_serialization.Model):
    """Generate support package post action properties.

    All required parameters must be populated in order to send to Azure.

    :ivar support_package_url: The URL to fetch the generated support package from. Required.
    :vartype support_package_url: str
    """

    _validation = {
        "support_package_url": {"required": True},
    }

    _attribute_map = {
        "support_package_url": {"key": "supportPackageURL", "type": "str"},
    }

    def __init__(self, *, support_package_url: str, **kwargs: Any) -> None:
        """
        :keyword support_package_url: The URL to fetch the generated support package from. Required.
        :paramtype support_package_url: str
        """
        super().__init__(**kwargs)
        self.support_package_url = support_package_url


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TerminalServerPatchableProperties(_serialization.Model):
    """Network and credential configuration currently applied on terminal server.

    :ivar username: Username for the terminal server connection.
    :vartype username: str
    :ivar password: Password for the terminal server connection.
    :vartype password: str
    :ivar serial_number: Serial Number of Terminal server.
    :vartype serial_number: str
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: Username for the terminal server connection.
        :paramtype username: str
        :keyword password: Password for the terminal server connection.
        :paramtype password: str
        :keyword serial_number: Serial Number of Terminal server.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password
        self.serial_number = serial_number


class TerminalServerConfiguration(Layer3IpPrefixProperties, TerminalServerPatchableProperties):
    """Network and credentials configuration currently applied to terminal server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar username: Username for the terminal server connection.
    :vartype username: str
    :ivar password: Password for the terminal server connection.
    :vartype password: str
    :ivar serial_number: Serial Number of Terminal server.
    :vartype serial_number: str
    :ivar primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
     172.31.0.0/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
     3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
     Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
     afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
     are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
     configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
     Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
     be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
     and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
     are to be configured on PE1 and PE2 for Option B interfaces.
    :vartype secondary_ipv6_prefix: str
    :ivar network_device_id: ARM Resource ID used for the NetworkDevice.
    :vartype network_device_id: str
    """

    _validation = {
        "network_device_id": {"readonly": True},
    }

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "network_device_id": {"key": "networkDeviceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        serial_number: Optional[str] = None,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: Username for the terminal server connection.
        :paramtype username: str
        :keyword password: Password for the terminal server connection.
        :paramtype password: str
        :keyword serial_number: Serial Number of Terminal server.
        :paramtype serial_number: str
        :keyword primary_ipv4_prefix: IPv4 Address Prefix of CE-PE interconnect links. Example:
         172.31.0.0/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix of CE-PE interconnect links. Example:
         3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix of CE-PE interconnect links.
         Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated
         afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs
         are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be
         configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix of CE-PE interconnect links.
         Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can
         be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st
         and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs
         are to be configured on PE1 and PE2 for Option B interfaces.
        :paramtype secondary_ipv6_prefix: str
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            username=username,
            password=password,
            serial_number=serial_number,
            **kwargs
        )
        self.username = username
        self.password = password
        self.serial_number = serial_number
        self.network_device_id = None
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix


class UpdateAdministrativeState(EnableDisableOnResources):
    """Update administrative state on list of resources.

    :ivar resource_ids: Network Fabrics or Network Rack resource Id.
    :vartype resource_ids: list[str]
    :ivar state: Administrative state. Known values are: "Enable" and "Disable".
    :vartype state: str or ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _attribute_map = {
        "resource_ids": {"key": "resourceIds", "type": "[str]"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_ids: Optional[List[str]] = None,
        state: Optional[Union[str, "_models.AdministrativeState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_ids: Network Fabrics or Network Rack resource Id.
        :paramtype resource_ids: list[str]
        :keyword state: Administrative state. Known values are: "Enable" and "Disable".
        :paramtype state: str or ~azure.mgmt.managednetworkfabric.models.AdministrativeState
        """
        super().__init__(resource_ids=resource_ids, **kwargs)
        self.state = state


class UpdatePowerCycleProperties(_serialization.Model):
    """Update power cycle input properties.

    All required parameters must be populated in order to send to Azure.

    :ivar power_end: Primary or Secondary power end. Required. Known values are: "Primary" and
     "Secondary".
    :vartype power_end: str or ~azure.mgmt.managednetworkfabric.models.PowerEnd
    :ivar state: On or Off toggle state. Required. Known values are: "On" and "Off".
    :vartype state: str or ~azure.mgmt.managednetworkfabric.models.State
    """

    _validation = {
        "power_end": {"required": True},
        "state": {"required": True},
    }

    _attribute_map = {
        "power_end": {"key": "powerEnd", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self, *, power_end: Union[str, "_models.PowerEnd"], state: Union[str, "_models.State"], **kwargs: Any
    ) -> None:
        """
        :keyword power_end: Primary or Secondary power end. Required. Known values are: "Primary" and
         "Secondary".
        :paramtype power_end: str or ~azure.mgmt.managednetworkfabric.models.PowerEnd
        :keyword state: On or Off toggle state. Required. Known values are: "On" and "Off".
        :paramtype state: str or ~azure.mgmt.managednetworkfabric.models.State
        """
        super().__init__(**kwargs)
        self.power_end = power_end
        self.state = state


class UpdateVersionProperties(_serialization.Model):
    """Generate support package post action properties.

    All required parameters must be populated in order to send to Azure.

    :ivar sku_version: The supported version defined in network device SKU. Required.
    :vartype sku_version: str
    """

    _validation = {
        "sku_version": {"required": True},
    }

    _attribute_map = {
        "sku_version": {"key": "skuVersion", "type": "str"},
    }

    def __init__(self, *, sku_version: str, **kwargs: Any) -> None:
        """
        :keyword sku_version: The supported version defined in network device SKU. Required.
        :paramtype sku_version: str
        """
        super().__init__(**kwargs)
        self.sku_version = sku_version


class VpnConfigurationProperties(_serialization.Model):
    """Configuration for infrastructure vpn.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar administrative_state: Indicates configuration state. Example: Enabled | Disabled. Known
     values are: "Enabled" and "Disabled".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.EnabledDisabledState
    :ivar network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the
     resource.
    :vartype network_to_network_interconnect_id: str
    :ivar peering_option: Peering option list. Required. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties.
    :vartype option_b_properties:
     ~azure.mgmt.managednetworkfabric.models.OptionBPropertiesAutoGenerated
    :ivar option_a_properties: option A properties.
    :vartype option_a_properties: ~azure.mgmt.managednetworkfabric.models.OptionAProperties
    """

    _validation = {
        "administrative_state": {"readonly": True},
        "network_to_network_interconnect_id": {"readonly": True},
        "peering_option": {"required": True},
    }

    _attribute_map = {
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "network_to_network_interconnect_id": {"key": "networkToNetworkInterconnectId", "type": "str"},
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "OptionBPropertiesAutoGenerated"},
        "option_a_properties": {"key": "optionAProperties", "type": "OptionAProperties"},
    }

    def __init__(
        self,
        *,
        peering_option: Union[str, "_models.PeeringOption"],
        option_b_properties: Optional["_models.OptionBPropertiesAutoGenerated"] = None,
        option_a_properties: Optional["_models.OptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword peering_option: Peering option list. Required. Known values are: "OptionA" and
         "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties.
        :paramtype option_b_properties:
         ~azure.mgmt.managednetworkfabric.models.OptionBPropertiesAutoGenerated
        :keyword option_a_properties: option A properties.
        :paramtype option_a_properties: ~azure.mgmt.managednetworkfabric.models.OptionAProperties
        """
        super().__init__(**kwargs)
        self.administrative_state = None
        self.network_to_network_interconnect_id = None
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties


class WorkloadServices(_serialization.Model):
    """WorkloadServices IP ranges.

    :ivar ipv4_address_spaces: The IPv4 Address space is optional, if the value is defined at the
     time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address subnet
     is an optional attribute.
    :vartype ipv4_address_spaces: list[str]
    :ivar ipv6_address_spaces: The IPv6 is not supported right now.
    :vartype ipv6_address_spaces: list[str]
    """

    _attribute_map = {
        "ipv4_address_spaces": {"key": "ipv4AddressSpaces", "type": "[str]"},
        "ipv6_address_spaces": {"key": "ipv6AddressSpaces", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ipv4_address_spaces: Optional[List[str]] = None,
        ipv6_address_spaces: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipv4_address_spaces: The IPv4 Address space is optional, if the value is defined at
         the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address
         subnet is an optional attribute.
        :paramtype ipv4_address_spaces: list[str]
        :keyword ipv6_address_spaces: The IPv6 is not supported right now.
        :paramtype ipv6_address_spaces: list[str]
        """
        super().__init__(**kwargs)
        self.ipv4_address_spaces = ipv4_address_spaces
        self.ipv6_address_spaces = ipv6_address_spaces
