# coding: utf-8

"""
    TKG Kubernetes API

    This API provides to vCD tenants the means to provision (create and update) Tanzu Kubernetes Grid clusters. This is complementary to the defined-entity APIs:    GET /cloudapi/1.0.0/entities/urn:vcloud:entity:vmware.tkgcluster:1.0.0:{id} which allows to retrieve the clusters created by the API presented here. This is why you will not find here a GET operation for the corresponding entity.   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from container_service_extension.client.tkgclient.models.tkg_cluster_metadata import TkgClusterMetadata  # noqa: F401,E501
from container_service_extension.client.tkgclient.models.tkg_cluster_spec import TkgClusterSpec  # noqa: F401,E501
from container_service_extension.client.tkgclient.models.tkg_cluster_status import TkgClusterStatus  # noqa: F401,E501


class TkgCluster(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kind': 'str',
        'metadata': 'TkgClusterMetadata',
        'spec': 'TkgClusterSpec',
        'status': 'TkgClusterStatus'
    }

    attribute_map = {
        'kind': 'kind',
        'metadata': 'metadata',
        'spec': 'spec',
        'status': 'status'
    }

    def __init__(self, kind=None, metadata=None, spec=None, status=None):  # noqa: E501
        """TkgCluster - a model defined in Swagger"""  # noqa: E501

        self._kind = None
        self._metadata = None
        self._spec = None
        self._status = None
        self.discriminator = None

        self.kind = kind
        self.metadata = metadata
        self.spec = spec
        if status is not None:
            self.status = status

    @property
    def kind(self):
        """Gets the kind of this TkgCluster.  # noqa: E501

        The kind of TKG cluster described in this manifest. The only supported kind is \"TanzuKubernetesCluster\".   # noqa: E501

        :return: The kind of this TkgCluster.  # noqa: E501
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this TkgCluster.

        The kind of TKG cluster described in this manifest. The only supported kind is \"TanzuKubernetesCluster\".   # noqa: E501

        :param kind: The kind of this TkgCluster.  # noqa: E501
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")  # noqa: E501

        self._kind = kind

    @property
    def metadata(self):
        """Gets the metadata of this TkgCluster.  # noqa: E501


        :return: The metadata of this TkgCluster.  # noqa: E501
        :rtype: TkgClusterMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this TkgCluster.


        :param metadata: The metadata of this TkgCluster.  # noqa: E501
        :type: TkgClusterMetadata
        """
        if metadata is None:
            raise ValueError("Invalid value for `metadata`, must not be `None`")  # noqa: E501

        self._metadata = metadata

    @property
    def spec(self):
        """Gets the spec of this TkgCluster.  # noqa: E501


        :return: The spec of this TkgCluster.  # noqa: E501
        :rtype: TkgClusterSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this TkgCluster.


        :param spec: The spec of this TkgCluster.  # noqa: E501
        :type: TkgClusterSpec
        """
        if spec is None:
            raise ValueError("Invalid value for `spec`, must not be `None`")  # noqa: E501

        self._spec = spec

    @property
    def status(self):
        """Gets the status of this TkgCluster.  # noqa: E501


        :return: The status of this TkgCluster.  # noqa: E501
        :rtype: TkgClusterStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this TkgCluster.


        :param status: The status of this TkgCluster.  # noqa: E501
        :type: TkgClusterStatus
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TkgCluster):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
