"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToCloudFront = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
/**
 * @summary The WafwebaclToCloudFront class.
 */
class WafwebaclToCloudFront extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToCloudFront class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToCloudFrontProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'CLOUDFRONT', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        // Property override of CloudFront Cfn Template
        const cfnExistingCloudFrontWebDistribution = props.existingCloudFrontWebDistribution.node.defaultChild;
        cfnExistingCloudFrontWebDistribution.addPropertyOverride('DistributionConfig.WebACLId', this.webacl.attrArn);
        this.cloudFrontWebDistribution = props.existingCloudFrontWebDistribution;
    }
}
exports.WafwebaclToCloudFront = WafwebaclToCloudFront;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToCloudFront[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-cloudfront.WafwebaclToCloudFront", version: "1.172.0" };
//# sourceMappingURL=data:application/json;base64,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