# Autogenerated constants for Character Screen service
from enum import IntEnum
from jacdac.constants import *
from jacdac.system.constants import *
JD_SERVICE_CLASS_CHARACTER_SCREEN = const(0x1f37c56a)


class CharacterScreenVariant(IntEnum):
    LCD = const(0x1)
    OLED = const(0x2)
    BRAILLE = const(0x3)


class CharacterScreenTextDirection(IntEnum):
    LEFT_TO_RIGHT = const(0x1)
    RIGHT_TO_LEFT = const(0x2)


JD_CHARACTER_SCREEN_REG_MESSAGE = const(JD_REG_VALUE)
JD_CHARACTER_SCREEN_REG_BRIGHTNESS = const(JD_REG_INTENSITY)
JD_CHARACTER_SCREEN_REG_VARIANT = const(JD_REG_VARIANT)
JD_CHARACTER_SCREEN_REG_TEXT_DIRECTION = const(0x82)
JD_CHARACTER_SCREEN_REG_ROWS = const(0x180)
JD_CHARACTER_SCREEN_REG_COLUMNS = const(0x181)
JD_CHARACTER_SCREEN_PACK_FORMATS = {
    JD_CHARACTER_SCREEN_REG_MESSAGE: "s",
    JD_CHARACTER_SCREEN_REG_BRIGHTNESS: "u0.16",
    JD_CHARACTER_SCREEN_REG_VARIANT: "u8",
    JD_CHARACTER_SCREEN_REG_TEXT_DIRECTION: "u8",
    JD_CHARACTER_SCREEN_REG_ROWS: "u8",
    JD_CHARACTER_SCREEN_REG_COLUMNS: "u8"
}
