# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['astoria',
 'astoria.common',
 'astoria.common.messages',
 'astoria.common.mqtt',
 'astoria.consumers',
 'astoria.consumers.astctl',
 'astoria.consumers.astctl.metadata',
 'astoria.consumers.astctl.static_disks',
 'astoria.consumers.astctl.usercode',
 'astoria.managers',
 'astoria.managers.astdiskd',
 'astoria.managers.astmetad',
 'astoria.managers.astprocd',
 'astoria.managers.mixins']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'dbus-next>=0.2.1,<0.3.0',
 'gmqtt>=0.6.8,<0.7.0',
 'pydantic>=1.6.1,<2.0.0',
 'toml>=0.10.2,<0.11.0',
 'typing-extensions>=3.7.4,<4.0.0']

entry_points = \
{'console_scripts': ['astctl = astoria.consumers.astctl:main',
                     'astdiskd = astoria.managers.astdiskd:main',
                     'astmetad = astoria.managers.astmetad:main',
                     'astprocd = astoria.managers.astprocd:main',
                     'astwifid = astoria.consumers.astwifid:main']}

setup_kwargs = {
    'name': 'astoria',
    'version': '0.8.1',
    'description': 'Robot Management System for Student Robotics Kit',
    'long_description': '# Astoria\n\n![Tests](https://github.com/srobo/astoria/workflows/Tests/badge.svg)\n![Build and Publish docs](https://github.com/srobo/astoria/workflows/Build%20and%20Publish%20docs/badge.svg)\n[![PyPI version](https://badge.fury.io/py/astoria.svg)](https://badge.fury.io/py/astoria)\n[![MIT license](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat)](https://opensource.org/licenses/MIT)\n![Bees](https://img.shields.io/badge/bees-110%25-yellow.svg)\n\nRobot Management System for Student Robotics 2022 kit.\n\nFor more information, please see the [documentation](https://srobo.github.io/astoria).\n\n## Contributions\n\nThis project is released under the MIT Licence. For more information, please see LICENSE.\n\nThe CONTRIBUTORS file can be generated by executing CONTRIBUTORS.gen. This generated file contains a list of people who have contributed to Astoria.\n\n',
    'author': 'Dan Trickey',
    'author_email': 'srobo-astoria@trickey.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/srobo/astoria',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
