# falcon-telegraf-middleware

[![forthebadge](https://forthebadge.com/images/badges/no-ragrets.svg)](https://forthebadge.com)

[![PyPI](https://img.shields.io/pypi/v/falcon-telegraf-middleware.svg?style=for-the-badge)](https://pypi.org/project/falcon-telegraf-middleware/)

[![Build Status](https://travis-ci.org/Webinterpret/falcon-telegraf-middleware.svg?branch=master)](https://travis-ci.org/Webinterpret/falcon-telegraf-middleware)

## What is this?

Package to ease gathering metrics from [Falcon](http://falcon.readthedocs.io/) APIs into InfluxDB via a Telegraf.
By use of middlewares this orthogonal functionality is added in a hassle-free way minimizing required work. Sane defaults make quickstart really quick 👍

## How?
Inject the middleware (or couple of them) when creating `Api` instance:

```python
from falcon_telegraf import LogHits, Timer

telegraf_client = TelegrafClient('localhost', 8094)
app = falcon.API(
    middleware=[
        LogHits(telegraf_client),
        Timer(),
    ]
)
```

Note that passing `telegraf_client` is totally optional.
Measurement names can be set when creating middleware, prefixed or autogenerated.

## Middlewares
### `LogHits`
Creates a metric named hits-path/to/endpoint with one fields called `hits` with value 1.
Executes *after* `on-*` method was called. Because of this you can add custom tags and values.
Example:
```python
def on_get(self, request, response, some_path_variable):
    request.context['telegraf_tags']['my_new_tag'] = 'this_tags_value'
    request.context['telegraf_values']['some_path_variable'] = some_path_variable
    ...
```
### `Timer`
Reports time in ms elapsed between registering response and registering request. Default metric prefix is `time-`.
Other things in processing pipeline can affect it's readings so take them with a grain of salt.

## Testing

```bash
pip install -e .
pytest
```

## Deploy
First bump version in `setup.py` in master branch via merge request. Afterwards push a version tag and wait.

```bash
git tag `date +"%Y.%-m.%-d.1"`
git push --tags
```
