"use strict";
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy ECS DeploymentGroup': {
        'imported with fromEcsDeploymentGroupAttributes': {
            'defaults the Deployment Config to AllAtOnce'(test) {
                const stack = new cdk.Stack();
                const ecsApp = codedeploy.EcsApplication.fromEcsApplicationName(stack, 'EA', 'EcsApplication');
                const importedGroup = codedeploy.EcsDeploymentGroup.fromEcsDeploymentGroupAttributes(stack, 'EDG', {
                    application: ecsApp,
                    deploymentGroupName: 'EcsDeploymentGroup',
                });
                test.equal(importedGroup.deploymentConfig, codedeploy.EcsDeploymentConfig.ALL_AT_ONCE);
                test.done();
            },
        },
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5kZXBsb3ltZW50LWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVzdC5kZXBsb3ltZW50LWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxxQ0FBcUM7QUFFckMsd0NBQXdDO0FBRXhDLGlCQUFTO0lBQ1AsZ0NBQWdDLEVBQUU7UUFDaEMsZ0RBQWdELEVBQUU7WUFDaEQsNkNBQTZDLENBQUMsSUFBVTtnQkFDdEQsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBRTlCLE1BQU0sTUFBTSxHQUFHLFVBQVUsQ0FBQyxjQUFjLENBQUMsc0JBQXNCLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO2dCQUMvRixNQUFNLGFBQWEsR0FBRyxVQUFVLENBQUMsa0JBQWtCLENBQUMsZ0NBQWdDLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtvQkFDakcsV0FBVyxFQUFFLE1BQU07b0JBQ25CLG1CQUFtQixFQUFFLG9CQUFvQjtpQkFDMUMsQ0FBQyxDQUFDO2dCQUVILElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxXQUFXLENBQUMsQ0FBQztnQkFFdkYsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2QsQ0FBQztTQUNGO0tBQ0Y7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCAqIGFzIGNvZGVkZXBsb3kgZnJvbSAnLi4vLi4vbGliJztcblxuZXhwb3J0ID0ge1xuICAnQ29kZURlcGxveSBFQ1MgRGVwbG95bWVudEdyb3VwJzoge1xuICAgICdpbXBvcnRlZCB3aXRoIGZyb21FY3NEZXBsb3ltZW50R3JvdXBBdHRyaWJ1dGVzJzoge1xuICAgICAgJ2RlZmF1bHRzIHRoZSBEZXBsb3ltZW50IENvbmZpZyB0byBBbGxBdE9uY2UnKHRlc3Q6IFRlc3QpIHtcbiAgICAgICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAgICAgY29uc3QgZWNzQXBwID0gY29kZWRlcGxveS5FY3NBcHBsaWNhdGlvbi5mcm9tRWNzQXBwbGljYXRpb25OYW1lKHN0YWNrLCAnRUEnLCAnRWNzQXBwbGljYXRpb24nKTtcbiAgICAgICAgY29uc3QgaW1wb3J0ZWRHcm91cCA9IGNvZGVkZXBsb3kuRWNzRGVwbG95bWVudEdyb3VwLmZyb21FY3NEZXBsb3ltZW50R3JvdXBBdHRyaWJ1dGVzKHN0YWNrLCAnRURHJywge1xuICAgICAgICAgIGFwcGxpY2F0aW9uOiBlY3NBcHAsXG4gICAgICAgICAgZGVwbG95bWVudEdyb3VwTmFtZTogJ0Vjc0RlcGxveW1lbnRHcm91cCcsXG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRlc3QuZXF1YWwoaW1wb3J0ZWRHcm91cC5kZXBsb3ltZW50Q29uZmlnLCBjb2RlZGVwbG95LkVjc0RlcGxveW1lbnRDb25maWcuQUxMX0FUX09OQ0UpO1xuXG4gICAgICAgIHRlc3QuZG9uZSgpO1xuICAgICAgfSxcbiAgICB9LFxuICB9LFxufTtcbiJdfQ==