# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['unmarkd']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.9.0,<5.0.0']

extras_require = \
{'all': ['cchardet>=2.1.7,<3.0.0'], 'speedups': ['cchardet>=2.1.7,<3.0.0']}

setup_kwargs = {
    'name': 'unmarkd',
    'version': '0.1.3',
    'description': 'A markdown reverser.',
    'long_description': '# 🔄 Unmarkd\n[![codecov](https://codecov.io/gh/ThatXliner/unmarkd/branch/master/graph/badge.svg?token=PWVIERHTG3)](https://codecov.io/gh/ThatXliner/unmarkd) [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) [![CI](https://github.com/ThatXliner/unmarkd/actions/workflows/ci.yml/badge.svg)](https://github.com/ThatXliner/unmarkd/actions/workflows/ci.yml) [![PyPI - Downloads](https://img.shields.io/pypi/dm/unmarkd)](https://pypi.org/project/unmarkd/)\n\n> A markdown reverser.\n\n---\nUnmarkd is a [BeautifulSoup](https://github.com/ThatXliner/unmarkd/issues/4)-powered [Markdown](https://en.wikipedia.org/wiki/Markdown) reverser written in Python and for Python.\n\n## Why\n\nThis is created as a [StackSearch](http://github.com/ThatXliner/stacksearch) (one of my other projects) dependancy. In order to create a better API, I needed a way to reverse HTML. So I created this.\n\nThere are [similar projects](https://github.com/xijo/reverse_markdown) (written in Ruby) ~~but I have not found any written in Python (or for Python)~~ later I found a popular library, [html2text](https://github.com/Alir3z4/html2text). But Unmarkd still is *still* better. See [comparison](#comparison).\n\n## Installation\n\nYou know the drill\n\n```bash\npip install unmarkd\n```\n\n## Known issues\n\n - ~~Nested lists are not properly indented ([#4](https://github.com/ThatXliner/unmarkd/issues/4))~~ Fixed in [#11](https://github.com/ThatXliner/unmarkd/pull/11)\n\n## Comparison\n\n**TL;DR: Html2Text is fast. If you don\'t need much configuration, you could use Html2Text for the little speed increase.**\n\n<details>\n\n\n<summary>Click to expand</summary>\n\n### Speed\n\n**TL;DR: Unmarkd < Html2Text**\n\nHtml2Text is basically faster:\n\n![Benchmark](./assets/benchmark.png)\n\n(The `DOC` variable used can be found [here](./assets/benchmark.html))\n\nUnmarkd sacrifices speed for [power](#configurability).\n\nHtml2Text directly uses Python\'s [`html.parser`](https://docs.python.org/3/library/html.parser.html) module (in the standard library). On the other hand, Unmarkd uses the powerful HTML parsing library, `beautifulsoup4`. BeautifulSoup can be configured to use different HTML parsers. In Unmarkd, we configure it to use Python\'s `html.parser`, too.\n\nBut another layer of code means more code is ran.\n\nI hope that\'s a good explanation of the speed difference.\n\n### Correctness\n\n**TL;DR: Unmarkd == Html2Text**\n\nI actually found *two* html-to-markdown libraries. One of them was [Tomd](https://github.com/gaojiuli/tomd) which had an *incorrect implementation*:\n\n![Actual results](./assets/tomd_cant_handle.png)\n\nIt seems to be abandoned, anyway.\n\nNow with Html2Text and Unmarkd:\n\n![Epic showdown](./assets/correct.png)\n\n\nIn other words, they *work*\n\n### Configurability\n\n**TL;DR: Unmarkd > Html2Text**\n\nThis is Unmarkd\'s strong point.\n\nIn Html2Text, you only have a limited [set of options](https://github.com/Alir3z4/html2text/blob/master/docs/usage.md#available-options).\n\nIn Unmarkd, you can subclass the `BaseUnmarker` and implement conversions for new tags (e.g. `<q>`), etc. In my opinion, it\'s much easier to extend and configure Unmarkd.\n\nUnmarkd was originally written as a StackSearch dependancy.\n\nHtml2Text has no options for configuring parsing of code blocks. Unmarkd does\n\n</details>\n\n## Documentation\n\nHere\'s an example of basic usage\n\n```python\nimport unmarkd\nprint(unmarkd.unmark("<b>I <i>love</i> markdown!</b>"))\n# Output: **I *love* markdown!**\n```\n\nor something more complex (shamelessly taken from [here](https://markdowntohtml.com)):\n\n```python\nimport unmarkd\nhtml_doc = R"""<h1 id="sample-markdown">Sample Markdown</h1>\n<p>This is some basic, sample markdown.</p>\n<h2 id="second-heading">Second Heading</h2>\n<ul>\n<li>Unordered lists, and:<ol>\n<li>One</li>\n<li>Two</li>\n<li>Three</li>\n</ol>\n</li>\n<li>More</li>\n</ul>\n<blockquote>\n<p>Blockquote</p>\n</blockquote>\n<p>And <strong>bold</strong>, <em>italics</em>, and even <em>italics and later <strong>bold</strong></em>. Even <del>strikethrough</del>. <a href="https://markdowntohtml.com">A link</a> to somewhere.</p>\n<p>And code highlighting:</p>\n<pre><code class="lang-js"><span class="hljs-keyword">var</span> foo = <span class="hljs-string">\'bar\'</span>;\n\n<span class="hljs-function"><span class="hljs-keyword">function</span> <span class="hljs-title">baz</span><span class="hljs-params">(s)</span> </span>{\n   <span class="hljs-keyword">return</span> foo + <span class="hljs-string">\':\'</span> + s;\n}\n</code></pre>\n<p>Or inline code like <code>var foo = &#39;bar&#39;;</code>.</p>\n<p>Or an image of bears</p>\n<p><img src="http://placebear.com/200/200" alt="bears"></p>\n<p>The end ...</p>\n"""\nprint(unmarkd.unmark(html_doc))\n```\nand the output:\n\n```markdown\n    # Sample Markdown\n\n\n    This is some basic, sample markdown.\n\n    ## Second Heading\n\n\n\n    - Unordered lists, and:\n     1. One\n     2. Two\n     3. Three\n    - More\n\n    >Blockquote\n\n\n    And **bold**, *italics*, and even *italics and later **bold***. Even ~~strikethrough~~. [A link](https://markdowntohtml.com) to somewhere.\n\n    And code highlighting:\n\n\n    ```js\n    var foo = \'bar\';\n\n    function baz(s) {\n       return foo + \':\' + s;\n    }\n    ```\n\n\n    Or inline code like `var foo = \'bar\';`.\n\n    Or an image of bears\n\n    ![bears](http://placebear.com/200/200)\n\n    The end ...\n```\n### Extending\n\n#### Brief Overview\n\nMost functionality should be covered by the `BasicUnmarker` class defined in `unmarkd.unmarkers`.\n\nIf you need to reverse markdown from StackExchange (as in the case for my other project), you may use the `StackOverflowUnmarker` (or it\'s alias, `StackExchangeUnmarker`), which is also defined in `unmarkd.unmarkers`.\n\n#### Customizing\n\nIf the above two classes do not suit your needs, you can subclass the `unmarkd.unmarkers.BaseUnmarker` abstract class.\n\nCurrently, you can *optionally* override the following methods:\n\n - `detect_language` (parameters: **1**)\n    - **Parameters**:\n        - html: `bs4.BeautifulSoup`\n    - When a fenced code block is approached, this function is called with a parameter of type `bs4.BeautifulSoup` passed to it; this is the element the code block was detected from (i.e. `pre`).\n    - This function is responsible for detecting the programming language (or returning `\'\'` if none was detected) of the code block.\n    - Note: This method is different from `unmarkd.unmarkers.BasicUnmarker`. It is simpler and does less checking/filtering\n\n\nBut Unmarkd is more flexible than that.\n\n##### Customizable constants\n\nThere are currently 3 constants you may override:\n - Formats:\n    NOTE: Use the [**Format String Syntax**](https://docs.python.org/3/library/string.html#formatstrings)\n     - `UNORDERED_FORMAT`\n        - The string format of unordered (bulleted) lists.\n     - `ORDERED_FORMAT`\n        -  The string format of ordered (numbered) lists.\n - Miscellaneous:\n     - `ESCAPABLES`\n        - A container (preferably a `set`) of length-1 `str` that should be escaped\n\n##### Customize converting HTML tags\n\nFor an HTML tag `some_tag`, you can customize how it\'s converted to markdown by overriding a method like so:\n\n```python\nfrom unmarkd.unmarkers import BaseUnmarker\nclass MyCustomUnmarker(BaseUnmarker):\n    def tag_some_tag(self, child) -> str:\n        ...  # parse code here\n```\n\nTo reduce code duplication, if your tag also has aliases (e.g. `strong` is an alias for `b` in HTML) then you may modify the `TAG_ALIASES`.\n\nIf you really need to, you may also modify `DEFAULT_TAG_ALIASES`. Be warned: if you do so, **you will also need to implement the aliases** (currently `em` and `strong`).\n\n##### Utility functions when overriding\n\nYou may use (when extending) the following functions:\n\n - `__parse`, 2 parameters:\n    - `html`: *bs4.BeautifulSoup*\n        - The html to unmark. This is used internally by the `unmark` method and is slightly faster.\n    - `escape`: *bool*\n        - Whether to escape the characters inside the string or not. Defaults to `False`.\n - `escape`: 1 parameter:\n    - `string`: *str*\n        - The string to escape and make markdown-safe\n - `wrap`: 2 parameters:\n    - `element`: *bs4.BeautifulSoup*\n        - The element to wrap.\n    - `around_with`: *str*\n        - The character to wrap the element around with. **WILL NOT BE ESCPAED**\n - And, of course, `tag_*` and `detect_language`.\n',
    'author': 'Bryan Hu',
    'author_email': 'bryan.hu.2020@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ThatXliner/unmarkd/tree/master',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
