# -*- coding: utf-8 -*-
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.translate import gapic_version as package_version

__version__ = package_version.__version__


from google.cloud.translate_v3.services.translation_service.async_client import (
    TranslationServiceAsyncClient,
)
from google.cloud.translate_v3.services.translation_service.client import (
    TranslationServiceClient,
)
from google.cloud.translate_v3.types.adaptive_mt import (
    AdaptiveMtDataset,
    AdaptiveMtFile,
    AdaptiveMtSentence,
    AdaptiveMtTranslateRequest,
    AdaptiveMtTranslateResponse,
    AdaptiveMtTranslation,
    CreateAdaptiveMtDatasetRequest,
    DeleteAdaptiveMtDatasetRequest,
    DeleteAdaptiveMtFileRequest,
    GetAdaptiveMtDatasetRequest,
    GetAdaptiveMtFileRequest,
    ImportAdaptiveMtFileRequest,
    ImportAdaptiveMtFileResponse,
    ListAdaptiveMtDatasetsRequest,
    ListAdaptiveMtDatasetsResponse,
    ListAdaptiveMtFilesRequest,
    ListAdaptiveMtFilesResponse,
    ListAdaptiveMtSentencesRequest,
    ListAdaptiveMtSentencesResponse,
)
from google.cloud.translate_v3.types.automl_translation import (
    BatchTransferResourcesResponse,
    CreateDatasetMetadata,
    CreateDatasetRequest,
    CreateModelMetadata,
    CreateModelRequest,
    Dataset,
    DatasetInputConfig,
    DatasetOutputConfig,
    DeleteDatasetMetadata,
    DeleteDatasetRequest,
    DeleteModelMetadata,
    DeleteModelRequest,
    Example,
    ExportDataMetadata,
    ExportDataRequest,
    GetDatasetRequest,
    GetModelRequest,
    ImportDataMetadata,
    ImportDataRequest,
    ListDatasetsRequest,
    ListDatasetsResponse,
    ListExamplesRequest,
    ListExamplesResponse,
    ListModelsRequest,
    ListModelsResponse,
    Model,
)
from google.cloud.translate_v3.types.common import (
    FileInputSource,
    GcsInputSource,
    GcsOutputDestination,
    GlossaryEntry,
    GlossaryTerm,
    OperationState,
)
from google.cloud.translate_v3.types.translation_service import (
    BatchDocumentInputConfig,
    BatchDocumentOutputConfig,
    BatchTranslateDocumentMetadata,
    BatchTranslateDocumentRequest,
    BatchTranslateDocumentResponse,
    BatchTranslateMetadata,
    BatchTranslateResponse,
    BatchTranslateTextRequest,
    CreateGlossaryEntryRequest,
    CreateGlossaryMetadata,
    CreateGlossaryRequest,
    DeleteGlossaryEntryRequest,
    DeleteGlossaryMetadata,
    DeleteGlossaryRequest,
    DeleteGlossaryResponse,
    DetectedLanguage,
    DetectLanguageRequest,
    DetectLanguageResponse,
    DocumentInputConfig,
    DocumentOutputConfig,
    DocumentTranslation,
    GcsDestination,
    GcsSource,
    GetGlossaryEntryRequest,
    GetGlossaryRequest,
    GetSupportedLanguagesRequest,
    Glossary,
    GlossaryInputConfig,
    InputConfig,
    ListGlossariesRequest,
    ListGlossariesResponse,
    ListGlossaryEntriesRequest,
    ListGlossaryEntriesResponse,
    OutputConfig,
    Romanization,
    RomanizeTextRequest,
    RomanizeTextResponse,
    SupportedLanguage,
    SupportedLanguages,
    TranslateDocumentRequest,
    TranslateDocumentResponse,
    TranslateTextGlossaryConfig,
    TranslateTextRequest,
    TranslateTextResponse,
    Translation,
    TransliterationConfig,
    UpdateGlossaryEntryRequest,
    UpdateGlossaryMetadata,
    UpdateGlossaryRequest,
)

__all__ = (
    "TranslationServiceClient",
    "TranslationServiceAsyncClient",
    "AdaptiveMtDataset",
    "AdaptiveMtFile",
    "AdaptiveMtSentence",
    "AdaptiveMtTranslateRequest",
    "AdaptiveMtTranslateResponse",
    "AdaptiveMtTranslation",
    "CreateAdaptiveMtDatasetRequest",
    "DeleteAdaptiveMtDatasetRequest",
    "DeleteAdaptiveMtFileRequest",
    "GetAdaptiveMtDatasetRequest",
    "GetAdaptiveMtFileRequest",
    "ImportAdaptiveMtFileRequest",
    "ImportAdaptiveMtFileResponse",
    "ListAdaptiveMtDatasetsRequest",
    "ListAdaptiveMtDatasetsResponse",
    "ListAdaptiveMtFilesRequest",
    "ListAdaptiveMtFilesResponse",
    "ListAdaptiveMtSentencesRequest",
    "ListAdaptiveMtSentencesResponse",
    "BatchTransferResourcesResponse",
    "CreateDatasetMetadata",
    "CreateDatasetRequest",
    "CreateModelMetadata",
    "CreateModelRequest",
    "Dataset",
    "DatasetInputConfig",
    "DatasetOutputConfig",
    "DeleteDatasetMetadata",
    "DeleteDatasetRequest",
    "DeleteModelMetadata",
    "DeleteModelRequest",
    "Example",
    "ExportDataMetadata",
    "ExportDataRequest",
    "GetDatasetRequest",
    "GetModelRequest",
    "ImportDataMetadata",
    "ImportDataRequest",
    "ListDatasetsRequest",
    "ListDatasetsResponse",
    "ListExamplesRequest",
    "ListExamplesResponse",
    "ListModelsRequest",
    "ListModelsResponse",
    "Model",
    "FileInputSource",
    "GcsInputSource",
    "GcsOutputDestination",
    "GlossaryEntry",
    "GlossaryTerm",
    "OperationState",
    "BatchDocumentInputConfig",
    "BatchDocumentOutputConfig",
    "BatchTranslateDocumentMetadata",
    "BatchTranslateDocumentRequest",
    "BatchTranslateDocumentResponse",
    "BatchTranslateMetadata",
    "BatchTranslateResponse",
    "BatchTranslateTextRequest",
    "CreateGlossaryEntryRequest",
    "CreateGlossaryMetadata",
    "CreateGlossaryRequest",
    "DeleteGlossaryEntryRequest",
    "DeleteGlossaryMetadata",
    "DeleteGlossaryRequest",
    "DeleteGlossaryResponse",
    "DetectedLanguage",
    "DetectLanguageRequest",
    "DetectLanguageResponse",
    "DocumentInputConfig",
    "DocumentOutputConfig",
    "DocumentTranslation",
    "GcsDestination",
    "GcsSource",
    "GetGlossaryEntryRequest",
    "GetGlossaryRequest",
    "GetSupportedLanguagesRequest",
    "Glossary",
    "GlossaryInputConfig",
    "InputConfig",
    "ListGlossariesRequest",
    "ListGlossariesResponse",
    "ListGlossaryEntriesRequest",
    "ListGlossaryEntriesResponse",
    "OutputConfig",
    "Romanization",
    "RomanizeTextRequest",
    "RomanizeTextResponse",
    "SupportedLanguage",
    "SupportedLanguages",
    "TranslateDocumentRequest",
    "TranslateDocumentResponse",
    "TranslateTextGlossaryConfig",
    "TranslateTextRequest",
    "TranslateTextResponse",
    "Translation",
    "TransliterationConfig",
    "UpdateGlossaryEntryRequest",
    "UpdateGlossaryMetadata",
    "UpdateGlossaryRequest",
)
