"""
************************************************************
meta.py - implementation detail meta information
************************************************************

Project: HALCON/Python

Description:
Information that gets generated by the build system.
Separate file to avoid slow iteration test cycle on changes to 'main' sources.

************************************************************

(c) 1996-2020 by MVTec Software GmbH

Software by: MVTec Software GmbH, www.mvtec.com
"""

__all__ = [
    'expected_halcon_version',
    'halcon_native_lib_names',
    'hdevengine_native_lib_names',
]

halcon_native_lib_names = {
    'linux': {
        'base': 'libhalcon.so.{}',
        'version': '22.11.1',
    },
    'darwin': {
        'base': 'HALCON.framework/Versions/{}/HALCON',
        'version': '22.11',
    },
    'win': 'halcon.dll',
}

expected_halcon_version = '22.11.1'

hdevengine_native_lib_names = {
    'linux': 'libhdevenginecpp.so.22.11.1',
    'darwin': 'HDevEngineCpp.framework/Versions/'
    '22.11/HDevEngineCpp',
    'win': 'hdevenginecpp.dll',
}
