# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pybotics']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=19.0', 'numpy>=1.20,<2.0', 'scipy>=1,<2']

extras_require = \
{':python_version >= "3.7" and python_version < "3.8"': ['typing-extensions>=4,<5']}

setup_kwargs = {
    'name': 'pybotics',
    'version': '2.0.1',
    'description': 'Python Toolbox for Robotics',
    'long_description': '# Pybotics\n\n![Robot arm logo](media/robotic-arm.png)\n\nThe Python Toolbox for Robotics\n\n- [Explore the docs](https://pybotics.readthedocs.io)\n- [View demos and examples](https://github.com/nnadeau/pybotics/tree/master/examples)\n- [Report a bug](https://github.com/nnadeau/pybotics/issues)\n- [Request a feature](https://github.com/nnadeau/pybotics/issues)\n\nItem | Badges\n---|---\nRepo | [![GitHub issues](https://img.shields.io/github/issues/nnadeau/pybotics.svg)](https://github.com/nnadeau/pybotics/issues) [![GitHub forks](https://img.shields.io/github/forks/nnadeau/pybotics.svg)](https://github.com/nnadeau/pybotics/network) [![GitHub stars](https://img.shields.io/github/stars/nnadeau/pybotics.svg)](https://github.com/nnadeau/pybotics/stargazers) ![GitHub repo size](https://img.shields.io/github/repo-size/engnadeau/pybotics)\nReleases | [![GitHub tag](https://img.shields.io/github/tag/nnadeau/pybotics.svg?maxAge=2592000?style=flat-square)](https://github.com/nnadeau/pybotics/releases) [![PyPI Version](https://img.shields.io/pypi/v/pybotics.svg)](https://pypi.python.org/pypi/pybotics) [![PyPI Wheel](https://img.shields.io/pypi/wheel/pybotics.svg)](https://pypi.python.org/pypi/pybotics) [![PyPI Format](https://img.shields.io/pypi/format/pybotics.svg)](https://pypi.python.org/pypi/pybotics) [![semantic-release](https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--release-e10079.svg)](https://github.com/semantic-release/semantic-release) ![PyPI - Downloads](https://img.shields.io/pypi/dm/pybotics)\nCompatibility | [![PyPI Pythons](https://img.shields.io/pypi/pyversions/pybotics.svg)](https://pypi.python.org/pypi/pybotics) [![PyPI Implementation](https://img.shields.io/pypi/implementation/pybotics.svg)](https://pypi.python.org/pypi/pybotics)\nWorkflows | [![Test](https://github.com/nnadeau/pybotics/workflows/Test/badge.svg)](https://github.com/nnadeau/pybotics/actions) [![Release](https://github.com/nnadeau/pybotics/workflows/Release/badge.svg)](https://github.com/nnadeau/pybotics/actions) [![Publish](https://github.com/nnadeau/pybotics/workflows/Publish/badge.svg)](https://github.com/nnadeau/pybotics/actions)\nDocumentation | [![Documentation Status](https://readthedocs.org/projects/pybotics/badge/?version=latest)](https://pybotics.readthedocs.io/en/latest/?badge=latest)\nCitations | [![DOI](https://joss.theoj.org/papers/10.21105/joss.01738/status.svg)](https://doi.org/10.21105/joss.01738) [![DOI](https://zenodo.org/badge/66797360.svg)](https://zenodo.org/badge/latestdoi/66797360)\nLicense | [![PyPI License](https://img.shields.io/pypi/l/pybotics.svg)](https://pypi.python.org/pypi/pybotics)\nSocial | ![Twitter Follow](https://img.shields.io/twitter/follow/engnadeau?style=social) [![Twitter](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Fgithub.com%2Fnnadeau%2Fpybotics)](https://twitter.com/intent/tweet?text=Wow:&url=https%3A%2F%2Fgithub.com%2Fnnadeau%2Fpybotics)\n\n## Contents\n\n- [Pybotics](#pybotics)\n  - [Contents](#contents)\n  - [Overview](#overview)\n  - [Usage](#usage)\n    - [Documentation](#documentation)\n    - [Installation](#installation)\n    - [Applications & Examples](#applications--examples)\n  - [Featured In](#featured-in)\n  - [Citing](#citing)\n  - [Development and Community Guidelines](#development-and-community-guidelines)\n    - [Local Development](#local-development)\n    - [Docker Development](#docker-development)\n    - [Dependency Management](#dependency-management)\n    - [Submit an Issue](#submit-an-issue)\n    - [Contributing](#contributing)\n    - [Testing](#testing)\n    - [GitHub Actions](#github-actions)\n\n## Overview\n\n`Pybotics` is an open-source Python toolbox for robot kinematics and calibration.\nIt was designed to provide a simple, clear, and concise interface to quickly simulate and evaluate common robot concepts, such as kinematics, dynamics, trajectory generations, and calibration.\nThe toolbox is specifically designed for use with the [Modified Denavit–Hartenberg parameters convention](https://en.wikipedia.org/wiki/Denavit%E2%80%93Hartenberg_parameters#Modified_DH_parameters).\n\n## Usage\n\n### Documentation\n\nPlease visit https://pybotics.readthedocs.io/\n\n### Installation\n\n```bash\n# python3 is mapped to pip or inside a venv\npip install pybotics\n\n# python3-pip\npip3 install pybotics\n\n# https://github.com/pypa/pipenv\npipenv install pybotics\n\n# https://github.com/sdispater/poetry\npoetry add pybotics\n```\n\n### Applications & Examples\n\n- [Basic Usage](examples/basic_usage.py)\n- [Kinematics](examples/kinematics.ipynb)\n- [Calibration](examples/calibration.ipynb)\n- [Trajectory and Path Planning](examples/trajectory_generation.ipynb)\n- [Machine Learning](examples/machine_learning.ipynb)\n- [Dynamics](examples/dynamics.ipynb)\n\n## Featured In\n\n- [Impedance Control Self-Calibration of a Collaborative Robot Using Kinematic Coupling](https://www.mdpi.com/2218-6581/8/2/33/htm)\n- [PyCon Canada 2017](https://2017.pycon.ca/schedule/53/)\n  - [Talk Photos](https://500px.com/nicholasnadeau/galleries/pycon-canada-2017)\n  - [Slides](https://github.com/nnadeau/pycon-canada-2017)\n- [Montreal-Python 2017](https://www.youtube.com/watch?v=wgKoGA69YXQ)\n\n## Citing\n\nPlease cite the following articles if you use `pybotics` in your research:\n\n> Nadeau, (2019). Pybotics: Python Toolbox for Robotics. Journal of Open Source Software, 4(41), 1738, https://doi.org/10.21105/joss.01738\n\n```\n@article{nadeau2019pybotics,\n  doi = {10.21105/joss.01738},\n  url = {https://doi.org/10.21105/joss.01738},\n  year = {2019},\n  month = sep,\n  publisher = {The Open Journal},\n  volume = {4},\n  number = {41},\n  pages = {1738},\n  author = {Nicholas Nadeau},\n  title = {Pybotics: Python Toolbox for Robotics},\n  journal = {Journal of Open Source Software}\n}\n```\n\n> Nadeau, Nicholas A., Ilian A. Bonev, and Ahmed Joubair. "Impedance Control Self-Calibration of a Collaborative Robot Using Kinematic Coupling." Robotics 8.2 (2019): 33.\n\n```\n@article{nadeau2019impedance,\n  title={Impedance Control Self-Calibration of a Collaborative Robot Using Kinematic Coupling},\n  volume={8},\n  ISSN={2218-6581},\n  url={http://dx.doi.org/10.3390/robotics8020033},\n  DOI={10.3390/robotics8020033},\n  number={2},\n  journal={Robotics},\n  publisher={MDPI AG},\n  author={Nadeau, Nicholas A. and Bonev, Ilian A. and Joubair, Ahmed},\n  year={2019},\n  month={Apr},\n  pages={33}\n}\n```\n\n## Development and Community Guidelines\n\n### Local Development\n\n- Use [poetry](https://python-poetry.org/) to install the dev virtual environment:\n\n```bash\npoetry install\n```\n\n### Docker Development\n\n- Docker is a great tool to test the package in an isolated environment\n- It is especially useful for debugging issues between python versions\n\n```bash\n# launch container attached to current directory\ndocker run -v $(pwd):/$(basename $(pwd)) -w /$(basename $(pwd)) -it python:3 bash\n\n# install deps\npip install poetry\npoetry install\n\n# run tests\nmake test\n```\n\n### Dependency Management\n\n```bash\n# refresh lock file\npoetry lock --no-update\n```\n\n### Submit an Issue\n\n- Navigate to the repository\'s [issue tab](https://github.com/nnadeau/pybotics/issues)\n- Search for related existing issues\n- If necessary, create a new issue using the provided templates\n\n### Contributing\n\n- Please see [`CONTRIBUTING.md`](.github/CONTRIBUTING.md) and the [Code of Conduct](CODE_OF_CONDUCT.md) for how to contribute to the project\n\n### Testing\n\n- Please review the [`Makefile`](Makefile) for an overview of all available tests\n- The most important tests and `make` commands are highlighted below:\n\n```bash\n# auto-format code\nmake format\n\n# perform all static tests\nmake lint\n\n# run all python tests\nmake test\n```\n\n### GitHub Actions\n\n- This repo uses [`semantic-releases`](https://github.com/semantic-release/) to generate releases and release notes automatically from commits\n  - A [`PERSONAL_TOKEN` Actions secret](https://github.com/nnadeau/pybotics/settings/secrets/actions) from a [Personal Token](https://github.com/settings/tokens) with a [`public_repo` scope](https://github.com/semantic-release/github#github-authentication) is needed for CI releases\n\n---\n\nIcons made by <a href="https://icon54.com/" title="Pixel perfect">Pixel perfect</a> from <a href="https://www.flaticon.com/" title="Flaticon"> www.flaticon.com</a>\n',
    'author': 'Nicholas Nadeau',
    'author_email': 'nicholas.nadeau@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/engnadeau/pybotics',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
