"use strict";
const core_1 = require("@aws-cdk/core");
const ec2 = require("../lib");
let app;
let stack;
function isWindowsUserData(ud) {
    return ud.render().indexOf('powershell') > -1;
}
function isLinuxUserData(ud) {
    return ud.render().indexOf('bash') > -1;
}
module.exports = {
    'setUp'(cb) {
        app = new core_1.App();
        stack = new core_1.Stack(app, 'Stack', {
            env: { account: '1234', region: 'testregion' }
        });
        cb();
    },
    'can make and use a Windows image'(test) {
        // WHEN
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234'
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.imageId, 'ami-1234');
        test.equals(details.osType, ec2.OperatingSystemType.WINDOWS);
        test.done();
    },
    'WindowsImage retains userdata if given'(test) {
        // WHEN
        const ud = ec2.UserData.forWindows();
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234',
        }, {
            userData: ud
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.userData, ud);
        test.done();
    },
    'WindowsImage creates UserData if not given'(test) {
        // WHEN
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234',
        });
        // THEN
        const details = image.getImage(stack);
        test.ok(isWindowsUserData(details.userData));
        test.done();
    },
    'LookupMachineImage default search'(test) {
        // GIVEN
        // WHEN
        new ec2.LookupMachineImage({ name: 'bla*', owners: ['amazon'] }).getImage(stack);
        // THEN
        const missing = app.synth().manifest.missing || [];
        test.deepEqual(missing, [
            {
                key: 'ami:account=1234:filters.image-type.0=machine:filters.name.0=bla*:filters.state.0=available:owners.0=amazon:region=testregion',
                props: {
                    account: '1234',
                    region: 'testregion',
                    owners: ['amazon'],
                    filters: {
                        'name': ['bla*'],
                        'state': ['available'],
                        'image-type': ['machine']
                    }
                },
                provider: 'ami'
            }
        ]);
        test.done();
    },
    'LookupMachineImage creates correct type of UserData'(test) {
        // WHEN
        const linuxDetails = new ec2.LookupMachineImage({ name: 'bla*', owners: ['amazon'] }).getImage(stack);
        const windowsDetails = new ec2.LookupMachineImage({ name: 'bla*', owners: ['amazon'], windows: true }).getImage(stack);
        // THEN
        test.ok(isWindowsUserData(windowsDetails.userData));
        test.ok(isLinuxUserData(linuxDetails.userData));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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