"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
class TestStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const vpc = new lib_1.Vpc(this, 'VPC');
        new lib_1.FlowLog(this, 'FlowLogsCW', {
            resourceType: lib_1.FlowLogResourceType.fromVpc(vpc)
        });
        vpc.addFlowLog('FlowLogsS3', {
            destination: lib_1.FlowLogDestination.toS3(),
        });
    }
}
new TestStack(app, 'TestStack');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudnBjLWZsb3ctbG9ncy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLnZwYy1mbG93LWxvZ3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQkFBZ0I7QUFDaEIsd0NBQXVEO0FBQ3ZELGdDQUErRTtBQUUvRSxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sU0FBVSxTQUFRLFlBQUs7SUFDM0IsWUFBWSxLQUFVLEVBQUUsRUFBVSxFQUFFLEtBQWtCO1FBQ3BELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLE1BQU0sR0FBRyxHQUFHLElBQUksU0FBRyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQztRQUVqQyxJQUFJLGFBQU8sQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQzlCLFlBQVksRUFBRSx5QkFBbUIsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDO1NBQy9DLENBQUMsQ0FBQztRQUVILEdBQUcsQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFO1lBQzNCLFdBQVcsRUFBRSx3QkFBa0IsQ0FBQyxJQUFJLEVBQUU7U0FDdkMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBRUQsSUFBSSxTQUFTLENBQUMsR0FBRyxFQUFFLFdBQVcsQ0FBQyxDQUFDO0FBRWhDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vLyAhY2RrLWludGVnICpcbmltcG9ydCB7IEFwcCwgU3RhY2ssIFN0YWNrUHJvcHMgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEZsb3dMb2csIEZsb3dMb2dEZXN0aW5hdGlvbiwgRmxvd0xvZ1Jlc291cmNlVHlwZSwgVnBjIH0gZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jbGFzcyBUZXN0U3RhY2sgZXh0ZW5kcyBTdGFjayB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBBcHAsIGlkOiBzdHJpbmcsIHByb3BzPzogU3RhY2tQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgY29uc3QgdnBjID0gbmV3IFZwYyh0aGlzLCAnVlBDJyk7XG5cbiAgICBuZXcgRmxvd0xvZyh0aGlzLCAnRmxvd0xvZ3NDVycsIHtcbiAgICAgIHJlc291cmNlVHlwZTogRmxvd0xvZ1Jlc291cmNlVHlwZS5mcm9tVnBjKHZwYylcbiAgICB9KTtcblxuICAgIHZwYy5hZGRGbG93TG9nKCdGbG93TG9nc1MzJywge1xuICAgICAgZGVzdGluYXRpb246IEZsb3dMb2dEZXN0aW5hdGlvbi50b1MzKCksXG4gICAgfSk7XG4gIH1cbn1cblxubmV3IFRlc3RTdGFjayhhcHAsICdUZXN0U3RhY2snKTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=