"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const paidswapi_generated_1 = require("./paidswapi.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return paidswapi_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::PaiDswApi::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::PaiDswApi::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new paidswapi_generated_1.RosInstance(this, id, {
            datasets: props.datasets,
            instanceName: props.instanceName,
            environmentVariables: props.environmentVariables,
            accessibility: props.accessibility,
            workspaceId: props.workspaceId,
            imageUrl: props.imageUrl,
            ecsSpec: props.ecsSpec,
            labels: props.labels,
            saveImage: props.saveImage,
            userVpc: props.userVpc,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrAccessibility = rosInstance.attrAccessibility;
        this.attrDatasets = rosInstance.attrDatasets;
        this.attrEcsSpec = rosInstance.attrEcsSpec;
        this.attrEnvironmentVariables = rosInstance.attrEnvironmentVariables;
        this.attrImageUrl = rosInstance.attrImageUrl;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrInstanceUrl = rosInstance.attrInstanceUrl;
        this.attrJupyterlabUrl = rosInstance.attrJupyterlabUrl;
        this.attrLabels = rosInstance.attrLabels;
        this.attrPaymentType = rosInstance.attrPaymentType;
        this.attrTerminalUrl = rosInstance.attrTerminalUrl;
        this.attrUserVpc = rosInstance.attrUserVpc;
        this.attrWebIdeUrl = rosInstance.attrWebIdeUrl;
        this.attrWorkspaceId = rosInstance.attrWorkspaceId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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