# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class VPCRouter(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    The description of the VPCRouter. The length of this value must be in the range [`1`-`512`]
    """
    dhcp_servers: pulumi.Output[list]
    dhcp_static_mappings: pulumi.Output[list]
    firewalls: pulumi.Output[list]
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the VPCRouter
    """
    internet_connection: pulumi.Output[bool]
    """
    The flag to enable connecting to the Internet from the VPC Router
    """
    l2tp: pulumi.Output[dict]
    name: pulumi.Output[str]
    """
    The name of the VPCRouter. The length of this value must be in the range [`1`-`64`]
    """
    plan: pulumi.Output[str]
    """
    The plan name of the VPCRouter. This must be one of [`standard`/`premium`/`highspec`/`highspec4000`]
    """
    port_forwardings: pulumi.Output[list]
    pptp: pulumi.Output[dict]
    private_network_interfaces: pulumi.Output[list]
    """
    A list of additional network interface setting. This doesn't include primary network interface setting

      * `index` (`float`)
      * `ip_addresses` (`list`)
      * `netmask` (`float`)
      * `switch_id` (`str`)
      * `vip` (`str`)
    """
    public_ip: pulumi.Output[str]
    """
    The public ip address of the VPC Router
    """
    public_netmask: pulumi.Output[float]
    """
    The bit length of the subnet to assign to the public network interface
    """
    public_network_interface: pulumi.Output[dict]
    site_to_site_vpns: pulumi.Output[list]
    static_nats: pulumi.Output[list]
    static_routes: pulumi.Output[list]
    syslog_host: pulumi.Output[str]
    """
    The ip address of the syslog host to which the VPC Router sends logs
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the VPCRouter
    """
    users: pulumi.Output[list]
    zone: pulumi.Output[str]
    """
    The name of zone that the VPCRouter will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, description=None, dhcp_servers=None, dhcp_static_mappings=None, firewalls=None, icon_id=None, internet_connection=None, l2tp=None, name=None, plan=None, port_forwardings=None, pptp=None, private_network_interfaces=None, public_network_interface=None, site_to_site_vpns=None, static_nats=None, static_routes=None, syslog_host=None, tags=None, users=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a VPCRouter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the VPCRouter. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] icon_id: The icon id to attach to the VPCRouter
        :param pulumi.Input[bool] internet_connection: The flag to enable connecting to the Internet from the VPC Router
        :param pulumi.Input[str] name: The name of the VPCRouter. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] plan: The plan name of the VPCRouter. This must be one of [`standard`/`premium`/`highspec`/`highspec4000`]
        :param pulumi.Input[list] private_network_interfaces: A list of additional network interface setting. This doesn't include primary network interface setting
        :param pulumi.Input[str] syslog_host: The ip address of the syslog host to which the VPC Router sends logs
        :param pulumi.Input[list] tags: Any tags to assign to the VPCRouter
        :param pulumi.Input[str] zone: The name of zone that the VPCRouter will be created (e.g. `is1a`, `tk1a`)

        The **dhcp_servers** object supports the following:

          * `dns_servers` (`pulumi.Input[list]`)
          * `interfaceIndex` (`pulumi.Input[float]`)
          * `rangeStart` (`pulumi.Input[str]`)
          * `rangeStop` (`pulumi.Input[str]`)

        The **dhcp_static_mappings** object supports the following:

          * `ip_address` (`pulumi.Input[str]`)
          * `macAddress` (`pulumi.Input[str]`)

        The **firewalls** object supports the following:

          * `direction` (`pulumi.Input[str]`)
          * `expressions` (`pulumi.Input[list]`)
            * `allow` (`pulumi.Input[bool]`)
            * `description` (`pulumi.Input[str]`)
            * `destinationNetwork` (`pulumi.Input[str]`)
            * `destinationPort` (`pulumi.Input[str]`)
            * `logging` (`pulumi.Input[bool]`)
            * `protocol` (`pulumi.Input[str]`)
            * `sourceNetwork` (`pulumi.Input[str]`)
            * `sourcePort` (`pulumi.Input[str]`)

          * `interfaceIndex` (`pulumi.Input[float]`)

        The **l2tp** object supports the following:

          * `preSharedSecret` (`pulumi.Input[str]`)
          * `rangeStart` (`pulumi.Input[str]`)
          * `rangeStop` (`pulumi.Input[str]`)

        The **port_forwardings** object supports the following:

          * `description` (`pulumi.Input[str]`)
          * `privateIp` (`pulumi.Input[str]`)
          * `privatePort` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)
          * `publicPort` (`pulumi.Input[float]`)

        The **pptp** object supports the following:

          * `rangeStart` (`pulumi.Input[str]`)
          * `rangeStop` (`pulumi.Input[str]`)

        The **private_network_interfaces** object supports the following:

          * `index` (`pulumi.Input[float]`)
          * `ip_addresses` (`pulumi.Input[list]`)
          * `netmask` (`pulumi.Input[float]`)
          * `switch_id` (`pulumi.Input[str]`)
          * `vip` (`pulumi.Input[str]`)

        The **public_network_interface** object supports the following:

          * `aliases` (`pulumi.Input[list]`)
          * `ip_addresses` (`pulumi.Input[list]`)
          * `switch_id` (`pulumi.Input[str]`)
          * `vip` (`pulumi.Input[str]`)
          * `vrid` (`pulumi.Input[float]`)

        The **site_to_site_vpns** object supports the following:

          * `localPrefixes` (`pulumi.Input[list]`)
          * `peer` (`pulumi.Input[str]`)
          * `preSharedSecret` (`pulumi.Input[str]`)
          * `remoteId` (`pulumi.Input[str]`)
          * `routes` (`pulumi.Input[list]`)

        The **static_nats** object supports the following:

          * `description` (`pulumi.Input[str]`)
          * `privateIp` (`pulumi.Input[str]`)
          * `public_ip` (`pulumi.Input[str]`)

        The **static_routes** object supports the following:

          * `next_hop` (`pulumi.Input[str]`)
          * `prefix` (`pulumi.Input[str]`)

        The **users** object supports the following:

          * `name` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['dhcp_servers'] = dhcp_servers
            __props__['dhcp_static_mappings'] = dhcp_static_mappings
            __props__['firewalls'] = firewalls
            __props__['icon_id'] = icon_id
            __props__['internet_connection'] = internet_connection
            __props__['l2tp'] = l2tp
            __props__['name'] = name
            __props__['plan'] = plan
            __props__['port_forwardings'] = port_forwardings
            __props__['pptp'] = pptp
            __props__['private_network_interfaces'] = private_network_interfaces
            __props__['public_network_interface'] = public_network_interface
            __props__['site_to_site_vpns'] = site_to_site_vpns
            __props__['static_nats'] = static_nats
            __props__['static_routes'] = static_routes
            __props__['syslog_host'] = syslog_host
            __props__['tags'] = tags
            __props__['users'] = users
            __props__['zone'] = zone
            __props__['public_ip'] = None
            __props__['public_netmask'] = None
        super(VPCRouter, __self__).__init__(
            'sakuracloud:index/vPCRouter:VPCRouter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, dhcp_servers=None, dhcp_static_mappings=None, firewalls=None, icon_id=None, internet_connection=None, l2tp=None, name=None, plan=None, port_forwardings=None, pptp=None, private_network_interfaces=None, public_ip=None, public_netmask=None, public_network_interface=None, site_to_site_vpns=None, static_nats=None, static_routes=None, syslog_host=None, tags=None, users=None, zone=None):
        """
        Get an existing VPCRouter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the VPCRouter. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] icon_id: The icon id to attach to the VPCRouter
        :param pulumi.Input[bool] internet_connection: The flag to enable connecting to the Internet from the VPC Router
        :param pulumi.Input[str] name: The name of the VPCRouter. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] plan: The plan name of the VPCRouter. This must be one of [`standard`/`premium`/`highspec`/`highspec4000`]
        :param pulumi.Input[list] private_network_interfaces: A list of additional network interface setting. This doesn't include primary network interface setting
        :param pulumi.Input[str] public_ip: The public ip address of the VPC Router
        :param pulumi.Input[float] public_netmask: The bit length of the subnet to assign to the public network interface
        :param pulumi.Input[str] syslog_host: The ip address of the syslog host to which the VPC Router sends logs
        :param pulumi.Input[list] tags: Any tags to assign to the VPCRouter
        :param pulumi.Input[str] zone: The name of zone that the VPCRouter will be created (e.g. `is1a`, `tk1a`)

        The **dhcp_servers** object supports the following:

          * `dns_servers` (`pulumi.Input[list]`)
          * `interfaceIndex` (`pulumi.Input[float]`)
          * `rangeStart` (`pulumi.Input[str]`)
          * `rangeStop` (`pulumi.Input[str]`)

        The **dhcp_static_mappings** object supports the following:

          * `ip_address` (`pulumi.Input[str]`)
          * `macAddress` (`pulumi.Input[str]`)

        The **firewalls** object supports the following:

          * `direction` (`pulumi.Input[str]`)
          * `expressions` (`pulumi.Input[list]`)
            * `allow` (`pulumi.Input[bool]`)
            * `description` (`pulumi.Input[str]`)
            * `destinationNetwork` (`pulumi.Input[str]`)
            * `destinationPort` (`pulumi.Input[str]`)
            * `logging` (`pulumi.Input[bool]`)
            * `protocol` (`pulumi.Input[str]`)
            * `sourceNetwork` (`pulumi.Input[str]`)
            * `sourcePort` (`pulumi.Input[str]`)

          * `interfaceIndex` (`pulumi.Input[float]`)

        The **l2tp** object supports the following:

          * `preSharedSecret` (`pulumi.Input[str]`)
          * `rangeStart` (`pulumi.Input[str]`)
          * `rangeStop` (`pulumi.Input[str]`)

        The **port_forwardings** object supports the following:

          * `description` (`pulumi.Input[str]`)
          * `privateIp` (`pulumi.Input[str]`)
          * `privatePort` (`pulumi.Input[float]`)
          * `protocol` (`pulumi.Input[str]`)
          * `publicPort` (`pulumi.Input[float]`)

        The **pptp** object supports the following:

          * `rangeStart` (`pulumi.Input[str]`)
          * `rangeStop` (`pulumi.Input[str]`)

        The **private_network_interfaces** object supports the following:

          * `index` (`pulumi.Input[float]`)
          * `ip_addresses` (`pulumi.Input[list]`)
          * `netmask` (`pulumi.Input[float]`)
          * `switch_id` (`pulumi.Input[str]`)
          * `vip` (`pulumi.Input[str]`)

        The **public_network_interface** object supports the following:

          * `aliases` (`pulumi.Input[list]`)
          * `ip_addresses` (`pulumi.Input[list]`)
          * `switch_id` (`pulumi.Input[str]`)
          * `vip` (`pulumi.Input[str]`)
          * `vrid` (`pulumi.Input[float]`)

        The **site_to_site_vpns** object supports the following:

          * `localPrefixes` (`pulumi.Input[list]`)
          * `peer` (`pulumi.Input[str]`)
          * `preSharedSecret` (`pulumi.Input[str]`)
          * `remoteId` (`pulumi.Input[str]`)
          * `routes` (`pulumi.Input[list]`)

        The **static_nats** object supports the following:

          * `description` (`pulumi.Input[str]`)
          * `privateIp` (`pulumi.Input[str]`)
          * `public_ip` (`pulumi.Input[str]`)

        The **static_routes** object supports the following:

          * `next_hop` (`pulumi.Input[str]`)
          * `prefix` (`pulumi.Input[str]`)

        The **users** object supports the following:

          * `name` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["dhcp_servers"] = dhcp_servers
        __props__["dhcp_static_mappings"] = dhcp_static_mappings
        __props__["firewalls"] = firewalls
        __props__["icon_id"] = icon_id
        __props__["internet_connection"] = internet_connection
        __props__["l2tp"] = l2tp
        __props__["name"] = name
        __props__["plan"] = plan
        __props__["port_forwardings"] = port_forwardings
        __props__["pptp"] = pptp
        __props__["private_network_interfaces"] = private_network_interfaces
        __props__["public_ip"] = public_ip
        __props__["public_netmask"] = public_netmask
        __props__["public_network_interface"] = public_network_interface
        __props__["site_to_site_vpns"] = site_to_site_vpns
        __props__["static_nats"] = static_nats
        __props__["static_routes"] = static_routes
        __props__["syslog_host"] = syslog_host
        __props__["tags"] = tags
        __props__["users"] = users
        __props__["zone"] = zone
        return VPCRouter(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

