# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Server(pulumi.CustomResource):
    cdrom_id: pulumi.Output[str]
    """
    The id of the CD-ROM to attach to the Server
    """
    commitment: pulumi.Output[str]
    """
    The policy of how to allocate virtual CPUs to the server. This must be one of [`standard`/`dedicatedcpu`]
    """
    core: pulumi.Output[float]
    """
    The number of virtual CPUs
    """
    description: pulumi.Output[str]
    """
    The description of the Server. The length of this value must be in the range [`1`-`512`]
    """
    disk_edit_parameter: pulumi.Output[dict]
    disks: pulumi.Output[list]
    """
    A list of disk id connected to the server
    """
    dns_servers: pulumi.Output[list]
    """
    A list of IP address of DNS server in the zone
    """
    force_shutdown: pulumi.Output[bool]
    """
    The flag to use force shutdown when need to reboot/shutdown while applying
    """
    gateway: pulumi.Output[str]
    """
    The IP address of the gateway used by Server
    """
    hostname: pulumi.Output[str]
    """
    The hostname of the Server
    """
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the Server
    """
    interface_driver: pulumi.Output[str]
    """
    The driver name of network interface. This must be one of [`virtio`/`e1000`]
    """
    ip_address: pulumi.Output[str]
    """
    The IP address assigned to the Server
    """
    memory: pulumi.Output[float]
    """
    The size of memory in GiB
    """
    name: pulumi.Output[str]
    """
    The name of the Server. The length of this value must be in the range [`1`-`64`]
    """
    netmask: pulumi.Output[float]
    """
    The bit length of the subnet assigned to the Server
    """
    network_address: pulumi.Output[str]
    """
    The network address which the `ip_address` belongs
    """
    network_interfaces: pulumi.Output[list]
    private_host_id: pulumi.Output[str]
    """
    The id of the PrivateHost which the Server is assigned
    """
    private_host_name: pulumi.Output[str]
    """
    The id of the PrivateHost which the Server is assigned
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the Server
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the Server will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, cdrom_id=None, commitment=None, core=None, description=None, disk_edit_parameter=None, disks=None, force_shutdown=None, icon_id=None, interface_driver=None, memory=None, name=None, network_interfaces=None, private_host_id=None, tags=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Server resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cdrom_id: The id of the CD-ROM to attach to the Server
        :param pulumi.Input[str] commitment: The policy of how to allocate virtual CPUs to the server. This must be one of [`standard`/`dedicatedcpu`]
        :param pulumi.Input[float] core: The number of virtual CPUs
        :param pulumi.Input[str] description: The description of the Server. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[list] disks: A list of disk id connected to the server
        :param pulumi.Input[bool] force_shutdown: The flag to use force shutdown when need to reboot/shutdown while applying
        :param pulumi.Input[str] icon_id: The icon id to attach to the Server
        :param pulumi.Input[str] interface_driver: The driver name of network interface. This must be one of [`virtio`/`e1000`]
        :param pulumi.Input[float] memory: The size of memory in GiB
        :param pulumi.Input[str] name: The name of the Server. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] private_host_id: The id of the PrivateHost which the Server is assigned
        :param pulumi.Input[list] tags: Any tags to assign to the Server
        :param pulumi.Input[str] zone: The name of zone that the Server will be created (e.g. `is1a`, `tk1a`)

        The **disk_edit_parameter** object supports the following:

          * `changePartitionUuid` (`pulumi.Input[bool]`)
          * `disablePwAuth` (`pulumi.Input[bool]`)
          * `enableDhcp` (`pulumi.Input[bool]`)
          * `gateway` (`pulumi.Input[str]`)
          * `hostname` (`pulumi.Input[str]`)
          * `ip_address` (`pulumi.Input[str]`)
          * `netmask` (`pulumi.Input[float]`)
          * `noteIds` (`pulumi.Input[list]`)
          * `password` (`pulumi.Input[str]`)
          * `sshKeyIds` (`pulumi.Input[list]`)

        The **network_interfaces** object supports the following:

          * `macAddress` (`pulumi.Input[str]`)
          * `packet_filter_id` (`pulumi.Input[str]`)
          * `upstream` (`pulumi.Input[str]`)
          * `userIpAddress` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cdrom_id'] = cdrom_id
            __props__['commitment'] = commitment
            __props__['core'] = core
            __props__['description'] = description
            __props__['disk_edit_parameter'] = disk_edit_parameter
            __props__['disks'] = disks
            __props__['force_shutdown'] = force_shutdown
            __props__['icon_id'] = icon_id
            __props__['interface_driver'] = interface_driver
            __props__['memory'] = memory
            __props__['name'] = name
            __props__['network_interfaces'] = network_interfaces
            __props__['private_host_id'] = private_host_id
            __props__['tags'] = tags
            __props__['zone'] = zone
            __props__['dns_servers'] = None
            __props__['gateway'] = None
            __props__['hostname'] = None
            __props__['ip_address'] = None
            __props__['netmask'] = None
            __props__['network_address'] = None
            __props__['private_host_name'] = None
        super(Server, __self__).__init__(
            'sakuracloud:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, cdrom_id=None, commitment=None, core=None, description=None, disk_edit_parameter=None, disks=None, dns_servers=None, force_shutdown=None, gateway=None, hostname=None, icon_id=None, interface_driver=None, ip_address=None, memory=None, name=None, netmask=None, network_address=None, network_interfaces=None, private_host_id=None, private_host_name=None, tags=None, zone=None):
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cdrom_id: The id of the CD-ROM to attach to the Server
        :param pulumi.Input[str] commitment: The policy of how to allocate virtual CPUs to the server. This must be one of [`standard`/`dedicatedcpu`]
        :param pulumi.Input[float] core: The number of virtual CPUs
        :param pulumi.Input[str] description: The description of the Server. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[list] disks: A list of disk id connected to the server
        :param pulumi.Input[list] dns_servers: A list of IP address of DNS server in the zone
        :param pulumi.Input[bool] force_shutdown: The flag to use force shutdown when need to reboot/shutdown while applying
        :param pulumi.Input[str] gateway: The IP address of the gateway used by Server
        :param pulumi.Input[str] hostname: The hostname of the Server
        :param pulumi.Input[str] icon_id: The icon id to attach to the Server
        :param pulumi.Input[str] interface_driver: The driver name of network interface. This must be one of [`virtio`/`e1000`]
        :param pulumi.Input[str] ip_address: The IP address assigned to the Server
        :param pulumi.Input[float] memory: The size of memory in GiB
        :param pulumi.Input[str] name: The name of the Server. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[float] netmask: The bit length of the subnet assigned to the Server
        :param pulumi.Input[str] network_address: The network address which the `ip_address` belongs
        :param pulumi.Input[str] private_host_id: The id of the PrivateHost which the Server is assigned
        :param pulumi.Input[str] private_host_name: The id of the PrivateHost which the Server is assigned
        :param pulumi.Input[list] tags: Any tags to assign to the Server
        :param pulumi.Input[str] zone: The name of zone that the Server will be created (e.g. `is1a`, `tk1a`)

        The **disk_edit_parameter** object supports the following:

          * `changePartitionUuid` (`pulumi.Input[bool]`)
          * `disablePwAuth` (`pulumi.Input[bool]`)
          * `enableDhcp` (`pulumi.Input[bool]`)
          * `gateway` (`pulumi.Input[str]`)
          * `hostname` (`pulumi.Input[str]`)
          * `ip_address` (`pulumi.Input[str]`)
          * `netmask` (`pulumi.Input[float]`)
          * `noteIds` (`pulumi.Input[list]`)
          * `password` (`pulumi.Input[str]`)
          * `sshKeyIds` (`pulumi.Input[list]`)

        The **network_interfaces** object supports the following:

          * `macAddress` (`pulumi.Input[str]`)
          * `packet_filter_id` (`pulumi.Input[str]`)
          * `upstream` (`pulumi.Input[str]`)
          * `userIpAddress` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cdrom_id"] = cdrom_id
        __props__["commitment"] = commitment
        __props__["core"] = core
        __props__["description"] = description
        __props__["disk_edit_parameter"] = disk_edit_parameter
        __props__["disks"] = disks
        __props__["dns_servers"] = dns_servers
        __props__["force_shutdown"] = force_shutdown
        __props__["gateway"] = gateway
        __props__["hostname"] = hostname
        __props__["icon_id"] = icon_id
        __props__["interface_driver"] = interface_driver
        __props__["ip_address"] = ip_address
        __props__["memory"] = memory
        __props__["name"] = name
        __props__["netmask"] = netmask
        __props__["network_address"] = network_address
        __props__["network_interfaces"] = network_interfaces
        __props__["private_host_id"] = private_host_id
        __props__["private_host_name"] = private_host_name
        __props__["tags"] = tags
        __props__["zone"] = zone
        return Server(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

