# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class DNSRecord(pulumi.CustomResource):
    dns_id: pulumi.Output[str]
    """
    The id of the DNS resource
    """
    name: pulumi.Output[str]
    """
    The name of the DNS Record resource
    """
    port: pulumi.Output[float]
    """
    The number of port. This must be in the range [`1`-`65535`]
    """
    priority: pulumi.Output[float]
    """
    The priority of target DNS Record. This must be in the range [`0`-`65535`]
    """
    ttl: pulumi.Output[float]
    """
    The number of the TTL
    """
    type: pulumi.Output[str]
    """
    The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`]
    """
    value: pulumi.Output[str]
    """
    The value of the DNS Record
    """
    weight: pulumi.Output[float]
    """
    The weight of target DNS Record. This must be in the range [`0`-`65535`]
    """
    def __init__(__self__, resource_name, opts=None, dns_id=None, name=None, port=None, priority=None, ttl=None, type=None, value=None, weight=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a DNSRecord resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_id: The id of the DNS resource
        :param pulumi.Input[str] name: The name of the DNS Record resource
        :param pulumi.Input[float] port: The number of port. This must be in the range [`1`-`65535`]
        :param pulumi.Input[float] priority: The priority of target DNS Record. This must be in the range [`0`-`65535`]
        :param pulumi.Input[float] ttl: The number of the TTL
        :param pulumi.Input[str] type: The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`]
        :param pulumi.Input[str] value: The value of the DNS Record
        :param pulumi.Input[float] weight: The weight of target DNS Record. This must be in the range [`0`-`65535`]
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if dns_id is None:
                raise TypeError("Missing required property 'dns_id'")
            __props__['dns_id'] = dns_id
            __props__['name'] = name
            __props__['port'] = port
            __props__['priority'] = priority
            __props__['ttl'] = ttl
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            if value is None:
                raise TypeError("Missing required property 'value'")
            __props__['value'] = value
            __props__['weight'] = weight
        super(DNSRecord, __self__).__init__(
            'sakuracloud:index/dNSRecord:DNSRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, dns_id=None, name=None, port=None, priority=None, ttl=None, type=None, value=None, weight=None):
        """
        Get an existing DNSRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_id: The id of the DNS resource
        :param pulumi.Input[str] name: The name of the DNS Record resource
        :param pulumi.Input[float] port: The number of port. This must be in the range [`1`-`65535`]
        :param pulumi.Input[float] priority: The priority of target DNS Record. This must be in the range [`0`-`65535`]
        :param pulumi.Input[float] ttl: The number of the TTL
        :param pulumi.Input[str] type: The type of DNS Record. This must be one of [`A`/`AAAA`/`ALIAS`/`CNAME`/`NS`/`MX`/`TXT`/`SRV`/`CAA`/`PTR`]
        :param pulumi.Input[str] value: The value of the DNS Record
        :param pulumi.Input[float] weight: The weight of target DNS Record. This must be in the range [`0`-`65535`]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["dns_id"] = dns_id
        __props__["name"] = name
        __props__["port"] = port
        __props__["priority"] = priority
        __props__["ttl"] = ttl
        __props__["type"] = type
        __props__["value"] = value
        __props__["weight"] = weight
        return DNSRecord(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

