# Changelog

## [0.5.1](https://github.com/BlueBrain/diameter-synthesis/compare/0.5.0..0.5.1)

> 22 August 2022

## [0.5.0](https://github.com/BlueBrain/diameter-synthesis/compare/0.4.2..0.5.0)

> 19 August 2022

### Chores And Housekeeping

- Use importlib instead of pkg_resources (Adrien Berchet - [#27](https://github.com/BlueBrain/diameter-synthesis/pull/27))

### CI Improvements

- Setup pre-commit and format files accordingly (Adrien Berchet - [#25](https://github.com/BlueBrain/diameter-synthesis/pull/25))

### Uncategorized Changes

- Simpler rediametrize (Alexis Arnaudon - [#26](https://github.com/BlueBrain/diameter-synthesis/pull/26))
- Fix docutils requirement as the new M2R2 release fixes it (Adrien Berchet - [#24](https://github.com/BlueBrain/diameter-synthesis/pull/24))
- simpler diametrizer (Alexis Arnaudon - [#22](https://github.com/BlueBrain/diameter-synthesis/pull/22))
- Updating copyright year (bbpgithubaudit - [#21](https://github.com/BlueBrain/diameter-synthesis/pull/21))
- Update DOI to the final article (Adrien Berchet - [#19](https://github.com/BlueBrain/diameter-synthesis/pull/19))
- fix ordering bug in assigning daughter diameters (Alexis Arnaudon - [#18](https://github.com/BlueBrain/diameter-synthesis/pull/18))

## [0.4.2](https://github.com/BlueBrain/diameter-synthesis/compare/0.4.1..0.4.2)

> 3 March 2022

### Uncategorized Changes

- Fix asymmetry of last children in apical diametrizer (Alexis Arnaudon - [#16](https://github.com/BlueBrain/diameter-synthesis/pull/16))

<!-- auto-changelog-above -->

## [0.4.1](https://github.com/BlueBrain/diameter-synthesis/compare/0.3.3..0.4.1)

> 23 February 2022

- Update the signature of build_diameters.build so it can be passed directly to NeuroTS (Adrien Berchet - [#15](https://github.com/BlueBrain/diameter-synthesis/pull/15))
- Add codespell in lint (Adrien Berchet - [#14](https://github.com/BlueBrain/diameter-synthesis/pull/14))
- Fix badges (Adrien Berchet - [#13](https://github.com/BlueBrain/diameter-synthesis/pull/13))

## [0.3.3](https://github.com/BlueBrain/diameter-synthesis/compare/0.3.2..0.3.3)

> 1 December 2021

- Fix RTD [#11](https://github.com/BlueBrain/diameter-synthesis/pull/11)

## [0.3.2](https://github.com/BlueBrain/diameter-synthesis/compare/0.3.1..0.3.2)

> 1 December 2021

- Setup RTD [#9](https://github.com/BlueBrain/diameter-synthesis/pull/9)

## [0.3.1](https://github.com/BlueBrain/diameter-synthesis/compare/0.3.0..0.3.1)

> 1 December 2021

- Add long description in setup.py [#7](https://github.com/BlueBrain/diameter-synthesis/pull/7)

## [0.3.0](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.6..0.3.0)

> 1 December 2021

- Fix CITATION.cff file [#6](https://github.com/BlueBrain/diameter-synthesis/pull/6)
- Change license and open the sources [#1](https://github.com/BlueBrain/diameter-synthesis/pull/1)
- Setup auto-changelog (Adrien Berchet - [f7c4e02](https://github.com/BlueBrain/diameter-synthesis/commit/f7c4e0295bf1de0ba4a352373c0f95e89c5c52eb))

## [0.2.6](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.5..0.2.6)

> 18 October 2021

- Migration to GitLab (Adrien Berchet - [9009eb6](https://github.com/BlueBrain/diameter-synthesis/commit/9009eb6c1cf245bb6df74d829a7e573b21be0e7d))
- Diameter smoother (arnaudon - [2345201](https://github.com/BlueBrain/diameter-synthesis/commit/2345201c49f492135c4fedc9d487ddff90996f14))

## [0.2.5](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.4..0.2.5)

> 30 August 2021

- Update NeuroM dependency to 3.0.0 (aleksei sanin - [b9c079c](https://github.com/BlueBrain/diameter-synthesis/commit/b9c079c7f72b624392a6a4d0e1a541b0e6f7bb31))

## [0.2.4](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.3..0.2.4)

> 26 May 2021

- Improve neurite type handling in build diameters and use random number generators (Adrien Berchet - [7037ecc](https://github.com/BlueBrain/diameter-synthesis/commit/7037ecc66e06b81bd7b3c7a0ec40fa97946e4fd2))
- No more use NeuroM.Population (Adrien Berchet - [df17bf8](https://github.com/BlueBrain/diameter-synthesis/commit/df17bf88774683ca7b1bf3ffe35c93305e84028b))
- Can use str or morphio neurite type to build diameters (Adrien Berchet - [29b7238](https://github.com/BlueBrain/diameter-synthesis/commit/29b7238b129b6af0012c2b25666d735ebb9000a8))

## [0.2.3](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.2..0.2.3)

> 4 May 2021

- Fix schema (Adrien Berchet - [fc0e63c](https://github.com/BlueBrain/diameter-synthesis/commit/fc0e63ca29e40ab826245f1e6066374922fcf921))

## [0.2.2](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.1..0.2.2)

> 30 April 2021

- Install missing JSON files (Adrien Berchet - [bdb1145](https://github.com/BlueBrain/diameter-synthesis/commit/bdb1145f4cda483d18c90da8dc45cc50ce35b672))

## [0.2.1](https://github.com/BlueBrain/diameter-synthesis/compare/0.2.0..0.2.1)

> 30 April 2021

- Fix schema and improve tests (Adrien Berchet - [b0df7fd](https://github.com/BlueBrain/diameter-synthesis/commit/b0df7fdfedba5b2e6e4a036e54c1e9d47059bc0a))

## [0.2.0](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.13..0.2.0)

> 29 April 2021

- Remove asymmetry_threshold (Adrien Berchet - [46716c1](https://github.com/BlueBrain/diameter-synthesis/commit/46716c101dfca697dea1b74a2b6da0e35d9cf3ae))
- Update NeuroM requirement (Adrien Berchet - [a42f139](https://github.com/BlueBrain/diameter-synthesis/commit/a42f13961cafc3ef088b2d12ce4af4e34bbc6005))

## [0.1.13](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.12..0.1.13)

> 29 April 2021

- Add JSON schemas and validation functions for distributions and parameters (Adrien Berchet - [f62f7ef](https://github.com/BlueBrain/diameter-synthesis/commit/f62f7efd2cfbd3bc30d234bb97e5a74602110fd7))
- Add documentation (Adrien Berchet - [b1c4790](https://github.com/BlueBrain/diameter-synthesis/commit/b1c4790f00fa45b0f4eec48588662196df9dd33b))
- Add __version__ attribute (Adrien Berchet - [5ace372](https://github.com/BlueBrain/diameter-synthesis/commit/5ace3720fec710a85632dd8060e4812b16bded15))

## [0.1.12](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.11..0.1.12)

> 20 April 2021

- Upgrade to neurom2.0 (arnaudon - [ec75713](https://github.com/BlueBrain/diameter-synthesis/commit/ec757135a6ebe507946502668419c3786aa328a7))
- Release (arnaudon - [2c590b2](https://github.com/BlueBrain/diameter-synthesis/commit/2c590b21614f4f8ad322d4c94a3b61c31ac666f4))

## [0.1.11](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.10..0.1.11)

> 18 March 2021

- Seaborn optional (arnaudon - [b922451](https://github.com/BlueBrain/diameter-synthesis/commit/b92245126ce7482975aae683230a9f141ccc93a8))
- Trailing (arnaudon - [486c6c2](https://github.com/BlueBrain/diameter-synthesis/commit/486c6c21445660954c0ea71f15f4fcb98675a284))
- Bump version for real (arnaudon - [8660830](https://github.com/BlueBrain/diameter-synthesis/commit/8660830fd8e5435a6175304af05f1b0bc706a286))
- Bump version (arnaudon - [bbf2f48](https://github.com/BlueBrain/diameter-synthesis/commit/bbf2f48c219c7d9b177d009792e0f0796cd44b66))

## [0.1.10](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.9..0.1.10)

> 15 March 2021

- Add axon diametrizer (arnaudon - [f35b5a5](https://github.com/BlueBrain/diameter-synthesis/commit/f35b5a574959370e66cd85640766c07683ccf86e))
- Release (arnaudon - [ce3d59d](https://github.com/BlueBrain/diameter-synthesis/commit/ce3d59d2274a29c8ffba7067d1ae6588578aa917))

## [0.1.9](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.8..0.1.9)

> 22 January 2021

- Fix tests with scipy&gt;=1.6 (Adrien Berchet - [a554751](https://github.com/BlueBrain/diameter-synthesis/commit/a55475175b4841a2a7dd6c10704eb23bb450461d))
- Remove h5py requirement (Adrien Berchet - [27e5df4](https://github.com/BlueBrain/diameter-synthesis/commit/27e5df4b53cc68cea4a03fbd8933396b9c808239))

## [0.1.8](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.7..0.1.8)

> 14 January 2021

- Improve test coverage and minor fixes (Adrien Berchet - [10f0b78](https://github.com/BlueBrain/diameter-synthesis/commit/10f0b788bc0ac651988928734962906be32e721c))
- Use apical section IDs to compute asymmetric diameters (Adrien Berchet - [c6eb579](https://github.com/BlueBrain/diameter-synthesis/commit/c6eb579906f7f44e606cd9e9bca6d5938a10ca81))

## [0.1.7](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.6..0.1.7)

> 13 October 2020

- Improved violin plots (arnaudon - [a67994c](https://github.com/BlueBrain/diameter-synthesis/commit/a67994c53f385f5cf096840676e8df3e2dfd76a4))
- Cumulative plot update (arnaudon - [b9b83cd](https://github.com/BlueBrain/diameter-synthesis/commit/b9b83cdebb3dd803b44f8578e6558378fe90353f))
- Small updates (arnaudon - [96fbc0d](https://github.com/BlueBrain/diameter-synthesis/commit/96fbc0d23e31d282956cfd444278de1bba8f663b))
- Remove deprecation in mean diameters (arnaudon - [da31e07](https://github.com/BlueBrain/diameter-synthesis/commit/da31e0702f19f47b4748c2765f66a60ada55740d))
- Fix small lint (arnaudon - [6aba453](https://github.com/BlueBrain/diameter-synthesis/commit/6aba453b4d7a9d0d4ad3dadb47590d1a9c0f03ec))
- Bump version (arnaudon - [8c4214f](https://github.com/BlueBrain/diameter-synthesis/commit/8c4214f8574d798c9b4309bd35b104b381795cf8))
- Remove black check (arnaudon - [7a9f4b6](https://github.com/BlueBrain/diameter-synthesis/commit/7a9f4b667cad9e6bdba67d34c7c6272c060e3d2c))
- Tox py3 (arnaudon - [0eca2bb](https://github.com/BlueBrain/diameter-synthesis/commit/0eca2bb2af10c1af19000c86b8f35023f7c23204))

## [0.1.6](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.4..0.1.6)

> 6 April 2020

- Astrocyte model (arnaudon - [23c39b8](https://github.com/BlueBrain/diameter-synthesis/commit/23c39b86acb99ab0291d19efb2f45493ded589e9))
- Typo fix (arnaudon - [85589de](https://github.com/BlueBrain/diameter-synthesis/commit/85589deefb4a7e4cc535d5da3ce730a68682e2bd))
- Bump version (arnaudon - [e080cc6](https://github.com/BlueBrain/diameter-synthesis/commit/e080cc673d11718647e371d1b1159a2c4947eb8f))

## [0.1.4](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.2..0.1.4)

> 31 March 2020

- Updated docstring (Alexis Arnaudon - [79b58dc](https://github.com/BlueBrain/diameter-synthesis/commit/79b58dcbe61274d595491fc5aa38d7bb864a1fd0))
- Unleash your reviews, v2 (arnaudon - [0153dc6](https://github.com/BlueBrain/diameter-synthesis/commit/0153dc68af1f334a685a0ce68f5b5a5d4df6ca66))
- Updated docstring (Alexis Arnaudon - [75620d9](https://github.com/BlueBrain/diameter-synthesis/commit/75620d90e76eeebcd41353d335cddcf6432afae3))
- Bump version (arnaudon - [2af25aa](https://github.com/BlueBrain/diameter-synthesis/commit/2af25aa2a7a6f92f244a3521d14cc17971170685))

## [0.1.2](https://github.com/BlueBrain/diameter-synthesis/compare/0.1.1..0.1.2)

> 27 March 2020

- Small modifs for region-grower compat. (arnaudon - [3702dcb](https://github.com/BlueBrain/diameter-synthesis/commit/3702dcbcc5f06ffc8675a502d3407bf1db658bbe))
- 0.1.2 release (arnaudon - [a62b6de](https://github.com/BlueBrain/diameter-synthesis/commit/a62b6deeb7f040144649a6310e10c501b443f044))

## [0.1.1](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.15..0.1.1)

> 27 March 2020

- Refactor + build with morphio + neurom[master] (Alexis Arnaudon - [ff791aa](https://github.com/BlueBrain/diameter-synthesis/commit/ff791aa95b910dcbb5661c1f9e14889514a9c73f))
- Basic build test (arnaudon - [7052b0a](https://github.com/BlueBrain/diameter-synthesis/commit/7052b0a93365d4435282b668499683d19ee304dd))
- Pathlib + small removed types/io (Alexis Arnaudon - [1a8749a](https://github.com/BlueBrain/diameter-synthesis/commit/1a8749a6c8b577d1db357f127ae4a7cc72742260))
- Better taper function (Alexis Arnaudon - [bf7046c](https://github.com/BlueBrain/diameter-synthesis/commit/bf7046c9ce8af5f5f1266dd1c52c30c05424295c))
- Tox update (arnaudon - [03227dd](https://github.com/BlueBrain/diameter-synthesis/commit/03227dd0486d9c882279e9544d186f583624d3ad))
- 0.1.1 release (arnaudon - [b09016c](https://github.com/BlueBrain/diameter-synthesis/commit/b09016c9afe26add59d359bd22ef4eb9631204db))
- New version (arnaudon - [ecd91d5](https://github.com/BlueBrain/diameter-synthesis/commit/ecd91d5eae6192384487f3c6bf41517380b3bde0))

## [0.0.15](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.13..0.0.15)

> 12 March 2020

- Speed up with caching (Alexis Arnaudon - [ba116dd](https://github.com/BlueBrain/diameter-synthesis/commit/ba116ddd3f08f8617e4e827fbd55b57036d19def))
- Exception + update example (arnaudon - [ef46fd0](https://github.com/BlueBrain/diameter-synthesis/commit/ef46fd0250bcad22e12d5524ebf36b8d75504220))
- Small updates (arnaudon - [02837f9](https://github.com/BlueBrain/diameter-synthesis/commit/02837f9f4b73fd00ccdda2038f56542fbe6ce566))
- Remove forbidden + plot diff (arnaudon - [a948129](https://github.com/BlueBrain/diameter-synthesis/commit/a9481292246010c12ab4569f3a7e5d678fbc085a))
- Small bug (arnaudon - [fab09ac](https://github.com/BlueBrain/diameter-synthesis/commit/fab09ac987277f06b8cf04f0b1420452f8fc8049))
- Plot update (arnaudon - [eaba651](https://github.com/BlueBrain/diameter-synthesis/commit/eaba651d97892ee91c9cce1c2a121b58e8b3588e))
- Small update for bb5 (arnaudon - [7772283](https://github.com/BlueBrain/diameter-synthesis/commit/777228379d0a167995673e8643653794cdac7543))
- Build accepts morphio object (arnaudon - [fddf09d](https://github.com/BlueBrain/diameter-synthesis/commit/fddf09d793217cc92e20b50ba4b262e6f4f46130))
- Small changes (arnaudon - [7e2f070](https://github.com/BlueBrain/diameter-synthesis/commit/7e2f0706abd5819645f543a48927d1deeabbf759))
- Add exception.py file (arnaudon - [50cd70f](https://github.com/BlueBrain/diameter-synthesis/commit/50cd70fd8555c87bfe9c4f0b34bcd88619605a64))
- Bug in pool.map (Alexis Arnaudon - [ba99578](https://github.com/BlueBrain/diameter-synthesis/commit/ba995789335547c460e70772282beed3b3707a21))
- New release (arnaudon - [cf336da](https://github.com/BlueBrain/diameter-synthesis/commit/cf336da3aec1ae8d3ddca34bb1d8fca900a4798d))

## [0.0.13](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.11..0.0.13)

> 14 February 2020

- Plotting + neurite in build (Alexis Arnaudon - [73ff47e](https://github.com/BlueBrain/diameter-synthesis/commit/73ff47e096b16e3561cec1991148bc0f65e21c0e))
- New version (Alexis Arnaudon - [b3d5aa4](https://github.com/BlueBrain/diameter-synthesis/commit/b3d5aa40b7d5b8f45204401c35f5f891a7c69769))

## [0.0.11](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.9..0.0.11)

> 13 February 2020

- Validation + M1-&gt; generic (Alexis Arnaudon - [d5dc3a1](https://github.com/BlueBrain/diameter-synthesis/commit/d5dc3a1b9501393d45ea8e9c6e08531f75360f16))
- Move plotting import (Alexis Arnaudon - [ba03d96](https://github.com/BlueBrain/diameter-synthesis/commit/ba03d9662eb3e3482557353fb3ce7c18c877388c))
- New release (Alexis Arnaudon - [fa64106](https://github.com/BlueBrain/diameter-synthesis/commit/fa6410658e85be74425def323b11da2cab7df731))
- Invalid value warning disabled (Alexis Arnaudon - [5a8cdc5](https://github.com/BlueBrain/diameter-synthesis/commit/5a8cdc52e0b1ecb7c9b77d38e35ec3e1206fe4c9))
- Disable warning divide (Alexis Arnaudon - [e76f524](https://github.com/BlueBrain/diameter-synthesis/commit/e76f5243e6f4a59a2e80f196d51d67b21dfc6964))

## [0.0.9](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.7..0.0.9)

> 4 February 2020

- Validation/analysis plot app merged (Alexis Arnaudon - [f22a5ac](https://github.com/BlueBrain/diameter-synthesis/commit/f22a5ac5f83848427535a9a07a594c6ea7f20554))
- New release (Alexis Arnaudon - [a45a3b7](https://github.com/BlueBrain/diameter-synthesis/commit/a45a3b7c6443b1c6f44ba6d40248d355f028d377))
- Merge "worker class + logging" (Alexis Arnaudon - [3bbd8e3](https://github.com/BlueBrain/diameter-synthesis/commit/3bbd8e32fff7c3c1f2e5b0ad27da7b395f8d336b))
- Worker class + logging (Alexis Arnaudon - [b0bf420](https://github.com/BlueBrain/diameter-synthesis/commit/b0bf4208b5b70da6ea2ca290fb2e9cd521dad5da))
- Small updated for TNS (Alexis Arnaudon - [e1c0cff](https://github.com/BlueBrain/diameter-synthesis/commit/e1c0cff49f8d426b3748930a431c65e87af7bd14))

## [0.0.7](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.5..0.0.7)

> 31 January 2020

- Small update to fit tns code (Alexis Arnaudon - [0b28a33](https://github.com/BlueBrain/diameter-synthesis/commit/0b28a33fa2b2cf8302ca5b507bfa7d28a30b213f))
- Matplotlib Agg (Alexis Arnaudon - [5c42959](https://github.com/BlueBrain/diameter-synthesis/commit/5c4295965c44ce1f95802d1944278e4262604d45))
- New release (Alexis Arnaudon - [139d874](https://github.com/BlueBrain/diameter-synthesis/commit/139d8741349df9490b29e7ebdf3f3815a47334dc))
- New release (Alexis Arnaudon - [4b68ff6](https://github.com/BlueBrain/diameter-synthesis/commit/4b68ff690d630fe4ffee2126055c6b5f2c48fb8a))

## [0.0.5](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.4..0.0.5)

> 27 January 2020

- List again (Alexis Arnaudon - [f9a7c6c](https://github.com/BlueBrain/diameter-synthesis/commit/f9a7c6ce3e907f783188b544db0447c99af15f60))
- Small bug (Alexis Arnaudon - [bad6069](https://github.com/BlueBrain/diameter-synthesis/commit/bad6069e011fc752a77375523785450f695616e1))
- New release (Alexis Arnaudon - [2677c28](https://github.com/BlueBrain/diameter-synthesis/commit/2677c28d028e58ed45b3801a65ff4ad02cb94b1d))
- New release (Alexis Arnaudon - [3f0be76](https://github.com/BlueBrain/diameter-synthesis/commit/3f0be76aaa7c8221bded41fd2987d6d05a558cc9))

## [0.0.4](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.3..0.0.4)

> 27 January 2020

- List thing (Alexis Arnaudon - [87f1591](https://github.com/BlueBrain/diameter-synthesis/commit/87f1591ef90f81af5809e89e541fff2f44ab17d5))
- New release (Alexis Arnaudon - [431fade](https://github.com/BlueBrain/diameter-synthesis/commit/431faded41f3122f5f08f4138d4f32590d97c922))

## [0.0.3](https://github.com/BlueBrain/diameter-synthesis/compare/0.0.2..0.0.3)

> 27 January 2020

- Substitution + exception from morphio (Alexis Arnaudon - [0d4f729](https://github.com/BlueBrain/diameter-synthesis/commit/0d4f729d2c1eaf2b3b90c7794b113ba3873a350f))
- New release (Alexis Arnaudon - [c558d67](https://github.com/BlueBrain/diameter-synthesis/commit/c558d67396571a947c3ee9ad0514f5c1f409bbde))

## 0.0.2

> 27 January 2020

- Code cleaning (Alexis Arnaudon - [262c6af](https://github.com/BlueBrain/diameter-synthesis/commit/262c6afcf3a51cf4c5b5ffd01ea8a6f3ced6c391))
- Simplfied build_diameter (Alexis Arnaudon - [a2d887a](https://github.com/BlueBrain/diameter-synthesis/commit/a2d887a0c7382ab0d82c941f1458fb348984c473))
- Generating model to test with diameter-check (arnaudon - [6920a44](https://github.com/BlueBrain/diameter-synthesis/commit/6920a44a7e8502b7e21b92f3f031910d38d5d6d5))
-  many updates (arnaudon - [9e52c34](https://github.com/BlueBrain/diameter-synthesis/commit/9e52c34d3e7884cd467625eef4aa225b0753cbba))
- Morphio -&gt; neurom + file reshaping (arnaudon - [0673b93](https://github.com/BlueBrain/diameter-synthesis/commit/0673b935a588f0f1317a062d6ac83152ab1091cd))
- First generic model for fitting distributions (arnaudon - [ede3b08](https://github.com/BlueBrain/diameter-synthesis/commit/ede3b085c4f4bb00f5a6a3c1b8384441b6735f3d))
- Many updates (arnaudon - [2fb3ad9](https://github.com/BlueBrain/diameter-synthesis/commit/2fb3ad9dfa0408b0f3e4543917eb59f9cf81d2fe))
- Tmp state (Alexis Arnaudon - [72109b6](https://github.com/BlueBrain/diameter-synthesis/commit/72109b649cdd16c262d9c7595646b6023fd4a7db))
- Many updates (arnaudon - [8541d6e](https://github.com/BlueBrain/diameter-synthesis/commit/8541d6ed3891b8d461c6f032d387631a4a4d8555))
- Better models + plot diff diameters (arnaudon - [67dc45d](https://github.com/BlueBrain/diameter-synthesis/commit/67dc45d92a17e42606e647953fa7892a96a8f78a))
- Better integration of sequential fits (Alexis Arnaudon - [075cd44](https://github.com/BlueBrain/diameter-synthesis/commit/075cd44d5299c830f30b00c4a543ba33c1736f13))
- Minor modifs (Alexis Arnaudon - [6be2f2f](https://github.com/BlueBrain/diameter-synthesis/commit/6be2f2f7b16b59854846d1089e163ae583bc76e4))
- Small bug in reading neurons from folder (Alexis Arnaudon - [8fcabed](https://github.com/BlueBrain/diameter-synthesis/commit/8fcabed21b4bf027b4e86b9e6d668d7ded305cbd))
- Generation of diameters, first commit (arnaudon - [60195ec](https://github.com/BlueBrain/diameter-synthesis/commit/60195ecd4abd8a33b6807c76d0278699660f9a5f))
- Add cumulative plot wrt a metric and create respective app (Eleftherios Zisis - [c5aae65](https://github.com/BlueBrain/diameter-synthesis/commit/c5aae659bee76d1799a66ccf6e93b72125db56a8))
- Apical sort of works + many small things (Alexis Arnaudon - [b1e07b2](https://github.com/BlueBrain/diameter-synthesis/commit/b1e07b2554889e4f3f67499ac1e913b094c2942c))
- Taper + small improvements (arnaudon - [fd0beae](https://github.com/BlueBrain/diameter-synthesis/commit/fd0beae9eb164af6ef032f40c095d10df1ea9c87))
- Wip, move out of bb5 (arnaudon - [2b7d2e7](https://github.com/BlueBrain/diameter-synthesis/commit/2b7d2e775e09b82743db625f998dcd07d7163c79))
- Impedance scripts (Alexis Arnaudon - [b3fc2c8](https://github.com/BlueBrain/diameter-synthesis/commit/b3fc2c8a387f585bc0618afbc400ead1ec6abe78))
- Apical stuff + updated analysis plot (Alexis Arnaudon - [eea1d93](https://github.com/BlueBrain/diameter-synthesis/commit/eea1d93aead69264711f56b402224016f14f8b44))
- Astrocytes + small cleanup (arnaudon - [e3e37e3](https://github.com/BlueBrain/diameter-synthesis/commit/e3e37e38c90d42db74ffdb6c9f8c7a79b508d374))
- Several minor updates (Alexis Arnaudon - [97f48ae](https://github.com/BlueBrain/diameter-synthesis/commit/97f48aef2c177d96f0021842b44621c38bee8f0a))
- Several updates to handle small datasets (arnaudon - [e6b97be](https://github.com/BlueBrain/diameter-synthesis/commit/e6b97be9532e904cb49b70efa34613dd17cb7f4a))
- Separate utils from io and type mappings (Eleftherios Zisis - [137652b](https://github.com/BlueBrain/diameter-synthesis/commit/137652bb5e7afaa078e9454d8221a30e04595266))
- Neuron name + spaces (Alexis Arnaudon - [2fdda0e](https://github.com/BlueBrain/diameter-synthesis/commit/2fdda0e8ed5d55812c20d417710d2e7eba958ee6))
- Add relative error plot for cumulative distributions (Eleftherios Zisis - [eada493](https://github.com/BlueBrain/diameter-synthesis/commit/eada493e18219910ca66868787f7c8a0cf055b54))
- Latest updates (arnaudon - [7577d3b](https://github.com/BlueBrain/diameter-synthesis/commit/7577d3b3a36c61cf72acf4b080d990ae3466a189))
- Small updates (arnaudon - [879ff72](https://github.com/BlueBrain/diameter-synthesis/commit/879ff7210f4d235301c00e4572b188673472daba))
- Bb5 latest version (arnaudon - [8a3c94f](https://github.com/BlueBrain/diameter-synthesis/commit/8a3c94f9cebbf6b0a9f33f53389443dbee5dba7d))
- Update to fit region_grower (Alexis Arnaudon - [454b603](https://github.com/BlueBrain/diameter-synthesis/commit/454b6034d61cf4619e492e8ff142661e29d24bf9))
- Can handle folder without neuronDB.xml file (arnaudon - [82ca224](https://github.com/BlueBrain/diameter-synthesis/commit/82ca2243e4b6ecaec3688adadc90466a2da0fede))
- Morphometrics script (arnaudon - [6a906e7](https://github.com/BlueBrain/diameter-synthesis/commit/6a906e763d55ff1285fadea911f947bd807a4a1d))
- Update for build_diameter and sequential (Alexis Arnaudon - [a07a1a0](https://github.com/BlueBrain/diameter-synthesis/commit/a07a1a00aa569e63b88cb2a9c02e559eab7a689d))
- Astrocyte example (Alexis Arnaudon - [9f67d80](https://github.com/BlueBrain/diameter-synthesis/commit/9f67d80be24547d7633281d317441cb453e06e97))
- Test+small bug (Alexis Arnaudon - [abe623f](https://github.com/BlueBrain/diameter-synthesis/commit/abe623f60f5ae327fa3d4fa9e35089e1f38695f8))
- Small updates (arnaudon - [d5673b6](https://github.com/BlueBrain/diameter-synthesis/commit/d5673b6a3156940d3577d9139fdaa95caf46b5db))
- Small things (Alexis Arnaudon - [2a90b13](https://github.com/BlueBrain/diameter-synthesis/commit/2a90b13a186b248165923ea36a2c1f940ac8117b))
- Small update for convergence (Alexis Arnaudon - [2fd5534](https://github.com/BlueBrain/diameter-synthesis/commit/2fd55343839ac69703cdd3c8b5a8d015ff0dd255))
- Trunk taper (not working well!) (alexis arnaudon - [6575868](https://github.com/BlueBrain/diameter-synthesis/commit/6575868c4e800954c0c97a56d5d4c118bd714d33))
- Git mistake (arnaudon - [9b67cd4](https://github.com/BlueBrain/diameter-synthesis/commit/9b67cd4e2a327a4afdd800a6c9e98df8c9fcc0a6))
- Build_diameter fix with new sequential code (Alexis Arnaudon - [aaa3716](https://github.com/BlueBrain/diameter-synthesis/commit/aaa3716d0e78c1dbfdb2e05e6857998fc1943b61))
- Trunk diameter bug (Alexis Arnaudon - [2e6882a](https://github.com/BlueBrain/diameter-synthesis/commit/2e6882aed330c3e6f6d197151a493c53bb1d1a29))
- Update click to access functions (Alexis Arnaudon - [2c49735](https://github.com/BlueBrain/diameter-synthesis/commit/2c4973504e560bf28caf549380e984f51a7fcd69))
- Cli file (Alexis Arnaudon - [64ee2c0](https://github.com/BlueBrain/diameter-synthesis/commit/64ee2c0d5c49ddd314b28302c61f017001400a7a))
- Test-&gt;example (arnaudon - [d0aefbd](https://github.com/BlueBrain/diameter-synthesis/commit/d0aefbd9bfc80d6b7c43cc6225e5b42a5545c69d))
- Small update in morphometrics (arnaudon - [eee031a](https://github.com/BlueBrain/diameter-synthesis/commit/eee031a5372a70cf6a993b4e23d2ed5181b40d4d))
- Gitignore update (Alexis Arnaudon - [2141a64](https://github.com/BlueBrain/diameter-synthesis/commit/2141a64a89226097355b4586548cf3cb75f77878))
- First release (Alexis Arnaudon - [20ebaef](https://github.com/BlueBrain/diameter-synthesis/commit/20ebaef129a870085e93d5f559e7c1741324acb5))
- Apical in test (Alexis Arnaudon - [d6d2b85](https://github.com/BlueBrain/diameter-synthesis/commit/d6d2b8598a094635d3c3e4bbe2849f11073dd6df))
- Small bug (Alexis Arnaudon - [15930a9](https://github.com/BlueBrain/diameter-synthesis/commit/15930a97ca645837ef82d141240b56045c7e15c9))
- Initial empty repository (Dries Verachtert - [c7ad947](https://github.com/BlueBrain/diameter-synthesis/commit/c7ad94702891fc50709af5b90427f7a977eb8309))
