
# BlueSMS SDK
This is a python SDK for the BlueSMS API. It can be added to your current python-based application so as to interact with the BlueSMS Uganda API in a much simpler way.

## Why we created the BlueSMS SDK
We began using BlueSMS in many of our applications and were simply tired of writing code to send SMSes in every Python project we created. So we decided to create a python package that would make it easier for us to send SMSes in our projects. 

## Installation
```bash
pip install bluesms
``` 

## Usage
```python
from bluesms import SMS 

# initialise the SMS class
sms = SMS()

# send the SMS 
try: 
    sending = sms.send(user="user@example.com", password="password", reciever="0777xxxxxx", sender="sender", message="message")

    print("The SMS sent", sending.text)

except Exception as e:
    print("Error sending SMS:", e)
```
## Development Setup

Clone the repository by running the following command in your terminal:
```
git clone https://github.com/mwanjajoel/bluesms.git
```

We use Pipenv to manage our dependencies. To install pipenv, run the following command:
```
pip install pipenv
```

Activate the virtual environment by running the following command in your terminal:
```
pipenv shell
```

Install the dependencies by running the following command in your terminal:
```
pipenv install
```

## Run tests
```
TBD

```
## Code Formatting using Black
```
black momo
```

## How to submit an issue

Please follow our [Bug Report Guide](ISSUE_TEMPLATE/BUG_REPORT.md) on how to submit your issue. 

## How to request for a new feature 

Please follow our [Feature Request Guide](ISSUE_TEMPLATE/FEATURE_REQUEST.md) on how to submit a feature request

## Code of Conduct 
We follow a strict code of conduct and you can read it [Here](CODE_OF_CONDUCT.md)

## Credits

BlueSMS SDK was designed and built by Mwanja Joel. It is licensed under the MIT license; for the full license please see the [LICENSE](LICENSE) file. 

Please see the [AUTHORS](AUTHORS) file for the full list of contributors. 

If you find BlueSMS SDK useful and want to reach out, find me on Twitter: [@mrjoelmwanja](https://twitter.com/mrjoelmwanja).




